<?php
/**
 *
 * @link              https://iben.pro
 * @since             1.0.0
 * @package           Iben_Woo_Elta_Courier
 *
 * @wordpress-plugin
 * Plugin Name:       WooCommerce ELTA Courier Voucher & Label
 * Plugin URI:        https://iben.pro
 * Description:       Generate ELTA courier vouchers, generate and print PDF, delivery status, tracing check, ELTA station checking and more.
 * Version:           4.2.0
 * Author:            iBen
 * Author URI:        https://iben.pro
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       iben-woo-elta-courier
 * Domain Path:       /languages
 * WC requires at least: 5.0.0
 * WC tested up to: 10.2.0
 * Requires Plugins: woocommerce
 * Requires PHP: 7.4
 */

if ( ! defined( 'WPINC' ) ) {
	wp_die();
}


define( 'IBEN_WOO_ELTA_COURIER_VERSION', '4.2.0' );

define( 'IBEN_WOO_ELTA_ROOT_DIR', plugin_dir_path( __FILE__ ) );
define( 'IBEN_WOO_ELTA_BASENAME', plugin_basename(__FILE__) );
define( 'IBEN_WOO_ELTA_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'IBEN_WOO_ELTA_PLUGIN_FILE', __FILE__ );

$upload = wp_upload_dir();
$upload_dir = $upload['basedir'];
$upload_dir = $upload_dir . '/iben_elta_vouchers/';
define( 'IBEN_WOO_ELTA_UPLOAD_FOLDER', $upload_dir );



$url = get_site_url(null, '/wp-content/uploads/iben_elta_vouchers/');
define( 'IBEN_WOO_ELTA_UPLOAD_VOUCHER_URL', $url );

/**
 * The code that runs during plugin activation.
 */
function iben_activate_iben_woo_elta_courier() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-iben-woo-elta-courier-activator.php';
	$activator = new Iben_Woo_Elta_Courier_Activator();
	$activator->activate();
}

/**
 * The code that runs during plugin deactivation.
 */
function iben_deactivate_iben_woo_elta_courier() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-iben-woo-elta-courier-deactivator.php';
	$deactivator = new Iben_Woo_Elta_Courier_Deactivator();
	$deactivator->deactivate();
}

register_activation_hook( __FILE__, 'iben_activate_iben_woo_elta_courier' );
register_deactivation_hook( __FILE__, 'iben_deactivate_iben_woo_elta_courier' );


// Begins execution of the plugin. internationalization ans loader
require_once plugin_dir_path( __FILE__ ) . 'includes/class-iben-woo-elta-courier.php';
Iben_Woo_Elta_Courier::getInstance()->run();


require_once plugin_dir_path( __FILE__ ) . 'includes/class-iben-woo-elta-courier-woo.php';	

add_action(
	'init',
	array ( Iben_Woo_Elta_Courier_Woo::getInstance(), 'run' )
);


add_filter( 'cron_schedules', 'iben_elta_register_cron_internal' );
function iben_elta_register_cron_internal( $schedules ) {
	$schedules[ 'iben-elta-2-minutes' ] = array( 'interval' => 2 * MINUTE_IN_SECONDS, 'display' => esc_html__( 'Every 2 minutes', 'iben-woo-elta-courier' ) );
	$schedules[ 'iben-elta-5-minutes' ] = array( 'interval' => 5 * MINUTE_IN_SECONDS, 'display' => esc_html__( 'Every 5 minutes', 'iben-woo-elta-courier' ) );
	$schedules[ 'iben-elta-15-minutes' ] = array( 'interval' => 15 * MINUTE_IN_SECONDS, 'display' => esc_html__( 'Every 15 minutes', 'iben-woo-elta-courier' ) );
	$schedules[ 'iben-elta-30-minutes' ] = array( 'interval' => 30 * MINUTE_IN_SECONDS, 'display' => esc_html__( 'Every 30 minutes', 'iben-woo-elta-courier' ) );
	$schedules[ 'iben-elta-2-hours' ] = array( 'interval' => 120 * MINUTE_IN_SECONDS, 'display' => esc_html__( 'Every 2 hours', 'iben-woo-elta-courier' ) );
	$schedules[ 'iben-elta-4-hours' ] = array( 'interval' => 240 * MINUTE_IN_SECONDS, 'display' => esc_html__( 'Every 4 hours', 'iben-woo-elta-courier' ) );
	$schedules[ 'iben-elta-3-days' ] = array( 'interval' => 4320 * MINUTE_IN_SECONDS, 'display' => esc_html__( 'Every 3 days', 'iben-woo-elta-courier' ) );
	$schedules[ 'iben-elta-1-week' ] = array( 'interval' => 10080 * MINUTE_IN_SECONDS, 'display' => esc_html__( 'Every 1 week', 'iben-woo-elta-courier' ) );

	return $schedules;
}

add_action( 'before_woocommerce_init', function() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__ , true );
	}
} );