<?php
if ( ! defined( 'WPINC' ) ) {
	wp_die();
}

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://iben.pro
 * @since      1.0.0
 *
 * @package    Iben_Woo_Elta_Courier
 * @subpackage Iben_Woo_Elta_Courier/admin/partials
 */

use Automattic\WooCommerce\Utilities\OrderUtil;
use Automattic\WooCommerce\Internal\DataStores\Orders\CustomOrdersTableController;

function iben_woo_elta_settings_page_create() {
	
	add_submenu_page('options-general.php', esc_html__('Settings ELTA', 'iben-woo-elta-courier'), esc_html__('Settings ELTA', 'iben-woo-elta-courier'), apply_filters( 'iben_elta_settings_cap', 'edit_others_posts' ), 'iben_woo_elta_courier', 'iben_woo_elta_settings_page_handler');	
		add_submenu_page('iben_woo_elta_courier', esc_html__('Import ELTA addresses', 'iben-woo-elta-courier'), esc_html__('Import ELTA addresses', 'iben-woo-elta-courier'), apply_filters( 'iben_elta_import_contacts_cap', 'edit_others_posts' ), 'iben_woo_elta_import_contacts', 'iben_woo_elta_import_page_handler');	
		add_submenu_page('iben_woo_elta_courier', esc_html__('ELTA addresses', 'iben-woo-elta-courier'), esc_html__('ELTA addresses', 'iben-woo-elta-courier'), apply_filters( 'iben_elta_contacts_cap', 'edit_others_posts' ), 'iben_woo_elta_contacts', 'iben_woo_elta_contacts_page_handler');	
		add_submenu_page('iben_woo_elta_contacts', esc_html__('Edit contact', 'iben-woo-elta-courier'), esc_html__('Edit contact', 'iben-woo-elta-courier'), apply_filters( 'iben_elta_edit_contacts_cap', 'edit_others_posts' ), 'iben_woo_elta_edit_contact', 'iben_woo_elta_edit_contact_handler');
		
		add_submenu_page('iben_woo_elta_courier', esc_html__('License registration', 'iben-woo-elta-courier'), esc_html__('License registration', 'iben-woo-elta-courier'), apply_filters( 'iben_elta_contacts_cap', 'edit_others_posts' ), 'iben_woo_elta_license', 'iben_woo_elta_license_handler');

		$iben_elta_screen_settings = add_submenu_page('woocommerce', esc_html__('ELTA Vouchers', 'iben-woo-elta-courier'), esc_html__('ELTA Vouchers', 'iben-woo-elta-courier'), apply_filters( 'iben_elta_vouchers_cap', 'edit_others_posts' ), 'iben_woo_elta_vouchers', 'iben_woo_elta_vouchers_page_handler');
	
	/**
  	*
 	* @since     1.6.0
 	*/
	add_action("load-$iben_elta_screen_settings", "iben_elta_screen_options");


}	
add_action( 'admin_menu', 'iben_woo_elta_settings_page_create' );


/**
  *
 * @since     1.6.0
 */
function iben_elta_screen_options() {
  
	$args = array(
		'label' => esc_html__('Vouchers per page', 'iben-woo-elta-courier'),
		'default' => 30,
		'option' => 'iben_elta_vouchers_per_page'
	);
	add_screen_option( 'per_page', $args );
}


 /**
  *
 * @since     1.6.0
 */
function iben_elta_screen_save_option($status, $option, $value) {
 
    if ( 'iben_elta_vouchers_per_page' == $option ) return $value;
 
    return $status;
 
}
add_filter('set-screen-option', 'iben_elta_screen_save_option', 10, 3);


/**
  *
 * @since     2.0.0
*/

function iben_woo_elta_license_handler() {
	?>
	<div class="iben_elta_woo_settings wrap">
	
		<div id="icon-themes" class="icon32"></div>
			<h2><?php esc_html_e( 'License registration', 'iben-woo-elta-courier' ); ?></h2>
			<?php 

				$active_tab = isset( $_GET[ 'page' ]) ?  $_GET[ 'page' ] : 'iben_woo_elta_courier';

				if( $active_tab == 'iben_woo_elta_license' ) {
					$active_tab = 'license';
				}else if( $active_tab == 'iben_woo_elta_courier' ) {
					$active_tab = 'main_settings';
				}

			?>
			<h2 class="nav-tab-wrapper">
				<a href="?page=iben_woo_elta_courier" class="nav-tab <?php echo $active_tab == 'main_settings' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e( 'Main Settings', 'iben-woo-elta-courier' ); ?></a>            
				<a href="<?php echo admin_url( 'admin.php?page=iben_woo_elta_license' )  ?>" class="nav-tab <?php echo $active_tab == 'license' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e( 'License registration', 'iben-woo-elta-courier' ); ?></a>
			</h2>

            <?php 
              do_action('iben_elta_license_page');
            ?>

	</div>
<?php
}



/**
  *
 * @since     1.3.0
 */
function iben_woo_elta_import_page_handler(){

	if ( ! current_user_can( 'edit_shop_orders' ) ) {
		wp_die();
	}


    global $wpdb;

    // Table name
    $tablename = $wpdb->prefix . apply_filters('iben_elta_contacts_table_name', 'iben_elta_contacts');

    // Import CSV
    if(isset($_POST['iben_elta_address_import'])){

    // File extension
    $extension = pathinfo($_FILES['import_file']['name'], PATHINFO_EXTENSION);

    // If file extension is 'csv'
    if(!empty($_FILES['import_file']['name']) && $extension == 'csv'){

        $totalInserted = 0;
		
		$totalDuplicated = 0;
		$totalemptyMobiles = 0;

        // Open file in read mode
        $csvFile = fopen($_FILES['import_file']['tmp_name'], 'r');


        // Skipping header row //fgetcsv($csvFile);
        // Read file
        while (($csvData = fgetcsv($csvFile, 2000, ",")) !== FALSE) {

			// Row column length
			$dataLen = count($csvData);
			// Skip row if length
			if( !($dataLen >= 7) ) continue;

			// Assign value to variables
			$id_reference = trim($csvData[0]);		
			$contact_name = trim($csvData[1]);
			$contact_address = trim($csvData[2]);
			$contact_region = trim($csvData[3]);
			$contact_postal = trim($csvData[4]);
			$contact_tel1 = trim($csvData[5]);
			$contact_tel2 = trim($csvData[6]);
			$contact_comment = trim($csvData[7]);

			if ( empty($id_reference) || $id_reference == '' ){
				$id_reference = -1;
			}

	

			// Check record already exists or not
			$record = $wpdb->get_results($wpdb->prepare("SELECT count(*) as count FROM {$tablename} WHERE id_reference = %s AND id_reference != '-1'", $id_reference), OBJECT);
			
			

				if($record[0]->count == 0){

						// Insert Record
						$wpdb->insert($tablename, array(
							'id_reference' =>$id_reference,
							'id_user' => get_current_user_id(),
							'contact_name' =>$contact_name,
							'contact_address' =>$contact_address,
							'contact_region' =>$contact_region,
							'contact_postal' =>$contact_postal,
							'contact_tel1' =>$contact_tel1,
							'contact_tel2' =>$contact_tel2,
							'contact_comment' =>$contact_comment,
							'time_updated' => 0,
							'time_created' => current_time('timestamp')
						));

						if($wpdb->insert_id > 0){
							$totalInserted++;
						}
				}else{
					$totalDuplicated++;
				}

        }
        echo "<h3 style='color: green;'>Total record Inserted : ".$totalInserted."</h3>";
        echo "<h3 style='color: green;'>Skipped duplicated : ".$totalDuplicated."</h3>";


    }else{
        echo "<h3 style='color: red;'>Invalid Extension</h3>";
    }

    }
    ?>
    <div class="wrap">
    <h2><?php esc_html_e('Import addresses', 'iben-woo-elta-courier') ?> </h2>

    <p><?php esc_html_e('CSV list must be 7 or 8 columns seperated with comma(,) with this order and these values: id_reference*, fullname, address, region, postal, tel1, tel2, comment', 'iben-woo-elta-courier') ?></p>
	<p><?php esc_html_e('Do not include header on your csv becuase the 1st row will be imported. Please check the sample', 'iben-woo-elta-courier') ?></p>
	<p><?php esc_html_e('id_reference are required field otherwise will skipped', 'iben-woo-elta-courier') ?></p>
	<p><a href="<?php echo IBEN_WOO_ELTA_PLUGIN_URL ?>importv1.csv"><?php esc_html_e('Download sample', 'iben-woo-elta-courier') ?> </a></p>

    <form method='post' action='<?= $_SERVER['REQUEST_URI']; ?>' enctype='multipart/form-data'>
        <input type="file" name="import_file" >
        <input type="submit" class="button button-primary" name="iben_elta_address_import" value="<?php esc_html_e('Upload and Import', 'iben-woo-elta-courier') ?>">
    </form>

    </div>
	<?php
}

/**
  *
 * @since     1.3.0
 */
function iben_woo_elta_contacts_page_handler(){
	
    if (!class_exists('WP_List_Table')) {
        require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
    }	
    
    require_once plugin_dir_path( __FILE__ ) . 'class-iben-elta-contacts-list-table.php';

    global $wpdb;

    $table = new Get_Elta_Contacts_List_Table();

	//Fetch, prepare, sort, and filter our data...
	if( isset($_POST['s']) ){
			$table->prepare_items( sanitize_text_field($_POST['s']) );
	} else {
			$table->prepare_items();
	}


	$message = '';
	$count = 0;
    if (isset($_REQUEST['id'])){
        if (is_array($_REQUEST['id'])){
            $count = count($_REQUEST['id']);
        } else {
            $count = 1;
        }
    }

    if ('delete' === $table->current_action()) {

        $message = '<div class="updated below-h2" id="message"><p>' . sprintf(esc_html__('Voucher rows deleted: %d', 'iben-woo-elta-courier'), $count ) . '</p></div>';
    }
    ?>
	<div class="wrap">

		<div class="icon32 icon32-posts-post" id="icon-edit"><br></div>
		<h2><?php esc_html_e('ELTA Contacts', 'iben-woo-elta-courier') ?> </h2>
		<?php 
			$options = get_option( 'iben_elta_main_settings_fields' );
			// if is not checked = is not isset then display
			if (!isset( $options['iben_elta_main_settings_hide_settings_button'] ) ){
				echo '<h4><a href="' . admin_url( 'options-general.php?page=iben_woo_elta_courier' ) . '">'. esc_html__('ELTA Settings', 'iben-woo-elta-courier') .'</a></h4>';
			}
			
			echo '<h4><a href="' . admin_url( 'admin.php?page=iben_woo_elta_edit_contact' ) . '">'. esc_html__('Add new contact', 'iben-woo-elta-courier') .'</a> - <a href="' . admin_url( 'admin.php?page=iben_woo_elta_import_contacts' ) . '">'. esc_html__('Import contacts', 'iben-woo-elta-courier') .'</a></h4>';
		
		
		echo $message; 

		
		$table->views();

		
		?>



		<form id="iben_elta-list-table" method="GET">
			<input type="hidden" name="page" value="<?php echo esc_attr($_REQUEST['page']); ?>"/>

			<?php $table->search_box( 'search', 'iben_elta_contacts_list_search' );?>


			<?php $table->display(); ?>


			
		</form>

	</div>
	<?php
}

/**
  *
 * @since     1.3.1
 */
function iben_woo_elta_edit_contact_handler(){
    global $wpdb;
    $table_name = $wpdb->prefix . apply_filters('iben_elta_contacts_table_name', 'iben_elta_contacts');

    $message = '';
    $notice = '';

    // this is default $item which will be used for new records
    $default = array(
		'id' => 0,
		'id_reference' => '',
        'contact_name' => '',
        'contact_address' => '',
        'contact_region' => '',
		'contact_postal' => '',
		'contact_tel1' => '',
		'contact_tel2' => '',
		'contact_comment' => '',
		'time_updated' => current_time('timestamp'),
		'time_created' => current_time('timestamp')
    );

    // here we are verifying does this request is post back and have correct nonce
    if (isset($_REQUEST['nonce']) && wp_verify_nonce($_REQUEST['nonce'], basename(__FILE__))) {
        // combine our default item with request params
        $item = shortcode_atts($default, $_REQUEST);
        // validate data, and if all ok save item to database
        // if id is zero insert otherwise update
        $item_valid = iben_elta_validate_edit_contact($item);
        if ($item_valid === true) {
            if ($item['id'] == 0) {
                $result = $wpdb->insert($table_name, $item);
                $item['id'] = $wpdb->insert_id;
                if ($result) {
                    $message = esc_html__('Contact was successfully saved', 'iben-woo-elta-courier');
                } else {
                    $notice = esc_html__('There was an error while saving contact', 'iben-woo-elta-courier');
                }
            } else {
                $result = $wpdb->update($table_name, $item, array('id' => $item['id']));
                if ($result) {
                    $message = esc_html__('Contact was successfully updated', 'iben-woo-elta-courier');
                } else {
                    $notice = esc_html__('Nothing has been updated', 'iben-woo-elta-courier');
                }
            }
        } else {
            // if $item_valid not true it contains error message(s)
            $notice = $item_valid;
        }
    }
    else {
        // if this is not post back we load item to edit or give new one to create
		$item = $default;
		
        if (isset($_REQUEST['id'])) {
            $item = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $_REQUEST['id']), ARRAY_A);
            if (!$item) {
                $item = $default;
                $notice = esc_html__('Item not found', 'iben-woo-elta-courier');
            }
        }
    }

    // here we adding our custom meta box
    add_meta_box('iben_elta_edit_contact_meta_box', 'Edit contact', 'iben_elta_edit_contact_meta_box_handler', 'iben_elta_edit_contact_meta_box_do', 'normal', 'default');

    ?>
	<div class="wrap">
		<div class="icon32 icon32-posts-post" id="icon-edit"><br></div>
		
		<p><h2><?php esc_html_e('Contact', 'iben-woo-elta-courier') ?></h2></p>
		
		<a class="add-new-h2" href="<?php echo get_admin_url(get_current_blog_id(), 'admin.php?page=iben_woo_elta_contacts');?>"><?php esc_html_e('Βack to list', 'iben-woo-elta-courier') ?></a></h2></p>
		
		<?php if (!empty($notice)): ?>
		<div id="notice" class="error"><p><?php echo esc_html( $notice ); ?></p></div>
		<?php endif;?>
		<?php if (!empty($message)): ?>
		<div id="message" class="updated"><p><?php echo esc_html( $message ); ?></p></div>
		<?php endif;?>

		<form id="form" method="POST">
			<input type="hidden" name="nonce" value="<?php echo wp_create_nonce(basename(__FILE__)) ?>"/>
			<?php /* NOTICE: here we storing id to determine will be item added or updated */ ?>
			<input type="hidden" name="id" value="<?php echo esc_attr( $item['id'] ); ?>"/>
		

			<div class="metabox-holder" id="poststuff">
				<div id="post-body">
					<div id="post-body-content">
						
						<?php do_meta_boxes('iben_elta_edit_contact_meta_box_do', 'normal', $item); ?>
						<?php 
						
						if (isset($item['id']) && $item['id'] == 0) { ?>
							<input type="submit" value="<?php esc_html_e('Save contact', 'iben-woo-elta-courier') ?>" id="submit" class="button-primary" name="submit">
						<?php
						}else{ ?>
							<input type="submit" value="<?php esc_html_e('Update contact', 'iben-woo-elta-courier') ?>" id="submit" class="button-primary" name="submit">
						<?php
						}					
						?>

					</div>
				</div>
			</div>
		</form>
	</div>
	<?php
}
/**
  *
 * @since     1.3.1
 */
function iben_elta_edit_contact_meta_box_handler($item){
    ?>

	<table cellspacing="2" cellpadding="5" style="width: 100%;" class="form-table">
		<input type="hidden" name="id" value="<?php echo $item['id'] ?>"/>

		<tbody>
		<tr class="form-field">
			<th valign="top" scope="row">
				<label for="id_reference"><?php esc_html_e('ID reference', 'iben-woo-elta-courier') ?>*</label>
			</th>
			<td>
				<input id="id_reference" name="id_reference" type="text" style="width: 95%" value="<?php echo esc_attr($item['id_reference']) ?>"
						size="50" class="code" placeholder="<?php esc_html_e('ID reference', 'iben-woo-elta-courier') ?>" required>
			</td>
		</tr>

		<tr class="form-field">
			<th valign="top" scope="row">
				<label for="contact_name"><?php esc_html_e('Full name', 'iben-woo-elta-courier') ?>*</label>
			</th>
			<td>
				<input id="contact_name" name="contact_name" type="text" style="width: 95%" value="<?php echo esc_attr($item['contact_name']) ?>"
						size="50" class="code" placeholder="<?php esc_html_e('Full name', 'iben-woo-elta-courier') ?>" required>
			</td>
		</tr>


		<tr class="form-field">
			<th valign="top" scope="row">
				<label for="contact_address"><?php esc_html_e('Address', 'iben-woo-elta-courier') ?>*</label>
			</th>
			<td>
				<input id="contact_address" name="contact_address" type="text" style="width: 95%" value="<?php echo esc_attr($item['contact_address']) ?>"
						size="50" class="code" placeholder="<?php esc_html_e('Address', 'iben-woo-elta-courier') ?>" required>
			</td>
		</tr>

		<tr class="form-field">
			<th valign="top" scope="row">
				<label for="contact_region"><?php esc_html_e('Region', 'iben-woo-elta-courier') ?>*</label>
			</th>
			<td>
				<input id="contact_region" name="contact_region" type="text" style="width: 95%" value="<?php echo esc_attr($item['contact_region']) ?>"
						size="50" class="code" placeholder="<?php esc_html_e('Region', 'iben-woo-elta-courier') ?>" required>
			</td>
		</tr>

		<tr class="form-field">
			<th valign="top" scope="row">
				<label for="contact_postal"><?php esc_html_e('Postal code', 'iben-woo-elta-courier') ?>*</label>
			</th>
			<td>
				<input id="contact_postal" name="contact_postal" type="text" style="width: 95%" value="<?php echo esc_attr($item['contact_postal']) ?>"
						size="50" class="code" placeholder="<?php esc_html_e('Postal code', 'iben-woo-elta-courier') ?>" required>
			</td>
		</tr>

		<tr class="form-field">
			<th valign="top" scope="row">
				<label for="contact_tel1"><?php esc_html_e('Telephone 1', 'iben-woo-elta-courier') ?></label>
			</th>
			<td>
				<input id="contact_tel1" name="contact_tel1" type="text" style="width: 95%" value="<?php echo esc_attr($item['contact_tel1']) ?>"
						size="50" class="code" placeholder="<?php esc_html_e('Telephone 1', 'iben-woo-elta-courier') ?>">
			</td>
		</tr>		

		<tr class="form-field">
			<th valign="top" scope="row">
				<label for="contact_tel2"><?php esc_html_e('Telephone 2', 'iben-woo-elta-courier') ?></label>
			</th>
			<td>
				<input id="contact_tel2" name="contact_tel2" type="text" style="width: 95%" value="<?php echo esc_attr($item['contact_tel2']) ?>"
						size="50" class="code" placeholder="<?php esc_html_e('Telephone 2', 'iben-woo-elta-courier') ?>">
			</td>
		</tr>		

		<tr class="form-field">
			<th valign="top" scope="row">
				<label for="contact_comment"><?php esc_html_e('Comment', 'iben-woo-elta-courier') ?></label>
			</th>
			<td>
				<input id="contact_comment" name="contact_comment" type="text" style="width: 95%" value="<?php echo esc_attr($item['contact_comment']) ?>"
						size="50" class="code" placeholder="<?php esc_html_e('Comment', 'iben-woo-elta-courier') ?>">
			</td>
		</tr>				


		</tbody>
	</table>
	<?php
}


/**
  *
 * @since     1.3.1
 */
function iben_elta_validate_edit_contact($item){
	global $wpdb;
    $table_name = $wpdb->prefix . apply_filters('iben_elta_contacts_table_name', 'iben_elta_contacts');

    $messages = array();

	if ( empty($item['id_reference']) ) $messages[] = esc_html__('ID reference is invalid', 'iben-woo-elta-courier');
	
    
    if ( empty($item['contact_tel1']) && empty($item['contact_tel1'])) $messages[] = esc_html__('1 telephone  is required', 'iben-woo-elta-courier');
	if(!empty($item['contact_tel1']) && !preg_match('/^[+]?[0-9][0-9]{8,15}$/', $item['contact_tel1'])) $messages[] = esc_html__('Phone 1 must be 8 - 15 digits', 'iben-woo-elta-courier');
	if(!empty($item['contact_tel2']) && !preg_match('/^[+]?[0-9][0-9]{8,15}$/', $item['contact_tel2'])) $messages[] = esc_html__('Phone 2 must be 8 - 15 digits', 'iben-woo-elta-courier');
	

	if (!empty($item['id_reference']) && $item['id'] == 0 ) {
		$item = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id_reference = %d", $item['id_reference']), ARRAY_A);
		if ($item) {
			$messages[] = esc_html__('ID reference already exist', 'iben-woo-elta-courier').' '.sprintf('<a href="?page=iben_woo_elta_edit_contact&id=%s">%s</a>', $item['id'], esc_html__('Update contact here', 'iben-woo-elta-courier'));
			
		}
	}


    if (empty($messages)) return true;
    return implode('<br />', $messages);
}


function iben_woo_elta_vouchers_page_handler(){
	
    if (!class_exists('WP_List_Table')) {
        require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
    }	
    
    require_once plugin_dir_path( __FILE__ ) . 'class-iben-elta-voucher-list-table.php';

    global $wpdb;

    $table = new Get_Elta_Voucher_List_Table();

	//Fetch, prepare, sort, and filter our data...
	if( isset($_POST['s']) ){
			$table->prepare_items( sanitize_text_field($_POST['s']) );
	} else {
			$table->prepare_items();
	}


    $message = '';
	$count = 0;
    if (isset($_REQUEST['id'])){
        if (is_array($_REQUEST['id'])){
            $count = count($_REQUEST['id']);
        } else {
            $count = 1;
        }
    }

    if ('delete' === $table->current_action()) {

        $message = '<div class="updated below-h2" id="message"><p>' . sprintf(esc_html__('Voucher rows deleted: %d', 'iben-woo-elta-courier'), $count ) . '</p></div>';
    }
    if ('undelivered' === $table->current_action()) {

        $message = '<div class="updated below-h2" id="message"><p>' . sprintf(esc_html__('Voucher rows set as undelivered: %d', 'iben-woo-elta-courier'), $count ) . '</p></div>';
    }    
    if ('delivered' === $table->current_action()) {

        $message = '<div class="updated below-h2" id="message"><p>' . sprintf(esc_html__('Voucher rows set as delivered: %d', 'iben-woo-elta-courier'), $count ) . '</p></div>';
    } 

    ?>
	<div class="wrap">

		<div class="icon32 icon32-posts-post" id="icon-edit"><br></div>
		<h2><?php esc_html_e('Vouchers', 'iben-woo-elta-courier') ?> </h2>
		<?php 
			$options = get_option( 'iben_elta_main_settings_fields' );
			// if is not checked = is not isset then display
			if (!isset( $options['iben_elta_main_settings_hide_settings_button'] ) ){
				echo '<h4><a href="' . admin_url( 'options-general.php?page=iben_woo_elta_courier' ) . '">'. esc_html__('ELTA Settings', 'iben-woo-elta-courier') .'</a></h4>';
			}
		
		
		echo $message; 

		if (isset($_REQUEST['ddeleted']) && $_REQUEST['ddeleted'] == '1'){ ?>
			<h4><?php esc_html_e('You can safely delete these records just make sure you have contacted with your local ELTA Courier and cancel these vouchers', 'iben-woo-elta-courier') ?> </h4>
		<?php
		}
		
		$table->views();

		
		?>



		<form id="iben_elta-list-table" method="GET">
			<input type="hidden" name="page" value="<?php echo esc_attr($_REQUEST['page']); ?>"/>

			<?php $table->search_box( 'search', 'iben_voucher_list_search' );?>

			
			<?php $table->display(); ?>


			
		</form>

	</div>
	<?php
}



function iben_woo_elta_settings_page_handler() {
	?>
	<!-- Create a header in the default WordPress 'wrap' container -->
	<div class="wrap">
	
		<div id="icon-themes" class="icon32"></div>
		<h2><?php esc_html_e( 'ELTA Courier', 'iben-woo-elta-courier' ); ?></h2>
		<?php settings_errors('iben_woo_elta_courier'); ?>

        <?php 

            $active_tab = isset( $_GET[ 'page' ]) ?  $_GET[ 'page' ] : 'iben_woo_elta_courier';

            if( $active_tab == 'iben_woo_elta_license' ) {
                $active_tab = 'license';
            }else if( $active_tab == 'iben_woo_elta_courier' ) {
                $active_tab = 'main_settings';
            }

        ?>

		<form method="post" action="options.php">
			<h2 class="nav-tab-wrapper">
				<a href="?page=iben_woo_elta_courier" class="nav-tab <?php echo $active_tab == 'main_settings' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e( 'Main Settings', 'iben-woo-elta-courier' ); ?></a>            
				<a href="<?php echo admin_url( 'admin.php?page=iben_woo_elta_license' )  ?>" class="nav-tab <?php echo $active_tab == 'license' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e( 'License registration', 'iben-woo-elta-courier' ); ?></a>
			</h2>

			<span class="iben_elta_woo_settings">
			<?php
				echo ( extension_loaded('soap') ? '' : '<h2><span style="color:red;">'. esc_html__( 'Soap PHP extension must be enabled', 'iben-woo-elta-courier' ).' </span></h2>');

				settings_fields( 'iben_elta_main_settings_fields' );
				do_settings_sections( 'iben_elta_main_settings_fields' );
				echo"<hr>";
				submit_button(); 
			?>
			</span>

		</form>
		
	</div>
<?php
}


function iben_elta_main_default_settings() {
	
	$defaults = array( 
		'iben_elta_main_settings_enable_test_mode'	=>	'1',
		'iben_elta_main_settings_papersize'	=>	'1',
		'iben_elta_main_settings_email_checked_default_completed' => '0',
		'iben_elta_button_settings_create_pdf' => '1',
		'iben_elta_button_settings_create_send_completed_email' => '0',

		'iben_elta_main_settings_cron_check_time' => 'hourly',
		'iben_elta_main_settings_cron_change_order_status' => '-1',
		
		'iben_elta_main_settings_delete_pdf_cron_check_time' => 'iben-elta-3-days',
		'iben_elta_main_settings_cron_query_limit' => '40',
		'iben_elta_main_settings_delete_pdf_cron_query' => '2',	
		
		// automatically fields	
		'iben_elta_main_settings_auto_createv_enable' => '0',
		'iben_elta_main_settings_auto_createv_cron_time' => 'iben-elta-5-minutes',
		'iben_elta_main_settings_auto_createv_create_pdf' => '1',
		'iben_elta_main_settings_auto_createv_set_order_completed' => '0',
		'iben_elta_main_settings_auto_createv_send_completed_email' => '0',
		'iben_elta_main_settings_auto_createv_include_message' => '0',
		'iben_elta_main_settings_auto_createv_resend_admin_email' => '0',
	);
	return apply_filters( 'iben_elta_main_default_settings', $defaults );
	
} 


function iben_elta_main_settings() {

	if( false == get_option( 'iben_elta_main_settings_fields' ) ) {	
		add_option( 'iben_elta_main_settings_fields', apply_filters( 'iben_elta_main_default_settings', iben_elta_main_default_settings() ) );
	}
    add_settings_field(
		'iben_elta_main_settings_enable_test_mode',
		esc_html__( 'Enable test mode', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_enable_test_mode_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_section'
	);
	add_settings_section(
		'iben_elta_main_settings_section',			// ID used to identify this section and with which to register options
		esc_html__( 'Main settings', 'iben-woo-elta-courier' ),		// Title to be displayed on the administration page
		'iben_elta_main_settings_section_callback',	// Callback used to render the description of the section
		'iben_elta_main_settings_fields'		// Page on which to add this section of options
	);
	
	add_settings_field(	
		'iben_elta_main_settings_customer',						
		esc_html__( 'Customer code', 'iben-woo-elta-courier' ),							
		'iben_elta_main_settings_customer_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_section'
	);

	add_settings_field(	
		'iben_elta_main_settings_username',						
		esc_html__( 'Username', 'iben-woo-elta-courier' ),							
		'iben_elta_main_settings_username_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_section'
	);

	add_settings_field(	
		'iben_elta_main_settings_password',						
		esc_html__( 'Password', 'iben-woo-elta-courier' ),							
		'iben_elta_main_settings_password_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_section'
	);	
	add_settings_field(	
		'iben_elta_main_settings_sub_password',						
		esc_html__( 'Sub code', 'iben-woo-elta-courier' ),							
		'iben_elta_main_settings_sub_password_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_section'
	);

    add_settings_field(
		'iben_elta_main_settings_2nd_enable_account',
		esc_html__( 'Enable 2nd ELTA account', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_2nd_enable_account_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_section'
	);
	add_settings_field(	
		'iben_elta_main_settings_2nd_customer',						
		esc_html__( 'Customer code', 'iben-woo-elta-courier' ).esc_html__( '( 2nd )', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_2nd_customer_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_section'
	);
	add_settings_field(	
		'iben_elta_main_settings_2nd_username',						
		esc_html__( 'Username', 'iben-woo-elta-courier' ).esc_html__( '( 2nd )', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_2nd_username_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_section'
	);
	add_settings_field(	
		'iben_elta_main_settings_2nd_password',						
		esc_html__( 'Password', 'iben-woo-elta-courier' ).esc_html__( '( 2nd )', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_2nd_password_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_section'
	);	
	add_settings_field(	
		'iben_elta_main_settings_2nd_sub_password',						
		esc_html__( 'Sub code', 'iben-woo-elta-courier' ).esc_html__( '( 2nd )', 'iben-woo-elta-courier' ),			
		'iben_elta_main_settings_2nd_sub_password_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_section'
	);

	add_settings_field(
		'iben_elta_main_settings_papersize',
		esc_html__( 'Default Paper size', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_papersize_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_section'
	);

	add_settings_field(	
		'iben_elta_main_settings_default_weight',						
		esc_html__( 'Default weight', 'iben-woo-elta-courier' ),							
		'iben_elta_main_settings_default_weight_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_section'
	);

	add_settings_field(
		'iben_elta_main_settings_convert_uppercase',
		esc_html__( 'Convert automatically to UPPERCASE', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_convert_uppercase_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_section'
	);
	function iben_elta_main_settings_convert_uppercase_callback() {

		$options = get_option( 'iben_elta_main_settings_fields' );
	
		$html = '<p><input type="checkbox" id="iben_elta_main_settings_convert_uppercase" name="iben_elta_main_settings_fields[iben_elta_main_settings_convert_uppercase]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_convert_uppercase'] ) ? $options['iben_elta_main_settings_convert_uppercase'] : 0, false ) . '/>'; 	
		$html .= '<label for="iben_elta_main_settings_convert_uppercase">'. esc_html__( 'Check it, if you want to automatically UPPSERCASE data in fields', 'iben-woo-elta-courier' ).'</label></p>';
		
		echo $html;	
	}
	
	
	add_settings_field(
		'iben_elta_main_settings_hide_settings_button',
		esc_html__( 'Hide settings link in voucher list', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_hide_settings_button_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_section'
	);
	function iben_elta_main_settings_hide_settings_button_callback() {

		$options = get_option( 'iben_elta_main_settings_fields' );
	
		$html = '<p><input type="checkbox" id="iben_elta_main_settings_hide_settings_button" name="iben_elta_main_settings_fields[iben_elta_main_settings_hide_settings_button]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_hide_settings_button'] ) ? $options['iben_elta_main_settings_hide_settings_button'] : 0, false ) . '/>'; 	
		$html .= '<label for="iben_elta_main_settings_hide_settings_button">'. esc_html__( 'Check it, if you want to hide the settings link in vouchers list page', 'iben-woo-elta-courier' ).'</label></p>';
		
		echo $html;	
	}
	

	add_settings_field(
		'iben_elta_main_settings_enable_ref_order',
		esc_html__( 'Put reference order number in ref field', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_enable_ref_order_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_section'
	);		

	add_settings_section(
		'iben_elta_button_settings_section_before',
		'',
		'iben_elta_new_section_callback',
		'iben_elta_main_settings_fields'
	);


	add_settings_section(
		'iben_elta_button_settings_section',
		esc_html__( 'Create voucher button settings', 'iben-woo-elta-courier' ),
		'iben_elta_button_settings_section_callback',
		'iben_elta_main_settings_fields'
	);
	add_settings_field(
		'iben_elta_button_settings_create_pdf',
		esc_html__( 'Create PDF immediately', 'iben-woo-elta-courier' ),
		'iben_elta_button_settings_create_pdf_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_button_settings_section'
	);

	
	function iben_elta_removed_completed_field() {
		$class = 'notice notice-error';
		$field1 = esc_html__( 'Set order as completed', 'iben-woo-elta-courier' );
		$message = esc_html__( 'field removed and replaced with a new dropdown field named', 'iben-woo-elta-courier' );
		$field2 = esc_html__( 'Change order status', 'iben-woo-elta-courier' );
		$message2 = esc_html__( ' You should change this field to Completed, then save settings and you are good to go', 'iben-woo-elta-courier' );	 
		$message3 = '<a href="' . esc_url( admin_url( 'options-general.php?page=' . 'iben_woo_elta_courier' ) ) . '">Ρυθμίσεις</a>';	
		printf( '<div class="%1$s"><p><b>%2$s </b> %3$s <b>%4$s</b> <br/>%5$s %6$s </p></div>', esc_attr( $class ),  $field1, $message, $field2, $message2, $message3 ); 		
		
	}

	$options = get_option( 'iben_elta_main_settings_fields' );
	if( isset( $options['iben_elta_button_settings_create_set_order_completed'] ) ) {
		add_action( 'admin_notices', 'iben_elta_removed_completed_field' );
	}

	add_settings_field(	
		'iben_elta_main_settings_voucher_change_order_status',						
		esc_html__( 'Change order status', 'iben-woo-elta-courier' ),							
		'iben_elta_main_settings_voucher_change_order_status_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_button_settings_section'
	);

    function iben_elta_main_settings_voucher_change_order_status_callback() {
        $status = wc_get_order_statuses();
        $options = get_option( 'iben_elta_main_settings_fields' );
        $html = '<p><select id="iben_elta_main_settings_voucher_change_order_status" name="iben_elta_main_settings_fields[iben_elta_main_settings_voucher_change_order_status]">';
            
		$change_order_status = (!empty($options['iben_elta_main_settings_voucher_change_order_status']) ? $options['iben_elta_main_settings_voucher_change_order_status'] : '');

		$html .= '<option value="-1">'.esc_html__( 'DISABLED', 'iben-woo-elta-courier' ) .'</option>';
		foreach($status as $key=>$stat){	
			$html .= '<option value="' .$key. '"' . selected( $change_order_status, $key, false) . '>' .$stat. '</option>';
		}            
        $html .= '</select></p>';
        $html .= '<p>'.esc_html__( 'Select order status to change when voucher created.', 'iben-woo-elta-courier' ) .'</b></p>';
    
        echo $html;
    
    }

	
	add_settings_field(
		'iben_elta_button_settings_create_send_completed_email',
		esc_html__( 'Send completed email', 'iben-woo-elta-courier' ),
		'iben_elta_button_settings_create_send_completed_email_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_button_settings_section'
	);		
	
	add_settings_field(
		'iben_elta_main_enable_tracking_saving',
        esc_html__( 'Copy/Paste tracking code', 'iben-woo-elta-courier' ),
		'iben_elta_main_enable_tracking_saving_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_button_settings_section'
	);		
    
    function iben_elta_main_enable_tracking_saving_callback($args) {
        $options = get_option( 'iben_elta_main_settings_fields' );
        $html = '<p><input type="checkbox" id="iben_elta_main_enable_tracking_saving" name="iben_elta_main_settings_fields[iben_elta_main_enable_tracking_saving]" value="1" ' . checked( 1, isset( $options['iben_elta_main_enable_tracking_saving'] ) ? $options['iben_elta_main_enable_tracking_saving'] : 0, false ) . '/>'; 	
        $html .= '<label for="iben_elta_main_enable_tracking_saving">'. esc_html__( 'Check, to copy the generated tracking code in a the field below.', 'iben-woo-elta-courier' ).'</label>
		<br/>'. esc_html__( 'This works for manual creation mode when you are inside order and generate it.', 'iben-woo-elta-courier' ).'</p>';
        echo $html;        
    }

    add_settings_field(
		'iben_elta_main_enable_tracking_saving_field',
		esc_html__( 'Target(s) (class or ID)', 'iben-woo-elta-courier' ),
		'iben_elta_main_enable_tracking_saving_field_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_button_settings_section'
	);


    function iben_elta_main_enable_tracking_saving_field_callback($args) {
		$options = get_option( 'iben_elta_main_settings_fields' );

		$default = '';
		// compability with
		if ( class_exists('zorem_woocommerce_advanced_shipment_tracking') ) {
			$default = '#tracking_number';
		}

        echo '<p><input type="text" size="100" id="iben_elta_main_enable_tracking_saving_field" placeholder = "Example: #iben_field_name_id | .iben_field_name_class" name="iben_elta_main_settings_fields[iben_elta_main_enable_tracking_saving_field]" value="' . (empty($options['iben_elta_main_enable_tracking_saving_field']) ? $default : $options['iben_elta_main_enable_tracking_saving_field']) . '" />
        <br/>'. esc_html__( 'Fill class or ID names separated by | . Include # or . in the prefix.', 'iben-woo-elta-courier' ).'
        <br/>'. esc_html__( 'After voucher creation, tracking number will be copied and pasted to the target field(s) above.', 'iben-woo-elta-courier' ).' </p>';
    } 


	


	add_settings_section(
		'iben_elta_main_settings_auto_createv_section_before',
		'',
		'iben_elta_new_section_callback',
		'iben_elta_main_settings_fields'
	);

	add_settings_section(
		'iben_elta_main_settings_auto_createv_section',
		esc_html__( 'Create voucher automatically - Available options', 'iben-woo-elta-courier' ),
		'iben_elta_automatic_settings_section_callback',
		'iben_elta_main_settings_fields'
	);	

	add_settings_field(
		'iben_elta_main_settings_auto_createv_enable',
		esc_html__( 'Enable automatically creation of voucher', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_auto_createv_enable_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_auto_createv_section'
	);
	add_settings_field(
		'iben_elta_main_settings_auto_createv_cron_time',
		esc_html__( 'Select cron time', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_auto_createv_cron_time_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_auto_createv_section'
	);

	
	add_settings_field(
		'iben_elta_main_settings_auto_createv_create_pdf',
		esc_html__( 'Create PDF immediately', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_auto_createv_create_pdf_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_auto_createv_section'
	);
	
	add_settings_field(
		'iben_elta_main_settings_auto_createv_set_order_completed',
		esc_html__( 'Set order as completed', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_auto_createv_set_order_completed_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_auto_createv_section'
	);	

	add_settings_field(
		'iben_elta_main_settings_auto_createv_send_completed_email',
		esc_html__( 'Send completed email', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_auto_createv_send_completed_email_email_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_auto_createv_section'
	);
	add_settings_field(
		'iben_elta_main_settings_auto_createv_resend_admin_email',
		esc_html__( 'Resend admin email', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_auto_createv_resend_admin_email_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_auto_createv_section'
	);
	add_settings_field(
		'iben_elta_main_settings_auto_createv_include_message',
		esc_html__( 'Include admin message', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_auto_createv_include_message_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_auto_createv_section'
	);

	add_settings_field(
		'iben_elta_main_settings_auto_createv_admin_body',
		esc_html__( 'Admin message', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_auto_createv_admin_body_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_auto_createv_section'
	);	
	
	
	function iben_elta_main_settings_auto_createv_cron_time_callback() {
		
		$options = get_option( 'iben_elta_main_settings_fields' );
		
		$html = '<p><select id="iben_elta_main_settings_auto_createv_cron_time" name="iben_elta_main_settings_fields[iben_elta_main_settings_auto_createv_cron_time]">';
					
			$html .= '<option value="iben-elta-2-minutes"' . selected( $options['iben_elta_main_settings_auto_createv_cron_time'], 'iben-elta-2-minutes', false) . '>' . esc_html__( 'Every 2 minutes', 'iben-woo-elta-courier' ) . '</option>';
			$html .= '<option value="iben-elta-5-minutes"' . selected( $options['iben_elta_main_settings_auto_createv_cron_time'], 'iben-elta-5-minutes', false) . '>' . esc_html__( 'Every 5 minutes  - Recommended', 'iben-woo-elta-courier' ) . '</option>';
			$html .= '<option value="iben-elta-15-minutes"' . selected( $options['iben_elta_main_settings_auto_createv_cron_time'], 'iben-elta-15-minutes', false) . '>' . esc_html__( 'Every 15 minutes', 'iben-woo-elta-courier' ) . '</option>';
			$html .= '<option value="iben-elta-30-minutes"' . selected( $options['iben_elta_main_settings_auto_createv_cron_time'], 'iben-elta-30-minutes', false) . '>' . esc_html__( 'Every 30 minutes', 'iben-woo-elta-courier' ) . '</option>';
			
		$html .= '</select></p>';
		
		echo $html;
	
	}


	function iben_elta_main_settings_auto_createv_admin_body_callback() {

		$options = get_option( 'iben_elta_main_settings_fields' );
	
		$settings = array( 
			'textarea_name' => 'iben_elta_main_settings_fields[iben_elta_main_settings_auto_createv_admin_body]',
			'tinymce'=>array(
				'toolbar1' => 'formatselect,bold,italic,bullist,numlist,alignleft,aligncenter,alignright,alignjustify,outdent,indent,removeformat',
			  ),
			'media_buttons' => false,
			'wpautop' =>false,
			'teeny' => false,
			'textarea_rows' => 6,
			'quicktags' => array( 'buttons' => 'strong,em,link,ul,ol,li' )
		);
	
	
		$body = '<h3>Προς διαχειριστή</h3>
			<p>Ο αριθμός αποστολής είναι: [iben_elta_tracking_pdf]</p>';
	
		if ( isset($options['iben_elta_main_settings_auto_createv_admin_body']) && $options['iben_elta_main_settings_auto_createv_admin_body'] != '' && $options['iben_elta_main_settings_auto_createv_admin_body'] != $body){
			$body = $options['iben_elta_main_settings_auto_createv_admin_body'];
		}
	
		echo wp_editor( $body, 'iben_elta_main_settings_auto_createv_admin_body', $settings  );
		echo '<p><b>'.esc_html__( 'Available Shortcode', 'iben-woo-elta-courier' ).': </b>[iben_elta_tracking_pdf]</p>';

	}	


	function iben_elta_main_settings_auto_createv_include_message_callback() {

		$options = get_option( 'iben_elta_main_settings_fields' );
		$html = '<p><input type="checkbox" id="iben_elta_main_settings_auto_createv_include_message" name="iben_elta_main_settings_fields[iben_elta_main_settings_auto_createv_include_message]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_auto_createv_include_message'] ) ? $options['iben_elta_main_settings_auto_createv_include_message'] : 0, false ) . '/>'; 	
		$html .= '<label for="iben_elta_main_settings_auto_createv_include_message">'. esc_html__( 'Check it, if you want to include the below message in admin email', 'iben-woo-elta-courier' ).'</label></p>';
		echo $html;
	}	
	function iben_elta_main_settings_auto_createv_enable_callback() {

		$options = get_option( 'iben_elta_main_settings_fields' );
		$html = '<p><input type="checkbox" id="iben_elta_main_settings_auto_createv_enable" name="iben_elta_main_settings_fields[iben_elta_main_settings_auto_createv_enable]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_auto_createv_enable'] ) ? $options['iben_elta_main_settings_auto_createv_enable'] : 0, false ) . '/>'; 	
		$html .= '<label for="iben_elta_main_settings_auto_createv_enable">'. esc_html__( 'Check it, if you want to enable the functionality of creating voucher when an order is placed and is processing (paid)', 'iben-woo-elta-courier' ).'</label></p>';
		echo $html;
	}	

	function iben_elta_main_settings_auto_createv_create_pdf_callback() {

		$options = get_option( 'iben_elta_main_settings_fields' );
		$html = '<p><input type="checkbox" id="iben_elta_main_settings_auto_createv_create_pdf" name="iben_elta_main_settings_fields[iben_elta_main_settings_auto_createv_create_pdf]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_auto_createv_create_pdf'] ) ? $options['iben_elta_main_settings_auto_createv_create_pdf'] : 0, false ) . '/>'; 	
		$html .= '<label for="iben_elta_main_settings_auto_createv_create_pdf">'. esc_html__( 'Check it, if you want to create PDF immediately after voucher will be created', 'iben-woo-elta-courier' ).'</label></p>';
		echo $html;
	}	
	function iben_elta_main_settings_auto_createv_set_order_completed_callback() {

		$options = get_option( 'iben_elta_main_settings_fields' );
		$html = '<p><input type="checkbox" id="iben_elta_main_settings_auto_createv_set_order_completed" name="iben_elta_main_settings_fields[iben_elta_main_settings_auto_createv_set_order_completed]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_auto_createv_set_order_completed'] ) ? $options['iben_elta_main_settings_auto_createv_set_order_completed'] : 0, false ) . '/>'; 	
		$html .= '<label for="iben_elta_main_settings_auto_createv_set_order_completed">'. esc_html__( 'Check it, if you want to set order as completed when the voucher will be created. By default, Woocommerce sends the completed email.', 'iben-woo-elta-courier' ).'</label></p>';
		echo $html;
	}
	function iben_elta_main_settings_auto_createv_send_completed_email_email_callback() {

		$options = get_option( 'iben_elta_main_settings_fields' );
		$html = '<p><input type="checkbox" id="iben_elta_main_settings_auto_createv_send_completed_email" name="iben_elta_main_settings_fields[iben_elta_main_settings_auto_createv_send_completed_email]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_auto_createv_send_completed_email'] ) ? $options['iben_elta_main_settings_auto_createv_send_completed_email'] : 0, false ) . '/>'; 	
		$html .= '<label for="iben_elta_main_settings_auto_createv_send_completed_email">'. esc_html__( 'Check it, if you want to send the completed order when voucher will be created. Woocommerce by default sends the completed email when an order changes from processing to completed. If you get 2 completed emails, try to disable this option or add this filter "iben_elta_filter_disable_order_status_completed_notification" as true in your functions.php to disable Woocommerce completed email notification and control it from this plugin', 'iben-woo-elta-courier' ).'</label></p>';
		echo $html;
	}

	function iben_elta_main_settings_auto_createv_resend_admin_email_callback() {

		$options = get_option( 'iben_elta_main_settings_fields' );
		$html = '<p><input type="checkbox" id="iben_elta_main_settings_auto_createv_resend_admin_email" name="iben_elta_main_settings_fields[iben_elta_main_settings_auto_createv_resend_admin_email]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_auto_createv_resend_admin_email'] ) ? $options['iben_elta_main_settings_auto_createv_resend_admin_email'] : 0, false ) . '/>'; 	
		$html .= '<label for="iben_elta_main_settings_auto_createv_resend_admin_email">'. esc_html__( 'Check it, if you want to re send admin email when the voucher created and order is completed. Admin new order email will be resent and voucher will be attached.', 'iben-woo-elta-courier' ).'</label></p>';
		echo $html;
	}


	add_settings_section(
		'iben_elta_main_settings_email_section_before',
		'',
		'iben_elta_new_section_callback',
		'iben_elta_main_settings_fields'
	);

	add_settings_section(
		'iben_elta_main_settings_email_section',
		esc_html__( 'Email tracking code', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_email_section_callback',
		'iben_elta_main_settings_fields'
	);	

	function iben_elta_main_settings_email_section_callback(){
		echo '<p>';	
			echo esc_html__( 'Available global shortcodes for your email templates', 'iben-woo-elta-courier' );
			echo '<br/>';
			echo '<span>prefix_text και suffix_text είναι προαιρετικά. Το ΧΧΧΧ πρέπει να αντικατασταθεί με το ID της παραγγελίας, συνήθως είναι {order_id}</span>';
			echo '<br/>';
			echo '<br/>';
			echo '<b>Εμφανίζει το ιστορικό της ιχνηλάτησης σε λίστα.</b>';
			echo '<br/>';
			echo '<code>[iben_elta_tracing_shortcode order_id="ΧΧΧΧ"]</code>';
			echo '<br/>';
			echo '<br/>';
			echo '<b>Εμφανίζει τον αριθμό αποστολής (εαν έχει δημιουργηθεί voucher στην παραγγελία, αλλιώς εμφανίζει κενό).</b>';
			echo '<br/>';
			echo '<code>[iben_elta_tracking_number_shortcode order_id="ΧΧΧΧ" prefix_text = "Κείμενο πριν τα link" suffix_text = "Κείμενο μετά τα link" ]</code>';
			echo '<br/>';
			echo '<br/>';
			echo '<b>Εμφανίζει το όνομα της Κούριερ (εαν έχει δημιουργηθεί voucher στην παραγγελία, αλλιώς εμφανίζει κενό) .</b>';
			echo '<br/>';
			echo '<span>Διαθέσιμο filter για την αλλαγή του ονόματος: iben_elta_courier_name_shortcode_filter. </span>';
			
			echo '<br/>';
			echo '<code>[iben_elta_courier_name_shortcode order_id="ΧΧΧΧ" prefix_text = "Κείμενο πριν τα link" suffix_text = "Κείμενο μετά τα link" ]</code>';
			echo '<br/>';
		echo '</p>';
	}	
	
	add_settings_field(
		'iben_elta_main_settings_email_completed',
		esc_html__( 'Enable sending tracking code', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_email_completed_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_email_section'
	);

	add_settings_field(
		'iben_elta_main_settings_email_checked_default_completed',
		esc_html__( 'Default checkbox status', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_email_checked_default_completed_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_email_section'
	);

	add_settings_field(
		'iben_elta_main_settings_email_default_body',
		esc_html__( 'Customer\'s message', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_email_default_body_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_email_section'
	);	

	add_settings_section(
		'iben_elta_main_settings_various_section_before',
		'',
		'iben_elta_new_section_callback',
		'iben_elta_main_settings_fields'
	);

	add_settings_section(
		'iben_elta_main_settings_various_section',
		esc_html__( 'Automatically check delivery', 'iben-woo-elta-courier' ),
		'',
		'iben_elta_main_settings_fields'
	);


	add_settings_field(
		'iben_elta_main_settings_enable_cron_check_delivery',
		esc_html__( 'Enable automatically delivery checking', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_enable_cron_check_delivery_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_various_section'
	);	
	add_settings_field(
		'iben_elta_main_settings_cron_check_time',
		esc_html__( 'Select cron time', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_cron_check_time_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_various_section'
	);

	add_settings_field(	
		'iben_elta_main_settings_cron_query_limit',						
		esc_html__( 'Select limit of query', 'iben-woo-elta-courier' ),							
		'iben_elta_main_settings_cron_query_limit_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_various_section'
	);		

	add_settings_field(	
		'iben_elta_main_settings_enable_email_cron_notification',						
		esc_html__( 'Enable email notification', 'iben-woo-elta-courier' ),							
		'iben_elta_main_settings_enable_email_cron_notification_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_various_section'
	);		

	add_settings_field(	
		'iben_elta_main_settings_admin_email_cron_notification',						
		esc_html__( 'Change email cron notification', 'iben-woo-elta-courier' ),							
		'iben_elta_main_settings_admin_email_cron_notification_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_various_section'
	);		

	add_settings_field(	
		'iben_elta_main_settings_cron_change_order_status',						
		esc_html__( 'Change order status', 'iben-woo-elta-courier' ),							
		'iben_elta_main_settings_cron_change_order_status_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_various_section'
	);		
	
	add_settings_section(
		'iben_elta_main_settings_auto_delete_pdf_cron_section_before',
		'',
		'iben_elta_new_section_callback',
		'iben_elta_main_settings_fields'
	);

	add_settings_section(
		'iben_elta_main_settings_auto_delete_pdf_cron_section',
		esc_html__( 'Automatically delete PDF of delivered vouchers', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_delete_pdf_cron_subtitle_callback',
		'iben_elta_main_settings_fields'
	);

	add_settings_field(
		'iben_elta_main_settings_delete_pdf_cron_enable',
		esc_html__( 'Enable PDF deletions', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_delete_pdf_cron_enable_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_auto_delete_pdf_cron_section'
	);	

	add_settings_field(
		'iben_elta_main_settings_delete_pdf_cron_check_time',
		esc_html__( 'Choose running frequency', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_delete_pdf_cron_check_time_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_auto_delete_pdf_cron_section'
	);	

	add_settings_field(	
		'iben_elta_main_settings_delete_pdf_cron_query',						
		esc_html__( 'Choose status', 'iben-woo-elta-courier' ),							
		'iben_elta_main_settings_delete_pdf_cron_query_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_auto_delete_pdf_cron_section'
	);	



	add_settings_section(
		'iben_elta_main_settings_frontend_tracking_section_before',
		'',
		'iben_elta_new_section_callback',
		'iben_elta_main_settings_fields'
	);

	add_settings_section(
		'iben_elta_main_settings_frontend_tracking_section',
		esc_html__( 'Frontend settings (My account)', 'iben-woo-elta-courier' ),
		'',
		'iben_elta_main_settings_fields'
	);


	add_settings_field(
		'iben_elta_main_settings_frontend_tracking_action_link_enable',
		esc_html__( 'Enable tracking link on orders list', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_frontend_tracking_action_link_enable_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_frontend_tracking_section'
	);	

	function iben_elta_main_settings_frontend_tracking_action_link_enable_callback() {
	
		$options = get_option( 'iben_elta_main_settings_fields' );
		$html = '<p><input type="checkbox" id="iben_elta_main_settings_frontend_tracking_action_link_enable" name="iben_elta_main_settings_fields[iben_elta_main_settings_frontend_tracking_action_link_enable]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_frontend_tracking_action_link_enable'] ) ? $options['iben_elta_main_settings_frontend_tracking_action_link_enable'] : 0, false ) . '/>'; 	
		$html .= '<label for="iben_elta_main_settings_frontend_tracking_action_link_enable">'. esc_html__( 'Check it, if you want to display an action link on customer account orders list page.', 'iben-woo-elta-courier' ).'</label></p>';	
		echo $html;
	
	}

	add_settings_field(	
		'iben_elta_main_settings_frontend_tracking_action_link_text',						
		esc_html__( 'Prefix text of tracking link', 'iben-woo-elta-courier' ),							
		'iben_elta_main_settings_frontend_tracking_action_link_text_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_frontend_tracking_section'
	);	

	function iben_elta_main_settings_frontend_tracking_action_link_text_callback() {
	
		$options = get_option( 'iben_elta_main_settings_fields' );
		echo '<p><input type="text" id="iben_elta_main_settings_frontend_tracking_action_link_text" name="iben_elta_main_settings_fields[iben_elta_main_settings_frontend_tracking_action_link_text]" value="' . (empty($options['iben_elta_main_settings_frontend_tracking_action_link_text']) && !isset($options['iben_elta_main_settings_frontend_tracking_action_link_text']) ? 'ΕΛΤΑ Ιχνηλάτηση:' : $options['iben_elta_main_settings_frontend_tracking_action_link_text']) . '" /></p>';
		echo '<p>'.esc_html__( 'Delete to disable prefix', 'iben-woo-elta-courier' ) .'</b></p>';
		
	}


	add_settings_field(
		'iben_elta_main_settings_frontend_view_order_tracking_tracing_enable',
		esc_html__( 'Enable voucher tracing on view order', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_frontend_view_order_tracking_tracing_enable_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_frontend_tracking_section'
	);	

	function iben_elta_main_settings_frontend_view_order_tracking_tracing_enable_callback() {
	
		$options = get_option( 'iben_elta_main_settings_fields' );
		$html = '<p><input type="checkbox" id="iben_elta_main_settings_frontend_view_order_tracking_tracing_enable" name="iben_elta_main_settings_fields[iben_elta_main_settings_frontend_view_order_tracking_tracing_enable]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_frontend_view_order_tracking_tracing_enable'] ) ? $options['iben_elta_main_settings_frontend_view_order_tracking_tracing_enable'] : 0, false ) . '/>'; 	
		$html .= '<label for="iben_elta_main_settings_frontend_view_order_tracking_tracing_enable">'. esc_html__( 'Check it, if you want το display voucher tracing of the order.', 'iben-woo-elta-courier' ).'</label></p>';	
		echo $html;
	}
	add_settings_field(	
		'iben_elta_main_settings_frontend_view_order_tracking_tracing_title',						
		esc_html__( 'Change title of tracing block', 'iben-woo-elta-courier' ),							
		'iben_elta_main_settings_frontend_view_order_tracking_tracing_title_callback',	
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_frontend_tracking_section'
	);	

	function iben_elta_main_settings_frontend_view_order_tracking_tracing_title_callback() {
	
		$options = get_option( 'iben_elta_main_settings_fields' );
		echo '<p><input type="text" id="iben_elta_main_settings_frontend_view_order_tracking_tracing_title" name="iben_elta_main_settings_fields[iben_elta_main_settings_frontend_view_order_tracking_tracing_title]" value="' . (empty($options['iben_elta_main_settings_frontend_view_order_tracking_tracing_title']) && !isset($options['iben_elta_main_settings_frontend_view_order_tracking_tracing_title']) ? 'ΕΛΤΑ κούριερ' : $options['iben_elta_main_settings_frontend_view_order_tracking_tracing_title']) . '" /></p>';
		echo '<p>'.esc_html__( 'Delete to disable title', 'iben-woo-elta-courier' ) .'</b></p>';
		
	}	
	
	
	if (class_exists('Iben_Sms_Lexicon_Admin_Woo')) {
	add_settings_section(
		'iben_elta_main_settings_single_order_sms_section',
		esc_html__( 'Single create voucher (SMS settings V>=1.1.7)', 'iben-woo-elta-courier' ),
		'',
		'iben_elta_main_settings_fields'
	);

	add_settings_field(
		'iben_elta_main_settings_single_order_sms_enable',
		esc_html__( 'Enable SMS form into popup window', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_single_order_sms_enable_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_single_order_sms_section'
	);	

	function iben_elta_main_settings_single_order_sms_enable_callback() {
	
		$options = get_option( 'iben_elta_main_settings_fields' );
		$html = '<p><input type="checkbox" id="iben_elta_main_settings_single_order_sms_enable" name="iben_elta_main_settings_fields[iben_elta_main_settings_single_order_sms_enable]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_single_order_sms_enable'] ) ? $options['iben_elta_main_settings_single_order_sms_enable'] : 0, false ) . '/>'; 	
		$html .= '<label for="iben_elta_main_settings_single_order_sms_enable">'. esc_html__( 'Check it, if you want to display an action link on customer account orders list page.', 'iben-woo-elta-courier' ).'</label></p>';	
		echo $html;
	
	}	
	add_settings_field(
		'iben_elta_main_settings_single_order_sms_enable_default_message',
		esc_html__( 'Default message', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_single_order_sms_enable_default_message_callback',
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_single_order_sms_section'
    );		
	function iben_elta_main_settings_single_order_sms_enable_default_message_callback() {
	
		$options = get_option( 'iben_elta_main_settings_fields' );
		
		echo '<p><textarea id="iben_elta_main_settings_single_order_sms_enable_default_message" name="iben_elta_main_settings_fields[iben_elta_main_settings_single_order_sms_enable_default_message]" rows="5" cols="60">' . (empty($options['iben_elta_main_settings_single_order_sms_enable_default_message']) ? '' : $options['iben_elta_main_settings_single_order_sms_enable_default_message']) . '</textarea></p>';		

		echo '<p><b>'.esc_html__( 'Available shortcodes', 'iben-woo-elta-courier' ).'</b>: [iben_elta_sms_voucher], [iben_elta_sms_voucher_with_link]</p>';
		
	
	} 
	}


	add_settings_section(
		'iben_elta_main_settings_footer_before',
		'',
		'iben_elta_new_section_callback',
		'iben_elta_main_settings_fields'
	);

	add_settings_section(
		'iben_elta_main_settings_footer',
		esc_html__( 'Contact list', 'iben-woo-elta-courier' ),
		'iben_elta_main_settings_footer_callback',
		'iben_elta_main_settings_fields'
	);

	register_setting(
		'iben_elta_main_settings_fields',
		'iben_elta_main_settings_fields',
		'iben_elta_general_validate_input'
	);
	
} 
add_action( 'admin_init', 'iben_elta_main_settings' );


function iben_elta_general_validate_input( $input ) {

	// Create our array for storing the validated options
	$output = array();
	
	$exclude = array('iben_elta_main_settings_email_default_body', 'iben_elta_main_settings_auto_createv_admin_body');

	// If auto create voucher is not enabled, then delete from table entries
	if (!array_key_exists('iben_elta_main_settings_auto_createv_enable', $input)) {
		global $wpdb;
		$table_name = $wpdb->prefix . 'iben_elta_voucher_schedule';
		$queries = $wpdb->get_results($wpdb->prepare("SELECT id FROM $table_name LIMIT %d", 2));

		if ($queries){
			$wpdb->query("DELETE FROM $table_name");
			add_settings_error("iben_elta_main_settings_auto_createv_enable", "iben_elta_main_settings_auto_createv_enable-invalid", esc_html__( 'You switched off the auto creation voucher. So the temp order queue deleted.', 'iben-woo-elta-courier' ) );
		}
		
	}
	
	// Loop through each of the incoming options
	foreach( $input as $key => $value ) {

		// || $key != 'iben_elta_main_settings_auto_createv_admin_body'
		// Check to see if the current option has a value. If so, process it.
		if( isset( $input[$key] ) && !in_array($key, $exclude, TRUE) ) {
		
			// Strip all HTML and PHP tags and properly handle quoted strings
			$output[$key] = strip_tags( stripslashes( $input[ $key ] ) );
			
		}else if (isset( $input[$key] ) && in_array($key, $exclude, TRUE) )  {
			
			$allowed_html = array(
				'a' => array(
					'href' => array(),
					'title' => array(),
					'alt' => array(),
				),
				'br' => array(),
				'em' => array(),
				'strong' => array(),
				'ul' => array(),
				'li' => array(),
				'ol' => array(),
				'p' => array(),
				'h1' => array(),
				'h2' => array(),
				'h3' => array(),
				'h4' => array(),
				'h5' => array(),
				'h6' => array(),
				'i' => array(),
			);
			
			$output[$key] = wp_kses($input[ $key ], $allowed_html);

		}else{
			$output[$key] = $input[ $key ];
		}
		
	}
	
	// Return the array processing any additional functions filtered by this action
	return apply_filters( 'iben_elta_general_validate_input', $output, $input );
}

/* ------------------------------------------------------------------------ *
 * Field Callbacks
 * ------------------------------------------------------------------------ */ 

function iben_elta_new_section_callback() {
	
	echo '<p><hr style="border-top: 1px solid #b3b3b3;border-bottom: 1px solid white;    margin: 35px auto;"></p>';
	
} 



function iben_elta_main_settings_section_callback() {

	function iben_checkport($ip, $portt) {
		$fp = @fsockopen($ip, $portt, $errno, $errstr, 0.1);
		if (!$fp) {
			return false;
		} else {
			fclose($fp);
			return true;
		}
	}

	if (!iben_checkport('212.205.47.226','9003')){
		echo '<p style="background-color: red;display: inline-block;padding: 10px;font-weight: bold;">'.esc_html__( 'Outgoing Port 9003:', 'iben-woo-elta-courier' ).' <span style="color:white;">'. esc_html__( 'is NOT enabled', 'iben-woo-elta-courier' ).'</span></p>';			
	}
	
	echo '<p>'.esc_html__( 'All fields required. Contact with your ELTA Courier to give you your credentials', 'iben-woo-elta-courier' ).'</p>';
	echo '<p style="font-weight: bold;">'.esc_html__( 'If you are confident in your credentials and receive an error such as "invalid customer code," you should notify your local ELTA courier that you are attempting to use these credentials for web service access.', 'iben-woo-elta-courier' ).'</p>';
	
	echo '<p>';
		echo '<b>'. sprintf(__( 'Useful instructions <a href="%s" target="_blank">here</a>', 'iben-woo-elta-courier' ),'https://eltacourier-doc.iben.pro/').'</b>';
	echo '</p>';	
} 

function iben_elta_button_settings_section_callback() {
	
	echo '<p>'.esc_html__( 'Change behavior or add actions when the create voucher button is pressed to create a SYDETA. You can skip those actions per order if needed', 'iben-woo-elta-courier' ).'</p>';
		
} 

function iben_elta_automatic_settings_section_callback() {
	
	echo '<p>'.esc_html__( 'When an order is placed, ID order is put in queue if the order status is processing. Then plugin with the WP Cron will check these orders and will try to create the voucher automatically if are free of errors.', 'iben-woo-elta-courier' ).'</p>';
		
} 


function iben_elta_button_settings_create_pdf_callback() {
	

	$options = get_option( 'iben_elta_main_settings_fields' );
	$html = '<p><input type="checkbox" id="iben_elta_button_settings_create_pdf" name="iben_elta_main_settings_fields[iben_elta_button_settings_create_pdf]" value="1" ' . checked( 1, isset( $options['iben_elta_button_settings_create_pdf'] ) ? $options['iben_elta_button_settings_create_pdf'] : 0, false ) . '/>'; 	
	$html .= '<label for="iben_elta_button_settings_create_pdf">'. esc_html__( 'Check it, if you want to create PDF immediately after SYDETA created', 'iben-woo-elta-courier' ).'</label></p>';
	echo $html;
}




function iben_elta_button_settings_create_send_completed_email_callback() {

	$options = get_option( 'iben_elta_main_settings_fields' );
	$html = '<p><input type="checkbox" id="iben_elta_button_settings_create_send_completed_email" name="iben_elta_main_settings_fields[iben_elta_button_settings_create_send_completed_email]" value="1" ' . checked( 1, isset( $options['iben_elta_button_settings_create_send_completed_email'] ) ? $options['iben_elta_button_settings_create_send_completed_email'] : 0, false ) . '/>'; 	
	$html .= '<label for="iben_elta_button_settings_create_send_completed_email">'. esc_html__( 'Check it, if you want to send the completed order when SYDETA created', 'iben-woo-elta-courier' ).'</label></p>';
	$html .= '<p>'. esc_html__( 'Usually this option doesn\'t need enabled. This option will force resend the completed email', 'iben-woo-elta-courier' ).'</p>';
	echo $html;
}




function iben_elta_main_settings_enable_ref_order_callback() {

	$options = get_option( 'iben_elta_main_settings_fields' );

	$html = '<p><input type="checkbox" id="iben_elta_main_settings_enable_ref_order" name="iben_elta_main_settings_fields[iben_elta_main_settings_enable_ref_order]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_enable_ref_order'] ) ? $options['iben_elta_main_settings_enable_ref_order'] : 0, false ) . '/>'; 	
	$html .= '<label for="iben_elta_main_settings_enable_ref_order">'. esc_html__( 'Check it, if you want to automatically add order refference number in ref No field', 'iben-woo-elta-courier' ).'</label></p>';
	
	echo $html;

}

function iben_elta_main_settings_enable_cron_check_delivery_callback() {

	$options = get_option( 'iben_elta_main_settings_fields' );

	$html = '<p><input type="checkbox" id="iben_elta_main_settings_enable_cron_check_delivery" name="iben_elta_main_settings_fields[iben_elta_main_settings_enable_cron_check_delivery]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_enable_cron_check_delivery'] ) ? $options['iben_elta_main_settings_enable_cron_check_delivery'] : 0, false ) . '/>'; 	
	$html .= '<label for="iben_elta_main_settings_enable_cron_check_delivery">'. esc_html__( 'Check it, if you want το enable auto check', 'iben-woo-elta-courier' ).'</label></p>';
	
	//check if DISABLE_WP_CRON is set to true. Usually in config file
	if(defined('DISABLE_WP_CRON')){

		if (DISABLE_WP_CRON){
			echo '<b style="color:red;">'.esc_html__( 'The DISABLE_WP_CRON constant is set to true! Your WP cron wont be run but you can set a cron from your server', 'iben-woo-elta-courier' ).'</b>'; 
		}
	}

	echo $html;

}

function iben_elta_main_settings_delete_pdf_cron_subtitle_callback() {
	$disk_used = iben_foldersize(IBEN_WOO_ELTA_UPLOAD_FOLDER);
	echo '<p><b>'.esc_html__( 'Disk usage of PDFs:', 'iben-woo-elta-courier' ) .' '. iben_format_size($disk_used) . '</b></p>';
}

function iben_elta_main_settings_delete_pdf_cron_enable_callback() {
	
	$options = get_option( 'iben_elta_main_settings_fields' );

	$html = '<p><input type="checkbox" id="iben_elta_main_settings_delete_pdf_cron_enable" name="iben_elta_main_settings_fields[iben_elta_main_settings_delete_pdf_cron_enable]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_delete_pdf_cron_enable'] ) ? $options['iben_elta_main_settings_delete_pdf_cron_enable'] : 0, false ) . '/>'; 	
	$html .= '<label for="iben_elta_main_settings_delete_pdf_cron_enable">'. esc_html__( 'Check it, if you want το enable automatically deletion DPF of delivered vouchers', 'iben-woo-elta-courier' ).'</label></p>';
	
	//check if DISABLE_WP_CRON is set to true. Usually in config file
	if(defined('DISABLE_WP_CRON')){

		if (DISABLE_WP_CRON){
			echo '<b style="color:red;">'.esc_html__( 'The DISABLE_WP_CRON constant is set to true! Your WP cron wont be run but you can set a cron from your server', 'iben-woo-elta-courier' ).'</b>'; 
		}
	}
	
	echo $html;

}


function iben_elta_main_settings_email_completed_callback() {

	$options = get_option( 'iben_elta_main_settings_fields' );

	$html = '<p><input type="checkbox" id="iben_elta_main_settings_email_completed" name="iben_elta_main_settings_fields[iben_elta_main_settings_email_completed]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_email_completed'] ) ? $options['iben_elta_main_settings_email_completed'] : 0, false ) . '/>'; 	
	$html .= '<label for="iben_elta_main_settings_email_completed">'. esc_html__( 'Check it, if you want to include below message to the customer\'s email when the order will change to completed.', 'iben-woo-elta-courier' ).'</label></p>';
	
	echo $html;

}


function iben_elta_main_settings_email_checked_default_completed_callback() {

	$options = get_option( 'iben_elta_main_settings_fields' );
	
	$html = '<p><select id="iben_elta_main_settings_email_checked_default_completed" name="iben_elta_main_settings_fields[iben_elta_main_settings_email_checked_default_completed]">';
		$html .= '<option value="0"' . selected( $options['iben_elta_main_settings_email_checked_default_completed'], '0', false) . '>' . esc_html__( 'Unchecked', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="1"' . selected( $options['iben_elta_main_settings_email_checked_default_completed'], '1', false) . '>' . esc_html__( 'Checked', 'iben-woo-elta-courier' ) . '</option>';
	$html .= '</select></p>';
	$html .= '<p>'.esc_html__( 'Default checkbox status for each new order.', 'iben-woo-elta-courier' ).'</p>';
	echo $html;
}


function iben_elta_main_settings_email_default_body_callback() {

	$options = get_option( 'iben_elta_main_settings_fields' );

	$settings = array( 
		'textarea_name' => 'iben_elta_main_settings_fields[iben_elta_main_settings_email_default_body]',
		'tinymce'=>array(
			'toolbar1' => 'formatselect,bold,italic,bullist,numlist,alignleft,aligncenter,alignright,alignjustify,outdent,indent,removeformat',
		  ),
		'media_buttons' => false,
		'wpautop' =>false,
		'teeny' => false,
		'textarea_rows' => 6,
		'quicktags' => array( 'buttons' => 'strong,em,link,ul,ol,li' )
	
	);


	$body = '<h2>Παρακολούθηση δέματος</h2>
		<p>Το δέμα σας απεστάλει με τα ΕΛΤΑ κούριερ. </p>
		<p>Ο αριθμός αποστολής είναι: [iben_elta_tracking]</p>';

	if ( isset($options['iben_elta_main_settings_email_default_body']) && $options['iben_elta_main_settings_email_default_body'] != '' && $options['iben_elta_main_settings_email_default_body'] != $body){
		$body = $options['iben_elta_main_settings_email_default_body'];
	}

	echo wp_editor( $body, 'iben_elta_main_settings_email_default_body', $settings  );

	echo '<p><b>'.esc_html__( 'Available Shortcode', 'iben-woo-elta-courier' ).': </b>[iben_elta_tracking] -><a href="https://www.elta-courier.gr/search?br=NZ000260031GR" >NZ000260031GR</a></p>';


}


function iben_elta_main_settings_footer_callback() {
	

echo '<h4>'.esc_html__( 'Remove all unnecessary bulk compined PDFs and delivered PDF of vouchers except last 1 month', 'iben-woo-elta-courier' ) .'</h4>';
?>
<div class="iben_elta_settings_remove_bulk_spinner iben_elta_spinners" style="display:none; margin: 0px;"><div class="bounce1"></div><div class="bounce2"></div><div class="bounce3"></div></div>
<?php
echo '<p><button id="iben_elta_settings_remove_bulk" class="button secondary-button">'.esc_html__( 'Remove Bulk PDFs', 'iben-woo-elta-courier' ) .'</button></p>';

echo '<h4><a href="' . admin_url( 'admin.php?page=iben_woo_elta_contacts' ) . '">'. esc_html__('Contacts list', 'iben-woo-elta-courier') .'</a> - <a href="' . admin_url( 'admin.php?page=iben_woo_elta_import_contacts' ) . '">'. esc_html__('Import contacts', 'iben-woo-elta-courier') .'</a></h4>';
} 

function iben_elta_main_settings_customer_callback() {

	$options = get_option( 'iben_elta_main_settings_fields' );
	echo '<p><input type="text" id="iben_elta_main_settings_customer" name="iben_elta_main_settings_fields[iben_elta_main_settings_customer]" value="' . (empty($options['iben_elta_main_settings_customer']) ? '' : $options['iben_elta_main_settings_customer']) . '" /></p><br> (PEL-APOST-CODE)';


} 

function iben_elta_main_settings_username_callback() {

	$options = get_option( 'iben_elta_main_settings_fields' );
	echo '<p><input type="text" id="iben_elta_main_settings_username" name="iben_elta_main_settings_fields[iben_elta_main_settings_username]" value="' . (empty($options['iben_elta_main_settings_username']) ? '' : $options['iben_elta_main_settings_username']) . '" /></p><br>(PEL-USER-CODE)';
	
	if ( !isset($options['iben_elta_main_settings_username']) || $options['iben_elta_main_settings_username'] == '' ){

		echo '<p>'.esc_html__( 'User name must be always 7 characters. If its not add on front of it zeros (0)', 'iben-woo-elta-courier' ) .'</p>';

	}elseif( isset($options['iben_elta_main_settings_username']) && strlen($options['iben_elta_main_settings_username']) != 7  ){
		echo '<p>'.esc_html__( 'Username is not 7 characters. Let me try to fix it', 'iben-woo-elta-courier' ) .': <a href= "#" class = "iben_elta_fix_username">'.esc_html__( 'Click to fix it', 'iben-woo-elta-courier' ) .'</a><br/><b> '.esc_html__( 'and then click save', 'iben-woo-elta-courier' ) .'</b></p>';
	}

} 

function iben_elta_main_settings_password_callback() {
	
	$options = get_option( 'iben_elta_main_settings_fields' );
	echo '<p><input type="password" id="iben_elta_main_settings_password" name="iben_elta_main_settings_fields[iben_elta_main_settings_password]" value="' . (empty($options['iben_elta_main_settings_password']) ? '' : $options['iben_elta_main_settings_password']) . '" /></p><br>(PEL-USER-PASS)';
	
} 

function iben_elta_main_settings_sub_password_callback() {
	
	$options = get_option( 'iben_elta_main_settings_fields' );
	echo '<p><input type="text" id="iben_elta_main_settings_sub_password" name="iben_elta_main_settings_fields[iben_elta_main_settings_sub_password]" value="' . (empty($options['iben_elta_main_settings_sub_password']) ? '' : $options['iben_elta_main_settings_sub_password']) . '" /></p>';
	echo '<p>'.esc_html__( 'Leave it empty if you dont know', 'iben-woo-elta-courier' ) .'</b></p>';
	
} 

	function iben_elta_main_settings_enable_test_mode_callback() {

		$options = get_option( 'iben_elta_main_settings_fields' );
		
		$html = '<p><input type="checkbox" id="iben_elta_main_settings_enable_test_mode" name="iben_elta_main_settings_fields[iben_elta_main_settings_enable_test_mode]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_enable_test_mode'] ) ? $options['iben_elta_main_settings_enable_test_mode'] : 0, false ) . '/>'; 	
		$html .= '<label for="iben_elta_main_settings_enable_test_mode">'. esc_html__( 'Check it, if you want to enable test mode. Remember that it requires a different set of credentials than your production logins.', 'iben-woo-elta-courier' ).'</label></p>';
		
		echo $html;
	
	}
	function iben_elta_main_settings_2nd_enable_account_callback() {

		$options = get_option( 'iben_elta_main_settings_fields' );
		
		$html = '<p><input type="checkbox" id="iben_elta_main_settings_2nd_enable_account" name="iben_elta_main_settings_fields[iben_elta_main_settings_2nd_enable_account]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_2nd_enable_account'] ) ? $options['iben_elta_main_settings_2nd_enable_account'] : 0, false ) . '/>'; 	
		$html .= '<label for="iben_elta_main_settings_2nd_enable_account">'. esc_html__( 'Check it, if you want to enable a  2nd ELTA account', 'iben-woo-elta-courier' ).'</label></p>';
		
		echo $html;
	
	}
	
	function iben_elta_main_settings_2nd_customer_callback() {
	
	$options = get_option( 'iben_elta_main_settings_fields' );
	echo '<p><input type="text" id="iben_elta_main_settings_2nd_customer" name="iben_elta_main_settings_fields[iben_elta_main_settings_2nd_customer]" value="' . (empty($options['iben_elta_main_settings_2nd_customer']) ? '' : $options['iben_elta_main_settings_2nd_customer']) . '" /></p>';
	
	} 
	
	function iben_elta_main_settings_2nd_username_callback() {
	
	$options = get_option( 'iben_elta_main_settings_fields' );
	echo '<p><input type="text" id="iben_elta_main_settings_2nd_username" name="iben_elta_main_settings_fields[iben_elta_main_settings_2nd_username]" value="' . (empty($options['iben_elta_main_settings_2nd_username']) ? '' : $options['iben_elta_main_settings_2nd_username']) . '" /></p>';
	
	if ( !isset($options['iben_elta_main_settings_2nd_username']) || $options['iben_elta_main_settings_2nd_username'] == '' ){
	
		echo '<p>'.esc_html__( 'User name must be always 7 characters. If its not add on front of it zeros (0)', 'iben-woo-elta-courier' ) .'</p>';
	
	}elseif( isset($options['iben_elta_main_settings_2nd_username']) && strlen($options['iben_elta_main_settings_2nd_username']) != 7  ){
		echo '<p>'.esc_html__( 'Username is not 7 characters. Let me try to fix it', 'iben-woo-elta-courier' ) .': <a href= "#" class = "iben_elta_fix_2nd_username">'.esc_html__( 'Click to fix it', 'iben-woo-elta-courier' ) .'</a><br/><b> '.esc_html__( 'and then click save', 'iben-woo-elta-courier' ) .'</b></p>';
	}
	
	} 
	
	function iben_elta_main_settings_2nd_password_callback() {
		
		$options = get_option( 'iben_elta_main_settings_fields' );
		echo '<p><input type="password" id="iben_elta_main_settings_2nd_password" name="iben_elta_main_settings_fields[iben_elta_main_settings_2nd_password]" value="' . (empty($options['iben_elta_main_settings_2nd_password']) ? '' : $options['iben_elta_main_settings_2nd_password']) . '" /></p>';
		
	} 
	
	function iben_elta_main_settings_2nd_sub_password_callback() {
		
		$options = get_option( 'iben_elta_main_settings_fields' );
		echo '<p><input type="text" id="iben_elta_main_settings_2nd_sub_password" name="iben_elta_main_settings_fields[iben_elta_main_settings_2nd_sub_password]" value="' . (empty($options['iben_elta_main_settings_2nd_sub_password']) ? '' : $options['iben_elta_main_settings_2nd_sub_password']) . '" /></p>';
		echo '<p>'.esc_html__( 'Leave it empty if you dont know', 'iben-woo-elta-courier' ) .'</b></p>';
		
	}
	

function iben_elta_main_settings_papersize_callback() {
	
	$options = get_option( 'iben_elta_main_settings_fields' );
	
	$html = '<p><select id="iben_elta_main_settings_papersize" name="iben_elta_main_settings_fields[iben_elta_main_settings_papersize]">';
				
		$html .= '<option value="1"' . selected( $options['iben_elta_main_settings_papersize'], '1', false) . '>' . esc_html__( 'A6', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="0"' . selected( $options['iben_elta_main_settings_papersize'], '0', false) . '>' . esc_html__( 'A4', 'iben-woo-elta-courier' ) . '</option>';
		
	$html .= '</select></p>';
	
	echo $html;

}

function iben_elta_main_settings_cron_check_time_callback() {
	
	$options = get_option( 'iben_elta_main_settings_fields' );
	
	$html = '<p><select id="iben_elta_main_settings_cron_check_time" name="iben_elta_main_settings_fields[iben_elta_main_settings_cron_check_time]">';
				
		$html .= '<option value="iben-elta-2-minutes"' . selected( $options['iben_elta_main_settings_cron_check_time'], 'iben-elta-2-minutes', false) . '>' . esc_html__( 'Every 2 minutes', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="iben-elta-15-minutes"' . selected( $options['iben_elta_main_settings_cron_check_time'], 'iben-elta-15-minutes', false) . '>' . esc_html__( 'Every 15 minutes', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="iben-elta-30-minutes"' . selected( $options['iben_elta_main_settings_cron_check_time'], 'iben-elta-30-minutes', false) . '>' . esc_html__( 'Every 30 minutes', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="hourly"' . selected( $options['iben_elta_main_settings_cron_check_time'], 'hourly', false) . '>' . esc_html__( 'Hourly (1 hour) - Recommended', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="iben-elta-2-hours"' . selected( $options['iben_elta_main_settings_cron_check_time'], 'iben-elta-2-hours', false) . '>' . esc_html__( 'Every 2 hours', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="iben-elta-4-hours"' . selected( $options['iben_elta_main_settings_cron_check_time'], 'iben-elta-4-hours', false) . '>' . esc_html__( 'Every 4 hours', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="twicedaily"' . selected( $options['iben_elta_main_settings_cron_check_time'], 'twicedaily', false) . '>' . esc_html__( 'Twice Daily', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="daily"' . selected( $options['iben_elta_main_settings_cron_check_time'], 'daily', false) . '>' . esc_html__( 'Once Daily', 'iben-woo-elta-courier' ) . '</option>';
		
	$html .= '</select></p>';
	
	echo $html;

}

function iben_elta_main_settings_delete_pdf_cron_check_time_callback() {
	
	$options = get_option( 'iben_elta_main_settings_fields' );

	$html = '<p><select id="iben_elta_main_settings_delete_pdf_cron_check_time" name="iben_elta_main_settings_fields[iben_elta_main_settings_delete_pdf_cron_check_time]">';
		
		$html .= '<option value="iben-elta-15-minutes"' . selected( $options['iben_elta_main_settings_delete_pdf_cron_check_time'], 'iben-elta-15-minutes', false) . '>' . esc_html__( 'Every 15 minutes', 'iben-woo-elta-courier' ) . '</option>';				
		$html .= '<option value="daily"' . selected( $options['iben_elta_main_settings_delete_pdf_cron_check_time'], 'daily', false) . '>' . esc_html__( 'Once Daily', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="iben-elta-3-days"' . selected( $options['iben_elta_main_settings_delete_pdf_cron_check_time'], 'iben-elta-3-days', false) . '>' . esc_html__( 'Every 3 days - Recommended', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="iben-elta-1-week"' . selected( $options['iben_elta_main_settings_delete_pdf_cron_check_time'], 'iben-elta-1-week', false) . '>' . esc_html__( 'Weekly', 'iben-woo-elta-courier' ) . '</option>';
		
	$html .= '</select></p>';
	
	echo $html;

}

function iben_elta_main_settings_default_weight_callback() {
	
	$options = get_option( 'iben_elta_main_settings_fields' );
	echo '<p><input type="text" id="iben_elta_main_settings_default_weight" name="iben_elta_main_settings_fields[iben_elta_main_settings_default_weight]" value="' . (empty($options['iben_elta_main_settings_default_weight']) ? '' : $options['iben_elta_main_settings_default_weight']) . '" /></p>';
	echo '<p>'.esc_html__( 'Leave it empty if you dont want to apply default weight at voucher and let caclulate weights per product', 'iben-woo-elta-courier' ) .'</b></p>';
	
} 

function iben_elta_main_settings_cron_query_limit_callback() {
	
	$options = get_option( 'iben_elta_main_settings_fields' );
	
	$html = '<p><select id="iben_elta_main_settings_cron_query_limit" name="iben_elta_main_settings_fields[iben_elta_main_settings_cron_query_limit]">';
				
		$html .= '<option value="5"' . selected( $options['iben_elta_main_settings_cron_query_limit'], '5', false) . '>' . esc_html__( '5', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="10"' . selected( $options['iben_elta_main_settings_cron_query_limit'], '10', false) . '>' . esc_html__( '10', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="20"' . selected( $options['iben_elta_main_settings_cron_query_limit'], '20', false) . '>' . esc_html__( '20', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="30"' . selected( $options['iben_elta_main_settings_cron_query_limit'], '30', false) . '>' . esc_html__( '30', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="40"' . selected( $options['iben_elta_main_settings_cron_query_limit'], '40', false) . '>' . esc_html__( '40 - Recommended', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="50"' . selected( $options['iben_elta_main_settings_cron_query_limit'], '50', false) . '>' . esc_html__( '50', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="80"' . selected( $options['iben_elta_main_settings_cron_query_limit'], '80', false) . '>' . esc_html__( '80', 'iben-woo-elta-courier' ) . '</option>';
		
	$html .= '</select></p>';
	$html .= '<p>'.esc_html__( 'Select a number, which is the maximum limit of vouchers will be checked each cron job', 'iben-woo-elta-courier' ) .'</b></p>';
	
	echo $html;
} 

function iben_elta_main_settings_delete_pdf_cron_query_callback() {
	
	$options = get_option( 'iben_elta_main_settings_fields' );
	
	$html = '<p><select id="iben_elta_main_settings_delete_pdf_cron_query" name="iben_elta_main_settings_fields[iben_elta_main_settings_delete_pdf_cron_query]">';
				
		$html .= '<option value="1"' . selected( $options['iben_elta_main_settings_delete_pdf_cron_query'], '1', false) . '>' . esc_html__( 'All delivered', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="2"' . selected( $options['iben_elta_main_settings_delete_pdf_cron_query'], '2', false) . '>' . esc_html__( 'All delivered except for last 1 week - Recommended', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="3"' . selected( $options['iben_elta_main_settings_delete_pdf_cron_query'], '3', false) . '>' . esc_html__( 'All delivered except for last 2 weeks', 'iben-woo-elta-courier' ) . '</option>';
		$html .= '<option value="4"' . selected( $options['iben_elta_main_settings_delete_pdf_cron_query'], '4', false) . '>' . esc_html__( 'All delivered except for last 1 month', 'iben-woo-elta-courier' ) . '</option>';
		
	$html .= '</select></p>';
	$html .= '<p>'.esc_html__( 'For performance reasons each time run, maximum limit is 50', 'iben-woo-elta-courier' ) .'</b></p>';
	
	echo $html;
} 


function iben_elta_main_settings_enable_email_cron_notification_callback() {

	$options = get_option( 'iben_elta_main_settings_fields' );

	$html = '<p><input type="checkbox" id="iben_elta_main_settings_enable_email_cron_notification" name="iben_elta_main_settings_fields[iben_elta_main_settings_enable_email_cron_notification]" value="1" ' . checked( 1, isset( $options['iben_elta_main_settings_enable_email_cron_notification'] ) ? $options['iben_elta_main_settings_enable_email_cron_notification'] : 0, false ) . '/>'; 	
	$html .= '<label for="iben_elta_main_settings_enable_email_cron_notification">'. esc_html__( 'Check it, if you want to receive an email notification each time cron run AND there are delivered packages.', 'iben-woo-elta-courier' ).'</label></p>';
	
	echo $html;

}

function iben_elta_main_settings_admin_email_cron_notification_callback() {
	
	$options = get_option( 'iben_elta_main_settings_fields' );
	echo '<p><input type="text" id="iben_elta_main_settings_admin_email_cron_notification" name="iben_elta_main_settings_fields[iben_elta_main_settings_admin_email_cron_notification]" value="' . (empty($options['iben_elta_main_settings_admin_email_cron_notification']) ? get_option( 'admin_email' ) : $options['iben_elta_main_settings_admin_email_cron_notification']) . '" /></p>';
	echo '<p>'.esc_html__( 'Change email to get delivered packages. Only 1 email', 'iben-woo-elta-courier' ) .'</b></p>';
	
} 

function iben_elta_main_settings_cron_change_order_status_callback() {
	$status = wc_get_order_statuses();
	$options = get_option( 'iben_elta_main_settings_fields' );
	$html = '<p><select id="iben_elta_main_settings_cron_change_order_status" name="iben_elta_main_settings_fields[iben_elta_main_settings_cron_change_order_status]">';
		
		$html .= '<option value="-1">'.esc_html__( 'DISABLED', 'iben-woo-elta-courier' ) .'</option>';
		foreach($status as $key=>$stat){	
			$html .= '<option value="' .$key. '"' . selected( $options['iben_elta_main_settings_cron_change_order_status'], $key, false) . '>' .$stat. '</option>';
		}
		
	$html .= '</select></p>';
	$html .= '<p>'.esc_html__( 'If an order has mulitple vouchers, then all vouchers need to be delivered to change the order status', 'iben-woo-elta-courier' ) .'</b></p>';

	echo $html;

} 





function iben_foldersize($path) {
    $total_size = 0;
    $files = scandir($path);
    $cleanPath = rtrim($path, '/'). '/';

    foreach($files as $t) {
        if ($t<>"." && $t<>"..") {
            $currentFile = $cleanPath . $t;
            if (is_dir($currentFile)) {
                $size = iben_foldersize($currentFile);
                $total_size += $size;
            }
            else {
                $size = filesize($currentFile);
                $total_size += $size;
            }
        }   
    }

    return $total_size;
}
function iben_format_size($size) {

	$units = explode(' ', 'B KB MB GB TB PB');
    $mod = 1024;

    for ($i = 0; $size > $mod; $i++) {
        $size /= $mod;
    }

    $endIndex = strpos($size, ".")+3;

    return substr( $size, 0, $endIndex).' '.$units[$i];
}



// add settings links to admin plugin list
add_action( 'plugin_action_links_' . IBEN_WOO_ELTA_BASENAME, 'iben_elta_add_plugin_links' );
function iben_elta_add_plugin_links ( $links ) {

	$mylinks = array(
		'<a href="' . admin_url( 'options-general.php?page=iben_woo_elta_courier' ) . '">'. esc_html__('Settings', 'iben-woo-elta-courier') .'</a>',
		'<a href="' . admin_url( 'admin.php?page=iben_woo_elta_vouchers' ) . '">'. esc_html__('ELTA Vouchers', 'iben-woo-elta-courier') .'</a>',
		'<a href="https://iben.pro/eltacouriersetup_gr/" target="_blank">'. esc_html__('Setup instructions', 'iben-woo-elta-courier') .'</a>'		
	);
	return array_merge( $links, $mylinks );
}


if (class_exists('Automattic\WooCommerce\Utilities\OrderUtil') && Automattic\WooCommerce\Utilities\OrderUtil::custom_orders_table_usage_is_enabled()) {
	add_action( 'woocommerce_order_list_table_extra_tablenav', 'admin_elta_order_list_top_bar_button_hpos', 20, 2 );
}else{
	add_action( 'manage_posts_extra_tablenav', 'admin_elta_order_list_top_bar_create_voucher', 20, 1 );
}

function admin_elta_order_list_top_bar_button_hpos( $typenow, $which ) {
    
    if ($typenow === 'shop_order' && 'top' === $which) {
		
		echo admin_elta_order_list_top_bar_content('id');

    }
}

function admin_elta_order_list_top_bar_create_voucher( $which ) {
    
	global $typenow;
    if ('shop_order' === $typenow && 'top' === $which) {
		
		echo admin_elta_order_list_top_bar_content('post');

    }
}


function admin_elta_order_list_top_bar_content($idcolumn){
	ob_start(); 

	add_thickbox(); 
	?>
	<div class="actions iben_elta_actions" >
		<span>
			<button class ="button iben_elta_order_list_bulk_create_voucher" class="button" data-idcolumn =<?php esc_html_e($idcolumn);?> value=""><?php esc_html_e( 'Bulk Generate Shipments & Print (ELTA)', 'iben-woo-elta-courier' ); ?></button>
			<div class="iben_elta_order_list_bulk_create_voucher_spinner iben_elta_spinners" style="display:none;"><div class="bounce1"></div><div class="bounce2"></div><div class="bounce3"></div></div>
			<span id ="iben_elta_create_multipdfs_response"></span>
		</span>
		<span>
			<button class ="button iben_elta_order_list_bulk_reprint" class="button" data-idcolumn =<?php esc_html_e($idcolumn);?> value=""><?php esc_html_e( 'Combine & Print (ELTA)', 'iben-woo-elta-courier' ); ?></button>
			<div class="iben_elta_order_list_bulk_reprint_spinner iben_elta_spinners" style="display:none;"><div class="bounce1"></div><div class="bounce2"></div><div class="bounce3"></div></div>
			<span id ="iben_compine_multipdfs_response"></span>
		</span>

		<span>
			<a href="#TB_inline=true&width=900&height=700&inlineId=iben_elta_order_create_voucher_modal_single" data-id_order = "order" class="button thickbox iben_elta_voucher_create_single_modal_trigger" title ="<?php esc_html_e('Create Single Shipment (ELTA)', 'iben-woo-elta-courier'); ?>"><?php esc_html_e('Create Single Shipment (ELTA)', 'iben-woo-elta-courier'); ?></a>
			<div class= "iben_elta_order_create_voucher_modal" id="iben_elta_order_create_voucher_modal_single" style="display:none;">
				<div class= "iben_elta_voucher_create_modal_response_single" id ="iben_elta_voucher_create_modal_response_single"></div>
			</div>	
		</span>

	</div>
	<?php
	return ob_get_clean();
}

?>