<?php
if ( ! defined( 'WPINC' ) ) {
	wp_die();
}

if ( ! class_exists( 'Get_Elta_Voucher_List_Table' ) ) {
    /**
     * The admin-specific functionality of the plugin.
     *
     * @link       https://iben.pro
     * @since      1.0.0
     *
     * @package    Iben_Woo_Elta_Courier
     * @subpackage Iben_Woo_Elta_Courier/admin/partials
     */


    class Get_Elta_Voucher_List_Table extends WP_List_Table{
        


        /**
        * [REQUIRED] You must declare constructor and give some basic params
        */
        function __construct()
        {
            global $status, $page;

            parent::__construct(array(
                'singular' => 'voucher',
                'plural' => 'voucherss',
            ));

        }

        /**
            * [REQUIRED] this is a default column renderer
            *
            * @param $item - row (key, value array)
            * @param $column_name - string (key)
            * @return HTML
            */
        function column_default($item, $column_name)
        {
            return $item[$column_name];
        }

        /**
            * [OPTIONAL] this is example, how to render specific column
            *
            * method name must be like this: "column_[column_name]"
            *
            * @param $item - row (key, value array)
            * @return HTML
            */
        function column_time($item)
        {
            return $datetime = date_i18n(get_option('date_format'), $item['time']) .' | '. date_i18n(get_option('time_format'), $item['time']);
        }

        function column_last_check_delivered_time($item)
        {
           if ($item['last_check_delivered_time'] != 0){
                return $datetime = date_i18n(get_option('date_format'), $item['last_check_delivered_time']) .' | '. date_i18n(get_option('time_format'), $item['last_check_delivered_time']);
           }else{
            return '-';
        }
        }

        /**
            * [OPTIONAL] this is example, how to render column with actions,
            * when you hover row "Edit | Delete" links showed
            *
            * @param $item - row (key, value array)
            * @return HTML
            */


        /**
            * [REQUIRED] this is how checkbox column renders
            *
            * @param $item - row (key, value array)
            * @return HTML
            */
        function column_cb($item)
        {
            return sprintf(
                '<input type="checkbox" name="id[]" value="%s" />',
                $item['id']
            );
        }

        function column_id_order($item){
            if ($item['id_order'] != -1){
                if (defined('WC_VERSION')) {
                    $order = wc_get_order($item['id_order']);
                    if (is_object($order)){
                        if ($order->get_shipping_first_name()){
                            $firstname = $order->get_shipping_first_name();
                        }else{
                            $firstname = $order->get_billing_first_name();
                        }

                        if ($order->get_shipping_last_name()){
                            $lastname = $order->get_shipping_last_name();
                        }else{
                            $lastname = $order->get_billing_last_name();
                        }                    


                        $value = $firstname.' '.$lastname;
                        return sprintf('<a href="post.php?post=%s&action=edit">%s</a>%s', $item['id_order'],  '('.$item['id_order'].') '.$value, '<br/>'.($order->get_order_number() != $item['id_order'] ? $order->get_order_number().'<br/>' : '').$item['logged_user']); 
                    }else{
                        return sprintf('Order %s (Removed)', $item['id_order'], '<br/>'.$item['logged_user']); 
                    
                    }
                }else{
                    return 'WOO is not installed';
                }
            }else{

                $voucher_info = maybe_unserialize($item['elta_voucher_info']);
                
                return $fullname = $voucher_info['fullname'].'<br/>'.$item['logged_user']; ;            
                
            }

            
        }


    
        function column_elta_returned_vouchers($item){

            $vouchers = '';
            $vouchers.='<span id="iben_elta_single_returned_vouchers_response'.$item['id'].'">';

            $get_compined = iben_elta_get_Compined_Returned_Voucher_from_id($item['id']);

            $vouchers_array = json_decode( $item['elta_returned_vouchers'] );
            if( !empty($vouchers_array) && sizeof( $vouchers_array ) != 0 ) {
                

                foreach ($vouchers_array as $voucher) {
                    if ($voucher != ''){

                        $file = IBEN_WOO_ELTA_UPLOAD_FOLDER.$voucher.".pdf";

                        if(is_file($file)){
                            $vouchers.= iben_elta_Voucher_Link($voucher);
                        }else{
                            $vouchers.= $voucher.'<br/>';
                        }  

                    }
                }

            }

            

            if ($get_compined && $item['id_elta_reason'] == 2){
                $file = IBEN_WOO_ELTA_UPLOAD_FOLDER.$get_compined.".pdf";
                if(is_file($file)){
                    $vouchers.= iben_elta_Compined_Voucher_Link($get_compined);
                }

            }
            $vouchers.='</span>';

            if ($item['id_order'] == -1 && $item['id_elta_reason'] == 2) {
                $vouchers.='
                <span class="iben_elta_compine_single id_'.$item['id'].'" style="display: block;align-content: center;align-items: center;">
                    <button type="button" class="button iben_elta_order_button_single_compine_vouchers button-secondary" data-id="'.$item['id'].'" data-id_elta_reason = "2" >'.esc_html__( 'PDF', 'iben-woo-elta-courier' ).'</button>
                    <div class="iben_elta_compine_vouchers_spinner iben_elta_spinners" style="display:none;"><div class="bounce1"></div><div class="bounce2"></div><div class="bounce3"></div></div>
                </span>';
            } 

            return $vouchers;

        }


        function column_elta_delivery_vouchers($item){

            $vouchers = '';

            $vouchers.='<span id="iben_elta_single_vouchers_response'.$item['id'].'">';
            $get_compined = iben_elta_get_Compined_Voucher_from_id($item['id']);

            $vouchers_array = json_decode( $item['elta_delivery_vouchers'] );
            if( !empty($vouchers_array) && sizeof( $vouchers_array ) != 0 ) {
                

                foreach ($vouchers_array as $voucher) {
                    if ($voucher != ''){


                    $file = IBEN_WOO_ELTA_UPLOAD_FOLDER.$voucher.".pdf";

                        if(is_file($file)){
                            $vouchers.= iben_elta_Voucher_Link($voucher);
                        }else{
                            $vouchers.= $voucher.'<br/>';
                        }                    
                    }
                }

            }
            
            if ( $get_compined && $item['id_elta_reason'] == 1 && $item['elta_delivery_compined_vouchers'] != '' ){
                    $file = IBEN_WOO_ELTA_UPLOAD_FOLDER.$get_compined.".pdf";
                    if(is_file($file)){
                        $vouchers.= iben_elta_Compined_Voucher_Link($get_compined);
                    }

            }
            $vouchers.='</span>';
            
            if ($item['id_order'] == -1 && $item['id_elta_reason'] == 1) {
                $vouchers.='
                <span class="iben_elta_compine_single id_'.$item['id'].'" style="display: block;align-content: center;align-items: center;">
                    <button type="button" class="button iben_elta_order_button_single_compine_vouchers button-secondary" data-id="'.$item['id'].'" data-id_elta_reason = "1" >'.esc_html__( 'PDF', 'iben-woo-elta-courier' ).'</button>
                    <div class="iben_elta_compine_vouchers_spinner iben_elta_spinners" style="display:none;"><div class="bounce1"></div><div class="bounce2"></div><div class="bounce3"></div></div>
                </span>';
            }


            return $vouchers;
        }


        function column_id_elta_account($item){
            ?>

            <div style="display: block;">

                <span class="iben_elta_voucherslist_status" id="iben_elta_voucherslist_status_response<?php echo absint(  $item['id'] ); ?>">

                    <?php
                    if ( $item['id_elta_account'] == 1 ) {

                        esc_html_e('1st account', 'iben-woo-elta-courier');
                        
                    }else{
                        esc_html_e('2nd account', 'iben-woo-elta-courier');
                    }
                    ?>
                </span>

            </div>
            <?php
        }

        function column_delivered($item){
            ?>

            <div style="display: block;">

                <span class="iben_elta_voucherslist_status" id="iben_elta_voucherslist_status_response<?php echo absint(  $item['id'] ); ?>">

                    <?php
                    if ( $item['delivered'] != 1 ) {

                        if ( $item['delivered'] == -1 ) {
                            esc_html_e('Hasn\'t delivered yet', 'iben-woo-elta-courier');
                            echo '<br/>';
                        }
                    ?>

                    <a href='#' title="<?php esc_html_e('Check delivery', 'iben-woo-elta-courier') ?>" alt="<?php esc_html_e('Check status', 'iben-woo-elta-courier') ?>" class="iben_elta_vouchers_status_list" data-id_elta_account = "<?php echo absint(  $item['id_elta_account'] ); ?>" data-id_elta_reason = "<?php echo absint(  $item['id_elta_reason'] ); ?>" data-id_order="<?php echo $item['id_order'];?>" data-updateid="<?php echo absint(  $item['id'] ); ?>">
                    <?php  esc_html_e('Check delivery', 'iben-woo-elta-courier'); ?></a>
                

                    <?php
                    }else{
                        echo '<p><b>'.esc_html__('Delivered', 'iben-woo-elta-courier').'</b></p>';
                        echo $item['delivered_date'].' '.$item['delivered_time'];
                    }
                    ?>
                </span>

            </div>
            <?php
        }

        function column_delivered_date($item){
            return $item['delivered_date'].':'.$item['delivered_time'];
        }

        function column_cod($item){

            $voucher_info = maybe_unserialize($item['elta_voucher_info']);
            $cash =  $voucher_info['cash_delivery'];

            if (isset($cash) && $cash > 0){
                return wc_price($cash);
            }
        }


        function column_deleted($item){
            
            add_thickbox(); 
            ?>

            <div style="display: block;">
                <a href="#TB_inline&width=400&height=350&inlineId=iben_elta_order_voucher_modal-<?php echo absint(  $item['id'] ); ?>" data-id_elta_reason = "<?php echo absint(  $item['id_elta_reason'] ); ?>" data-id_order = "<?php echo $item['id_order']; ?>"  data-id_response = "<?php echo absint(  $item['id'] ); ?>" class="thickbox iben_elta_voucher_info_modal_trigger" title ="<?php esc_html_e('Voucher info', 'iben-woo-elta-courier') ?>"><?php esc_html_e('Voucher info', 'iben-woo-elta-courier') ?></a>

                <div id="iben_elta_order_voucher_modal-<?php echo absint(  $item['id'] ); ?>" style="display:none;">
                    <div id ="iben_elta_voucher_info_modal_response<?php echo absint(  $item['id'] ); ?>"></div>
                </div>
            </div>

            <div style="display: block;">
                <a href="#TB_inline&width=400&height=350&inlineId=iben_elta_order_voucher_tracing_modal-<?php echo absint(  $item['id'] ); ?>" data-id_elta_account = "<?php echo absint(  $item['id_elta_account'] ); ?>" data-id_elta_reason = "<?php echo absint(  $item['id_elta_reason'] ); ?>" data-id_order = "<?php echo $item['id_order']; ?>"  data-id_response = "<?php echo absint(  $item['id'] ); ?>" class="thickbox iben_elta_order_voucher_tracing_modal_trigger" title = "<?php esc_html_e('Tracing', 'iben-woo-elta-courier') ?>"><?php esc_html_e('Tracing', 'iben-woo-elta-courier') ?></a>

                <div id="iben_elta_order_voucher_tracing_modal-<?php echo absint(  $item['id'] ); ?>" style="display:none;">
                    <div id ="iben_elta_voucher_tracing_modal_response<?php echo absint(  $item['id'] ); ?>"></div>
                </div>
            </div>

        <?php       
        }

        /**
        *
        * @return array
        */
        function get_columns(){

        
            $columns = array(
                'cb' => '<input type="checkbox" />', //Render a checkbox instead of text
                'id_order' => esc_html__('Order', 'iben-woo-elta-courier'),
                'elta_returned_vouchers' => esc_html__('Returned Vouchers', 'iben-woo-elta-courier'),
                'elta_delivery_vouchers' => esc_html__('Delivery Vouchers', 'iben-woo-elta-courier'),
                'delivered' => esc_html__('Delivery status', 'iben-woo-elta-courier'),
                'deleted' => esc_html__('Voucher info', 'iben-woo-elta-courier'),
                'delivered_date' => esc_html__('Delivered', 'iben-woo-elta-courier'),                 
                'time' => esc_html__('Date created', 'iben-woo-elta-courier'),
            );

       
            if ( isset($_REQUEST['delivered']) && $_REQUEST['delivered'] == 0 ){

                $columns = array(
                    'cb' => '<input type="checkbox" />', //Render a checkbox instead of text
                    'id_order' => esc_html__('Order', 'iben-woo-elta-courier'),
                    'elta_returned_vouchers' => esc_html__('Returned Vouchers', 'iben-woo-elta-courier'),
                    'elta_delivery_vouchers' => esc_html__('Delivery Vouchers', 'iben-woo-elta-courier'),
                    'delivered' => esc_html__('Delivery status', 'iben-woo-elta-courier'),
                    'deleted' => esc_html__('Voucher info', 'iben-woo-elta-courier'),
                    'last_check_delivered_time' => esc_html__('Last delivery check', 'iben-woo-elta-courier'),
                    'time' => esc_html__('Date created', 'iben-woo-elta-courier'),
                );

            }

            $main_settings = get_option('iben_elta_main_settings_fields'); 

            if( isset( $main_settings['iben_elta_main_settings_2nd_enable_account'] ) ) {
              
                $columns['id_elta_account'] = esc_html__('ELTA account', 'iben-woo-elta-courier');
            }


            $displaycod = apply_filters( 'iben_elta_filter_listvouchers_displaycod', true);
            if($displaycod){
                $columns['cod'] = esc_html__('COD', 'iben-woo-elta-courier');
            }
                

            return $columns;
        }

        /**
            *
            * @return array
            */
        function get_sortable_columns()
        {
            $sortable_columns = array(
                'time' => array('time', false),
                'id_order' => array('id_order', false),
                'delivered_date' => array('delivered_date,delivered_time', false),
                'last_check_delivered_time' => array('last_check_delivered_time', false),
            );
            return $sortable_columns;
        }



        /**
            * [OPTIONAL] Return array of bult actions if has any
            *
            * @return array
            */
        function get_bulk_actions()
        {

            if (isset($_REQUEST['ddeleted']) && $_REQUEST['ddeleted'] == '1'){
                $actions = array(
                    'delete_permant' => esc_html__('Permanently delete', 'iben-woo-elta-courier'),
                    'restore' => esc_html__('Restore', 'iben-woo-elta-courier')
                );
            }else{
            
                $actions = array(
                    'delete' => esc_html__('Safely delete selected record. Nessecery if you want to create new voucher for an order', 'iben-woo-elta-courier'),
                    'deleteALLPDF' => esc_html__('Delete voucher PDFs (Free space)', 'iben-woo-elta-courier'),
                    'delivered' => esc_html__('Mark as delivered', 'iben-woo-elta-courier'),
                    'undelivered' => esc_html__('Mark as undelivered', 'iben-woo-elta-courier'),
                    'delete_permant' => esc_html__('Permanently delete', 'iben-woo-elta-courier'),
                );
            }
            return $actions;
        }

        function extra_tablenav( $which ) {
            if ( isset($_REQUEST['ddeleted']) && $_REQUEST['ddeleted'] != '1' && ($which == "top" || $which == "bottom" ) ){
                ?>
                <div class="alignleft actions bulkactions">
                    <span class="iben_elta_info_settings">?</span>
                </div>
                <?php
            }

        }
        
        
        /**
            * it can be outside of class
            * it can not use wp_redirect coz there is output already
            * in this example we are processing delete action
            * message about successful deletion will be shown on page in next part
            */
        function process_bulk_action(){


            if ('delete_permant' === $this->current_action()) {

                if ( isset( $_REQUEST['_wpnonce'] ) && ! empty( $_REQUEST['_wpnonce'] ) ) {

                    $action = 'bulk-' . $this->_args['plural'];

                    if ( ! wp_verify_nonce( $_REQUEST['_wpnonce'], $action ) ){
                        wp_die( 'Nope! Security check failed!' );
                    }

                }

                if ( ! current_user_can( 'edit_shop_orders' ) ) {
                    $resultss = array (
                        "status" => "failure",
                        "result" => esc_html__( 'You cannot edit shop orders', 'iben-woo-elta-courier' )
                    );
                    wp_die( 'Nope! You cannot edit shop orders' );
                } 
                            

                if ( isset( $_REQUEST['id'] ) )
                $ids = $_REQUEST['id'];

                if (!empty($ids)) {

                    global $wpdb;
                    $table_name = $wpdb->prefix . 'iben_elta_vouchers';

                    foreach ($ids as $id){
                        $query = $wpdb->get_row( $wpdb->prepare( "SELECT id_order, elta_delivery_compined_vouchers, elta_returned_compined_vouchers, elta_returned_vouchers, elta_delivery_vouchers FROM $table_name WHERE id = %d", absint($id) ) );
                    
                        $elta_returned_vouchers_array =  ( isset($query->elta_returned_vouchers) ? json_decode($query->elta_returned_vouchers) : '');

                        if (isset($elta_returned_vouchers_array) && !empty($elta_returned_vouchers_array)) {
                            foreach ($elta_returned_vouchers_array as $elta_returned_voucher){
                                if ($elta_returned_voucher != ''){
                                $file2 = IBEN_WOO_ELTA_UPLOAD_FOLDER.$elta_returned_voucher.".pdf";
                                    
                                    if(is_file($file2)){

                                        iben_elta_secure_unlink($file2);
                                    }
                                
                                }
                            }

                        }


                        $elta_delivery_vouchers_array =  ( isset($query->elta_delivery_vouchers) ? json_decode($query->elta_delivery_vouchers) : '');

                        if (!empty($elta_delivery_vouchers_array)) {
                            foreach ($elta_delivery_vouchers_array as $elta_voucher){
                                if ($elta_voucher != ''){
                                $file2 = IBEN_WOO_ELTA_UPLOAD_FOLDER.$elta_voucher.".pdf";
                                    if(is_file($file2)){
                                        iben_elta_secure_unlink($file2);
                                    }
                                }
                            }
                        }


                        if ( isset($query->elta_delivery_compined_vouchers) && $query->elta_delivery_compined_vouchers != ''){
                            
                            $file2 = IBEN_WOO_ELTA_UPLOAD_FOLDER.$query->elta_delivery_compined_vouchers.".pdf";
                            if(is_file($file2)){
                                iben_elta_secure_unlink($file2);
                            }

                        }


                        if (isset($query->elta_returned_compined_vouchers) && $query->elta_returned_compined_vouchers != ''){
                            
                            $file2 = IBEN_WOO_ELTA_UPLOAD_FOLDER.$query->elta_returned_compined_vouchers.".pdf";
                            if(is_file($file2)){
                                iben_elta_secure_unlink($file2);
                            }                

                        }


                        // delete row
                        $id = absint($id);
                        $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE id = %d", $id));               

                    }
                }
            }
            
            if ('restore' === $this->current_action()) {

                if ( isset( $_REQUEST['_wpnonce'] ) && ! empty( $_REQUEST['_wpnonce'] ) ) {

                    $action = 'bulk-' . $this->_args['plural'];

                    if ( ! wp_verify_nonce( $_REQUEST['_wpnonce'], $action ) ){
                        wp_die( 'Nope! Security check failed!' );
                    }

                }
                if ( ! current_user_can( 'edit_shop_orders' ) ) {
                    $resultss = array (
                        "status" => "failure",
                        "result" => esc_html__( 'You cannot edit shop orders', 'iben-woo-elta-courier' )
                    );
                    wp_die( 'Nope! You cannot edit shop orders' );
                }            

                
                if ( isset( $_REQUEST['id'] ) )

                $ids = $_REQUEST['id'];

                if (!empty($ids)) {


                    global $wpdb;
                    $table_name = $wpdb->prefix . 'iben_elta_vouchers';

                    foreach ($ids as $id){

                        $updatedata = [ 'deleted' => 0 ];                   
                        $where = [ 'id' => absint($id) ];
                        $wpdb->update( $table_name, $updatedata, $where );              

                    }
                }


            }


            if ('delete' === $this->current_action()) {

                if ( isset( $_REQUEST['_wpnonce'] ) && ! empty( $_REQUEST['_wpnonce'] ) ) {

                    $action = 'bulk-' . $this->_args['plural'];

                    if ( ! wp_verify_nonce( $_REQUEST['_wpnonce'], $action ) ){
                        wp_die( 'Nope! Security check failed!' );
                    }

                }

                if (!current_user_can( 'delete_shop_orders' )){
                    wp_die( 'You dont have the capibility' );
                }          

                if ( isset( $_REQUEST['id'] ) )

                $ids = $_REQUEST['id'];

                if (!empty($ids)) {


                    global $wpdb;
                    $table_name = $wpdb->prefix . 'iben_elta_vouchers';

                    foreach ($ids as $id){
                        $query = $wpdb->get_row( $wpdb->prepare( "SELECT id_order, elta_delivery_compined_vouchers, elta_returned_compined_vouchers, elta_returned_vouchers, elta_delivery_vouchers FROM $table_name WHERE id = %d", absint($id) ) );
                    
                        
                        $elta_returned_vouchers_array =  json_decode($query->elta_returned_vouchers);
                        if (!empty($elta_returned_vouchers_array)) {
                            foreach ($elta_returned_vouchers_array as $elta_returned_voucher){
                                if ($elta_returned_voucher != ''){
                                $file2 = IBEN_WOO_ELTA_UPLOAD_FOLDER.$elta_returned_voucher.".pdf";
                                    
                                    if(is_file($file2)){

                                        iben_elta_secure_unlink($file2);
                                    }
                                
                                }
                            }              

                        }


                        $elta_delivery_vouchers_array =  json_decode($query->elta_delivery_vouchers);
                        if (!empty($elta_delivery_vouchers_array)) {
                            foreach ($elta_delivery_vouchers_array as $elta_voucher){
                                if ($elta_voucher != ''){
                                $file2 = IBEN_WOO_ELTA_UPLOAD_FOLDER.$elta_voucher.".pdf";
                                    if(is_file($file2)){
                                        iben_elta_secure_unlink($file2);
                                    }
                                }
                            }
                        }


                        if ($query->elta_delivery_compined_vouchers != ''){
                            
                            $file2 = IBEN_WOO_ELTA_UPLOAD_FOLDER.$query->elta_delivery_compined_vouchers.".pdf";
                            if(is_file($file2)){
                                iben_elta_secure_unlink($file2);
                            }

                        }


                        if ($query->elta_returned_compined_vouchers != ''){
                            
                            $file2 = IBEN_WOO_ELTA_UPLOAD_FOLDER.$query->elta_returned_compined_vouchers.".pdf";
                            if(is_file($file2)){
                                iben_elta_secure_unlink($file2);
                            }                  

                        }

                        $updatedata = [ 'deleted' => 1 ];                   
                        $where = [ 'id' => absint($id) ];
                        $wpdb->update( $table_name, $updatedata, $where );              

                    }
                }


            }
            
            
            if ('deleteALLPDF' === $this->current_action()) {

                if ( isset( $_REQUEST['_wpnonce'] ) && ! empty( $_REQUEST['_wpnonce'] ) ) {

                    $action = 'bulk-' . $this->_args['plural'];

                    if ( ! wp_verify_nonce( $_REQUEST['_wpnonce'], $action ) ){
                        wp_die( 'Nope! Security check failed!' );
                    }

                }

                if (!current_user_can( 'delete_shop_orders' )){
                    wp_die( 'You dont have the capibility' );
                }          

                if ( isset( $_REQUEST['id'] ) )
                $ids = $_REQUEST['id'];

                if (!empty($ids)) {

                    global $wpdb;
                    $table_name = $wpdb->prefix . 'iben_elta_vouchers';

                    foreach ($ids as $id){
                        $query = $wpdb->get_row( $wpdb->prepare( "SELECT id_order, elta_delivery_compined_vouchers, elta_returned_compined_vouchers, elta_returned_vouchers, elta_delivery_vouchers FROM $table_name WHERE id = %d", absint($id) ) );
                    
                
                        $elta_returned_vouchers_array =  json_decode($query->elta_returned_vouchers);
                        if (!empty($elta_returned_vouchers_array)) {
                            foreach ($elta_returned_vouchers_array as $elta_returned_voucher){
                                if ($elta_returned_voucher != ''){
                                $file2 = IBEN_WOO_ELTA_UPLOAD_FOLDER.$elta_returned_voucher.".pdf";
                                    
                                    if(is_file($file2)){

                                        iben_elta_secure_unlink($file2);
                                    }
                                
                                }
                            }
                        }



                        $elta_delivery_vouchers_array =  json_decode($query->elta_delivery_vouchers);
                        if (!empty($elta_delivery_vouchers_array)) {
                            foreach ($elta_delivery_vouchers_array as $elta_voucher){
                                if ($elta_voucher != ''){
                                $file2 = IBEN_WOO_ELTA_UPLOAD_FOLDER.$elta_voucher.".pdf";
                                    if(is_file($file2)){
                                        iben_elta_secure_unlink($file2);
                                    }
                                }
                            }
                        }

                        
                        if ($query->elta_delivery_compined_vouchers != ''){
                            
                            $file2 = IBEN_WOO_ELTA_UPLOAD_FOLDER.$query->elta_delivery_compined_vouchers.".pdf";
                            if(is_file($file2)){
                                iben_elta_secure_unlink($file2);
                            }
                
                            $wpdb->update( 
                                $table_name, 
                                array( 
                                    'elta_delivery_compined_vouchers' => ''
                                ), 
                                array( 'id' => absint($id) )
                            );

                        }


                        if ($query->elta_returned_compined_vouchers != ''){
                            
                            $file2 = IBEN_WOO_ELTA_UPLOAD_FOLDER.$query->elta_returned_compined_vouchers.".pdf";
                            if(is_file($file2)){
                                iben_elta_secure_unlink($file2);
                            }
                            $wpdb->update( 
                                $table_name, 
                                array( 
                                    'elta_returned_compined_vouchers' => ''
                                ), 
                                array( 'id' => absint($id) )
                            );

                        }
                        

                    }
                }


            } 


            if ('delivered' === $this->current_action()) {

                if ( isset( $_REQUEST['_wpnonce'] ) && ! empty( $_REQUEST['_wpnonce'] ) ) {

                    $action = 'bulk-' . $this->_args['plural'];

                    if ( ! wp_verify_nonce( $_REQUEST['_wpnonce'], $action ) ){
                        wp_die( 'Nope! Security check failed!' );
                    }

                }

                if (!current_user_can( 'delete_shop_orders' )){
                    wp_die( 'You dont have the capibility' );
                }         

                
                if ( isset( $_REQUEST['id'] ) )

                $ids = $_REQUEST['id'];

                if (!empty($ids)) {


                    global $wpdb;
                    $table_name = $wpdb->prefix . 'iben_elta_vouchers';

                    foreach ($ids as $id){
                        $query = $wpdb->get_row( $wpdb->prepare( "SELECT delivered FROM $table_name WHERE id = %d", absint($id) ) );
                    

                        if (isset($query->delivered) && $query->delivered != 1 ){

                            $updatedata = [ 'delivered' => 1 ];                   
                            $where = [ 'id' => absint($id) ];
                            $wpdb->update( $table_name, $updatedata, $where );  
                        }        

                    }
                }


            }   

            if ('undelivered' === $this->current_action()) {

                if ( isset( $_REQUEST['_wpnonce'] ) && ! empty( $_REQUEST['_wpnonce'] ) ) {

                    $action = 'bulk-' . $this->_args['plural'];

                    if ( ! wp_verify_nonce( $_REQUEST['_wpnonce'], $action ) ){
                        wp_die( 'Nope! Security check failed!' );
                    }

                }

                if (!current_user_can( 'delete_shop_orders' )){
                    wp_die( 'You dont have the capibility' );
                }           

                
                if ( isset( $_REQUEST['id'] ) )

                $ids = $_REQUEST['id'];

                if (!empty($ids)) {


                    global $wpdb;
                    $table_name = $wpdb->prefix . 'iben_elta_vouchers';

                    foreach ($ids as $id){
                        $query = $wpdb->get_row( $wpdb->prepare( "SELECT delivered FROM $table_name WHERE id = %d", absint($id) ) );
                    

                        if (isset($query->delivered) && $query->delivered != 0 ){

                            $updatedata = [ 'delivered' => 0 ];                   
                            $where = [ 'id' => absint($id) ];
                            $wpdb->update( $table_name, $updatedata, $where );  
                        }        

                    }
                }


            }            
            
            

        }

        protected function get_views() { 
            
            $views = array();

            if ( isset($_REQUEST['delivered']) ){

                $current = $_REQUEST['delivered'];
                $current2 = '';
                $current3 = '';
            }else if (isset($_REQUEST['ddeleted']) ){
                $current = '';
                $current2 = $_REQUEST['ddeleted']; 
                $current3 = '';

            }else if (isset($_REQUEST['with_cod']) ){
                $current = '';
                $current2 = '';
                $current3 = $_REQUEST['with_cod']; 

            }else{
                $current = 'all';
                $current2 = '';
                $current3 = '';
            }
            
            global $wpdb;
            $table_name = $wpdb->prefix . 'iben_elta_vouchers';

            $count_all = $wpdb->get_var("SELECT COUNT(id) FROM $table_name WHERE deleted = 0");
            $count_undelivered = $wpdb->get_var("SELECT COUNT(id) FROM $table_name WHERE delivered < 1 AND deleted = 0");
            $count_delivered = $wpdb->get_var("SELECT COUNT(id) FROM $table_name WHERE delivered = 1 AND deleted = 0");
            $count_deleted = $wpdb->get_var("SELECT COUNT(id) FROM $table_name WHERE deleted = 1");                
            
            $count_returned = $wpdb->get_var("SELECT COUNT(id) FROM $table_name WHERE delivered = 2 AND deleted = 0");
            $count_riskreturning = $wpdb->get_var("SELECT COUNT(id) FROM $table_name WHERE delivered = 3 AND deleted = 0");
            
            $display_totalcod_all = apply_filters( 'iben_elta_filter_listvouchers_displaycod_all', false);
            $display_totalcod_delivered = apply_filters( 'iben_elta_filter_listvouchers_displaycod_delivered', false);
            $display_totalcod_undelivered = apply_filters( 'iben_elta_filter_listvouchers_displaycod_undelivered', false);
            
            $display_totalcod_returned = apply_filters( 'iben_elta_filter_listvouchers_displaycod_returned', false);
            $display_totalcod_riskreturning = apply_filters( 'iben_elta_filter_listvouchers_displaycod_riskreturning', false);


            $arr_params = array( 'delivered', 'ddeleted');
            $all_url = remove_query_arg( $arr_params );


            $class = ($current == 'all' ? ' class="current"' :'');
            $display_totalcod_all = ($display_totalcod_all ? wc_price(iben_elta_get_cod_all()) : '');
            $views['all'] = "<a href='{$all_url }' {$class} >". esc_html__('All', 'iben-woo-elta-courier')." ($count_all) ".$display_totalcod_all."</a>";

        
            $foo_url = add_query_arg('delivered','1', $all_url);
            $class = ($current == '1' ? ' class="current"' :'');
            $display_totalcod_delivered = ($display_totalcod_delivered ? wc_price(iben_elta_get_cod_delivered()) : '');
            $views['1'] = "<a href='{$foo_url}' {$class} >". esc_html__('All Delivered', 'iben-woo-elta-courier')." ($count_delivered) ".$display_totalcod_delivered."</a>";


            
            $bar_url = add_query_arg('delivered','0', $all_url);
            $class = ($current == '0' ? ' class="current"' :'');
            $display_totalcod_undelivered = ($display_totalcod_undelivered ? wc_price(iben_elta_get_cod_undelivered()) : '');
            $views['2'] = "<a href='{$bar_url}' {$class} >". esc_html__('All Undelivered', 'iben-woo-elta-courier')." ($count_undelivered) ".$display_totalcod_undelivered."</a>";



            $bar_url2 = add_query_arg('delivered','2', $all_url);
            $class = ($current == '2' ? ' class="current"' :'');
            $display_totalcod_returned = ($display_totalcod_returned ? wc_price(iben_elta_get_cod_returned()) : '');
            $views['3'] = "<a href='{$bar_url2}' {$class} >". esc_html__('All returned', 'iben-woo-elta-courier')." ($count_returned) ".$display_totalcod_returned."</a>";


            $bar_url3 = add_query_arg('delivered','3', $all_url);
            $class = ($current == '3' ? ' class="current"' :'');
            $display_totalcod_riskreturning = ($display_totalcod_riskreturning ? wc_price(iben_elta_get_cod_riskreturning()) : '');
            $views['4'] = "<a href='{$bar_url3}' {$class} >". esc_html__('Returning risk', 'iben-woo-elta-courier')." ($count_riskreturning) ".$display_totalcod_riskreturning."</a>";



            $arr_params = array( 'delivered');
            $bar_url1 = add_query_arg('ddeleted', '1', $all_url);
            $class2 = ($current2 == '1' ? ' class="current"' :'');
            $views['5'] = "<a href='{$bar_url1}' {$class2} >". esc_html__('Deleted', 'iben-woo-elta-courier')." ($count_deleted)</a>";         
        

            $arr_params = array( 'with_cod');
            $bar_url3 = add_query_arg('with_cod', '1', $all_url);
    
            return $views;
        }    
        
        /**
            * [REQUIRED] This is the most important method
            *
            * It will get rows from database and prepare them to be showed in table
            */
        function prepare_items(){

            global $wpdb;
            $table_name = $wpdb->prefix . 'iben_elta_vouchers';
            
            $per_page = 30; // constant, how much records will be shown per page
            $user = get_current_user_id();
            $screen = get_current_screen();
            $option = $screen->get_option('per_page', 'option');
            $per_page = get_user_meta($user, $option, true);
             
            if ( empty ( $per_page) || $per_page < 1 || $per_page > 500) {
             
                $per_page = $screen->get_option( 'per_page', 'default' );
             
            }
            

            $columns = $this->get_columns();
            $hidden = array();
            $sortable = $this->get_sortable_columns();

            // here we configure table headers, defined in our methods
            $this->_column_headers = array($columns, $hidden, $sortable);

            // [OPTIONAL] process bulk action if any
            $this->process_bulk_action();


            //Retrieve $customvar for use in query to get items.
            $customvar = ( isset($_REQUEST['delivered']) ? $_REQUEST['delivered'] : '');
            
            if($customvar != '') {
                //if want undelivered
                if ($customvar == 0){
                    $search_custom_vars= "AND delivered <= '" . esc_sql( $wpdb->esc_like( $customvar ) ) . "'";                
                }else{
                    $search_custom_vars= "AND delivered = '" . esc_sql( $wpdb->esc_like( $customvar ) ) . "'";                
                }
            } else	{
                $search_custom_vars = '';
            }



            $customvar2 = ( isset($_REQUEST['ddeleted']) ? $_REQUEST['ddeleted'] : '');
            
            if($customvar2 != '') {
                $search_custom_vars2= "AND deleted = '" . esc_sql( $wpdb->esc_like( $customvar2 ) ) . "'";
            } else	{
                $search_custom_vars2 = " AND deleted = 0 ";
            }

            
            // search
            $search = '';
            if ( ! empty( $_REQUEST['s'] ) ) {
                $search .= "AND elta_delivery_vouchers LIKE '%" . esc_sql( $wpdb->esc_like( $_REQUEST['s'] ) ) . "%'";
                $search .= "OR elta_returned_vouchers LIKE '%" . esc_sql( $wpdb->esc_like( $_REQUEST['s'] ) ) . "%'";
                $search .= "OR elta_voucher_info LIKE '%" . esc_sql( $wpdb->esc_like( $_REQUEST['s'] ) ) . "%'";
            }	
            

            // will be used in pagination settings
            $total_items = $wpdb->get_var("SELECT COUNT(id) FROM $table_name WHERE 1=1 $search $search_custom_vars $search_custom_vars2");


            // prepare query params, as usual current page, order by and order direction
            $paged = isset($_REQUEST['paged']) ? ($per_page * max(0, intval($_REQUEST['paged']) - 1)) : 0;
            $orderby = (isset($_REQUEST['orderby']) && in_array($_REQUEST['orderby'], array_keys($this->get_sortable_columns()))) ? $_REQUEST['orderby'] : 'id';
            $order = (isset($_REQUEST['order']) && in_array($_REQUEST['order'], array('asc', 'desc'))) ? $_REQUEST['order'] : 'desc';

            // [REQUIRED] define $items array
            // notice that last argument is ARRAY_A, so we will retrieve array
            $this->items = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE 1=1 $search $search_custom_vars $search_custom_vars2 ORDER BY $orderby $order LIMIT %d OFFSET %d", $per_page, $paged), ARRAY_A);


            // [REQUIRED] configure pagination
            $this->set_pagination_args(array(
                'total_items' => $total_items, // total items defined above
                'per_page' => $per_page, // per page constant defined at top of method
                'total_pages' => ceil($total_items / $per_page) // calculate pages count
            ));
        }
    }
}    