<?php
if ( ! defined( 'WPINC' ) ) {
    wp_die();
}

class IbenELTALicenceInit {

    public $plugin_file = IBEN_WOO_ELTA_PLUGIN_FILE;
    public $responseObj;
    public $licenseMessage;
    public $showMessage=false;
    public $slug="iben-woo-elta-courier";

    function __construct() {

        $licenseKey=get_option("IbenELTALicenceInit_lic_Key","");
        $liceEmail=get_option( "IbenELTALicenceInit_lic_email","");
        
        IbenELTALicenceBase::addOnDelete(function(){
           delete_option("IbenELTALicenceInit_lic_Key");
        });

        
        if(IbenELTALicenceBase::CheckWPPlugin($licenseKey,$liceEmail,$this->licenseMessage,$this->responseObj,IBEN_WOO_ELTA_PLUGIN_FILE)){

            add_action( 'iben_elta_license_page', [ $this, 'Activated' ] );
            add_action( 'admin_post_IbenELTALicenceInit_el_deactivate_license', [ $this, 'action_deactivate_license' ] );

        }else{
            if(!empty($licenseKey) && !empty($this->licenseMessage)){
               $this->showMessage=true;
            }
            update_option("IbenELTALicenceInit_lic_Key","") || add_option("IbenELTALicenceInit_lic_Key","");
            add_action( 'admin_post_IbenELTALicenceInit_el_activate_license', [ $this, 'action_activate_license' ] );

            add_action( 'iben_elta_license_page', [ $this, 'LicenseForm' ] );
            // display notice message
            add_action( 'admin_notices', array( $this, 'inactive_notice' ) );
        }

    }

    function inactive_notice() { ?>
        <?php if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }
        ?>
        <div class="notice notice-error">
            <p><?php 
                printf( '<strong>%s</strong>: '.esc_html__('License Key has not been activated! %sClick here%s to register your CodeCanyon License Key. By registering your license, you can easily update the iBen ELTA Courier plugin with one click on upcoming versions with new features, improvements, and security updates.', 'iben-woo-elta-courier'), 'iBen ELTA Courier', '<a href="' . esc_url( admin_url( 'admin.php?page=' . 'iben_woo_elta_license' ) ) . '">', '</a>');
            ?></p>

            
        </div>
        <?php
    }
    

    function action_activate_license(){

        if (!current_user_can( 'delete_shop_orders' )){
            wp_die( 'You dont have the capibility' );
        }

        check_admin_referer( 'el-license' );
        $licenseKey   = ! empty( $_POST['el_license_key'] ) ? sanitize_text_field( $_POST['el_license_key'] ) : '';
        $licenseEmail = ! empty( $_POST['el_license_email'] ) ? sanitize_email( $_POST['el_license_email'] ) : '';
        update_option( 'IbenELTALicenceInit_lic_Key', $licenseKey ) || add_option( 'IbenELTALicenceInit_lic_Key', $licenseKey );
        update_option( 'IbenELTALicenceInit_lic_email', $licenseEmail ) || add_option( 'IbenELTALicenceInit_lic_email', $licenseEmail );
        update_option('_site_transient_update_plugins','');
        wp_safe_redirect(admin_url( 'admin.php?page=iben_woo_elta_license'));
    }
    function action_deactivate_license() {
        
        if (!current_user_can( 'delete_shop_orders' )){
            wp_die( 'You dont have the capibility' );
        }

        check_admin_referer( 'el-license' );
        $message="";
        if(IbenELTALicenceBase::RemoveLicenseKey(IBEN_WOO_ELTA_PLUGIN_FILE,$message)){
            update_option("IbenELTALicenceInit_lic_Key","") || add_option("IbenELTALicenceInit_lic_Key","");
            update_option('_site_transient_update_plugins','');
        }
        wp_safe_redirect(admin_url( 'admin.php?page=iben_woo_elta_license'));
    }

    function Activated(){
        ?>
        <form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
            <input type="hidden" name="action" value="IbenELTALicenceInit_el_deactivate_license"/>
            <div class="el-license-container">
                <h3 class="el-license-title"><?php esc_html_e("iBen WooCommerce ELTA Courier Licensing",$this->slug);?> </h3>
                <hr>
                <ul class="el-license-info">
                <li>
                    <div>
                        <span class="el-license-info-title"><?php esc_html_e("Status",$this->slug);?></span>

                        <?php if ( $this->responseObj->is_valid ) : ?>
                            <span class="el-license-valid"><?php esc_html_e("Valid",$this->slug);?></span>
                        <?php else : ?>
                            <span class="el-license-valid"><?php esc_html_e("Invalid",$this->slug);?></span>
                        <?php endif; ?>
                    </div>
                </li>

                <li>
                    <div>
                        <span class="el-license-info-title"><?php esc_html_e("License Type",$this->slug);?></span>
                        <?php echo $this->responseObj->license_title; ?>
                    </div>
                </li>

               <li>
                   <div>
                       <span class="el-license-info-title"><?php esc_html_e("License Expire on",$this->slug);?></span>
                       <?php echo $this->responseObj->expire_date;
                       if(!empty($this->responseObj->expire_renew_link)){
                           ?>
                           <a target="_blank" class="el-blue-btn" href="<?php echo $this->responseObj->expire_renew_link; ?>">Renew</a>
                           <?php
                       }
                       ?>
                   </div>
               </li>
                <li>
                    <div>
                        <span class="el-license-info-title"><?php esc_html_e("Your License Key",$this->slug);?></span>
                        <span class="el-license-key"><?php echo esc_attr( substr($this->responseObj->license_key,0,9)."XXXXXXXX-XXXXXXXX".substr($this->responseObj->license_key,-9) ); ?></span>
                    </div>
                </li>
                </ul>
                <div class="el-license-active-btn">
                    <?php wp_nonce_field( 'el-license' ); ?>
                    <?php submit_button(esc_html__("Deactivate License",$this->slug)); ?> 
                </div>
            </div>
        </form>
    <?php
    }

    function LicenseForm() {
        ?>
        <form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
            <input type="hidden" name="action" value="IbenELTALicenceInit_el_activate_license"/>
            <div class="el-license-container">
                <h3 class="el-license-title"><?php esc_html_e("iBen WooCommerce ELTA Courier Licensing",$this->slug);?></h3>
                <hr>
                <?php
                if(!empty($this->showMessage) && !empty($this->licenseMessage)){
                    ?>
                    <div class="notice notice-error is-dismissible">
                        <p><?php echo esc_html_e($this->licenseMessage,$this->slug); ?></p>
                    </div>
                    <?php
                }
                ?>
                <p><?php esc_html_e("Enter your CodeCanyon license key, click activate and get automatic updates.", $this->slug);?></p>
                <div class="el-license-field">
                    <label for="el_license_key"><?php esc_html_e("License code",$this->slug);?></label>
                    <input type="text" class="regular-text code" name="el_license_key" size="50" placeholder="xxxxxxxx-xxxxxxxx-xxxxxxxx-xxxxxxxx" required="required">
                </div>
                <div class="el-license-field">
                    <label for="el_license_key"><?php esc_html_e("Email Address",$this->slug);?></label>
                    <?php
                        $purchaseEmail   = get_option( "IbenELTALicenceInit_lic_email", get_bloginfo( 'admin_email' ));
                    ?>
                    <input type="text" class="regular-text code" name="el_license_email" size="50" value="<?php echo $purchaseEmail; ?>" placeholder="" required="required">
                </div>
                <div class="el-license-active-btn">
                    <?php wp_nonce_field( 'el-license' ); ?>
                    <?php submit_button(esc_html__("Activate License",$this->slug)); ?>
                </div>
            </div>
        </form>
        <?php
    }
}