<?php
if ( ! defined( 'WPINC' ) ) {
	wp_die();
}

if ( ! class_exists( 'Get_Elta_Contacts_List_Table' ) ) {
    /**
     * The admin-specific functionality of the plugin.
     *
     * @link       https://iben.pro
     * @since      1.0.0
     *
     * @package    Iben_Woo_Elta_Courier
     * @subpackage Iben_Woo_Elta_Courier/admin/partials
     */


    class Get_Elta_Contacts_List_Table extends WP_List_Table{
        

        /**
        * [REQUIRED] You must declare constructor and give some basic params
        */
        function __construct()
        {
            global $status, $page;

            parent::__construct(array(
                'singular' => 'contact',
                'plural' => 'contacts',
            ));

        }

        /**
            * [REQUIRED] this is a default column renderer
            *
            * @param $item - row (key, value array)
            * @param $column_name - string (key)
            * @return HTML
            */
        function column_default($item, $column_name)
        {
            return $item[$column_name];
        }

        /**
            * @param $item - row (key, value array)
            * @return HTML
            */
        function column_time_created($item)
        {
            return $datetime = date_i18n(get_option('date_format'), $item['time_created']) .' | '. date_i18n(get_option('time_format'), $item['time_created']);
        }


        function column_contact_name($item){

            $actions = array(
                'edit' => sprintf('<a href="?page=iben_woo_elta_edit_contact&id=%s">%s</a>', $item['id'], esc_html__('Edit', 'iben-woo-elta-courier')),
                
            );
    
            return sprintf('%s %s',
                $item['contact_name'],
                $this->row_actions($actions)
            );
        }

        /**
            * [REQUIRED] this is how checkbox column renders
            *
            * @param $item - row (key, value array)
            * @return HTML
            */
        function column_cb($item)
        {
            return sprintf(
                '<input type="checkbox" name="id[]" value="%s" />',
                $item['id']
            );
        }


        function column_id_reference($item)
        {
            return '<code>'.$item['id_reference'].'</code>';
        }




        /**
        *
        * @return array
        */
        function get_columns(){

            $columns = array(
                'cb' => '<input type="checkbox" />', //Render a checkbox instead of text
                'id_reference' => esc_html__('ID reference', 'iben-woo-elta-courier'),
                'contact_name' => esc_html__('Full name', 'iben-woo-elta-courier'),
                'contact_address' => esc_html__('Address', 'iben-woo-elta-courier'),
                'contact_region' => esc_html__('Region', 'iben-woo-elta-courier'),
                'contact_postal' => esc_html__('Postal code', 'iben-woo-elta-courier'),
                'contact_tel1' => esc_html__('Telephone 1', 'iben-woo-elta-courier'),
                'contact_tel2' => esc_html__('Telephone 2', 'iben-woo-elta-courier'),
                'contact_comment' => esc_html__('Comments', 'iben-woo-elta-courier'),
                'time_created' => esc_html__('Date created', 'iben-woo-elta-courier'),
            );

            return $columns;
        }

        /**
        *
        * @return array
        */
        function get_sortable_columns()
        {
            $sortable_columns = array(
                'time_created' => array('time_created', false),
                'contact_name' => array('contact_name', false),
            );
            return $sortable_columns;
        }



        /**
        * [OPTIONAL] Return array of bult actions if has any
        *
        * @return array
        */
        function get_bulk_actions()
        {

            $actions = array(
                'delete' => esc_html__('Delete', 'iben-woo-elta-courier')
            );
            
            return $actions;
        }

       
        
        /**
        * it can be outside of class
        * it can not use wp_redirect coz there is output already
        * in this example we are processing delete action
        * message about successful deletion will be shown on page in next part
        */
        function process_bulk_action(){

     
            global $wpdb;
            $table_name = $wpdb->prefix . 'iben_elta_contacts';
    
            if ('delete' === $this->current_action()) {

                if (!current_user_can( 'delete_shop_orders' )){
                    wp_die( 'You dont have the capibility' );
                }
                                
                $ids = isset($_REQUEST['id']) ? $_REQUEST['id'] : array();
                if (is_array($ids)) {
                    // Sanitize IDs and create placeholders
                    $sanitized_ids = array_map('absint', $ids);
                    $placeholders = implode(',', array_fill(0, count($sanitized_ids), '%d'));
                    $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE id IN($placeholders)", ...$sanitized_ids));
                }
            }


        }

        protected function get_views() { 
            
            $views = array();

            return $views;
        }    
        
        /**
        * [REQUIRED] This is the most important method
        *
        * It will get rows from database and prepare them to be showed in table
        */
        function prepare_items(){

            global $wpdb;
            $table_name = $wpdb->prefix . apply_filters('iben_elta_contacts_table_name', 'iben_elta_contacts');

            $per_page = 20; // constant, how much records will be shown per page

            $columns = $this->get_columns();
            $hidden = array();
            $sortable = $this->get_sortable_columns();

            // here we configure table headers, defined in our methods
            $this->_column_headers = array($columns, $hidden, $sortable);

            // [OPTIONAL] process bulk action if any
            $this->process_bulk_action();


            // search
            $search = '';
            if ( ! empty( $_REQUEST['s'] ) ) {
                $search .= "AND contact_name LIKE '%" . esc_sql( $wpdb->esc_like( $_REQUEST['s'] ) ) . "%'";
                $search .= "OR contact_postal LIKE '%" . esc_sql( $wpdb->esc_like( $_REQUEST['s'] ) ) . "%'";
                $search .= "OR contact_address LIKE '%" . esc_sql( $wpdb->esc_like( $_REQUEST['s'] ) ) . "%'";
                
            }	
            

            // will be used in pagination settings
            $total_items = $wpdb->get_var("SELECT COUNT(id) FROM $table_name WHERE 1=1 $search ");


            // prepare query params, as usual current page, order by and order direction
            $paged = isset($_REQUEST['paged']) ? ($per_page * max(0, intval($_REQUEST['paged']) - 1)) : 0;
            $orderby = (isset($_REQUEST['orderby']) && in_array($_REQUEST['orderby'], array_keys($this->get_sortable_columns()))) ? $_REQUEST['orderby'] : 'id';
            $order = (isset($_REQUEST['order']) && in_array($_REQUEST['order'], array('asc', 'desc'))) ? $_REQUEST['order'] : 'desc';

            // [REQUIRED] define $items array
            // notice that last argument is ARRAY_A, so we will retrieve array
            $this->items = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE 1=1 $search  ORDER BY $orderby $order LIMIT %d OFFSET %d", $per_page, $paged), ARRAY_A);


            // [REQUIRED] configure pagination
            $this->set_pagination_args(array(
                'total_items' => $total_items, // total items defined above
                'per_page' => $per_page, // per page constant defined at top of method
                'total_pages' => ceil($total_items / $per_page) // calculate pages count
            ));
        }
    }
}    