/*jslint browser: true, plusplus: true */
(function ($, window, document) {
    "use strict";
    // execute when the DOM is ready
    $(document).ready(function () {
        // display ZIP station on edit order
        if ($("#iben_elta_courier_order_metabox").length > 0) {
            var error = false;

            var postal_code = $("#iben_elta_order_metabox_postalcode").val();

            if (postal_code == "" || !postal_code || postal_code == null) {
                error = true;
            }

            if (!error) {
                $(".iben_elta_order_postalcode_field_station").addClass("loading");
                $(".iben_elta_order_postalcode_field_station").text("Loading ELTA info...");

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_station_onload_ajax_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            order_id: $("#iben_elta_order_metabox_order_id").val(),
                            post_type: $("#iben_elta_order_metabox_post_type").val(),
                            postal_code: postal_code,
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            $(".iben_elta_order_postalcode_field_station").removeClass("loading");
                            $(".iben_elta_order_postalcode_field_station").addClass("success");
                            $(".iben_elta_order_postalcode_field_station").html(data.result);
                        } else if (data.status === "failure") {
                            $(".iben_elta_order_postalcode_field_station").removeClass("loading");
                            $(".iben_elta_order_postalcode_field_station").addClass("error");
                            $(".iben_elta_order_postalcode_field_station").html(data.result);
                        } else {
                            $(".iben_elta_order_postalcode_field_station").html("error display ELTA info");
                        }
                    }
                );
            }
        }

        function replaceCommawithDot(s) {
            if (s) {
                s = s.replace(/,/g, ".");
                return parseFloat(s); // convert to number
            } else {
                return s;
            }
        }

        var iben_elta_create_voucher_button = "#iben_elta_order_create_voucher";
        $(".wp-admin").on("click", iben_elta_create_voucher_button, function () {
            var error = false;

            var list = $(this).data("list");
            var id_order = $(this).data("id_order");

            if (list) {
                var position_page = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_position_page").val();
                var order_id = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_order_id").val();
                var post_type = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_post_type").val();
            } else {
                var position_page = $("#iben_elta_order_metabox_position_page").val();
                var order_id = $("#iben_elta_order_metabox_order_id").val();
                var post_type = $("#iben_elta_order_metabox_post_type").val();
            }

            if (list) {
                var elta_account = "#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_elta_account";
                var duplicatedvoucher = "#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_confirm_duplicatedvoucher";
                var send_completed_email = "#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_button_settings_create_send_completed_email";
                var email_completed = "#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_main_settings_email_completed";

                var create_pdf = "#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_button_settings_create_pdf";
            } else {
                var elta_account = "#iben_elta_order_metabox_elta_account";
                var duplicatedvoucher = "#iben_elta_confirm_duplicatedvoucher";
                var send_completed_email = "#iben_elta_button_settings_create_send_completed_email";
                var email_completed = "#iben_elta_main_settings_email_completed";

                var create_pdf = "#iben_elta_button_settings_create_pdf";
            }

            // check if 2nd account selectboc exist and is checked
            if ($(elta_account).length == 1) {
                var second_account = $(elta_account).val();
            } else {
                var second_account = 1;
            }

            // check if dublicate checkbox exist and is checked
            if ($(duplicatedvoucher).length == 1) {
                if ($(duplicatedvoucher).is(":checked")) {
                    var confirm_duplicated_voucher = 1;
                } else {
                    var confirm_duplicated_voucher = 0;
                }
            } else {
                var confirm_duplicated_voucher = 0;
            }

            // check if SEND COMPLETED EMAIL checkbox exist and is checked
            if ($(send_completed_email).length == 1) {
                if ($(send_completed_email).is(":checked")) {
                    var send_completed_email = 1;
                } else {
                    var send_completed_email = 0;
                }
            } else {
                var send_completed_email = 0;
            }

            // check if ATTACH TRACKING INFO IN EMAIL checkbox exist and is checked
            if ($(email_completed).length == 1) {
                if ($(email_completed).is(":checked")) {
                    var attach_trackinginfo_in_completed = 1;
                } else {
                    var attach_trackinginfo_in_completed = 0;
                }
            } else {
                var attach_trackinginfo_in_completed = 0;
            }

            // check if CREATE PDF checkbox exist and is checked
            if ($(create_pdf).length == 1) {
                if ($(create_pdf).is(":checked")) {
                    var create_pdf = 1;
                } else {
                    var create_pdf = 0;
                }
            } else {
                var create_pdf = 0;
            }

            if (list) {
                var fullname = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_fullname").val();
                var postal_code = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_postalcode").val();
                var address = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_address").val();
                var weight = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_weight").val();
            } else {
                var fullname = $("#iben_elta_order_metabox_fullname").val();
                var postal_code = $("#iben_elta_order_metabox_postalcode").val();
                var address = $("#iben_elta_order_metabox_address").val();
                var weight = $("#iben_elta_order_metabox_weight").val();
            }

            if (fullname == "") {
                error = true;
                alert("Όνομα δεν μπορεί να είναι κενό");
            }

            if (postal_code == "") {
                error = true;
                alert("ΤΚ δεν μπορεί να είναι κενό");
            }

            if (address == "") {
                error = true;
                alert("Διεύθυνση δεν μπορεί να είναι κενή");
            }

            if (weight == "") {
                error = true;
                alert("Το βάρος δεν μπορεί να είναι κενό");
            }

            if (list) {
                var cash_delivery = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_cash_delivery").val();
                var region = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_region").val();
                var phone1 = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_phone1").val();
                var phone2 = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_phone2").val();
                var comments = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_comments").val();
                var packages_number = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_packages_number").val();
                var service = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_packages_number").val();
                var sur_1 = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_sur_1").val();
                var sur_2 = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_sur_2").val();
                var sur_3 = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_sur_3").val();
                var ref = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_ref").val();
                var subcode = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_subcode").val();
            } else {
                var cash_delivery = $("#iben_elta_order_metabox_cash_delivery").val();
                var region = $("#iben_elta_order_metabox_region").val();
                var phone1 = $("#iben_elta_order_metabox_phone1").val();
                var phone2 = $("#iben_elta_order_metabox_phone2").val();
                var comments = $("#iben_elta_order_metabox_comments").val();
                var packages_number = $("#iben_elta_order_metabox_packages_number").val();
                var service = $("#iben_elta_order_metabox_service").val();
                var sur_1 = $("#iben_elta_order_metabox_sur_1").val();
                var sur_2 = $("#iben_elta_order_metabox_sur_2").val();
                var sur_3 = $("#iben_elta_order_metabox_sur_3").val();
                var ref = $("#iben_elta_order_metabox_ref").val();
                var subcode = $("#iben_elta_order_metabox_subcode").val();
            }

            if (!error) {
                if (position_page == "list") {
                    var tempname_listname = $(".post-" + id_order + " .column-iben_elta_order_voucher").html();
                    $(".post-" + id_order + " .column-iben_elta_order_voucher").text("loading...");

                    var tempname = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_create_voucher").text();

                    $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_create_voucher").removeClass("error");
                    $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_create_voucher").removeClass("success");
                    $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_create_voucher").removeClass("loading");
                    $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_create_voucher").addClass("loading");
                    $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_create_voucher").text("Loading");
                    $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_create_voucher").prop("disabled", true);
                } else {
                    var tempname = $(iben_elta_create_voucher_button).text();
                    $(iben_elta_create_voucher_button).removeClass("error");
                    $(iben_elta_create_voucher_button).removeClass("success");
                    $(iben_elta_create_voucher_button).removeClass("loading");

                    $(iben_elta_create_voucher_button).addClass("loading");
                    $(iben_elta_create_voucher_button).text("Loading");
                    $(iben_elta_create_voucher_button).prop("disabled", true);
                }
                var iben_datas = {
                    iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                    confirm_duplicated_voucher: confirm_duplicated_voucher,
                    order_id: order_id,
                    post_type: post_type,
                    position_page: position_page,
                    send_completed_email: send_completed_email,
                    attach_trackinginfo_in_completed: attach_trackinginfo_in_completed,

                    create_pdf: create_pdf,
                    second_account: second_account,
                    fullname: fullname,
                    address: address,
                    postal_code: postal_code,
                    region: region,
                    phone1: phone1,
                    phone2: phone2,
                    comments: comments,

                    cash_delivery: replaceCommawithDot(cash_delivery),
                    weight: replaceCommawithDot(weight),
                    packages_number: packages_number,

                    ref: ref,
                    subcode: subcode,

                    service: service,
                    sur_1: sur_1,
                    sur_2: sur_2,
                    sur_3: sur_3,
                };
                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_create_voucher_ajax_hook",
                        dataType: "json",
                        iben_data: iben_datas,
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            
                            $(document).trigger("iben_elta_label_created", [{ 
                                export: iben_datas, 
                                data: data
                            }]);

                            if (list) {
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_create_voucher").prop("disabled", false);
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_create_voucher").removeClass("loading");
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_create_voucher").addClass("success");

                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_create_voucher").text(data.message);
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_voucher_response").html(data.result);

                                var ttname = ".wp-list-table .post-" + id_order + " .iben_elta_order_voucher";
                                $(ttname).html(data.result);

                                $("#iben_elta_voucher_create_modal_response" + id_order + " .iben_elta_order_button_compine_vouchers").show();
                                $("#iben_elta_voucher_create_modal_response" + id_order + " #iben_elta_order_vouchers_title_response").show();
                            } else {
                                $(iben_elta_create_voucher_button).prop("disabled", false);
                                $(iben_elta_create_voucher_button).removeClass("loading");
                                $(iben_elta_create_voucher_button).addClass("success");

                                $(iben_elta_create_voucher_button).text(data.message);
                                $("#iben_elta_order_voucher_response").html(data.result);

                                $(".iben_elta_order_button_compine_vouchers").show();
                                $("#iben_elta_order_vouchers_title_response").show();
                            }

                            if (data.exportsettings.set_order_completed == 1 && position_page == "order") {
                                $("#order_status").val(iben_elta_various.status_value2);
                                $("#select2-order_status-container").text(iben_elta_various.status_text);
                            } else if (data.exportsettings.set_order_completed == 1 && position_page == "list") {
                                $(".post-" + id_order + " .column-order_status mark").removeClass();
                                $(".post-" + id_order + " .column-order_status mark").addClass("order-status");
                                $(".post-" + id_order + " .column-order_status mark").addClass("status-" + iben_elta_various.status_value);

                                $(".post-" + id_order + " .column-order_status mark span").text(iben_elta_various.status_text);
                            }
                            $("#iben_elta_order_create_voucher_response_" + id_order).hide();

                            // put tracking to the custom field
                            if (iben_elta_copy_voucher.tracking_enable == 1 && position_page == "order") {
                                var field = iben_elta_copy_voucher.tracking_field;
                                var tracking = data.exportsettings.tracking;

                                var field_split = field.split("|");

                                $.each(field_split, function (key, value) {
                                    var count_field = $(value).length;
                                    if (count_field == 1) {
                                        var value = $.trim(value);
                                        $(value).val(tracking);
                                    }
                                });
                            }
                        } else if (data.status === "failure") {
                            if (position_page == "list") {
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_create_voucher").prop("disabled", false);
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_create_voucher").removeClass("loading");
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_create_voucher").addClass("error");
                                //button
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_create_voucher_button).text(tempname);
                                // list order button
                                $(".post-" + id_order + " .column-iben_elta_order_voucher").html(tempname_listname);
                            } else {
                                $(iben_elta_create_voucher_button).prop("disabled", false);
                                $(iben_elta_create_voucher_button).removeClass("loading");
                                $(iben_elta_create_voucher_button).addClass("error");
                                //button
                                $(iben_elta_create_voucher_button).text(tempname);
                            }

                            $("#iben_elta_order_create_voucher_response_" + id_order).html(data.result);
                            $("#iben_elta_order_create_voucher_response_" + id_order).show();
                        } else {
                            alert("General failure error");
                        }
                    }
                );
            }
        });

        var iben_return_button = "#iben_elta_order_create_returned_voucher";
        $(".wp-admin").on("click", iben_return_button, function () {
            var error = "";

            // check if 2nc account selectboc exist and is checked
            if ($("#iben_elta_order_metabox_elta_account").length == 1) {
                var second_account = $("#iben_elta_order_metabox_elta_account").val();
            } else {
                var second_account = 1;
            }

            if ($("#iben_elta_confirm_duplicated_returned_voucher").length == 1) {
                if ($("#iben_elta_confirm_duplicated_returned_voucher").is(":checked")) {
                    var confirm_duplicated_returned_voucher = 1;
                } else {
                    var confirm_duplicated_returned_voucher = 0;
                }
            } else {
                var confirm_duplicated_returned_voucher = 0;
            }

            var fullname = $("#iben_elta_order_metabox_fullname").val();

            if (fullname == "") {
                error = true;
                alert("Όνομα δεν μπορεί να είναι κενό");
            }

            var postal_code = $("#iben_elta_order_metabox_postalcode").val();

            if (postal_code == "") {
                error = true;
                alert("ΤΚ δεν μπορεί να είναι κενό");
            }

            var address = $("#iben_elta_order_metabox_address").val();

            if (address == "") {
                error = true;
                alert("Διεύθυνση δεν μπορεί να είναι κενή");
            }

            var weight = $("#iben_elta_order_metabox_weight").val();

            if (weight == "") {
                error = true;
                alert("Το βάρος δεν μπορεί να είναι κενό");
            }

            var text_length = $("#iben_elta_order_metabox_comments").val().length;

            if (text_length > 57) {
                error = true;
                alert("Το πλήθος των χαρακτήρων στις παρατηρήσεις δεν μπορεί να ξεπερνάει τους 57");
            }

            var cash_delivery = $("#iben_elta_order_metabox_cash_delivery").val();

            if (!error) {
                $(iben_return_button).addClass("loading");
                var tempname = $(iben_return_button).text();
                $(iben_return_button).text("Loading");
                $(iben_return_button).prop("disabled", true);

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_returned_vouchers_ajax_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            confirm_duplicated_returned_voucher: confirm_duplicated_returned_voucher,
                            order_id: $("#iben_elta_order_metabox_order_id").val(),
                            post_type: $("#iben_elta_order_metabox_post_type").val(),

                            fullname: fullname,
                            address: address,
                            postal_code: postal_code,
                            region: $("#iben_elta_order_metabox_region").val(),
                            phone1: $("#iben_elta_order_metabox_phone1").val(),
                            phone2: $("#iben_elta_order_metabox_phone2").val(),
                            comments: $("#iben_elta_order_metabox_comments").val(),
                            second_account: second_account,

                            cash_delivery: replaceCommawithDot(cash_delivery),
                            weight: replaceCommawithDot(weight),

                            packages_number: $("#iben_elta_order_metabox_packages_number").val(),
                            ref: $("#iben_elta_order_metabox_ref").val(),
                            subcode: $("#iben_elta_order_metabox_subcode").val(),
                            service: $("#iben_elta_order_metabox_service").val(),

                            sur_1: $("#iben_elta_order_metabox_sur_1").val(),
                            sur_2: $("#iben_elta_order_metabox_sur_2").val(),
                            sur_3: $("#iben_elta_order_metabox_sur_3").val(),
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        // handle response data
                        if (data.status === "success") {
                            $(iben_return_button).prop("disabled", false);
                            $(iben_return_button).removeClass("loading");

                            $(iben_return_button).addClass("success");

                            $(iben_return_button).text(data.message);
                            $("#iben_elta_order_returned_vouchers_response").html(data.result);
                            $("#iben_elta_order_returned_vouchers_title_response").show();
                            $(".iben_elta_order_button_compine_ret_vouchers").show();
                        } else if (data.status === "failure") {
                            // perform our failure logic
                            $(iben_return_button).prop("disabled", false);
                            $(iben_return_button).removeClass("loading");
                            $(iben_return_button).addClass("error");

                            $(iben_return_button).text(data.result);
                        } else {
                            // do nothing
                            alert("General failure error");
                        }
                    }
                );
            }
        });

        // CREATE single VOUCHER
        var iben_elta_order_create_single_voucher = "#iben_elta_order_create_single_voucher";
        $(".wp-admin").on("click", iben_elta_order_create_single_voucher, function () {
            var error = false;

            // check if 2nc account selectboc exist and is checked
            if ($("#iben_elta_order_metabox_elta_account").length == 1) {
                var second_account = $("#iben_elta_order_metabox_elta_account").val();
            } else {
                var second_account = 1;
            }

            // check if CREATE PDF checkbox exist and is checked
            if ($("#iben_elta_button_settings_create_pdf").length == 1) {
                if ($("#iben_elta_button_settings_create_pdf").is(":checked")) {
                    var create_pdf = 1;
                } else {
                    var create_pdf = 0;
                }
            } else {
                var create_pdf = 0;
            }

            var fullname = $("#iben_elta_order_metabox_fullname_single").val();

            if (fullname == "") {
                error = true;
                alert("Όνομα δεν μπορεί να είναι κενό");
            }

            var postal_code = $("#iben_elta_order_metabox_postalcode_single").val();

            if (postal_code == "") {
                error = true;
                alert("ΤΚ δεν μπορεί να είναι κενό");
            }

            var address = $("#iben_elta_order_metabox_address_single").val();

            if (address == "") {
                error = true;
                alert("Διεύθυνση δεν μπορεί να είναι κενή");
            }

            var weight = $("#iben_elta_order_metabox_weight_single").val();

            if (weight == "") {
                error = true;
                alert("Το βάρος δεν μπορεί να είναι κενό");
            }

            var text_length = $("#iben_elta_order_metabox_comments_single").val().length;

            if (text_length > 57) {
                error = true;
                alert("Το πλήθος των χαρακτήρων στις παρατηρήσεις δεν μπορεί να ξεπερνάει τους 57");
            }

            var cash_delivery = $("#iben_elta_order_metabox_cash_delivery_single").val();

            if (!error) {
                $(iben_elta_order_create_single_voucher).addClass("loading");
                var tempname = $(iben_elta_order_create_single_voucher).text();
                $(iben_elta_order_create_single_voucher).text("Loading");
                $(iben_elta_order_create_single_voucher).prop("disabled", true);

                $(iben_elta_order_create_single_voucher).removeClass("error");
                $(iben_elta_order_create_single_voucher).removeClass("success");

                var iben_datas = {
                    iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                    order_id: $("#iben_elta_order_metabox_order_id_single").val(),
                    create_pdf: create_pdf,
                    fullname: fullname,
                    address: address,
                    postal_code: postal_code,
                    region: $("#iben_elta_order_metabox_region_single").val(),
                    phone1: $("#iben_elta_order_metabox_phone1_single").val(),
                    phone2: $("#iben_elta_order_metabox_phone2_single").val(),
                    comments: $("#iben_elta_order_metabox_comments_single").val(),
                    second_account: second_account,

                    cash_delivery: replaceCommawithDot(cash_delivery),
                    weight: replaceCommawithDot(weight),
                    packages_number: $("#iben_elta_order_metabox_packages_number_single").val(),
                    subcode: $("#iben_elta_order_metabox_subcode_single").val(),

                    service: $("#iben_elta_order_metabox_service_single").val(),
                    sur_1: $("#iben_elta_order_metabox_sur_1_single").val(),
                    sur_2: $("#iben_elta_order_metabox_sur_2_single").val(),
                    sur_3: $("#iben_elta_order_metabox_sur_3_single").val(),
                    ref: $("#iben_elta_order_metabox_ref_single").val(),
                };

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_create_single_voucher_ajax_hook",
                        dataType: "json",
                        iben_data: iben_datas,
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            $(iben_elta_order_create_single_voucher).prop("disabled", false);
                            $(iben_elta_order_create_single_voucher).removeClass("loading");
                            $(iben_elta_order_create_single_voucher).addClass("success");

                            $(iben_elta_order_create_single_voucher).text(data.message);
                            $("#iben_elta_order_voucher_response").html(data.result);
                            // compatibility with iBEN SMS plugin
                            if ($("#iben_elta_send_sms_single_voucher_number").length == 1) {
                                $("#iben_elta_send_sms_single_voucher_number").val(data.main_voucher);
                            }
                            if ($("#iben_elta_send_sms_single_mobile").length == 1) {
                                $("#iben_elta_send_sms_single_mobile").val(data.mobile_number);
                            }

                            $("#iben_elta_order_vouchers_title_response").show();
                            // $('.iben_elta_order_button_compine_vouchers').show();

                            $(document).trigger("iben_elta_single_created", [{ export: iben_datas }]);
                        } else if (data.status === "failure") {
                            $(iben_elta_order_create_single_voucher).prop("disabled", false);
                            $(iben_elta_order_create_single_voucher).removeClass("loading");
                            $(iben_elta_order_create_single_voucher).addClass("error");

                            $(iben_elta_order_create_single_voucher).text(data.result);
                        } else {
                            alert("General failure error");
                        }
                    }
                );
            }
        });

        // SAVE CONTACT SINGLE
        var iben_elta_contact_save = "#iben_elta_contact_save";
        $(".wp-admin").on("click", iben_elta_contact_save, function () {
            var error = false;

            var id_referrence = $("#iben_elta_order_metabox_id_referrence_single").val();
            var fullname = $("#iben_elta_order_metabox_fullname_single").val();
            var postal_code = $("#iben_elta_order_metabox_postalcode_single").val();
            var address = $("#iben_elta_order_metabox_address_single").val();

            if (id_referrence == "") {
                error = true;
                alert("Κωδικός δεν μπορεί να είναι κενός");
            }

            if (postal_code == "") {
                error = true;
                alert("ΤΚ δεν μπορεί να είναι κενό");
            }

            if (!error) {
                $(iben_elta_contact_save).addClass("loading");
                var tempname = $(iben_elta_contact_save).text();
                $(iben_elta_contact_save).text("Loading...");
                $(iben_elta_contact_save).prop("disabled", true);

                $("#iben_elta_contact_save_response").removeClass("error");
                $("#iben_elta_contact_save_response").removeClass("updated");

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_save_single_contact_ajax_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            id_referrence: id_referrence,
                            fullname: fullname,
                            address: address,
                            postal_code: postal_code,
                            region: $("#iben_elta_order_metabox_region_single").val(),
                            phone1: $("#iben_elta_order_metabox_phone1_single").val(),
                            phone2: $("#iben_elta_order_metabox_phone2_single").val(),
                            comments: $("#iben_elta_order_metabox_comments_single").val(),
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            $(iben_elta_contact_save).prop("disabled", false);
                            $(iben_elta_contact_save).removeClass("loading");
                            $("#iben_elta_contact_save_response").addClass("updated");
                            $(iben_elta_contact_save).text(tempname);

                            $("#iben_elta_contact_save_response").html(data.result);
                        } else if (data.status === "failure") {
                            $(iben_elta_contact_save).prop("disabled", false);
                            $(iben_elta_contact_save).removeClass("loading");
                            $("#iben_elta_contact_save_response").addClass("error");
                            $(iben_elta_contact_save).text(tempname);
                            $("#iben_elta_contact_save_response").html(data.result);
                        } else {
                            alert("General failure error");
                        }
                    }
                );
            }
        });

        // LOAD CONTACT SINGLE
        var iben_elta_contact_load = "#iben_elta_contact_load";

        $(".wp-admin").on("click", iben_elta_contact_load, function () {
            var error = false;

            var id_referrence = $("#iben_elta_order_metabox_id_referrence_single").val();

            if (id_referrence == "") {
                error = true;
                alert("Κωδικός δεν μπορεί να είναι κενός");
            }

            if (!error) {
                $(iben_elta_contact_load).addClass("loading");
                var tempname = $(iben_elta_contact_load).text();
                $(iben_elta_contact_load).text("loading...");
                $(iben_elta_contact_load).prop("disabled", true);
                $(iben_elta_contact_load).removeClass("error");
                $(iben_elta_contact_load).removeClass("success");

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_load_single_contact_ajax_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            id_referrence: id_referrence,
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            $(iben_elta_contact_load).prop("disabled", false);
                            $(iben_elta_contact_load).removeClass("loading");
                            $(iben_elta_contact_load).addClass("success");
                            $(iben_elta_contact_load).text(tempname);

                            $("#iben_elta_contact_save_response").html(data.result);

                            if (data.exportsettings.contact_name) {
                                $("#iben_elta_order_metabox_fullname_single").val(data.exportsettings.contact_name);
                            }

                            if (data.exportsettings.contact_address) {
                                $("#iben_elta_order_metabox_address_single").val(data.exportsettings.contact_address);
                            }

                            if (data.exportsettings.contact_postal) {
                                $("#iben_elta_order_metabox_postalcode_single").val(data.exportsettings.contact_postal);
                            }

                            if (data.exportsettings.contact_region) {
                                $("#iben_elta_order_metabox_region_single").val(data.exportsettings.contact_region);
                            }

                            if (data.exportsettings.contact_tel1) {
                                $("#iben_elta_order_metabox_phone1_single").val(data.exportsettings.contact_tel1);
                            }
                            if (data.exportsettings.contact_tel2) {
                                $("#iben_elta_order_metabox_phone2_single").val(data.exportsettings.contact_tel2);
                            }
                            if (data.exportsettings.contact_comment) {
                                $("#iben_elta_order_metabox_comments_single").val(data.exportsettings.contact_comment);
                            }
                        } else if (data.status === "failure") {
                            $(iben_elta_contact_load).prop("disabled", false);
                            $(iben_elta_contact_load).removeClass("loading");
                            $(iben_elta_contact_load).addClass("error");
                            $(iben_elta_contact_load).text(tempname);

                            $("#iben_elta_contact_save_response").html(data.result);
                        } else {
                            alert("General failure error");
                        }
                    }
                );
            }
        });

        // COMPINE SINGLE VOUCHERS
        var iben_elta_order_button_single_compine_vouchers = ".iben_elta_order_button_single_compine_vouchers";

        $(".wp-admin").on("click", iben_elta_order_button_single_compine_vouchers, function (e) {
            e.preventDefault();

            var error = "";

            if (error == "") {
                $(this).prop("disabled", true);

                $(this).addClass("loading");
                var tempname = $(this).text();

                var id = $(this).data("id");
                var id_elta_reason = $(this).data("id_elta_reason");

                //spinner
                var spinner = ".iben_elta_compine_single.id_" + id + " .iben_elta_spinners";
                if (id_elta_reason == 1) {
                    var response = "#iben_elta_single_vouchers_response" + id;
                } else {
                    var response = "#iben_elta_single_returned_vouchers_response" + id;
                }

                var button = ".iben_elta_compine_single.id_" + id + " .iben_elta_order_button_single_compine_vouchers";

                $(spinner).show();

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_compine_single_vouchers_ajax_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            id: id,
                            id_elta_reason: id_elta_reason,
                            post_type: "order",
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        // handle response data
                        if (data.status === "success") {
                            $(button).prop("disabled", false);
                            $(button).removeClass("loading");
                            $(button).removeClass("error");
                            $(button).addClass("success");

                            $(button).text(tempname);
                            $(response).html(data.result);

                            //spinner
                            $(spinner).hide();
                        } else if (data.status === "failure") {
                            $(button).prop("disabled", false);
                            $(button).text(tempname);
                            // $(this).show();
                            $(button).removeClass("loading");
                            $(button).removeClass("success");
                            $(button).addClass("error");
                            $(response).html(data.result);

                            //spinner
                            $(spinner).hide();
                        } else {
                            alert("General failure");
                        }
                    }
                );
            }
        });

        //
        var iben_elta_order_button_compine_vouchers = ".iben_elta_order_vouchers .iben_elta_order_button_compine_vouchers";
        $(".wp-admin").on("click", iben_elta_order_button_compine_vouchers, function (e) {
            e.preventDefault();
            var error = "";
            var list = $(this).data("list");
            var id_order = $(this).data("id_order");

            if (error == "") {
                if (list) {
                    var order_id = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_order_id").val();
                    var post_type = $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_post_type").val();

                    $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_voucher_response").html("");
                    $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).prop("disabled", true);
                    $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).hide();
                    $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).addClass("loading");

                    var tempname = $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).val();
                    $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).text(tempname);

                    //spinner
                    $("#iben_elta_voucher_create_modal_response" + id_order + " " + ".iben_elta_compine_vouchers_spinner").show();
                } else {
                    var order_id = $("#iben_elta_order_metabox_order_id").val();
                    var post_type = $("#iben_elta_order_metabox_post_type").val();
                    $("#iben_elta_order_voucher_response").html("");
                    $(iben_elta_order_button_compine_vouchers).prop("disabled", true);
                    $(iben_elta_order_button_compine_vouchers).hide();
                    $(iben_elta_order_button_compine_vouchers).addClass("loading");

                    var tempname = $(iben_elta_order_button_compine_vouchers).text();
                    $(iben_elta_order_button_compine_vouchers).text(tempname);

                    //spinner
                    $(".iben_elta_compine_vouchers_spinner").show();
                }

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_compine_vouchers_ajax_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            order_id: order_id,
                            post_type: post_type,
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        // handle response data
                        if (data.status === "success") {
                            if (list) {
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).prop("disabled", false);
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).removeClass("loading");
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).removeClass("error");
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).addClass("success");
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).hide();

                                $(iben_elta_order_button_compine_vouchers).text(tempname);
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_voucher_response").html(data.result);

                                var ttname = ".wp-list-table .post-" + id_order + " .iben_elta_order_voucher";
                                $(ttname).html(data.result);

                                //spinner
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + ".iben_elta_compine_vouchers_spinner").hide();
                            } else {
                                $(iben_elta_order_button_compine_vouchers).prop("disabled", false);
                                $(iben_elta_order_button_compine_vouchers).removeClass("loading");
                                $(iben_elta_order_button_compine_vouchers).removeClass("error");
                                $(iben_elta_order_button_compine_vouchers).addClass("success");
                                $(iben_elta_order_button_compine_vouchers).hide();

                                $(iben_elta_order_button_compine_vouchers).text(tempname);
                                $("#iben_elta_order_voucher_response").html(data.result);

                                //spinner
                                $(".iben_elta_compine_vouchers_spinner").hide();
                            }
                        } else if (data.status === "failure") {
                            if (list) {
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).prop("disabled", false);
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).text(tempname);
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).show();
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).removeClass("loading");
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).removeClass("success");
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).addClass("error");
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + iben_elta_order_button_compine_vouchers).text(data.result);

                                //spinner
                                $("#iben_elta_voucher_create_modal_response" + id_order + " " + ".iben_elta_compine_vouchers_spinner").hide();
                            } else {
                                $(iben_elta_order_button_compine_vouchers).prop("disabled", false);
                                $(iben_elta_order_button_compine_vouchers).text(tempname);
                                $(iben_elta_order_button_compine_vouchers).show();
                                $(iben_elta_order_button_compine_vouchers).removeClass("loading");
                                $(iben_elta_order_button_compine_vouchers).removeClass("success");
                                $(iben_elta_order_button_compine_vouchers).addClass("error");
                                $(iben_elta_order_button_compine_vouchers).text(data.result);

                                //spinner
                                $(".iben_elta_compine_vouchers_spinner").hide();
                            }
                        } else {
                            alert("General failure");
                        }
                    }
                );
            }
        });

        //
        var iben_elta_order_button_compine_ret_vouchers = ".iben_elta_order_vouchers .iben_elta_order_button_compine_ret_vouchers";
        $(".wp-admin").on("click", iben_elta_order_button_compine_ret_vouchers, function (e) {
            e.preventDefault();

            var error = "";

            if (error == "") {
                $("#iben_elta_order_returned_vouchers_response").html("");
                $(iben_elta_order_button_compine_ret_vouchers).prop("disabled", true);
                $(iben_elta_order_button_compine_ret_vouchers).hide();

                $(iben_elta_order_button_compine_ret_vouchers).addClass("loading");
                var tempname = $(iben_elta_order_button_compine_ret_vouchers).text();

                //spinner
                $(".iben_elta_compine_returned_vouchers_spinner").show();

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_compine_returned_vouchers_ajax_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            order_id: $("#iben_elta_order_metabox_order_id").val(),
                            post_type: $("#iben_elta_order_metabox_post_type").val(),
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            $(iben_elta_order_button_compine_ret_vouchers).prop("disabled", false);
                            $(iben_elta_order_button_compine_ret_vouchers).removeClass("loading");
                            $(iben_elta_order_button_compine_ret_vouchers).removeClass("error");
                            $(iben_elta_order_button_compine_ret_vouchers).addClass("success");

                            $(iben_elta_order_button_compine_ret_vouchers).text(tempname);
                            $("#iben_elta_order_returned_vouchers_response").html(data.result);

                            // spinner
                            $(".iben_elta_compine_returned_vouchers_spinner").hide();
                        } else if (data.status === "failure") {
                            $(iben_elta_order_button_compine_ret_vouchers).prop("disabled", false);
                            $(iben_elta_order_button_compine_ret_vouchers).text(tempname);
                            $(iben_elta_order_button_compine_ret_vouchers).show();
                            $(iben_elta_order_button_compine_ret_vouchers).removeClass("loading");
                            $(iben_elta_order_button_compine_ret_vouchers).removeClass("success");
                            $(iben_elta_order_button_compine_ret_vouchers).addClass("error");

                            $("#iben_elta_order_returned_vouchers_response").html(data.result);

                            // spinner
                            $(".iben_elta_compine_returned_vouchers_spinner").hide();
                        } else {
                            alert("General failure");
                        }
                    }
                );
            }
        });

        // BUTTON check delivery status on vouchers list
        var iben_elta_vouchers_status_list = ".iben_elta_vouchers_status_list";

        $(".wp-admin").on("click", iben_elta_vouchers_status_list, function (e) {
            e.preventDefault();

            var update_id = $(this).data("updateid");
            var id_order = $(this).data("id_order");
            var id_elta_reason = $(this).data("id_elta_reason");
            var id_elta_account = $(this).data("id_elta_account");

            var error = false;

            if (!error) {
                $("#iben_elta_voucherslist_status_response" + update_id).text("Loading...");
                $("#iben_elta_voucherslist_status_response" + update_id).addClass("loading");

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_check_delivery_voucher_list_ajax_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            update_id: update_id,
                            id_order: id_order,
                            id_elta_reason: id_elta_reason,
                            id_elta_account: id_elta_account,
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        // handle response data
                        if (data.status === "success") {
                            $("#iben_elta_voucherslist_status_response" + update_id).removeClass("loading");
                            $("#iben_elta_voucherslist_status_response" + update_id).removeClass("error");
                            $("#iben_elta_voucherslist_status_response" + update_id).addClass("success");

                            $("#iben_elta_voucherslist_status_response" + update_id).html(data.result);
                        } else if (data.status === "failure") {
                            $("#iben_elta_voucherslist_status_response" + update_id).removeClass("loading");
                            $("#iben_elta_voucherslist_status_response" + update_id).removeClass("success");
                            $("#iben_elta_voucherslist_status_response" + update_id).addClass("error");

                            $("#iben_elta_voucherslist_status_response" + update_id).text(data.result);
                        } else {
                            alert("General failure");
                        }
                    }
                );
            }
        });

        // BUTTON Voucher info modal window
        var iben_elta_voucher_info_modal_trigger = ".iben_elta_voucher_info_modal_trigger";

        $(".wp-admin").on("click", iben_elta_voucher_info_modal_trigger, function (e) {
            e.preventDefault();

            var id_response = $(this).data("id_response");
            var id_order = $(this).data("id_order");
            var id_elta_reason = $(this).data("id_elta_reason");
            var id_elta_account = $(this).data("id_elta_account");

            var error = false;

            if (!error) {
                $("#iben_elta_voucher_info_modal_response" + id_response).text("Loading...");

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_voucher_info_modal_ajax_handler_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            id_response: id_response,
                            id_order: id_order,
                            id_elta_reason: id_elta_reason,
                            id_elta_account: id_elta_account,
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            $("#iben_elta_voucher_info_modal_response" + id_response).html(data.result);
                        } else if (data.status === "failure") {
                            $("#iben_elta_voucher_info_modal_response" + id_response).text(data.result);
                        } else {
                            alert("General failure (modal_trigger)");
                        }
                    }
                );
            }
        });

        // BUTTON Tracinng voucher on modal window
        var iben_elta_order_voucher_tracing_modal_trigger = ".iben_elta_order_voucher_tracing_modal_trigger";

        $(".wp-admin").on("click", iben_elta_order_voucher_tracing_modal_trigger, function (e) {
            e.preventDefault();

            var id_response = $(this).data("id_response");
            var id_order = $(this).data("id_order");
            var id_elta_reason = $(this).data("id_elta_reason");
            var id_elta_account = $(this).data("id_elta_account");

            var error = false;

            if (!error) {
                $("#iben_elta_voucher_tracing_modal_response" + id_response).text("Loading...");

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_voucher_tracing_modal_ajax_handler_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            id_response: id_response,
                            id_order: id_order,
                            id_elta_reason: id_elta_reason,
                            id_elta_account: id_elta_account,
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            $("#iben_elta_voucher_tracing_modal_response" + id_response).html(data.result);
                        } else if (data.status === "failure") {
                            $("#iben_elta_voucher_tracing_modal_response" + id_response).text(data.result);
                        } else {
                            alert("General failure");
                        }
                    }
                );
            }
        });

        // BUTTON Create Order voucher on modal window
        var iben_elta_voucher_create_modal_trigger = ".iben_elta_voucher_create_modal_trigger";

        $(".wp-admin").on("click", iben_elta_voucher_create_modal_trigger, function (e) {
            e.preventDefault();

            var id_order = $(this).data("id_order");

            var error = false;

            if (!error) {
                $("#iben_elta_voucher_create_modal_response" + id_order).text("Loading...");

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_voucher_create_modal_ajax_handler_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            id_order: id_order,
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            $("#iben_elta_voucher_create_modal_response" + id_order).html(data.result);
                        } else if (data.status === "failure") {
                            $("#iben_elta_voucher_create_modal_response" + id_order).text(data.result);
                        } else {
                            alert("General failure (modal_trigger)");
                        }
                    }
                );
            }
        });

        // BUTTON Create Single voucher on modal window
        var iben_elta_voucher_create_single_modal_trigger = ".iben_elta_voucher_create_single_modal_trigger";

        $(".wp-admin").on("click", iben_elta_voucher_create_single_modal_trigger, function (e) {
            e.preventDefault();

            var error = false;

            if (!error) {
                $("#iben_elta_voucher_create_modal_response_single").text("Loading...");

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_voucher_create_single_modal_ajax_handler_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status == "success") {
                            $("#iben_elta_voucher_create_modal_response_single").html(data.result);
                        } else if (data.status == "failure") {
                            $("#iben_elta_voucher_create_modal_response_single").text(data.result);
                        } else {
                            alert("General failure (modal_trigger)");
                        }
                    }
                );
            }
        });

        // Button Tracing Voucher on edit order
        var iben_elta_order_tracing_button = ".iben_elta_order_tracing_button";

        $(".wp-admin").on("click", iben_elta_order_tracing_button, function () {
            var error = false;
            var id_order = $(this).data("id_order");
            var voucher = $(".iben_elta_order_right_box_tools .list_tracing_tracing_voucher" + id_order).val();

            if (voucher == "") {
                error = true;
                alert("Συμπληρώστε το voucher");
            }

            if (!error) {
                $(".iben_elta_order_right_box_tools .tools_response_id_order_" + id_order).html("");

                $(this).addClass("loading");
                var tempname = $(this).text();
                $(this).text("loading..");
                $(this).prop("disabled", true);

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_tracing_ajax_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            order_id: $("#iben_elta_order_metabox_order_id").val(),
                            post_type: $("#iben_elta_order_metabox_post_type").val(),
                            ref_flag: $(".iben_elta_order_right_box_tools .list_tracing_ref" + id_order + " option:selected").val(),
                            voucher: voucher,
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            $(".iben_elta_order_right_box_tools .list_tracing_button" + id_order).prop("disabled", false);
                            $(".iben_elta_order_right_box_tools .list_tracing_button" + id_order).removeClass("loading");
                            $(".iben_elta_order_right_box_tools .list_tracing_button" + id_order).removeClass("error");
                            $(".iben_elta_order_right_box_tools .list_tracing_button" + id_order).addClass("success");
                            $(".iben_elta_order_right_box_tools .list_tracing_button" + id_order).text(tempname);
                            $(".iben_elta_order_right_box_tools .tools_response_id_order_" + id_order).html(data.result);
                        } else if (data.status === "failure") {
                            $(".iben_elta_order_right_box_tools .list_tracing_button" + id_order).prop("disabled", false);
                            $(".iben_elta_order_right_box_tools .list_tracing_button" + id_order).removeClass("loading");
                            $(".iben_elta_order_right_box_tools .list_tracing_button" + id_order).removeClass("error");
                            $(".iben_elta_order_right_box_tools .list_tracing_button" + id_order).addClass("success");
                            $(".iben_elta_order_right_box_tools .list_tracing_button" + id_order).text(tempname);
                            $(".iben_elta_order_right_box_tools .tools_response_id_order_" + id_order).html(data.result);
                        } else {
                            // do nothing
                            alert("General failure");
                        }
                    }
                );
            }
        });

        // Button Check ZIP station on edit order
        var iben_elta_order_station_button = ".iben_elta_order_station_button";

        $(".wp-admin").on("click", iben_elta_order_station_button, function () {
            var error = false;
            var id_order = $(this).data("id_order");
            var postal_code = $(".iben_elta_order_right_box_tools .list_station_zip" + id_order).val();

            if (postal_code == "") {
                error = true;
                alert("Συμπληρώστε το ΤΚ");
            }

            if (!error) {
                $(".iben_elta_order_right_box_tools .tools_response_id_order_" + id_order).html("");

                $(this).addClass("loading");
                var tempname = $(this).text();
                $(this).text("loading..");
                $(this).prop("disabled", true);

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_station_ajax_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            order_id: $("#iben_elta_order_metabox_order_id").val(),
                            post_type: $("#iben_elta_order_metabox_post_type").val(),
                            postal_code: postal_code,
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            $(".iben_elta_order_right_box_tools .list_station_button" + id_order).prop("disabled", false);
                            $(".iben_elta_order_right_box_tools .list_station_button" + id_order).removeClass("loading");
                            $(".iben_elta_order_right_box_tools .list_station_button" + id_order).removeClass("error");
                            $(".iben_elta_order_right_box_tools .list_station_button" + id_order).addClass("success");

                            $(".iben_elta_order_right_box_tools .list_station_button" + id_order).text(tempname);
                            $(".iben_elta_order_right_box_tools .tools_response_id_order_" + id_order).html(data.result);
                        } else if (data.status === "failure") {
                            $(".iben_elta_order_right_box_tools .list_station_button" + id_order).prop("disabled", false);
                            $(".iben_elta_order_right_box_tools .list_station_button" + id_order).removeClass("loading");
                            $(".iben_elta_order_right_box_tools .list_station_button" + id_order).removeClass("success");
                            $(".iben_elta_order_right_box_tools .list_station_button" + id_order).addClass("error");

                            $(".iben_elta_order_right_box_tools .list_station_button" + id_order).text(tempname);
                            $(".iben_elta_order_right_box_tools .tools_response_id_order_" + id_order).html(data.result);
                        } else {
                            // do nothing
                            alert("General failure");
                        }
                    }
                );
            }
        });

        // SINGLE Button Tracing Voucher on edit order
        var iben_elta_order_tracing_button_single = "#iben_elta_order_tracing_button_single";

        $(".wp-admin").on("click", iben_elta_order_tracing_button_single, function () {
            var error = false;

            var voucher = $("#iben_elta_order_tracing_voucher_single").val();

            if (voucher == "") {
                error = true;
                alert("Συμπληρώστε το voucher");
            }

            if (!error) {
                $("#iben_elta_order_tools_response_single").html("");

                $(iben_elta_order_tracing_button_single).addClass("loading");
                var tempname = $(iben_elta_order_tracing_button_single).text();
                $(iben_elta_order_tracing_button_single).text("loading..");
                $(iben_elta_order_tracing_button_single).prop("disabled", true);

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_tracing_ajax_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            order_id: $("#iben_elta_order_metabox_order_id").val(),
                            post_type: $("#iben_elta_order_metabox_post_type").val(),
                            ref_flag: $("#iben_elta_order_tracing_voucher_ref_single").val(),
                            voucher: voucher,
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            $(iben_elta_order_tracing_button_single).prop("disabled", false);
                            $(iben_elta_order_tracing_button_single).removeClass("loading");
                            $(iben_elta_order_tracing_button_single).removeClass("error");
                            $(iben_elta_order_tracing_button_single).addClass("success");

                            $(iben_elta_order_tracing_button_single).text(tempname);
                            $("#iben_elta_order_tools_response_single").html(data.result);
                        } else if (data.status === "failure") {
                            $(iben_elta_order_tracing_button_single).prop("disabled", false);
                            $(iben_elta_order_tracing_button_single).removeClass("loading");
                            $(iben_elta_order_tracing_button_single).removeClass("success");
                            $(iben_elta_order_tracing_button_single).addClass("error");

                            $(iben_elta_order_tracing_button_single).text(tempname);
                            $("#iben_elta_order_tools_response_single").html(data.result);
                        } else {
                            // do nothing
                            alert("General failure");
                        }
                    }
                );
            }
        });

        // SINGLE Button Check ZIP station on edit order
        var iben_elta_order_station_button_single = "#iben_elta_order_station_button_single";

        $(".wp-admin").on("click", iben_elta_order_station_button_single, function () {
            var error = false;

            var postal_code = $("#iben_elta_order_station_voucher_single").val();

            if (postal_code == "") {
                error = true;
                alert("Συμπληρώστε το ΤΚ");
            }

            if (!error) {
                $("#iben_elta_order_tools_response_single").html("");

                $(iben_elta_order_station_button_single).addClass("loading");
                var tempname = $(iben_elta_order_station_button_single).text();
                $(iben_elta_order_station_button_single).text("loading");
                $(iben_elta_order_station_button_single).prop("disabled", true);

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_station_ajax_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            order_id: $("#iben_elta_order_metabox_order_id").val(),
                            post_type: $("#iben_elta_order_metabox_post_type").val(),
                            postal_code: postal_code,
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            $(iben_elta_order_station_button_single).prop("disabled", false);
                            $(iben_elta_order_station_button_single).removeClass("loading");
                            $(iben_elta_order_station_button_single).removeClass("error");
                            $(iben_elta_order_station_button_single).addClass("success");

                            $(iben_elta_order_station_button_single).text(tempname);
                            $("#iben_elta_order_tools_response_single").html(data.result);
                        } else if (data.status === "failure") {
                            $(iben_elta_order_station_button_single).prop("disabled", false);
                            $(iben_elta_order_station_button_single).removeClass("loading");
                            $(iben_elta_order_station_button_single).removeClass("success");
                            $(iben_elta_order_station_button_single).addClass("error");

                            $(iben_elta_order_station_button_single).text(tempname);
                            $("#iben_elta_order_tools_response_single").html(data.result);
                        } else {
                            // do nothing
                            alert("General failure");
                        }
                    }
                );
            }
        });

        function iben_generateRandString(length = 8) {
            var result = "";
            var characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
            var charactersLength = characters.length;
            for (var i = 0; i < length; i++) {
                result += characters.charAt(Math.floor(Math.random() * charactersLength));
            }
            return result;
        }

        // reprint vouchers
        var list_bulk_reprint = ".iben_elta_order_list_bulk_reprint";

        $(".wp-admin").on("click", list_bulk_reprint, function (e) {
            e.preventDefault();
            var error = false;

            var myarray = [];
            var idcolumn = $(this).data("idcolumn");

            if (idcolumn != "id" && idcolumn != "post") {
                error = true;
                alert("Δεν υπάρχει αναγνωριστικό για την επιλογή των παραγγελειών");
            }

            $('input[name="' + idcolumn + '[]"]:checked').each(function (index) {
                myarray[index] = $(this).val();
            });

            if (myarray.length == 0) {
                error = true;
                alert("Επιλέξτε μια παραγγελία");
            }
            if (!error) {
                var compined_name = iben_generateRandString() + "BULK";

                $(list_bulk_reprint).addClass("loading");
                var tempname = $(list_bulk_reprint).text();
                $(list_bulk_reprint).text("Loading");
                $(list_bulk_reprint).prop("disabled", true);

                //spinner
                $(".iben_elta_order_list_bulk_reprint_spinner").show();

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_bulk_reprint_vouchers_ajax_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            order_id: $("#iben_elta_order_metabox_order_id").val(),
                            post_type: $("#iben_elta_order_metabox_post_type").val(),
                            id_arrays: myarray,
                            compined_name: compined_name,
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            $(list_bulk_reprint).prop("disabled", false);
                            $(list_bulk_reprint).removeClass("loading");
                            $(list_bulk_reprint).addClass("success");

                            $(list_bulk_reprint).text(tempname);

                            $("#iben_compine_multipdfs_response").html(data.result);

                            //spinner
                            $(".iben_elta_order_list_bulk_reprint_spinner").hide();
                        } else if (data.status === "failure") {
                            $(list_bulk_reprint).prop("disabled", false);
                            $(list_bulk_reprint).removeClass("loading");
                            $(list_bulk_reprint).addClass("error");

                            //spinner
                            $(".iben_elta_order_list_bulk_reprint_spinner").hide();
                            $(list_bulk_reprint).text(tempname);
                            $("#iben_compine_multipdfs_response").html(data.result);
                        } else {
                            alert("General failure");
                        }
                    }
                );
            }
        });

        // create multi vouchers
        var list_bulk_create_voucher = ".iben_elta_order_list_bulk_create_voucher";
        $(".wp-admin").on("click", list_bulk_create_voucher, function (e) {
            e.preventDefault();
            var error = false;
            var idsarray = [];

            var idcolumn = $(this).data("idcolumn");
            if (idcolumn != "id" && idcolumn != "post") {
                error = true;
                alert("Δεν υπάρχει αναγνωριστικό για την επιλογή των παραγγελειών");
            }
            $('input[name="' + idcolumn + '[]"]:checked').each(function (index) {
                idsarray[index] = $(this).val();
            });

            if (idsarray.length == 0) {
                error = true;
                alert("Επιλέξτε μια παραγγελία ");
            }

            if (!error) {
                $(list_bulk_create_voucher).addClass("loading");
                var tempname = $(list_bulk_create_voucher).text();
                $(list_bulk_create_voucher).text("Loading..");
                $(list_bulk_create_voucher).prop("disabled", true);

                //spinner
                $(".iben_elta_order_list_bulk_create_voucher_spinner").show();
                $("#iben_elta_create_multipdfs_response").hide();

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_bulk_create_vouchers_ajax_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            id_arrays: idsarray,
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            $(list_bulk_create_voucher).prop("disabled", false);
                            $(list_bulk_create_voucher).removeClass("loading");
                            $(list_bulk_create_voucher).addClass("success");

                            $(list_bulk_create_voucher).text(tempname);

                            $("#iben_elta_create_multipdfs_response").show();
                            $("#iben_elta_create_multipdfs_response").html(data.result);

                            //spinner
                            $(".iben_elta_order_list_bulk_create_voucher_spinner").hide();
                        } else if (data.status === "failure") {
                            $(list_bulk_create_voucher).prop("disabled", false);
                            $(list_bulk_create_voucher).removeClass("loading");
                            $(list_bulk_create_voucher).addClass("error");

                            //spinner
                            $(".iben_elta_order_list_bulk_create_voucher_spinner").hide();
                            $(list_bulk_create_voucher).text(tempname);
                            $("#iben_elta_create_multipdfs_response").show();
                            $("#iben_elta_create_multipdfs_response").html(data.result);
                        } else {
                            alert("General failure");
                        }
                    }
                );
            }
        });

        var iben_elta_settings_remove_bulk = "#iben_elta_settings_remove_bulk";

        $(".wp-admin").on("click", iben_elta_settings_remove_bulk, function (e) {
            e.preventDefault();

            $(iben_elta_settings_remove_bulk).addClass("loading");
            var tempname = $(iben_elta_settings_remove_bulk).text();
            $(iben_elta_settings_remove_bulk).text("Loading");
            $(iben_elta_settings_remove_bulk).prop("disabled", true);

            //spinner
            $(".iben_elta_settings_remove_bulk_spinner").show();

            $.post(
                iben_elta_jscript.url,
                {
                    action: "iben_elta_settings_remove_bulk_ajax_hook",
                    dataType: "json",
                    iben_data: {
                        iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                    },
                },
                function (data) {
                    var data = JSON.parse(data);

                    if (data.status === "success") {
                        $(iben_elta_settings_remove_bulk).prop("disabled", false);
                        $(iben_elta_settings_remove_bulk).removeClass("loading");
                        $(iben_elta_settings_remove_bulk).addClass("success");

                        $(iben_elta_settings_remove_bulk).text(data.result);

                        //spinner
                        $(".iben_elta_settings_remove_bulk_spinner").hide();
                    } else if (data.status === "failure") {
                        $(iben_elta_settings_remove_bulk).prop("disabled", false);
                        $(iben_elta_settings_remove_bulk).removeClass("loading");
                        $(iben_elta_settings_remove_bulk).addClass("error");

                        $(iben_elta_settings_remove_bulk).html(data.result);

                        //spinner
                        $(".iben_elta_settings_remove_bulk_spinner").hide();
                    } else {
                        alert("General failure");
                    }
                }
            );
        });

        function ibenConvertUppercase(text) {
            var newtext = text.replace("Έ", "Ε");
            newtext = newtext.replace("Ά", "Α");
            newtext = newtext.replace("Ύ", "Υ");
            newtext = newtext.replace("Ή", "Η");
            newtext = newtext.replace("Ί", "Ι");
            newtext = newtext.replace("Ό", "Ο");
            newtext = newtext.replace("Ώ", "Ω");

            return newtext;
        }

        $(".wp-admin").on("click", "#iben_elta_convert_uppercase", function (e) {
            e.preventDefault();

            var list = $(this).data("list");
            var id_order = $(this).data("id_order");

            if (list) {
                var textadd = $("#iben_elta_voucher_create_modal_response" + id_order + " " + ".iben_elta_order_metabox_fullname")
                    .val()
                    .toUpperCase();
                var textadd1 = $("#iben_elta_voucher_create_modal_response" + id_order + " " + ".iben_elta_order_metabox_address")
                    .val()
                    .toUpperCase();
                var textadd2 = $("#iben_elta_voucher_create_modal_response" + id_order + " " + ".iben_elta_order_metabox_region")
                    .val()
                    .toUpperCase();
                var textadd3 = $("#iben_elta_voucher_create_modal_response" + id_order + " " + ".iben_elta_order_metabox_comments")
                    .val()
                    .toUpperCase();
            } else {
                var textadd = $(".iben_elta_order_metabox_fullname").val().toUpperCase();
                var textadd1 = $(".iben_elta_order_metabox_address").val().toUpperCase();
                var textadd2 = $(".iben_elta_order_metabox_region").val().toUpperCase();
                var textadd3 = $(".iben_elta_order_metabox_comments").val().toUpperCase();
            }

            textadd = ibenConvertUppercase(textadd);
            $(".iben_elta_order_metabox_fullname").val(textadd);

            textadd1 = ibenConvertUppercase(textadd1);
            $(".iben_elta_order_metabox_address").val(textadd1);

            textadd2 = ibenConvertUppercase(textadd2);
            $(".iben_elta_order_metabox_region").val(textadd2);

            textadd3 = ibenConvertUppercase(textadd3);
            $(".iben_elta_order_metabox_comments").val(textadd3);
        });

        $(".wp-admin").on("click", "#iben_elta_convert_single_uppercase", function (e) {
            e.preventDefault();

            var textadd = $(".iben_elta_order_metabox_fullname_single").val().toUpperCase();
            textadd = ibenConvertUppercase(textadd);
            $(".iben_elta_order_metabox_fullname_single").val(textadd);

            var textadd1 = $(".iben_elta_order_metabox_address_single").val().toUpperCase();
            textadd1 = ibenConvertUppercase(textadd1);
            $(".iben_elta_order_metabox_address_single").val(textadd1);

            var textadd2 = $(".iben_elta_order_metabox_region_single").val().toUpperCase();
            textadd2 = ibenConvertUppercase(textadd2);
            $(".iben_elta_order_metabox_region_single").val(textadd2);

            var textadd3 = $(".iben_elta_order_metabox_comments_single").val().toUpperCase();
            textadd3 = ibenConvertUppercase(textadd3);
            $(".iben_elta_order_metabox_comments_single").val(textadd3);
        });

        var tempname = $("#iben_elta_order_create_voucher").text();

        $(".wp-admin").on("change", "#iben_elta_order_metabox_sur_1", function (e) {
            var list = $(this).data("list");
            var id_order = $(this).data("id_order");

            if (list) {
                if ($("#iben_elta_voucher_create_modal_response" + id_order + " " + "#iben_elta_order_metabox_sur_1").val() == 1) {
                    $("#iben_elta_voucher_create_modal_response" + id_order + " " + ".iben-normal-shipping-button").hide();
                    $("#iben_elta_voucher_create_modal_response" + id_order + " " + ".iben-returned-shipping-button").show();
                } else {
                    $("#iben_elta_voucher_create_modal_response" + id_order + " " + ".iben-normal-shipping-button").show();
                    $("#iben_elta_voucher_create_modal_response" + id_order + " " + ".iben-returned-shipping-button").hide();
                }
            } else {
                if ($("#iben_elta_courier_order_metabox" + " " + "#iben_elta_order_metabox_sur_1").val() == 1) {
                    $(".iben-normal-shipping-button").hide();
                    $(".iben-returned-shipping-button").show();
                } else {
                    $(".iben-normal-shipping-button").show();
                    $(".iben-returned-shipping-button").hide();
                }
            }
        });

        $(".wp-admin").on("click", "#iben_elta_order_create_voucher_more", function (e) {
            e.preventDefault();
            $(this).hide();
            $(".iben_elta_order_loadmore_hidden_section").toggleClass("more");
        });

        //if elta metabox exist, then check
        if ($("#iben_elta_courier_order_metabox").length == 1) {
            var text_length = $("#iben_elta_order_metabox_comments").val().length;
            $("#iben_elta_order_metabox_comments_counter").text(text_length);
        }

        $(".wp-admin").on("keyup", "#iben_elta_order_metabox_comments", function () {
            var text_length = $("#iben_elta_order_metabox_comments").val().length;
            $("#iben_elta_order_metabox_comments_counter").text(text_length);
        });

        $(".wp-admin").on("click", ".iben_elta_fix_username", function (e) {
            e.preventDefault();

            var get_val = $("#iben_elta_main_settings_username").val();
            var get_length = $("#iben_elta_main_settings_username").val().length;

            if (get_length == 1) {
                $("#iben_elta_main_settings_username").val("000000" + get_val);
            } else if (get_length == 2) {
                $("#iben_elta_main_settings_username").val("00000" + get_val);
            } else if (get_length == 3) {
                $("#iben_elta_main_settings_username").val("0000" + get_val);
            } else if (get_length == 4) {
                $("#iben_elta_main_settings_username").val("000" + get_val);
            } else if (get_length == 5) {
                $("#iben_elta_main_settings_username").val("00" + get_val);
            } else if (get_length == 6) {
                $("#iben_elta_main_settings_username").val("0" + get_val);
            } else if (get_length == 7) {
            } else {
                alert("Δεν μπορεί να είναι κενό η παραπάνω απο 7 χαρακτήρες");
            }
        });

        $(".wp-admin").on("click", ".iben_elta_fix_2nd_username", function (e) {
            e.preventDefault();

            var get_val = $("#iben_elta_main_settings_2nd_username").val();
            var get_length = $("#iben_elta_main_settings_2nd_username").val().length;

            if (get_length == 1) {
                $("#iben_elta_main_settings_2nd_username").val("000000" + get_val);
            } else if (get_length == 2) {
                $("#iben_elta_main_settings_2nd_username").val("00000" + get_val);
            } else if (get_length == 3) {
                $("#iben_elta_main_settings_2nd_username").val("0000" + get_val);
            } else if (get_length == 4) {
                $("#iben_elta_main_settings_2nd_username").val("000" + get_val);
            } else if (get_length == 5) {
                $("#iben_elta_main_settings_2nd_username").val("00" + get_val);
            } else if (get_length == 6) {
                $("#iben_elta_main_settings_2nd_username").val("0" + get_val);
            } else if (get_length == 7) {
            } else {
                alert("Δεν μπορεί να είναι κενό η παραπάνω απο 7 χαρακτήρες");
            }
        });

        // 2nd ACCOUNT
        // when load
        if ($("#iben_elta_main_settings_2nd_enable_account").prop("checked")) {
            $("#iben_elta_main_settings_2nd_customer").parents("tr").show();
            $("#iben_elta_main_settings_2nd_username").parents("tr").show();
            $("#iben_elta_main_settings_2nd_password").parents("tr").show();
            $("#iben_elta_main_settings_2nd_sub_password").parents("tr").show();
        } else {
            $("#iben_elta_main_settings_2nd_customer").parents("tr").hide();
            $("#iben_elta_main_settings_2nd_username").parents("tr").hide();
            $("#iben_elta_main_settings_2nd_password").parents("tr").hide();
            $("#iben_elta_main_settings_2nd_sub_password").parents("tr").hide();
        }

        // when click
        $(".wp-admin").on("click", "#iben_elta_main_settings_2nd_enable_account", function (e) {
            // $("#iben_elta_main_settings_2nd_enable_account").click(function (){

            if ($(this).prop("checked")) {
                $("#iben_elta_main_settings_2nd_customer").parents("tr").show("slow");
                $("#iben_elta_main_settings_2nd_username").parents("tr").show("slow");
                $("#iben_elta_main_settings_2nd_password").parents("tr").show("slow");
                $("#iben_elta_main_settings_2nd_sub_password").parents("tr").show("slow");
            } else {
                $("#iben_elta_main_settings_2nd_customer").parents("tr").hide("slow");
                $("#iben_elta_main_settings_2nd_username").parents("tr").hide("slow");
                $("#iben_elta_main_settings_2nd_password").parents("tr").hide("slow");
                $("#iben_elta_main_settings_2nd_sub_password").parents("tr").hide("slow");
            }
        });

        // Automatically create voucher
        // when load
        if ($("#iben_elta_main_settings_auto_createv_enable").prop("checked")) {
            $("#iben_elta_main_settings_auto_createv_create_pdf").parents("tr").show("slow");
            $("#iben_elta_main_settings_auto_createv_set_order_completed").parents("tr").show("slow");
            $("#iben_elta_main_settings_auto_createv_send_completed_email").parents("tr").show("slow");
            $("#iben_elta_main_settings_auto_createv_resend_admin_email").parents("tr").show("slow");
            $("#iben_elta_main_settings_auto_createv_include_message").parents("tr").show("slow");
            $("#iben_elta_main_settings_auto_createv_cron_time").parents("tr").show("slow");

            if ($("#iben_elta_main_settings_auto_createv_include_message").prop("checked")) {
                $("#wp-iben_elta_main_settings_auto_createv_admin_body-wrap").parents("tr").show("slow");
            } else {
                $("#wp-iben_elta_main_settings_auto_createv_admin_body-wrap").parents("tr").hide();
            }
        } else {
            $("#iben_elta_main_settings_auto_createv_create_pdf").parents("tr").hide();
            $("#iben_elta_main_settings_auto_createv_set_order_completed").parents("tr").hide();
            $("#iben_elta_main_settings_auto_createv_send_completed_email").parents("tr").hide();
            $("#iben_elta_main_settings_auto_createv_resend_admin_email").parents("tr").hide();
            $("#iben_elta_main_settings_auto_createv_include_message").parents("tr").hide();
            $("#iben_elta_main_settings_auto_createv_cron_time").parents("tr").hide();
            $("#wp-iben_elta_main_settings_auto_createv_admin_body-wrap").parents("tr").hide("slow");
        }

        // when click
        $("#iben_elta_main_settings_auto_createv_enable").click(function () {
            if ($(this).prop("checked")) {
                $("#iben_elta_main_settings_auto_createv_create_pdf").parents("tr").show("slow");
                $("#iben_elta_main_settings_auto_createv_set_order_completed").parents("tr").show("slow");
                $("#iben_elta_main_settings_auto_createv_send_completed_email").parents("tr").show("slow");
                $("#iben_elta_main_settings_auto_createv_resend_admin_email").parents("tr").show("slow");
                $("#iben_elta_main_settings_auto_createv_include_message").parents("tr").show("slow");
                $("#iben_elta_main_settings_auto_createv_cron_time").parents("tr").show("slow");

                if ($("#iben_elta_main_settings_auto_createv_include_message").prop("checked")) {
                    $("#wp-iben_elta_main_settings_auto_createv_admin_body-wrap").parents("tr").show("slow");
                }
            } else {
                $("#iben_elta_main_settings_auto_createv_create_pdf").parents("tr").hide("slow");
                $("#iben_elta_main_settings_auto_createv_set_order_completed").parents("tr").hide("slow");
                $("#iben_elta_main_settings_auto_createv_send_completed_email").parents("tr").hide("slow");
                $("#iben_elta_main_settings_auto_createv_resend_admin_email").parents("tr").hide();
                $("#iben_elta_main_settings_auto_createv_include_message").parents("tr").hide();
                $("#iben_elta_main_settings_auto_createv_cron_time").parents("tr").hide();
                $("#wp-iben_elta_main_settings_auto_createv_admin_body-wrap").parents("tr").hide("slow");
            }
        });

        // Include admin message When click
        $("#iben_elta_main_settings_auto_createv_include_message").click(function () {
            if ($(this).prop("checked") && $("#iben_elta_main_settings_auto_createv_enable").prop("checked")) {
                $("#wp-iben_elta_main_settings_auto_createv_admin_body-wrap").parents("tr").show("slow");
            } else {
                $("#wp-iben_elta_main_settings_auto_createv_admin_body-wrap").parents("tr").hide("slow");
            }
        });

        // Email tracking code PANEL
        // when load
        if ($("#iben_elta_main_settings_email_completed").prop("checked")) {
            $("#wp-iben_elta_main_settings_email_default_body-wrap").parents("tr").show("slow");
            $("#iben_elta_main_settings_email_checked_default_completed").parents("tr").show("slow");
        } else {
            $("#wp-iben_elta_main_settings_email_default_body-wrap").parents("tr").hide();
            $("#iben_elta_main_settings_email_checked_default_completed").parents("tr").hide();
        }

        // when click
        $("#iben_elta_main_settings_email_completed").click(function () {
            if ($(this).prop("checked")) {
                $("#wp-iben_elta_main_settings_email_default_body-wrap").parents("tr").show("slow");
                $("#iben_elta_main_settings_email_checked_default_completed").parents("tr").show("slow");
            } else {
                $("#wp-iben_elta_main_settings_email_default_body-wrap").parents("tr").hide("slow");
                $("#iben_elta_main_settings_email_checked_default_completed").parents("tr").hide("slow");
            }
        });

        // Automatically check delivery PANEL
        // when load
        if ($("#iben_elta_main_settings_enable_cron_check_delivery").prop("checked")) {
            $("#iben_elta_main_settings_cron_check_time").parents("tr").show("slow");
            $("#iben_elta_main_settings_cron_query_limit").parents("tr").show("slow");
            $("#iben_elta_main_settings_cron_change_order_status").parents("tr").show("slow");
            $("#iben_elta_main_settings_enable_email_cron_notification").parents("tr").show("slow");

            if ($("#iben_elta_main_settings_enable_email_cron_notification").prop("checked")) {
                $("#iben_elta_main_settings_admin_email_cron_notification").parents("tr").show("slow");
            } else {
                $("#iben_elta_main_settings_admin_email_cron_notification").parents("tr").hide();
            }
        } else {
            $("#iben_elta_main_settings_cron_check_time").parents("tr").hide();
            $("#iben_elta_main_settings_cron_query_limit").parents("tr").hide();
            $("#iben_elta_main_settings_cron_change_order_status").parents("tr").hide();
            $("#iben_elta_main_settings_enable_email_cron_notification").parents("tr").hide();
            $("#iben_elta_main_settings_admin_email_cron_notification").parents("tr").hide();
        }

        //when click
        $("#iben_elta_main_settings_enable_cron_check_delivery").click(function () {
            if ($(this).prop("checked")) {
                $("#iben_elta_main_settings_cron_check_time").parents("tr").show("slow");
                $("#iben_elta_main_settings_cron_query_limit").parents("tr").show("slow");
                $("#iben_elta_main_settings_cron_change_order_status").parents("tr").show("slow");
                $("#iben_elta_main_settings_enable_email_cron_notification").parents("tr").show("slow");

                if ($("#iben_elta_main_settings_enable_email_cron_notification").prop("checked")) {
                    $("#iben_elta_main_settings_admin_email_cron_notification").parents("tr").show("slow");
                }
            } else {
                $("#iben_elta_main_settings_cron_check_time").parents("tr").hide("slow");
                $("#iben_elta_main_settings_cron_query_limit").parents("tr").hide("slow");
                $("#iben_elta_main_settings_cron_change_order_status").parents("tr").hide("slow");
                $("#iben_elta_main_settings_enable_email_cron_notification").parents("tr").hide("slow");

                $("#iben_elta_main_settings_admin_email_cron_notification").parents("tr").hide("slow");
            }
        });

        $("#iben_elta_main_settings_enable_email_cron_notification").click(function () {
            if ($(this).prop("checked") && $("#iben_elta_main_settings_enable_cron_check_delivery").prop("checked")) {
                $("#iben_elta_main_settings_admin_email_cron_notification").parents("tr").show("slow");
            } else {
                $("#iben_elta_main_settings_admin_email_cron_notification").parents("tr").hide("slow");
            }
        });

        // DELETE pdf cron
        // when load
        if ($("#iben_elta_main_settings_delete_pdf_cron_enable").prop("checked")) {
            $("#iben_elta_main_settings_delete_pdf_cron_check_time").parents("tr").show();
            $("#iben_elta_main_settings_delete_pdf_cron_query").parents("tr").show();
        } else {
            $("#iben_elta_main_settings_delete_pdf_cron_check_time").parents("tr").hide();
            $("#iben_elta_main_settings_delete_pdf_cron_query").parents("tr").hide();
        }

        // when click
        $("#iben_elta_main_settings_delete_pdf_cron_enable").click(function () {
            if ($(this).prop("checked")) {
                $("#iben_elta_main_settings_delete_pdf_cron_check_time").parents("tr").show("slow");
                $("#iben_elta_main_settings_delete_pdf_cron_query").parents("tr").show("slow");
            } else {
                $("#iben_elta_main_settings_delete_pdf_cron_check_time").parents("tr").hide("slow");
                $("#iben_elta_main_settings_delete_pdf_cron_query").parents("tr").hide("slow");
            }
        });

        // FRONTEND
        // when load
        if ($("#iben_elta_main_settings_frontend_tracking_action_link_enable").prop("checked")) {
            $("#iben_elta_main_settings_frontend_tracking_action_link_text").parents("tr").show();
        } else {
            $("#iben_elta_main_settings_frontend_tracking_action_link_text").parents("tr").hide();
        }

        if ($("#iben_elta_main_settings_frontend_view_order_tracking_tracing_enable").prop("checked")) {
            $("#iben_elta_main_settings_frontend_view_order_tracking_tracing_title").parents("tr").show();
        } else {
            $("#iben_elta_main_settings_frontend_view_order_tracking_tracing_title").parents("tr").hide();
        }

        // when click
        $("#iben_elta_main_settings_frontend_tracking_action_link_enable").click(function () {
            if ($(this).prop("checked")) {
                $("#iben_elta_main_settings_frontend_tracking_action_link_text").parents("tr").show("slow");
            } else {
                $("#iben_elta_main_settings_frontend_tracking_action_link_text").parents("tr").hide("slow");
            }
        });

        $("#iben_elta_main_settings_frontend_view_order_tracking_tracing_enable").click(function () {
            if ($(this).prop("checked")) {
                $("#iben_elta_main_settings_frontend_view_order_tracking_tracing_title").parents("tr").show("slow");
            } else {
                $("#iben_elta_main_settings_frontend_view_order_tracking_tracing_title").parents("tr").hide("slow");
            }
        });

        var iben_elta_email_completed_click = ".iben_elta_settings_info_button #iben_elta_main_settings_email_completed, #iben_elta_tracking_order_notification";

        $(".wp-admin").on("click", iben_elta_email_completed_click, function (e) {
            var error = false;
            var update_email_completed;

            if ($(this).is(":checked")) {
                update_email_completed = 1;
            } else {
                update_email_completed = 0;
            }

            if (update_email_completed == "undefined") {
                error = true;
                e.preventDefault();
            }

            if (!error) {
                $(iben_elta_email_completed_click).attr("disabled", true);

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_change_postmeta_attach_tracking_info_email_ajax_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            order_id: $("#iben_elta_order_metabox_order_id").val(),
                            post_type: $("#iben_elta_order_metabox_post_type").val(),
                            update_email_completed: update_email_completed,
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            $(iben_elta_email_completed_click).attr("disabled", false);

                            if ($("#iben_elta_tracking_order_notification").length == 1) {
                                if (data.update_email_completed == 1) {
                                    $("#iben_elta_tracking_order_notification").prop("checked", true);
                                } else {
                                    $("#iben_elta_tracking_order_notification").prop("checked", false);
                                }
                            }

                            if ($("#iben_elta_main_settings_email_completed").length == 1) {
                                if (data.update_email_completed == 1) {
                                    $("#iben_elta_main_settings_email_completed").prop("checked", true);
                                } else {
                                    $("#iben_elta_main_settings_email_completed").prop("checked", false);
                                }
                            }
                        } else if (data.status === "failure") {
                            $(iben_elta_email_completed_click).attr("disabled", false);
                            alert(data.result);
                        } else {
                            $(iben_elta_email_completed_click).attr("disabled", false);
                            alert("Uknown error");
                        }
                    }
                );
            }
        });

        var iben_elta_send_iben_sms_completed = "#iben_elta_button_settings_send_iben_sms_completed, #iben_sms_lexicon_woo_customer_order_notification_meta";
        $(".wp-admin").on("click", iben_elta_send_iben_sms_completed, function (e) {
            // compatibility, so it runs only if metabox is there and order id exist, otherwise will handle from other iben plugins
            if ($("#iben_elta_order_metabox_order_id").length == 0) {
                return;
            }
            e.stopImmediatePropagation();

            var error = false;
            var update_send_sms;

            if ($(this).is(":checked")) {
                update_send_sms = 1;
            } else {
                update_send_sms = 0;
            }

            if (update_send_sms == "undefined") {
                error = true;
                e.preventDefault();
            }

            if (!error) {
                $(iben_elta_send_iben_sms_completed).attr("disabled", true);

                $.post(
                    iben_elta_jscript.url,
                    {
                        action: "iben_elta_change_postmeta_send_sms_completed_ajax_hook",
                        dataType: "json",
                        iben_data: {
                            iben_elta_nonce: iben_elta_jscript.iben_elta_nonce,
                            order_id: $("#iben_elta_order_metabox_order_id").val(),
                            post_type: $("#iben_elta_order_metabox_post_type").val(),
                            update_send_sms: update_send_sms,
                        },
                    },
                    function (data) {
                        var data = JSON.parse(data);

                        if (data.status === "success") {
                            $(iben_elta_send_iben_sms_completed).attr("disabled", false);

                            if ($("#iben_sms_lexicon_woo_customer_order_notification_meta").length == 1) {
                                if (data.update_send_sms == 1) {
                                    $("#iben_sms_lexicon_woo_customer_order_notification_meta").prop("checked", true);
                                } else {
                                    $("#iben_sms_lexicon_woo_customer_order_notification_meta").prop("checked", false);
                                }
                            }

                            if ($("#iben_elta_button_settings_send_iben_sms_completed").length == 1) {
                                if (data.update_send_sms == 1) {
                                    $("#iben_elta_button_settings_send_iben_sms_completed").prop("checked", true);
                                } else {
                                    $("#iben_elta_button_settings_send_iben_sms_completed").prop("checked", false);
                                }
                            }

                            // COMPATIBILITY *geniki voucher
                            if ($("#iben_geniki_button_settings_send_iben_sms_completed").length == 1) {
                                if (data.update_send_sms == 1) {
                                    $("#iben_geniki_button_settings_send_iben_sms_completed").prop("checked", true);
                                } else {
                                    $("#iben_geniki_button_settings_send_iben_sms_completed").prop("checked", false);
                                }
                            }

                            // COMPATIBILITY *ACS voucher
                            if ($("#iben_acs_button_settings_send_iben_sms_completed").length == 1) {
                                if (data.update_send_sms == 1) {
                                    $("#iben_acs_button_settings_send_iben_sms_completed").prop("checked", true);
                                } else {
                                    $("#iben_acs_button_settings_send_iben_sms_completed").prop("checked", false);
                                }
                            }

                            // COMPATIBILITY *SPEEDEX voucher
                            if ($("#iben_speedex_button_settings_send_iben_sms_completed").length == 1) {
                                if (data.update_send_sms == 1) {
                                    $("#iben_speedex_button_settings_send_iben_sms_completed").prop("checked", true);
                                } else {
                                    $("#iben_speedex_button_settings_send_iben_sms_completed").prop("checked", false);
                                }
                            }
                        } else if (data.status === "failure") {
                            $(iben_elta_send_iben_sms_completed).attr("disabled", false);
                            alert(data.result);
                        } else {
                            $(iben_elta_send_iben_sms_completed).attr("disabled", false);
                            alert("Uknown error");
                        }
                    }
                );

                return false;
            }
        });
    });
})(jQuery, window, document);
