<?php

namespace VIWEC\INC;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Email_Samples {

	protected static $instance = null;

	private function __construct() {
	}

	public static function init() {
		if ( null == self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public static function default_subject() {
		return apply_filters( 'viwec_sample_subjects', [
			'default'                           => esc_html__( 'This template will be used in the case of none detected template and the subject will be get from original email', 'viwec-email-template-customizer' ),
			'new_order'                         => '{customer_name} placed a new order #{order_number} on your store',
			'cancelled_order'                   => '{customer_name} has cancelled order #{order_number} on your store',
			'failed_order'                      => 'Order #{order_number} has failed on your store',
			'customer_failed_order'            => 'Hi {customer_name}, Your order at {site_title} was unsuccessful',
			'customer_cancelled_order'            => 'Hi {customer_name}, Your order {order_number} has been cancelled',
			'customer_on_hold_order'            => 'Hi {customer_name}, Your order {order_number} has been received!',
			'customer_processing_order'         => 'Hi {customer_name}, Your order {order_number} has been received!',
			'customer_completed_order'          => 'Hi {customer_name}, Your order {order_number} is now complete',
			'customer_refunded_order'           => 'Hi {customer_name}, Your order {order_number} has been refunded.',
			'customer_partially_refunded_order' => 'Hi {customer_name}, Your order {order_number} has been partially refunded.',
			'customer_invoice'                  => 'Invoice for order #{order_number} on {site_title}',
			'customer_invoice_pending'          => '{site_title} invoice',
			'customer_note'                     => 'Note added to your order {order_date} on {site_title}',
			'customer_reset_password'           => 'Hi {user_login}, Your password reset requested on {site_title}',
			'customer_new_account'              => 'Your account has been created on {site_title}'
		] );
	}

	public static function sample_templates() {
		//    ' . VIWEC_IMAGES . '
		//   ' . VIWEC_IMAGES . '

		return apply_filters( 'viwec_sample_templates', [
			'default' => [
				'basic' => [
					'name' => esc_html__( 'Basic', 'viwec-email-template-customizer' ),
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"transparent","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/recover_heading","style":{"width":"530px","font-size":"30px","font-weight":"600","color":"#444444","line-height":"45px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}}}},"2":{"props":{"style_outer":{"padding":"35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/recover_content","style":{"width":"530px"},"content":{},"attrs":{"show_img":"true"},"childStyle":{"p":{"font-size":"16px","font-weight":"400","line-height":"22px","color":"#444444","padding":"0px"},"h2":{"font-size":"20px","font-weight":"500","line-height":"25.2px","color":"#444444","padding":"25px 0px 10px"},".head.td":{"font-size":"16px","line-height":"18.2px","font-weight":"600","color":"#444444","border-color":"#f4f4f4","border-style":"dotted","border-width":"0px 0px 1px"},".body.td":{"font-size":"16px","line-height":"18.2px","color":"#444444","border-color":"#cccccc","border-style":"dashed","border-width":"1px 0px 0px"},"th.body.td":{"font-weight":"500"},"td.body.td":{"font-weight":"400"},".td":{"padding":"8px 0px"},"img":{"width":"80px"}}}}}}},"3":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"facebook":"' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","youtube":"' . VIWEC_IMAGES . 'yt-color-white.png","youtube_url":"","linkedin":"' . VIWEC_IMAGES . 'li-color-white.png","linkedin_url":"","whatsapp":"' . VIWEC_IMAGES . 'wa-color-white.png","whatsapp_url":"","direction":"","data-width":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"20px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\"><a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}}}}',
				],
			],

			'new_order' => [
				'basic' => [
					'name' => esc_html__( 'Basic', 'viwec-email-template-customizer' ),
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-color":"transparent","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":"' . VIWEC_IMAGES . 'icon-cart-dark-blue-200x200-1.png"},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #444444; font-size: 24px;\">{customer_name} placed a new order on your store.</span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 20px;\"><span style=\"color: #444444;\">Order #</span><span style=\"color: #444444;\">{order_number} - Total {order_total} -&nbsp;</span><span style=\"color: #444444;\">{order_date}</span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"35px 0px 0px"},"content":{"text":"Go To Your Store"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"172px","padding":"10px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3","show_sku":""},"childStyle":{".viwec-item-row":{"background-color":"transparent","border-width":"0px","border-color":"#808080"},".viwec-product-img":{},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{payment_method}</span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"25px","color":"#23282d","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 50px 8px 0px"},".head.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-width":"0px 0px 1px"},".body.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-width":"1px 0px 0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{"data-shipping_address_title":"Shipping Address"},"attrs":{},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"facebook":"' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","youtube":"' . VIWEC_IMAGES . 'yt-color-white.png","youtube_url":"","linkedin":"' . VIWEC_IMAGES . 'li-color-white.png","linkedin_url":"","whatsapp":"' . VIWEC_IMAGES . 'wa-color-white.png","whatsapp_url":"","direction":"","data-width":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"20px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\"><a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}}}}',
				],
			],

			'cancelled_order' => [
				'basic' => [
					'name' => esc_html__( 'Basic', 'viwec-email-template-customizer' ),
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-color":"transparent","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":"' . VIWEC_IMAGES . 'icon-cart-dark-blue-200x200-1.png"},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #444444; font-size: 24px;\">{customer_name} has cancelled order on your store.</span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 20px;\"><span style=\"color: #444444;\">Order #</span><span style=\"color: #444444;\">{order_number} - Total {order_total} -&nbsp;</span><span style=\"color: #444444;\">{order_date}</span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"35px 0px 0px"},"content":{"text":"Go To Your Store"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"172px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3","show_sku":""},"childStyle":{".viwec-item-row":{"background-color":"transparent","border-width":"0px","border-color":"#808080"},".viwec-product-img":{},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p>{customer_note}</p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-width":"0px 0px 1px"},".body.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-width":"1px 0px 0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{"data-shipping_address_title":"Shipping Address"},"attrs":{},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"facebook":"' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","youtube":"' . VIWEC_IMAGES . 'yt-color-white.png","youtube_url":"","linkedin":"' . VIWEC_IMAGES . 'li-color-white.png","linkedin_url":"","whatsapp":"' . VIWEC_IMAGES . 'wa-color-white.png","whatsapp_url":"","direction":"","data-width":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"20px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\"><a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}}}}',
				],
			],

			'failed_order' => [
				'basic' => [
					'name' => esc_html__( 'Basic', 'viwec-email-template-customizer' ),
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-color":"transparent","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none"},"content":{},"attrs":{"src":"' . VIWEC_IMAGES . 'icon-cart-dark-blue-200x200-1.png"},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #444444; font-size: 24px;\">Order #{order_number} has failed on your store</span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 20px;\"><span style=\"color: #444444;\">Total {order_total} - </span><span style=\"color: #444444;\">{order_date}</span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"35px 0px 0px"},"content":{"text":"Go To Your Store"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"172px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3","show_sku":""},"childStyle":{".viwec-item-row":{"border-width":"0px","border-color":"#808080"},".viwec-product-img":{},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"24px","padding":"0px","background-image":"none"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px","background-image":"none","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px"},".head.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-width":"0px 0px 1px"},".body.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-width":"1px 0px 0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"25px 0px 0px","background-image":"none"},"content":{"data-shipping_address_title":"Shipping Address"},"attrs":{},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none"},"content":{},"attrs":{"facebook":"' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","youtube":"' . VIWEC_IMAGES . 'yt-color-white.png","youtube_url":"","linkedin":"' . VIWEC_IMAGES . 'li-color-white.png","linkedin_url":"","whatsapp":"' . VIWEC_IMAGES . 'wa-color-white.png","whatsapp_url":"","direction":"","data-width":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"20px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\"><a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}}}}',
				],
			],

			'customer_failed_order' => [
				'basic' => [
					'name' => esc_html__( 'Basic', 'viwec-email-template-customizer' ),
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"transparent","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":"' . VIWEC_IMAGES . 'icon-info-dark-blue-200x200-1.png"},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 30px;\">Hi {customer_name},</span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 16px;\">Unfortunately, we couldn\'t complete your order due to an issue with your payment method.</span></p>\n<p><span style=\"font-size: 16px;\">If you\'d like to continue with your purchase, please return to {site_title} and try a different method of payment.</span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"10px 0px 0px"},"content":{"text":"VIEW YOUR ORDER"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"204px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3"},"childStyle":{".viwec-item-row":{"background-color":"transparent","border-width":"0px","border-color":"#808080"},".viwec-product-img":{},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","background-color":"transparent","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-width":"0px 0px 1px"},".body.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-width":"1px 0px 0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{"data-shipping_address_title":"Shipping Address"},"attrs":{},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"facebook":"' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","youtube":"' . VIWEC_IMAGES . 'yt-color-white.png","youtube_url":"","linkedin":"' . VIWEC_IMAGES . 'li-color-white.png","linkedin_url":"","whatsapp":"' . VIWEC_IMAGES . 'wa-color-white.png","whatsapp_url":"","direction":"","data-width":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"20px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\"><a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}}}}'
				],
			],
			'customer_cancelled_order' => [
				'basic' => [
					'name' => esc_html__( 'Basic', 'viwec-email-template-customizer' ),
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"transparent","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none"},"content":{},"attrs":{"src":"' . VIWEC_IMAGES . 'icon-cart-dark-blue-200x200-1.png"},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"35px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Hi {first_name}.</span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"10px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">We’re getting in touch to let you know that your order #{order_number} has been cancelled.</span></p>"},"attrs":{},"childStyle":{}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3"},"childStyle":{".viwec-item-row":{"border-width":"0px","border-color":"#808080"},".viwec-product-img":{},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"24px","padding":"0px","background-image":"none"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px","background-image":"none","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-width":"0px 0px 1px"},".body.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-width":"1px 0px 0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"25px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"25px 0px 0px","background-image":"none"},"content":{"data-shipping_address_title":"Shipping Address"},"attrs":{},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none"},"content":{},"attrs":{"facebook":"' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","youtube":"' . VIWEC_IMAGES . 'yt-color-white.png","youtube_url":"","linkedin":"' . VIWEC_IMAGES . 'li-color-white.png","linkedin_url":"","whatsapp":"' . VIWEC_IMAGES . 'wa-color-white.png","whatsapp_url":"","direction":"","data-width":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"20px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\"><a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}}}}',
				],
			],
			'customer_on_hold_order' => [
				'basic' => [
					'name' => esc_html__( 'Basic', 'viwec-email-template-customizer' ),
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"transparent","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":"' . VIWEC_IMAGES . 'icon-cart-dark-blue-200x200-1.png"},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Order #{order_number}.</span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Hi {first_name}, Thank you for your purchase.</span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"35px 0px 0px"},"content":{"text":"VIEW YOUR ORDER"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"204px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3"},"childStyle":{".viwec-item-row":{"background-color":"transparent","border-width":"0px","border-color":"#808080"},".viwec-product-img":{},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-width":"0px 0px 1px"},".body.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-width":"1px 0px 0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{"data-shipping_address_title":"Shipping Address"},"attrs":{},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"facebook":"' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","youtube":"' . VIWEC_IMAGES . 'yt-color-white.png","youtube_url":"","linkedin":"' . VIWEC_IMAGES . 'li-color-white.png","linkedin_url":"","whatsapp":"' . VIWEC_IMAGES . 'wa-color-white.png","whatsapp_url":"","direction":"","data-width":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"20px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\"><a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}}}}',
				],
			],

			'customer_processing_order' => [
				'basic' => [
					'name' => esc_html__( 'Basic', 'viwec-email-template-customizer' ),
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"transparent","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none"},"content":{},"attrs":{"src":"' . VIWEC_IMAGES . 'icon-cart-dark-blue-200x200-1.png"},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"35px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Order #{order_number}.</span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"10px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Hi {first_name}, Thank you for your purchase.</span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"10px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 20px; color: #444444;\">We are processing your order.</span></p>"},"attrs":{},"childStyle":{}},"4":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"35px 0px 0px"},"content":{"text":"VIEW YOUR ORDER"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"204px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3"},"childStyle":{".viwec-item-row":{"border-width":"0px","border-color":"#808080"},".viwec-product-img":{},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"24px","padding":"0px","background-image":"none"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px","background-image":"none","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-width":"0px 0px 1px"},".body.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-width":"1px 0px 0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"25px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"25px 0px 0px","background-image":"none"},"content":{"data-shipping_address_title":"Shipping Address"},"attrs":{},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none"},"content":{},"attrs":{"facebook":"' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","youtube":"' . VIWEC_IMAGES . 'yt-color-white.png","youtube_url":"","linkedin":"' . VIWEC_IMAGES . 'li-color-white.png","linkedin_url":"","whatsapp":"' . VIWEC_IMAGES . 'wa-color-white.png","whatsapp_url":"","direction":"","data-width":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"20px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\"><a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}}}}',
				],
			],

			'customer_completed_order' => [
				'basic' => [
					'name' => esc_html__( 'Basic', 'viwec-email-template-customizer' ),
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"transparent","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":"' . VIWEC_IMAGES . 'icon-cart-dark-blue-200x200-1.png"},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Order #{order_number}.</span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Hi {first_name}, Thank you for your purchase.</span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 20px; color: #444444;\">We will send you a follow-up email with tracking information when your order ships.</span></p>"},"attrs":{},"childStyle":{}},"4":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"35px 0px 0px"},"content":{"text":"VIEW YOUR ORDER"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"204px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3"},"childStyle":{".viwec-item-row":{"background-color":"transparent","border-width":"0px","border-color":"#808080"},".viwec-product-img":{},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","background-color":"transparent","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-width":"0px 0px 1px"},".body.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-width":"1px 0px 0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{"data-shipping_address_title":"Shipping Address"},"attrs":{},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"facebook":"' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","youtube":"' . VIWEC_IMAGES . 'yt-color-white.png","youtube_url":"","linkedin":"' . VIWEC_IMAGES . 'li-color-white.png","linkedin_url":"","whatsapp":"' . VIWEC_IMAGES . 'wa-color-white.png","whatsapp_url":"","direction":"","data-width":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"20px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\"><a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}}}}',
				],
			],

			'customer_refunded_order' => [
				'basic' => [
					'name' => esc_html__( 'Basic', 'viwec-email-template-customizer' ),
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"transparent","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":"' . VIWEC_IMAGES . 'icon-star-dark-blue-200x200-1.png"},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Hi {first_name},&nbsp;</span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #444444;\"><span style=\"font-size: 20px;\">Your order #{order_number} has been refunded.</span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"35px 0px 0px"},"content":{"text":"VIEW YOUR ORDER"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"204px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3"},"childStyle":{".viwec-item-row":{"background-color":"transparent","border-width":"0px","border-color":"#808080"},".viwec-product-img":{},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","background-color":"transparent","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-width":"0px 0px 1px"},".body.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-width":"1px 0px 0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{"data-shipping_address_title":"Shipping Address"},"attrs":{},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"facebook":"' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","youtube":"' . VIWEC_IMAGES . 'yt-color-white.png","youtube_url":"","linkedin":"' . VIWEC_IMAGES . 'li-color-white.png","linkedin_url":"","whatsapp":"' . VIWEC_IMAGES . 'wa-color-white.png","whatsapp_url":"","direction":"","data-width":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"20px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\">&nbsp;<a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}}}}',
				],
			],

			'customer_partially_refunded_order' => [
				'basic' => [
					'name' => esc_html__( 'Basic', 'viwec-email-template-customizer' ),
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"transparent","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":"' . VIWEC_IMAGES . 'icon-star-dark-blue-200x200-1.png"},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Hi {first_name},&nbsp;</span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #444444;\"><span style=\"font-size: 20px;\">Your order #{order_number} has been partially refunded.</span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"35px 0px 0px"},"content":{"text":"VIEW YOUR ORDER"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"204px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3"},"childStyle":{".viwec-item-row":{"background-color":"transparent","border-width":"0px","border-color":"#808080"},".viwec-product-img":{},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","background-color":"transparent","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-width":"0px 0px 1px"},".body.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-width":"1px 0px 0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{"data-shipping_address_title":"Shipping Address"},"attrs":{},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"facebook":"' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","youtube":"' . VIWEC_IMAGES . 'yt-color-white.png","youtube_url":"","linkedin":"' . VIWEC_IMAGES . 'li-color-white.png","linkedin_url":"","whatsapp":"' . VIWEC_IMAGES . 'wa-color-white.png","whatsapp_url":"","direction":"","data-width":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"20px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\"><a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}}}}',
				],
			],

			'customer_invoice' => [
				'basic' => [
					'name' => esc_html__( 'Basic', 'viwec-email-template-customizer' ),
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-color":"transparent","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none"},"content":{},"attrs":{"src":"' . VIWEC_IMAGES . 'icon-barcode-dark-blue-200x200-1.png"},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #444444;\"><span style=\"font-size: 24px;\">Invoice for order #{order_number}</span></span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"24px","background-image":"none","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 16px;\">Hi {customer_name}, Here are the details of your order placed on {order_date}.</span></p>"},"attrs":{},"childStyle":{}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none"},"content":{"product":"Product","quantity":"Quantity","price":"Price"},"attrs":{"data-template":"1","show_sku":""},"childStyle":{".viwec-item-row":{},".viwec-product-img":{},".viwec-product-distance":{},".viwec-product-name":{},".viwec-text-price":{"width":"30%"},".viwec-item-style-1":{"font-size":"15px","color":"#444444","line-height":"22px"},".viwec-product-price":{},".viwec-product-quantity":{}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"24px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 16px;\">Pay with {payment_method}</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"24px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 16px;\">Shipping via {shipping_method}</span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"24px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 16px;\">Note: {customer_note}</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"16px","font-weight":"300","color":"#444444","line-height":"24px","padding":"0px","background-image":"none"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px","background-image":"none","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-width":"0px 0px 1px"},".body.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-width":"1px 0px 0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"25px 0px 0px","background-image":"none"},"content":{"data-shipping_address_title":"Shipping Address"},"attrs":{},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none"},"content":{},"attrs":{"facebook":"' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","youtube":"' . VIWEC_IMAGES . 'yt-color-white.png","youtube_url":"","linkedin":"' . VIWEC_IMAGES . 'li-color-white.png","linkedin_url":"","whatsapp":"' . VIWEC_IMAGES . 'wa-color-white.png","whatsapp_url":"","direction":"","data-width":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"20px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\"><a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}}}}',
				],
			],

			'customer_invoice_pending' => [
				'basic' => [
					'name' => esc_html__( 'Basic', 'viwec-email-template-customizer' ),
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-color":"transparent","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none"},"content":{},"attrs":{"src":"' . VIWEC_IMAGES . 'icon-barcode-dark-blue-200x200-1.png"},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #444444;\"><span style=\"font-size: 24px;\">Invoice for order #{order_number}</span></span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"24px","background-image":"none","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 16px;\">Hi {customer_name}, Here are the details of your order placed on {order_date}. With a <span style=\"font-family: \'Helvetica Neue\', Helvetica, Roboto, Arial, sans-serif;\">link to make payment when you\'re ready: <span style=\"color: #333333;\"><a style=\"color: #333333;\" href=\"{payment_url}\">Pay for this order</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none"},"content":{"product":"Product","quantity":"Quantity","price":"Price"},"attrs":{"data-template":"1","show_sku":""},"childStyle":{".viwec-item-row":{},".viwec-product-img":{},".viwec-product-distance":{},".viwec-product-name":{},".viwec-text-price":{"width":"30%"},".viwec-item-style-1":{"font-size":"15px","color":"#444444","line-height":"22px"},".viwec-product-price":{},".viwec-product-quantity":{}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"24px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 16px;\">Pay with {payment_method}</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"24px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 16px;\">Shipping via {shipping_method}</span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"24px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 16px;\">Note: {customer_note}</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"16px","font-weight":"300","color":"#444444","line-height":"24px","padding":"0px","background-image":"none"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px","background-image":"none","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-width":"0px 0px 1px"},".body.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-width":"1px 0px 0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"25px 0px 0px","background-image":"none"},"content":{"data-shipping_address_title":"Shipping Address"},"attrs":{},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none"},"content":{},"attrs":{"facebook":"' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","youtube":"' . VIWEC_IMAGES . 'yt-color-white.png","youtube_url":"","linkedin":"' . VIWEC_IMAGES . 'li-color-white.png","linkedin_url":"","whatsapp":"' . VIWEC_IMAGES . 'wa-color-white.png","whatsapp_url":"","direction":"","data-width":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"20px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\"><a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}}}}',
				],
			],

			'customer_note' => [
				'basic' => [
					'name' => esc_html__( 'Basic', 'viwec-email-template-customizer' ),
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"transparent","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":"' . VIWEC_IMAGES . 'icon-info-dark-blue-200x200-1.png"},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 30px;\">Hi {customer_name},</span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 16px;\">The following note has been added to your order #{order_number}:</span></p>\n<p><span style=\"font-size: 16px;\"><span style=\"font-size: 16px;\"><strong>{order_note}</strong></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"10px 0px 0px"},"content":{"text":"VIEW YOUR ORDER"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"204px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3"},"childStyle":{".viwec-item-row":{"background-color":"transparent","border-width":"0px","border-color":"#808080"},".viwec-product-img":{},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","background-color":"transparent","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-width":"0px 0px 1px"},".body.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-width":"1px 0px 0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-width":"10px 0px 0px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 35px","background-image":"none","background-color":"#ffffff","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"265px"}},"elements":{"0":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","color":"#444444","line-height":"22px","text-align":"start","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{"data-shipping_address_title":"Shipping Address"},"attrs":{},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"600px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-width":"0px","border-radius":"0px","border-color":"#444444","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"facebook":"' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","youtube":"' . VIWEC_IMAGES . 'yt-color-white.png","youtube_url":"","linkedin":"' . VIWEC_IMAGES . 'li-color-white.png","linkedin_url":"","whatsapp":"' . VIWEC_IMAGES . 'wa-color-white.png","whatsapp_url":"","direction":"","data-width":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"20px 0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-width":"0px","border-radius":"0px","border-color":"#444444"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\"><a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}}}}'
				],
			],

			'customer_reset_password' => [
				'basic' => [
					'name' => esc_html__( 'Basic', 'viwec-email-template-customizer' ),
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-color":"transparent","border-style":"solid","border-width":"0px","border-radius":"0px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":"' . VIWEC_IMAGES . 'icon-badged-dark-blue-200x200-1.png"},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 30px;\">Password Reset Request</span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"20px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: left;\"><span style=\"font-size: 16px;\">Hi <strong>{user_login}</strong>, Someone has requested a new password for the following account on {site_title}: </span></p>\n<p style=\"text-align: left;\"><span style=\"font-size: 16px;\">Username:&nbsp;<strong>{user_login}</strong></span></p>\n<p style=\"text-align: left;\"><span style=\"font-size: 16px;\">If you didn\'t make this request, just ignore this email. If you\'d like to proceed:</span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","color":"#eeeeee","line-height":"24px","text-align":"center","padding":"20px 0px 0px"},"content":{"text":"Click to reset your password"},"attrs":{"href":"{reset_password_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"260px"}}},"4":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"20px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 16px;\">Thanks for reading.</span></p>"},"attrs":{},"childStyle":{}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"facebook":"' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","direction":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"20px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\"><a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}}}}'
				],
			],

			'customer_new_account' => [
				'basic' => [
					'name' => esc_html__( 'Basic', 'viwec-email-template-customizer' ),
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-color":"transparent","border-style":"solid","border-width":"0px","border-radius":"0px"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":"' . VIWEC_IMAGES . 'icon-badged-dark-blue-200x200-1.png"},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 30px; color: #444444;\">Hi {user_login},&nbsp;</span></p>"},"attrs":{},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"20px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: left;\"><span style=\"font-size: 16px;\"><span style=\"color: #444444;\">Thanks for creating an account on {site_title}. </span></span></p>\n<p style=\"text-align: left;\"><span style=\"font-size: 16px;\"><span style=\"color: #444444;\">Your username is <strong>{user_login}</strong>.</span></span></p>\n<p style=\"text-align: left;\"><span style=\"font-size: 16px;\"><span style=\"color: #444444;\">Your password is:<strong> {user_password}</strong></span></span></p>\n<p style=\"text-align: left;\"><span style=\"font-size: 16px;\"><span style=\"color: #444444;\">You can access your account area to view orders, change your password, and more at:&nbsp;</span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","color":"#eeeeee","line-height":"24px","text-align":"center","padding":"20px 0px 0px"},"content":{"text":"Go to your account"},"attrs":{"href":"{myaccount_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"transparent","border-style":"solid","background-color":"#e43f5a","width":"186px"}}},"4":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"20px 0px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #636363; font-family: \'Helvetica Neue\', Helvetica, Roboto, Arial, sans-serif; font-size: 16px;\">We look forward to seeing you soon.</span></p>"},"attrs":{},"childStyle":{}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"facebook":"' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","direction":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"20px 0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\"><a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{},"childStyle":{}}}}}}}}'
				],
			],
		] );

	}
}

