# User Interface - MVC and Templates

Admin interface structure using MVC pattern.

## MVC Pattern

- **Controllers** - `src/Controllers/` (extends `src/Core/Controllers` base classes)
- **Models** - `src/Models/` (entities and data)
- **Views** - `template/` (PHP templates)

## Template System

**TplMng** (`src/Core/Views/TplMng.php`) - Template manager for rendering views.

```php
TplMng::getInstance()->render('path/to/template', ['data' => $value]);
```

## Admin Pages

Controllers handle admin pages, extending base controller classes:
- Menu registration
- Permission checks via `CapMng`
- Template rendering via `TplMng`

## AJAX Handlers

Located in `src/Ajax/` - handle client-side requests.

## Styling

- CSS in `assets/sass/`
- Prefix: `dup-` for classes
- No inline styles
