<?php

/**
 * This class configures hide admin notices PRO
 *
 * Github: https://github.com/alexkovalevv
 *
 * @author        Alexander Kovalev <alex.kovalevv@gmail.com>
 * @copyright (c) 2018 Webraftic Ltd
 * @version       1.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WDNPRO_ConfigHideNotices extends WDN_ConfigHideNotices {

	public function registerActionsAndFilters() {
		//parent::registerActionsAndFilters();

		if ( is_admin() ) {
			$hide_notices_type = $this->getPopulateOption( 'hide_admin_notices' );

			if ( 'not_hide' !== $hide_notices_type ) {
				add_action( 'admin_head', [ $this, 'hide_nags' ], 999 );
				add_action( 'admin_print_scripts', [ $this, 'catchNoticesPro' ], 999 );
				add_action( 'admin_print_footer_scripts', [ $this, 'show_compact_panel' ], 999 );

				add_filter( 'wdan/notifications/all', [ $this, 'notifications_all' ] );
				add_action( 'wdn/notifications/panel/all', [ $this, 'notificationsPanel_all' ], 10, 3 );
				add_filter( 'wdn/notifications/catch/all', [ $this, 'catchNotices_all' ], 10, 4 );
			}
		}
	}

	public function hide_nags() {
		?>
		<?php if ( $this->plugin->getPopulateOption( 'disable_updates_nags_for_plugins' ) ): ?>
            <style>
                .update-message, #wp-admin-bar-updates, span.update-plugins {
                    display: none !important;
                }
            </style>
		<?php endif; ?>
		<?php if ( $this->plugin->getPopulateOption( 'disable_updates_nags_for_core' ) ): ?>
            <style>
                div.update-nag {
                    display: none !important;
                }
            </style>
		<?php endif; ?>
		<?php if ( "compact_panel" === $this->plugin->getPopulateOption( 'hide_admin_notices' ) ): ?>
            <style id="wdanpro-disable-notices-style">
                div.updated, div.error, div.notice, div.wdanpro-notice {
                    display: none !important;
                }
            </style>
            <style>
                .wdan-notices-compact-panel {
                    background: #fff;
                    border: 1px solid #cecccc;

                    cursor: pointer;
                    margin-bottom: 20px;
                    padding: 5px 5px 5px 5px;
                }

                .wdan-notices-compact-panel.wdan-oppened {
                    cursor: default;
                }

                .wdan-notices-compact-panel h3 {
                    display: inline-block;
                    color: #32373c;
                    font-weight: normal;
                    font-size: 13px;
                    margin: 0;
                }

                .wdan-notices-compact-panel h3 .dashicons {
                    height: 20px;
                    width: 20px;
                    font-size: 20px;
                    line-height: 0.8;

                }

                .wdan-notices-compact-panel.wdan-oppened .wdan-notices-compact-panel__title > .dashicons {
                    -webkit-transform: rotateX(180deg);
                    transform: rotateX(180deg);
                    line-height: 1;
                }

                .wdan-notices-compact-panel ul {
                    display: block;
                    float: right;
                    margin: 0;

                }

                .wdan-notices-compact-panel ul li {
                    display: inline-block;
                    margin: 0;
                }

                .wdan-notices-compact-panel__notices {
                    display: none;
                    padding: 15px;
                }

                .wdan-notices-compact-panel.wdan-oppened .wdan-notices-compact-panel__notices {
                    display: block;
                }

                .wdan-notices-compact-panel__error {
                    color: red;
                }

                .wdan-notices-compact-panel__warning {
                    color: #fd865a;
                }

                .wdan-notices-compact-panel__success {
                    color: green;
                }
            </style>
		<?php endif; ?>
		<?php
	}

	public function catchNoticesPro() {
		if ( "compact_panel" !== $this->plugin->getPopulateOption( 'hide_admin_notices' ) ) {
			return;
		}

		$content = wdan_collect_notices( 'admin_notices' );
		$content = array_merge( $content, wdan_collect_notices( 'all_admin_notices' ) );

		wdan_clear_all_notices( 'admin_notices', [
			'Learndash_Admin_Menus_Tabs',
			'WC_Memberships_Admin',
			'YIT_Plugin_Panel_WooCommerce'
		], [ 'et_pb_export_layouts_interface' ] );

		wdan_clear_all_notices( 'all_admin_notices', [
			'Learndash_Admin_Menus_Tabs',
			'WC_Memberships_Admin',
			'YIT_Plugin_Panel_WooCommerce'
		], [ 'et_pb_export_layouts_interface' ] );

		if ( empty( $content ) ) {
			return;
		}

		add_action( 'admin_notices', function () use ( $content ) {
			foreach ( $content as $html ) {
				echo "<div class='wdanpro-notice'>" . base64_encode( $html ) . "</div>";
			}
		} );
	}

	public function show_compact_panel() {
		if ( "compact_panel" !== $this->plugin->getPopulateOption( 'hide_admin_notices' ) ) {
			return;
		}
		?>

        <script>
            jQuery(document).ready(function ($) {

                function wdanproB64DecodeUnicode(str) {
                    // Going backwards: from bytestream, to percent-encoding, to original string.
                    return decodeURIComponent(atob(str).split('').map(function (c) {
                        return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2);
                    }).join(''));
                }

                let notices = $('div.updated, div.error, div.notice, div.update-nag, div.wdanpro-notice').not('.inline, .below-h2').not('.inline').detach(),
                    contanier = $('.wdan-notices-compact-panel').detach(),
                    $headerEnd = $('.wp-header-end');

                notices.each(function () {
                    contanier.find('.wdan-notices-compact-panel__notices').append("<div class='wdanpro-notice'>" + wdanproB64DecodeUnicode($(this).html()) + "</div>");
                });

                /*
				 * The `.below-h2` class is here just for backward compatibility with plugins
				 * that are (incorrectly) using it. Do not use. Use `.inline` instead. See #34570.
				 * If '.wp-header-end' is found, append the notices after it otherwise
				 * after the first h1 or h2 heading found within the main content.
				 */
                if (!$headerEnd.length) {
                    $headerEnd = $('.wrap h1, .wrap h2').first();
                }

                $headerEnd.after(contanier);

                let compactPanelNoticesEl = $('.wdan-notices-compact-panel__notices'),
                    other = compactPanelNoticesEl.find('div.wdanpro-notice').length;

                $('.wdan-notices-compact-panel__warning').find('span').text(other);

                $('#wdanpro-disable-notices-style').remove();
                contanier.show();

                contanier.find('.wdan-notices-compact-panel__button').click(function () {
                    $(this).parent().toggleClass('wdan-oppened');
                    return false;
                });

            });
        </script>
        <div class="wdan-notices-compact-panel" style="display: none;">
            <div class="wdan-notices-compact-panel__button">
                <h3 class="wdan-notices-compact-panel__title">
                    <span class="dashicons dashicons-arrow-down"></span> Click
                    here to see all admin notifications
                </h3>
                <ul>
                    <li class="wdan-notices-compact-panel__warning"><strong> Notices</strong>: <span>0</span></li>
                </ul>
            </div>
            <div class="wdan-notices-compact-panel__notices">

            </div>
        </div>
		<?php
	}

	public function notifications_all() {
		return $this->plugin->getPopulateOption( 'hidden_notices', [] );
	}

	/**
	 * @param $wp_admin_bar WP_Admin_Bar
	 * @param $notifications array
	 */
	public function notificationsPanel_all( $wp_admin_bar, $notifications, $i ) {
		if ( ! empty( $notifications ) ) {
			$wp_admin_bar->add_menu( [
				'id'     => 'wbcr-han-notify-panel-group-all',
				'parent' => 'wbcr-han-notify-panel',
				'title'  => __( 'Hidden for all', 'disable-admin-notices-premium' ),
				'href'   => false,
				'meta'   => [
					'class' => ''
				]
			] );

			foreach ( $notifications as $notice_id => $message ) {
				$message = wp_kses( $message, [] );
				$message = $this->getExcerpt( stripslashes( $message ), 0, 350 );
				$message .= '<div class="wbcr-han-panel-restore-notify-line">';
				$message .= '<a href="#" data-nonce="' . wp_create_nonce( $this->plugin->getPluginName() . '_ajax_restore_notice_nonce' );
				$message .= '" data-notice-id="' . esc_attr( $notice_id ) . '" class="wbcr-han-panel-restore-notify-link">';
				$message .= __( 'Restore notice', 'clearfy' );
				$message .= '</a></div>';

				$wp_admin_bar->add_menu( [
					'id'     => 'wbcr-han-notify-panel-item-' . $i,
					'parent' => 'wbcr-han-notify-panel',
					'title'  => $message,
					'href'   => false,
					'meta'   => [
						'class' => ''
					]
				] );

				$i ++;
			}
		}
	}

	/**
	 * @param $hidden_notices
	 * @param $uniq_id1
	 * @param $uniq_id2
	 *
	 * @return bool
	 */
	public function catchNotices_all( $skip_notice, $hidden_notices, $uniq_id1, $uniq_id2 ) {
		$skip_notice = true;
		if ( ! empty( $hidden_notices ) ) {
			foreach ( (array) $hidden_notices as $key => $notice ) {
				$splited_notice_id = explode( '_', $key );
				if ( empty( $splited_notice_id ) || sizeof( $splited_notice_id ) < 2 ) {
					continue;
				}
				$compare_notice_id_1 = $splited_notice_id[0];
				$compare_notice_id_2 = $splited_notice_id[1];

				if ( $compare_notice_id_1 == $uniq_id1 || $compare_notice_id_2 == $uniq_id2 ) {
					$skip_notice = false;
					break;
				}
			}
		}

		return $skip_notice;
	}
}