<?php
/**
 * Plugin Name: Disable Admin Notices premium
 * Plugin URI: https://wordpress.org/plugins/disable-admin-notices/
 * Description: Premium addon for the Disable admin notices plugin.
 * Author: CreativeMotion <wordpress.webraftic@gmail.com>
 * Version: 1.1.0
 * Text Domain: disable-admin-notices-premium
 * Domain Path: /languages/
 * Author URI: https://clearfy.pro
 */

// @formatter:off
// Выход при непосредственном доступе
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Устанавливаем контстанту c версией плагина
define( 'WDANPRO_PLUGIN_VERSION', '1.1.0' );

if ( ! function_exists( 'wdan_premium_load' ) ) {

	function wdan_premium_load() {

		# Если бесплатный плагин не установлен или вызвал ошибку, то прерываем выполнение кода
		if ( ! defined( 'WDN_PLUGIN_ACTIVE' ) ) {
			return;
		}

		if ( defined( 'LOADING_DISABLE_ADMIN_NOTICES_AS_ADDON' ) && LOADING_DISABLE_ADMIN_NOTICES_AS_ADDON ) {
			return;
		}

		$plugin = WDN_Plugin::app();

		# Если лицензия не активирована, то прерываем выполнение кода
		if ( ! $plugin->premium->is_activate() ) {
			return;
		}

		// Устанавливаем контстанту, что плагин уже используется
		define( 'WDANPRO_PLUGIN_ACTIVE', true );

		// Директория плагина
		define( 'WDANPRO_PLUGIN_DIR', dirname( __FILE__ ) );

		// Относительный путь к плагину
		define( 'WDANPRO_PLUGIN_BASE', plugin_basename( __FILE__ ) );

		// Ссылка к директории плагина
		define( 'WDANPRO_PLUGIN_URL', plugins_url( null, __FILE__ ) );

		if ( is_admin() ) {
			require_once( WDANPRO_PLUGIN_DIR . '/admin/boot.php' );

			// Rewrite free plugin settings page
			$plugin->registerPage( 'WDANPRO_Notices', WDANPRO_PLUGIN_DIR . '/admin/pages/class-pages-notices.php' );
			$plugin->registerPage( 'WDANPRO_Edit_Admin_Bar', WDANPRO_PLUGIN_DIR . '/admin/pages/class-pages-edit-admin-bar.php' );
			$plugin->registerPage( 'WDANPRO_Block_Ad_Redirects', WDANPRO_PLUGIN_DIR . '/admin/pages/class-pages-edit-redirects.php' );
		}

		require_once( WDANPRO_PLUGIN_DIR . '/includes/function.php' );
		if ( ! wp_doing_ajax() || ! isset( $_REQUEST['action'] ) ) {
			return;
		}

		switch ( $_REQUEST['action'] ) {
			case 'wdanpro-disable-adminbar-menus':
				require_once( WDANPRO_PLUGIN_DIR . '/admin/ajax/disable-adminbar-menus.php' );
				break;
		}
	}

	add_action( 'plugins_loaded', 'wdan_premium_load', 20 );

	/**
	 * Register activation hook
	 * @since 1.0.0
	 */
	function wdan_activate() {
		if ( class_exists( 'WDN_Plugin' ) ) {
			WDN_Plugin::app()->premium->update_package_data( [
				'basename'          => plugin_basename( __FILE__ ),
				'version'           => WDANPRO_PLUGIN_VERSION,
				'framework_version' => ''
			] );
		}
	}

	register_activation_hook( __FILE__, 'wdan_activate' );

	/**
	 * Register deactivation hook
	 * @since 1.0.0
	 * @author Alexander Kovalev <alex.kovalevv@gmail.com>
	 */
	function wdan_deactivate() {
		if ( class_exists( 'WDN_Plugin' ) ) {
			WDN_Plugin::app()->premium->delete_package();
		}
	}

	register_deactivation_hook( __FILE__, 'wdan_deactivate' );
}
// @formatter:on