<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Страница общих настроек для этого плагина.
 *
 * Не поддерживает режим работы с мультисаймами.
 *
 * @author        Alexander Kovalev <alex.kovalevv@gmail.com>, Github: https://github.com/alexkovalevv
 * @copyright (c) 2019 Webraftic Ltd
 * @version       1.0
 */
class WDANPRO_Block_Ad_Redirects extends WDAN_Block_Ad_Redirects {

	/**
	 * {@inheritDoc}
	 *
	 * @var string
	 */
	public $id = "wdanp-edit-redirects";

	/**
	 * {@inheritDoc}
	 *
	 * @var string
	 */
	public $type = "page";

	/**
	 * {@inheritDoc}
	 *
	 * @var string
	 */
	public $page_menu_dashicon = 'dashicons dashicons-undo';

	/**
	 * {@inheritDoc}
	 *
	 * @since   2.0.5 - добавлен
	 * @var bool
	 */
	public $show_right_sidebar_in_options = false;


	/**
	 * @param WDN_Plugin $plugin
	 */
	public function __construct( $plugin ) {
		$this->menu_title                  = __( 'Block ad redirects', 'disable-admin-notices' );
		$this->page_menu_short_description = __( 'Break advertising redirects', 'disable-admin-notices' );

		parent::__construct( $plugin );

		$this->plugin = $plugin;

		add_filter( 'wp_redirect', function ( $location ) {
			$redirects = $this->getPopulateOption( 'blocked_redirects', [] );
			if ( in_array( $location, $redirects ) ) {
				return null;
			}

			return $location;
		} );
	}

	public function unblockRedirectAction() {
		$redirect_ID = $this->request()->get( 'redirect_id', null, 'sanitize_key' );
		check_admin_referer( 'unblock_redirect_' . $redirect_ID );

		$redirects = $this->getPopulateOption( 'blocked_redirects', [] );

		if ( isset( $redirects[ $redirect_ID ] ) ) {
			unset( $redirects[ $redirect_ID ] );
			$this->updatePopulateOption( 'blocked_redirects', $redirects );
		}

		$this->redirectToAction( 'index' );
	}

	public function showPageContent() {
		$redirects = $this->getPopulateOption( 'blocked_redirects', [] );

		if ( isset( $_POST['wdnpro_add_block'] ) ) {
			$url = $this->request()->post( 'wdnpro_redirect_url', null, 'sanitize_url' );

			if ( ! in_array( $url, $redirects ) ) {
				$redirects[ md5( $url ) ] = $url;
				$this->updatePopulateOption( 'blocked_redirects', $redirects );
			}

			$this->redirectToAction( 'index' );
		}
		?>
		<div style="padding:15px;">
			<h4>Block ad redirects</h4>
			<form method="post">
				<label for="wdnpro-redirect-url">Enter url for block:</label><br>
				<input id="wdnpro-redirect-url" style="width:400px;" type="text" name="wdnpro_redirect_url">
				<input type="submit" name="wdnpro_add_block" class="button" value="Add block">
			</form>
			<br>
			<table class="wp-list-table widefat fixed striped">
				<tr>
					<th>Url</th>
					<th style="width:200px;">Action</th>
				</tr>
				<?php foreach ( $redirects as $ID => $redirect ): ?>
					<tr>
						<td>
							<?php echo $redirect; ?>
						</td>
						<td>
							<a style="color:#428bca;" href="<?php echo wp_nonce_url( $this->getActionUrl( 'unblock-redirect', [ 'redirect_id' => $ID ] ), 'unblock_redirect_' . $ID ); ?>">Unblock</a>
						</td>
					</tr>
				<?php endforeach; ?>
			</table>
		</div>
		<?php
	}

}
