<?php
/**
 * Ajax action to check existing comments
 *
 * @author        Webcraftic <wordpress.webraftic@gmail.com>
 * @author        Alexander Kovalev <alex.kovalevv@gmail.com>
 *
 * @since         1.0
 * @copyright (c) 2020 Webcraftic Ltd
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'wp_ajax_wdanpro-disable-adminbar-menus', function () {
	$menu_ID     = WDN_Plugin::app()->request->post( 'menu_id', null, 'sanitize_key' );
	$enable_menu = WDN_Plugin::app()->request->post( 'enable_menu', "false" ) === "true";

	check_admin_referer( 'enable_adminbar_item_' . $menu_ID );

	if ( ! current_user_can( 'manage_options' ) ) {
		wp_die( - 1 );
	}

	$items = WDN_Plugin::app()->getPopulateOption( 'hidden_adminbar_items', [] );

	if ( ! $enable_menu ) {
		if ( ! isset( $items[ $menu_ID ] ) ) {
			$items[ $menu_ID ] = true;
		}
	} else {
		if ( isset( $items[ $menu_ID ] ) ) {
			unset( $items[ $menu_ID ] );
		}
	}

	WDN_Plugin::app()->updatePopulateOption( 'hidden_adminbar_items', $items );

	wp_send_json_success( [ 'success_message' => __( 'Settings successfully saved!' ) ] );
} );
