/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-01-28 09:14:12 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wpby_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=93 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=488 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1922 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1409 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `woo_idx_comment_date_type` (`comment_date_gmt`,`comment_type`,`comment_approved`,`comment_post_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_duplicator_activity_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `sub_type` varchar(100) NOT NULL,
  `severity` int(8) NOT NULL,
  `title` text NOT NULL,
  `data` longtext NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `sub_type_idx` (`sub_type`),
  KEY `severity_idx` (`severity`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE','TEMPORARY') NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_helpmate_abandoned_carts` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `cart_data` text NOT NULL,
  `cart_status` varchar(50) NOT NULL COMMENT 'Order Placed, Abandoned, Recovered',
  `woocommerce_session_id` varchar(255) NOT NULL,
  `timestamp` bigint(20) NOT NULL,
  `mails_sent` int(11) NOT NULL,
  `metadata` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_helpmate_analytics` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `event_type` varchar(255) NOT NULL,
  `event_data` text NOT NULL,
  `timestamp` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `event_type` (`event_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_helpmate_chat_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `session_id` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `role` varchar(50) NOT NULL,
  `timestamp` bigint(20) NOT NULL,
  `metadata` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_helpmate_documents` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `document_type` varchar(50) NOT NULL,
  `title` text DEFAULT NULL,
  `content` longtext DEFAULT NULL,
  `vector` text DEFAULT NULL,
  `metadata` text DEFAULT NULL,
  `last_updated` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_type` (`document_type`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_helpmate_jobs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `job_id` varchar(255) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `total_documents` int(11) NOT NULL DEFAULT 0,
  `processed_documents` int(11) NOT NULL DEFAULT 0,
  `successful_documents` int(11) NOT NULL DEFAULT 0,
  `failed_documents` int(11) NOT NULL DEFAULT 0,
  `status` varchar(50) NOT NULL DEFAULT 'scheduled',
  `documents` longtext DEFAULT NULL,
  `errors` longtext DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `completed_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `job_id` (`job_id`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`),
  KEY `created_at` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_helpmate_leads` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `timestamp` bigint(20) NOT NULL,
  `metadata` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_helpmate_promo_banners` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `status` varchar(50) NOT NULL DEFAULT 'active' COMMENT 'active, inactive',
  `start_datetime` bigint(20) DEFAULT NULL,
  `end_datetime` bigint(20) DEFAULT NULL,
  `metadata` text NOT NULL,
  `created_at` bigint(20) NOT NULL,
  `updated_at` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `start_datetime` (`start_datetime`),
  KEY `end_datetime` (`end_datetime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_helpmate_returns_refunds` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(50) NOT NULL COMMENT 'refund, return, or exchange',
  `status` varchar(50) NOT NULL DEFAULT 'pending' COMMENT 'pending, approved, rejected',
  `reason` text NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `items` text NOT NULL COMMENT 'JSON array of returned/refunded/exchanged items',
  `created_at` bigint(20) NOT NULL,
  `updated_at` bigint(20) NOT NULL,
  `metadata` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`),
  KEY `created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_helpmate_settings` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(255) NOT NULL,
  `setting_value` text NOT NULL,
  `last_updated` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting_key` (`setting_key`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_helpmate_tickets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ticket_id` varchar(255) NOT NULL,
  `subject` text NOT NULL,
  `message` text NOT NULL,
  `role` varchar(50) NOT NULL,
  `status` varchar(50) NOT NULL DEFAULT 'open' COMMENT 'open, in_progress, resolved, closed',
  `user_id` bigint(20) DEFAULT NULL,
  `timestamp` bigint(20) NOT NULL,
  `metadata` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_id` (`ticket_id`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_iben_elta_bulk_vouchers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `logged_user` tinytext NOT NULL,
  `id_user` int(5) NOT NULL,
  `id_arrays` text DEFAULT NULL,
  `voucher_arrays` text DEFAULT NULL,
  `compined_pdf` varchar(250) DEFAULT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_iben_elta_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_reference` varchar(100) NOT NULL,
  `id_user` int(5) NOT NULL,
  `contact_name` varchar(100) NOT NULL,
  `contact_address` varchar(100) NOT NULL,
  `contact_region` varchar(100) NOT NULL,
  `contact_postal` varchar(50) NOT NULL,
  `contact_tel1` varchar(50) NOT NULL,
  `contact_tel2` varchar(50) NOT NULL,
  `contact_comment` varchar(100) DEFAULT NULL,
  `time_updated` int(11) NOT NULL,
  `time_created` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_iben_elta_vouchers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `logged_user` tinytext NOT NULL,
  `id_user` int(5) NOT NULL,
  `id_order_parent` int(5) DEFAULT 0,
  `id_order` int(5) NOT NULL,
  `id_elta_account` int(2) DEFAULT 1,
  `duplicated_record` int(2) NOT NULL DEFAULT 0,
  `deleted` int(2) NOT NULL DEFAULT 0,
  `id_elta_reason` int(5) NOT NULL,
  `elta_voucher_info` longtext DEFAULT NULL,
  `elta_returned_vouchers` text DEFAULT NULL,
  `elta_delivery_vouchers` text DEFAULT NULL,
  `elta_returned_compined_vouchers` varchar(250) DEFAULT NULL,
  `elta_delivery_compined_vouchers` varchar(250) DEFAULT NULL,
  `elta_pdf_type` int(3) NOT NULL DEFAULT 1,
  `delivered` int(2) NOT NULL DEFAULT 0,
  `delivered_date` varchar(15) DEFAULT NULL,
  `delivered_time` varchar(15) DEFAULT NULL,
  `delivered_name` varchar(150) DEFAULT NULL,
  `last_check_delivered_time` int(11) NOT NULL DEFAULT 0,
  `email_sent` int(2) NOT NULL DEFAULT 0,
  `sms_sent` int(2) NOT NULL DEFAULT 0,
  `pdf_deleted` int(2) DEFAULT 0,
  `time` int(11) NOT NULL,
  `plugin_version` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_iben_elta_voucher_schedule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_order_parent` int(5) DEFAULT 0,
  `id_order` int(5) NOT NULL,
  `status` varchar(250) DEFAULT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_jet_cache` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `source` varchar(191) NOT NULL DEFAULT 'default',
  `source_id` bigint(20) NOT NULL DEFAULT 0,
  `cache_key` varchar(191) DEFAULT NULL,
  `cache_data` longtext DEFAULT NULL,
  `cache_expired` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_jet_post_types` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text DEFAULT NULL,
  `status` text DEFAULT NULL,
  `labels` longtext DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `meta_fields` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_jet_taxonomies` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text DEFAULT NULL,
  `object_type` text DEFAULT NULL,
  `status` text DEFAULT NULL,
  `labels` longtext DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `meta_fields` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=10671 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pmxe_exports` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) NOT NULL DEFAULT 0,
  `attch_id` bigint(20) NOT NULL DEFAULT 0,
  `options` longtext DEFAULT NULL,
  `scheduled` varchar(64) NOT NULL DEFAULT '',
  `registered_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `friendly_name` text NOT NULL DEFAULT '',
  `exported` bigint(20) NOT NULL DEFAULT 0,
  `canceled` tinyint(1) NOT NULL DEFAULT 0,
  `canceled_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `settings_update_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_activity` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `processing` tinyint(1) NOT NULL DEFAULT 0,
  `executing` tinyint(1) NOT NULL DEFAULT 0,
  `triggered` tinyint(1) NOT NULL DEFAULT 0,
  `iteration` bigint(20) NOT NULL DEFAULT 0,
  `export_post_type` text NOT NULL DEFAULT '',
  `client_mode_enabled` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_at_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `rte_last_row` mediumtext NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pmxe_google_cats` (
  `id` int(11) NOT NULL,
  `name` varchar(200) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `parent_name` varchar(200) NOT NULL,
  `level` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pmxe_posts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `export_id` bigint(20) unsigned NOT NULL,
  `iteration` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pmxe_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `options` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pmxi_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `import_id` bigint(20) unsigned NOT NULL,
  `name` text DEFAULT NULL,
  `path` text DEFAULT NULL,
  `registered_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pmxi_geocoding` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `address` text DEFAULT NULL,
  `latitude` decimal(18,15) DEFAULT NULL,
  `longitude` decimal(18,15) DEFAULT NULL,
  `raw_data` text DEFAULT NULL,
  `provider` varchar(50) NOT NULL DEFAULT 'google_maps',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_address` (`address`(255)),
  KEY `idx_coordinates` (`latitude`,`longitude`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pmxi_hash` (
  `hash` binary(16) NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `import_id` smallint(5) unsigned NOT NULL,
  `post_type` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pmxi_history` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `import_id` bigint(20) unsigned NOT NULL,
  `type` enum('manual','processing','trigger','continue','cli','') NOT NULL DEFAULT '',
  `time_run` text DEFAULT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `summary` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pmxi_images` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attachment_id` bigint(20) unsigned NOT NULL,
  `image_url` text DEFAULT NULL,
  `image_filename` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pmxi_imports` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_import_id` bigint(20) NOT NULL DEFAULT 0,
  `name` text DEFAULT NULL,
  `friendly_name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(32) NOT NULL DEFAULT '',
  `feed_type` enum('xml','csv','zip','gz','') NOT NULL DEFAULT '',
  `path` text DEFAULT NULL,
  `xpath` text DEFAULT NULL,
  `options` longtext DEFAULT NULL,
  `registered_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `root_element` varchar(255) DEFAULT '',
  `processing` tinyint(1) NOT NULL DEFAULT 0,
  `executing` tinyint(1) NOT NULL DEFAULT 0,
  `triggered` tinyint(1) NOT NULL DEFAULT 0,
  `queue_chunk_number` bigint(20) NOT NULL DEFAULT 0,
  `first_import` timestamp NOT NULL DEFAULT current_timestamp(),
  `count` bigint(20) NOT NULL DEFAULT 0,
  `imported` bigint(20) NOT NULL DEFAULT 0,
  `created` bigint(20) NOT NULL DEFAULT 0,
  `updated` bigint(20) NOT NULL DEFAULT 0,
  `skipped` bigint(20) NOT NULL DEFAULT 0,
  `deleted` bigint(20) NOT NULL DEFAULT 0,
  `changed_missing` bigint(20) NOT NULL DEFAULT 0,
  `canceled` tinyint(1) NOT NULL DEFAULT 0,
  `canceled_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `failed` tinyint(1) NOT NULL DEFAULT 0,
  `failed_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `settings_update_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_activity` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `iteration` bigint(20) NOT NULL DEFAULT 0,
  `is_preview` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pmxi_posts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `import_id` bigint(20) unsigned NOT NULL,
  `unique_key` text DEFAULT NULL,
  `product_key` text DEFAULT NULL,
  `iteration` bigint(20) NOT NULL DEFAULT 0,
  `specified` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=312 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pmxi_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `options` longtext DEFAULT NULL,
  `scheduled` varchar(64) NOT NULL DEFAULT '',
  `name` varchar(200) NOT NULL DEFAULT '',
  `title` text DEFAULT NULL,
  `content` longtext DEFAULT NULL,
  `is_keep_linebreaks` tinyint(1) NOT NULL DEFAULT 0,
  `is_leave_html` tinyint(1) NOT NULL DEFAULT 0,
  `fix_characters` tinyint(1) NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=286 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pys_events_queue` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `pixel_type` varchar(50) NOT NULL,
  `event_name` varchar(191) DEFAULT NULL,
  `event_id` varchar(191) DEFAULT NULL,
  `event_data` longtext NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `processed_at` datetime DEFAULT NULL,
  `retry_count` int(11) DEFAULT 0,
  `status` varchar(20) DEFAULT 'pending',
  `error_message` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pixel_type` (`pixel_type`),
  KEY `status` (`status`),
  KEY `created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pys_options` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL,
  `option_value` longtext NOT NULL,
  `migrated` tinyint(1) NOT NULL DEFAULT 1,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pys_stat_landing` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `item_value` char(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pys_stat_order` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `traffic_source_id` bigint(20) unsigned DEFAULT NULL,
  `landing_id` bigint(20) unsigned DEFAULT NULL,
  `utm_source_id` bigint(20) unsigned DEFAULT NULL,
  `utm_medium_id` bigint(20) unsigned DEFAULT NULL,
  `utm_campaing_id` bigint(20) unsigned DEFAULT NULL,
  `utm_term_id` bigint(20) unsigned DEFAULT NULL,
  `utm_content_id` bigint(20) unsigned DEFAULT NULL,
  `last_traffic_source_id` bigint(20) unsigned DEFAULT NULL,
  `last_landing_id` bigint(20) unsigned DEFAULT NULL,
  `last_utm_source_id` bigint(20) unsigned DEFAULT NULL,
  `last_utm_medium_id` bigint(20) unsigned DEFAULT NULL,
  `last_utm_campaing_id` bigint(20) unsigned DEFAULT NULL,
  `last_utm_term_id` bigint(20) unsigned DEFAULT NULL,
  `last_utm_content_id` bigint(20) unsigned DEFAULT NULL,
  `gross_sale` float unsigned NOT NULL,
  `net_sale` float unsigned NOT NULL,
  `total_sale` float unsigned NOT NULL,
  `type` tinyint(4) NOT NULL,
  `date` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pys_stat_product_order` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `product_name` char(100) NOT NULL,
  `qty` int(10) unsigned NOT NULL,
  `gross_sale` float unsigned NOT NULL,
  `type` tinyint(4) NOT NULL,
  `date` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pys_stat_traffic` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `item_value` char(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pys_stat_utm_campaing` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `item_value` char(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pys_stat_utm_content` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `item_value` char(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pys_stat_utm_medium` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `item_value` char(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pys_stat_utm_source` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `item_value` char(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_pys_stat_utm_term` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `item_value` char(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_rank_math_404_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uri` varchar(255) NOT NULL,
  `accessed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `times_accessed` bigint(20) unsigned NOT NULL DEFAULT 1,
  `referer` varchar(255) NOT NULL DEFAULT '',
  `user_agent` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `uri` (`uri`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_rank_math_internal_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `target_post_id` (`target_post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_rank_math_internal_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT 0,
  `external_link_count` int(10) unsigned DEFAULT 0,
  `incoming_link_count` int(10) unsigned DEFAULT 0,
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_rank_math_redirections` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sources` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `url_to` text NOT NULL,
  `header_code` smallint(4) unsigned NOT NULL,
  `hits` bigint(20) unsigned NOT NULL DEFAULT 0,
  `status` varchar(25) NOT NULL DEFAULT 'active',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_rank_math_redirections_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `from_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `redirection_id` bigint(20) unsigned NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `object_type` varchar(10) NOT NULL DEFAULT 'post',
  `is_redirected` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `redirection_id` (`redirection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_slm_orders` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `soid` varchar(255) DEFAULT NULL,
  `recipient_name` varchar(255) NOT NULL,
  `recipient_phone` varchar(255) NOT NULL,
  `tracking_id` varchar(255) DEFAULT NULL,
  `externalLockerId` varchar(255) NOT NULL,
  `status_message` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT 1,
  `slm_tracking_msg` varchar(255) DEFAULT NULL,
  `slm_tracking_status` varchar(255) DEFAULT NULL,
  `pickup_location_code` varchar(255) DEFAULT NULL,
  `pickup_date` varchar(255) DEFAULT NULL,
  `pickup_time_from` varchar(255) DEFAULT NULL,
  `pickup_time_to` varchar(255) DEFAULT NULL,
  `pickup_time_enum` enum('morning','evening') DEFAULT 'morning',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `locker_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1205 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  `term_order` int(4) DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=442 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=442 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_viva_com_smart_wc_checkout_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `woocommerce_order_id` varchar(255) NOT NULL,
  `vivacom_order_code` varchar(100) NOT NULL,
  `client_id` varchar(100) NOT NULL,
  `currency` varchar(3) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `is_demo` tinyint(1) NOT NULL DEFAULT 0,
  `date_add` datetime NOT NULL DEFAULT current_timestamp(),
  `gmt_date_add` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `woocommerce_order_id` (`woocommerce_order_id`),
  KEY `vivacom_order_code` (`vivacom_order_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_viva_com_smart_wc_checkout_recurring` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) NOT NULL,
  `recurring_id` varchar(100) NOT NULL,
  `token_id` varchar(100) NOT NULL,
  `date_add` datetime NOT NULL DEFAULT current_timestamp(),
  `gmt_date_add` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `recurring_id` (`recurring_id`),
  KEY `token_id` (`token_id`),
  CONSTRAINT `wpby_viva_com_smart_wc_checkout_recurring_ibfk_1` FOREIGN KEY (`transaction_id`) REFERENCES `wpby_viva_com_smart_wc_checkout_transactions` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_viva_com_smart_wc_checkout_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `transaction_id` varchar(100) NOT NULL,
  `transaction_type_id` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `date_add` datetime NOT NULL DEFAULT current_timestamp(),
  `gmt_date_add` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id_transaction_id` (`order_id`,`transaction_id`),
  KEY `order_id` (`order_id`),
  KEY `transaction_type_id` (`transaction_type_id`),
  CONSTRAINT `wpby_viva_com_smart_wc_checkout_transactions_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `wpby_viva_com_smart_wc_checkout_orders` (`id`),
  CONSTRAINT `wpby_viva_com_smart_wc_checkout_transactions_ibfk_2` FOREIGN KEY (`transaction_type_id`) REFERENCES `wpby_viva_com_smart_wc_checkout_transaction_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_viva_com_smart_wc_checkout_transaction_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=32478 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT current_timestamp(),
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`),
  KEY `idx_date_paid_status_parent` (`date_paid`,`status`,`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfauditevents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `request_id` bigint(20) unsigned NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT 0,
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfblocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT 0,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT 0,
  `blockedHits` int(10) unsigned DEFAULT 0,
  `expiration` bigint(20) unsigned NOT NULL DEFAULT 0,
  `parameters` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT 0,
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfhits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT 0,
  `statusCode` int(11) NOT NULL DEFAULT 200,
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text DEFAULT NULL,
  `referer` text DEFAULT NULL,
  `UA` text DEFAULT NULL,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text DEFAULT NULL,
  `actionData` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfhoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text DEFAULT NULL,
  `host` text DEFAULT NULL,
  `path` text DEFAULT NULL,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfknownfilelist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT 0.0000000,
  `lon` float(10,7) DEFAULT 0.0000000,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wflogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT 1,
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT 1000,
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfpendingissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfsecurityevents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfsnipcache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT current_timestamp(),
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT 0,
  `type` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfstatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wftrafficrates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wfwaffailures` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int(10) unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wlr_earn_campaign` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(180) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `active` smallint(6) DEFAULT 0,
  `ordering` bigint(20) DEFAULT 0,
  `is_show_way_to_earn` smallint(6) DEFAULT 1,
  `achievement_type` varchar(180) DEFAULT NULL,
  `levels` longtext DEFAULT NULL,
  `start_at` bigint(20) DEFAULT 0,
  `end_at` bigint(20) DEFAULT 0,
  `action_type` varchar(180) DEFAULT NULL,
  `campaign_type` enum('point','coupon') DEFAULT 'point',
  `point_rule` longtext DEFAULT NULL,
  `condition_relationship` enum('and','or') DEFAULT 'and',
  `conditions` longtext DEFAULT NULL,
  `priority` int(11) DEFAULT 0,
  `usage_limits` int(11) DEFAULT 0,
  `icon` varchar(180) DEFAULT NULL,
  `created_at` bigint(20) DEFAULT 0,
  `modified_at` bigint(20) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `name_index` (`name`),
  KEY `start_at_index` (`start_at`),
  KEY `end_at_index` (`end_at`),
  KEY `active_index` (`active`),
  KEY `action_type_index` (`action_type`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wlr_earn_campaign_transaction` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_email` varchar(180) DEFAULT NULL,
  `action_type` varchar(180) DEFAULT NULL,
  `transaction_type` enum('credit','debit') DEFAULT 'credit',
  `campaign_type` varchar(180) DEFAULT NULL,
  `referral_type` varchar(180) DEFAULT NULL,
  `points` bigint(20) DEFAULT 0,
  `display_name` varchar(180) DEFAULT NULL,
  `reward_id` bigint(20) DEFAULT 0,
  `campaign_id` bigint(20) DEFAULT 0,
  `order_id` varchar(180) DEFAULT NULL,
  `order_currency` varchar(180) DEFAULT NULL,
  `order_total` decimal(12,4) DEFAULT 0.0000,
  `product_id` varchar(180) DEFAULT NULL,
  `admin_user_id` bigint(20) unsigned DEFAULT 0,
  `log_data` longtext DEFAULT NULL,
  `customer_command` varchar(180) DEFAULT NULL,
  `action_sub_type` varchar(180) DEFAULT NULL,
  `action_sub_value` varchar(180) DEFAULT NULL,
  `created_at` bigint(20) DEFAULT 0,
  `modified_at` bigint(20) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `user_email_index` (`user_email`),
  KEY `action_type_index` (`action_type`),
  KEY `campaign_type_index` (`campaign_type`),
  KEY `display_name_index` (`display_name`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `order_id_index` (`order_id`),
  KEY `order_currency_index` (`order_currency`),
  KEY `product_id_index` (`product_id`),
  KEY `created_at_index` (`created_at`),
  KEY `transaction_type_index` (`transaction_type`),
  KEY `action_sub_type_index` (`action_sub_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wlr_expire_points` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_email` varchar(180) DEFAULT NULL,
  `action_type` varchar(180) DEFAULT NULL,
  `status` enum('open','active','expired','used') DEFAULT 'open',
  `points` bigint(20) DEFAULT 0,
  `used_points` bigint(20) DEFAULT 0,
  `available_points` bigint(20) DEFAULT 0,
  `earn_trans_campaign_id` bigint(20) DEFAULT 0,
  `debit_trans_campaign_id` varchar(180) DEFAULT NULL,
  `reward_id` bigint(20) DEFAULT 0,
  `campaign_id` bigint(20) DEFAULT 0,
  `order_id` varchar(180) DEFAULT NULL,
  `order_currency` varchar(180) DEFAULT NULL,
  `order_total` decimal(12,4) DEFAULT 0.0000,
  `product_id` varchar(180) DEFAULT NULL,
  `admin_user_id` bigint(20) unsigned DEFAULT 0,
  `log_data` longtext DEFAULT NULL,
  `expire_email_date` bigint(20) DEFAULT 0,
  `is_expire_email_send` int(3) DEFAULT 0,
  `expire_date` bigint(20) DEFAULT 0,
  `created_at` bigint(20) DEFAULT 0,
  `modified_at` bigint(20) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `user_email_index` (`user_email`),
  KEY `action_type_index` (`action_type`),
  KEY `status_index` (`status`),
  KEY `earn_trans_campaign_id_index` (`earn_trans_campaign_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `order_id_index` (`order_id`),
  KEY `order_currency_index` (`order_currency`),
  KEY `product_id_index` (`product_id`),
  KEY `created_at_index` (`created_at`),
  KEY `expire_date_index` (`expire_date`),
  KEY `expire_email_date_index` (`expire_email_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wlr_levels` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(180) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `from_points` bigint(20) DEFAULT 0,
  `to_points` bigint(20) DEFAULT 0,
  `badge` varchar(180) DEFAULT NULL,
  `active` smallint(6) DEFAULT 0,
  `text_color` varchar(180) DEFAULT NULL,
  `created_at` bigint(20) DEFAULT 0,
  `modified_at` bigint(20) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `name_index` (`name`),
  KEY `from_points_index` (`from_points`),
  KEY `to_points_index` (`to_points`),
  KEY `active_index` (`active`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wlr_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_email` varchar(180) DEFAULT NULL,
  `action_type` varchar(180) DEFAULT NULL,
  `reward_id` bigint(20) DEFAULT 0,
  `user_reward_id` bigint(20) DEFAULT 0,
  `campaign_id` bigint(20) DEFAULT 0,
  `earn_campaign_id` bigint(20) DEFAULT 0,
  `note` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  `order_id` bigint(20) DEFAULT 0,
  `product_id` bigint(20) DEFAULT 0,
  `admin_id` bigint(20) DEFAULT 0,
  `points` bigint(20) DEFAULT 0,
  `expire_email_date` bigint(20) DEFAULT 0,
  `expire_date` bigint(20) DEFAULT 0,
  `action_process_type` varchar(180) DEFAULT NULL,
  `referral_type` varchar(180) DEFAULT NULL,
  `reward_display_name` varchar(180) DEFAULT NULL,
  `required_points` bigint(20) DEFAULT 0,
  `discount_code` varchar(180) DEFAULT NULL,
  `created_at` bigint(20) DEFAULT 0,
  `modified_at` bigint(20) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `user_email_index` (`user_email`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wlr_points_ledger` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_email` varchar(180) DEFAULT NULL,
  `action_type` varchar(180) DEFAULT NULL,
  `action_process_type` varchar(180) DEFAULT NULL,
  `credit_points` bigint(20) DEFAULT 0,
  `debit_points` bigint(20) DEFAULT 0,
  `note` text DEFAULT NULL,
  `created_at` bigint(20) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`),
  KEY `action_type_index` (`action_type`),
  KEY `user_email_index` (`user_email`),
  KEY `action_process_type_index` (`action_process_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wlr_referral` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `advocate_email` varchar(180) DEFAULT NULL,
  `friend_email` varchar(180) DEFAULT NULL,
  `status` varchar(180) DEFAULT NULL,
  `created_date` bigint(20) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `advocate_email_index` (`advocate_email`),
  KEY `friend_email_index` (`friend_email`),
  KEY `status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wlr_rewards` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(180) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `reward_type` enum('redeem_point','redeem_coupon') DEFAULT 'redeem_point',
  `discount_type` varchar(180) DEFAULT NULL,
  `discount_value` int(11) DEFAULT 0,
  `free_product` text DEFAULT NULL,
  `display_name` varchar(180) DEFAULT NULL,
  `require_point` int(11) DEFAULT 0,
  `expire_after` int(11) DEFAULT 0,
  `expire_period` enum('day','week','month','year') DEFAULT 'day',
  `enable_expiry_email` int(4) DEFAULT 0,
  `expire_email` int(11) DEFAULT 0,
  `expire_email_period` enum('day','week','month','year') DEFAULT 'day',
  `usage_limits` int(11) DEFAULT 0,
  `condition_relationship` enum('and','or') DEFAULT 'and',
  `conditions` longtext DEFAULT NULL,
  `active` smallint(6) DEFAULT 0,
  `ordering` bigint(20) DEFAULT 0,
  `is_show_reward` smallint(6) DEFAULT 1,
  `minimum_point` int(11) DEFAULT 0,
  `maximum_point` int(11) DEFAULT 0,
  `icon` varchar(180) DEFAULT NULL,
  `created_at` bigint(20) DEFAULT 0,
  `modified_at` bigint(20) DEFAULT 0,
  `coupon_type` varchar(50) DEFAULT NULL,
  `max_discount` int(11) DEFAULT 0,
  `max_percentage` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `name_index` (`name`),
  KEY `reward_type_index` (`reward_type`),
  KEY `require_point_index` (`require_point`),
  KEY `active_index` (`active`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wlr_reward_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_email` varchar(180) DEFAULT NULL,
  `action_type` varchar(180) DEFAULT NULL,
  `user_reward_id` bigint(20) DEFAULT 0,
  `order_id` varchar(180) DEFAULT NULL,
  `order_total` decimal(12,4) DEFAULT 0.0000,
  `reward_amount` decimal(12,4) DEFAULT 0.0000,
  `reward_amount_tax` decimal(12,4) DEFAULT 0.0000,
  `reward_currency` varchar(180) DEFAULT NULL,
  `discount_code` varchar(180) DEFAULT NULL,
  `discount_id` bigint(20) DEFAULT 0,
  `log_data` longtext DEFAULT NULL,
  `created_at` bigint(20) DEFAULT 0,
  `modified_at` bigint(20) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `user_email_index` (`user_email`),
  KEY `created_at_index` (`created_at`),
  KEY `reward_currency_index` (`reward_currency`),
  KEY `user_reward_id_index` (`user_reward_id`),
  KEY `action_type_index` (`action_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wlr_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_email` varchar(180) DEFAULT NULL,
  `refer_code` varchar(180) DEFAULT NULL,
  `points` bigint(20) DEFAULT 0,
  `used_total_points` bigint(20) DEFAULT 0,
  `earn_total_point` bigint(20) DEFAULT 0,
  `birth_date` bigint(20) DEFAULT 0,
  `level_id` bigint(20) DEFAULT 0,
  `is_banned_user` tinyint(4) DEFAULT 0,
  `is_allow_send_email` tinyint(4) DEFAULT 1,
  `birthday_date` date DEFAULT NULL,
  `last_login` bigint(20) DEFAULT 0,
  `created_date` bigint(20) DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_email` (`user_email`(150)),
  KEY `created_date_index` (`created_date`),
  KEY `refer_code_index` (`refer_code`),
  KEY `birth_date_index` (`birth_date`),
  KEY `birthday_date_index` (`birthday_date`),
  KEY `is_banned_user_index` (`is_banned_user`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wlr_user_rewards` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(180) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `email` varchar(180) DEFAULT NULL,
  `reward_id` bigint(20) DEFAULT 0,
  `campaign_id` bigint(20) DEFAULT 0,
  `reward_type` enum('redeem_point','redeem_coupon') DEFAULT 'redeem_point',
  `action_type` varchar(180) DEFAULT NULL,
  `discount_type` varchar(180) DEFAULT NULL,
  `discount_value` decimal(12,4) DEFAULT 0.0000,
  `reward_currency` varchar(180) DEFAULT NULL,
  `discount_code` varchar(180) DEFAULT NULL,
  `discount_id` bigint(20) DEFAULT 0,
  `display_name` varchar(180) DEFAULT NULL,
  `require_point` int(11) DEFAULT 0,
  `status` enum('open','active','used','expired') DEFAULT 'open',
  `start_at` bigint(20) DEFAULT 0,
  `end_at` bigint(20) DEFAULT 0,
  `icon` varchar(180) DEFAULT NULL,
  `expire_email_date` bigint(20) DEFAULT 0,
  `is_expire_email_send` int(3) DEFAULT 0,
  `usage_limits` int(11) DEFAULT 0,
  `condition_relationship` enum('and','or') DEFAULT 'and',
  `conditions` longtext DEFAULT NULL,
  `free_product` text DEFAULT NULL,
  `expire_after` int(11) DEFAULT 0,
  `expire_period` enum('day','week','month','year') DEFAULT 'day',
  `enable_expiry_email` int(4) DEFAULT 1,
  `expire_email` int(11) DEFAULT 0,
  `expire_email_period` enum('day','week','month','year') DEFAULT 'day',
  `minimum_point` int(11) DEFAULT 0,
  `maximum_point` int(11) DEFAULT 0,
  `created_at` bigint(20) DEFAULT 0,
  `modified_at` bigint(20) DEFAULT 0,
  `is_show_reward` smallint(6) DEFAULT 1,
  `coupon_type` varchar(50) DEFAULT NULL,
  `max_discount` int(11) DEFAULT 0,
  `max_percentage` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `email_index` (`email`),
  KEY `discount_code_index` (`discount_code`),
  KEY `status_index` (`status`),
  KEY `end_at_index` (`end_at`),
  KEY `is_expire_email_send_index` (`is_expire_email_send`),
  KEY `expire_email_date_index` (`expire_email_date`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`),
  KEY `session_expiry` (`session_expiry`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_woodmart_unsubscribed_emails` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_email` varchar(100) NOT NULL,
  `unsubscribed_email_name` varchar(100) NOT NULL,
  `unsubscription_date` datetime NOT NULL DEFAULT current_timestamp(),
  `unsubscription_date_gmt` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_woodmart_wishlists` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `wishlist_group` varchar(255) NOT NULL DEFAULT 'My wishlist',
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_woodmart_wishlist_products` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(255) NOT NULL,
  `wishlist_id` int(11) DEFAULT NULL,
  `date_added` timestamp NOT NULL DEFAULT current_timestamp(),
  `on_sale` tinyint(1) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wpby_wpmailsmtp_debug_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` text DEFAULT NULL,
  `initiator` text DEFAULT NULL,
  `event_type` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wpmailsmtp_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wpr_rocket_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_locked` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpby_wpr_rucss_used_css` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `css` longtext DEFAULT NULL,
  `hash` varchar(32) DEFAULT '',
  `error_code` varchar(32) DEFAULT NULL,
  `error_message` longtext DEFAULT NULL,
  `unprocessedcss` longtext DEFAULT NULL,
  `retries` tinyint(1) NOT NULL DEFAULT 1,
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `job_id` varchar(255) NOT NULL DEFAULT '',
  `queue_name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wpby_users` VALUES 
("1","and.adamop","$wp$2y$10$sNZmFhfNNwdTUxCCHykDyOfbKHi4uhj9k6K7WXgN8S5w4eACetuMa","and-adamop","and.adamop@gmail.com","https://staging.promarketing.gr","2026-01-26 08:35:07","","0","and.adamop"),
("2","test","$wp$2y$10$58Du54Mp.Q6m6uKEpRCVgu1bPY9R8TyJKHav4wOqqMFrTot6C7px.","test","test@test.gr","","2026-01-26 12:37:27","","0","test");

INSERT IGNORE INTO `wpby_usermeta` VALUES 
("1","1","nickname","and.adamop"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","wpby_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","wpby_user_level","10"),
("14","1","dismissed_wp_pointers","theme_editor_notice"),
("15","1","show_welcome_panel","0"),
("16","1","session_tokens","a:4:{s:64:\"267f6dca52fddb24b5abba2ca422a7296d9815b9fcd96d98aa8e4cb001595c3a\";a:5:{s:10:\"expiration\";i:1769589320;s:2:\"ip\";s:14:\"62.169.211.222\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1769416520;s:4:\"loco\";a:4:{s:1:\"c\";s:17:\"Loco_data_Session\";s:1:\"v\";i:0;s:1:\"d\";a:1:{s:7:\"success\";a:0:{}}s:1:\"t\";i:1769508539;}}s:64:\"4bb92481ec5864d15370eb565b7989fefd6834b571c13406055f5202765be653\";a:4:{s:10:\"expiration\";i:1769688163;s:2:\"ip\";s:14:\"62.169.211.222\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1769515363;}s:64:\"cbcd637c93ee943d0009a41774d1e0bd8fac0830464640e659c6824bdee941ee\";a:4:{s:10:\"expiration\";i:1769713327;s:2:\"ip\";s:11:\"5.55.125.68\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1769540527;}s:64:\"e8b6e4fa78048a092595bb8d2dfb15d5726408de6448028b28828111f4ea113a\";a:4:{s:10:\"expiration\";i:1769753116;s:2:\"ip\";s:14:\"62.169.211.222\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1769580316;}}"),
("17","1","wpby_dashboard_quick_press_last_post_id","263"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:12:\"62.169.211.0\";}"),
("19","1","closedpostboxes_dashboard","a:1:{i:0;s:36:\"woocommerce_dashboard_recent_reviews\";}"),
("20","1","metaboxhidden_dashboard","a:12:{i:0;s:26:\"rank_math_dashboard_widget\";i:1;s:24:\"flexible-checkout-fields\";i:2;s:32:\"wp_mail_smtp_reports_widget_lite\";i:3;s:20:\"e-dashboard-overview\";i:4;s:21:\"dashboard_site_health\";i:5;s:19:\"dashboard_right_now\";i:6;s:18:\"dashboard_activity\";i:7;s:27:\"duplicator_dashboard_widget\";i:8;s:9:\"themeisle\";i:9;s:36:\"woocommerce_dashboard_recent_reviews\";i:10;s:21:\"dashboard_quick_press\";i:11;s:17:\"dashboard_primary\";}"),
("21","1","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:1:{s:32:\"e165421110ba03099a1c0393373c5b43\";a:12:{s:3:\"key\";s:32:\"e165421110ba03099a1c0393373c5b43\";s:10:\"product_id\";i:233;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";i:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:16:\"tm_cart_item_key\";s:32:\"e165421110ba03099a1c0393373c5b43\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:1:{i:1;d:0.580645159999999993516439644736237823963165283203125;}s:5:\"total\";a:1:{i:1;d:0.580645159999999993516439644736237823963165283203125;}}s:13:\"line_subtotal\";d:2.419354840000000006483560355263762176036834716796875;s:17:\"line_subtotal_tax\";d:0.57999999999999996003197111349436454474925994873046875;s:10:\"line_total\";d:2.419354840000000006483560355263762176036834716796875;s:8:\"line_tax\";d:0.57999999999999996003197111349436454474925994873046875;}}}"),
("22","1","_woocommerce_tracks_anon_id","woo:dzBmCPHEeXS7/pgYbEedklye"),
("23","1","wc_last_active","1769591522"),
("24","1","elementor_introduction","a:5:{s:27:\"e-editor-one-notice-pointer\";b:1;s:27:\"ai-get-started-announcement\";b:1;s:35:\"upload_json_warning_generic_message\";b:1;s:20:\"globals_introduction\";b:1;s:30:\"e-ai-product-image-unification\";b:1;}"),
("25","1","woocommerce_payments_nox_profile","a:1:{s:18:\"hidden_suggestions\";a:2:{i:0;a:2:{s:2:\"id\";s:17:\"paypal_full_stack\";s:9:\"timestamp\";i:1769422574;}i:1;a:2:{s:2:\"id\";s:11:\"woopayments\";s:9:\"timestamp\";i:1769422576;}}}"),
("26","1","meta-box-order_product","a:3:{s:4:\"side\";s:84:\"submitdiv,postimagediv,woocommerce-product-images,product_catdiv,tagsdiv-product_tag\";s:6:\"normal\";s:55:\"woocommerce-product-data,postcustom,slugdiv,postexcerpt\";s:8:\"advanced\";s:0:\"\";}"),
("27","1","last_update","1769602317"),
("28","1","wpby_persisted_preferences","a:5:{s:4:\"core\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:10:\"openPanels\";a:4:{i:0;s:11:\"post-status\";i:1;s:26:\"jf-actions-panel/undefined\";i:2;s:35:\"jf-schedule-panel/jf-schedule-panel\";i:3;s:49:\"jf-limit-responses-panel/jf-limit-responses-panel\";}}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2026-01-27T08:38:09.071Z\";s:22:\"core/customize-widgets\";a:1:{s:12:\"welcomeGuide\";b:0;}s:17:\"core/edit-widgets\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:12:\"welcomeGuide\";b:0;}}"),
("31","1","pro_expiration_chain_notice_dismissed_at","1769425444"),
("32","1","next_chain_notice","1"),
("33","1","pys_notice_dont_CAPI_start_delay","1769425444"),
("34","1","wpby_user-settings","editor=tinymce&libraryContent=browse"),
("35","1","wpby_user-settings-time","1769428218"),
("36","1","woodmart_wishlist_group_1","a:2:{s:7:\"expires\";i:1770031811;s:8:\"products\";a:0:{}}"),
("37","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("38","1","metaboxhidden_nav-menus","a:8:{i:0;s:18:\"add-post-type-post\";i:1;s:21:\"add-post-type-product\";i:2;s:12:\"add-category\";i:3;s:12:\"add-post_tag\";i:4;s:15:\"add-post_format\";i:5;s:17:\"add-product_brand\";i:6;s:15:\"add-product_tag\";i:7;s:30:\"woocommerce_endpoints_nav_link\";}"),
("39","1","nav_menu_recently_edited","22"),
("40","1","closedpostboxes_nav-menus","a:0:{}"),
("41","1","woodmart_wishlist_1","a:2:{s:7:\"expires\";i:1770033269;s:8:\"products\";a:0:{}}"),
("42","2","nickname","test"),
("43","2","first_name",""),
("44","2","last_name",""),
("45","2","description",""),
("46","2","rich_editing","true"),
("47","2","syntax_highlighting","true"),
("48","2","comment_shortcuts","false"),
("49","2","admin_color","fresh"),
("50","2","use_ssl","0"),
("51","2","show_admin_bar_front","true"),
("52","2","locale",""),
("53","2","wpby_capabilities","a:1:{s:12:\"shop_manager\";b:1;}"),
("54","2","wpby_user_level","0"),
("55","2","dismissed_wp_pointers",""),
("56","2","pys_complete_registration","1"),
("58","2","wpby_dashboard_quick_press_last_post_id","229"),
("59","2","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:0:{}}"),
("60","2","community-events-location","a:1:{s:2:\"ip\";s:12:\"62.169.211.0\";}"),
("61","2","closedpostboxes_dashboard","a:9:{i:0;s:24:\"flexible-checkout-fields\";i:1;s:20:\"e-dashboard-overview\";i:2;s:19:\"dashboard_right_now\";i:3;s:18:\"dashboard_activity\";i:4;s:36:\"woocommerce_dashboard_recent_reviews\";i:5;s:28:\"woocommerce_dashboard_status\";i:6;s:43:\"aaaa_webappick_latest_news_dashboard_widget\";i:7;s:21:\"dashboard_quick_press\";i:8;s:17:\"dashboard_primary\";}"),
("62","2","metaboxhidden_dashboard","a:0:{}"),
("63","1","wc_order_count_wpby","0"),
("64","1","wc_money_spent_wpby","0"),
("65","1","woocommerce_admin_coming_soon_banner_dismissed","yes"),
("68","1","manageedit-postcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("69","1","manageedit-postcolumnshidden_default","1"),
("70","1","manageedit-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("71","1","manageedit-pagecolumnshidden_default","1"),
("72","1","manageedit-jet-popupcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("73","1","manageedit-jet-popupcolumnshidden_default","1"),
("74","1","manageedit-e-floating-buttonscolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("75","1","manageedit-e-floating-buttonscolumnshidden_default","1"),
("76","1","manageedit-cms_blockcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("77","1","manageedit-cms_blockcolumnshidden_default","1"),
("78","1","manageedit-productcolumnshidden","a:6:{i:0;s:16:\"global_unique_id\";i:1;s:11:\"product_tag\";i:2;s:21:\"rank_math_seo_details\";i:3;s:22:\"taxonomy-product_brand\";i:4;s:15:\"rank_math_title\";i:5;s:21:\"rank_math_description\";}"),
("79","1","manageedit-productcolumnshidden_default","1"),
("80","1","manageedit-jet-enginecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("81","1","manageedit-jet-enginecolumnshidden_default","1"),
("82","1","edit_product_per_page","20"),
("83","1","pys_just_login","1"),
("84","1","external_id","37388007a7a96b94294060bb1db9cfc1058ad8e139c916be4d8d38a435626747"),
("86","1","wfls-last-login","1769515363"),
("89","1","edit_pa_size_per_page","200"),
("90","1","tgmpa_dismissed_notice_tgmpa","1"),
("91","1","helpmate_job_notices","a:1:{i:0;a:6:{s:6:\"job_id\";s:38:\"helpmate_bulk_697889bb1116b_1769507259\";s:6:\"status\";s:6:\"failed\";s:10:\"successful\";i:14;s:6:\"failed\";i:8;s:6:\"errors\";a:8:{i:0;a:2:{s:14:\"document_title\";s:4:\"Shop\";s:5:\"error\";s:77:\"Sorry, you have reached your embedding credits limit. Please try again later.\";}i:1;a:2:{s:14:\"document_title\";s:4:\"Shop\";s:5:\"error\";s:49:\"Processing stopped due to embedding credits limit\";}i:2;a:2:{s:14:\"document_title\";s:12:\"Καλάθι\";s:5:\"error\";s:49:\"Processing stopped due to embedding credits limit\";}i:3;a:2:{s:14:\"document_title\";s:10:\"Αγορά\";s:5:\"error\";s:49:\"Processing stopped due to embedding credits limit\";}i:4;a:2:{s:14:\"document_title\";s:32:\"Ο λογαριασμός μου\";s:5:\"error\";s:49:\"Processing stopped due to embedding credits limit\";}i:5;a:2:{s:14:\"document_title\";s:12:\"Hello world!\";s:5:\"error\";s:49:\"Processing stopped due to embedding credits limit\";}i:6;a:2:{s:14:\"document_title\";s:50:\"Ben Tailor Ρούχα &amp; Red Raven Γυαλιά\";s:5:\"error\";s:49:\"Processing stopped due to embedding credits limit\";}i:7;a:2:{s:14:\"document_title\";s:35:\"Πολιτική Απορρήτου\";s:5:\"error\";s:49:\"Processing stopped due to embedding credits limit\";}}s:9:\"timestamp\";s:19:\"2026-01-28 11:59:42\";}}"),
("92","1","edit_product_cat_per_page","200");

INSERT IGNORE INTO `wpby_actionscheduler_actions` VALUES 
("7","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-26 09:11:26","2026-01-26 09:11:26","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769418686;s:18:\"\0*\0first_timestamp\";i:1769418686;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769418686;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-26 09:11:28","2026-01-26 09:11:28","1",NULL),
("8","action_scheduler/migration_hook","complete","2026-01-26 09:12:28","2026-01-26 09:12:28","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769418748;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769418748;}","2","1","2026-01-26 09:13:11","2026-01-26 09:13:11","6",NULL),
("9","woocommerce_scheduled_sales","complete","2026-01-27 00:00:00","2026-01-27 00:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769472000;s:18:\"\0*\0first_timestamp\";i:1769472000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769472000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2026-01-27 00:00:30","2026-01-27 03:00:30","891",NULL),
("11","woocommerce_cleanup_personal_data","complete","2026-01-26 09:11:38","2026-01-26 09:11:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769418698;s:18:\"\0*\0first_timestamp\";i:1769418698;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769418698;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2026-01-26 09:13:11","2026-01-26 09:13:11","6",NULL),
("12","woocommerce_cleanup_logs","complete","2026-01-27 03:00:00","2026-01-27 03:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769482800;s:18:\"\0*\0first_timestamp\";i:1769482800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769482800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2026-01-27 03:00:32","2026-01-27 06:00:32","1073",NULL),
("13","woocommerce_cleanup_sessions","complete","2026-01-27 06:00:00","2026-01-27 06:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769493600;s:18:\"\0*\0first_timestamp\";i:1769493600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769493600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2026-01-27 06:00:34","2026-01-27 09:00:34","1258",NULL),
("14","woocommerce_geoip_updater","complete","2026-01-27 06:00:00","2026-01-27 06:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769493600;s:18:\"\0*\0first_timestamp\";i:1769493600;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769493600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}","3","1","2026-01-27 06:00:34","2026-01-27 09:00:34","1258",NULL),
("15","woocommerce_cleanup_rate_limits_wrapper","complete","2026-01-27 03:00:00","2026-01-27 03:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769482800;s:18:\"\0*\0first_timestamp\";i:1769482800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769482800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2026-01-27 03:00:32","2026-01-27 06:00:32","1073",NULL),
("16","wc_admin_daily_wrapper","complete","2026-01-26 09:11:28","2026-01-26 09:11:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769418688;s:18:\"\0*\0first_timestamp\";i:1769418688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769418688;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2026-01-26 09:11:28","2026-01-26 09:11:28","2",NULL),
("17","generate_category_lookup_table_wrapper","complete","2026-01-26 09:11:38","2026-01-26 09:11:38","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769418698;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769418698;}","3","1","2026-01-26 09:13:11","2026-01-26 09:13:11","6",NULL),
("18","woocommerce_refresh_order_count_cache","complete","2026-01-26 21:11:28","2026-01-26 21:11:28","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769461888;s:18:\"\0*\0first_timestamp\";i:1769461888;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769461888;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2026-01-26 21:11:28","2026-01-27 00:11:28","716",NULL),
("19","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-27 09:11:28","2026-01-27 09:11:28","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769505088;s:18:\"\0*\0first_timestamp\";i:1769418686;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769505088;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-27 09:11:33","2026-01-27 12:11:33","1450",NULL),
("20","woocommerce_cleanup_draft_orders","complete","2026-01-26 09:11:28","2026-01-26 09:11:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769418688;s:18:\"\0*\0first_timestamp\";i:1769418688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769418688;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","1","2026-01-26 09:11:28","2026-01-26 09:11:28","3",NULL),
("21","wc_admin_daily_wrapper","complete","2026-01-27 09:11:28","2026-01-27 09:11:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769505088;s:18:\"\0*\0first_timestamp\";i:1769418688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769505088;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2026-01-27 09:11:33","2026-01-27 12:11:33","1450",NULL),
("22","woocommerce_cleanup_draft_orders","complete","2026-01-27 09:11:28","2026-01-27 09:11:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769505088;s:18:\"\0*\0first_timestamp\";i:1769418688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769505088;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","1","2026-01-27 09:11:33","2026-01-27 12:11:33","1450",NULL),
("23","woocommerce_cleanup_personal_data","complete","2026-01-27 09:13:11","2026-01-27 09:13:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769505191;s:18:\"\0*\0first_timestamp\";i:1769418698;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769505191;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2026-01-27 09:13:29","2026-01-27 12:13:29","1455",NULL),
("24","woocommerce_cancel_unpaid_orders","complete","2026-01-26 11:11:45","2026-01-26 11:11:45","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769425905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769425905;}","3","1","2026-01-26 11:12:30","2026-01-26 14:12:30","117",NULL),
("26","woocommerce_install_assembler_fonts","complete","2026-01-26 10:17:27","2026-01-26 10:17:27","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769422647;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769422647;}","5","1","2026-01-26 10:17:29","2026-01-26 10:17:29","53",NULL),
("27","fetch_patterns","complete","2026-01-26 10:17:27","2026-01-26 10:17:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769422647;s:18:\"\0*\0first_timestamp\";i:1769422647;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769422647;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2026-01-26 10:17:29","2026-01-26 10:17:29","53",NULL),
("46","woocommerce_cancel_unpaid_orders","complete","2026-01-26 12:12:30","2026-01-26 12:12:30","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769429550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769429550;}","3","1","2026-01-26 12:14:24","2026-01-26 15:14:24","182",NULL),
("47","rocket_preload_job_check_finished","failed","2026-01-26 11:23:22","2026-01-26 11:23:22","10","[1769426542]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769426602;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769426602;}","6","1","2026-01-26 11:23:28","2026-01-26 14:23:28","129",NULL),
("48","action_scheduler/migration_hook","complete","2026-01-26 11:23:30","2026-01-26 11:23:30","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769426610;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769426610;}","2","1","2026-01-26 11:24:26","2026-01-26 14:24:26","131",NULL),
("49","action_scheduler/migration_hook","complete","2026-01-26 12:05:30","2026-01-26 12:05:30","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769429130;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769429130;}","2","1","2026-01-26 12:05:33","2026-01-26 15:05:33","173",NULL),
("50","woocommerce_cancel_unpaid_orders","complete","2026-01-26 13:14:24","2026-01-26 13:14:24","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769433264;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769433264;}","3","1","2026-01-26 13:15:22","2026-01-26 16:15:22","252",NULL),
("74","rocket_preload_job_check_finished","failed","2026-01-26 12:40:55","2026-01-26 12:40:55","10","[1769431195]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769431255;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769431255;}","6","1","2026-01-26 12:41:15","2026-01-26 15:41:15","216",NULL),
("75","action_scheduler/migration_hook","complete","2026-01-26 12:41:01","2026-01-26 12:41:01","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769431261;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769431261;}","2","1","2026-01-26 12:41:15","2026-01-26 15:41:15","216",NULL),
("76","woocommerce_cancel_unpaid_orders","complete","2026-01-26 14:15:22","2026-01-26 14:15:22","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769436922;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769436922;}","3","1","2026-01-26 14:15:23","2026-01-26 17:15:23","313",NULL),
("77","woocommerce_cancel_unpaid_orders","complete","2026-01-26 15:15:23","2026-01-26 15:15:23","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769440523;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769440523;}","3","1","2026-01-26 15:15:24","2026-01-26 18:15:24","376",NULL),
("78","woocommerce_cancel_unpaid_orders","complete","2026-01-26 16:15:24","2026-01-26 16:15:24","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769444124;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769444124;}","3","1","2026-01-26 16:15:24","2026-01-26 19:15:24","437",NULL),
("79","woocommerce_cancel_unpaid_orders","complete","2026-01-26 17:15:24","2026-01-26 17:15:24","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769447724;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769447724;}","3","1","2026-01-26 17:15:25","2026-01-26 20:15:25","498",NULL),
("80","woocommerce_cancel_unpaid_orders","complete","2026-01-26 18:15:25","2026-01-26 18:15:25","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769451325;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769451325;}","3","1","2026-01-26 18:15:26","2026-01-26 21:15:26","550",NULL),
("81","woocommerce_cancel_unpaid_orders","complete","2026-01-26 19:15:26","2026-01-26 19:15:26","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769454926;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769454926;}","3","1","2026-01-26 19:15:27","2026-01-26 22:15:27","597",NULL),
("82","woocommerce_cancel_unpaid_orders","complete","2026-01-26 20:15:27","2026-01-26 20:15:27","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769458527;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769458527;}","3","1","2026-01-26 20:15:27","2026-01-26 23:15:27","659",NULL),
("83","woocommerce_cancel_unpaid_orders","complete","2026-01-26 21:15:27","2026-01-26 21:15:27","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769462127;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769462127;}","3","1","2026-01-26 21:15:28","2026-01-27 00:15:28","721",NULL),
("84","woocommerce_refresh_order_count_cache","complete","2026-01-27 09:11:28","2026-01-27 09:11:28","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769505088;s:18:\"\0*\0first_timestamp\";i:1769461888;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769505088;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2026-01-27 09:11:33","2026-01-27 12:11:33","1450",NULL),
("85","woocommerce_cancel_unpaid_orders","complete","2026-01-26 22:15:28","2026-01-26 22:15:28","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769465728;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769465728;}","3","1","2026-01-26 22:15:29","2026-01-27 01:15:29","782",NULL),
("86","woocommerce_cancel_unpaid_orders","complete","2026-01-26 23:15:29","2026-01-26 23:15:29","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769469329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769469329;}","3","1","2026-01-26 23:15:29","2026-01-27 02:15:29","844",NULL),
("87","woocommerce_cancel_unpaid_orders","complete","2026-01-27 00:15:29","2026-01-27 00:15:29","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769472929;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769472929;}","3","1","2026-01-27 00:15:30","2026-01-27 03:15:30","905",NULL),
("88","woocommerce_scheduled_sales","complete","2026-01-28 00:00:30","2026-01-28 00:00:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769558430;s:18:\"\0*\0first_timestamp\";i:1769472000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769558430;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2026-01-28 00:04:41","2026-01-28 03:04:41","1671",NULL),
("89","woocommerce_cancel_unpaid_orders","complete","2026-01-27 01:15:30","2026-01-27 01:15:30","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769476530;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769476530;}","3","1","2026-01-27 01:15:31","2026-01-27 04:15:31","966",NULL),
("90","woocommerce_cancel_unpaid_orders","complete","2026-01-27 02:15:31","2026-01-27 02:15:31","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769480131;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769480131;}","3","1","2026-01-27 02:15:31","2026-01-27 05:15:31","1027",NULL),
("91","woocommerce_cancel_unpaid_orders","complete","2026-01-27 03:15:31","2026-01-27 03:15:31","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769483731;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769483731;}","3","1","2026-01-27 03:15:32","2026-01-27 06:15:32","1090",NULL),
("92","woocommerce_cleanup_logs","complete","2026-01-28 03:00:32","2026-01-28 03:00:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769569232;s:18:\"\0*\0first_timestamp\";i:1769482800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769569232;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2026-01-28 03:04:41","2026-01-28 06:04:41","1682",NULL),
("93","woocommerce_cleanup_rate_limits_wrapper","complete","2026-01-28 03:00:32","2026-01-28 03:00:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769569232;s:18:\"\0*\0first_timestamp\";i:1769482800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769569232;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2026-01-28 03:04:41","2026-01-28 06:04:41","1682",NULL),
("94","woocommerce_cancel_unpaid_orders","complete","2026-01-27 04:15:32","2026-01-27 04:15:32","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769487332;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769487332;}","3","1","2026-01-27 04:15:33","2026-01-27 07:15:33","1151",NULL),
("95","woocommerce_cancel_unpaid_orders","complete","2026-01-27 05:15:33","2026-01-27 05:15:33","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769490933;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769490933;}","3","1","2026-01-27 05:15:34","2026-01-27 08:15:34","1212",NULL),
("96","woocommerce_cancel_unpaid_orders","complete","2026-01-27 06:15:34","2026-01-27 06:15:34","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769494534;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769494534;}","3","1","2026-01-27 06:15:34","2026-01-27 09:15:34","1275",NULL),
("98","woocommerce_geoip_updater","pending","2026-02-11 06:00:34","2026-02-11 06:00:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770789634;s:18:\"\0*\0first_timestamp\";i:1769493600;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770789634;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("99","woocommerce_cancel_unpaid_orders","complete","2026-01-27 07:15:34","2026-01-27 07:15:34","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769498134;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769498134;}","3","1","2026-01-27 07:15:35","2026-01-27 10:15:35","1337",NULL),
("100","woocommerce_cancel_unpaid_orders","complete","2026-01-27 08:15:35","2026-01-27 08:15:35","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769501735;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769501735;}","3","1","2026-01-27 08:16:31","2026-01-27 11:16:31","1396",NULL),
("101","action_scheduler/migration_hook","complete","2026-01-27 07:57:31","2026-01-27 07:57:31","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769500651;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769500651;}","2","1","2026-01-27 07:57:34","2026-01-27 10:57:34","1371",NULL),
("102","action_scheduler/migration_hook","complete","2026-01-27 07:59:40","2026-01-27 07:59:40","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769500780;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769500780;}","2","1","2026-01-27 07:59:54","2026-01-27 10:59:54","1376",NULL),
("103","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","failed","2026-01-27 08:03:29","2026-01-27 08:03:29","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","5","1","2026-01-27 08:03:39","2026-01-27 11:03:39","1382",NULL),
("104","woocommerce_cancel_unpaid_orders","complete","2026-01-27 09:16:31","2026-01-27 09:16:31","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769505391;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769505391;}","3","1","2026-01-27 09:16:34","2026-01-27 12:16:34","1460",NULL),
("105","wc_admin_daily_wrapper","complete","2026-01-28 09:11:33","2026-01-28 09:11:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769591493;s:18:\"\0*\0first_timestamp\";i:1769418688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769591493;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2026-01-28 09:11:34","2026-01-28 12:11:34","1914",NULL),
("106","woocommerce_cleanup_draft_orders","complete","2026-01-28 09:11:33","2026-01-28 09:11:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769591493;s:18:\"\0*\0first_timestamp\";i:1769418688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769591493;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","1","2026-01-28 09:11:34","2026-01-28 12:11:34","1914",NULL),
("107","woocommerce_refresh_order_count_cache","complete","2026-01-27 21:11:33","2026-01-27 21:11:33","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769548293;s:18:\"\0*\0first_timestamp\";i:1769461888;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769548293;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","1","2026-01-27 21:34:40","2026-01-28 00:34:40","1662",NULL),
("108","woocommerce_cleanup_sessions","complete","2026-01-28 03:00:00","2026-01-28 03:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769569200;s:18:\"\0*\0first_timestamp\";i:1769569200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769569200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","1","2026-01-28 03:04:41","2026-01-28 06:04:41","1682",NULL),
("109","generate_category_lookup_table_wrapper","complete","2026-01-27 09:11:43","2026-01-27 09:11:43","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769505103;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769505103;}","3","1","2026-01-27 09:12:10","2026-01-27 12:12:10","1452",NULL),
("110","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-28 09:11:33","2026-01-28 09:11:33","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769591493;s:18:\"\0*\0first_timestamp\";i:1769418686;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769591493;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-28 09:11:34","2026-01-28 12:11:34","1914",NULL),
("111","woocommerce_cleanup_personal_data","complete","2026-01-28 09:13:29","2026-01-28 09:13:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769591609;s:18:\"\0*\0first_timestamp\";i:1769418698;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769591609;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2026-01-28 09:13:58","2026-01-28 12:13:58","1919",NULL),
("112","woocommerce_cancel_unpaid_orders","complete","2026-01-27 10:16:34","2026-01-27 10:16:34","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769508994;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769508994;}","3","1","2026-01-27 10:16:56","2026-01-27 13:16:56","1528",NULL),
("113","action_scheduler/migration_hook","complete","2026-01-27 09:23:43","2026-01-27 09:23:43","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769505823;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769505823;}","2","1","2026-01-27 09:24:12","2026-01-27 12:24:12","1469",NULL),
("125","rocket_preload_job_check_finished","failed","2026-01-27 09:26:04","2026-01-27 09:26:04","10","[1769505904]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769505964;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769505964;}","6","1","2026-01-27 09:26:27","2026-01-27 12:26:27","1477",NULL),
("138","action_scheduler/migration_hook","complete","2026-01-27 09:27:08","2026-01-27 09:27:08","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769506028;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769506028;}","2","1","2026-01-27 09:27:40","2026-01-27 12:27:40","1480",NULL),
("164","woocommerce_cancel_unpaid_orders","complete","2026-01-27 11:16:56","2026-01-27 11:16:56","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769512616;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769512616;}","3","1","2026-01-27 11:17:54","2026-01-27 14:17:54","1570",NULL),
("165","action_scheduler/migration_hook","complete","2026-01-27 10:32:18","2026-01-27 10:32:18","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769509938;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769509938;}","2","1","2026-01-27 10:33:25","2026-01-27 13:33:25","1541",NULL),
("166","rank_math/analytics/email_report_event","failed","2026-01-28 00:00:00","2026-01-28 00:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769558400;s:18:\"\0*\0first_timestamp\";i:1769558400;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769558400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}","7","1","2026-01-28 00:04:41","2026-01-28 03:04:41","1671",NULL),
("168","wp_mail_smtp_admin_notifications_update","complete","2026-01-27 10:58:22","2026-01-27 10:58:22","10","[null]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769511502;s:18:\"\0*\0first_timestamp\";i:1769511502;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769511502;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","8","1","2026-01-27 11:04:25","2026-01-27 14:04:25","1560",NULL),
("170","woocommerce_cancel_unpaid_orders","complete","2026-01-27 12:17:54","2026-01-27 12:17:54","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769516274;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769516274;}","3","1","2026-01-27 12:34:38","2026-01-27 15:34:38","1618",NULL),
("171","action_scheduler/migration_hook","complete","2026-01-27 11:46:36","2026-01-27 11:46:36","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769514396;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769514396;}","2","1","2026-01-27 11:46:40","2026-01-27 14:46:40","1598",NULL),
("172","action_scheduler/migration_hook","complete","2026-01-27 11:47:47","2026-01-27 11:47:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769514467;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769514467;}","2","1","2026-01-27 11:47:50","2026-01-27 14:47:50","1602",NULL),
("186","action_scheduler/migration_hook","complete","2026-01-27 12:05:41","2026-01-27 12:05:41","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769515541;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769515541;}","2","1","2026-01-27 12:07:08","2026-01-27 15:07:08","1612",NULL),
("187","woocommerce_cancel_unpaid_orders","complete","2026-01-27 13:34:38","2026-01-27 13:34:38","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769520878;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769520878;}","3","1","2026-01-27 13:34:38","2026-01-27 16:34:38","1623",NULL),
("188","woocommerce_cancel_unpaid_orders","complete","2026-01-27 14:34:38","2026-01-27 14:34:38","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769524478;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769524478;}","3","1","2026-01-27 14:34:39","2026-01-27 17:34:39","1626",NULL),
("189","woocommerce_cancel_unpaid_orders","complete","2026-01-27 15:34:39","2026-01-27 15:34:39","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769528079;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769528079;}","3","1","2026-01-27 15:34:39","2026-01-27 18:34:39","1630",NULL),
("190","woocommerce_cancel_unpaid_orders","complete","2026-01-27 16:34:39","2026-01-27 16:34:39","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769531679;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769531679;}","3","1","2026-01-27 16:34:39","2026-01-27 19:34:39","1633",NULL),
("191","woocommerce_cancel_unpaid_orders","complete","2026-01-27 17:34:39","2026-01-27 17:34:39","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769535279;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769535279;}","3","1","2026-01-27 18:04:40","2026-01-27 21:04:40","1639",NULL),
("192","woocommerce_cancel_unpaid_orders","complete","2026-01-27 19:04:40","2026-01-27 19:04:40","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769540680;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769540680;}","3","1","2026-01-27 19:05:30","2026-01-27 22:05:30","1646",NULL),
("193","action_scheduler/migration_hook","complete","2026-01-27 19:06:30","2026-01-27 19:06:30","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769540790;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769540790;}","2","1","2026-01-27 19:06:36","2026-01-27 22:06:36","1650",NULL),
("194","woocommerce_cancel_unpaid_orders","complete","2026-01-27 20:05:30","2026-01-27 20:05:30","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769544330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769544330;}","3","1","2026-01-27 20:34:40","2026-01-27 23:34:40","1659",NULL),
("195","action_scheduler/migration_hook","failed","2026-01-27 19:07:36","2026-01-27 19:07:36","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769540856;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769540856;}","2","1","2026-01-27 19:07:37","2026-01-27 22:07:37","1653",NULL),
("196","woocommerce_cancel_unpaid_orders","complete","2026-01-27 21:34:40","2026-01-27 21:34:40","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769549680;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769549680;}","3","1","2026-01-27 21:34:40","2026-01-28 00:34:40","1662",NULL),
("197","woocommerce_refresh_order_count_cache","pending","2026-01-28 09:34:40","2026-01-28 09:34:40","10","[\"shop_order\"]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769592880;s:18:\"\0*\0first_timestamp\";i:1769461888;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769592880;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","4","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("198","woocommerce_cancel_unpaid_orders","complete","2026-01-27 22:34:40","2026-01-27 22:34:40","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769553280;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769553280;}","3","1","2026-01-27 22:34:40","2026-01-28 01:34:40","1666",NULL),
("199","woocommerce_cancel_unpaid_orders","complete","2026-01-27 23:34:40","2026-01-27 23:34:40","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769556880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769556880;}","3","1","2026-01-27 23:34:41","2026-01-28 02:34:41","1669",NULL),
("200","woocommerce_cancel_unpaid_orders","complete","2026-01-28 00:34:41","2026-01-28 00:34:41","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769560481;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769560481;}","3","1","2026-01-28 00:34:41","2026-01-28 03:34:41","1673",NULL),
("201","rank_math/analytics/email_report_event","pending","2026-02-27 00:04:41","2026-02-27 00:04:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772150681;s:18:\"\0*\0first_timestamp\";i:1769558400;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772150681;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}","7","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("202","woocommerce_scheduled_sales","pending","2026-01-29 00:04:41","2026-01-29 00:04:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769645081;s:18:\"\0*\0first_timestamp\";i:1769472000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769645081;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("203","woocommerce_cancel_unpaid_orders","complete","2026-01-28 01:34:41","2026-01-28 01:34:41","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769564081;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769564081;}","3","1","2026-01-28 01:34:41","2026-01-28 04:34:41","1677",NULL),
("204","woocommerce_cancel_unpaid_orders","complete","2026-01-28 02:34:41","2026-01-28 02:34:41","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769567681;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769567681;}","3","1","2026-01-28 02:34:42","2026-01-28 05:34:42","1680",NULL),
("205","woocommerce_cancel_unpaid_orders","complete","2026-01-28 03:34:42","2026-01-28 03:34:42","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769571282;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769571282;}","3","1","2026-01-28 03:34:42","2026-01-28 06:34:42","1684",NULL),
("207","woocommerce_cleanup_logs","pending","2026-01-29 03:04:41","2026-01-29 03:04:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769655881;s:18:\"\0*\0first_timestamp\";i:1769482800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769655881;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("208","woocommerce_cleanup_rate_limits_wrapper","pending","2026-01-29 03:04:41","2026-01-29 03:04:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769655881;s:18:\"\0*\0first_timestamp\";i:1769482800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769655881;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("209","woocommerce_cancel_unpaid_orders","complete","2026-01-28 04:34:42","2026-01-28 04:34:42","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769574882;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769574882;}","3","1","2026-01-28 04:34:42","2026-01-28 07:34:42","1687",NULL),
("210","woocommerce_cancel_unpaid_orders","complete","2026-01-28 05:34:42","2026-01-28 05:34:42","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769578482;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769578482;}","3","1","2026-01-28 05:34:42","2026-01-28 08:34:42","1690",NULL),
("211","woocommerce_cancel_unpaid_orders","complete","2026-01-28 06:34:42","2026-01-28 06:34:42","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769582082;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769582082;}","3","1","2026-01-28 06:35:09","2026-01-28 09:35:09","1726",NULL),
("212","action_scheduler/migration_hook","complete","2026-01-28 06:19:24","2026-01-28 06:19:24","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769581164;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769581164;}","2","1","2026-01-28 06:19:31","2026-01-28 09:19:31","1707",NULL),
("213","action_scheduler/migration_hook","failed","2026-01-28 06:20:31","2026-01-28 06:20:31","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769581231;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769581231;}","2","1","2026-01-28 06:20:59","2026-01-28 09:20:59","1709",NULL),
("214","woocommerce_cancel_unpaid_orders","complete","2026-01-28 07:35:09","2026-01-28 07:35:09","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769585709;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769585709;}","3","1","2026-01-28 07:35:31","2026-01-28 10:35:31","1791",NULL),
("215","action_scheduler/migration_hook","complete","2026-01-28 06:36:40","2026-01-28 06:36:40","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769582200;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769582200;}","2","1","2026-01-28 06:37:19","2026-01-28 09:37:19","1730",NULL),
("216","action_scheduler/migration_hook","complete","2026-01-28 07:21:48","2026-01-28 07:21:48","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769584908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769584908;}","2","1","2026-01-28 07:22:28","2026-01-28 10:22:28","1777",NULL),
("217","woocommerce_cancel_unpaid_orders","complete","2026-01-28 08:35:31","2026-01-28 08:35:31","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769589331;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769589331;}","3","1","2026-01-28 08:35:34","2026-01-28 11:35:34","1856",NULL),
("218","action_scheduler/migration_hook","complete","2026-01-28 07:54:29","2026-01-28 07:54:29","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769586869;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769586869;}","2","1","2026-01-28 07:54:33","2026-01-28 10:54:33","1811",NULL),
("219","action_scheduler/migration_hook","failed","2026-01-28 07:55:33","2026-01-28 07:55:33","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769586933;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769586933;}","2","1","2026-01-28 07:56:26","2026-01-28 10:56:26","1813",NULL),
("220","action_scheduler/migration_hook","complete","2026-01-28 08:08:19","2026-01-28 08:08:19","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769587699;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769587699;}","2","1","2026-01-28 08:08:23","2026-01-28 11:08:23","1827",NULL),
("221","woocommerce_cancel_unpaid_orders","pending","2026-01-28 09:35:34","2026-01-28 09:35:34","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769592934;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769592934;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("222","action_scheduler/migration_hook","complete","2026-01-28 08:57:04","2026-01-28 08:57:04","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769590624;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769590624;}","2","1","2026-01-28 08:57:43","2026-01-28 11:57:43","1879",NULL),
("223","rocket_preload_job_load_initial_sitemap","complete","2026-01-28 08:59:04","2026-01-28 08:59:04","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","6","1","2026-01-28 08:59:47","2026-01-28 11:59:47","1883",NULL),
("225","wp_mail_smtp_admin_notifications_update","failed","2026-01-28 09:00:06","2026-01-28 09:00:06","10","[null]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769590806;s:18:\"\0*\0first_timestamp\";i:1769590806;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769590806;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","8","1","2026-01-28 09:01:47","2026-01-28 12:01:47","1888",NULL),
("226","rocket_preload_job_preload_url","complete","2026-01-28 08:59:47","2026-01-28 08:59:47","10","[\"https:\\/\\/staging.promarketing.gr\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","6","1","2026-01-28 08:59:47","2026-01-28 11:59:47","1884",NULL),
("227","rocket_preload_job_preload_url","complete","2026-01-28 09:00:10","2026-01-28 09:00:10","10","[\"https:\\/\\/staging.promarketing.gr\\/wp-login.php\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","6","1","2026-01-28 09:01:48","2026-01-28 12:01:48","1888",NULL),
("228","action_scheduler/migration_hook","complete","2026-01-28 09:02:47","2026-01-28 09:02:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769590967;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769590967;}","2","1","2026-01-28 09:04:34","2026-01-28 12:04:34","1891",NULL),
("230","rocket_preload_job_preload_url","complete","2026-01-28 09:01:48","2026-01-28 09:01:48","10","[\"https:\\/\\/staging.promarketing.gr\\/product-category\\/plus-size-fashion\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","6","1","2026-01-28 09:01:49","2026-01-28 12:01:49","1889",NULL),
("231","action_scheduler/migration_hook","complete","2026-01-28 09:05:38","2026-01-28 09:05:38","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591138;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591138;}","2","1","2026-01-28 09:07:03","2026-01-28 12:07:03","1894",NULL),
("232","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("233","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("234","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("235","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("236","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("237","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("238","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("239","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("240","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("241","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("242","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("243","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("244","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("245","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("246","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("247","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("248","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("249","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("250","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("251","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("252","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("253","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("254","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("255","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("256","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1900",NULL),
("257","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("258","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("259","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("260","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("261","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("262","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("263","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("264","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("265","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("266","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("267","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("268","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("269","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("270","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("271","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("272","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("273","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("274","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("275","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("276","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("277","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("278","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("279","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("280","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("281","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1901",NULL),
("282","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("283","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("284","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("285","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("286","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("287","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("288","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("289","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:46","2026-01-28 09:09:46","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591386;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("290","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("291","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("292","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("293","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("294","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("295","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("296","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("297","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("298","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("299","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("300","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("301","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("302","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("303","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("304","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("305","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("306","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1902",NULL),
("307","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("308","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("309","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("310","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("311","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("312","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("313","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("314","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("315","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("316","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("317","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("318","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("319","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("320","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("321","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("322","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("323","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("324","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("325","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("326","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("327","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("328","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("329","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("330","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("331","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1903",NULL),
("332","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("333","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("334","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("335","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("336","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("337","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("338","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("339","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("340","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("341","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("342","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("343","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("344","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("345","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("346","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("347","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("348","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("349","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("350","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:47","2026-01-28 09:09:47","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591387;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("351","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:48","2026-01-28 09:09:48","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591388;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591388;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("352","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:48","2026-01-28 09:09:48","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591388;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591388;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("353","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:48","2026-01-28 09:09:48","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591388;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591388;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("354","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:48","2026-01-28 09:09:48","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591388;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591388;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("355","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:48","2026-01-28 09:09:48","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591388;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591388;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("356","wc_schedule_update_product_default_cat","complete","2026-01-28 09:09:48","2026-01-28 09:09:48","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591388;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591388;}","9","1","2026-01-28 09:10:18","2026-01-28 12:10:18","1904",NULL),
("357","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("358","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("359","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("360","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("361","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("362","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("363","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("364","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("365","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("366","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("367","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("368","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("369","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("370","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("371","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("372","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("373","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("374","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("375","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("376","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("377","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("378","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("379","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("380","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("381","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1907",NULL),
("382","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("383","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("384","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("385","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("386","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("387","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("388","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("389","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("390","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("391","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("392","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("393","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("394","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("395","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("396","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("397","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("398","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("399","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("400","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("401","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("402","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("403","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("404","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:12","2026-01-28 09:11:12","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591472;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("405","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("406","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1908",NULL),
("407","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("408","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("409","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("410","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("411","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("412","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("413","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("414","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("415","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("416","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("417","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("418","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("419","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("420","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("421","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("422","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("423","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("424","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("425","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("426","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("427","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("428","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("429","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("430","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("431","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1909",NULL),
("432","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("433","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("434","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("435","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("436","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("437","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("438","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("439","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("440","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("441","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("442","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("443","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("444","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("445","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("446","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("447","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("448","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("449","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("450","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("451","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("452","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("453","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("454","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("455","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("456","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1910",NULL),
("457","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("458","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("459","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("460","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("461","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("462","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("463","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("464","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("465","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("466","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("467","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("468","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("469","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("470","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("471","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:13","2026-01-28 09:11:13","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591473;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("472","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:14","2026-01-28 09:11:14","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591474;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591474;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("473","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:14","2026-01-28 09:11:14","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591474;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591474;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("474","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:14","2026-01-28 09:11:14","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591474;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591474;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("475","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:14","2026-01-28 09:11:14","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591474;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591474;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("476","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:14","2026-01-28 09:11:14","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591474;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591474;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("477","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:14","2026-01-28 09:11:14","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591474;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591474;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("478","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:14","2026-01-28 09:11:14","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591474;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591474;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("479","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:14","2026-01-28 09:11:14","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591474;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591474;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("480","wc_schedule_update_product_default_cat","complete","2026-01-28 09:11:14","2026-01-28 09:11:14","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591474;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591474;}","9","1","2026-01-28 09:11:28","2026-01-28 12:11:28","1911",NULL),
("481","wc_admin_daily_wrapper","pending","2026-01-29 09:11:34","2026-01-29 09:11:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769677894;s:18:\"\0*\0first_timestamp\";i:1769418688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769677894;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("482","woocommerce_cleanup_draft_orders","pending","2026-01-29 09:11:34","2026-01-29 09:11:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769677894;s:18:\"\0*\0first_timestamp\";i:1769418688;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769677894;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","5","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("483","woocommerce_cleanup_sessions","pending","2026-01-29 03:00:00","2026-01-29 03:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769655600;s:18:\"\0*\0first_timestamp\";i:1769655600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769655600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("484","generate_category_lookup_table_wrapper","complete","2026-01-28 09:11:44","2026-01-28 09:11:44","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591504;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591504;}","3","1","2026-01-28 09:12:38","2026-01-28 12:12:38","1916",NULL),
("485","action_scheduler_run_recurring_actions_schedule_hook","pending","2026-01-29 09:11:34","2026-01-29 09:11:34","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769677894;s:18:\"\0*\0first_timestamp\";i:1769418686;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769677894;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("486","action_scheduler/migration_hook","pending","2026-01-28 09:14:10","2026-01-28 09:14:10","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769591650;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769591650;}","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("487","woocommerce_cleanup_personal_data","pending","2026-01-29 09:13:58","2026-01-29 09:13:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769678038;s:18:\"\0*\0first_timestamp\";i:1769418698;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769678038;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL);

INSERT IGNORE INTO `wpby_actionscheduler_groups` VALUES 
("1","ActionScheduler"),
("2","action-scheduler-migration"),
("3","woocommerce"),
("4","count"),
("5",""),
("6","rocket-preload"),
("7","rank-math"),
("8","wp_mail_smtp"),
("9","wc_update_product_default_cat");

INSERT IGNORE INTO `wpby_actionscheduler_logs` VALUES 
("1","7","ενέργεια δημιουργήθηκε","2026-01-26 09:11:26","2026-01-26 09:11:26"),
("2","8","ενέργεια δημιουργήθηκε","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("3","7","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("4","9","ενέργεια δημιουργήθηκε","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("6","11","ενέργεια δημιουργήθηκε","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("7","12","ενέργεια δημιουργήθηκε","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("8","13","ενέργεια δημιουργήθηκε","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("9","14","ενέργεια δημιουργήθηκε","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("10","15","ενέργεια δημιουργήθηκε","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("11","16","ενέργεια δημιουργήθηκε","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("12","17","ενέργεια δημιουργήθηκε","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("13","18","ενέργεια δημιουργήθηκε","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("14","7","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("15","19","ενέργεια δημιουργήθηκε","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("16","16","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("17","20","ενέργεια δημιουργήθηκε","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("18","16","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("19","21","ενέργεια δημιουργήθηκε","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("20","20","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("21","20","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("22","22","ενέργεια δημιουργήθηκε","2026-01-26 09:11:28","2026-01-26 09:11:28"),
("23","11","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-26 09:13:11","2026-01-26 09:13:11"),
("24","11","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-26 09:13:11","2026-01-26 09:13:11"),
("25","23","ενέργεια δημιουργήθηκε","2026-01-26 09:13:11","2026-01-26 09:13:11"),
("26","17","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-26 09:13:11","2026-01-26 09:13:11"),
("27","17","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-26 09:13:11","2026-01-26 09:13:11"),
("28","8","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-26 09:13:11","2026-01-26 09:13:11"),
("29","8","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-26 09:13:11","2026-01-26 09:13:11"),
("31","24","ενέργεια δημιουργήθηκε","2026-01-26 10:11:45","2026-01-26 10:11:45"),
("33","26","ενέργεια δημιουργήθηκε","2026-01-26 10:17:27","2026-01-26 10:17:27"),
("34","27","ενέργεια δημιουργήθηκε","2026-01-26 10:17:27","2026-01-26 10:17:27"),
("35","26","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-26 10:17:27","2026-01-26 10:17:27"),
("36","26","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-26 10:17:29","2026-01-26 10:17:29"),
("37","27","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-26 10:17:29","2026-01-26 10:17:29"),
("38","27","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-26 10:17:29","2026-01-26 10:17:29"),
("93","24","action started via WP Cron","2026-01-26 11:12:30","2026-01-26 11:12:30"),
("94","46","action created","2026-01-26 11:12:30","2026-01-26 11:12:30"),
("95","24","action complete via WP Cron","2026-01-26 11:12:30","2026-01-26 11:12:30"),
("96","47","action created","2026-01-26 11:22:22","2026-01-26 11:22:22"),
("97","48","ενέργεια δημιουργήθηκε","2026-01-26 11:22:30","2026-01-26 11:22:30"),
("98","47","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-26 11:23:28","2026-01-26 11:23:28"),
("99","47","ενέργεια απέτυχε μέσω WP Cron: Η προγραμματισμένη ενέργεια για το rocket_preload_job_check_finished δεν θα εκτελεστεί καθώς δεν έχουν δηλωθεί κάποια callbacks.","2026-01-26 11:23:28","2026-01-26 11:23:28"),
("100","48","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-26 11:24:26","2026-01-26 11:24:26"),
("101","48","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-26 11:24:26","2026-01-26 11:24:26"),
("102","49","ενέργεια δημιουργήθηκε","2026-01-26 12:04:30","2026-01-26 12:04:30"),
("103","49","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-26 12:05:33","2026-01-26 12:05:33"),
("104","49","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-26 12:05:33","2026-01-26 12:05:33"),
("105","46","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-26 12:14:24","2026-01-26 12:14:24"),
("106","50","ενέργεια δημιουργήθηκε","2026-01-26 12:14:24","2026-01-26 12:14:24"),
("107","46","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-26 12:14:24","2026-01-26 12:14:24"),
("177","74","action created","2026-01-26 12:39:55","2026-01-26 12:39:55"),
("178","75","ενέργεια δημιουργήθηκε","2026-01-26 12:40:01","2026-01-26 12:40:01"),
("179","74","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-26 12:41:15","2026-01-26 12:41:15"),
("180","74","ενέργεια απέτυχε μέσω Async Request: Η προγραμματισμένη ενέργεια για το rocket_preload_job_check_finished δεν θα εκτελεστεί καθώς δεν έχουν δηλωθεί κάποια callbacks.","2026-01-26 12:41:15","2026-01-26 12:41:15"),
("181","75","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-26 12:41:15","2026-01-26 12:41:15"),
("182","75","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-26 12:41:15","2026-01-26 12:41:15"),
("183","50","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-26 13:15:22","2026-01-26 13:15:22"),
("184","76","ενέργεια δημιουργήθηκε","2026-01-26 13:15:22","2026-01-26 13:15:22"),
("185","50","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-26 13:15:22","2026-01-26 13:15:22"),
("186","76","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-26 14:15:23","2026-01-26 14:15:23"),
("187","77","ενέργεια δημιουργήθηκε","2026-01-26 14:15:23","2026-01-26 14:15:23"),
("188","76","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-26 14:15:23","2026-01-26 14:15:23"),
("189","77","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-26 15:15:24","2026-01-26 15:15:24"),
("190","78","ενέργεια δημιουργήθηκε","2026-01-26 15:15:24","2026-01-26 15:15:24"),
("191","77","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-26 15:15:24","2026-01-26 15:15:24"),
("192","78","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-26 16:15:24","2026-01-26 16:15:24"),
("193","79","ενέργεια δημιουργήθηκε","2026-01-26 16:15:24","2026-01-26 16:15:24"),
("194","78","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-26 16:15:24","2026-01-26 16:15:24"),
("195","79","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-26 17:15:25","2026-01-26 17:15:25"),
("196","80","ενέργεια δημιουργήθηκε","2026-01-26 17:15:25","2026-01-26 17:15:25"),
("197","79","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-26 17:15:25","2026-01-26 17:15:25"),
("198","80","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-26 18:15:26","2026-01-26 18:15:26"),
("199","81","ενέργεια δημιουργήθηκε","2026-01-26 18:15:26","2026-01-26 18:15:26"),
("200","80","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-26 18:15:26","2026-01-26 18:15:26"),
("201","81","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-26 19:15:27","2026-01-26 19:15:27"),
("202","82","ενέργεια δημιουργήθηκε","2026-01-26 19:15:27","2026-01-26 19:15:27"),
("203","81","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-26 19:15:27","2026-01-26 19:15:27"),
("204","82","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-26 20:15:27","2026-01-26 20:15:27"),
("205","83","ενέργεια δημιουργήθηκε","2026-01-26 20:15:27","2026-01-26 20:15:27"),
("206","82","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-26 20:15:27","2026-01-26 20:15:27"),
("207","18","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-26 21:11:28","2026-01-26 21:11:28"),
("208","18","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-26 21:11:28","2026-01-26 21:11:28"),
("209","84","ενέργεια δημιουργήθηκε","2026-01-26 21:11:28","2026-01-26 21:11:28"),
("210","83","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-26 21:15:28","2026-01-26 21:15:28"),
("211","85","ενέργεια δημιουργήθηκε","2026-01-26 21:15:28","2026-01-26 21:15:28"),
("212","83","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-26 21:15:28","2026-01-26 21:15:28"),
("213","85","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-26 22:15:29","2026-01-26 22:15:29"),
("214","86","ενέργεια δημιουργήθηκε","2026-01-26 22:15:29","2026-01-26 22:15:29"),
("215","85","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-26 22:15:29","2026-01-26 22:15:29"),
("216","86","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-26 23:15:29","2026-01-26 23:15:29"),
("217","87","ενέργεια δημιουργήθηκε","2026-01-26 23:15:29","2026-01-26 23:15:29"),
("218","86","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-26 23:15:29","2026-01-26 23:15:29"),
("219","9","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 00:00:30","2026-01-27 00:00:30"),
("220","9","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 00:00:30","2026-01-27 00:00:30"),
("221","88","ενέργεια δημιουργήθηκε","2026-01-27 00:00:30","2026-01-27 00:00:30"),
("222","87","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 00:15:30","2026-01-27 00:15:30"),
("223","89","ενέργεια δημιουργήθηκε","2026-01-27 00:15:30","2026-01-27 00:15:30"),
("224","87","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 00:15:30","2026-01-27 00:15:30"),
("225","89","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 01:15:31","2026-01-27 01:15:31"),
("226","90","ενέργεια δημιουργήθηκε","2026-01-27 01:15:31","2026-01-27 01:15:31"),
("227","89","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 01:15:31","2026-01-27 01:15:31"),
("228","90","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 02:15:31","2026-01-27 02:15:31"),
("229","91","ενέργεια δημιουργήθηκε","2026-01-27 02:15:31","2026-01-27 02:15:31"),
("230","90","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 02:15:31","2026-01-27 02:15:31"),
("231","12","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 03:00:32","2026-01-27 03:00:32"),
("232","12","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-27 03:00:32","2026-01-27 03:00:32"),
("233","92","ενέργεια δημιουργήθηκε","2026-01-27 03:00:32","2026-01-27 03:00:32"),
("234","15","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 03:00:32","2026-01-27 03:00:32"),
("235","15","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-27 03:00:32","2026-01-27 03:00:32"),
("236","93","ενέργεια δημιουργήθηκε","2026-01-27 03:00:32","2026-01-27 03:00:32"),
("237","91","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 03:15:32","2026-01-27 03:15:32"),
("238","94","ενέργεια δημιουργήθηκε","2026-01-27 03:15:32","2026-01-27 03:15:32"),
("239","91","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 03:15:32","2026-01-27 03:15:32"),
("240","94","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 04:15:33","2026-01-27 04:15:33"),
("241","95","ενέργεια δημιουργήθηκε","2026-01-27 04:15:33","2026-01-27 04:15:33"),
("242","94","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 04:15:33","2026-01-27 04:15:33"),
("243","95","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 05:15:34","2026-01-27 05:15:34"),
("244","96","ενέργεια δημιουργήθηκε","2026-01-27 05:15:34","2026-01-27 05:15:34"),
("245","95","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 05:15:34","2026-01-27 05:15:34"),
("246","13","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 06:00:34","2026-01-27 06:00:34"),
("247","13","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-27 06:00:34","2026-01-27 06:00:34"),
("249","14","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 06:00:34","2026-01-27 06:00:34"),
("250","14","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-27 06:00:34","2026-01-27 06:00:34"),
("251","98","ενέργεια δημιουργήθηκε","2026-01-27 06:00:34","2026-01-27 06:00:34"),
("252","96","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 06:15:34","2026-01-27 06:15:34"),
("253","99","ενέργεια δημιουργήθηκε","2026-01-27 06:15:34","2026-01-27 06:15:34"),
("254","96","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-27 06:15:34","2026-01-27 06:15:34"),
("255","99","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 07:15:35","2026-01-27 07:15:35"),
("256","100","ενέργεια δημιουργήθηκε","2026-01-27 07:15:35","2026-01-27 07:15:35"),
("257","99","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-27 07:15:35","2026-01-27 07:15:35"),
("258","101","ενέργεια δημιουργήθηκε","2026-01-27 07:56:31","2026-01-27 07:56:31"),
("259","101","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 07:57:34","2026-01-27 07:57:34"),
("260","101","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 07:57:34","2026-01-27 07:57:34"),
("261","102","ενέργεια δημιουργήθηκε","2026-01-27 07:58:40","2026-01-27 07:58:40"),
("262","102","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 07:59:54","2026-01-27 07:59:54"),
("263","102","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-27 07:59:54","2026-01-27 07:59:54"),
("264","103","ενέργεια δημιουργήθηκε","2026-01-27 08:03:29","2026-01-27 08:03:29"),
("265","103","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 08:03:39","2026-01-27 08:03:39"),
("266","103","ενέργεια απέτυχε μέσω Async Request: Η προγραμματισμένη ενέργεια για το woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications δεν θα εκτελεστεί καθώς δεν έχουν δηλωθεί κάποια callbacks.","2026-01-27 08:03:39","2026-01-27 08:03:39"),
("267","100","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 08:16:31","2026-01-27 08:16:31"),
("268","104","ενέργεια δημιουργήθηκε","2026-01-27 08:16:31","2026-01-27 08:16:31"),
("269","100","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-27 08:16:31","2026-01-27 08:16:31"),
("270","21","action started via WP Cron","2026-01-27 09:11:33","2026-01-27 09:11:33"),
("271","21","action complete via WP Cron","2026-01-27 09:11:33","2026-01-27 09:11:33"),
("272","105","action created","2026-01-27 09:11:33","2026-01-27 09:11:33"),
("273","22","action started via WP Cron","2026-01-27 09:11:33","2026-01-27 09:11:33"),
("274","22","action complete via WP Cron","2026-01-27 09:11:33","2026-01-27 09:11:33"),
("275","106","action created","2026-01-27 09:11:33","2026-01-27 09:11:33"),
("276","84","action started via WP Cron","2026-01-27 09:11:33","2026-01-27 09:11:33"),
("277","84","action complete via WP Cron","2026-01-27 09:11:33","2026-01-27 09:11:33"),
("278","107","action created","2026-01-27 09:11:33","2026-01-27 09:11:33"),
("279","19","action started via WP Cron","2026-01-27 09:11:33","2026-01-27 09:11:33"),
("281","108","action created","2026-01-27 09:11:33","2026-01-27 09:11:33"),
("282","109","action created","2026-01-27 09:11:33","2026-01-27 09:11:33"),
("283","19","action complete via WP Cron","2026-01-27 09:11:33","2026-01-27 09:11:33"),
("284","110","action created","2026-01-27 09:11:33","2026-01-27 09:11:33"),
("285","109","action started via Async Request","2026-01-27 09:12:10","2026-01-27 09:12:10"),
("286","109","action complete via Async Request","2026-01-27 09:12:10","2026-01-27 09:12:10"),
("287","23","action started via Async Request","2026-01-27 09:13:28","2026-01-27 09:13:28"),
("288","23","action complete via Async Request","2026-01-27 09:13:29","2026-01-27 09:13:29"),
("289","111","action created","2026-01-27 09:13:29","2026-01-27 09:13:29"),
("290","104","action started via WP Cron","2026-01-27 09:16:34","2026-01-27 09:16:34"),
("291","112","action created","2026-01-27 09:16:34","2026-01-27 09:16:34"),
("292","104","action complete via WP Cron","2026-01-27 09:16:34","2026-01-27 09:16:34"),
("293","113","action created","2026-01-27 09:22:43","2026-01-27 09:22:43"),
("296","113","action started via Async Request","2026-01-27 09:24:12","2026-01-27 09:24:12"),
("297","113","action complete via Async Request","2026-01-27 09:24:12","2026-01-27 09:24:12"),
("328","125","action created","2026-01-27 09:25:04","2026-01-27 09:25:04"),
("366","138","action created","2026-01-27 09:26:08","2026-01-27 09:26:08"),
("367","125","action started via Async Request","2026-01-27 09:26:27","2026-01-27 09:26:27"),
("368","125","action failed via Async Request: Scheduled action for rocket_preload_job_check_finished will not be executed as no callbacks are registered.","2026-01-27 09:26:27","2026-01-27 09:26:27"),
("369","138","action started via WP Cron","2026-01-27 09:27:40","2026-01-27 09:27:40"),
("370","138","action complete via WP Cron","2026-01-27 09:27:40","2026-01-27 09:27:40"),
("446","112","action started via WP Cron","2026-01-27 10:16:56","2026-01-27 10:16:56"),
("447","164","action created","2026-01-27 10:16:56","2026-01-27 10:16:56"),
("448","112","action complete via WP Cron","2026-01-27 10:16:56","2026-01-27 10:16:56"),
("449","165","ενέργεια δημιουργήθηκε","2026-01-27 10:31:18","2026-01-27 10:31:18"),
("450","165","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 10:33:25","2026-01-27 10:33:25"),
("451","165","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-27 10:33:25","2026-01-27 10:33:25"),
("452","166","action created","2026-01-27 10:49:16","2026-01-27 10:49:16"),
("454","168","ενέργεια δημιουργήθηκε","2026-01-27 10:57:22","2026-01-27 10:57:22"),
("455","168","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 11:04:25","2026-01-27 11:04:25"),
("456","168","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-27 11:04:25","2026-01-27 11:04:25"),
("458","164","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 11:17:54","2026-01-27 11:17:54"),
("459","170","ενέργεια δημιουργήθηκε","2026-01-27 11:17:54","2026-01-27 11:17:54"),
("460","164","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-27 11:17:54","2026-01-27 11:17:54"),
("461","171","ενέργεια δημιουργήθηκε","2026-01-27 11:45:36","2026-01-27 11:45:36"),
("462","171","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 11:46:40","2026-01-27 11:46:40"),
("463","171","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-27 11:46:40","2026-01-27 11:46:40"),
("464","172","ενέργεια δημιουργήθηκε","2026-01-27 11:46:47","2026-01-27 11:46:47"),
("465","172","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 11:47:50","2026-01-27 11:47:50"),
("466","172","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-27 11:47:50","2026-01-27 11:47:50"),
("508","186","ενέργεια δημιουργήθηκε","2026-01-27 12:04:41","2026-01-27 12:04:41"),
("509","186","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 12:07:08","2026-01-27 12:07:08"),
("510","186","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-27 12:07:08","2026-01-27 12:07:08"),
("511","170","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 12:34:38","2026-01-27 12:34:38"),
("512","187","ενέργεια δημιουργήθηκε","2026-01-27 12:34:38","2026-01-27 12:34:38"),
("513","170","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 12:34:38","2026-01-27 12:34:38"),
("514","187","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 13:34:38","2026-01-27 13:34:38"),
("515","188","ενέργεια δημιουργήθηκε","2026-01-27 13:34:38","2026-01-27 13:34:38"),
("516","187","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 13:34:38","2026-01-27 13:34:38"),
("517","188","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 14:34:39","2026-01-27 14:34:39"),
("518","189","ενέργεια δημιουργήθηκε","2026-01-27 14:34:39","2026-01-27 14:34:39"),
("519","188","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 14:34:39","2026-01-27 14:34:39"),
("520","189","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 15:34:39","2026-01-27 15:34:39"),
("521","190","ενέργεια δημιουργήθηκε","2026-01-27 15:34:39","2026-01-27 15:34:39"),
("522","189","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 15:34:39","2026-01-27 15:34:39"),
("523","190","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 16:34:39","2026-01-27 16:34:39"),
("524","191","ενέργεια δημιουργήθηκε","2026-01-27 16:34:39","2026-01-27 16:34:39"),
("525","190","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 16:34:39","2026-01-27 16:34:39"),
("526","191","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 18:04:40","2026-01-27 18:04:40"),
("527","192","ενέργεια δημιουργήθηκε","2026-01-27 18:04:40","2026-01-27 18:04:40"),
("528","191","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 18:04:40","2026-01-27 18:04:40"),
("529","193","ενέργεια δημιουργήθηκε","2026-01-27 19:05:30","2026-01-27 19:05:30"),
("530","192","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 19:05:30","2026-01-27 19:05:30"),
("531","194","ενέργεια δημιουργήθηκε","2026-01-27 19:05:30","2026-01-27 19:05:30"),
("532","192","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-27 19:05:30","2026-01-27 19:05:30"),
("533","193","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 19:06:36","2026-01-27 19:06:36"),
("534","193","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-27 19:06:36","2026-01-27 19:06:36"),
("535","195","ενέργεια δημιουργήθηκε","2026-01-27 19:06:36","2026-01-27 19:06:36"),
("536","195","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-27 19:07:37","2026-01-27 19:07:37"),
("537","195","ενέργεια απέτυχε μέσω Async Request: Η προγραμματισμένη ενέργεια για το action_scheduler/migration_hook δεν θα εκτελεστεί καθώς δεν έχουν δηλωθεί κάποια callbacks.","2026-01-27 19:07:37","2026-01-27 19:07:37"),
("538","194","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 20:34:40","2026-01-27 20:34:40"),
("539","196","ενέργεια δημιουργήθηκε","2026-01-27 20:34:40","2026-01-27 20:34:40"),
("540","194","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 20:34:40","2026-01-27 20:34:40"),
("541","107","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 21:34:40","2026-01-27 21:34:40"),
("542","107","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 21:34:40","2026-01-27 21:34:40"),
("543","197","ενέργεια δημιουργήθηκε","2026-01-27 21:34:40","2026-01-27 21:34:40"),
("544","196","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 21:34:40","2026-01-27 21:34:40"),
("545","198","ενέργεια δημιουργήθηκε","2026-01-27 21:34:40","2026-01-27 21:34:40"),
("546","196","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 21:34:40","2026-01-27 21:34:40"),
("547","198","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 22:34:40","2026-01-27 22:34:40"),
("548","199","ενέργεια δημιουργήθηκε","2026-01-27 22:34:40","2026-01-27 22:34:40"),
("549","198","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 22:34:40","2026-01-27 22:34:40"),
("550","199","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-27 23:34:41","2026-01-27 23:34:41"),
("551","200","ενέργεια δημιουργήθηκε","2026-01-27 23:34:41","2026-01-27 23:34:41"),
("552","199","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-27 23:34:41","2026-01-27 23:34:41"),
("553","166","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-28 00:04:41","2026-01-28 00:04:41"),
("554","166","ενέργεια απέτυχε μέσω WP Cron: Η προγραμματισμένη ενέργεια για το rank_math/analytics/email_report_event δεν θα εκτελεστεί καθώς δεν έχουν δηλωθεί κάποια callbacks.","2026-01-28 00:04:41","2026-01-28 00:04:41"),
("555","201","ενέργεια δημιουργήθηκε","2026-01-28 00:04:41","2026-01-28 00:04:41"),
("556","88","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-28 00:04:41","2026-01-28 00:04:41"),
("557","88","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-28 00:04:41","2026-01-28 00:04:41"),
("558","202","ενέργεια δημιουργήθηκε","2026-01-28 00:04:41","2026-01-28 00:04:41"),
("559","200","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-28 00:34:41","2026-01-28 00:34:41"),
("560","203","ενέργεια δημιουργήθηκε","2026-01-28 00:34:41","2026-01-28 00:34:41"),
("561","200","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-28 00:34:41","2026-01-28 00:34:41"),
("562","203","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-28 01:34:41","2026-01-28 01:34:41"),
("563","204","ενέργεια δημιουργήθηκε","2026-01-28 01:34:41","2026-01-28 01:34:41"),
("564","203","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-28 01:34:41","2026-01-28 01:34:41"),
("565","204","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-28 02:34:42","2026-01-28 02:34:42"),
("566","205","ενέργεια δημιουργήθηκε","2026-01-28 02:34:42","2026-01-28 02:34:42"),
("567","204","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-28 02:34:42","2026-01-28 02:34:42"),
("568","108","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-28 03:04:41","2026-01-28 03:04:41"),
("569","108","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-28 03:04:41","2026-01-28 03:04:41"),
("571","92","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-28 03:04:41","2026-01-28 03:04:41"),
("572","92","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-28 03:04:41","2026-01-28 03:04:41"),
("573","207","ενέργεια δημιουργήθηκε","2026-01-28 03:04:41","2026-01-28 03:04:41"),
("574","93","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-28 03:04:41","2026-01-28 03:04:41"),
("575","93","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-28 03:04:41","2026-01-28 03:04:41"),
("576","208","ενέργεια δημιουργήθηκε","2026-01-28 03:04:41","2026-01-28 03:04:41"),
("577","205","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-28 03:34:42","2026-01-28 03:34:42"),
("578","209","ενέργεια δημιουργήθηκε","2026-01-28 03:34:42","2026-01-28 03:34:42"),
("579","205","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-28 03:34:42","2026-01-28 03:34:42"),
("580","209","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-28 04:34:42","2026-01-28 04:34:42"),
("581","210","ενέργεια δημιουργήθηκε","2026-01-28 04:34:42","2026-01-28 04:34:42"),
("582","209","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-28 04:34:42","2026-01-28 04:34:42"),
("583","210","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-28 05:34:42","2026-01-28 05:34:42"),
("584","211","ενέργεια δημιουργήθηκε","2026-01-28 05:34:42","2026-01-28 05:34:42"),
("585","210","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-28 05:34:42","2026-01-28 05:34:42"),
("586","212","ενέργεια δημιουργήθηκε","2026-01-28 06:18:24","2026-01-28 06:18:24"),
("587","212","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-28 06:19:31","2026-01-28 06:19:31"),
("588","212","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-28 06:19:31","2026-01-28 06:19:31"),
("589","213","ενέργεια δημιουργήθηκε","2026-01-28 06:19:31","2026-01-28 06:19:31"),
("590","213","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 06:20:59","2026-01-28 06:20:59"),
("591","213","ενέργεια απέτυχε μέσω Async Request: Η προγραμματισμένη ενέργεια για το action_scheduler/migration_hook δεν θα εκτελεστεί καθώς δεν έχουν δηλωθεί κάποια callbacks.","2026-01-28 06:20:59","2026-01-28 06:20:59"),
("592","211","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 06:35:09","2026-01-28 06:35:09"),
("593","214","ενέργεια δημιουργήθηκε","2026-01-28 06:35:09","2026-01-28 06:35:09"),
("594","211","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 06:35:09","2026-01-28 06:35:09"),
("595","215","ενέργεια δημιουργήθηκε","2026-01-28 06:35:40","2026-01-28 06:35:40"),
("596","215","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 06:37:19","2026-01-28 06:37:19"),
("597","215","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 06:37:19","2026-01-28 06:37:19"),
("598","216","ενέργεια δημιουργήθηκε","2026-01-28 07:20:48","2026-01-28 07:20:48"),
("599","216","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-28 07:22:28","2026-01-28 07:22:28"),
("600","216","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-28 07:22:28","2026-01-28 07:22:28"),
("601","214","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-28 07:35:31","2026-01-28 07:35:31"),
("602","217","ενέργεια δημιουργήθηκε","2026-01-28 07:35:31","2026-01-28 07:35:31"),
("603","214","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-28 07:35:31","2026-01-28 07:35:31"),
("604","218","ενέργεια δημιουργήθηκε","2026-01-28 07:53:29","2026-01-28 07:53:29"),
("605","218","η ενέργεια ξεκίνησε μέσω WP Cron","2026-01-28 07:54:33","2026-01-28 07:54:33"),
("606","218","η ενέργεια ολοκληρώθηκε μέσω WP Cron","2026-01-28 07:54:33","2026-01-28 07:54:33"),
("607","219","ενέργεια δημιουργήθηκε","2026-01-28 07:54:33","2026-01-28 07:54:33"),
("608","219","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 07:56:26","2026-01-28 07:56:26"),
("609","219","ενέργεια απέτυχε μέσω Async Request: Η προγραμματισμένη ενέργεια για το action_scheduler/migration_hook δεν θα εκτελεστεί καθώς δεν έχουν δηλωθεί κάποια callbacks.","2026-01-28 07:56:26","2026-01-28 07:56:26"),
("610","220","ενέργεια δημιουργήθηκε","2026-01-28 08:07:19","2026-01-28 08:07:19"),
("611","220","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 08:08:23","2026-01-28 08:08:23"),
("612","220","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 08:08:23","2026-01-28 08:08:23"),
("613","217","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 08:35:34","2026-01-28 08:35:34"),
("614","221","ενέργεια δημιουργήθηκε","2026-01-28 08:35:34","2026-01-28 08:35:34"),
("615","217","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 08:35:34","2026-01-28 08:35:34"),
("616","222","ενέργεια δημιουργήθηκε","2026-01-28 08:56:04","2026-01-28 08:56:04"),
("617","222","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 08:57:43","2026-01-28 08:57:43"),
("618","222","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 08:57:43","2026-01-28 08:57:43"),
("619","223","ενέργεια δημιουργήθηκε","2026-01-28 08:59:04","2026-01-28 08:59:04"),
("621","225","action created","2026-01-28 08:59:06","2026-01-28 08:59:06"),
("622","223","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 08:59:47","2026-01-28 08:59:47"),
("623","226","ενέργεια δημιουργήθηκε","2026-01-28 08:59:47","2026-01-28 08:59:47"),
("624","223","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 08:59:47","2026-01-28 08:59:47"),
("625","226","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 08:59:47","2026-01-28 08:59:47"),
("626","226","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 08:59:47","2026-01-28 08:59:47"),
("627","227","action created","2026-01-28 09:00:10","2026-01-28 09:00:10"),
("628","228","ενέργεια δημιουργήθηκε","2026-01-28 09:01:47","2026-01-28 09:01:47"),
("629","225","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:01:47","2026-01-28 09:01:47"),
("630","225","ενέργεια απέτυχε μέσω Async Request: Η προγραμματισμένη ενέργεια για το wp_mail_smtp_admin_notifications_update δεν θα εκτελεστεί καθώς δεν έχουν δηλωθεί κάποια callbacks.","2026-01-28 09:01:47","2026-01-28 09:01:47"),
("632","227","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:01:47","2026-01-28 09:01:47"),
("633","230","action created","2026-01-28 09:01:48","2026-01-28 09:01:48"),
("634","227","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:01:48","2026-01-28 09:01:48"),
("635","230","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:01:48","2026-01-28 09:01:48"),
("636","230","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:01:49","2026-01-28 09:01:49"),
("637","228","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:04:34","2026-01-28 09:04:34"),
("638","228","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:04:34","2026-01-28 09:04:34"),
("639","231","ενέργεια δημιουργήθηκε","2026-01-28 09:04:38","2026-01-28 09:04:38"),
("640","231","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:07:03","2026-01-28 09:07:03"),
("641","231","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:07:03","2026-01-28 09:07:03"),
("642","232","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("643","233","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("644","234","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("645","235","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("646","236","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("647","237","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("648","238","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("649","239","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("650","240","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("651","241","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("652","242","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("653","243","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("654","244","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("655","245","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("656","246","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("657","247","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("658","248","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("659","249","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("660","250","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("661","251","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("662","252","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("663","253","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("664","254","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("665","255","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("666","256","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("667","257","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("668","258","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("669","259","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("670","260","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("671","261","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("672","262","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("673","263","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("674","264","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("675","265","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("676","266","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("677","267","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("678","268","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("679","269","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("680","270","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("681","271","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("682","272","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("683","273","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("684","274","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("685","275","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("686","276","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("687","277","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("688","278","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("689","279","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("690","280","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("691","281","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("692","282","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("693","283","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("694","284","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("695","285","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("696","286","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("697","287","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("698","288","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("699","289","ενέργεια δημιουργήθηκε","2026-01-28 09:09:46","2026-01-28 09:09:46"),
("700","290","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("701","291","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("702","292","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("703","293","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("704","294","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("705","295","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("706","296","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("707","297","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("708","298","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("709","299","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("710","300","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("711","301","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("712","302","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("713","303","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("714","304","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("715","305","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("716","306","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("717","307","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("718","308","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("719","309","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("720","310","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("721","311","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("722","312","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("723","313","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("724","314","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("725","315","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("726","316","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("727","317","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("728","318","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("729","319","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("730","320","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("731","321","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("732","322","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("733","323","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("734","324","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("735","325","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("736","326","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("737","327","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("738","328","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("739","329","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("740","330","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("741","331","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("742","332","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("743","333","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("744","334","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("745","335","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("746","336","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("747","337","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("748","338","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("749","339","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("750","340","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("751","341","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("752","342","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("753","343","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("754","344","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("755","345","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("756","346","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("757","347","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("758","348","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("759","349","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("760","350","ενέργεια δημιουργήθηκε","2026-01-28 09:09:47","2026-01-28 09:09:47"),
("761","351","ενέργεια δημιουργήθηκε","2026-01-28 09:09:48","2026-01-28 09:09:48"),
("762","352","ενέργεια δημιουργήθηκε","2026-01-28 09:09:48","2026-01-28 09:09:48"),
("763","353","ενέργεια δημιουργήθηκε","2026-01-28 09:09:48","2026-01-28 09:09:48"),
("764","354","ενέργεια δημιουργήθηκε","2026-01-28 09:09:48","2026-01-28 09:09:48"),
("765","355","ενέργεια δημιουργήθηκε","2026-01-28 09:09:48","2026-01-28 09:09:48"),
("766","356","ενέργεια δημιουργήθηκε","2026-01-28 09:09:48","2026-01-28 09:09:48"),
("767","232","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("768","232","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("769","233","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("770","233","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("771","234","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("772","234","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("773","235","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("774","235","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("775","236","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("776","236","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("777","237","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("778","237","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("779","238","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("780","238","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("781","239","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("782","239","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("783","240","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("784","240","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("785","241","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("786","241","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("787","242","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("788","242","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("789","243","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("790","243","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("791","244","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("792","244","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("793","245","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("794","245","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("795","246","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("796","246","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("797","247","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("798","247","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("799","248","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("800","248","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("801","249","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("802","249","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("803","250","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("804","250","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("805","251","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("806","251","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("807","252","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("808","252","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("809","253","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("810","253","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("811","254","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("812","254","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("813","255","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("814","255","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("815","256","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("816","256","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("817","257","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("818","257","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("819","258","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("820","258","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("821","259","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("822","259","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("823","260","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("824","260","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("825","261","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("826","261","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("827","262","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("828","262","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("829","263","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("830","263","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("831","264","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("832","264","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("833","265","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("834","265","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("835","266","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("836","266","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("837","267","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("838","267","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("839","268","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("840","268","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("841","269","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("842","269","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("843","270","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("844","270","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("845","271","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("846","271","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("847","272","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("848","272","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("849","273","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("850","273","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("851","274","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("852","274","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("853","275","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("854","275","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("855","276","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("856","276","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("857","277","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("858","277","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("859","278","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("860","278","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("861","279","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("862","279","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("863","280","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("864","280","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("865","281","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("866","281","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("867","282","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("868","282","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("869","283","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("870","283","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("871","284","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("872","284","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("873","285","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("874","285","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("875","286","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("876","286","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("877","287","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("878","287","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("879","288","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("880","288","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("881","289","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("882","289","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("883","290","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("884","290","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("885","291","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("886","291","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("887","292","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("888","292","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("889","293","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("890","293","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("891","294","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("892","294","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("893","295","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("894","295","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("895","296","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("896","296","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("897","297","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("898","297","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("899","298","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("900","298","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("901","299","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("902","299","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("903","300","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("904","300","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("905","301","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("906","301","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("907","302","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("908","302","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("909","303","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("910","303","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("911","304","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("912","304","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("913","305","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("914","305","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("915","306","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("916","306","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("917","307","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("918","307","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("919","308","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("920","308","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("921","309","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("922","309","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("923","310","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("924","310","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("925","311","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("926","311","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("927","312","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("928","312","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("929","313","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("930","313","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("931","314","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("932","314","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("933","315","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("934","315","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("935","316","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("936","316","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("937","317","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("938","317","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("939","318","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("940","318","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("941","319","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("942","319","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("943","320","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("944","320","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("945","321","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("946","321","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("947","322","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("948","322","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("949","323","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("950","323","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("951","324","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("952","324","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("953","325","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("954","325","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("955","326","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("956","326","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("957","327","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("958","327","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("959","328","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("960","328","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("961","329","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("962","329","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("963","330","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("964","330","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("965","331","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("966","331","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("967","332","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("968","332","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("969","333","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("970","333","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("971","334","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("972","334","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("973","335","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("974","335","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("975","336","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("976","336","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("977","337","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("978","337","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("979","338","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("980","338","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("981","339","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("982","339","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("983","340","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("984","340","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("985","341","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("986","341","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("987","342","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("988","342","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("989","343","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("990","343","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("991","344","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("992","344","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("993","345","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("994","345","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("995","346","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("996","346","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("997","347","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("998","347","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("999","348","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1000","348","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1001","349","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1002","349","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1003","350","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1004","350","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1005","351","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1006","351","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1007","352","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1008","352","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1009","353","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1010","353","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1011","354","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1012","354","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1013","355","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1014","355","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1015","356","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1016","356","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:10:18","2026-01-28 09:10:18"),
("1017","357","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1018","358","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1019","359","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1020","360","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1021","361","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1022","362","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1023","363","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1024","364","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1025","365","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1026","366","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1027","367","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1028","368","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1029","369","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1030","370","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1031","371","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1032","372","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1033","373","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1034","374","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1035","375","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1036","376","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1037","377","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1038","378","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1039","379","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1040","380","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1041","381","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1042","382","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1043","383","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1044","384","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1045","385","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1046","386","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1047","387","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1048","388","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1049","389","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1050","390","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1051","391","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1052","392","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1053","393","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1054","394","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1055","395","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1056","396","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1057","397","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1058","398","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1059","399","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1060","400","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1061","401","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1062","402","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1063","403","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1064","404","ενέργεια δημιουργήθηκε","2026-01-28 09:11:12","2026-01-28 09:11:12"),
("1065","405","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1066","406","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1067","407","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1068","408","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1069","409","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1070","410","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1071","411","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1072","412","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1073","413","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1074","414","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1075","415","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1076","416","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1077","417","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1078","418","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1079","419","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1080","420","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1081","421","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1082","422","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1083","423","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1084","424","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1085","425","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1086","426","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1087","427","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1088","428","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1089","429","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1090","430","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1091","431","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1092","432","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1093","433","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1094","434","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1095","435","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1096","436","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1097","437","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1098","438","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1099","439","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1100","440","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1101","441","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1102","442","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1103","443","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1104","444","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1105","445","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1106","446","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1107","447","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1108","448","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1109","449","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1110","450","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1111","451","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1112","452","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1113","453","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1114","454","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1115","455","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1116","456","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1117","457","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1118","458","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1119","459","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1120","460","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1121","461","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1122","462","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1123","463","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1124","464","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1125","465","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1126","466","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1127","467","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1128","468","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1129","469","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1130","470","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1131","471","ενέργεια δημιουργήθηκε","2026-01-28 09:11:13","2026-01-28 09:11:13"),
("1132","472","ενέργεια δημιουργήθηκε","2026-01-28 09:11:14","2026-01-28 09:11:14"),
("1133","473","ενέργεια δημιουργήθηκε","2026-01-28 09:11:14","2026-01-28 09:11:14"),
("1134","474","ενέργεια δημιουργήθηκε","2026-01-28 09:11:14","2026-01-28 09:11:14"),
("1135","475","ενέργεια δημιουργήθηκε","2026-01-28 09:11:14","2026-01-28 09:11:14"),
("1136","476","ενέργεια δημιουργήθηκε","2026-01-28 09:11:14","2026-01-28 09:11:14"),
("1137","477","ενέργεια δημιουργήθηκε","2026-01-28 09:11:14","2026-01-28 09:11:14"),
("1138","478","ενέργεια δημιουργήθηκε","2026-01-28 09:11:14","2026-01-28 09:11:14"),
("1139","479","ενέργεια δημιουργήθηκε","2026-01-28 09:11:14","2026-01-28 09:11:14"),
("1140","480","ενέργεια δημιουργήθηκε","2026-01-28 09:11:14","2026-01-28 09:11:14"),
("1141","357","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1142","357","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1143","358","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1144","358","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1145","359","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1146","359","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1147","360","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1148","360","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1149","361","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1150","361","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1151","362","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1152","362","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1153","363","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1154","363","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1155","364","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1156","364","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1157","365","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1158","365","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1159","366","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1160","366","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1161","367","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1162","367","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1163","368","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1164","368","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1165","369","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1166","369","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1167","370","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1168","370","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1169","371","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1170","371","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1171","372","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1172","372","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1173","373","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1174","373","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1175","374","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1176","374","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1177","375","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1178","375","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1179","376","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1180","376","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1181","377","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1182","377","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1183","378","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1184","378","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1185","379","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1186","379","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1187","380","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1188","380","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1189","381","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1190","381","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1191","382","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1192","382","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1193","383","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1194","383","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1195","384","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1196","384","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1197","385","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1198","385","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1199","386","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1200","386","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1201","387","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1202","387","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1203","388","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1204","388","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1205","389","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1206","389","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1207","390","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1208","390","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1209","391","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1210","391","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1211","392","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1212","392","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1213","393","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1214","393","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1215","394","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1216","394","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1217","395","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1218","395","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1219","396","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1220","396","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1221","397","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1222","397","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1223","398","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1224","398","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1225","399","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1226","399","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1227","400","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1228","400","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1229","401","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1230","401","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1231","402","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1232","402","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1233","403","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1234","403","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1235","404","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1236","404","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1237","405","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1238","405","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1239","406","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1240","406","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1241","407","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1242","407","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1243","408","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1244","408","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1245","409","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1246","409","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1247","410","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1248","410","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1249","411","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1250","411","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1251","412","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1252","412","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1253","413","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1254","413","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1255","414","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1256","414","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1257","415","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1258","415","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1259","416","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1260","416","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1261","417","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1262","417","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1263","418","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1264","418","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1265","419","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1266","419","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1267","420","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1268","420","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1269","421","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1270","421","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1271","422","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1272","422","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1273","423","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1274","423","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1275","424","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1276","424","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1277","425","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1278","425","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1279","426","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1280","426","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1281","427","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1282","427","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1283","428","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1284","428","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1285","429","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1286","429","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1287","430","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1288","430","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1289","431","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1290","431","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1291","432","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1292","432","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1293","433","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1294","433","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1295","434","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1296","434","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1297","435","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1298","435","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1299","436","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1300","436","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1301","437","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1302","437","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1303","438","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1304","438","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1305","439","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1306","439","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1307","440","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1308","440","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1309","441","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1310","441","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1311","442","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1312","442","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1313","443","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1314","443","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1315","444","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1316","444","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1317","445","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1318","445","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1319","446","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1320","446","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1321","447","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1322","447","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1323","448","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1324","448","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1325","449","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1326","449","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1327","450","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1328","450","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1329","451","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1330","451","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1331","452","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1332","452","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1333","453","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1334","453","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1335","454","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1336","454","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1337","455","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1338","455","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1339","456","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1340","456","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1341","457","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1342","457","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1343","458","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1344","458","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1345","459","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1346","459","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1347","460","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1348","460","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1349","461","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1350","461","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1351","462","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1352","462","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1353","463","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1354","463","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1355","464","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1356","464","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1357","465","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1358","465","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1359","466","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1360","466","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1361","467","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1362","467","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1363","468","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1364","468","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1365","469","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1366","469","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1367","470","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1368","470","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1369","471","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1370","471","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1371","472","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1372","472","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1373","473","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1374","473","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1375","474","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1376","474","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1377","475","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1378","475","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1379","476","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1380","476","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1381","477","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1382","477","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1383","478","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1384","478","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1385","479","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1386","479","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1387","480","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1388","480","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:28","2026-01-28 09:11:28"),
("1389","105","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:34","2026-01-28 09:11:34"),
("1390","105","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:34","2026-01-28 09:11:34"),
("1391","481","ενέργεια δημιουργήθηκε","2026-01-28 09:11:34","2026-01-28 09:11:34"),
("1392","106","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:34","2026-01-28 09:11:34"),
("1393","106","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:34","2026-01-28 09:11:34"),
("1394","482","ενέργεια δημιουργήθηκε","2026-01-28 09:11:34","2026-01-28 09:11:34"),
("1395","110","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:11:34","2026-01-28 09:11:34"),
("1397","483","ενέργεια δημιουργήθηκε","2026-01-28 09:11:34","2026-01-28 09:11:34"),
("1398","484","ενέργεια δημιουργήθηκε","2026-01-28 09:11:34","2026-01-28 09:11:34"),
("1399","110","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:11:34","2026-01-28 09:11:34"),
("1400","485","ενέργεια δημιουργήθηκε","2026-01-28 09:11:34","2026-01-28 09:11:34"),
("1401","484","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:12:38","2026-01-28 09:12:38"),
("1402","484","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:12:38","2026-01-28 09:12:38"),
("1405","486","ενέργεια δημιουργήθηκε","2026-01-28 09:13:10","2026-01-28 09:13:10"),
("1406","111","η ενέργεια ξεκίνησε μέσω Async Request","2026-01-28 09:13:57","2026-01-28 09:13:57"),
("1407","111","η ενέργεια ολοκληρώθηκε μέσω Async Request","2026-01-28 09:13:58","2026-01-28 09:13:58"),
("1408","487","ενέργεια δημιουργήθηκε","2026-01-28 09:13:58","2026-01-28 09:13:58");

INSERT IGNORE INTO `wpby_comments` VALUES 
("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2026-01-26 08:35:07","2026-01-26 08:35:07","Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com/\">Gravatar</a>.","0","1","","comment","0","0");

INSERT IGNORE INTO `wpby_duplicator_activity_logs` VALUES 
("1","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 1,\n    \"packageName\": \"Protipofornewsites\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 0,\n    \"dbSize\": 0,\n    \"dbRowCount\": 0\n}","0","4.5.24.2","2026-01-28 09:13:58","2026-01-28 09:13:58"),
("2","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 1,\n    \"packageName\": \"Protipofornewsites\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 41387,\n    \"dirCount\": 7690,\n    \"size\": 691711793,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 150,\n    \"dbSize\": 19333120,\n    \"dbRowCount\": 10379\n}","1","4.5.24.2","2026-01-28 09:14:00","2026-01-28 09:14:00"),
("3","backup_create","start","10","Backup creation: Protipofornewsites","{\n    \"packageId\": 2,\n    \"packageName\": \"Protipofornewsites\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"Protipofornewsites_6d8b100855fc537b1735_20260128091357\",\n    \"logFileName\": \"Protipofornewsites_6d8b100855fc537b1735_20260128091357_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 41387,\n    \"dirCount\": 7690,\n    \"size\": 691711793,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 150,\n    \"dbSizeDisplay\": \"18.44MB\",\n    \"execution_start_time\": 1769591651.723896026611328125\n}","0","4.5.24.2","2026-01-28 09:14:11","2026-01-28 09:14:11"),
("4","backup_create","db_dump","10","Backup creation: Protipofornewsites - Database Dump","{\n    \"packageId\": 2,\n    \"packageName\": \"Protipofornewsites\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"Protipofornewsites_6d8b100855fc537b1735_20260128091357\",\n    \"logFileName\": \"Protipofornewsites_6d8b100855fc537b1735_20260128091357_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 41387,\n    \"dirCount\": 7690,\n    \"size\": 691711793,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 150,\n    \"dbSizeDisplay\": \"18.44MB\",\n    \"execution_start_time\": 1769591651.723896026611328125\n}","3","4.5.24.2","2026-01-28 09:14:11","2026-01-28 09:14:11");

INSERT IGNORE INTO `wpby_duplicator_backups` VALUES 
("1","Standard","Protipofornewsites","6d8b100855fc537b1735_20260128091357","Protipofornewsites_6d8b100855fc537b1735_20260128091357_archive.zip","5","MANUAL,ZIP_ARCHIVE,TEMPORARY","{\n    \"ID\": 1,\n    \"VersionWP\": \"6.9\",\n    \"VersionDB\": \"10.11.15\",\n    \"VersionPHP\": \"8.1.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"Protipofornewsites\",\n    \"hash\": \"6d8b100855fc537b1735_20260128091357\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/staging.promarketing.gr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"Protipofornewsites_6d8b100855fc537b1735_20260128091357_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/stagingpromarket\\/public_html\\/.opcache\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/.tmb\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/bps-backup\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/cache\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/old-cache\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/updraft\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/wfcache\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/.htaccess\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/.user.ini\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/php.ini\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/web.config\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-config.php\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"Protipofornewsites_6d8b100855fc537b1735_20260128091357_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/stagingpromarket\\/public_html\\/\",\n        \"Size\": 691711793,\n        \"Dirs\": [],\n        \"DirCount\": 7690,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 41387,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 369477781,\n                        \"bytes\": \"352.36MB\",\n                        \"nodes\": 37959,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 181180849,\n                        \"bytes\": \"172.79MB\",\n                        \"nodes\": 2428,\n                        \"name\": \"dummy-data\",\n                        \"dir\": \"wp-content\\/themes\\/woodmart\\/inc\\/admin\\/modules\\/import\",\n                        \"path\": \"wp-content\\/themes\\/woodmart\\/inc\\/admin\\/modules\\/import\\/dummy-data\"\n                    },\n                    {\n                        \"ubytes\": 181319136,\n                        \"bytes\": \"172.92MB\",\n                        \"nodes\": 2442,\n                        \"name\": \"import\",\n                        \"dir\": \"wp-content\\/themes\\/woodmart\\/inc\\/admin\\/modules\",\n                        \"path\": \"wp-content\\/themes\\/woodmart\\/inc\\/admin\\/modules\\/import\"\n                    },\n                    {\n                        \"ubytes\": 182838406,\n                        \"bytes\": \"174.37MB\",\n                        \"nodes\": 2567,\n                        \"name\": \"modules\",\n                        \"dir\": \"wp-content\\/themes\\/woodmart\\/inc\\/admin\",\n                        \"path\": \"wp-content\\/themes\\/woodmart\\/inc\\/admin\\/modules\"\n                    },\n                    {\n                        \"ubytes\": 187849925,\n                        \"bytes\": \"179.15MB\",\n                        \"nodes\": 3242,\n                        \"name\": \"admin\",\n                        \"dir\": \"wp-content\\/themes\\/woodmart\\/inc\",\n                        \"path\": \"wp-content\\/themes\\/woodmart\\/inc\\/admin\"\n                    },\n                    {\n                        \"ubytes\": 207679652,\n                        \"bytes\": \"198.06MB\",\n                        \"nodes\": 6111,\n                        \"name\": \"inc\",\n                        \"dir\": \"wp-content\\/themes\\/woodmart\",\n                        \"path\": \"wp-content\\/themes\\/woodmart\\/inc\"\n                    },\n                    {\n                        \"ubytes\": 223558313,\n                        \"bytes\": \"213.2MB\",\n                        \"nodes\": 7230,\n                        \"name\": \"woodmart\",\n                        \"dir\": \"wp-content\\/themes\",\n                        \"path\": \"wp-content\\/themes\\/woodmart\"\n                    },\n                    {\n                        \"ubytes\": 223805142,\n                        \"bytes\": \"213.44MB\",\n                        \"nodes\": 7236,\n                        \"name\": \"themes\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/themes\"\n                    },\n                    {\n                        \"ubytes\": 630249190,\n                        \"bytes\": \"601.05MB\",\n                        \"nodes\": 45854,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-snapshots\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/.opcache\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/.tmb\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/old-cache\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/updraft\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/wfcache\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/cache\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 9705065,\n                        \"bytes\": \"9.26MB\",\n                        \"nodes\": 1,\n                        \"name\": \"geoip.mmdb\",\n                        \"dir\": \"wp-content\\/plugins\\/wordfence\\/lib\",\n                        \"path\": \"wp-content\\/plugins\\/wordfence\\/lib\\/geoip.mmdb\"\n                    },\n                    {\n                        \"ubytes\": 5868666,\n                        \"bytes\": \"5.6MB\",\n                        \"nodes\": 1,\n                        \"name\": \"1769512041.xml\",\n                        \"dir\": \"wp-content\\/uploads\\/wpallimport\\/uploads\\/1f5f24c38ae5c5892099a486318ce656\",\n                        \"path\": \"wp-content\\/uploads\\/wpallimport\\/uploads\\/1f5f24c38ae5c5892099a486318ce656\\/1769512041.xml\"\n                    },\n                    {\n                        \"ubytes\": 9705065,\n                        \"bytes\": \"9.26MB\",\n                        \"nodes\": 1,\n                        \"name\": \"geoip.mmdb\",\n                        \"dir\": \"wp-content\\/wflogs\",\n                        \"path\": \"wp-content\\/wflogs\\/geoip.mmdb\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/.htaccess\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/.user.ini\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/php.ini\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/web.config\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/debug.log\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"text\": \"\\/home\\/stagingpromarket\\/public_html <span class=\\\"size\\\" >659.67MB<\\/span> <span class=\\\"nodes\\\" >49077<\\/span>\",\n                \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\",\n                \"type\": \"folder\",\n                \"state\": {\n                    \"opened\": true,\n                    \"disabled\": false,\n                    \"selected\": false,\n                    \"checked\": false,\n                    \"checkbox_disabled\": true\n                },\n                \"children\": [\n                    {\n                        \"text\": \"wp-content <span class=\\\"size\\\" >601.05MB<\\/span> <span class=\\\"nodes\\\" >45854<\\/span>\",\n                        \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\",\n                        \"type\": \"folder\",\n                        \"state\": {\n                            \"opened\": true,\n                            \"disabled\": false,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": false\n                        },\n                        \"children\": [\n                            {\n                                \"text\": \"plugins <span class=\\\"size\\\" >352.36MB<\\/span> <span class=\\\"nodes\\\" >37959<\\/span>\",\n                                \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/plugins\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"wordfence <span class=\\\"size\\\" >18.86MB<\\/span> <span class=\\\"nodes\\\" >830<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/plugins\\/wordfence\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"lib <span class=\\\"size\\\" >11.81MB<\\/span> <span class=\\\"nodes\\\" >138<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/plugins\\/wordfence\\/lib\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"geoip.mmdb <span class=\\\"size\\\" >9.26MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/plugins\\/wordfence\\/lib\\/geoip.mmdb\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            },\n                            {\n                                \"text\": \"themes <span class=\\\"size\\\" >213.44MB<\\/span> <span class=\\\"nodes\\\" >7236<\\/span>\",\n                                \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/themes\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"woodmart <span class=\\\"size\\\" >213.2MB<\\/span> <span class=\\\"nodes\\\" >7230<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/themes\\/woodmart\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"inc <span class=\\\"size\\\" >198.06MB<\\/span> <span class=\\\"nodes\\\" >6111<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/themes\\/woodmart\\/inc\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"admin <span class=\\\"size\\\" >179.15MB<\\/span> <span class=\\\"nodes\\\" >3242<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/themes\\/woodmart\\/inc\\/admin\",\n                                                        \"type\": \"folder\",\n                                                        \"state\": {\n                                                            \"opened\": true,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": [\n                                                            {\n                                                                \"text\": \"modules <span class=\\\"size\\\" >174.37MB<\\/span> <span class=\\\"nodes\\\" >2567<\\/span>\",\n                                                                \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/themes\\/woodmart\\/inc\\/admin\\/modules\",\n                                                                \"type\": \"folder\",\n                                                                \"state\": {\n                                                                    \"opened\": true,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": [\n                                                                    {\n                                                                        \"text\": \"import <span class=\\\"size\\\" >172.92MB<\\/span> <span class=\\\"nodes\\\" >2442<\\/span>\",\n                                                                        \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/themes\\/woodmart\\/inc\\/admin\\/modules\\/import\",\n                                                                        \"type\": \"folder\",\n                                                                        \"state\": {\n                                                                            \"opened\": true,\n                                                                            \"disabled\": false,\n                                                                            \"selected\": false,\n                                                                            \"checked\": false,\n                                                                            \"checkbox_disabled\": false\n                                                                        },\n                                                                        \"children\": [\n                                                                            {\n                                                                                \"text\": \"dummy-data <span class=\\\"size\\\" >172.79MB<\\/span> <span class=\\\"nodes\\\" >2428<\\/span>\",\n                                                                                \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/themes\\/woodmart\\/inc\\/admin\\/modules\\/import\\/dummy-data\",\n                                                                                \"type\": \"folder\",\n                                                                                \"state\": {\n                                                                                    \"opened\": false,\n                                                                                    \"disabled\": false,\n                                                                                    \"selected\": false,\n                                                                                    \"checked\": false,\n                                                                                    \"checkbox_disabled\": false\n                                                                                },\n                                                                                \"children\": true,\n                                                                                \"li_attr\": {\n                                                                                    \"data-full-loaded\": false,\n                                                                                    \"class\": \" warning-node\"\n                                                                                },\n                                                                                \"a_attr\": []\n                                                                            }\n                                                                        ],\n                                                                        \"li_attr\": {\n                                                                            \"data-full-loaded\": false,\n                                                                            \"class\": \" warning-node\"\n                                                                        },\n                                                                        \"a_attr\": []\n                                                                    }\n                                                                ],\n                                                                \"li_attr\": {\n                                                                    \"data-full-loaded\": false,\n                                                                    \"class\": \" warning-node\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            }\n                                                        ],\n                                                        \"li_attr\": {\n                                                            \"data-full-loaded\": false,\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-node\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-node\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            },\n                            {\n                                \"text\": \"uploads <span class=\\\"size\\\" >10.3MB<\\/span> <span class=\\\"nodes\\\" >191<\\/span>\",\n                                \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"wpallimport <span class=\\\"size\\\" >6.09MB<\\/span> <span class=\\\"nodes\\\" >35<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/wpallimport\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"uploads <span class=\\\"size\\\" >5.78MB<\\/span> <span class=\\\"nodes\\\" >16<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/wpallimport\\/uploads\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"1f5f24c38ae5c5892099a486318ce656 <span class=\\\"size\\\" >5.6MB<\\/span> <span class=\\\"nodes\\\" >3<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/wpallimport\\/uploads\\/1f5f24c38ae5c5892099a486318ce656\",\n                                                        \"type\": \"folder\",\n                                                        \"state\": {\n                                                            \"opened\": true,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": [\n                                                            {\n                                                                \"text\": \"1769512041.xml <span class=\\\"size\\\" >5.6MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/wpallimport\\/uploads\\/1f5f24c38ae5c5892099a486318ce656\\/1769512041.xml\",\n                                                                \"type\": \"file\",\n                                                                \"state\": {\n                                                                    \"opened\": false,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": null,\n                                                                \"li_attr\": {\n                                                                    \"class\": \" warning-node\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            }\n                                                        ],\n                                                        \"li_attr\": {\n                                                            \"data-full-loaded\": false,\n                                                            \"class\": \" warning-childs\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-childs\"\n                                },\n                                \"a_attr\": []\n                            },\n                            {\n                                \"text\": \"wflogs <span class=\\\"size\\\" >11.76MB<\\/span> <span class=\\\"nodes\\\" >11<\\/span>\",\n                                \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/wflogs\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"geoip.mmdb <span class=\\\"size\\\" >9.26MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/wflogs\\/geoip.mmdb\",\n                                        \"type\": \"file\",\n                                        \"state\": {\n                                            \"opened\": false,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": null,\n                                        \"li_attr\": {\n                                            \"class\": \" warning-node\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-childs\"\n                                },\n                                \"a_attr\": []\n                            }\n                        ],\n                        \"li_attr\": {\n                            \"data-full-loaded\": false,\n                            \"class\": \" warning-node\"\n                        },\n                        \"a_attr\": []\n                    }\n                ],\n                \"li_attr\": {\n                    \"data-full-loaded\": false,\n                    \"class\": \" root-node core-node warning-childs\"\n                },\n                \"a_attr\": {\n                    \"title\": \"Core WordPress directories should not be filtered. Use caution when excluding files.\"\n                }\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"Protipofornewsites_6d8b100855fc537b1735_20260128091357_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"7RjP0bZUuXRKSx5tKeGGA0dw\\/Ter2qJNlcSZNQ6p5bzvXvMJIquyxH10GBmVZwuAcHQ985Za2+if0b+K8NSZlA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"stagingpromarket_wp920\",\n            \"tablesBaseCount\": 150,\n            \"tablesFinalCount\": 150,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 10379,\n            \"tablesSizeOnDisk\": 19333120,\n            \"tablesList\": {\n                \"wpby_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"371\",\n                    \"insertedRows\": 0,\n                    \"size\": 327680\n                },\n                \"wpby_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"1087\",\n                    \"insertedRows\": 0,\n                    \"size\": 262144\n                },\n                \"wpby_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_comments\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpby_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wpby_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wpby_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wpby_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 311296\n                },\n                \"wpby_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpby_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_helpmate_abandoned_carts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_helpmate_analytics\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_helpmate_chat_history\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_helpmate_documents\": {\n                    \"inaccurateRows\": \"20\",\n                    \"insertedRows\": 0,\n                    \"size\": 245760\n                },\n                \"wpby_helpmate_jobs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_helpmate_leads\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_helpmate_promo_banners\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_helpmate_returns_refunds\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_helpmate_settings\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_helpmate_tickets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_iben_elta_bulk_vouchers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_iben_elta_contacts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_iben_elta_vouchers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_iben_elta_voucher_schedule\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_jet_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_jet_post_types\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_jet_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_options\": {\n                    \"inaccurateRows\": \"1440\",\n                    \"insertedRows\": 0,\n                    \"size\": 5439488\n                },\n                \"wpby_pmxe_exports\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpby_pmxe_google_cats\": {\n                    \"inaccurateRows\": \"5512\",\n                    \"insertedRows\": 0,\n                    \"size\": 409600\n                },\n                \"wpby_pmxe_posts\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pmxe_templates\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_pmxi_files\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pmxi_geocoding\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_pmxi_hash\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pmxi_history\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pmxi_images\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pmxi_imports\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wpby_pmxi_posts\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pmxi_templates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_postmeta\": {\n                    \"inaccurateRows\": \"577\",\n                    \"insertedRows\": 0,\n                    \"size\": 2211840\n                },\n                \"wpby_posts\": {\n                    \"inaccurateRows\": \"121\",\n                    \"insertedRows\": 0,\n                    \"size\": 1409024\n                },\n                \"wpby_pys_events_queue\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_pys_options\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 0,\n                    \"size\": 1605632\n                },\n                \"wpby_pys_stat_landing\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pys_stat_order\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pys_stat_product_order\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pys_stat_traffic\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pys_stat_utm_campaing\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pys_stat_utm_content\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pys_stat_utm_medium\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pys_stat_utm_source\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pys_stat_utm_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_slm_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_termmeta\": {\n                    \"inaccurateRows\": \"306\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_terms\": {\n                    \"inaccurateRows\": \"124\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_term_relationships\": {\n                    \"inaccurateRows\": \"18\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_term_taxonomy\": {\n                    \"inaccurateRows\": \"124\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_usermeta\": {\n                    \"inaccurateRows\": \"84\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_viva_com_smart_wc_checkout_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_viva_com_smart_wc_checkout_recurring\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_viva_com_smart_wc_checkout_transactions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_viva_com_smart_wc_checkout_transaction_types\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wc_admin_notes\": {\n                    \"inaccurateRows\": \"61\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"87\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_wc_category_lookup\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpby_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpby_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpby_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wfauditevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_wfconfig\": {\n                    \"inaccurateRows\": \"269\",\n                    \"insertedRows\": 0,\n                    \"size\": 147456\n                },\n                \"wpby_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wffilemods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wfhits\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wfissues\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_wfknownfilelist\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wflogins\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wpby_wfls_settings\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_wfstatus\": {\n                    \"inaccurateRows\": \"20\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wlr_earn_campaign\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wpby_wlr_earn_campaign_transaction\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"wpby_wlr_expire_points\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"wpby_wlr_levels\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpby_wlr_logs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wlr_points_ledger\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_wlr_referral\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_wlr_rewards\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_wlr_reward_transactions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpby_wlr_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wpby_wlr_user_rewards\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpby_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_woodmart_unsubscribed_emails\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_woodmart_wishlists\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_woodmart_wishlist_products\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wpmailsmtp_debug_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wpmailsmtp_tasks_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.11.15\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"Protipofornewsites_6d8b100855fc537b1735_20260128091357_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 5,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 691711793,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"isProcessing\": false,\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2026-01-28 09:13:57\",\n    \"updated\": \"2026-01-28 09:14:00\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\",\n        \"TEMPORARY\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 1,\n    \"mainActivityLogId\": 0\n}","4.5.24.2","2026-01-28 09:13:57","2026-01-28 09:14:00"),
("2","Standard","Protipofornewsites","6d8b100855fc537b1735_20260128091357","Protipofornewsites_6d8b100855fc537b1735_20260128091357_archive.zip","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 2,\n    \"VersionWP\": \"6.9\",\n    \"VersionDB\": \"10.11.15\",\n    \"VersionPHP\": \"8.1.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"Protipofornewsites\",\n    \"hash\": \"6d8b100855fc537b1735_20260128091357\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/staging.promarketing.gr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"Protipofornewsites_6d8b100855fc537b1735_20260128091357_scan.json\",\n    \"timer_start\": 1769591651.723896026611328125,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/stagingpromarket\\/public_html\\/.opcache\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/.tmb\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/bps-backup\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/cache\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/old-cache\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/updraft\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/wfcache\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/.htaccess\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/.user.ini\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/php.ini\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/web.config\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-config.php\",\n            \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"Protipofornewsites_6d8b100855fc537b1735_20260128091357_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/stagingpromarket\\/public_html\\/\",\n        \"Size\": 691711793,\n        \"Dirs\": [],\n        \"DirCount\": 7690,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 41387,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 369477781,\n                        \"bytes\": \"352.36MB\",\n                        \"nodes\": 37959,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 181180849,\n                        \"bytes\": \"172.79MB\",\n                        \"nodes\": 2428,\n                        \"name\": \"dummy-data\",\n                        \"dir\": \"wp-content\\/themes\\/woodmart\\/inc\\/admin\\/modules\\/import\",\n                        \"path\": \"wp-content\\/themes\\/woodmart\\/inc\\/admin\\/modules\\/import\\/dummy-data\"\n                    },\n                    {\n                        \"ubytes\": 181319136,\n                        \"bytes\": \"172.92MB\",\n                        \"nodes\": 2442,\n                        \"name\": \"import\",\n                        \"dir\": \"wp-content\\/themes\\/woodmart\\/inc\\/admin\\/modules\",\n                        \"path\": \"wp-content\\/themes\\/woodmart\\/inc\\/admin\\/modules\\/import\"\n                    },\n                    {\n                        \"ubytes\": 182838406,\n                        \"bytes\": \"174.37MB\",\n                        \"nodes\": 2567,\n                        \"name\": \"modules\",\n                        \"dir\": \"wp-content\\/themes\\/woodmart\\/inc\\/admin\",\n                        \"path\": \"wp-content\\/themes\\/woodmart\\/inc\\/admin\\/modules\"\n                    },\n                    {\n                        \"ubytes\": 187849925,\n                        \"bytes\": \"179.15MB\",\n                        \"nodes\": 3242,\n                        \"name\": \"admin\",\n                        \"dir\": \"wp-content\\/themes\\/woodmart\\/inc\",\n                        \"path\": \"wp-content\\/themes\\/woodmart\\/inc\\/admin\"\n                    },\n                    {\n                        \"ubytes\": 207679652,\n                        \"bytes\": \"198.06MB\",\n                        \"nodes\": 6111,\n                        \"name\": \"inc\",\n                        \"dir\": \"wp-content\\/themes\\/woodmart\",\n                        \"path\": \"wp-content\\/themes\\/woodmart\\/inc\"\n                    },\n                    {\n                        \"ubytes\": 223558313,\n                        \"bytes\": \"213.2MB\",\n                        \"nodes\": 7230,\n                        \"name\": \"woodmart\",\n                        \"dir\": \"wp-content\\/themes\",\n                        \"path\": \"wp-content\\/themes\\/woodmart\"\n                    },\n                    {\n                        \"ubytes\": 223805142,\n                        \"bytes\": \"213.44MB\",\n                        \"nodes\": 7236,\n                        \"name\": \"themes\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/themes\"\n                    },\n                    {\n                        \"ubytes\": 630249190,\n                        \"bytes\": \"601.05MB\",\n                        \"nodes\": 45854,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-snapshots\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/.opcache\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/.tmb\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/old-cache\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/updraft\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/wfcache\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/cache\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 9705065,\n                        \"bytes\": \"9.26MB\",\n                        \"nodes\": 1,\n                        \"name\": \"geoip.mmdb\",\n                        \"dir\": \"wp-content\\/plugins\\/wordfence\\/lib\",\n                        \"path\": \"wp-content\\/plugins\\/wordfence\\/lib\\/geoip.mmdb\"\n                    },\n                    {\n                        \"ubytes\": 5868666,\n                        \"bytes\": \"5.6MB\",\n                        \"nodes\": 1,\n                        \"name\": \"1769512041.xml\",\n                        \"dir\": \"wp-content\\/uploads\\/wpallimport\\/uploads\\/1f5f24c38ae5c5892099a486318ce656\",\n                        \"path\": \"wp-content\\/uploads\\/wpallimport\\/uploads\\/1f5f24c38ae5c5892099a486318ce656\\/1769512041.xml\"\n                    },\n                    {\n                        \"ubytes\": 9705065,\n                        \"bytes\": \"9.26MB\",\n                        \"nodes\": 1,\n                        \"name\": \"geoip.mmdb\",\n                        \"dir\": \"wp-content\\/wflogs\",\n                        \"path\": \"wp-content\\/wflogs\\/geoip.mmdb\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/.htaccess\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/.user.ini\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/php.ini\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/web.config\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/debug.log\",\n                    \"\\/home\\/stagingpromarket\\/public_html\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"Protipofornewsites_6d8b100855fc537b1735_20260128091357_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"L5iQFtD5TIUhgQ\\/C5B3W1P3krtzs+DY4xl7uuWmnY+Ku4hXzKvdXAjpi909BkldmLCpipaBYE2K5Sbgvpoc\\/Sg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"stagingpromarket_wp920\",\n            \"tablesBaseCount\": 150,\n            \"tablesFinalCount\": 150,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 10379,\n            \"tablesSizeOnDisk\": 19333120,\n            \"tablesList\": {\n                \"wpby_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"371\",\n                    \"insertedRows\": 0,\n                    \"size\": 327680\n                },\n                \"wpby_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"1087\",\n                    \"insertedRows\": 0,\n                    \"size\": 262144\n                },\n                \"wpby_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_comments\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpby_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wpby_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wpby_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wpby_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 311296\n                },\n                \"wpby_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpby_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_helpmate_abandoned_carts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_helpmate_analytics\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_helpmate_chat_history\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_helpmate_documents\": {\n                    \"inaccurateRows\": \"20\",\n                    \"insertedRows\": 0,\n                    \"size\": 245760\n                },\n                \"wpby_helpmate_jobs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_helpmate_leads\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_helpmate_promo_banners\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_helpmate_returns_refunds\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_helpmate_settings\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_helpmate_tickets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_iben_elta_bulk_vouchers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_iben_elta_contacts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_iben_elta_vouchers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_iben_elta_voucher_schedule\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_jet_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_jet_post_types\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_jet_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_options\": {\n                    \"inaccurateRows\": \"1440\",\n                    \"insertedRows\": 0,\n                    \"size\": 5439488\n                },\n                \"wpby_pmxe_exports\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpby_pmxe_google_cats\": {\n                    \"inaccurateRows\": \"5512\",\n                    \"insertedRows\": 0,\n                    \"size\": 409600\n                },\n                \"wpby_pmxe_posts\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pmxe_templates\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_pmxi_files\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pmxi_geocoding\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_pmxi_hash\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pmxi_history\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pmxi_images\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pmxi_imports\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wpby_pmxi_posts\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pmxi_templates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_postmeta\": {\n                    \"inaccurateRows\": \"577\",\n                    \"insertedRows\": 0,\n                    \"size\": 2211840\n                },\n                \"wpby_posts\": {\n                    \"inaccurateRows\": \"121\",\n                    \"insertedRows\": 0,\n                    \"size\": 1409024\n                },\n                \"wpby_pys_events_queue\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_pys_options\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 0,\n                    \"size\": 1605632\n                },\n                \"wpby_pys_stat_landing\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pys_stat_order\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pys_stat_product_order\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pys_stat_traffic\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pys_stat_utm_campaing\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pys_stat_utm_content\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pys_stat_utm_medium\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pys_stat_utm_source\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_pys_stat_utm_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_slm_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_termmeta\": {\n                    \"inaccurateRows\": \"306\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_terms\": {\n                    \"inaccurateRows\": \"124\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_term_relationships\": {\n                    \"inaccurateRows\": \"18\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_term_taxonomy\": {\n                    \"inaccurateRows\": \"124\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_usermeta\": {\n                    \"inaccurateRows\": \"84\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_viva_com_smart_wc_checkout_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_viva_com_smart_wc_checkout_recurring\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_viva_com_smart_wc_checkout_transactions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_viva_com_smart_wc_checkout_transaction_types\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wc_admin_notes\": {\n                    \"inaccurateRows\": \"61\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"87\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_wc_category_lookup\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpby_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpby_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpby_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wfauditevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_wfconfig\": {\n                    \"inaccurateRows\": \"269\",\n                    \"insertedRows\": 0,\n                    \"size\": 147456\n                },\n                \"wpby_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wffilemods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wfhits\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wfissues\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_wfknownfilelist\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wflogins\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wpby_wfls_settings\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_wfstatus\": {\n                    \"inaccurateRows\": \"20\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wlr_earn_campaign\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wpby_wlr_earn_campaign_transaction\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"wpby_wlr_expire_points\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"wpby_wlr_levels\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpby_wlr_logs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_wlr_points_ledger\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_wlr_referral\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_wlr_rewards\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_wlr_reward_transactions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wpby_wlr_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wpby_wlr_user_rewards\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wpby_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wpby_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wpby_woodmart_unsubscribed_emails\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_woodmart_wishlists\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_woodmart_wishlist_products\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wpby_wpmailsmtp_debug_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wpmailsmtp_tasks_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wpby_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wpby_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.11.15\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"Protipofornewsites_6d8b100855fc537b1735_20260128091357_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/stagingpromarket\\/public_html\\/wp-content\\/backups-dup-pro\\/tmp\\/Protipofornewsites_6d8b100855fc537b1735_20260128091357_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 20,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1769591652,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 691711793,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wpby_users\",\n            \"wpby_usermeta\",\n            \"wpby_actionscheduler_actions\",\n            \"wpby_actionscheduler_claims\",\n            \"wpby_actionscheduler_groups\",\n            \"wpby_actionscheduler_logs\",\n            \"wpby_commentmeta\",\n            \"wpby_comments\",\n            \"wpby_duplicator_activity_logs\",\n            \"wpby_duplicator_backups\",\n            \"wpby_duplicator_entities\",\n            \"wpby_e_events\",\n            \"wpby_e_submissions\",\n            \"wpby_e_submissions_actions_log\",\n            \"wpby_e_submissions_values\",\n            \"wpby_helpmate_abandoned_carts\",\n            \"wpby_helpmate_analytics\",\n            \"wpby_helpmate_chat_history\",\n            \"wpby_helpmate_documents\",\n            \"wpby_helpmate_jobs\",\n            \"wpby_helpmate_leads\",\n            \"wpby_helpmate_promo_banners\",\n            \"wpby_helpmate_returns_refunds\",\n            \"wpby_helpmate_settings\",\n            \"wpby_helpmate_tickets\",\n            \"wpby_iben_elta_bulk_vouchers\",\n            \"wpby_iben_elta_contacts\",\n            \"wpby_iben_elta_vouchers\",\n            \"wpby_iben_elta_voucher_schedule\",\n            \"wpby_jet_cache\",\n            \"wpby_jet_post_types\",\n            \"wpby_jet_taxonomies\",\n            \"wpby_links\",\n            \"wpby_options\",\n            \"wpby_pmxe_exports\",\n            \"wpby_pmxe_google_cats\",\n            \"wpby_pmxe_posts\",\n            \"wpby_pmxe_templates\",\n            \"wpby_pmxi_files\",\n            \"wpby_pmxi_geocoding\",\n            \"wpby_pmxi_hash\",\n            \"wpby_pmxi_history\",\n            \"wpby_pmxi_images\",\n            \"wpby_pmxi_imports\",\n            \"wpby_pmxi_posts\",\n            \"wpby_pmxi_templates\",\n            \"wpby_postmeta\",\n            \"wpby_posts\",\n            \"wpby_pys_events_queue\",\n            \"wpby_pys_options\",\n            \"wpby_pys_stat_landing\",\n            \"wpby_pys_stat_order\",\n            \"wpby_pys_stat_product_order\",\n            \"wpby_pys_stat_traffic\",\n            \"wpby_pys_stat_utm_campaing\",\n            \"wpby_pys_stat_utm_content\",\n            \"wpby_pys_stat_utm_medium\",\n            \"wpby_pys_stat_utm_source\",\n            \"wpby_pys_stat_utm_term\",\n            \"wpby_rank_math_404_logs\",\n            \"wpby_rank_math_internal_links\",\n            \"wpby_rank_math_internal_meta\",\n            \"wpby_rank_math_redirections\",\n            \"wpby_rank_math_redirections_cache\",\n            \"wpby_slm_orders\",\n            \"wpby_termmeta\",\n            \"wpby_terms\",\n            \"wpby_term_relationships\",\n            \"wpby_term_taxonomy\",\n            \"wpby_viva_com_smart_wc_checkout_orders\",\n            \"wpby_viva_com_smart_wc_checkout_recurring\",\n            \"wpby_viva_com_smart_wc_checkout_transactions\",\n            \"wpby_viva_com_smart_wc_checkout_transaction_types\",\n            \"wpby_wc_admin_notes\",\n            \"wpby_wc_admin_note_actions\",\n            \"wpby_wc_category_lookup\",\n            \"wpby_wc_customer_lookup\",\n            \"wpby_wc_download_log\",\n            \"wpby_wc_orders\",\n            \"wpby_wc_orders_meta\",\n            \"wpby_wc_order_addresses\",\n            \"wpby_wc_order_coupon_lookup\",\n            \"wpby_wc_order_operational_data\",\n            \"wpby_wc_order_product_lookup\",\n            \"wpby_wc_order_stats\",\n            \"wpby_wc_order_tax_lookup\",\n            \"wpby_wc_product_attributes_lookup\",\n            \"wpby_wc_product_download_directories\",\n            \"wpby_wc_product_meta_lookup\",\n            \"wpby_wc_rate_limits\",\n            \"wpby_wc_reserved_stock\",\n            \"wpby_wc_tax_rate_classes\",\n            \"wpby_wc_webhooks\",\n            \"wpby_wfauditevents\",\n            \"wpby_wfblockediplog\",\n            \"wpby_wfblocks7\",\n            \"wpby_wfconfig\",\n            \"wpby_wfcrawlers\",\n            \"wpby_wffilechanges\",\n            \"wpby_wffilemods\",\n            \"wpby_wfhits\",\n            \"wpby_wfhoover\",\n            \"wpby_wfissues\",\n            \"wpby_wfknownfilelist\",\n            \"wpby_wflivetraffichuman\",\n            \"wpby_wflocs\",\n            \"wpby_wflogins\",\n            \"wpby_wfls_2fa_secrets\",\n            \"wpby_wfls_role_counts\",\n            \"wpby_wfls_settings\",\n            \"wpby_wfnotifications\",\n            \"wpby_wfpendingissues\",\n            \"wpby_wfreversecache\",\n            \"wpby_wfsecurityevents\",\n            \"wpby_wfsnipcache\",\n            \"wpby_wfstatus\",\n            \"wpby_wftrafficrates\",\n            \"wpby_wfwaffailures\",\n            \"wpby_wlr_earn_campaign\",\n            \"wpby_wlr_earn_campaign_transaction\",\n            \"wpby_wlr_expire_points\",\n            \"wpby_wlr_levels\",\n            \"wpby_wlr_logs\",\n            \"wpby_wlr_points_ledger\",\n            \"wpby_wlr_referral\",\n            \"wpby_wlr_rewards\",\n            \"wpby_wlr_reward_transactions\",\n            \"wpby_wlr_users\",\n            \"wpby_wlr_user_rewards\",\n            \"wpby_woocommerce_api_keys\",\n            \"wpby_woocommerce_attribute_taxonomies\",\n            \"wpby_woocommerce_downloadable_product_permissions\",\n            \"wpby_woocommerce_log\",\n            \"wpby_woocommerce_order_itemmeta\",\n            \"wpby_woocommerce_order_items\",\n            \"wpby_woocommerce_payment_tokenmeta\",\n            \"wpby_woocommerce_payment_tokens\",\n            \"wpby_woocommerce_sessions\",\n            \"wpby_woocommerce_shipping_zones\",\n            \"wpby_woocommerce_shipping_zone_locations\",\n            \"wpby_woocommerce_shipping_zone_methods\",\n            \"wpby_woocommerce_tax_rates\",\n            \"wpby_woocommerce_tax_rate_locations\",\n            \"wpby_woodmart_unsubscribed_emails\",\n            \"wpby_woodmart_wishlists\",\n            \"wpby_woodmart_wishlist_products\",\n            \"wpby_wpmailsmtp_debug_events\",\n            \"wpby_wpmailsmtp_tasks_meta\",\n            \"wpby_wpr_rocket_cache\",\n            \"wpby_wpr_rucss_used_css\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1769591651.7424590587615966796875,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 10430,\n            \"tables\": {\n                \"wpby_users\": {\n                    \"start\": \"2\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_duplicator_activity_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_e_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_e_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_e_submissions_actions_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_e_submissions_values\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_helpmate_abandoned_carts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_helpmate_analytics\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_helpmate_chat_history\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_helpmate_documents\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_helpmate_jobs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_helpmate_leads\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_helpmate_promo_banners\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_helpmate_returns_refunds\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_helpmate_settings\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_helpmate_tickets\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_iben_elta_bulk_vouchers\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_iben_elta_contacts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_iben_elta_vouchers\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_iben_elta_voucher_schedule\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_jet_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_jet_post_types\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_jet_taxonomies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pmxe_exports\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pmxe_google_cats\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pmxe_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pmxe_templates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pmxi_files\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pmxi_geocoding\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pmxi_hash\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pmxi_history\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pmxi_images\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pmxi_imports\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pmxi_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pmxi_templates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pys_events_queue\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pys_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pys_stat_landing\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pys_stat_order\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pys_stat_product_order\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pys_stat_traffic\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pys_stat_utm_campaing\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pys_stat_utm_content\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pys_stat_utm_medium\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pys_stat_utm_source\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_pys_stat_utm_term\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_rank_math_404_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_rank_math_internal_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_rank_math_internal_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_rank_math_redirections\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_rank_math_redirections_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_slm_orders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_viva_com_smart_wc_checkout_orders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_viva_com_smart_wc_checkout_recurring\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_viva_com_smart_wc_checkout_transactions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_viva_com_smart_wc_checkout_transaction_types\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_admin_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_admin_note_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_category_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_customer_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_download_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_orders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_orders_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_order_addresses\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_order_coupon_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_order_operational_data\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_order_product_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_order_stats\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_order_tax_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_product_attributes_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_product_download_directories\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_product_meta_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_rate_limits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_reserved_stock\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_tax_rate_classes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wc_webhooks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfauditevents\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfblockediplog\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfblocks7\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfconfig\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfcrawlers\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wffilechanges\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wffilemods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfhits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfhoover\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfissues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfknownfilelist\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wflivetraffichuman\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wflocs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wflogins\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfls_2fa_secrets\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfls_role_counts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfls_settings\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfnotifications\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfpendingissues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfreversecache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfsecurityevents\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfsnipcache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfstatus\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wftrafficrates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wfwaffailures\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wlr_earn_campaign\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wlr_earn_campaign_transaction\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wlr_expire_points\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wlr_levels\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wlr_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wlr_points_ledger\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wlr_referral\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wlr_rewards\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wlr_reward_transactions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wlr_users\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wlr_user_rewards\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woocommerce_api_keys\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woocommerce_attribute_taxonomies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woocommerce_downloadable_product_permissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woocommerce_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woocommerce_order_itemmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woocommerce_order_items\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woocommerce_payment_tokenmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woocommerce_payment_tokens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woocommerce_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woocommerce_shipping_zones\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woocommerce_shipping_zone_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woocommerce_shipping_zone_methods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woocommerce_tax_rates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woocommerce_tax_rate_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woodmart_unsubscribed_emails\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woodmart_wishlists\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_woodmart_wishlist_products\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wpmailsmtp_debug_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wpmailsmtp_tasks_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wpr_rocket_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpby_wpr_rucss_used_css\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"isProcessing\": false,\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2026-01-28 09:13:57\",\n    \"updated\": \"2026-01-28 09:14:12\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 1,\n    \"mainActivityLogId\": 3\n}","4.5.24.2","2026-01-28 09:13:57","2026-01-28 09:14:12");

INSERT IGNORE INTO `wpby_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"and.adamop@gmail.com\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 1,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"and.adamop@gmail.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 0,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"https:\\/\\/staging.promarketing.gr\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"purgeBackupRecords\": 0,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_key_visible\": 1,\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1769515556,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 1,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2026-01-27 12:05:55\",\n    \"updated\": \"2026-01-28 09:13:57\"\n}","4.5.24.2","2026-01-27 12:05:55","2026-01-28 09:13:57"),
("2","Dynamic_Entity","","","","","","{\n    \"data\": \"BoX5VwS0HgUqPAZQf9MerZTLpNbzh4FMtsXQ8i+0rywrS4OT5cetLMRFLlZXLyyNE5XX55Qmmirk+Tr2AuEOKjos3hxohEtu\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 2,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2026-01-27 12:05:55\",\n    \"updated\": \"2026-01-28 09:13:17\",\n    \"dataIsEncrypted\": true\n}","4.5.24.2","2026-01-27 12:05:55","2026-01-28 09:13:17"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"1423T2cCeY+nqk1PQDUJ1itdeaYTVjzTNsmT2eUpnyTiRFD11lSI294501AXZhEQn7csgy1VErhxrVsV2Bpp1WIMwad5CBbQtG4eORuMv8djlBon7iGiCj\\/YqlwlQA+GevMgTmhAfHeD8MqPQzBmbhNjddffhSUGbYhJGhqBOaUYI\\/EAComdSiXxZBtWhsHs+Qdlap2rJkEm+rwROEGbCo7TKrDbpO3rEyFl1JyJVmctHYwiRKE6cGXrJ78j2PMj7qqqsTGHEkM=\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 3,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2026-01-27 12:05:55\",\n    \"updated\": \"2026-01-28 09:13:17\"\n}","4.5.24.2","2026-01-27 12:05:55","2026-01-28 09:13:17"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [],\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 4,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2026-01-27 12:05:55\",\n    \"updated\": \"2026-01-27 12:05:55\"\n}","4.5.24.2","2026-01-27 12:05:55","2026-01-27 12:05:55"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"zMFhWVRCT+QkRwEcys0rjKKtVQHSl9VwyDqySjfPKKQtjo5EDp1AW8cuFu8\\/odqPpDcE6FLrpiljM5Z2ovFCOQ==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 5,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2026-01-27 12:05:55\",\n    \"updated\": \"2026-01-27 12:05:55\"\n}","4.5.24.2","2026-01-27 12:05:55","2026-01-27 12:05:55"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[Manual Mode]\",\n    \"package_name_format\": \"Protipo for new sites\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"LsjoWJhd74hCd341EfDtcLIaLSuaqkplSZ+JrUe1TuQ0lIeYFBlpmul\\/N0bmj\\/TrmfFM5Y6Zn\\/3\\/IShCsBuv7w==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -1,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 6,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2026-01-27 12:05:55\",\n    \"updated\": \"2026-01-28 09:13:57\"\n}","4.5.24.2","2026-01-27 12:05:55","2026-01-28 09:13:57"),
("7","LicenseDataEntity","","","","","","{\n    \"licenseKey\": \"R5I0KkKZUJekE0xuZ9d4rORCnE9rB4NNBAIdLxg8IUSrt7+pdOs+ltNbdHGyBbMs6Z9bSVC\\/r9EBEtf14clwyQ==\",\n    \"status\": \"olUSkGg5DXeYOy1wWFC9JUn50\\/ELjiHEvh4eizHBIH0XrfxqfdD6BCXL2G\\/RAr2EtZrJF0dvZUIS0rKFVTy6cfzt55trdIhR\",\n    \"type\": \"HvTkvnVpFuzg8nVoEFa4+c5CHkw+IADy7CHvPf07jOiUofLVKc6F8IfDZ90T2hpAJLVSBxtbS0zJgo184b5PbEr8RG7YfgR3\",\n    \"data\": \"UwMOtIB7PPhYzZE0hesxNkfOi0Gx47LEy7B3Pi8KfxBxz\\/du+SO2Bg9REsesBZiAZyQmvLHxibhMunK02pUCWAA2I0GpwelTY\\/3LDJgokQfdmS8NSB4sRVlmPWzlrrJJf1Nb\\/\\/RvwVLCqFo60O\\/wecc6qP\\/fUBq\\/tdrCostjrZK+kmD4JylYHVRJi\\/SYNUhKGoPVgUvFqMiFK0nYd65IpWiWHKR2szrGFeB0vV+UEtiXcQJDp4rB\\/2ckJryx8Ym4gmBw4WOW\\/LhsZ3f0gnbLkTdcfLT0ElQ9ZeHR\\/KpCkA0DBXzDgDA4NsnG3JVG8kn7fDCqvOW\\/Rw58ZuZf4sWCxZznYqicdkQ9jeelUSOX9+GtPvErn6ETucJpSBM553Sm9feif+vvtlWEVJ1blz\\/AHnt4GjpOzfnvIhjPlK+tPLI=\",\n    \"lastRemoteUpdate\": \"\",\n    \"lastFailureTime\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 7,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2026-01-27 12:05:55\",\n    \"updated\": \"2026-01-28 09:14:12\"\n}","4.5.24.2","2026-01-27 12:05:55","2026-01-28 09:14:12"),
("8","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1769591651,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 8,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2026-01-27 12:05:57\",\n    \"updated\": \"2026-01-28 09:14:11\"\n}","4.5.24.2","2026-01-27 12:05:57","2026-01-28 09:14:11");

INSERT IGNORE INTO `wpby_helpmate_documents` VALUES 
("1","general","LikeMe.gr – Ben Tailor Ρούχα & Red Raven Γυαλιά","# Website Overview\n\n**Website/Brand Name:**  \nLikeMe.gr\n\n**Main Tagline / Heading:**  \n\"Pardon our dust! We\'re working on something amazing — check back soon!\"\n\n**Description / Purpose:**  \nThe website appears to be an online store focused on fashion and accessories, with specific categories for men\'s and women\'s clothing, as well as a shopping cart. It is currently in a \"coming soon\" state, indicating that the full site or store is under development.\n\n**Industry / Category:**  \nE-commerce (Fashion & Accessories)\n\n---\n\n# Navigation & Structure\n\n**Main Menu Items:**  \n- Men (link: https://likeme.gr/andriki-moda/andrika-okonomika-rouxa/)  \n- Women (link: https://likeme.gr/ginaikeia-moda/)  \n- Purchase / Checkout (link: https://likeme.gr/checkout/)\n\n**Additional Navigation Elements:**  \n- Skip to navigation  \n- Skip to main content\n\n**Social Media Links (in footer or header):**  \n- LinkedIn (https://www.linkedin.com/)  \n- Instagram (https://www.instagram.com)  \n- Facebook (https://www.facebook.com)\n\n**Login/Register Link:**  \n- \"Σύνδεση\" (Login) link: https://staging.promarketing.gr/wp-login.php?redirect_to=https%3A%2F%2Fstaging.promarketing.gr%2F\n\n**Sticky Toolbar Links:**  \n- Men (link: https://likeme.gr/andriki-moda/andrika-okonomika-rouxa/)  \n- Women (link: https://likeme.gr/ginaikeia-moda/)  \n- Purchase (link: https://likeme.gr/checkout/)\n\n**Footer / Additional Links:**  \nNot explicitly detailed, but social media and login links are present.\n\n---\n\n# Main Offerings / Purpose\n\n- The site is an e-commerce platform for fashion items, specifically targeting men\'s and women\'s clothing.\n- The site is currently in a \"coming soon\" phase, indicating that products or full features are not yet available.\n- The presence of categories for men\'s and women\'s fashion suggests a focus on apparel.\n- The \"Αγορά\" (Purchase) link indicates a shopping cart or checkout process.\n\n**Unique Selling Points / Benefits:**  \nNot explicitly detailed in the HTML, but the emphasis on \"working on something amazing\" suggests upcoming new features or products.\n\n---\n\n# Content Highlights\n\n- **Hero Banner / Main Message:**  \n  \"Pardon our dust! We\'re working on something amazing — check back soon!\"\n\n- **Site Title / Logo:**  \n  \"LikeMe.gr\" (linked to the homepage)\n\n- **Social Media Presence:**  \n  Icons and links for LinkedIn, Instagram, Facebook.\n\n- **Login Option:**  \n  \"Σύνδεση\" (Login) link for user account access.\n\n- **Header / Navigation:**  \n  Contains links to Men, Women, and Checkout pages.\n\n- **Footer / Additional Elements:**  \n  - Shadow DOM container (`#helpmate-root`) for potential dynamic content or scripts.\n  - Sticky toolbar with quick links to Men, Women, and Purchase.\n\n---\n\n# Customer-Facing Information\n\n**Contact Methods:**  \n- Social media links (LinkedIn, Instagram, Facebook)  \n- Login link for account access\n\n**Location / Addresses:**  \n- Not explicitly provided.\n\n**Social Media Links:**  \n- LinkedIn, Instagram, Facebook (as above)\n\n**Policies:**  \n- Not explicitly detailed in the HTML.\n\n**Calls to Action:**  \n- \"Check back soon!\" message indicating the site is under construction.  \n- Links to Men, Women, and Checkout pages for quick navigation.\n\n---\n\n# Possible Questions & Answers\n\n| Question | Answer |\n| --- | --- |\n| What is LikeMe.gr? | It is an upcoming e-commerce website focused on fashion and accessories for men and women. Currently, it is in a \"coming soon\" phase. |\n| How can I browse products? | The full product catalog is not yet available; the site is under construction. You can visit the Men and Women categories via the provided links. |\n| How do I log in or create an account? | You can click on the \"Σύνδεση\" (Login) link to access the login page. |\n| How can I contact or follow the store? | Through social media links to LinkedIn, Instagram, and Facebook. |\n| When will the site be fully operational? | The site indicates \"check back soon,\" suggesting it is currently under development and will be available in the future. |\n| How do I make a purchase? | The checkout link is available, but the full shopping experience is likely not yet active. |\n\n---\n\n# Summary\n\nThis website is an e-commerce platform named LikeMe.gr, focusing on fashion items for men and women. It is currently in a \"coming soon\" phase, with a message inviting visitors to check back later. The site includes social media links, login options, and quick navigation to product categories and checkout. The full product offerings and detailed policies are not yet available, as the site is under development.","758d708d-2516-43d9-8886-753f6a14ea20","[]","1769507072"),
("2","qa","Θέλω να κάνω αλλαγή.","Σε αυτή την περίπτωση θα χρειαστεί να συμπληρώσετε την αντίστοιχη φόρμα που βρίσκεται στην σελίδα μας για να γίνει επιστροφή χρημάτων. Η επιστροφή χρημάτων θα γίνει εντός 2 εργάσιμων ημερών από την ημερομηνία παραλαβής. Συνήθως από την μέρα που θα το στείλετε δεν ξεπερνάει η διαδικασία τις 5-7 εργάσιμες.\nΝα ενημερώσουμε ότι δεν κάνουμε αλλαγές αλλά πραγματοποιούμε ΜΟΝΟ επιστροφή χρημάτων για την παραγγελία σας. Στο ενδιάμεσο μπορείτε να παραγγείλετε το σωστό νούμερο για εσάς από την αρχή.","e9a827ea-22d5-4ec3-9b92-7355246d301a","{\"show_as_quick_option\":true}","1769507193"),
("3","qa","Πώς παίρνω τις προσφορές;","Όλες οι εκπτώσεις υπολογίζονται αυτόματα στο καλάθι αγορών σας στο Checkout.","59216129-f083-4c9d-96da-ec7841090e8c","{\"show_as_quick_option\":false}","1769507205"),
("4","qa","Μπορείς να μου πεις σε τί κατάσταση είναι η παραγγελία μου;","Λυπάμαι, αλλά δεν έχω πρόσβαση σε πληροφορίες σχετικά με την κατάσταση της παραγγελίας σας. Για να λάβετε ενημέρωση, μπορείτε να επικοινωνήσετε μαζί μας μέσω email στο pro@likeme.gr. Αν θέλετε, μπορώ να σας βοηθήσω να δημιουργήσετε ένα αίτημα ή να σας καθοδηγήσω στη διαδικασία.","a74dd35f-febf-4271-a901-0b740a06020f","{\"show_as_quick_option\":false}","1769507215"),
("5","qa","Μπορείς να μου πεις αν η παραγγελία μου έχει φύγει;","Λυπάμαι, αλλά δεν έχω πρόσβαση σε πληροφορίες σχετικά με την κατάσταση της παραγγελίας σας. Για να λάβετε ενημέρωση, μπορείτε να επικοινωνήσετε μαζί μας μέσω email στο pro@likeme.gr. Αν θέλετε, μπορώ να σας βοηθήσω να δημιουργήσετε ένα αίτημα ή να σας καθοδηγήσω στη διαδικασία.","b9ceba69-9eab-4fa9-a89f-1df79574e002","{\"show_as_quick_option\":false}","1769507224"),
("6","qa","Έκανα παραγγελία τη λάβατε αλλά δε μου ήρθε μεηλ επιβεβαίωσης","Θα πρότεινα να ελέγξεις τα spam του email σου. Αν δεν το βρίσκεις ούτε εκεί, το τελευταίο διάστημα παρατηρείται ένα πρόβλημα στα Gmail, emails και πιθανόν να το μπλοκάρει ο λογαριασμός σας. Αν σας εμφάνισαι πάντως το σύστημα ότι ολοκληρώθηκε η παραγγελία σας, σίγουρα την έχουμε λάβει και άμεσα θα αποσταλεί. Εάν θέλετε συμπληρώστε την φόρμα επικοινωνίας, ενημερώστε για το πρόβλημα του Email και θα σας ενημερώσουμε για την εξέλιξη με sms.","bed0d224-1cdc-43ba-84c9-6a0ebfd1ed36","{\"show_as_quick_option\":false}","1769507233"),
("7","post","Gtranslate","<link rel=\"stylesheet\" id=\"wd-text-block-css\" href=\"https://staging.promarketing.gr/wp-content/themes/woodmart/css/parts/el-text-block.min.css?ver=8.3.8\" type=\"text/css\" media=\"all\" />\n\nMetadata:\n{\n    \"featured_image\": false,\n    \"excerpt\": \"\",\n    \"modified_date\": \"2026-01-27 11:33:08\",\n    \"permalink\": \"https:\\/\\/staging.promarketing.gr\\/?cms_block=gtranslate\",\n    \"categories\": [],\n    \"tags\": []\n}","e97b8773-db55-4422-a01f-025ce77c2d49","{\"post_id\":242}","1769590750"),
("8","post","Φόρμα Αλλαγής &#8211; Επιστροφής","<h2>Φόρμα Επιστροφής Προϊόντων - Χρημάτων</h2>		<p><strong>Η παρακάτω φόρμα είναι υποχρεωτική. Συμπληρώστε την αφού παραδώσετε το δέμα στην Elta Courier για επιστροφή για να συμπληρώσετε τον κωδικό αποστολής που θα λάβετε από την Elta Courier.</strong></p><p>ΠΡΟΣΟΧΗ: ΓΙΑ ΠΑΡΑΓΓΕΛΙΕΣ ΜΕΣΩ SKROUTZ MARKETPLACE ΕΠΙΣΤΡΟΦΕΣ ΓΙΝΟΝΤΑΙ ΜΟΝΟ ΜΕΣΩ ΤΟΥ SKROUTZ ΚΑΙ ΟΧΙ ΜΕΣΩ ΑΥΤΗΣ ΤΗΣ ΦΟΡΜΑΣ!</p><p>Δεν δεχόμαστε δέματα από άλλες Courier εκτός από τα Elta Courier.</p><p>Τα χρήματα θα επιστραφούν στον λογαριασμό σας εντός 5 εργάσιμων ημερών από την παραλαβή του δέματος - προϊόντων.</p><p>Παρακαλούμε συμπληρώστε όλα τα παρακάτω πεδία για να επιστραφούν τα χρήματα στον λογαριασμό σας για τα προϊόντα που θέλετε να επιστρέψετε ή να αλλάξετε.</p><p>Η διαδικασία είναι απλή καθώς θα επιστραφούν τα χρήματα για τα προϊόντα που δεν θέλετε να κρατήσετε ή να αλλάξετε και μπορείτε να κάνετε εκ νέου παραγγελία τα προϊόντα που θέλετε.</p><p>Για παραγγελίες που πληρώθηκαν με κάρτα δεν χρειάζεται να συμπληρώσετε στοιχεία τραπέζης.</p>		\n					<link rel=\'stylesheet\' id=\'wp-block-library-css\' href=\'https://staging.promarketing.gr/wp-includes/css/dist/block-library/style.min.css?ver=6.9\' media=\'all\' />\nPlease select form to show\n\nMetadata:\n{\n    \"featured_image\": false,\n    \"excerpt\": \"\\u03a6\\u03cc\\u03c1\\u03bc\\u03b1 \\u0395\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ae\\u03c2 \\u03a0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03c9\\u03bd &#8211; \\u03a7\\u03c1\\u03b7\\u03bc\\u03ac\\u03c4\\u03c9\\u03bd \\u0397 \\u03c0\\u03b1\\u03c1\\u03b1\\u03ba\\u03ac\\u03c4\\u03c9 \\u03c6\\u03cc\\u03c1\\u03bc\\u03b1 \\u03b5\\u03af\\u03bd\\u03b1\\u03b9 \\u03c5\\u03c0\\u03bf\\u03c7\\u03c1\\u03b5\\u03c9\\u03c4\\u03b9\\u03ba\\u03ae. \\u03a3\\u03c5\\u03bc\\u03c0\\u03bb\\u03b7\\u03c1\\u03ce\\u03c3\\u03c4\\u03b5 \\u03c4\\u03b7\\u03bd \\u03b1\\u03c6\\u03bf\\u03cd \\u03c0\\u03b1\\u03c1\\u03b1\\u03b4\\u03ce\\u03c3\\u03b5\\u03c4\\u03b5 \\u03c4\\u03bf \\u03b4\\u03ad\\u03bc\\u03b1 \\u03c3\\u03c4\\u03b7\\u03bd Elta Courier \\u03b3\\u03b9\\u03b1 \\u03b5\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ae \\u03b3\\u03b9\\u03b1 \\u03bd\\u03b1 \\u03c3\\u03c5\\u03bc\\u03c0\\u03bb\\u03b7\\u03c1\\u03ce\\u03c3\\u03b5\\u03c4\\u03b5 \\u03c4\\u03bf\\u03bd \\u03ba\\u03c9\\u03b4\\u03b9\\u03ba\\u03cc \\u03b1\\u03c0\\u03bf\\u03c3\\u03c4\\u03bf\\u03bb\\u03ae\\u03c2 \\u03c0\\u03bf\\u03c5 \\u03b8\\u03b1 \\u03bb\\u03ac\\u03b2\\u03b5\\u03c4\\u03b5 \\u03b1\\u03c0\\u03cc \\u03c4\\u03b7\\u03bd Elta Courier. \\u03a0\\u03a1\\u039f\\u03a3\\u039f\\u03a7\\u0397: \\u0393\\u0399\\u0391 \\u03a0\\u0391\\u03a1\\u0391\\u0393\\u0393\\u0395\\u039b\\u0399\\u0395\\u03a3 \\u039c\\u0395\\u03a3\\u03a9 SKROUTZ MARKETPLACE \\u0395\\u03a0\\u0399\\u03a3\\u03a4\\u03a1\\u039f\\u03a6\\u0395\\u03a3 \\u0393\\u0399\\u039d\\u039f\\u039d\\u03a4\\u0391\\u0399 \\u039c\\u039f\\u039d\\u039f \\u039c\\u0395\\u03a3\\u03a9 \\u03a4\\u039f\\u03a5 SKROUTZ \\u039a\\u0391\\u0399 \\u039f\\u03a7\\u0399 \\u039c\\u0395\\u03a3\\u03a9 \\u0391\\u03a5\\u03a4\\u0397\\u03a3 \\u03a4\\u0397\\u03a3 \\u03a6\\u039f\\u03a1\\u039c\\u0391\\u03a3! \\u0394\\u03b5\\u03bd \\u03b4\\u03b5\\u03c7\\u03cc\\u03bc\\u03b1\\u03c3\\u03c4\\u03b5 \\u03b4\\u03ad\\u03bc\\u03b1\\u03c4\\u03b1 \\u03b1\\u03c0\\u03cc \\u03ac\\u03bb\\u03bb\\u03b5\\u03c2 Courier \\u03b5\\u03ba\\u03c4\\u03cc\\u03c2 \\u03b1\\u03c0\\u03cc \\u03c4\\u03b1 Elta Courier. \\u03a4\\u03b1 \\u03c7\\u03c1\\u03ae\\u03bc\\u03b1\\u03c4\\u03b1 \\u03b8\\u03b1 \\u03b5\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03b1\\u03c6\\u03bf\\u03cd\\u03bd \\u03c3\\u03c4\\u03bf\\u03bd \\u03bb\\u03bf\\u03b3\\u03b1\\u03c1\\u03b9\\u03b1\\u03c3\\u03bc\\u03cc \\u03c3\\u03b1\\u03c2 \\u03b5\\u03bd\\u03c4\\u03cc\\u03c2 5 \\u03b5\\u03c1\\u03b3\\u03ac\\u03c3\\u03b9\\u03bc\\u03c9\\u03bd \\u03b7\\u03bc\\u03b5\\u03c1\\u03ce\\u03bd \\u03b1\\u03c0\\u03cc \\u03c4\\u03b7\\u03bd \\u03c0\\u03b1\\u03c1\\u03b1\\u03bb\\u03b1\\u03b2\\u03ae \\u03c4\\u03bf\\u03c5 \\u03b4\\u03ad\\u03bc\\u03b1\\u03c4\\u03bf\\u03c2 &#8211; \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03c9\\u03bd. \\u03a0\\u03b1\\u03c1\\u03b1\\u03ba\\u03b1\\u03bb\\u03bf\\u03cd\\u03bc\\u03b5 \\u03c3\\u03c5\\u03bc\\u03c0\\u03bb\\u03b7\\u03c1\\u03ce\\u03c3\\u03c4\\u03b5 \\u03cc\\u03bb\\u03b1 \\u03c4\\u03b1 \\u03c0\\u03b1\\u03c1\\u03b1\\u03ba\\u03ac\\u03c4\\u03c9 \\u03c0\\u03b5\\u03b4\\u03af\\u03b1 \\u03b3\\u03b9\\u03b1 \\u03bd\\u03b1 \\u03b5\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03b1\\u03c6\\u03bf\\u03cd\\u03bd \\u03c4\\u03b1 \\u03c7\\u03c1\\u03ae\\u03bc\\u03b1\\u03c4\\u03b1 \\u03c3\\u03c4\\u03bf\\u03bd \\u03bb\\u03bf\\u03b3\\u03b1\\u03c1\\u03b9\\u03b1\\u03c3\\u03bc\\u03cc \\u03c3\\u03b1\\u03c2 \\u03b3\\u03b9\\u03b1 \\u03c4\\u03b1 \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03b1 \\u03c0\\u03bf\\u03c5 \\u03b8\\u03ad\\u03bb\\u03b5\\u03c4\\u03b5\",\n    \"modified_date\": \"2026-01-26 14:37:04\",\n    \"permalink\": \"https:\\/\\/staging.promarketing.gr\\/forma-allagis-epistrofis\\/\",\n    \"categories\": [],\n    \"tags\": []\n}","8c0b4639-2b24-4834-ada9-1f78b7a8dc8f","{\"post_id\":207}","1769590752"),
("9","post","Όροι &amp; Προϋποθέσεις","<p>ΕΙΣΑΓΩΓΗ<br />Το likeme.gr είναι ο «Δικτυακός τόπος» και το «Ηλεκτρονικό Κατάστημα» έκθεσης και διάθεσης προϊόντων μέσω του Διαδικτύου, το οποίο ανήκει στην ελληνική επιχείρηση με την επωνυμία «ProMarketing-ΑΔΑΜΟΠΟΥΛΟΣ ΑΝΔΡΕΑΣ» που εδρεύει στην διεύθυνση Δοϊράνης 9, Καλλιθέα, Αττικής, 17671 με ΑΦΜ 133620153, ΔΟΥ: Καλλιθέας και αριθμό ΓΕΜΗ 159378403000 (εφεξής το «LikeMe.» ή η «Επιχείρηση»).</p><p>Οι παρόντες Γενικοί Όροι και προϋποθέσεις χρήσης του δικτυακού τόπου και αγοράς των προϊόντων/υπηρεσιών του ηλεκτρονικού μας καταστήματος (εφεξής οι «Όροι Χρήσης και Συναλλαγών» ή οι «Όροι Χρήσης»), καθορίζουν τους όρους και τις προϋποθέσεις περιήγησης σας στο Δικτυακό μας τόπο και χρήσης αυτού και του ηλεκτρονικού μας καταστήματος και διέπουν τη σύμβαση πώλησης που συνάπτεται μεταξύ μας για την αγορά προϊόντων από το ηλεκτρονικό μας κατάστημα.</p><p>Πριν εισέλθετε στο ηλεκτρονικό μας κατάστημα σας καλούμε να συμβουλευτείτε τους ‘Όρους Χρήσης και Συναλλαγών και να βεβαιωθείτε ότι συμφωνείτε με αυτούς.</p><p>Σε περίπτωση διαφωνίας σας με οποιονδήποτε από τους παρόντες Όρους Χρήσης, οφείλετε να μην προβείτε σε καμία ενέργεια τόσο στο Δικτυακό μας τόπο όσο και στο ηλεκτρονικό μας κατάστημα, συμπεριλαμβανομένης και της απλής περιήγησής σας σε αυτό.</p><p>Οποιαδήποτε ωστόσο ενέργεια σας στο ηλεκτρονικό μας κατάστημα, όπως ενδεικτικά η περιήγησή σας σε αυτό, η εγγραφή σας στο newsletter της Επιχείρησης μας, ή η αγορά προϊόντων μας, λογίζεται ως ανεπιφύλακτη αποδοχή των παρόντων Όρων Χρήσης και Συναλλαγών.</p><p>Το LikeMe.gr, διατηρεί το δικαίωμα να τροποποιεί ή να ανανεώνει μονομερώς τους παρόντες Όρους Χρήσης κατά την απόλυτη διακριτική του ευχέρεια ή/και όταν η τροποποίηση επιβάλλεται από το νόμο, ενδεχομένως και χωρίς προηγούμενη ειδοποίηση σας, πάντα ωστόσο στα πλαίσια των συναλλακτικών ηθών και των ορίων που θέτει ο νόμος.</p><p>Το LikeMe.gr αναλαμβάνει την υποχρέωση να σας ενημερώνει για τυχόν τροποποιήσεις καθώς και για οποιαδήποτε αλλαγή, μέσω του Δικτυακού τόπου.</p><p>Οι τυχόν τροποποιήσεις θα ισχύουν από την ημερομηνία ανάρτησης τους στον παρόντα Δικτυακό τόπο.</p><p>Διευκρινίζεται ότι τυχόν αλλαγή των παρόντων Όρων Χρήσης δεν περιλαμβάνει παραγγελίες τις οποίες έχετε ήδη διενεργήσει μέσα στο ηλεκτρονικό μας κατάστημα, πριν την έναρξη ισχύος των τροποποιήσεων σύμφωνα με τα ανωτέρω.</p><p>Η χρήση του LikeMe.gr μετά την ως άνω αναφερόμενη τροποποίηση, λογίζεται ως αποδοχή των Όρων Χρήσης, όπως αυτοί τροποποιήθηκαν.</p><p>Η χρήση του παρόντος Δικτυακού τόπου από εσάς και οποιαδήποτε συναλλαγή σας στο ηλεκτρονικό μας κατάστημα, γίνεται με δική σας αποκλειστικά ευθύνη.</p><p>ΙΙ. ΥΠΗΡΕΣΙΕΣ ΔΙΚΤΥΑΚΟΥ ΤΟΠΟΥ – ΗΛΕΚΤΡΟΝΙΚΟΥ ΚΑΤΑΣΤΗΜΑΤΟΣ</p><p>Α. ΠΑΡΟΧΗ ΠΛΗΡΟΦΟΡΙΩΝ</p><p>Οι πληροφορίες που παρέχονται από τον παρόντα Δικτυακό τόπο είναι πλήρεις, αληθείς, έγκυρες και επικαιροποιημένες, είτε αυτές αφορούν στην ταυτότητά μας, είτε στα παρεχόμενα προϊόντα/υπηρεσίες από το ηλεκτρονικό μας κατάστημα.</p><p>Οι ανωτέρω εγγυήσεις τελούν υπό την επιφύλαξη τυχόν τεχνικών ή τυπογραφικών λαθών, τα οποία δεν μπορούν να προβλεφθούν ή έχουν προκύψει ακούσια ή λόγω διακοπών λειτουργίας του παρόντος δικτυακού τόπου ή και λόγω ανωτέρας βίας.</p><p>Το LikeMe.gr έχει λάβει όλα τα απαραίτητα τεχνικά και άλλα μέσα προκειμένου να ενημερώνεται άμεσα η διαθέσιμη ποσότητα και μεγέθη των προϊόντων μας, ωστόσο διατηρεί ρητή επιφύλαξη αναφορικά με τη εγκυρότητα των διαθέσιμων στο ηλεκτρονικό κατάστημα ποσοτήτων και μεγεθών των προϊόντων, καθόσον ενδέχεται η ενημέρωση τους να πραγματοποιείται μέσα σε τρεις (3) ημέρες, από την στιγμή της τροποποίησης τους.</p><p>Β. ΕΓΓΡΑΦΗ ΜΕΛΟΥΣ</p><p>Η εγγραφή σας ως Μέλος στο LikeMe.gr είναι επιθυμητή αλλά όχι απαραίτητη προκειμένου να διενεργήσετε μια αγορά από το Ηλεκτρονικό μας κατάστημα.</p><p>Με την εισαγωγή των ζητηθέντων προσωπικών σας στοιχείων (όνομα και επώνυμο, διεύθυνση, ταχυδρομικό κωδικό της τρέχουσας κύριας κατοικίας, τηλέφωνο, ισχύουσα διεύθυνση ηλεκτρονικού σας ταχυδρομείου (email), φύλο και ημερομηνία γεννήσεως) και την αποδοχή των παρόντων Όρων Χρήσης και Συναλλαγών, γίνεστε Μέλος στο LikeMe.gr και σας ανοίγουμε δικό σας Λογαριασμό Μέλους.</p><p>Η εγγραφή και η συμμετοχή ως μέλος είναι δωρεάν, είναι προσωπική, αμεταβίβαστη και ανεκχώρητη.</p><p>Φέρετε εσείς την ευθύνη για τα στοιχεία που μας χορηγείτε και το LikeMe.gr βασίζεται αποκλειστικώς και μόνον στις δηλώσεις σας αναφορικά με τα προσωπικά σας στοιχεία.</p><p>Τα προσωπικά σας στοιχεία που μας χορηγείτε κατά την εγγραφή σας ως Μέλος, η Επιχείρηση μας τα επεξεργάζεται αποκλειστικά για το σκοπό:</p><p>(α) Της δημιουργίας Λογαριασμού σας στο LikeMe.gr μέσω του οποίου μπορείτε να παρακολουθείτε την πορεία της παραγγελίας σας, το ιστορικό των συναλλαγών σας στο LikeMe.gr κτλ..</p><p>(β) Της επικοινωνίας μας μαζί σας αναφορικά με τις μεταξύ μας συναλλαγές (π.χ. για να διασφαλισθεί η δυνατότητα επικοινωνίας μαζί σας, για την ολοκλήρωση, αποστολή και παράδοση της παραγγελίας σας, για την εξόφληση και την ασφαλή οικονομική μας συναλλαγή).</p><p>Έχετε τη δυνατότητα, οποιαδήποτε στιγμή, να έχετε πρόσβαση στα δεδομένα σας, ή μπορείτε επίσης οποιαδήποτε στιγμή να ζητήσετε την άμεση διαγραφή ή διόρθωση των στοιχείων σας, την προσωρινή μη χρησιμοποίηση τους από το LikeMe.gr, τη δέσμευση ή μη διαβίβασή τους, ακολουθώντας την ίδια ως άνω διαδικασία αποστολής email σε εμάς.</p><p>Σε κάθε περίπτωση πάντως τα στοιχεία σας διατηρούνται από την Επιχείρηση μας μόνο για όσο χρόνο είστε εγγεγραμμένο Μέλος του LikeMe.gr.</p><p>Τα προσωπικά σας δεδομένα δεν ανακοινώνονται σε κανέναν τρίτο και τυγχάνουν διαχείρισης αποκλειστικά από το LikeMe.gr.</p><p>Όλα τα προσωπικά σας στοιχεία, τα οποία συλλέγονται μέσω της ειδικής ηλεκτρονικής φόρμας του LikeMe.gr είναι τα απολύτως απαραίτητα για τη διενέργεια των ως άνω υπηρεσιών και η εγγραφή σας δηλώνει την πλήρη συγκατάθεσή σας.</p><p>Αναφορικά με τη συλλογή και επεξεργασία των προσωπικών σας δεδομένων, ισχύουν οι όροι και διατάξεις της Πολιτικής Προστασίας Προσωπικών Δεδομένων του LikeMe.gr.</p><p>Το LikeMe.gr δεν παραδίδει σε τρίτους πληροφορίες σχετικά με όνομα, επώνυμο, διεύθυνση κατοικίας ή άλλα προσωπικά σας δεδομένα.</p><p>ΣΥΣΤΗΜΑ ΑΝΤΑΜΟΙΒΗΣ ΠΟΝΤΩΝ</p><p>Για να μπορέσετε να χρησιμοποιήσετε το σύστημα ανταμοιβής πόντων θα πρέπει να έχετε εγγραφεί ως Μέλος του LikeMe.gr. Μέσω του προσωπικού σας λογαριασμού μπορείτε να παρακολουθείτε τους πόντους σας από την αντίστοιχη ενότητα που ορίζεται ως “Οι πόντοι μου”.</p><p>Κάθε ευρώ αγορών αντιστοιχεί σε 2 πόντους και για κάθε 100 πόντους κερδίζετε 2 ευρώ έκπτωση. Οι πόντοι συλλέγονται αθροιστικά μέχρις ώτου συγκεντρώσετε συνολικά από τις αγορές σας 1000 πόντους, οι οποίοι αντιστοιχούν σε έκπτωση 20 ευρώ. Κατά την ολοκλήρωση κάθε παραγγελίας σας εμφανίζεται το σύνολο των πόντων που έχετε συλλέξει. Όταν το σύνολο αυτό ανέλθει στους 1000 πόντους διατίθεται η επιλογή εξαργύρωσης “Εφαρμογή Έκπτωσης”, η οποία και εφαρμόζεται στην τρέχουσα παραγγελία.</p><p>Η εξαργύρωση των πόντων αφορά μόνο σε εκπτωτικό δικαίωμα επί των αγορών σας στο ηλεκτρονικό κατάστημα LikeMe.gr και όχι σε οποιοδήποτε φυσικό κατάστημα. Σε καμία περίπτωση o λογαριασμός, ο αριθμός των πόντων και τα δικαιώματα που απορρέουν από αυτούς δεν μπορούν να εξαργυρωθούν με χρήματα. Το LikeMe διατηρεί το δικαίωμα να τροποποιεί μονομερώς το σύστημα ανταμοιβής και να μεταβάλλει ή να αντικαθιστά το ύψος επιβράβευσης των αγορών.</p><p>Με την χρήση της εκάστοτε έκπτωσης, οι αντίστοιχοι πόντοι αφαιρούνται από το λογαριασμό σας. Εφόσον οι πόντοι εξαργυρωθούν, δεν δύναται να γίνει ακύρωση της εξαργύρωσης και επιστροφή των πόντων.</p><p>Σε περίπτωση που η επιστροφή προϊόντος, για την αγορά του οποίου πιστώθηκε στον λογαριασμό αντίστοιχος αριθμός πόντων, συνδυάζεται με επιστροφή χρημάτων, οι πόντοι που αντιστοιχούν στο ποσό της επιστροφής αφαιρούνται από το σύνολο των εξαργυρώσιμων πόντων. Σε περίπτωση επιστροφής χρημάτων, η επιστροφή γίνεται στη πληρωτέα αξία. Σε περίπτωση που επιστρέψετε το σύνολο ή μέρος των προϊόντων που αγοράσατε και από τα οποία κερδίσατε πόντους ή/και αλλάξετε τα προϊόντα αυτά με άλλα, τότε το σύνολο των πόντων που συλλέχθηκαν για την συγκεκριμένη παραγγελία διαμορφώνεται εξαρχής και σύμφωνα με τα δεδομένα της τελικής παραγγελίας.</p><p>Οι πόντοι που δικαιούστε μετά από κάθε συναλλαγή θα πιστώνονται την ίδια ημέρα της συναλλαγής. Το σύνολο των πόντων που αντιστοιχούν στην παραγγελία σας θα είναι διαθέσιμο επίσης την ίδια ημέρα της συναλλαγής.</p><p>Γ. ΔΙΕΝΕΡΓΕΙΑ ΑΓΟΡΑΣ ΜΕΣΩ ΤΟΥ ΚΑΤΑΣΤΗΜΑΤΟΣ</p><p>ΠΑΡΑΓΓΕΛΙΑ<br />1.1. Ολοκλήρωση – Επιβεβαίωση Παραγγελίας.</p><p>Μπορείτε να ολοκληρώσετε την παραγγελία σας, ως επισκέπτης ή ως μέλος.</p><p>Κατά τη διάρκεια της ολοκλήρωσης της παραγγελίας σας το σύστημα θα σας καθοδηγήσει αυτόματα στην πολύ απλή και γρήγορη διαδικασία εγγραφής.</p><p>Αν επιθυμείτε να κάνετε την αγορά σας ως επισκέπτης, τα στοιχεία σας δεν θα αποθηκευτούν για καμία μελλοντική χρήση (εκτός των στοιχείων που αφορούν τις φορολογικές αρχές).</p><p>Για να ολοκληρωθεί η παραγγελία πρέπει να επιλέξετε ένα τρόπο πληρωμής, από τους διαθέσιμους και να αποδεχθείτε τους παρόντες όρους.</p><p>Οι τιμές που αναγράφονται στα προϊόντα μας συμπεριλαμβάνουν το Φ.Π.Α. και θεωρούνται τελικές.</p><p>Τα έξοδα αποστολής και αντικαταβολής, εφόσον προκύπτουν προστίθενται στο τελικό ποσό πληρωμής και αναγράφονται ευκρινώς στην τελική φόρμα παραγγελίας, την οποία και σας αποστέλουμε στην ηλεκτρονική σας διεύθυνση.</p><p>Με την υποβολή της παραγγελίας σας, θα σας στείλει ένα μήνυμα στον λογαριασμό του email που μας έχετε δηλώσει, το οποίο θα σας γνωστοποιεί:</p><p>Ότι παραλάβαμε την παραγγελία.</p><p>Τα προϊόντα που έχετε παραγγείλει.</p><p>Τα έξοδα αποστολής και αντικαταβολής, εφόσον προκύπτουν.</p><p>Τον τρόπο πληρωμής.</p><p>Και όλους τους όρους της παραγγελίας.</p><p>1.2. Ακύρωση Παραγγελίας.</p><p>Ακύρωση της παραγγελίας σας δύναται να γίνει:</p><p>1.2.1. Πριν ολοκληρωθεί η παραγγελία.</p><p>Πριν υποβάλλετε την παραγγελία σας, έχετε τη δυνατότητα τεχνικά να κάνετε πίσω «επιστροφή στο καλάθι» και να αφαιρέσετε τις ποσότητες των προϊόντων από το καλάθι σας που δεν επιθυμείτε να παραγγείλετε πατώντας στο κουμπί «αφαίρεση».</p><p>1.2.2. Μετά την ολοκλήρωση της παραγγελίας αλλά πριν την παραλαβή των προϊόντων.</p><p>Εάν έχει ολοκληρωθεί η ηλεκτρονική παραγγελία αλλά δεν έχει αποσταλεί ακόμα, μπορείτε να την ακυρώσετε με αποστολή email στην ηλεκτρονική διεύθυνση info@LikeMe.gr.</p><p>1.2.3. Μετά την παραλαβή της παραγγελίας.</p><p>Τυχόν άρνησή σας να παραλάβετε τα προϊόντα σας κατά την παράδοση από την Επιχείρηση μεταφοράς, ισοδυναμεί με το δικαίωμα υπαναχώρησης σας.</p><p>Σε κάθε περίπτωση σας ενημερώνουμε ότι σε περίπτωση υπαναχώρησης σας, το LikeMe.gr καταγράφει το γεγονός σε ειδικό αρχείο.</p><p>Στην περίπτωση δεύτερης παραγγελίας, μετά από προηγούμενη άρνηση παραλαβής από τον ίδιο πελάτη, το LikeMe.gr θα επικοινωνήσει με τον πελάτη, για να επιβεβαιώσει την νέα παραγγελία.</p><p>Στην περίπτωση που αρνηθεί και δεύτερη φορά να παραλάβει την παραγγελία του, ο ίδιος πελάτης, τότε οποιαδήποτε επόμενη παραγγελία του πληρώνεται με τραπεζική κατάθεση.</p><p>1.2.4. Μετά την παραλαβή της παραγγελίας, λόγω λάθους, λόγω ελαττωματικών προϊόντων, λόγω απώλειας.</p><p>Μετά την παραλαβή ακυρώνεται η παραγγελία σας, σε περίπτωση που παραλάβετε ελαττωματικό προϊόν, λάθος προϊόν (που δεν περιλαμβάνεται στην τελική φόρμα παραγγελίας) ή δεν παραλάβετε κάποιο προϊόν ποτέ λόγω απώλειας.</p><p>ΑΠΟΣΤΟΛΗ ΚΑΙ ΠΑΡΑΔΟΣΗ ΠΡΟΪΟΝΤΩΝ<br />2.1. Έξοδα αποστολής.</p><p>Οι αποστολή των προϊόντων της παραγγελίας σας, επιβαρύνεται με έξοδα αποστολής και αντικαταβολής (εφόσον προκύψουν) τα οποία προστίθενται στο τελικό ποσό πληρωμής και αναγράφονται ευκρινώς στην τελική φόρμα παραγγελίας.</p><p>2.2. Τόπος – Ημερομηνίες και ώρες παράδοσης.</p><p>Οι ημέρες παράδοσης των προϊόντων σας, ορίζονται από τα ωράρια λειτουργίας της Μεταφορικής επιχείρησης που αναλαμβάνει την μεταφορά τους και γίνεται στον τόπο παράδοσης που έχετε δηλώσει στην φόρμα παραγγελίας σας.</p><p>Εάν η παραγγελία σας ολοκληρωθεί μέχρι τις 12:30μμ, τα προϊόντα παραδίδονται εντός τριών εργάσιμων ημερών.</p><p>Σε περίπτωση που η παραγγελία σας ολοκληρωθεί με την υποβολή της σε εμάς μετά την 12:30μμ, ο χρόνος παράδοσης αυξάνει κατά μια εργάσιμη ημέρα.</p><p>Οι ανωτέρω προθεσμίες δεν ισχύουν σε περιόδους ακραίων καιρικών φαινομένων ή απεργιών και σε κάθε περίπτωση ανωτέρας βίας, που δύναται να επηρεάσει τους χρόνους μεταφοράς και παράδοσης.</p><p>2.3. Καθυστέρηση Παράδοσης.</p><p>Η Επιχείρηση μας καταβάλλει κάθε δυνατή προσπάθεια για την έγκαιρη και προσήκουσα παράδοση των προϊόντων σας, ωστόσο διατηρούμε την επιφύλαξη ότι η παράδοση του(ων) προϊόντος(ων) σας δύναται να καθυστερήσει σε περίπτωση που:</p><p>(α) Το προϊόν δεν βρίσκεται στην αποθήκη μας και καθυστερήσει να σταλεί από τον προμηθευτή μας.</p><p>(β) Το προϊόν που παραγγείλατε έχει ήδη καταργηθεί και δεν είναι διαθέσιμο λόγω ξαφνικής και απροειδοποίητης ανακοίνωσης του προμηθευτή περί κατάργησης του εν λόγω προϊόντος.</p><p>(γ) Υφίσταται γεγονός ανωτέρας βίας όπως ενδεικτικά ακραία καιρικά φαινόμενα, απεργίες, ή κάθε άλλο γεγονός έξω από τη σφαίρα επιρροής και ελέγχου μας το οποίο δύναται να επηρεάσει τη μεταφορά και παράδοση της παραγγελιάς σας.</p><p>Στις ανωτέρω περιπτώσεις θα επικοινωνήσουμε μαζί σας για να σας ρωτήσουμε εάν θέλετε να σας παραδώσουμε την παραγγελία χωρίς το προϊόν που έχει καθυστερήσει ή δεν είναι διαθέσιμο, ή να σας προτείνουμε κάποιο εναλλακτικό, ή να σας ενημερώσουμε για το χρόνο παράδοσης του προϊόντος που δεν είναι άμεσα διαθέσιμο.</p><p>Σε περίπτωση που δε σας ικανοποιεί η πρότασή μας, έχετε το δικαίωμα να ακυρώσετε την παραγγελία εν μέρει ή στο σύνολό της και να σας επιστρέψουμε τυχόν χρήματα που έχετε καταβάλλει.</p><p>Σε περίπτωση καθυστέρησης μπορείτε να επικοινωνήσετε με τo LikeMe τηλεφωνικά, ή, στο email info@LikeMe.gr, για να δηλώσετε την υπαναχώρησή σας στο σύνολο της παραγγελίας ή σε μέρος αυτής.</p><p>ΤΡΟΠΟΙ ΠΛΗΡΩΜΗΣ<br />3.1. Μέθοδος Αντικαταβολής – Πληρωμή με την παραλαβή της παραγγελίας.</p><p>Όταν έρθει στο χώρο σας ο υπάλληλος της ταχυμεταφορικής εταιρείας για να σας παραδώσει τα προϊόντα σας, πληρώνετε μετρητά την αξία της παραγγελίας σας και τα έξοδα που τυχόν προκύπτουν (π.χ. έξοδα μεταφοράς, αντικαταβολή), όπως αναφέρονται στην φόρμα που έχετε παραλάβει, στην ηλεκτρονική σας διεύθυνση.</p><p>3.2. Πληρωμή με Χρεωστική ή Πιστωτική Κάρτα.</p><p>Μπορείτε να πληρώσετε την αξία της παραγγελίας σας και τα έξοδα που τυχόν προκύπτουν, όπως αναφέρονται στην φόρμα της παραγγελίας σας (π.χ. έξοδα μεταφοράς), με πιστωτική κάρτα, ή χρεωστική κάρτα (εφόσον είναι διαθέσιμος τρόπος πληρωμής).</p><p>3.3. Πληρωμή με κατάθεση σε Τραπεζικό Λογαριασμό.</p><p>Μπορείτε να πληρώσετε την αξία της παραγγελίας σας και τα έξοδα που τυχόν προκύπτουν, με κατάθεση σε τραπεζικό λογαριασμό της εταιρίας μας (εφόσον είναι διαθέσιμος τρόπος πληρωμής).</p><p>Για την καλύτερη εξυπηρέτηση σας, παρακαλείστε να αναγράψετε τον κωδικό της παραγγελίας σας, κατά την κατάθεση του ποσού.</p><p>3.4. Ασφάλεια.</p><p>Το LikeMe δεν διαχειρίζεται τις προσωπικές πληροφορίες, συμπεριλαμβανομένων των αριθμών πιστωτικών καρτών και των αριθμών των τραπεζικών λογαριασμών, των χρηστών που επιλέγουν Πληρωμή με Χρεωστική ή Πιστωτική Κάρτα, ή, Πληρωμή με κατάθεση σε Τραπεζικό Λογαριασμό.</p><p>Αυτές οι διαδικασίες προστατεύονται από οποιαδήποτε μη επιτρεπόμενη πρόσβαση ή αποκάλυψη, απώλεια ή κακή χρήση και αλλαγή ή καταστροφή, από τα πιστωτικά ιδρύματα που διεκπεραιώνουν τις συναλλαγές.</p><p>Η σύνδεσή των χρηστών στο LikeMe.gr είναι ασφαλές, διότι χρησιμοποιεί τεχνολογία SSL (Secure Socket Layer) με κρυπτογράφηση AES 256 bit.</p><p>Η τεχνολογία SSL στηρίζεται σε ένα κωδικό κλειδί για κρυπτογράφηση των δεδομένων πριν αποσταλούν μέσω της (SSL) σύνδεσης.</p><p>Ο έλεγχος ασφαλείας μεταξύ των δεδομένων και του Server γίνεται με βάση το μοναδικό κωδικό κλειδί διασφαλίζοντας στο ακέραιο την επικοινωνία.</p><p>Το πρωτόκολλο SSL (Secure Sockets Layer) είναι σήμερα το παγκόσμιο standard στο Διαδίκτυο για την πιστοποίηση δικτυακών τόπων (web sites) στους δικτυακούς χρήστες και για την κρυπτογράφηση στοιχείων μεταξύ των δικτυακών χρηστών και των δικτυακών εξυπηρετητών (web servers).</p><p>ΥΠΑΝΑΧΩΡΗΣΗ – ΑΚΥΡΩΣΗ ΠΑΡΑΓΓΕΛΙΑΣ<br />4.1. Προϋποθέσεις άσκησης δικαιώματος.</p><p>Έχετε στη διάθεσή σας προθεσμία εντός 14 ημερών να υπαναχωρήσετε από την αγορά που τυχόν πραγματοποιήσατε μέσω του ηλεκτρονικού μας καταστήματος, χωρίς να αναφέρετε τους λόγους ή να μας παρέχετε οποιαδήποτε εξήγηση (αναίτια υπαναχώρηση).</p><p>Το δικαίωμα υπαναχώρησης ασκείται όταν θέλετε να επιστρέψετε το προϊόν που αγοράσατε από το ηλεκτρονικό μας κατάστημα, και να λάβετε πίσω τα χρήματά σας.</p><p>Η ως άνω προθεσμία των δεκατεσσάρων (14) για την άσκηση του δικαιώματος υπαναχώρησης, άρχεται από την επόμενη της ημέρας που εσείς ή πρόσωπο που τυχόν εσείς μας υποδείξετε ως αρμόδιο για την παραλαβή των προϊόντων σας (άλλο από τον μεταφορέα) αποκτήσετε τη φυσική κατοχή των αγορασθέντων αγαθών.</p><p>Σε περίπτωση που έχετε παραγγείλει περισσότερα από ένα αγαθά με μια παραγγελία και τα οποία παραδίδονται χωριστά, η προθεσμία ασκήσεως του δικαιώματος υπαναχώρησης σύμφωνα με τα ανωτέρω άρχεται από την επόμενη της ημέρας που εσείς ή πρόσωπο που τυχόν εσείς μας υποδείξετε ως αρμόδιο για την παραλαβή των προϊόντων σας (άλλο από τον μεταφορέα) αποκτήσετε τη φυσική κατοχή του τελευταίου αγαθού.</p><p>4.2. Υποχρεώσεις καταναλωτή κατά την υπαναχώρηση.</p><p>Σε περίπτωση ασκήσεως του δικαιώματος υπαναχώρησης σύμφωνα με τα ανωτέρω, οφείλετε να επιστρέψετε σε εμάς (στη διεύθυνση που αναγράφεται στο παρόν) το προϊόν από την αγορά του οποίου υπαναχωρείτε άμεσα, χωρίς αδικαιολόγητη καθυστέρηση.</p><p>Για τις επιστροφές των προϊόντων, το κόστος της επιστροφής των προϊόντων το αναλαμβάνετε εσείς, εκτός και αν πρόκειται για κατεστραμμένα ή ελαττωματικά προϊόντα που σας έχουμε αποστείλει εμείς, οπότε και το κόστος της επιστροφής το αναλαμβάνουμε εμείς.</p><p>4.3. Υποχρεώσεις LikeMe.gr κατά την υπαναχώρηση.</p><p>Εάν υπαναχωρήσετε από κάποια αγορά σας σύμφωνα με τα οριζόμενα στο παρόν, θα σας επιστρέψουμε όλα τα χρήματα που λάβαμε από εσάς, συμπεριλαμβανομένων των εξόδων αποστολής και των συμπληρωματικών εξόδων που οφείλονται στην επιλογή σας για πληρωμή της παραγγελίας σας με αντικαταβολή, με την επιφύλαξη των όσων ρητά ορίζονται κατωτέρω.</p><p>Η επιστροφή των χρημάτων θα πραγματοποιηθεί άμεσα, χωρίς υπαίτια καθυστέρηση και σε κάθε περίπτωση το αργότερο εντός δεκατεσσάρων(14) ημερών από την ημερομηνία που το LikeMe.gr θα παραλάβει τα προϊόντα που επιστρέψατε σύμφωνα με τα ανωτέρω οριζόμενα και με την επιφύλαξη των διατάξεων του άρθρου ΙΙ. Γ. 4.5.</p><p>Η επιστροφή των χρημάτων γίνεται με πίστωση του τραπεζικού σας λογαριασμού τον οποίο θα γνωστοποιήσετε στο LikeMe.gr κατά την άσκηση του δικαιώματος της υπαναχώρησης.</p><p>Ωστόσο, μπορεί να καθυστερήσει να επιστρέψει τα χρήματα εάν δεν λάβει τα προϊόντα ή απόδειξη για την επιστροφή τους.</p><p>Σε κάθε περίπτωση δε θα χρεωθούν επιπλέον έξοδα για τέτοια επιστροφή χρημάτων εκτός και αν η τράπεζα στην οποία επιθυμείτε να γίνει η κατάθεση δεν είναι μια από τις οποίες συνάπτει συνεργασία και διαθέτει λογαριασμό το LikeMe.gr.</p><p>4.4. Επιστροφή Προϊόντων.</p><p>Δικαιούμαστε να καθυστερήσουμε την επιστροφή των χρημάτων σας μέχρις ότου λάβουμε πίσω τα αγαθά από την αγορά των οποίων υπαναχωρείτε στην ίδια καλή κατάσταση στην οποία τα παραλάβατε.</p><p>Σε περίπτωση υπαναχώρησης σύμφωνα με τα ανωτέρω, διευκρινίζεται ότι τυχόν προϊόντα τα οποία έχετε αγοράσει με κάποια έκπτωση οφειλόμενη στην αγορά του προϊόντος από την οποία υπαναχωρείτε, οφείλετε να τα επιστρέψετε μαζί με το βασικό προϊόν από την αγορά του οποίου υπαναχωρείτε, διαφορετικά η υπαναχώρηση θεωρείται ως μη ασκηθείσα από εσάς και άρα ουδεμία υποχρέωση παράγεται για εμάς.</p><p>Αναγνωρίζετε δε και συναινείτε ότι αποτελεί δική σας ευθύνη η τυχόν μείωση της αξίας των προϊόντων που επιστρέφετε, η οποία (μείωση) επέρχεται ως αποτέλεσμα της διαχείρισης των εν λόγω προϊόντων εκ μέρους σας, πλην εκείνης που είναι αναγκαίας για τη διαπίστωση της φύσης και των ιδιοτήτων των προϊόντων.</p><p>Διευκρινίζεται ωστόσο ότι για να πάρετε πίσω τα χρήματά σας στην περίπτωση της υπαναχώρησης, θα πρέπει το προϊόν να βρίσκεται στην άριστη κατάσταση που παραλήφθηκε χωρίς φθορές και να είναι πλήρες, εντός της αρχικής συσκευασίας του και να συνοδεύονται από όλα τα σχετικά έγγραφα και την απόδειξη αγοράς.</p><p>Όλα τα προϊόντα, που επιστρέφονται θα πρέπει να είναι σε άριστη κατάσταση, να μην έχουν αλλοιωθεί με οποιοδήποτε τρόπο και να διαθέτουν το ειδικό καρτελάκι της σήμανσής τους, σε διαφορετική περίπτωση οι επιστροφές ΔΕΝ θα γίνονται δεκτές.</p><p>Ρούχα και Αξεσουάρ.</p><p>Όλα τα ρούχα και αξεσουάρ που επιστρέφονται θα πρέπει να είναι σε άριστη κατάσταση και να μην έχουν πλυθεί με οποιοδήποτε τρόπο.</p><p>Παπούτσια.</p><p>Όλα τα παπούτσια θα πρέπει να τα δοκιμάζετε σε μαλακή επιφάνεια όπως το χαλί, μέχρι να είστε σίγουροι ότι θέλετε να τα κρατήσετε.</p><p>Τα παπούτσια θα πρέπει επιστρέφονται στην αρχική τους, άθικτη συσκευασία, διότι θεωρείται μέρος του προϊόντος.</p><p>Παπούτσια τα οποία επιστρέφονται χωρίς κουτί ή σε κατεστραμμένο κουτί και με σημαδεμένες σόλες ΔΕΝ θα γίνουν αποδεκτά και θα επιστραφούν πίσω στον καταναλωτή.</p><p>Εσώρουχα.</p><p>Στα εσώρουχα και μαγιό, καθαρά για λόγους υγιεινής, ΔΕΝ ΓΙΝΟΝΤΑΙ ΕΠΙΣΤΡΟΦΕΣ για αυτό παρακαλούμε επιλέξετε με προσοχή το σωστό νούμερο που επιθυμείτε με βάση αυτό που φοράτε συνήθως.</p><p>Το προϊόν που επιστρέφεται θα πρέπει να συνοδεύεται και από όλα τα απαραίτητα παραστατικά που λάβατε με την παραλαβή του, διαφορετικά το LikeMe.gr δεν τα παραλαμβάνει καθόσον συμφωνείτε ότι το δικαίωμα της υπαναχώρησης δεν έχει νομίμως ασκηθεί και σύμφωνα με τους όρους του παρόντος.</p><p>Σε περίπτωση επιστροφής λόγω λάθους εκτίμησης σας (χρώμα, μέγεθος, κ.λπ..), τα προϊόντα δεν ανταλλάσσονται με χρηματικό ποσό και τα μεταφορικά έξοδα και τα έξοδα αντικαταβολής επιβαρύνουν εσάς.</p><p>Δηλαδή, αφαιρούνται από το αρχικό συνολικό ποσό της αγοράς σας:</p><p>α) το σύνολο των μεταφορικών εξόδων της συναλλαγής μας και το κόστος επιστροφής των προϊόντων σε εμάς και το κόστος αντικαταβολής, εφόσον η πληρωμή έχει γίνει ΜΕ αντικαταβολή,</p><p>ή,</p><p>β) το σύνολο των μεταφορικών εξόδων της συναλλαγής μας και το κόστος επιστροφής των προϊόντων σε εμάς, εφόσον η πληρωμή έχει γίνει ΧΩΡΙΣ αντικαταβολή.</p><p>Σε περίπτωση επιστροφής, αποδεδειγμένα ελαττωματικών προϊόντων, τα μεταφορικά έξοδα επιβαρύνουν εμάς.</p><p>Στην περίπτωση που το προς επιστροφή προϊόν,</p><p>α) δεν αποδειχτεί ελαττωματικό,</p><p>β) διαπιστωθεί ότι έχει χρησιμοποιηθεί,</p><p>γ) έχει καταστραφεί η συσκευασία του,</p><p>επιστρέφεται στον αγοραστή με μεταφορικά έξοδα που επιβαρύνουν τον ίδιο.</p><p>ΑΝΤΙΚΑΤΑΣΤΑΣΗ – ΑΛΛΑΓΗ ΠΡΟΪΟΝΤΩΝ<br />Έχετε το δικαίωμα να επιστρέψετε το προϊόν που παραλάβατε, Εκτός των Εσωρούχων και Μαγιό, στα οποία για λόγους υγιεινής ΔΕΝ ΓΙΝΟΝΤΑΙ ΕΠΙΣΤΡΟΦΕΣ, εντός 14 ημερών από την ημερομηνία αποστολής της παραγγελίας και να ζητήσετε την αντικατάστασή του.</p><p>Η επιστροφή των προϊόντων με σκοπό την αντικατάσταση αυτών, δεν αποτελεί ενέργεια υπαναχώρησης εκ μέρους σας και άρα δεν εφαρμόζονται οι διατάξεις του άρθρου ΙΙ. Γ. 4. της παρούσας.</p><p>Ως αλλαγή προϊόντος, εννοούμε την αντικατάσταση του προϊόντος με άλλη παραλλαγή (μέγεθος, χρώμα, κ.λπ..), του ίδιου κωδικού προϊόντος.</p><p>Οι αλλαγές προϊόντων, γίνονται μόνο εφόσον υπάρχουν διαθέσιμες παραλλαγές των προϊόντων.</p><p>Δεν δεχόμαστε αλλαγές ή επιστροφές προϊόντων, με παραβιασμένη συσκευασία, ή χρησιμοποιημένων, ή γενικά με αλλοιωμένη την αρχική τους κατάσταση.</p><p>Δεν δεχόμαστε αλλαγές εσωρούχων και μαγιό, σε καμία περίπτωση, για λόγους υγιεινής.</p><p>(1) Για να επιστρέψετε ένα ή περισσότερα προϊόντα θα πρέπει να επικοινωνήσετε με την εταιρία ταχυμεταφορών (courier) που σας παρέδωσε το δέμα αναφέροντας ότι πρόκειται για επιστροφή προς το LikeMe.gr, προκειμένου να παραλάβει το δέμα προς επιστροφή και να δρομολογηθεί η διαδικασία.</p><p>(2) Στη συνέχεια τοποθετείστε το είδος στη συσκευασία του με το καρτελάκι του, την απόδειξη της παραγγελίας και καταγράψτε τι αλλαγή θέλετε να κάνετε (π.χ. αλλαγή σε νούμερο, σε χρώμα ή αν θέλετε επιστροφή χρημάτων) και παραδώσετε το δέμα στην ταχυμεταφορική (courier).</p><p>(3) Μόλις παραλάβουμε το δέμα, πραγματοποιείται έλεγχος διαθεσιμότητας των προϊόντων που θέλετε να αλλάξετε. Εφόσον το προϊόν/ντα είναι διαθέσιμα, θα κάνουμε την αλλαγή και θα σας το επιστρέψουμε.</p><p>Σε περίπτωση που κάποιο από τα προϊόντα δεν είναι διαθέσιμο θα επικοινωνήσουμε μαζί μας για να συζητήσουμε μαζί την αντικατάσταση της παραγγελίας σας.</p><p>Σε περίπτωση αλλαγής αποδεδειγμένα ελαττωματικών προϊόντων, αυτά δεν ανταλλάσσονται με διαφορετικά προϊόντα ή χρηματικό ποσό, αλλά αντικαθιστούνται.</p><p>Μπορεί να συμφωνηθεί η αντικατάσταση προϊόντος με κάποιο άλλο, διαφορετικό προϊόν, μετά από συνεννόηση των δύο μερών και μόνο εφόσον η επιχείρηση μας διατίθεται να αντικαταστήσει το προϊόν.</p><p>Στην περίπτωση που η αλλαγή γίνεται, κατόπιν συμφωνίας, με ακριβότερο προϊόν, πληρώνετε την διαφορά και το νέο κόστος αντικαταβολής. Φυσικά μπορείτε να αποφύγετε την αντικαταβολή με κατάθεση της διαφοράς στην τράπεζα.</p><p>Σε περίπτωση αλλαγής λόγω λάθους εκτίμησης σας (χρώμα, μέγεθος, κ.λπ..), τα προϊόντα δεν ανταλλάσσονται με χρηματικό ποσό και τα νέα μεταφορικά έξοδα επιβαρύνουν εσάς.</p><p>Σε περίπτωση αλλαγής, αποδεδειγμένα ελαττωματικών προϊόντων, τα μεταφορικά έξοδα επιβαρύνουν εμάς.</p><p>Στην περίπτωση που το προς αλλαγή προϊόν,</p><p>α) δεν αποδειχτεί ελαττωματικό,</p><p>β) διαπιστωθεί ότι έχει χρησιμοποιηθεί,</p><p>γ) έχει καταστραφεί η συσκευασία του,</p><p>επιστρέφεται στον αγοραστή με μεταφορικά έξοδα που επιβαρύνουν τον ίδιο.</p><p>Σε περίπτωση αλλαγής ή επιστροφής, τα προϊόντα θα πρέπει να βρίσκονται στη συσκευασία τους σε άθικτη κατάσταση και θα πρέπει να συνοδεύονται από το παραστατικό αγοράς.</p><p>Οποιαδήποτε αλλαγή ή επιστροφή, δεν συνοδεύεται από το παραστατικό αγοράς, δεν θα γίνεται δεκτή.</p><p>Ρητά συμφωνείται ότι:</p><p>Η αντικατάσταση των προϊόντων πραγματοποιείται εφόσον το προϊόν προς αντικατάσταση επιστρέφεται στην Επιχείρηση μας στην ίδια καλή κατάσταση που αρχικά το παραλάβατε.</p><p>Η Επιχείρηση μας δεν αντικαθιστά προϊόντα τα οποία φέρουν βρωμιές, φθορές, αλλοιώσεις, κακώσεις ή δε συνοδεύονται από όλα τα έγγραφα τα οποία λάβατε από εμάς.</p><p>Για οποιαδήποτε αλλαγή ή επιστροφή, θα πρέπει πρώτα να επικοινωνήσετε με εμάς, στο info@LikeMe.gr.</p><p>ΙΙΙ. ΕΥΘΥΝΕΣ – ΥΠΟΧΡΕΩΣΕΙΣ ΤΩΝ ΜΕΡΩΝ</p><p>Α. ΕΥΘΥΝΗ ΧΡΗΣΤΩΝ ΤΟΥ ΔΙΚΤΥΑΚΟΥ ΤΟΠΟΥ ΚΑΙ ΚΑΤΑΝΑΛΩΤΩΝ ΤΟΥ ΗΛΕΚΤΡΟΝΙΚΟΥ ΚΑΤΑΣΤΗΜΑΤΟΣ</p><p>Αποκλειστική Ευθύνη Χρήστη/Καταναλωτή.<br />Είστε ο μόνος και αποκλειστικά υπεύθυνος για τη νόμιμη χρήση του Δικτυακού τόπου και Ηλεκτρονικού καταστήματος και υποχρεούστε να απέχετε από κάθε παράνομη πράξη και καταχρηστική συμπεριφορά καθώς και από την υιοθέτηση παράνομων πρακτικών και πρακτικών αθέμιτου ανταγωνισμού.</p><p>Η συμμετοχή ως μέλος είναι δυνατή μόνο για φυσικά ή νομικά πρόσωπα με πλήρη δικαιοπρακτική ικανότητα. Από την απόκτηση ιδιότητας Μέλους αποκλείονται ανήλικα άτομα (άτομα κάτω των 18 ετών).</p><p>Ευθύνεστε αποκλειστικά για τη νομιμότητα και την ορθότητα των Πληροφοριών, Δεδομένων και στοιχείων που χορηγείτε στο LikeMe.gr, τα οποία η Επιχείρηση ουδεμία ευθύνη ή υποχρέωση έχει να ελέγχει, εκτός και αν αυτό της επιβληθεί μετά από καταγγελία ή με επιταγή νόμου.</p><p>Απαγορευμένες Χρήσεις.<br />Απαγορεύεται να χρησιμοποιείτε τον Δικτυακό τόπο και το ηλεκτρονικό κατάστημα LikeMe.gr για αποστολή με οποιονδήποτε τρόπο, δημοσίευση, μετάδοση οποιουδήποτε περιεχομένου είναι παράνομο, απειλητικό, προσβλητικό, δυσφημιστικό, ανήθικο, χυδαίο, άσεμνο, ενισχύει ή εκφράζει φυλετικές, εθνικές ή άλλες διακρίσεις, δύναται να προκαλέσει βλάβες σε τρίτους με οποιονδήποτε τρόπο.</p><p>Απαγορεύεται οποιαδήποτε ενέργεια ή παράληψή σας (α) παραβιάζει οποιαδήποτε ευρεσιτεχνία, εμπορικό σήμα, εμπορικό μυστικό, πνευματικά δικαιώματα ή άλλα ιδιοκτησιακά δικαιώματα τόσο του LikeMe.gr όσο και τρίτων, (β) περιέχει ιούς ή άλλα λογισμικά τα οποία δύνανται να προκαλέσουν διακοπή, βλάβη, καταστροφή ή παρεμπόδιση της λειτουργίας οποιουδήποτε λογισμικού ή να προκαλέσουν βλάβη στη φήμη και την υπόληψη της Επιχείρησης των Συνεργατών της και των Συνδεδεμένων Εταιρειών ή/και των άλλων χρηστών/μελών/καταναλωτών, ή δύναται να παραβιάσει οποιοδήποτε προσωπικό ή άλλο δεδομένο των χρηστών/μελών/καταναλωτών του παρόντος Δικτυακού τόπου/Ηλεκτρονικού Καταστήματος.</p><p>Επιπλέον απαγορεύεται.</p><p>(α) Οποιαδήποτε πρόσβαση ή απόπειρα πρόσβασης σε πληροφορίες και δεδομένα (συμπεριλαμβανομένων και των προσωπικών δεδομένων) που διακινούνται μέσω του Δικτυακού τόπου και για τα οποία δεν έχετε καμία εξουσιοδότηση ή εξουσία να χρησιμοποιήσετε.</p><p>(β) Η πρόσβαση στο Ηλεκτρονικό μας κατάστημα με σκοπό τη δημιουργία ή παραγωγή προϊόντος ή υπηρεσίας που να ανταγωνίζεται τα δικά μας προϊόντα/ υπηρεσίες.</p><p>(γ) Η διευκόλυνση με οποιονδήποτε τρόπο και με οποιαδήποτε μέσα τρίτων να αποκτήσουν πρόσβαση στα Δεδομένα που χορηγούνται στο LikeMe.gr από τα Μέλη του.</p><p>(δ) Οποιασδήποτε μορφής πειρατείας Λογισμικού, hacking ή/και υποκλοπής, αντιγραφής, αναλογικής/ψηφιακής εγγραφής και μηχανικής αναπαραγωγής, διανομής, μεταφοράς, downloading, μεταποίησης, μεταπώλησης, δημιουργίας παράγωγης εργασίας δεδομένων (συμπεριλαμβανομένων και των προσωπικών δεδομένων) και πληροφοριών, συμπεριλαμβανομένων και του περιεχομένου και υλικού (φωτογραφίες, γραφικά, κείμενα κτλ.) του Δικτυακού τόπου.</p><p>Β. ΕΥΘΥΝΗ LikeMe.gr</p><p>Ευθύνη και Εγγύηση Προμηθευτή.<br />Ο παραγωγός κάθε προϊόντος το οποίο αγοράζετε ευθύνεται για κάθε ζημία που οφείλεται σε ελάττωμα του προϊόντος του. Κάθε συμφωνία περιορισμού ή απαλλαγής του παραγωγού από την ευθύνη του είναι άκυρη.</p><p>Σε περίπτωση αμφιβολίας ως προς την ταυτότητα του παραγωγού ενός προϊόντος που προμηθευτήκατε από εμάς, παρακαλούμε ενημερώστε μας.</p><p>Ευθύνη LikeMe.gr για ελαττώματα, απώλεια.<br />Το LikeMe.gr έχει απέναντι σας όλες τις υποχρεώσεις που προβλέπονται στον Αστικό Κώδικα για τον πωλητή. Ειδικά σε περίπτωση ελαττώματος του προϊόντος που σας πωλούμε μπορείτε (α) να ζητήσετε την επισκευή του χωρίς επιβάρυνση σας, εκτός και αν αυτό είναι αδύνατο ή απαιτεί δυσανάλογες δαπάνες ή (β) την αντικατάσταση του με άλλο (βλ. Ενότητα ΙΙ.Δ.6) ή (γ) να υπαναχωρήσετε ακολουθώντας τη διαδικασία που υπάρχει στην Ενότητα Ι.Δ.5.2.</p><p>Οι παραπάνω υποχρεώσεις της Επιχείρησης μας παύουν σε περίπτωση που το ελάττωμα έχει προκληθεί από εσάς, ή το προϊόν το οποίο επιστρέφεται φέρει βρωμιές, φθορές, εκδορές, τσακίσεις και γενικότερα δημιουργεί την εντύπωση ότι έχει υποστεί χρήση πέρα από την απαραίτητη για τη διαπίστωση της καταλληλόλητας του, ή από στενή ή ευρεία έννοια ανωτέρα βία.</p><p>Σε κάθε περίπτωση τα προϊόντα πρέπει να συνοδεύονται από τα απαραίτητα νομιμοποιητικά έγγραφα και τις αποδείξεις παραλαβής. Θα πρέπει να ασκήσετε τα ως άνω δικαιώματά σας εντός δεκατεσσάρων ημερών από την παραλαβή των προϊόντων σας, η δε προθεσμία αυτή ξεκινάει από την επόμενη της παραλαβής και σε κάθε περίπτωση εντός αυτής θα πρέπει να μας έχετε επιστρέψει το προϊόν.</p><p>Σε περίπτωση που σας έχουμε εκτελέσει λάθος την παραγγελία σας (λάθος προϊόν, τίμημα κτλ.), οφείλετε να μας ενημερώσετε άμεσα στα παρακάτω στοιχεία επικοινωνίας: Τηλεφωνικά στα αντίστοιχα τηλέφωνα επικοινωνίας των καταστημάτων όπως καταγράφονται στη σελίδα Καταστήματα της ιστοσελίδας ή με Email στη διεύθυνση info@LikeMe.gr.</p><p>Σας ενημερώνουμε επιπλέον ότι ο κίνδυνος απώλειας ή βλάβης των προϊόντων βαρύνει το LikeMe.gr μέχρι εσείς ή κάποιο τρίτο μέρος το οποίο ορίζετε εσείς ως αρμόδιο να παραλάβει τα προϊόντα για λογαριασμό σας (διάφορο του μεταφορέα) έχει αποκτήσει τη φυσική κατοχή των αγαθών, οπότε και ο κίνδυνος αυτός μετατίθεται σε εσάς.</p><p>Εντούτοις, ο κίνδυνος μετατίθεται σε εσάς από την παράδοση των αγορασθέντων προϊόντων σας στον μεταφορέα, εάν ο μεταφορέας έχει ενταλθεί από εσάς να μεταφέρει τα αγαθά και η εν λόγω επιλογή δεν προσφέρθηκε από το LikeMe.gr, με την επιφύλαξη των δικαιωμάτων σας έναντι του μεταφορέα.</p><p>Περιορισμός Εγγυήσεων-Ευθύνης.<br />Το LikeMe.gr ενεργεί πάντοτε καλόπιστα και στο πλαίσιο των όσων προβλέπει ο νόμος και οι παρόντες Γενικοί Όροι.</p><p>Συνεπώς έχει λάβει και εξακολουθεί αδιαλείπτως να λαμβάνει όλα τα απαραίτητα τεχνικά ή άλλα μέτρα και καταβάλει κάθε δυνατή προσπάθεια προκειμένου (α) ο δικτυακός τόπος και το ηλεκτρονικό κατάστημα να λειτουργεί αδιαλείπτως και προσηκόντως χωρίς προβλήματα, διακοπές, καθυστερήσεις, σφάλματα ή λάθη, (β) τα δεδομένα/πληροφορίες που χορηγούνται και διαβιβάζονται μέσω του παρόντος δικτυακού τόπου αφενός να μην αλλοιώνονται αφετέρου να προστατεύονται με τη δημιουργία αντιγράφων ασφαλείας, καθόσον τα συστήματα ασφαλείας του παρόντος δικτυακού τόπου υπόκεινται σε περιορισμούς, (γ) η τεχνολογία που χρησιμοποιεί η ίδια ή οι εξυπηρετητές (Servers) μέσω των οποίων το ηλεκτρονικό κατάστημά μας τίθεται στη διάθεση των Χρηστών να μην περιέχει ιούς ή άλλα επιζήμια συστατικά ή προγράμματα λογισμικού, ωστόσο το LikeMe.gr ΔΕΝ ΠΑΡΕΧΕΙ ΣΧΕΤΙΚΕΣ ΕΓΓΥΗΣΕΙΣ για όλα τα ανωτέρω και δεν υποχρεούται σε αποζημίωση σας, σε περίπτωση που υποστείτε οποιαδήποτε ζημία για τους ως άνω λόγους.</p><p>Επιπλέον το LikeMe.gr ουδεμία εγγύηση παρέχει (α) για την καταλληλότητα, αποτελεσματικότητα, επάρκεια των προϊόντων του αναφορικά με το σκοπό για τον οποίο εσείς το προορίζετε και (β) για την ορθή και προσήκουσα εκτέλεση των συναλλακτικών υποχρεώσεων των υπολοίπων Χρηστών του δικτυακού τόπου και των υπηρεσιών του.</p><p>Το LikeMe.gr καταβάλλει εύλογες προσπάθειες για τη συντήρηση και τη διαθεσιμότητα του περιεχομένου του.</p><p>Παρ’ όλα αυτά, οι χρήστες αποδέχονται ότι το LikeMe.gr δικαιούται να τροποποιεί ή/και να διακόπτει προσωρινά ή μόνιμα το σύνολο ή τμήμα του δικτυακού τόπου με ή/και χωρίς προειδοποίηση προς τους χρήστες, δεδομένου ότι η διαθεσιμότητα μπορεί να επηρεάζεται από τον εξοπλισμό των χρηστών, από άλλα δίκτυα επικοινωνιών, από το μεγάλο αριθμό ατόμων που προσπαθούν να κάνουν χρήση του δικτυακού τόπου ταυτόχρονα ή από άλλες αιτίες.</p><p>Ως εκ τούτου, το LikeMe.gr δεν φέρει ουδεμία ευθύνη για οποιαδήποτε είδους ζημία (θετική, αποθετική, εξ αμελείας, ενδοσυμβατική ή άλλη) προερχόμενη από την αδυναμία πρόσβασης των χρηστών σ’ αυτό, την παύση του συνόλου ή τμημάτων αυτού, την καθυστέρηση, μη παράδοση, διακοπή ή κακή ποιότητα λήψης των υπηρεσιών του ή απώλειας του περιεχομένου τους, την ύπαρξη κάθε είδους λαθών.</p><p>Το LikeMe.gr δεν φέρει ευθύνη για τυχόν τεχνικά προβλήματα που τυχόν παρουσιασθούν στους χρήστες όταν επιχειρούν την πρόσβαση στον δικτυακό τόπο και κατά την διάρκεια αυτής και έχουν σχέση με τη λειτουργία ή συμβατότητα της δικής τους υποδομής με τη χρήση του δικτυακού τόπου.</p><p>Επίσης το LikeMe.gr ουδεμία ευθύνη έχει για πράξεις ή παραλείψεις τρίτων και ιδιαίτερα μη επιτρεπόμενες παρεμβάσεις τρίτων σε προϊόντα ή/και υπηρεσίες ή/και πληροφορίες που διατίθενται μέσω αυτού.</p><p>Πλέον των όσων ρητά ορίζονται στο παρόν, το LikeMe.gr ουδεμία ευθύνη αστική, ποινική, ή άλλως πως φέρει έναντι υμών ή/και οποιουδήποτε τρίτου έλκει δικαιώματα από εσάς, σε περίπτωση που οποιοσδήποτε από τους ανωτέρω, κατά τη χρήση των υπηρεσιών ή/και των προϊόντων του παρόντος ηλεκτρονικού καταστήματος υποστεί ζημία άμεση, έμμεση, παρεπόμενη, αποθετική οικονομική ή άλλη ζημία, διαφυγόντα κέρδη, οφειλόμενη σε: (α) λάθη, παραλήψεις, τεχνικά κολλήματα, βλάβες ή δυσλειτουργίες των τηλεπικοινωνιακών Δικτύων, του Διαδικτύου, του δικτυακού τόπου, των Internet Service Providers, (β) οριστική ή προσωρινή διακοπή λειτουργίας του δικτυακού τόπου ή ορισμένων υπηρεσιών του ή/και σε διακοπή παροχής ορισμένων προϊόντων μέσω του ηλεκτρονικού καταστήματος, (γ) γεγονότα, καταστάσεις, ενέργειες, πράξεις ή/και παραλήψεις του LikeMe.gr ή τρίτων συμπεριλαμβανομένων και των άλλων Χρηστών για τις οποίες το LikeMe.gr δεν παρέχει εγγυήσεις και δεν φέρει υποχρέωση σύμφωνα με τα οριζόμενα στο παρόν, (γ) πληροφορίες και λοιπό περιεχόμενο που τυχόν δημοσιεύουν και κοινοποιούν τρίτα μέρη.</p><p>Το LikeMe.gr επιφυλάσσεται ως προς το χρόνο παράδοσης των προϊόντων στις περιπτώσεις ανωτέρας βίας.</p><p>Το LikeMe.gr διατηρεί το δικαίωμα οποτεδήποτε να διακόψει προσωρινά ή οριστικά τη λειτουργία ολόκληρου ή τμήματός του για λόγους συντήρησης ή αναβάθμισης ή για οποιονδήποτε λόγο.</p><p>Το LikeMe.gr ουδεμία εγγύηση μπορεί να παράσχει για τη διαθεσιμότητα των προϊόντων, αλλά εγγυάται την έγκαιρη ενημέρωση των τελικών καταναλωτών περί της μη διαθεσιμότητάς τους, με την επιφύλαξη του όρου ΙΙ.Δ.</p><p>Ο Δικτυακός τόπος ενδέχεται να περιλαμβάνει συνδέσμους (Links) σε άλλους δικτυακούς τόπους.</p><p>Το LikeMe.gr σε καμία περίπτωση δεν πρέπει να θεωρηθεί ότι ενστερνίζεται ή αποδέχεται το περιεχόμενο ή τις υπηρεσίες άλλων διαδικτυακών τόπων που ενδέχεται να συνδέονται μέσω συνδέσμων και ρητά αποποιείται οποιασδήποτε ευθύνης για κάθε περιεχόμενο, πολιτική προστασίας απορρήτου, ποιότητα περιεχομένου και υπηρεσιών.</p><p>Επιπλέον το LikeMe.gr ουδεμία ευθύνη φέρει για τυχόν μη διαθεσιμότητα των δικτυακών αυτών τόπων, της πολιτικής τους περί προστασίας των προσωπικών σας δεδομένων, την ποιότητα και πληρότητα των πληροφοριών και των υπηρεσιών τους.</p><p>Το LikeMe.gr δεν ελέγχει και δεν προβαίνει σε κανένα προληπτικό έλεγχο του περιεχομένου και των πληροφοριών που δημοσιεύουν και κοινοποιούν τρίτα μέρη και δε φέρει ουδεμία ευθύνη για αυτά.</p><p>Το LikeMe.gr ευθύνεται μόνο για δόλο και βαριά αμέλεια, σε περίπτωση βλάβης σας από πληροφορίες που το LikeMe.gr ή υπηρεσίες που παρέχει μέσω του δικτυακού τόπου.</p><p>Το LikeMe.gr δικαιούται να αποκλείσει προσωρινά ή μόνιμα κάποιο μέλος οποτεδήποτε και χωρίς να αναφέρει τους λόγους, δηλαδή να ακυρώσει/διαγράψει/εμποδίσει την πρόσβαση ή/και τη συμμετοχή μέλους (προσωρινά ή/και μόνιμα) χωρίς να εγερθούν απαιτήσεις κατά του LikeMe.gr. Εξυπακούεται ότι το μέλος αυτό απαγορεύεται να γίνει μέλος ξανά του LikeMe.gr με τα ίδια ή άλλα στοιχεία εκτός και αν το LikeMe.gr συναινέσει ρητώς προς τούτο. Προς τον σκοπό αυτό το μέλος συναινεί το LikeMe.gr να διατηρεί τα προσωπικά του στοιχεία στο σύστημά του προκειμένου να είναι σε θέση να ταυτοποιήσει τυχόν μεταγενέστερη προσπάθεια εγγραφής του.</p><p>Τα ανωτέρω ισχύουν ιδίως (αλλά όχι αποκλειστικώς) σε περίπτωση παραβίασης των όρων χρήσης από το μέλος οι οποίοι στο σύνολό τους αναγνωρίζονται και συνομολογούνται από το μέλος ως ουσιώδεις, σε περίπτωση αιτήματος από οποιαδήποτε Αρχή, Δικαστήριο, σε περίπτωση καταγγελίας από τρίτο δικαιούχο δικαιωμάτων κατά του μέλους.</p><p>Το LikeMe.gr διατηρεί το δικαίωμα οποτεδήποτε, αναιτιολογήτως και αζημίως να διακόψει ή να παύσει την παροχή των υπηρεσιών του ή/και την λειτουργία του οριστικά ή προσωρινά χωρίς αν υπέχει προς τούτο ουδεμία υποχρέωση προηγούμενης ενημέρωσης των μελών. Το LikeMe.gr ευθύνεται μόνο για άμεσες ζημιές, οι οποίες προκύπτουν λόγω δόλου ή βαριάς αμέλειας του LikeMe.gr.</p><p>Με την επιφύλαξη αναγκαστικού χαρακτήρα διατάξεων, αποκλείεται ρητά η ευθύνη του LikeMe.gr για άμεση ζημία λόγω ελαφράς αμέλειας ανεξαρτήτως νομικού λόγου. Αποκλείεται πλήρως και ρητά η ευθύνη του LikeMe.gr για έμμεσες ή επακόλουθες ζημίες – ανεξαρτήτως λόγου.</p><p>ΙV. ΔΙΚΑΙΩΜΑΤΑ ΠΝΕΥΜΑΤΙΚΗΣ ΙΔΙΟΚΤΗΣΙΑΣ</p><p>Όλο το περιεχόμενο των ιστοσελίδων του παρόντος δικτυακού τόπου, συμπεριλαμβανομένων εικόνων, γραφικών, φωτογραφιών, σχεδίων, κειμένων, παρεχόμενων υπηρεσιών και προϊόντων αποτελούν πνευματική ιδιοκτησία του LikeMe.gr και προστατεύονται κατά τις σχετικές διατάξεις του ελληνικού δικαίου, του ευρωπαϊκού δικαίου και των διεθνών συμβάσεων και συνθηκών.</p><p>Απαγορεύεται οποιαδήποτε αντιγραφή, αναλογική/ψηφιακή εγγραφή και μηχανική αναπαραγωγή, διανομή, μεταφορά, downloading, μεταποίηση, μεταπώληση, μέρος ή του συνόλου του περιεχομένου το δικτυακού τόπο για κανέναν σκοπό, πλην της αυστηρά προσωπικής χρήσης, εκτός και αν η LikeMe.gr δώσει εγγράφως τη συναίνεση της.</p><p>Τα ονόματα, εικόνες, λογότυπα και διακριτικά γνωρίσματα που αντιπροσωπεύουν το LikeMe.gr ή/και το ηλεκτρονικό του κατάστημα ή/και τρίτα μέρη συμβεβλημένα με αυτούς καθώς και τα προϊόντα ή τις υπηρεσίες τους, είναι αποκλειστικά σήματα και διακριτικά γνωρίσματα του LikeMe.gr ή/και των άνω τρίτων μερών και προστατεύονται από τους ελληνικούς, κοινοτικούς και διεθνείς νόμους περί εμπορικών σημάτων και βιομηχανικής και πνευματικής ιδιοκτησίας και αθεμίτου ανταγωνισμού.</p><p>Σε κάθε περίπτωση η εμφάνισή και έκθεση τους στις ιστοσελίδες LikeMe.gr δεν θα πρέπει κατά κανένα τρόπο να εκληφθεί ως μεταβίβαση ή εκχώρηση άδειας ή δικαιώματος χρήσης τους.</p><p>ΑΣΦΑΛΕΙΑ<br />Αναγνώριση Πελάτη.<br />Το LikeMe.gr αναγνωρίζει τη σημασία του θέματος της ασφαλείας των Προσωπικών Σας Δεδομένων καθώς και των ηλεκτρονικών σας συναλλαγών και λαμβάνει όλα τα απαραίτητα μέτρα, με τις πιο σύγχρονες και προηγμένες μεθόδους, ώστε να εξασφαλίζεται η μέγιστη δυνατή ασφάλεια σας. Όλες οι πληροφορίες, οι οποίες σχετίζονται με τα προσωπικά σας στοιχεία και τις συναλλαγές σας, είναι ασφαλείς και απόρρητες.</p><p>Η ασφάλεια του Ηλεκτρονικού καταστήματος του LikeMe.gr επιτυγχάνεται με τις ακόλουθες μεθόδους:</p><p>Οι κωδικοί που χρησιμοποιούνται για την αναγνώρισή σας είναι δύο: ο Κωδικός Εισόδου (e-mail ή username) και ο Προσωπικός Μυστικός Κωδικός Ασφαλείας (password), οι οποίοι κάθε φορά που τους καταχωρείτε σας παρέχουν πρόσβαση με απόλυτη ασφάλεια στα προσωπικά σας στοιχεία.</p><p>Εξασφάλιση του Απορρήτου.<br />Η σύνδεσή των χρηστών σε αυτό είναι ασφαλής διότι χρησιμοποιεί τεχνολογία SSL (Secure Socket Layer) με κρυπτογράφηση AES 256 bit.</p><p>Η τεχνολογία SSL στηρίζεται σε ένα κωδικό κλειδί για κρυπτογράφηση των δεδομένων πριν αποσταλούν μέσω της (SSL) σύνδεσης. Ο έλεγχος ασφαλείας μεταξύ των δεδομένων και του Server γίνεται με βάση το μοναδικό κωδικό κλειδί διασφαλίζοντας στο ακέραιο την επικοινωνία.</p><p>Το πρωτόκολλο SSL (Secure Sockets Layer) είναι σήμερα το παγκόσμιο standard στο Διαδίκτυο για την πιστοποίηση δικτυακών τόπων (web sites) στους δικτυακούς χρήστες και για την κρυπτογράφηση στοιχείων μεταξύ των δικτυακών χρηστών και των δικτυακών εξυπηρετητών (web servers).</p><p>Η πρόσβαση στα συστήματα του LikeMe.gr (servers) ελέγχεται από firewall, το οποίο επιτρέπει τη χρήση συγκεκριμένων υπηρεσιών από τους πελάτες/ χρήστες απαγορεύοντας, παράλληλα, την πρόσβαση σε συστήματα και βάσεις δεδομένων με απόρρητα στοιχεία και πληροφορίες της εταιρείας.</p><p>Απόρρητο Συναλλαγών.<br />Η τήρηση του απορρήτου θεωρείται αυτονόητη. Οι ίδιες βασικές αρχές που διέπουν τις κλασσικές συναλλαγές ισχύουν και στην περίπτωση του e-commerce (ηλεκτρονικού εμπορίου).</p><p>Όλες οι πληροφορίες που διαβιβάζονται από τον χρηστή/μέλος στο LikeMe.gr είναι εμπιστευτικές και το LikeMe.gr έχει λάβει όλα τα απαραίτητα μέτρα ώστε να γίνεται χρήση τους μόνο στο μέτρο που αυτό κρίνεται αναγκαίο στο πλαίσιο των παρεχόμενων υπηρεσιών.</p><p>Μερικά από τα μέτρα που έχουν ληφθεί είναι τα ακόλουθα:</p><p>– Μόνο εξουσιοδοτημένοι υπάλληλοι έχουν πρόσβαση στις πληροφορίες των συναλλαγών σας και μόνο όποτε αυτό είναι αναγκαίο, π.χ. για τη διεκπεραίωση των αιτήσεών σας.</p><p>– Το LikeMe.gr δεν αποκαλύπτει τα στοιχεία των πελατών και των συναλλαγών τους, εκτός αν έχει έγγραφη εξουσιοδότηση από εσάς ή αυτό επιβάλλεται από δικαστική απόφαση ή απόφαση άλλης δημόσιας αρχής.</p><p>– Στην περίπτωση που το LikeMe.gr χρησιμοποιεί τρίτους για την υποστήριξη των συστημάτων της, φροντίζει για την εξασφάλιση του απορρήτου.</p><p>Για τη δική σας ασφάλεια, θα πρέπει και εσείς να χειρίζεστε όλες τις πληροφορίες που παρέχονται μέσω της υπηρεσίας ως εμπιστευτικές και απόρρητες και να μην προβαίνετε σε οποιαδήποτε αποκάλυψή τους σε τρίτα πρόσωπα.</p><p>ΤΕΛΙΚΕΣ ΔΙΑΤΑΞΕΙΣ<br />Α. ΤΕΛΙΚΟΙ ΟΡΟΙ</p><p>Οι παρόντες Γενικοί Όροι αποτελούν τους τελικούς και μοναδικούς όρους σε ισχύ αναφορικά με την παροχή της Υπηρεσίας εκ μέρους της Επιχείρησης στον Χρήστη και καταργούν τυχόν προ ισχύσαντες όρους, προηγούμενες συμβάσεις και διακανονισμούς, έγγραφους ή προφορικούς μεταξύ της Επιχείρησης και του Χρήστη αναφορικά με τη χρήση της Υπηρεσίας.</p><p>Β. ΠΑΡΑΙΤΗΣΗ</p><p>Καμία καθυστέρηση, αμέλεια ή ανοχή της Επιχείρησης στην επιβολή της τήρησης κάποιου παρόντος όρου από τον Χρήστη, δεν αποτελεί παραίτηση ούτε βλάπτει προβλεπόμενο στην παρούσα δικαίωμά της.</p><p>Εάν οποιοσδήποτε παρόν όρος ήθελε κριθεί από οποιοδήποτε αρμόδιο Δικαστήριο η Αρχή ως άκυρος και κατά συνέπεια ανεφάρμοστος, ο όρος αυτός δε θα συμπαρασύρει σε ακυρότητα τους υπόλοιπους όρους της παρούσης, οι οποίοι θα παραμείνουν σε πλήρη ισχύ.</p><p>Γ. ΑΚΥΡΟΤΗΤΑ ΟΡΩΝ</p><p>Στην περίπτωση που κάποιο τμήμα του παρόντος κηρυχθεί ή ορισθεί με δικαστική απόφαση άκυρο, η ακυρότητα αυτή δεν θα επηρεάσει το κύρος του υπολειπόμενου τμήματος του παρόντος, το οποίο θα παραμείνει ισχυρό σαν οι παρόντες Γενικοί Όροι να είχαν εκτελεσθεί με το άκυρο τμήμα τους διαγεγραμμένο.</p><p>Η Επιχείρηση θα επιδιώξει να αντικαταστήσει κάθε άκυρο όρο, με νέο έγκυρο όρο, του οποίου το αποτέλεσμα θα είναι το εγγύτατο ισοδύναμο αυτού που ακυρώθηκε.</p><p>Δ. ΕΦΑΡΜΟΣΤΑΙΟ ΔΙΚΑΙΟ – ΔΙΚΑΙΟΔΟΣΙΑ</p><p>Κάθε διαφορά μεταξύ των συμβαλλομένων σχετικά με την εφαρμογή, ερμηνεία, ακυρότητα όρων της σύμβασης, την ύπαρξη ή ανυπαρξία δικαιωμάτων και υποχρεώσεων των συμβαλλομένων εκ συμβάσεως ή και αδικοπραξίας, ερμηνεύεται σύμφωνα με τους ελληνικούς νόμους και υπάγεται στην αποκλειστική δικαιοδοσία των καθ’ ύλη αρμοδίων δικαστηρίων, στην δικαιοδοσία των οποίων τα μέρη υποβάλλονται από σήμερα οικειοθελώς.</p><p>Εναλλακτικά, προτείνεται η λύση του εξωδικαστικού συμβιβασμού μέσω του Ευρωπαϊκού Φορέα Εναλλακτικής Επίλυσης Διαφορών.</p><p>Σύμφωνα με την Οδηγία 2013/11/ΕΚ, η οποία ενσωματώθηκε στην Ελλάδα με την ΚΥΑ 70330/2015, προβλέπεται πλέον και η δυνατότητα ηλεκτρονικής επίλυσης καταναλωτικών διαφορών με τη διαδικασία Εναλλακτικής Επίλυσης Διαφορών (ΕΕΔ – Alternative Dispute Resolution) στο σύνολο της Ευρωπαϊκής Ένωσης.</p><p>Εάν ο πελάτης έχει την ιδιότητα του καταναλωτή (δηλ. φυσικό πρόσωπο που ενεργεί εκτός επαγγελματικής ιδιότητας) και έχει οποιοδήποτε πρόβλημα με αγορά που πραγματοποίησε από την Ιστοσελίδα μας μπορεί να κινήσει την διαδικασία ΕΕΔ δια μέσου της ενιαίας πανενωσιακής πλατφόρμας για την ηλεκτρονική επίλυση διαφορών (πλατφόρμα ΗΕΔ) διαθέσιμη στο https://webgate.ec.europa.eu/odr/main/index.cfm?event=main.home.chooseLanguage</p><p>Ε. ΠΟΛΙΤΙΚΗ ΑΝΤΙΜΕΤΩΠΙΣΗΣ ΠΑΡΑΠΟΝΩΝ – ΥΠΟΣΤΗΡΙΨΗ ΠΕΛΑΤΗ ΜΕΤΑ ΤΗΝ ΠΩΛΗΣΗ</p><p>Τρόποι Πληρωμής / Ασφάλεια Συναλλαγών<br />Στον Διαδικτυακό σας τόπο θα πρέπει να υπάρχει ενημερωτική αναφορά σύμφωνα με το ακόλουθο πρότυπο:<br />«Αναγνωρίζοντας τη σημασία της ασφάλειας των ηλεκτρονικών πληρωμών, η EveryPay είναι αδειοδοτημένο Ίδρυμα Πληρωμών από την Τράπεζα της Ελλάδος (αρ. απόφασης 280/3/23-7-2018 ΦΕΚ Β 3010/25-7-2018), και διαχειρίζεται με ασφάλεια στοιχεία συναλλαγών πληρωμών με κάρτες, σύμφωνα με το κανονιστικό πλαίσιο του προτύπου διαχείρισης ασφάλειας συναλλαγών με κάρτες. Η Everypay είναι πιστοποιημένη σύμφωνα με το πρότυπο διασφάλισης ασφάλειας διαχείρισης συναλλαγών με κάρτες (PCI DSS), και υπόκειται σε περιοδικούς ελέγχους από εξειδικευμένη συμβουλευτική εταιρία. Όλες οι υπηρεσίες της Everypay γίνονται μέσα από ασφαλείς συνδέσεις με πιστοποιητικά 256 bit SSL. Η EveryPay υποστηρίζει επίσης τη δυνατότητα χρήσης της υπηρεσίας 3D Secure, μία επιπρόσθετη δικλίδα ασφαλείας για κάρτες VISA &amp; MasterCard. Ο Πληρωτής τότε θα πρέπει να πληκτρολογήσει τον προσωπικό του μυστικό κωδικό, για να ολοκληρώσει με επιτυχία την συναλλαγή»</p><p>Μπορείτε να επικοινωνήσετε με το LikeMe.gr στο pro@LikeMe.gr αναφέροντας το ονοματεπώνυμο σας και τον κωδικό παραγγελίας.</p>\n\nMetadata:\n{\n    \"featured_image\": false,\n    \"excerpt\": \"\\u0395\\u0399\\u03a3\\u0391\\u0393\\u03a9\\u0393\\u0397\\u03a4\\u03bf likeme.gr \\u03b5\\u03af\\u03bd\\u03b1\\u03b9 \\u03bf \\u00ab\\u0394\\u03b9\\u03ba\\u03c4\\u03c5\\u03b1\\u03ba\\u03cc\\u03c2 \\u03c4\\u03cc\\u03c0\\u03bf\\u03c2\\u00bb \\u03ba\\u03b1\\u03b9 \\u03c4\\u03bf \\u00ab\\u0397\\u03bb\\u03b5\\u03ba\\u03c4\\u03c1\\u03bf\\u03bd\\u03b9\\u03ba\\u03cc \\u039a\\u03b1\\u03c4\\u03ac\\u03c3\\u03c4\\u03b7\\u03bc\\u03b1\\u00bb \\u03ad\\u03ba\\u03b8\\u03b5\\u03c3\\u03b7\\u03c2 \\u03ba\\u03b1\\u03b9 \\u03b4\\u03b9\\u03ac\\u03b8\\u03b5\\u03c3\\u03b7\\u03c2 \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03c9\\u03bd \\u03bc\\u03ad\\u03c3\\u03c9 \\u03c4\\u03bf\\u03c5 \\u0394\\u03b9\\u03b1\\u03b4\\u03b9\\u03ba\\u03c4\\u03cd\\u03bf\\u03c5, \\u03c4\\u03bf \\u03bf\\u03c0\\u03bf\\u03af\\u03bf \\u03b1\\u03bd\\u03ae\\u03ba\\u03b5\\u03b9 \\u03c3\\u03c4\\u03b7\\u03bd \\u03b5\\u03bb\\u03bb\\u03b7\\u03bd\\u03b9\\u03ba\\u03ae \\u03b5\\u03c0\\u03b9\\u03c7\\u03b5\\u03af\\u03c1\\u03b7\\u03c3\\u03b7 \\u03bc\\u03b5 \\u03c4\\u03b7\\u03bd \\u03b5\\u03c0\\u03c9\\u03bd\\u03c5\\u03bc\\u03af\\u03b1 \\u00abProMarketing-\\u0391\\u0394\\u0391\\u039c\\u039f\\u03a0\\u039f\\u03a5\\u039b\\u039f\\u03a3 \\u0391\\u039d\\u0394\\u03a1\\u0395\\u0391\\u03a3\\u00bb \\u03c0\\u03bf\\u03c5 \\u03b5\\u03b4\\u03c1\\u03b5\\u03cd\\u03b5\\u03b9 \\u03c3\\u03c4\\u03b7\\u03bd \\u03b4\\u03b9\\u03b5\\u03cd\\u03b8\\u03c5\\u03bd\\u03c3\\u03b7 \\u0394\\u03bf\\u03ca\\u03c1\\u03ac\\u03bd\\u03b7\\u03c2 9, \\u039a\\u03b1\\u03bb\\u03bb\\u03b9\\u03b8\\u03ad\\u03b1, \\u0391\\u03c4\\u03c4\\u03b9\\u03ba\\u03ae\\u03c2, 17671 \\u03bc\\u03b5 \\u0391\\u03a6\\u039c 133620153, \\u0394\\u039f\\u03a5: \\u039a\\u03b1\\u03bb\\u03bb\\u03b9\\u03b8\\u03ad\\u03b1\\u03c2 \\u03ba\\u03b1\\u03b9 \\u03b1\\u03c1\\u03b9\\u03b8\\u03bc\\u03cc \\u0393\\u0395\\u039c\\u0397 159378403000 (\\u03b5\\u03c6\\u03b5\\u03be\\u03ae\\u03c2 \\u03c4\\u03bf \\u00abLikeMe.\\u00bb \\u03ae \\u03b7 \\u00ab\\u0395\\u03c0\\u03b9\\u03c7\\u03b5\\u03af\\u03c1\\u03b7\\u03c3\\u03b7\\u00bb). \\u039f\\u03b9 \\u03c0\\u03b1\\u03c1\\u03cc\\u03bd\\u03c4\\u03b5\\u03c2 \\u0393\\u03b5\\u03bd\\u03b9\\u03ba\\u03bf\\u03af \\u038c\\u03c1\\u03bf\\u03b9 \\u03ba\\u03b1\\u03b9 \\u03c0\\u03c1\\u03bf\\u03cb\\u03c0\\u03bf\\u03b8\\u03ad\\u03c3\\u03b5\\u03b9\\u03c2 \\u03c7\\u03c1\\u03ae\\u03c3\\u03b7\\u03c2 \\u03c4\\u03bf\\u03c5 \\u03b4\\u03b9\\u03ba\\u03c4\\u03c5\\u03b1\\u03ba\\u03bf\\u03cd \\u03c4\\u03cc\\u03c0\\u03bf\\u03c5 \\u03ba\\u03b1\\u03b9 \\u03b1\\u03b3\\u03bf\\u03c1\\u03ac\\u03c2 \\u03c4\\u03c9\\u03bd \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03c9\\u03bd\\/\\u03c5\\u03c0\\u03b7\\u03c1\\u03b5\\u03c3\\u03b9\\u03ce\\u03bd \\u03c4\\u03bf\\u03c5 \\u03b7\\u03bb\\u03b5\\u03ba\\u03c4\\u03c1\\u03bf\\u03bd\\u03b9\\u03ba\\u03bf\\u03cd \\u03bc\\u03b1\\u03c2 \\u03ba\\u03b1\\u03c4\\u03b1\\u03c3\\u03c4\\u03ae\\u03bc\\u03b1\\u03c4\\u03bf\\u03c2 (\\u03b5\\u03c6\\u03b5\\u03be\\u03ae\\u03c2 \\u03bf\\u03b9 \\u00ab\\u038c\\u03c1\\u03bf\\u03b9 \\u03a7\\u03c1\\u03ae\\u03c3\\u03b7\\u03c2 \\u03ba\\u03b1\\u03b9 \\u03a3\\u03c5\\u03bd\\u03b1\\u03bb\\u03bb\\u03b1\\u03b3\\u03ce\\u03bd\\u00bb \\u03ae \\u03bf\\u03b9 \\u00ab\\u038c\\u03c1\\u03bf\\u03b9 \\u03a7\\u03c1\\u03ae\\u03c3\\u03b7\\u03c2\\u00bb), \\u03ba\\u03b1\\u03b8\\u03bf\\u03c1\\u03af\\u03b6\\u03bf\\u03c5\\u03bd \\u03c4\\u03bf\\u03c5\\u03c2 \\u03cc\\u03c1\\u03bf\\u03c5\\u03c2 \\u03ba\\u03b1\\u03b9 \\u03c4\\u03b9\\u03c2 \\u03c0\\u03c1\\u03bf\\u03cb\\u03c0\\u03bf\\u03b8\\u03ad\\u03c3\\u03b5\\u03b9\\u03c2 \\u03c0\\u03b5\\u03c1\\u03b9\\u03ae\\u03b3\\u03b7\\u03c3\\u03b7\\u03c2 \\u03c3\\u03b1\\u03c2 \\u03c3\\u03c4\\u03bf \\u0394\\u03b9\\u03ba\\u03c4\\u03c5\\u03b1\\u03ba\\u03cc \\u03bc\\u03b1\\u03c2 \\u03c4\\u03cc\\u03c0\\u03bf \\u03ba\\u03b1\\u03b9 \\u03c7\\u03c1\\u03ae\\u03c3\\u03b7\\u03c2 \\u03b1\\u03c5\\u03c4\\u03bf\\u03cd \\u03ba\\u03b1\\u03b9 \\u03c4\\u03bf\\u03c5 \\u03b7\\u03bb\\u03b5\\u03ba\\u03c4\\u03c1\\u03bf\\u03bd\\u03b9\\u03ba\\u03bf\\u03cd \\u03bc\\u03b1\\u03c2 \\u03ba\\u03b1\\u03c4\\u03b1\\u03c3\\u03c4\\u03ae\\u03bc\\u03b1\\u03c4\\u03bf\\u03c2\",\n    \"modified_date\": \"2026-01-26 14:34:46\",\n    \"permalink\": \"https:\\/\\/staging.promarketing.gr\\/oroi-kai-proipotheseis\\/\",\n    \"categories\": [],\n    \"tags\": []\n}","2b694c83-10be-4233-a933-569e28bbe3a5","{\"post_id\":198}","1769590756"),
("10","post","Επικοινωνία","<h2>Στοιχεία Επικοινωνίας</h2>		<p>Προς το παρόν το κατάστημα λειτουργεί μόνο διαδικτυακά και δεν παρέχεται η δυνατότητα παραλαβής από τον χώρο μας ή δοκιμής των προϊόντων. Όλες οι παραγγελίες εκτελούνται διαδικτυακά με την παραλαβή των προϊόντων ΜΟΝΟ μέσω της επιλεγμένης από εσάς Courier που συνεργαζόμαστε.</p><p>Δεν πραγματοποιούμε αλλαγές χέρι με χέρι, αλλά πραγματοποιούμε άμεσες επιστροφές χρημάτων βάση της πολιτικής μας και ταυτόχρονα μπορείτε να κάνετε εκ νέου παραγγελία. Για αλλαγές-επιστροφές ακολουθήστε τις παρακάτω οδηγίες πατώντας <a href=\"https://likeme.gr/forma-allagis-epistrofis/\">εδώ</a>.</p><p>Για παραγγελίες μέσω Skroutz Marketplace, θα πρέπει να απευθύνεστε απευθείας στο Skroutz ή μέσω του account σας στο Skroutz και όχι μαζί μας. </p><p>Για οποιαδήποτε άλλη διευκρίνιση μπορείτε να μας στείλετε email.</p><p>Email: pro \"at\" likeme.gr</p>					\n															<svg viewBox=\"0 0 448 512\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M207.029 381.476L12.686 187.132c-9.373-9.373-9.373-24.569 0-33.941l22.667-22.667c9.357-9.357 24.522-9.375 33.901-.04L224 284.505l154.745-154.021c9.379-9.335 24.544-9.317 33.901.04l22.667 22.667c9.373 9.373 9.373 24.569 0 33.941L240.971 381.476c-9.373 9.372-24.569 9.372-33.942 0z\"></path></svg>\n								<svg viewBox=\"0 0 448 512\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M240.971 130.524l194.343 194.343c9.373 9.373 9.373 24.569 0 33.941l-22.667 22.667c-9.357 9.357-24.522 9.375-33.901.04L224 227.495 69.255 381.516c-9.379 9.335-24.544 9.317-33.901-.04l-22.667-22.667c-9.373-9.373-9.373-24.569 0-33.941L207.03 130.525c9.372-9.373 24.568-9.373 33.941-.001z\"></path></svg>\n												<a tabindex=\"0\">Με ποία μεταφορική συνεργάζεστε;</a>\n					<p>Elta Courier, Box Now και Skroutz Last Mile.</p>\n															<svg viewBox=\"0 0 448 512\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M207.029 381.476L12.686 187.132c-9.373-9.373-9.373-24.569 0-33.941l22.667-22.667c9.357-9.357 24.522-9.375 33.901-.04L224 284.505l154.745-154.021c9.379-9.335 24.544-9.317 33.901.04l22.667 22.667c9.373 9.373 9.373 24.569 0 33.941L240.971 381.476c-9.373 9.372-24.569 9.372-33.942 0z\"></path></svg>\n								<svg viewBox=\"0 0 448 512\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M240.971 130.524l194.343 194.343c9.373 9.373 9.373 24.569 0 33.941l-22.667 22.667c-9.357 9.357-24.522 9.375-33.901.04L224 227.495 69.255 381.516c-9.379 9.335-24.544 9.317-33.901-.04l-22.667-22.667c-9.373-9.373-9.373-24.569 0-33.941L207.03 130.525c9.372-9.373 24.568-9.373 33.941-.001z\"></path></svg>\n												<a tabindex=\"0\">Μπορώ να παραλάβω από τον χώρο σας;</a>\n					<p>Προς το παρόν η παράδοση των προϊόντων γίνεται μόνο μέσω αποστολής με Courier και δεν υπάρχει δυνατότητα παράδοσης από την αποθήκη μας.</p>\n															<svg viewBox=\"0 0 448 512\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M207.029 381.476L12.686 187.132c-9.373-9.373-9.373-24.569 0-33.941l22.667-22.667c9.357-9.357 24.522-9.375 33.901-.04L224 284.505l154.745-154.021c9.379-9.335 24.544-9.317 33.901.04l22.667 22.667c9.373 9.373 9.373 24.569 0 33.941L240.971 381.476c-9.373 9.372-24.569 9.372-33.942 0z\"></path></svg>\n								<svg viewBox=\"0 0 448 512\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M240.971 130.524l194.343 194.343c9.373 9.373 9.373 24.569 0 33.941l-22.667 22.667c-9.357 9.357-24.522 9.375-33.901.04L224 227.495 69.255 381.516c-9.379 9.335-24.544 9.317-33.901-.04l-22.667-22.667c-9.373-9.373-9.373-24.569 0-33.941L207.03 130.525c9.372-9.373 24.568-9.373 33.941-.001z\"></path></svg>\n												<a tabindex=\"0\">Ποια είναι τα έξοδα μεταφορικών;</a>\n					<p>Παρέχουμε ΔΩΡΕΑΝ μεταφορικά για όλη την Ελλάδα άνω των 49€ αγορών με Box Now. Κάτω των 49€ υπάρχει χρέωση 3€.</p>\n<p>Επιλέξτε την πληρωμή με Κάρτα και κερδίστε άλλα 2.5€, από το κόστος αντικαταβολής.</p>\n															<svg viewBox=\"0 0 448 512\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M207.029 381.476L12.686 187.132c-9.373-9.373-9.373-24.569 0-33.941l22.667-22.667c9.357-9.357 24.522-9.375 33.901-.04L224 284.505l154.745-154.021c9.379-9.335 24.544-9.317 33.901.04l22.667 22.667c9.373 9.373 9.373 24.569 0 33.941L240.971 381.476c-9.373 9.372-24.569 9.372-33.942 0z\"></path></svg>\n								<svg viewBox=\"0 0 448 512\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M240.971 130.524l194.343 194.343c9.373 9.373 9.373 24.569 0 33.941l-22.667 22.667c-9.357 9.357-24.522 9.375-33.901.04L224 227.495 69.255 381.516c-9.379 9.335-24.544 9.317-33.901-.04l-22.667-22.667c-9.373-9.373-9.373-24.569 0-33.941L207.03 130.525c9.372-9.373 24.568-9.373 33.941-.001z\"></path></svg>\n												<a tabindex=\"0\">Πού απευθύνομαι για επιστροφές προϊόντων;</a>\n					<h4 style=\"margin-bottom: var(--wd-tags-mb); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: var(--wd-title-font-weight); font-family: var(--wd-title-font); text-transform: none;\">ΑΛΛΑΓΕΣ &amp; ΕΠΙΣΤΡΟΦΕΣ</h4><ul style=\"margin-bottom: 0px; padding-left: var(--li-pl); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-family: Lato, Arial, Helvetica, sans-serif; font-size: 14px; --list-mb: 20px; --li-mb: 10px; --li-pl: 17px; color: #777777;\"><li style=\"font-weight: 400; margin-bottom: var(--li-mb); font-size: 14px;\">Μπορείτε να κάνετε είτε αλλαγή είτε επιστροφή χρημάτων εντός 20 ημερών από την ημερομηνία αγοράς (όχι παραλαβής). Η διαδικασία αλλαγής ή επιστροφής χρημάτων κοστίζει 6€ και θα αφαιρείται από την αξία των προϊόντων που είχατε αγοράσει και όχι από το σύνολο της παραγγελίας (κόστη μεταφορικών ή αντικαταβολής). Σε περιπτώσεις ελλατωματικού προϊόντος ή λάθος από την πλευρά μας δεν επιβαρύνεστε με κανένα έξοδο.</li><li style=\"font-weight: 400; margin-bottom: var(--li-mb); font-size: 14px;\">Είτε προχωρήσετε σε αλλαγή είτε σε επιστροφή χρημάτων, η διαδικασία είναι απλή καθώς μας στέλνετε πίσω τα προϊόντα που θέλετε να αλλάξετε ή να επιστρέψετε και εμείς σας επιστρέφουμε τα αντίστοιχα χρήματα στον λογαριασμό σας αφαιρώντας τα κόστη μεταφορικών (6€). Από εκεί και πέρα μπορείτε να προχωρήσετε σε νέα αγορά των προϊόντων που σας ενδιαφέρουν.</li><li style=\"margin-bottom: var(--li-mb); font-size: 14px;\"><b>Αναλυτικές οδηγίες: </b>Συσκευάστε τα προϊόντα που θέλετε να κάνετε αλλαγή ή επιστροφή στην ίδια σακούλα που παραλάβατε, όπου αναγράφονται τα στοιχεία της εταιρείας μας στο Voucher που είναι κολλημένο έξω από την σακούλα. Παραδώστε την σακούλα στην ίδια Courier που παραλάβατε το δέμα και ζητήστε επιστροφή του δέματος με δική μας χρέωση. Εάν έχετε πετάξει την σακούλα με το Voucher, μεταβείτε σε ένα Elta Courier και δώστε τα παρακάτω στοιχεία: LikeMe.gr &#8211; Δοϊράνης 9 Καλλιθέα, 17671 &#8211; 2102156537. Μόλις πραγματοποιήσετε την αποστολή &#8211; επιστροφή συμπληρώστε <a href=\"https://likeme.gr/forma-allagis-epistrofis/\" target=\"_blank\" rel=\"noopener\">την φόρμα που θα βρείτε πατώντας εδώ</a> ή στείλτε μας ένα email στο pro@likeme.gr με τα παρακάτω στοιχεία: Αριθμός παραγγελίας, Κινητό παραγγελίας, Αριθμός Voucher. Εάν η παραγγελία σας ήταν με αντικαταβολή χρειαζόμαστε και τα στοιχεία τραπέζης (IBAN, όνομα δικαιούχου, όνομα τραπέζης). Εάν η παραγγελία σας ήταν μέσω κάρτας δεν χρειαζόμαστε κανένα άλλο στοιχείο. Μόλις παραλάβουμε το δέμα η επιστροφή χρημάτων θα γίνει εντός 5 εργάσιμων ημερών.</li><li style=\"margin-bottom: var(--li-mb); font-size: 14px;\"><a href=\"https://likeme.gr/forma-allagis-epistrofis/\" target=\"_blank\" rel=\"noopener\">Πατήστε εδώ για την συμπλήρωση της φόρμας αλλαγής ή επιστροφής προϊόντων</a></li><li style=\"margin-bottom: var(--li-mb); font-size: 14px;\">Κατά την επιστροφή των χρημάτων θα αφαιρεθούν 6€ από την αξία των προϊόντων + εκπτώσεων που μπορεί να είχατε λάβει.</li><li style=\"margin-bottom: var(--li-mb); font-size: 14px;\">Για διατραπεζικές συναλλαγές χρησιμοποιούμε την Alpha Bank &amp; την Eurobank. Σε περίπτωση που χρησιμοποιήσετε άλλη τράπεζα για την επιστροφή των χρημάτων ενδέχεται να έχετε επιπλέον χρεώσεις από την τράπεζα σας.</li><li style=\"margin-bottom: var(--li-mb); font-size: 14px;\">Η συμπλήρωση της φόρμας ή η αποστολή του email είναι υποχρεωτική και δεν δεχόμαστε τηλεφωνικά αριθμούς λογαριασμών τραπέζης για αποφυγή λαθών.</li></ul><h4> </h4>\n															<svg viewBox=\"0 0 448 512\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M207.029 381.476L12.686 187.132c-9.373-9.373-9.373-24.569 0-33.941l22.667-22.667c9.357-9.357 24.522-9.375 33.901-.04L224 284.505l154.745-154.021c9.379-9.335 24.544-9.317 33.901.04l22.667 22.667c9.373 9.373 9.373 24.569 0 33.941L240.971 381.476c-9.373 9.372-24.569 9.372-33.942 0z\"></path></svg>\n								<svg viewBox=\"0 0 448 512\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M240.971 130.524l194.343 194.343c9.373 9.373 9.373 24.569 0 33.941l-22.667 22.667c-9.357 9.357-24.522 9.375-33.901.04L224 227.495 69.255 381.516c-9.379 9.335-24.544 9.317-33.901-.04l-22.667-22.667c-9.373-9.373-9.373-24.569 0-33.941L207.03 130.525c9.372-9.373 24.568-9.373 33.941-.001z\"></path></svg>\n												<a tabindex=\"0\">Μπορώ να πληρώσω με κάρτα;</a>\n					<p>Μπορείτε να πληρώσετε με κάρτα κατά την ολοκλήρωση της παραγγελίας σας.</p>\n					<link rel=\'stylesheet\' id=\'wp-block-library-css\' href=\'https://staging.promarketing.gr/wp-includes/css/dist/block-library/style.min.css?ver=6.9\' media=\'all\' />\nPlease select form to show\n\nMetadata:\n{\n    \"featured_image\": false,\n    \"excerpt\": \"\\u03a3\\u03c4\\u03bf\\u03b9\\u03c7\\u03b5\\u03af\\u03b1 \\u0395\\u03c0\\u03b9\\u03ba\\u03bf\\u03b9\\u03bd\\u03c9\\u03bd\\u03af\\u03b1\\u03c2 \\u03a0\\u03c1\\u03bf\\u03c2 \\u03c4\\u03bf \\u03c0\\u03b1\\u03c1\\u03cc\\u03bd \\u03c4\\u03bf \\u03ba\\u03b1\\u03c4\\u03ac\\u03c3\\u03c4\\u03b7\\u03bc\\u03b1 \\u03bb\\u03b5\\u03b9\\u03c4\\u03bf\\u03c5\\u03c1\\u03b3\\u03b5\\u03af \\u03bc\\u03cc\\u03bd\\u03bf \\u03b4\\u03b9\\u03b1\\u03b4\\u03b9\\u03ba\\u03c4\\u03c5\\u03b1\\u03ba\\u03ac \\u03ba\\u03b1\\u03b9 \\u03b4\\u03b5\\u03bd \\u03c0\\u03b1\\u03c1\\u03ad\\u03c7\\u03b5\\u03c4\\u03b1\\u03b9 \\u03b7 \\u03b4\\u03c5\\u03bd\\u03b1\\u03c4\\u03cc\\u03c4\\u03b7\\u03c4\\u03b1 \\u03c0\\u03b1\\u03c1\\u03b1\\u03bb\\u03b1\\u03b2\\u03ae\\u03c2 \\u03b1\\u03c0\\u03cc \\u03c4\\u03bf\\u03bd \\u03c7\\u03ce\\u03c1\\u03bf \\u03bc\\u03b1\\u03c2 \\u03ae \\u03b4\\u03bf\\u03ba\\u03b9\\u03bc\\u03ae\\u03c2 \\u03c4\\u03c9\\u03bd \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03c9\\u03bd.\\u00a0\\u038c\\u03bb\\u03b5\\u03c2 \\u03bf\\u03b9 \\u03c0\\u03b1\\u03c1\\u03b1\\u03b3\\u03b3\\u03b5\\u03bb\\u03af\\u03b5\\u03c2 \\u03b5\\u03ba\\u03c4\\u03b5\\u03bb\\u03bf\\u03cd\\u03bd\\u03c4\\u03b1\\u03b9 \\u03b4\\u03b9\\u03b1\\u03b4\\u03b9\\u03ba\\u03c4\\u03c5\\u03b1\\u03ba\\u03ac \\u03bc\\u03b5 \\u03c4\\u03b7\\u03bd \\u03c0\\u03b1\\u03c1\\u03b1\\u03bb\\u03b1\\u03b2\\u03ae \\u03c4\\u03c9\\u03bd \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03c9\\u03bd \\u039c\\u039f\\u039d\\u039f \\u03bc\\u03ad\\u03c3\\u03c9 \\u03c4\\u03b7\\u03c2 \\u03b5\\u03c0\\u03b9\\u03bb\\u03b5\\u03b3\\u03bc\\u03ad\\u03bd\\u03b7\\u03c2 \\u03b1\\u03c0\\u03cc \\u03b5\\u03c3\\u03ac\\u03c2 Courier \\u03c0\\u03bf\\u03c5 \\u03c3\\u03c5\\u03bd\\u03b5\\u03c1\\u03b3\\u03b1\\u03b6\\u03cc\\u03bc\\u03b1\\u03c3\\u03c4\\u03b5. \\u0394\\u03b5\\u03bd \\u03c0\\u03c1\\u03b1\\u03b3\\u03bc\\u03b1\\u03c4\\u03bf\\u03c0\\u03bf\\u03b9\\u03bf\\u03cd\\u03bc\\u03b5 \\u03b1\\u03bb\\u03bb\\u03b1\\u03b3\\u03ad\\u03c2 \\u03c7\\u03ad\\u03c1\\u03b9 \\u03bc\\u03b5 \\u03c7\\u03ad\\u03c1\\u03b9, \\u03b1\\u03bb\\u03bb\\u03ac \\u03c0\\u03c1\\u03b1\\u03b3\\u03bc\\u03b1\\u03c4\\u03bf\\u03c0\\u03bf\\u03b9\\u03bf\\u03cd\\u03bc\\u03b5 \\u03ac\\u03bc\\u03b5\\u03c3\\u03b5\\u03c2 \\u03b5\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ad\\u03c2 \\u03c7\\u03c1\\u03b7\\u03bc\\u03ac\\u03c4\\u03c9\\u03bd \\u03b2\\u03ac\\u03c3\\u03b7 \\u03c4\\u03b7\\u03c2 \\u03c0\\u03bf\\u03bb\\u03b9\\u03c4\\u03b9\\u03ba\\u03ae\\u03c2 \\u03bc\\u03b1\\u03c2 \\u03ba\\u03b1\\u03b9 \\u03c4\\u03b1\\u03c5\\u03c4\\u03cc\\u03c7\\u03c1\\u03bf\\u03bd\\u03b1 \\u03bc\\u03c0\\u03bf\\u03c1\\u03b5\\u03af\\u03c4\\u03b5 \\u03bd\\u03b1 \\u03ba\\u03ac\\u03bd\\u03b5\\u03c4\\u03b5 \\u03b5\\u03ba \\u03bd\\u03ad\\u03bf\\u03c5 \\u03c0\\u03b1\\u03c1\\u03b1\\u03b3\\u03b3\\u03b5\\u03bb\\u03af\\u03b1. \\u0393\\u03b9\\u03b1 \\u03b1\\u03bb\\u03bb\\u03b1\\u03b3\\u03ad\\u03c2-\\u03b5\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ad\\u03c2 \\u03b1\\u03ba\\u03bf\\u03bb\\u03bf\\u03c5\\u03b8\\u03ae\\u03c3\\u03c4\\u03b5 \\u03c4\\u03b9\\u03c2 \\u03c0\\u03b1\\u03c1\\u03b1\\u03ba\\u03ac\\u03c4\\u03c9 \\u03bf\\u03b4\\u03b7\\u03b3\\u03af\\u03b5\\u03c2 \\u03c0\\u03b1\\u03c4\\u03ce\\u03bd\\u03c4\\u03b1\\u03c2 \\u03b5\\u03b4\\u03ce. \\u0393\\u03b9\\u03b1 \\u03c0\\u03b1\\u03c1\\u03b1\\u03b3\\u03b3\\u03b5\\u03bb\\u03af\\u03b5\\u03c2 \\u03bc\\u03ad\\u03c3\\u03c9 Skroutz Marketplace, \\u03b8\\u03b1 \\u03c0\\u03c1\\u03ad\\u03c0\\u03b5\\u03b9 \\u03bd\\u03b1 \\u03b1\\u03c0\\u03b5\\u03c5\\u03b8\\u03cd\\u03bd\\u03b5\\u03c3\\u03c4\\u03b5 \\u03b1\\u03c0\\u03b5\\u03c5\\u03b8\\u03b5\\u03af\\u03b1\\u03c2 \\u03c3\\u03c4\\u03bf Skroutz \\u03ae \\u03bc\\u03ad\\u03c3\\u03c9 \\u03c4\\u03bf\\u03c5 account \\u03c3\\u03b1\\u03c2 \\u03c3\\u03c4\\u03bf Skroutz \\u03ba\\u03b1\\u03b9 \\u03cc\\u03c7\\u03b9 \\u03bc\\u03b1\\u03b6\\u03af \\u03bc\\u03b1\\u03c2.\\u00a0 \\u0393\\u03b9\\u03b1 \\u03bf\\u03c0\\u03bf\\u03b9\\u03b1\\u03b4\\u03ae\\u03c0\\u03bf\\u03c4\\u03b5 \\u03ac\\u03bb\\u03bb\\u03b7 \\u03b4\\u03b9\\u03b5\\u03c5\\u03ba\\u03c1\\u03af\\u03bd\\u03b9\\u03c3\\u03b7\",\n    \"modified_date\": \"2026-01-26 14:33:32\",\n    \"permalink\": \"https:\\/\\/staging.promarketing.gr\\/epikoinonia\\/\",\n    \"categories\": [],\n    \"tags\": []\n}","17ac17fa-af41-49fe-b7f4-c06c5f56632c","{\"post_id\":191}","1769590759"),
("11","post","Αποστολές &#038; Επιστροφές","<h4><strong>ΑΠΟΣΤΟΛΗ</strong></h4>\n<ul>\n<li><b>Δωρεάν&nbsp;</b>μεταφορικά για <b>αγορές άνω των 49€ (Με Box Now)</b></li>\n<li><b>10% Επιπλέον έκπτωση για αγορά 2 προϊόντων και άνω</b></li>\n<li style=\"margin-bottom: var(--li-mb); font-size: 14px;\">5% Επιπλέον έκπτωση&nbsp;για πληρωμές με κάρτα</li>\n<li style=\"margin-bottom: var(--li-mb); font-size: 14px;\"><b>Δικαίωμα αλλαγής ή επιστροφής χρημάτων&nbsp;</b>με κόστος 6€</li>\n<li style=\"margin-bottom: var(--li-mb); font-size: 14px;\"><b>Χρέωση 2.5€ </b>για πληρωμές με αντικαταβολή</li>\n</ul><h4 style=\"margin-bottom: var(--wd-tags-mb); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: var(--wd-title-font-weight); font-family: var(--wd-title-font); text-transform: none;\">ΑΛΛΑΓΕΣ &amp; ΕΠΙΣΤΡΟΦΕΣ</h4>\n<ul style=\"margin-bottom: 0px; padding-left: var(--li-pl); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-family: Lato, Arial, Helvetica, sans-serif; font-size: 14px; --list-mb: 20px; --li-mb: 10px; --li-pl: 17px; color: #777777;\">\n<li style=\"font-weight: 400; margin-bottom: var(--li-mb); font-size: 14px;\">Μπορείτε να κάνετε είτε αλλαγή είτε επιστροφή χρημάτων εντός 20 ημερών από την ημερομηνία αγοράς (όχι παραλαβής). Η διαδικασία αλλαγής ή επιστροφής χρημάτων κοστίζει 6€ και θα αφαιρείται από την αξία των προϊόντων που είχατε αγοράσει και όχι από το σύνολο της παραγγελίας (κόστη μεταφορικών ή αντικαταβολής). Σε περιπτώσεις ελλατωματικού προϊόντος ή λάθος από την πλευρά μας δεν επιβαρύνεστε με κανένα έξοδο.</li>\n<li style=\"font-weight: 400; margin-bottom: var(--li-mb); font-size: 14px;\">Είτε προχωρήσετε σε αλλαγή είτε σε επιστροφή χρημάτων, η διαδικασία είναι απλή καθώς μας στέλνετε πίσω τα προϊόντα που θέλετε να αλλάξετε ή να επιστρέψετε και εμείς σας επιστρέφουμε τα αντίστοιχα χρήματα στον λογαριασμό σας αφαιρώντας τα κόστη μεταφορικών (6€). Από εκεί και πέρα μπορείτε να προχωρήσετε σε νέα αγορά των προϊόντων που σας ενδιαφέρουν.</li>\n<li style=\"margin-bottom: var(--li-mb); font-size: 14px;\"><b>Αναλυτικές οδηγίες:&nbsp;</b>Συσκευάστε τα προϊόντα που θέλετε να κάνετε αλλαγή ή επιστροφή στην ίδια σακούλα που παραλάβατε, όπου αναγράφονται τα στοιχεία της εταιρείας μας στο Voucher που είναι κολλημένο έξω από την σακούλα. Παραδώστε την σακούλα στην ίδια Courier που παραλάβατε το δέμα και ζητήστε επιστροφή του δέματος με δική μας χρέωση. Εάν έχετε πετάξει την σακούλα με το Voucher, μεταβείτε σε ένα Elta Courier και δώστε τα παρακάτω στοιχεία: LikeMe.gr - Δοϊράνης 9 Καλλιθέα, 17671. Μόλις πραγματοποιήσετε την αποστολή - επιστροφή συμπληρώστε <a href=\"https://likeme.gr/forma-allagis-epistrofis/\" target=\"_blank\" rel=\"noopener\">την φόρμα που θα βρείτε πατώντας εδώ</a>.&nbsp;Εάν η παραγγελία σας ήταν μέσω κάρτας δεν χρειαζόμαστε κανένα άλλο στοιχείο. Μόλις παραλάβουμε το δέμα η επιστροφή χρημάτων θα γίνει εντός 5 εργάσιμων ημερών.</li>\n<li style=\"margin-bottom: var(--li-mb); font-size: 14px;\"><a href=\"https://likeme.gr/forma-allagis-epistrofis/\" target=\"_blank\" rel=\"noopener\">Πατήστε εδώ για την συμπλήρωση της φόρμας αλλαγής ή επιστροφής προϊόντων</a></li>\n<li style=\"margin-bottom: var(--li-mb); font-size: 14px;\">Κατά την επιστροφή των χρημάτων θα αφαιρεθούν 6€ από την αξία των προϊόντων + εκπτώσεων που μπορεί να είχατε λάβει.</li>\n<li style=\"margin-bottom: var(--li-mb); font-size: 14px;\">Για διατραπεζικές συναλλαγές χρησιμοποιούμε την Piraeus Bank &amp; την Eurobank. Σε περίπτωση που χρησιμοποιήσετε άλλη τράπεζα για την επιστροφή των χρημάτων ενδέχεται να έχετε επιπλέον χρεώσεις από την τράπεζα σας.</li>\n<li style=\"margin-bottom: var(--li-mb); font-size: 14px;\">Η συμπλήρωση της φόρμας ή η αποστολή του email είναι υποχρεωτική και δεν δεχόμαστε τηλεφωνικά αριθμούς λογαριασμών τραπέζης για αποφυγή λαθών.</li>\n</ul>\n<h4>&nbsp;</h4>\n\nMetadata:\n{\n    \"featured_image\": false,\n    \"excerpt\": \"\\u0391\\u03a0\\u039f\\u03a3\\u03a4\\u039f\\u039b\\u0397 \\u0394\\u03c9\\u03c1\\u03b5\\u03ac\\u03bd&nbsp;\\u03bc\\u03b5\\u03c4\\u03b1\\u03c6\\u03bf\\u03c1\\u03b9\\u03ba\\u03ac \\u03b3\\u03b9\\u03b1 \\u03b1\\u03b3\\u03bf\\u03c1\\u03ad\\u03c2 \\u03ac\\u03bd\\u03c9 \\u03c4\\u03c9\\u03bd 49\\u20ac (\\u039c\\u03b5 Box Now) 10% \\u0395\\u03c0\\u03b9\\u03c0\\u03bb\\u03ad\\u03bf\\u03bd \\u03ad\\u03ba\\u03c0\\u03c4\\u03c9\\u03c3\\u03b7 \\u03b3\\u03b9\\u03b1 \\u03b1\\u03b3\\u03bf\\u03c1\\u03ac 2 \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03c9\\u03bd \\u03ba\\u03b1\\u03b9 \\u03ac\\u03bd\\u03c9 5% \\u0395\\u03c0\\u03b9\\u03c0\\u03bb\\u03ad\\u03bf\\u03bd \\u03ad\\u03ba\\u03c0\\u03c4\\u03c9\\u03c3\\u03b7&nbsp;\\u03b3\\u03b9\\u03b1 \\u03c0\\u03bb\\u03b7\\u03c1\\u03c9\\u03bc\\u03ad\\u03c2 \\u03bc\\u03b5 \\u03ba\\u03ac\\u03c1\\u03c4\\u03b1 \\u0394\\u03b9\\u03ba\\u03b1\\u03af\\u03c9\\u03bc\\u03b1 \\u03b1\\u03bb\\u03bb\\u03b1\\u03b3\\u03ae\\u03c2 \\u03ae \\u03b5\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ae\\u03c2 \\u03c7\\u03c1\\u03b7\\u03bc\\u03ac\\u03c4\\u03c9\\u03bd&nbsp;\\u03bc\\u03b5 \\u03ba\\u03cc\\u03c3\\u03c4\\u03bf\\u03c2 6\\u20ac \\u03a7\\u03c1\\u03ad\\u03c9\\u03c3\\u03b7 2.5\\u20ac \\u03b3\\u03b9\\u03b1 \\u03c0\\u03bb\\u03b7\\u03c1\\u03c9\\u03bc\\u03ad\\u03c2 \\u03bc\\u03b5 \\u03b1\\u03bd\\u03c4\\u03b9\\u03ba\\u03b1\\u03c4\\u03b1\\u03b2\\u03bf\\u03bb\\u03ae \\u0391\\u039b\\u039b\\u0391\\u0393\\u0395\\u03a3 &amp; \\u0395\\u03a0\\u0399\\u03a3\\u03a4\\u03a1\\u039f\\u03a6\\u0395\\u03a3 \\u039c\\u03c0\\u03bf\\u03c1\\u03b5\\u03af\\u03c4\\u03b5 \\u03bd\\u03b1 \\u03ba\\u03ac\\u03bd\\u03b5\\u03c4\\u03b5 \\u03b5\\u03af\\u03c4\\u03b5 \\u03b1\\u03bb\\u03bb\\u03b1\\u03b3\\u03ae \\u03b5\\u03af\\u03c4\\u03b5 \\u03b5\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ae \\u03c7\\u03c1\\u03b7\\u03bc\\u03ac\\u03c4\\u03c9\\u03bd \\u03b5\\u03bd\\u03c4\\u03cc\\u03c2 20 \\u03b7\\u03bc\\u03b5\\u03c1\\u03ce\\u03bd \\u03b1\\u03c0\\u03cc \\u03c4\\u03b7\\u03bd \\u03b7\\u03bc\\u03b5\\u03c1\\u03bf\\u03bc\\u03b7\\u03bd\\u03af\\u03b1 \\u03b1\\u03b3\\u03bf\\u03c1\\u03ac\\u03c2 (\\u03cc\\u03c7\\u03b9 \\u03c0\\u03b1\\u03c1\\u03b1\\u03bb\\u03b1\\u03b2\\u03ae\\u03c2). \\u0397 \\u03b4\\u03b9\\u03b1\\u03b4\\u03b9\\u03ba\\u03b1\\u03c3\\u03af\\u03b1 \\u03b1\\u03bb\\u03bb\\u03b1\\u03b3\\u03ae\\u03c2 \\u03ae \\u03b5\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ae\\u03c2 \\u03c7\\u03c1\\u03b7\\u03bc\\u03ac\\u03c4\\u03c9\\u03bd \\u03ba\\u03bf\\u03c3\\u03c4\\u03af\\u03b6\\u03b5\\u03b9 6\\u20ac \\u03ba\\u03b1\\u03b9 \\u03b8\\u03b1 \\u03b1\\u03c6\\u03b1\\u03b9\\u03c1\\u03b5\\u03af\\u03c4\\u03b1\\u03b9 \\u03b1\\u03c0\\u03cc \\u03c4\\u03b7\\u03bd \\u03b1\\u03be\\u03af\\u03b1 \\u03c4\\u03c9\\u03bd \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03c9\\u03bd \\u03c0\\u03bf\\u03c5 \\u03b5\\u03af\\u03c7\\u03b1\\u03c4\\u03b5 \\u03b1\\u03b3\\u03bf\\u03c1\\u03ac\\u03c3\\u03b5\\u03b9 \\u03ba\\u03b1\\u03b9 \\u03cc\\u03c7\\u03b9 \\u03b1\\u03c0\\u03cc \\u03c4\\u03bf \\u03c3\\u03cd\\u03bd\\u03bf\\u03bb\\u03bf \\u03c4\\u03b7\\u03c2 \\u03c0\\u03b1\\u03c1\\u03b1\\u03b3\\u03b3\\u03b5\\u03bb\\u03af\\u03b1\\u03c2 (\\u03ba\\u03cc\\u03c3\\u03c4\\u03b7 \\u03bc\\u03b5\\u03c4\\u03b1\\u03c6\\u03bf\\u03c1\\u03b9\\u03ba\\u03ce\\u03bd \\u03ae \\u03b1\\u03bd\\u03c4\\u03b9\\u03ba\\u03b1\\u03c4\\u03b1\\u03b2\\u03bf\\u03bb\\u03ae\\u03c2). \\u03a3\\u03b5 \\u03c0\\u03b5\\u03c1\\u03b9\\u03c0\\u03c4\\u03ce\\u03c3\\u03b5\\u03b9\\u03c2 \\u03b5\\u03bb\\u03bb\\u03b1\\u03c4\\u03c9\\u03bc\\u03b1\\u03c4\\u03b9\\u03ba\\u03bf\\u03cd \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03bf\\u03c2 \\u03ae \\u03bb\\u03ac\\u03b8\\u03bf\\u03c2 \\u03b1\\u03c0\\u03cc \\u03c4\\u03b7\\u03bd \\u03c0\\u03bb\\u03b5\\u03c5\\u03c1\\u03ac \\u03bc\\u03b1\\u03c2 \\u03b4\\u03b5\\u03bd \\u03b5\\u03c0\\u03b9\\u03b2\\u03b1\\u03c1\\u03cd\\u03bd\\u03b5\\u03c3\\u03c4\\u03b5\",\n    \"modified_date\": \"2026-01-26 14:32:01\",\n    \"permalink\": \"https:\\/\\/staging.promarketing.gr\\/apostoles-kai-epistrofes\\/\",\n    \"categories\": [],\n    \"tags\": []\n}","c3cb8d87-431f-4c62-b03c-eb9a935bde4e","{\"post_id\":185}","1769590761"),
("12","post","Αγαπημένα","<h3>\n					Ο λογαριασμός μου				</h3>\n<nav aria-label=\"Σελίδες Λογαριασμού\">\n	<ul>\n					<li>\n				<a href=\"https://staging.promarketing.gr/my-account/\" aria-current=\"page\">\n					Πίνακας ελέγχου				</a>\n			</li>\n					<li>\n				<a href=\"https://staging.promarketing.gr/my-account/orders/\" >\n					Παραγγελίες				</a>\n			</li>\n					<li>\n				<a href=\"https://staging.promarketing.gr/my-account/downloads/\" >\n					Μεταφορτώσεις				</a>\n			</li>\n					<li>\n				<a href=\"https://staging.promarketing.gr/my-account/edit-address/\" >\n					Διευθύνσεις				</a>\n			</li>\n					<li>\n				<a href=\"https://staging.promarketing.gr/my-account/payment-methods/\" >\n					Μέθοδοι πληρωμής				</a>\n			</li>\n					<li>\n				<a href=\"https://staging.promarketing.gr/my-account/edit-account/\" >\n					Στοιχεία λογαριασμού				</a>\n			</li>\n					<li>\n				<a href=\"\" >\n					Wishlist				</a>\n			</li>\n					<li>\n				<a href=\"https://staging.promarketing.gr/my-account/customer-logout/?_wpnonce=43762c3687\" >\n					Logout				</a>\n			</li>\n			</ul>\n</nav>\n												<link rel=\"stylesheet\" id=\"wd-woo-page-empty-page-css\" href=\"https://staging.promarketing.gr/wp-content/themes/woodmart/css/parts/woo-page-empty-page.min.css?ver=8.3.8\" type=\"text/css\" media=\"all\" /> 					\n		<p>\n			This wishlist is empty.		</p>\n				Δεν έχετε αγαπημένα προϊόντα ακόμα.  <br> Θα βρείτε μεγάλη ποικιλία προϊόντων σε όλες τις κατηγορίες.			\n					<p>\n				<a href=\"https://staging.promarketing.gr/shop/\">\n					Return to shop				</a>\n			</p>\n\nMetadata:\n{\n    \"featured_image\": false,\n    \"excerpt\": \"\\u039f \\u03bb\\u03bf\\u03b3\\u03b1\\u03c1\\u03b9\\u03b1\\u03c3\\u03bc\\u03cc\\u03c2 \\u03bc\\u03bf\\u03c5 \\u03a0\\u03af\\u03bd\\u03b1\\u03ba\\u03b1\\u03c2 \\u03b5\\u03bb\\u03ad\\u03b3\\u03c7\\u03bf\\u03c5 \\u03a0\\u03b1\\u03c1\\u03b1\\u03b3\\u03b3\\u03b5\\u03bb\\u03af\\u03b5\\u03c2 \\u039c\\u03b5\\u03c4\\u03b1\\u03c6\\u03bf\\u03c1\\u03c4\\u03ce\\u03c3\\u03b5\\u03b9\\u03c2 \\u0394\\u03b9\\u03b5\\u03c5\\u03b8\\u03cd\\u03bd\\u03c3\\u03b5\\u03b9\\u03c2 \\u039c\\u03ad\\u03b8\\u03bf\\u03b4\\u03bf\\u03b9 \\u03c0\\u03bb\\u03b7\\u03c1\\u03c9\\u03bc\\u03ae\\u03c2 \\u03a3\\u03c4\\u03bf\\u03b9\\u03c7\\u03b5\\u03af\\u03b1 \\u03bb\\u03bf\\u03b3\\u03b1\\u03c1\\u03b9\\u03b1\\u03c3\\u03bc\\u03bf\\u03cd Wishlist Logout This wishlist is empty. \\u0394\\u03b5\\u03bd \\u03ad\\u03c7\\u03b5\\u03c4\\u03b5 \\u03b1\\u03b3\\u03b1\\u03c0\\u03b7\\u03bc\\u03ad\\u03bd\\u03b1 \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03b1 \\u03b1\\u03ba\\u03cc\\u03bc\\u03b1. \\u0398\\u03b1 \\u03b2\\u03c1\\u03b5\\u03af\\u03c4\\u03b5 \\u03bc\\u03b5\\u03b3\\u03ac\\u03bb\\u03b7 \\u03c0\\u03bf\\u03b9\\u03ba\\u03b9\\u03bb\\u03af\\u03b1 \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03c9\\u03bd \\u03c3\\u03b5 \\u03cc\\u03bb\\u03b5\\u03c2 \\u03c4\\u03b9\\u03c2 \\u03ba\\u03b1\\u03c4\\u03b7\\u03b3\\u03bf\\u03c1\\u03af\\u03b5\\u03c2. Return to shop\",\n    \"modified_date\": \"2026-01-26 14:30:29\",\n    \"permalink\": \"https:\\/\\/staging.promarketing.gr\\/wishlist\\/\",\n    \"categories\": [],\n    \"tags\": []\n}","c4b9f9a6-e541-4c6e-b617-1a8d8ffaff08","{\"post_id\":178}","1769590763");

INSERT IGNORE INTO `wpby_helpmate_documents` VALUES 
("13","post","Return Form","<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:jet-forms/text-field {\"label\":\"Υποχρεωτικό\",\"name\":\"name\",\"placeholder\":\"Ονομ/νυμο Παραγγελίας\",\"required\":true} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:jet-forms/number-field {\"label\":\"Υποχρεωτικό\",\"name\":\"til\",\"placeholder\":\"Κινητό Παραγγελίας\",\"required\":true} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p><strong>Συμπληρώστε τα παρακάτω μόνο εάν πληρώσατε την παραγγελία σας με Αντικαταβολή. Προτιμήστε τράπεζα Πειραιώς ή Eurobank για αποφυγή χρεώσεων εμβάσματος. Οι παραγγελίες που έχουν πληρωθεί με κάρτα θα επιστραφούν τα χρήματα στον ίδιο λογαριασμό που ανήκει η κάρτα που πληρώσατε την παραγγελία.</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"jetDynamicVisibility\":{\"jedv_enabled\":false,\"jedv_type\":\"show\",\"jedv_conditions\":[],\"jedv_relation\":\"AND\"}} -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:jet-forms/text-field {\"label\":\"Όνομα Τράπεζας\",\"name\":\"bank\"} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:jet-forms/text-field {\"label\":\"IBAN\",\"name\":\"iban\"} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:jet-forms/text-field {\"label\":\"Όνοματεπώνυμο Δικαιούχου\",\"name\":\"holder\"} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p><strong>Με το που λάβουμε τα επιστραφέντα προϊόντα, τα χρήματα θα φανούν στον λογαριασμό σας εντός 3 εργάσιμων ημερών. Το σύνολο της διαδικασίας επιστροφής δεν κρατάει συνήθως πάνω από 5 εργάσιμες ημέρες από την ημερομηνία αποστολής τους προς εμάς.</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:jet-forms/submit-field {\"label\":\"ΑΠΟΣΤΟΛΗ ΦΟΡΜΑΣ\"} /-->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\nMetadata:\n{\n    \"featured_image\": false,\n    \"excerpt\": \"\\u03a3\\u03c5\\u03bc\\u03c0\\u03bb\\u03b7\\u03c1\\u03ce\\u03c3\\u03c4\\u03b5 \\u03c4\\u03b1 \\u03c0\\u03b1\\u03c1\\u03b1\\u03ba\\u03ac\\u03c4\\u03c9 \\u03bc\\u03cc\\u03bd\\u03bf \\u03b5\\u03ac\\u03bd \\u03c0\\u03bb\\u03b7\\u03c1\\u03ce\\u03c3\\u03b1\\u03c4\\u03b5 \\u03c4\\u03b7\\u03bd \\u03c0\\u03b1\\u03c1\\u03b1\\u03b3\\u03b3\\u03b5\\u03bb\\u03af\\u03b1 \\u03c3\\u03b1\\u03c2 \\u03bc\\u03b5 \\u0391\\u03bd\\u03c4\\u03b9\\u03ba\\u03b1\\u03c4\\u03b1\\u03b2\\u03bf\\u03bb\\u03ae. \\u03a0\\u03c1\\u03bf\\u03c4\\u03b9\\u03bc\\u03ae\\u03c3\\u03c4\\u03b5 \\u03c4\\u03c1\\u03ac\\u03c0\\u03b5\\u03b6\\u03b1 \\u03a0\\u03b5\\u03b9\\u03c1\\u03b1\\u03b9\\u03ce\\u03c2 \\u03ae Eurobank \\u03b3\\u03b9\\u03b1 \\u03b1\\u03c0\\u03bf\\u03c6\\u03c5\\u03b3\\u03ae \\u03c7\\u03c1\\u03b5\\u03ce\\u03c3\\u03b5\\u03c9\\u03bd \\u03b5\\u03bc\\u03b2\\u03ac\\u03c3\\u03bc\\u03b1\\u03c4\\u03bf\\u03c2. \\u039f\\u03b9 \\u03c0\\u03b1\\u03c1\\u03b1\\u03b3\\u03b3\\u03b5\\u03bb\\u03af\\u03b5\\u03c2 \\u03c0\\u03bf\\u03c5 \\u03ad\\u03c7\\u03bf\\u03c5\\u03bd \\u03c0\\u03bb\\u03b7\\u03c1\\u03c9\\u03b8\\u03b5\\u03af \\u03bc\\u03b5 \\u03ba\\u03ac\\u03c1\\u03c4\\u03b1 \\u03b8\\u03b1 \\u03b5\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03b1\\u03c6\\u03bf\\u03cd\\u03bd \\u03c4\\u03b1 \\u03c7\\u03c1\\u03ae\\u03bc\\u03b1\\u03c4\\u03b1 \\u03c3\\u03c4\\u03bf\\u03bd \\u03af\\u03b4\\u03b9\\u03bf \\u03bb\\u03bf\\u03b3\\u03b1\\u03c1\\u03b9\\u03b1\\u03c3\\u03bc\\u03cc \\u03c0\\u03bf\\u03c5 \\u03b1\\u03bd\\u03ae\\u03ba\\u03b5\\u03b9 \\u03b7 \\u03ba\\u03ac\\u03c1\\u03c4\\u03b1 \\u03c0\\u03bf\\u03c5 \\u03c0\\u03bb\\u03b7\\u03c1\\u03ce\\u03c3\\u03b1\\u03c4\\u03b5 \\u03c4\\u03b7\\u03bd \\u03c0\\u03b1\\u03c1\\u03b1\\u03b3\\u03b3\\u03b5\\u03bb\\u03af\\u03b1. \\u039c\\u03b5 \\u03c4\\u03bf \\u03c0\\u03bf\\u03c5 \\u03bb\\u03ac\\u03b2\\u03bf\\u03c5\\u03bc\\u03b5 \\u03c4\\u03b1 \\u03b5\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03b1\\u03c6\\u03ad\\u03bd\\u03c4\\u03b1 \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03b1, \\u03c4\\u03b1 \\u03c7\\u03c1\\u03ae\\u03bc\\u03b1\\u03c4\\u03b1 \\u03b8\\u03b1 \\u03c6\\u03b1\\u03bd\\u03bf\\u03cd\\u03bd \\u03c3\\u03c4\\u03bf\\u03bd \\u03bb\\u03bf\\u03b3\\u03b1\\u03c1\\u03b9\\u03b1\\u03c3\\u03bc\\u03cc \\u03c3\\u03b1\\u03c2 \\u03b5\\u03bd\\u03c4\\u03cc\\u03c2 3 \\u03b5\\u03c1\\u03b3\\u03ac\\u03c3\\u03b9\\u03bc\\u03c9\\u03bd \\u03b7\\u03bc\\u03b5\\u03c1\\u03ce\\u03bd. \\u03a4\\u03bf \\u03c3\\u03cd\\u03bd\\u03bf\\u03bb\\u03bf \\u03c4\\u03b7\\u03c2 \\u03b4\\u03b9\\u03b1\\u03b4\\u03b9\\u03ba\\u03b1\\u03c3\\u03af\\u03b1\\u03c2 \\u03b5\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ae\\u03c2 \\u03b4\\u03b5\\u03bd \\u03ba\\u03c1\\u03b1\\u03c4\\u03ac\\u03b5\\u03b9 \\u03c3\\u03c5\\u03bd\\u03ae\\u03b8\\u03c9\\u03c2 \\u03c0\\u03ac\\u03bd\\u03c9 \\u03b1\\u03c0\\u03cc 5 \\u03b5\\u03c1\\u03b3\\u03ac\\u03c3\\u03b9\\u03bc\\u03b5\\u03c2 \\u03b7\\u03bc\\u03ad\\u03c1\\u03b5\\u03c2 \\u03b1\\u03c0\\u03cc \\u03c4\\u03b7\\u03bd \\u03b7\\u03bc\\u03b5\\u03c1\\u03bf\\u03bc\\u03b7\\u03bd\\u03af\\u03b1 \\u03b1\\u03c0\\u03bf\\u03c3\\u03c4\\u03bf\\u03bb\\u03ae\\u03c2 \\u03c4\\u03bf\\u03c5\\u03c2 \\u03c0\\u03c1\\u03bf\\u03c2 \\u03b5\\u03bc\\u03ac\\u03c2.\",\n    \"modified_date\": \"2026-01-26 14:23:55\",\n    \"permalink\": \"https:\\/\\/staging.promarketing.gr\\/?post_type=jet-form-builder&p=162\",\n    \"categories\": [],\n    \"tags\": []\n}","4bf70cad-a0c4-4917-bc2d-c13ca3bf296b","{\"post_id\":162}","1769590764"),
("14","post","ΕΠΙΚΟΙΝΩΝΙΑ","<!-- wp:jet-forms/text-field {\"enable_input_mask\":true,\"name\":\"name\",\"placeholder\":\"Όνομα\"} /-->\n\n<!-- wp:jet-forms/text-field {\"field_type\":\"email\",\"name\":\"email\",\"placeholder\":\"Email\"} /-->\n\n<!-- wp:jet-forms/text-field {\"field_type\":\"tel\",\"name\":\"tel\",\"placeholder\":\"Τηλέφωνο\"} /-->\n\n<!-- wp:jet-forms/textarea-field /-->\n\n<!-- wp:jet-forms/submit-field {\"label\":\"ΑΠΟΣΤΟΛΗ\"} /-->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\nMetadata:\n{\n    \"featured_image\": false,\n    \"excerpt\": \"\",\n    \"modified_date\": \"2026-01-26 14:23:34\",\n    \"permalink\": \"https:\\/\\/staging.promarketing.gr\\/?post_type=jet-form-builder&p=160\",\n    \"categories\": [],\n    \"tags\": []\n}","57f4d16f-4d9a-4486-b581-16f4944db798","{\"post_id\":160}","1769590767"),
("15","post","Footer","<figure><img src=\"https://staging.promarketing.gr/wp-content/uploads/elementor/thumbs/shipped-ri7z1x8f70e40bdqvxww5gintuud6sl19u46od5ko8.png\" title=\"shipped.png\" alt=\"shipped.png\" loading=\"lazy\" /></figure><h5>Δωρεάν Μεταφορικά</h5><p>Για αγορές άνω των 49€</p>					<figure><img src=\"https://staging.promarketing.gr/wp-content/uploads/elementor/thumbs/parcel-ri7z1x8f70e40bdqvxww5gintuud6sl19u46od5ko8.png\" title=\"parcel.png\" alt=\"parcel.png\" loading=\"lazy\" /></figure><h5>Αλλαγές - Επιστροφές</h5><p>Δικαίωμα αλλαγής ή επιστροφής εντός 20 ημερών</p>					<figure><img src=\"https://staging.promarketing.gr/wp-content/uploads/elementor/thumbs/fast-delivery-ri7z1x8f70e40bdqvxww5gintuud6sl19u46od5ko8.png\" title=\"fast-delivery.png\" alt=\"fast-delivery.png\" loading=\"lazy\" /></figure><h5>Παράδοση σε 1-2 Ημέρες</h5><p>Το 90% των προϊόντων, παραδίδονται σε μία ημέρα</p>					<figure><img src=\"https://staging.promarketing.gr/wp-content/uploads/elementor/thumbs/discount-tag-pngrepo-com-ri7z1x8f70e40bdqvxww5gintuud6sl19u46od5ko8.png\" title=\"discount-tag-pngrepo-com.png\" alt=\"discount-tag-pngrepo-com.png\" loading=\"lazy\" /></figure><h5>Επιπλέον Έκπτωση 15%</h5><p>Με 2 προϊόντα &amp; άνω + Κάρτα</p>															<img src=\"https://staging.promarketing.gr/wp-content/uploads/elementor/thumbs/likeme-logo-horizontal-white-ri7z1x8fsxrh4fg6labseu6trr9vlu84bi60pmlqpa.png\" title=\"likeme-logo-horizontal-white.png\" alt=\"likeme-logo-horizontal-white.png\" loading=\"lazy\" />													<p>Στο κατάστημα μας θα βρείτε επιλεγμένες μάρκες ένδυσης και αξεσουάρ με προτεραιότητα, τα μοντέρνα, ποιοτικά και οικονομικά ρούχα και αξεσουάρ για τον Άνδρα, την Γυναίκα και την Plus Size Ένδυση.</p><p>Νέες Παραλαβές κάθε εβδομάδα με καινούργιες προσφορές και εκπτώσεις. Μην χάνετε άλλο χρόνο στην αναζήτηση αυτού που χρειάζεται η ντουλάπα σας.</p>			<h2>ΚΑΤΗΓΟΡΙΕΣ</h2>		<p><a href=\"https://likeme.gr/andriki-moda/andrika-okonomika-rouxa/\">Ανδρική Ένδυση</a></p><p><a href=\"https://likeme.gr/ginaikeia-moda/ginaikeia-plus-size-rouxa-oikonomika/\">Plus Size Ένδυση</a></p><p><a href=\"https://likeme.gr/ginaikeia-moda/ginaikeia-oikonomika-rouxa/\">Γυναικεία Ένδυση</a></p><p><a href=\"https://likeme.gr/andriki-moda/\">Men\'s New Collection</a></p><p><a href=\"https://likeme.gr/ginaikeia-moda/\">Women\'s New Collection</a></p>			<h2>ΧΡΗΣΙΜΑ LINKS</h2>		<p><a href=\"https://likeme.gr/apostoles-kai-epistrofes/\">Αποστολές &amp; Επιστροφές</a></p><p><a href=\"https://likeme.gr/forma-allagis-epistrofis/\">Φόρμα Αλλαγών - Επιστροφών</a></p><p><a href=\"https://www.elta-courier.gr/search?br=\" target=\"_blank\" rel=\"noopener\">Παρακολούθηση Παραγγελίας</a></p><p><a href=\"https://likeme.gr/oroi-kai-proipotheseis/\">Όροι &amp; Προϋποθέσεις</a></p><p><a href=\"https://likeme.gr/privacy-policy/\">Πολιτική Απορρήτου</a></p>			<h2>ΕΠΙΚΟΙΝΩΝΙΑ</h2>		<p>Email: pro@likeme.gr</p><p>Ωράριο Λειτουργίας: 10:00 - 18:00</p><p>Ημέρες Λειτουργίας: Δευτέρα - Σάββατο</p><p>Αριθμός ΓΕΜΗ: 159378403000</p>					\n					<a href=\"https://www.facebook.com/LikeMe.gr/\" target=\"_blank\">\n						Facebook\n						<svg aria-hidden=\"true\" viewBox=\"0 0 512 512\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z\"></path></svg>					</a>\n					<a href=\"https://www.instagram.com/likeme.gr/\" target=\"_blank\">\n						Instagram\n						<svg aria-hidden=\"true\" viewBox=\"0 0 448 512\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z\"></path></svg>					</a>\n					<a href=\"https://www.youtube.com/channel/UC-D0pufYikoi3G4hsufXrSQ\" target=\"_blank\">\n						Youtube\n						<svg aria-hidden=\"true\" viewBox=\"0 0 576 512\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z\"></path></svg>					</a>\n				<p>© 2022 <a href=\"https://likeme.gr\">LIKEME.GR</a></p><p>Σχεδιασμός &amp; Premium Marketing Services <a href=\"https://promarketing.gr/\" target=\"_blank\" rel=\"noopener\">ProMarketing.gr</a></p>													<img src=\"https://staging.promarketing.gr/wp-content/uploads/elementor/thumbs/payment-methods-ri7z1x8hmpx9ujocpjlusapcqzx0on2x8yt0waj48k.jpg\" title=\"payment-methods.jpg\" alt=\"payment-methods.jpg\" loading=\"lazy\" />\n\nMetadata:\n{\n    \"featured_image\": false,\n    \"excerpt\": \"\\u0394\\u03c9\\u03c1\\u03b5\\u03ac\\u03bd \\u039c\\u03b5\\u03c4\\u03b1\\u03c6\\u03bf\\u03c1\\u03b9\\u03ba\\u03ac \\u0393\\u03b9\\u03b1 \\u03b1\\u03b3\\u03bf\\u03c1\\u03ad\\u03c2 \\u03ac\\u03bd\\u03c9 \\u03c4\\u03c9\\u03bd 49\\u20ac \\u0391\\u03bb\\u03bb\\u03b1\\u03b3\\u03ad\\u03c2 &#8211; \\u0395\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ad\\u03c2 \\u0394\\u03b9\\u03ba\\u03b1\\u03af\\u03c9\\u03bc\\u03b1 \\u03b1\\u03bb\\u03bb\\u03b1\\u03b3\\u03ae\\u03c2 \\u03ae \\u03b5\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ae\\u03c2 \\u03b5\\u03bd\\u03c4\\u03cc\\u03c2 20 \\u03b7\\u03bc\\u03b5\\u03c1\\u03ce\\u03bd \\u03a0\\u03b1\\u03c1\\u03ac\\u03b4\\u03bf\\u03c3\\u03b7 \\u03c3\\u03b5 1-2 \\u0397\\u03bc\\u03ad\\u03c1\\u03b5\\u03c2 \\u03a4\\u03bf 90% \\u03c4\\u03c9\\u03bd \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03c9\\u03bd, \\u03c0\\u03b1\\u03c1\\u03b1\\u03b4\\u03af\\u03b4\\u03bf\\u03bd\\u03c4\\u03b1\\u03b9 \\u03c3\\u03b5 \\u03bc\\u03af\\u03b1 \\u03b7\\u03bc\\u03ad\\u03c1\\u03b1 \\u0395\\u03c0\\u03b9\\u03c0\\u03bb\\u03ad\\u03bf\\u03bd \\u0388\\u03ba\\u03c0\\u03c4\\u03c9\\u03c3\\u03b7 15% \\u039c\\u03b5 2 \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03b1 &amp; \\u03ac\\u03bd\\u03c9 + \\u039a\\u03ac\\u03c1\\u03c4\\u03b1 \\u03a3\\u03c4\\u03bf \\u03ba\\u03b1\\u03c4\\u03ac\\u03c3\\u03c4\\u03b7\\u03bc\\u03b1 \\u03bc\\u03b1\\u03c2 \\u03b8\\u03b1 \\u03b2\\u03c1\\u03b5\\u03af\\u03c4\\u03b5 \\u03b5\\u03c0\\u03b9\\u03bb\\u03b5\\u03b3\\u03bc\\u03ad\\u03bd\\u03b5\\u03c2 \\u03bc\\u03ac\\u03c1\\u03ba\\u03b5\\u03c2 \\u03ad\\u03bd\\u03b4\\u03c5\\u03c3\\u03b7\\u03c2 \\u03ba\\u03b1\\u03b9 \\u03b1\\u03be\\u03b5\\u03c3\\u03bf\\u03c5\\u03ac\\u03c1 \\u03bc\\u03b5 \\u03c0\\u03c1\\u03bf\\u03c4\\u03b5\\u03c1\\u03b1\\u03b9\\u03cc\\u03c4\\u03b7\\u03c4\\u03b1, \\u03c4\\u03b1 \\u03bc\\u03bf\\u03bd\\u03c4\\u03ad\\u03c1\\u03bd\\u03b1, \\u03c0\\u03bf\\u03b9\\u03bf\\u03c4\\u03b9\\u03ba\\u03ac \\u03ba\\u03b1\\u03b9 \\u03bf\\u03b9\\u03ba\\u03bf\\u03bd\\u03bf\\u03bc\\u03b9\\u03ba\\u03ac \\u03c1\\u03bf\\u03cd\\u03c7\\u03b1 \\u03ba\\u03b1\\u03b9 \\u03b1\\u03be\\u03b5\\u03c3\\u03bf\\u03c5\\u03ac\\u03c1 \\u03b3\\u03b9\\u03b1 \\u03c4\\u03bf\\u03bd \\u0386\\u03bd\\u03b4\\u03c1\\u03b1, \\u03c4\\u03b7\\u03bd \\u0393\\u03c5\\u03bd\\u03b1\\u03af\\u03ba\\u03b1 \\u03ba\\u03b1\\u03b9 \\u03c4\\u03b7\\u03bd Plus Size \\u0388\\u03bd\\u03b4\\u03c5\\u03c3\\u03b7. \\u039d\\u03ad\\u03b5\\u03c2 \\u03a0\\u03b1\\u03c1\\u03b1\\u03bb\\u03b1\\u03b2\\u03ad\\u03c2 \\u03ba\\u03ac\\u03b8\\u03b5 \\u03b5\\u03b2\\u03b4\\u03bf\\u03bc\\u03ac\\u03b4\\u03b1 \\u03bc\\u03b5 \\u03ba\\u03b1\\u03b9\\u03bd\\u03bf\\u03cd\\u03c1\\u03b3\\u03b9\\u03b5\\u03c2 \\u03c0\\u03c1\\u03bf\\u03c3\\u03c6\\u03bf\\u03c1\\u03ad\\u03c2 \\u03ba\\u03b1\\u03b9 \\u03b5\\u03ba\\u03c0\\u03c4\\u03ce\\u03c3\\u03b5\\u03b9\\u03c2. \\u039c\\u03b7\\u03bd \\u03c7\\u03ac\\u03bd\\u03b5\\u03c4\\u03b5 \\u03ac\\u03bb\\u03bb\\u03bf \\u03c7\\u03c1\\u03cc\\u03bd\\u03bf \\u03c3\\u03c4\\u03b7\\u03bd \\u03b1\\u03bd\\u03b1\\u03b6\\u03ae\\u03c4\\u03b7\\u03c3\\u03b7 \\u03b1\\u03c5\\u03c4\\u03bf\\u03cd \\u03c0\\u03bf\\u03c5 \\u03c7\\u03c1\\u03b5\\u03b9\\u03ac\\u03b6\\u03b5\\u03c4\\u03b1\\u03b9 \\u03b7 \\u03bd\\u03c4\\u03bf\\u03c5\\u03bb\\u03ac\\u03c0\\u03b1 \\u03c3\\u03b1\\u03c2. \\u039a\\u0391\\u03a4\\u0397\\u0393\\u039f\\u03a1\\u0399\\u0395\\u03a3 \\u0391\\u03bd\\u03b4\\u03c1\\u03b9\\u03ba\\u03ae \\u0388\\u03bd\\u03b4\\u03c5\\u03c3\\u03b7 Plus Size \\u0388\\u03bd\\u03b4\\u03c5\\u03c3\\u03b7 \\u0393\\u03c5\\u03bd\\u03b1\\u03b9\\u03ba\\u03b5\\u03af\\u03b1 \\u0388\\u03bd\\u03b4\\u03c5\\u03c3\\u03b7 Men&#8217;s New\",\n    \"modified_date\": \"2026-01-27 10:55:17\",\n    \"permalink\": \"https:\\/\\/staging.promarketing.gr\\/?cms_block=footer\",\n    \"categories\": [],\n    \"tags\": []\n}","c6fdc85a-99ea-485d-8997-967569c98095","{\"post_id\":157}","1769590770"),
("16","post","Delivery Time","\n\nMetadata:\n{\n    \"featured_image\": false,\n    \"excerpt\": \"\",\n    \"modified_date\": \"2026-01-26 14:18:35\",\n    \"permalink\": \"https:\\/\\/staging.promarketing.gr\\/?cms_block=delivery-time\",\n    \"categories\": [],\n    \"tags\": []\n}","efa5d503-3c5f-42dc-96d9-730a934be187","{\"post_id\":153}","1769590771"),
("17","post","Αποστολές &amp; Επιστροφές","<h4 style=\"margin-bottom: var(--wd-tags-mb); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: var(--wd-title-font-weight); font-family: Roboto, Arial, Helvetica, sans-serif; text-transform: none;\">ΑΠΟΣΤΟΛΗ</h4><h4><ul style=\"margin-bottom: 0px; padding-left: var(--li-pl); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; font-family: Roboto, Arial, Helvetica, sans-serif; font-size: 14px; --list-mb: 20px; --li-mb: 10px; --li-pl: 17px; color: rgb(119, 119, 119);\"><li style=\"margin-bottom: var(--li-mb); font-size: 14px;\">Δωρεάν&nbsp;μεταφορικά για&nbsp;αγορές άνω των 49€ (Με Box Now)</li><li style=\"margin-bottom: var(--li-mb); font-size: 14px;\">10% Επιπλέον έκπτωση για αγορά 2 προϊόντων και άνω</li><li style=\"margin-bottom: var(--li-mb); font-size: 14px;\">5% Επιπλέον έκπτωση&nbsp;για πληρωμές με κάρτα</li><li style=\"margin-bottom: var(--li-mb); font-size: 14px;\">Δικαίωμα αλλαγής ή επιστροφής χρημάτων&nbsp;με κόστος 6€</li><li style=\"margin-bottom: var(--li-mb); font-size: 14px;\">Χρέωση 2.5€&nbsp;για πληρωμές με αντικαταβολή</li></ul></h4><ul>\n</ul><h4 style=\"margin-bottom: var(--wd-tags-mb); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: var(--wd-title-font-weight); font-family: var(--wd-title-font); text-transform: none;\">ΑΛΛΑΓΕΣ &amp; ΕΠΙΣΤΡΟΦΕΣ</h4>\n<ul style=\"margin-bottom: 0px; padding-left: var(--li-pl); font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-family: Lato, Arial, Helvetica, sans-serif; font-size: 14px; --list-mb: 20px; --li-mb: 10px; --li-pl: 17px; color: #777777;\">\n<li style=\"font-weight: 400; margin-bottom: var(--li-mb); font-size: 14px;\">Μπορείτε να κάνετε είτε αλλαγή είτε επιστροφή χρημάτων εντός 20 ημερών από την ημερομηνία αγοράς (όχι παραλαβής). Η διαδικασία αλλαγής ή επιστροφής χρημάτων κοστίζει 6€ και θα αφαιρείται από την αξία των προϊόντων που είχατε αγοράσει και όχι από το σύνολο της παραγγελίας (κόστη μεταφορικών ή αντικαταβολής). Σε περιπτώσεις ελλατωματικού προϊόντος ή λάθος από την πλευρά μας δεν επιβαρύνεστε με κανένα έξοδο.</li>\n<li style=\"font-weight: 400; margin-bottom: var(--li-mb); font-size: 14px;\">Είτε προχωρήσετε σε αλλαγή είτε σε επιστροφή χρημάτων, η διαδικασία είναι απλή καθώς μας στέλνετε πίσω τα προϊόντα που θέλετε να αλλάξετε ή να επιστρέψετε και εμείς σας επιστρέφουμε τα αντίστοιχα χρήματα στον λογαριασμό σας αφαιρώντας τα κόστη μεταφορικών (6€). Από εκεί και πέρα μπορείτε να προχωρήσετε σε νέα αγορά των προϊόντων που σας ενδιαφέρουν.</li>\n<li style=\"margin-bottom: var(--li-mb); font-size: 14px;\"><b>Αναλυτικές οδηγίες:&nbsp;</b>Συσκευάστε τα προϊόντα που θέλετε να κάνετε αλλαγή ή επιστροφή στην ίδια σακούλα που παραλάβατε, όπου αναγράφονται τα στοιχεία της εταιρείας μας στο Voucher που είναι κολλημένο έξω από την σακούλα. Παραδώστε την σακούλα στην ίδια Courier που παραλάβατε το δέμα και ζητήστε επιστροφή του δέματος με δική μας χρέωση. Εάν έχετε πετάξει την σακούλα με το Voucher, μεταβείτε σε ένα Elta Courier και δώστε τα παρακάτω στοιχεία: LikeMe.gr - Δοϊράνης 9 Καλλιθέα, 17671. Μόλις πραγματοποιήσετε την αποστολή - επιστροφή συμπληρώστε <a href=\"https://likeme.gr/forma-allagis-epistrofis/\" target=\"_blank\" rel=\"noopener\">την φόρμα που θα βρείτε πατώντας εδώ</a> ή στείλτε μας ένα email στο pro@likeme.gr με τα παρακάτω στοιχεία: Αριθμός παραγγελίας, Κινητό παραγγελίας, Αριθμός Voucher. Εάν η παραγγελία σας ήταν με αντικαταβολή χρειαζόμαστε και τα στοιχεία τραπέζης (IBAN, όνομα δικαιούχου, όνομα τραπέζης). Εάν η παραγγελία σας ήταν μέσω κάρτας δεν χρειαζόμαστε κανένα άλλο στοιχείο. Μόλις παραλάβουμε το δέμα η επιστροφή χρημάτων θα γίνει εντός 5 εργάσιμων ημερών.</li>\n<li style=\"margin-bottom: var(--li-mb); font-size: 14px;\"><a href=\"https://likeme.gr/forma-allagis-epistrofis/\" target=\"_blank\" rel=\"noopener\">Πατήστε εδώ για την συμπλήρωση της φόρμας αλλαγής ή επιστροφής προϊόντων</a></li>\n<li style=\"margin-bottom: var(--li-mb); font-size: 14px;\">Κατά την επιστροφή των χρημάτων θα αφαιρεθούν 6€ από την αξία των προϊόντων + εκπτώσεων που μπορεί να είχατε λάβει.</li>\n<li style=\"margin-bottom: var(--li-mb); font-size: 14px;\">Για διατραπεζικές συναλλαγές χρησιμοποιούμε την Alpha Bank &amp; την Eurobank. Σε περίπτωση που χρησιμοποιήσετε άλλη τράπεζα για την επιστροφή των χρημάτων ενδέχεται να έχετε επιπλέον χρεώσεις από την τράπεζα σας.</li>\n<li style=\"margin-bottom: var(--li-mb); font-size: 14px;\">Η συμπλήρωση της φόρμας ή η αποστολή του email είναι υποχρεωτική και δεν δεχόμαστε τηλεφωνικά αριθμούς λογαριασμών τραπέζης για αποφυγή λαθών.</li>\n</ul>\n<h4>&nbsp;</h4>\n\nMetadata:\n{\n    \"featured_image\": false,\n    \"excerpt\": \"\\u0391\\u03a0\\u039f\\u03a3\\u03a4\\u039f\\u039b\\u0397 \\u0394\\u03c9\\u03c1\\u03b5\\u03ac\\u03bd&nbsp;\\u03bc\\u03b5\\u03c4\\u03b1\\u03c6\\u03bf\\u03c1\\u03b9\\u03ba\\u03ac \\u03b3\\u03b9\\u03b1&nbsp;\\u03b1\\u03b3\\u03bf\\u03c1\\u03ad\\u03c2 \\u03ac\\u03bd\\u03c9 \\u03c4\\u03c9\\u03bd 49\\u20ac (\\u039c\\u03b5 Box Now) 10% \\u0395\\u03c0\\u03b9\\u03c0\\u03bb\\u03ad\\u03bf\\u03bd \\u03ad\\u03ba\\u03c0\\u03c4\\u03c9\\u03c3\\u03b7 \\u03b3\\u03b9\\u03b1 \\u03b1\\u03b3\\u03bf\\u03c1\\u03ac 2 \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03c9\\u03bd \\u03ba\\u03b1\\u03b9 \\u03ac\\u03bd\\u03c9 5% \\u0395\\u03c0\\u03b9\\u03c0\\u03bb\\u03ad\\u03bf\\u03bd \\u03ad\\u03ba\\u03c0\\u03c4\\u03c9\\u03c3\\u03b7&nbsp;\\u03b3\\u03b9\\u03b1 \\u03c0\\u03bb\\u03b7\\u03c1\\u03c9\\u03bc\\u03ad\\u03c2 \\u03bc\\u03b5 \\u03ba\\u03ac\\u03c1\\u03c4\\u03b1 \\u0394\\u03b9\\u03ba\\u03b1\\u03af\\u03c9\\u03bc\\u03b1 \\u03b1\\u03bb\\u03bb\\u03b1\\u03b3\\u03ae\\u03c2 \\u03ae \\u03b5\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ae\\u03c2 \\u03c7\\u03c1\\u03b7\\u03bc\\u03ac\\u03c4\\u03c9\\u03bd&nbsp;\\u03bc\\u03b5 \\u03ba\\u03cc\\u03c3\\u03c4\\u03bf\\u03c2 6\\u20ac \\u03a7\\u03c1\\u03ad\\u03c9\\u03c3\\u03b7 2.5\\u20ac&nbsp;\\u03b3\\u03b9\\u03b1 \\u03c0\\u03bb\\u03b7\\u03c1\\u03c9\\u03bc\\u03ad\\u03c2 \\u03bc\\u03b5 \\u03b1\\u03bd\\u03c4\\u03b9\\u03ba\\u03b1\\u03c4\\u03b1\\u03b2\\u03bf\\u03bb\\u03ae \\u0391\\u039b\\u039b\\u0391\\u0393\\u0395\\u03a3 &amp; \\u0395\\u03a0\\u0399\\u03a3\\u03a4\\u03a1\\u039f\\u03a6\\u0395\\u03a3 \\u039c\\u03c0\\u03bf\\u03c1\\u03b5\\u03af\\u03c4\\u03b5 \\u03bd\\u03b1 \\u03ba\\u03ac\\u03bd\\u03b5\\u03c4\\u03b5 \\u03b5\\u03af\\u03c4\\u03b5 \\u03b1\\u03bb\\u03bb\\u03b1\\u03b3\\u03ae \\u03b5\\u03af\\u03c4\\u03b5 \\u03b5\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ae \\u03c7\\u03c1\\u03b7\\u03bc\\u03ac\\u03c4\\u03c9\\u03bd \\u03b5\\u03bd\\u03c4\\u03cc\\u03c2 20 \\u03b7\\u03bc\\u03b5\\u03c1\\u03ce\\u03bd \\u03b1\\u03c0\\u03cc \\u03c4\\u03b7\\u03bd \\u03b7\\u03bc\\u03b5\\u03c1\\u03bf\\u03bc\\u03b7\\u03bd\\u03af\\u03b1 \\u03b1\\u03b3\\u03bf\\u03c1\\u03ac\\u03c2 (\\u03cc\\u03c7\\u03b9 \\u03c0\\u03b1\\u03c1\\u03b1\\u03bb\\u03b1\\u03b2\\u03ae\\u03c2). \\u0397 \\u03b4\\u03b9\\u03b1\\u03b4\\u03b9\\u03ba\\u03b1\\u03c3\\u03af\\u03b1 \\u03b1\\u03bb\\u03bb\\u03b1\\u03b3\\u03ae\\u03c2 \\u03ae \\u03b5\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ae\\u03c2 \\u03c7\\u03c1\\u03b7\\u03bc\\u03ac\\u03c4\\u03c9\\u03bd \\u03ba\\u03bf\\u03c3\\u03c4\\u03af\\u03b6\\u03b5\\u03b9 6\\u20ac \\u03ba\\u03b1\\u03b9 \\u03b8\\u03b1 \\u03b1\\u03c6\\u03b1\\u03b9\\u03c1\\u03b5\\u03af\\u03c4\\u03b1\\u03b9 \\u03b1\\u03c0\\u03cc \\u03c4\\u03b7\\u03bd \\u03b1\\u03be\\u03af\\u03b1 \\u03c4\\u03c9\\u03bd \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03c9\\u03bd \\u03c0\\u03bf\\u03c5 \\u03b5\\u03af\\u03c7\\u03b1\\u03c4\\u03b5 \\u03b1\\u03b3\\u03bf\\u03c1\\u03ac\\u03c3\\u03b5\\u03b9 \\u03ba\\u03b1\\u03b9 \\u03cc\\u03c7\\u03b9 \\u03b1\\u03c0\\u03cc \\u03c4\\u03bf \\u03c3\\u03cd\\u03bd\\u03bf\\u03bb\\u03bf \\u03c4\\u03b7\\u03c2 \\u03c0\\u03b1\\u03c1\\u03b1\\u03b3\\u03b3\\u03b5\\u03bb\\u03af\\u03b1\\u03c2 (\\u03ba\\u03cc\\u03c3\\u03c4\\u03b7 \\u03bc\\u03b5\\u03c4\\u03b1\\u03c6\\u03bf\\u03c1\\u03b9\\u03ba\\u03ce\\u03bd \\u03ae \\u03b1\\u03bd\\u03c4\\u03b9\\u03ba\\u03b1\\u03c4\\u03b1\\u03b2\\u03bf\\u03bb\\u03ae\\u03c2). \\u03a3\\u03b5 \\u03c0\\u03b5\\u03c1\\u03b9\\u03c0\\u03c4\\u03ce\\u03c3\\u03b5\\u03b9\\u03c2 \\u03b5\\u03bb\\u03bb\\u03b1\\u03c4\\u03c9\\u03bc\\u03b1\\u03c4\\u03b9\\u03ba\\u03bf\\u03cd \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03bf\\u03c2 \\u03ae \\u03bb\\u03ac\\u03b8\\u03bf\\u03c2 \\u03b1\\u03c0\\u03cc \\u03c4\\u03b7\\u03bd \\u03c0\\u03bb\\u03b5\\u03c5\\u03c1\\u03ac \\u03bc\\u03b1\\u03c2 \\u03b4\\u03b5\\u03bd \\u03b5\\u03c0\\u03b9\\u03b2\\u03b1\\u03c1\\u03cd\\u03bd\\u03b5\\u03c3\\u03c4\\u03b5 \\u03bc\\u03b5 \\u03ba\\u03b1\\u03bd\\u03ad\\u03bd\\u03b1\",\n    \"modified_date\": \"2026-01-26 14:13:46\",\n    \"permalink\": \"https:\\/\\/staging.promarketing.gr\\/?cms_block=apostoles-epistrofes\",\n    \"categories\": [],\n    \"tags\": []\n}","a0eb173a-7d45-40b0-afcc-0859d844e8a7","{\"post_id\":149}","1769590774"),
("18","post","Before Add to Cart","<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->		\n								<link rel=\"stylesheet\" id=\"wd-text-block-css\" href=\"https://staging.promarketing.gr/wp-content/themes/woodmart/css/parts/el-text-block.min.css?ver=8.3.8\" type=\"text/css\" media=\"all\" /> 					\n			<p><strong>-Παρήγγειλε έως τις 11:00 με BOX Now και θα παραλάβεις μέχρι αύριο βράδυ κατά 90%.</strong></p><p><strong>-10% Επιπλέον Έκπτωση στα μη  εκπτωτικά προϊόντα για αγορές 2 οποιονδήποτε προϊόντων.</strong></p><p><strong>-5% Επιπλέον Έκπτωση για πληρωμές με Κάρτα.</strong></p><p>Μην το σκέφτεσαι! Αγόρασε το! Έχεις <strong>Δωρεάν Μεταφορικά άνω των 49€ με Box Now και -5% Έκπτωση στο καλάθι σου</strong>!<br>Μήπως φοβάσαι ότι δεν θα σου κάνει; <strong>Θα έχεις άμεση επιστροφή χρημάτων</strong>!</p>\n\nMetadata:\n{\n    \"featured_image\": false,\n    \"excerpt\": \"-\\u03a0\\u03b1\\u03c1\\u03ae\\u03b3\\u03b3\\u03b5\\u03b9\\u03bb\\u03b5 \\u03ad\\u03c9\\u03c2 \\u03c4\\u03b9\\u03c2 11:00 \\u03bc\\u03b5 BOX Now \\u03ba\\u03b1\\u03b9 \\u03b8\\u03b1 \\u03c0\\u03b1\\u03c1\\u03b1\\u03bb\\u03ac\\u03b2\\u03b5\\u03b9\\u03c2 \\u03bc\\u03ad\\u03c7\\u03c1\\u03b9 \\u03b1\\u03cd\\u03c1\\u03b9\\u03bf \\u03b2\\u03c1\\u03ac\\u03b4\\u03c5 \\u03ba\\u03b1\\u03c4\\u03ac 90%. -10% \\u0395\\u03c0\\u03b9\\u03c0\\u03bb\\u03ad\\u03bf\\u03bd \\u0388\\u03ba\\u03c0\\u03c4\\u03c9\\u03c3\\u03b7 \\u03c3\\u03c4\\u03b1 \\u03bc\\u03b7 \\u03b5\\u03ba\\u03c0\\u03c4\\u03c9\\u03c4\\u03b9\\u03ba\\u03ac \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03b1 \\u03b3\\u03b9\\u03b1 \\u03b1\\u03b3\\u03bf\\u03c1\\u03ad\\u03c2 2 \\u03bf\\u03c0\\u03bf\\u03b9\\u03bf\\u03bd\\u03b4\\u03ae\\u03c0\\u03bf\\u03c4\\u03b5 \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03c9\\u03bd. -5% \\u0395\\u03c0\\u03b9\\u03c0\\u03bb\\u03ad\\u03bf\\u03bd \\u0388\\u03ba\\u03c0\\u03c4\\u03c9\\u03c3\\u03b7 \\u03b3\\u03b9\\u03b1 \\u03c0\\u03bb\\u03b7\\u03c1\\u03c9\\u03bc\\u03ad\\u03c2 \\u03bc\\u03b5 \\u039a\\u03ac\\u03c1\\u03c4\\u03b1. \\u039c\\u03b7\\u03bd \\u03c4\\u03bf \\u03c3\\u03ba\\u03ad\\u03c6\\u03c4\\u03b5\\u03c3\\u03b1\\u03b9! \\u0391\\u03b3\\u03cc\\u03c1\\u03b1\\u03c3\\u03b5 \\u03c4\\u03bf! \\u0388\\u03c7\\u03b5\\u03b9\\u03c2 \\u0394\\u03c9\\u03c1\\u03b5\\u03ac\\u03bd \\u039c\\u03b5\\u03c4\\u03b1\\u03c6\\u03bf\\u03c1\\u03b9\\u03ba\\u03ac \\u03ac\\u03bd\\u03c9 \\u03c4\\u03c9\\u03bd 49\\u20ac \\u03bc\\u03b5 Box Now \\u03ba\\u03b1\\u03b9 -5% \\u0388\\u03ba\\u03c0\\u03c4\\u03c9\\u03c3\\u03b7 \\u03c3\\u03c4\\u03bf \\u03ba\\u03b1\\u03bb\\u03ac\\u03b8\\u03b9 \\u03c3\\u03bf\\u03c5!\\u039c\\u03ae\\u03c0\\u03c9\\u03c2 \\u03c6\\u03bf\\u03b2\\u03ac\\u03c3\\u03b1\\u03b9 \\u03cc\\u03c4\\u03b9 \\u03b4\\u03b5\\u03bd \\u03b8\\u03b1 \\u03c3\\u03bf\\u03c5 \\u03ba\\u03ac\\u03bd\\u03b5\\u03b9; \\u0398\\u03b1 \\u03ad\\u03c7\\u03b5\\u03b9\\u03c2 \\u03ac\\u03bc\\u03b5\\u03c3\\u03b7 \\u03b5\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ae \\u03c7\\u03c1\\u03b7\\u03bc\\u03ac\\u03c4\\u03c9\\u03bd!\",\n    \"modified_date\": \"2026-01-26 14:12:18\",\n    \"permalink\": \"https:\\/\\/staging.promarketing.gr\\/?cms_block=before-add-to-cart\",\n    \"categories\": [],\n    \"tags\": []\n}","47652b76-4c7b-4245-a586-73230381085c","{\"post_id\":132}","1769590775"),
("19","post","Header","-10%&nbsp;Επιπλέον&nbsp;Έκπτωση&nbsp;για&nbsp;αγορές&nbsp;2&nbsp;τμχ&nbsp;και&nbsp;πάνω\n	-5%&nbsp;Επιπλέον&nbsp;Έκπτωση&nbsp;για&nbsp;πληρωμή&nbsp;με&nbsp;Κάρτα\n	Δωρεαν&nbsp;Μεταφορικα&nbsp;άνω&nbsp;των&nbsp;49€\n	Δικαιωμα&nbsp;Επιστροφης&nbsp;σε&nbsp;όλα&nbsp;τα&nbsp;προϊοντα\n\nMetadata:\n{\n    \"featured_image\": false,\n    \"excerpt\": \"-10%&nbsp;\\u0395\\u03c0\\u03b9\\u03c0\\u03bb\\u03ad\\u03bf\\u03bd&nbsp;\\u0388\\u03ba\\u03c0\\u03c4\\u03c9\\u03c3\\u03b7&nbsp;\\u03b3\\u03b9\\u03b1&nbsp;\\u03b1\\u03b3\\u03bf\\u03c1\\u03ad\\u03c2&nbsp;2&nbsp;\\u03c4\\u03bc\\u03c7&nbsp;\\u03ba\\u03b1\\u03b9&nbsp;\\u03c0\\u03ac\\u03bd\\u03c9 -5%&nbsp;\\u0395\\u03c0\\u03b9\\u03c0\\u03bb\\u03ad\\u03bf\\u03bd&nbsp;\\u0388\\u03ba\\u03c0\\u03c4\\u03c9\\u03c3\\u03b7&nbsp;\\u03b3\\u03b9\\u03b1&nbsp;\\u03c0\\u03bb\\u03b7\\u03c1\\u03c9\\u03bc\\u03ae&nbsp;\\u03bc\\u03b5&nbsp;\\u039a\\u03ac\\u03c1\\u03c4\\u03b1 \\u0394\\u03c9\\u03c1\\u03b5\\u03b1\\u03bd&nbsp;\\u039c\\u03b5\\u03c4\\u03b1\\u03c6\\u03bf\\u03c1\\u03b9\\u03ba\\u03b1&nbsp;\\u03ac\\u03bd\\u03c9&nbsp;\\u03c4\\u03c9\\u03bd&nbsp;49\\u20ac \\u0394\\u03b9\\u03ba\\u03b1\\u03b9\\u03c9\\u03bc\\u03b1&nbsp;\\u0395\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03b7\\u03c2&nbsp;\\u03c3\\u03b5&nbsp;\\u03cc\\u03bb\\u03b1&nbsp;\\u03c4\\u03b1&nbsp;\\u03c0\\u03c1\\u03bf\\u03ca\\u03bf\\u03bd\\u03c4\\u03b1\",\n    \"modified_date\": \"2026-01-28 11:10:54\",\n    \"permalink\": \"https:\\/\\/staging.promarketing.gr\\/?cms_block=header\",\n    \"categories\": [],\n    \"tags\": []\n}","0f16e60b-5294-481f-98db-35840a8d6676","{\"post_id\":109}","1769590777"),
("20","post","Προεπιλεγμένο Κιτ","\n\nMetadata:\n{\n    \"featured_image\": false,\n    \"excerpt\": \"\",\n    \"modified_date\": \"2026-01-26 14:41:58\",\n    \"permalink\": \"https:\\/\\/staging.promarketing.gr\\/?elementor_library=%cf%80%cf%81%ce%bf%ce%b5%cf%80%ce%b9%ce%bb%ce%b5%ce%b3%ce%bc%ce%ad%ce%bd%ce%bf-%ce%ba%ce%b9%cf%84\",\n    \"categories\": [],\n    \"tags\": []\n}","cd2f4acc-f11e-42a8-a4f8-f340e57df57e","{\"post_id\":13}","1769590779");

INSERT IGNORE INTO `wpby_helpmate_jobs` VALUES 
("1","helpmate_bulk_697889bb1116b_1769507259","1","21","21","14","8","failed","{\"post_ids\":[242,207,198,191,185,178,162,160,157,153,149,132,109,13,8,9,10,11,1,2,3],\"post_types\":[\"cms_block\",\"page\",\"page\",\"page\",\"page\",\"page\",\"jet-form-builder\",\"jet-form-builder\",\"cms_block\",\"cms_block\",\"cms_block\",\"cms_block\",\"cms_block\",\"elementor_library\",\"page\",\"page\",\"page\",\"page\",\"post\",\"page\",\"page\"],\"titles\":[\"Gtranslate\",\"\\u03a6\\u03cc\\u03c1\\u03bc\\u03b1 \\u0391\\u03bb\\u03bb\\u03b1\\u03b3\\u03ae\\u03c2 &#8211; \\u0395\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ae\\u03c2\",\"\\u038c\\u03c1\\u03bf\\u03b9 &amp; \\u03a0\\u03c1\\u03bf\\u03cb\\u03c0\\u03bf\\u03b8\\u03ad\\u03c3\\u03b5\\u03b9\\u03c2\",\"\\u0395\\u03c0\\u03b9\\u03ba\\u03bf\\u03b9\\u03bd\\u03c9\\u03bd\\u03af\\u03b1\",\"\\u0391\\u03c0\\u03bf\\u03c3\\u03c4\\u03bf\\u03bb\\u03ad\\u03c2 &#038; \\u0395\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ad\\u03c2\",\"\\u0391\\u03b3\\u03b1\\u03c0\\u03b7\\u03bc\\u03ad\\u03bd\\u03b1\",\"Return Form\",\"\\u0395\\u03a0\\u0399\\u039a\\u039f\\u0399\\u039d\\u03a9\\u039d\\u0399\\u0391\",\"Footer\",\"Delivery Time\",\"\\u0391\\u03c0\\u03bf\\u03c3\\u03c4\\u03bf\\u03bb\\u03ad\\u03c2 &amp; \\u0395\\u03c0\\u03b9\\u03c3\\u03c4\\u03c1\\u03bf\\u03c6\\u03ad\\u03c2\",\"Before Add to Cart\",\"Header\",\"\\u03a0\\u03c1\\u03bf\\u03b5\\u03c0\\u03b9\\u03bb\\u03b5\\u03b3\\u03bc\\u03ad\\u03bd\\u03bf \\u039a\\u03b9\\u03c4\",\"Shop\",\"\\u039a\\u03b1\\u03bb\\u03ac\\u03b8\\u03b9\",\"\\u0391\\u03b3\\u03bf\\u03c1\\u03ac\",\"\\u039f \\u03bb\\u03bf\\u03b3\\u03b1\\u03c1\\u03b9\\u03b1\\u03c3\\u03bc\\u03cc\\u03c2 \\u03bc\\u03bf\\u03c5\",\"Hello world!\",\"Ben Tailor \\u03a1\\u03bf\\u03cd\\u03c7\\u03b1 &amp; Red Raven \\u0393\\u03c5\\u03b1\\u03bb\\u03b9\\u03ac\",\"\\u03a0\\u03bf\\u03bb\\u03b9\\u03c4\\u03b9\\u03ba\\u03ae \\u0391\\u03c0\\u03bf\\u03c1\\u03c1\\u03ae\\u03c4\\u03bf\\u03c5\"],\"document_type\":\"post\"}","[{\"document_title\":\"Shop\",\"error\":\"Sorry, you have reached your embedding credits limit. Please try again later.\"},{\"document_title\":\"Shop\",\"error\":\"Processing stopped due to embedding credits limit\"},{\"document_title\":\"\\u039a\\u03b1\\u03bb\\u03ac\\u03b8\\u03b9\",\"error\":\"Processing stopped due to embedding credits limit\"},{\"document_title\":\"\\u0391\\u03b3\\u03bf\\u03c1\\u03ac\",\"error\":\"Processing stopped due to embedding credits limit\"},{\"document_title\":\"\\u039f \\u03bb\\u03bf\\u03b3\\u03b1\\u03c1\\u03b9\\u03b1\\u03c3\\u03bc\\u03cc\\u03c2 \\u03bc\\u03bf\\u03c5\",\"error\":\"Processing stopped due to embedding credits limit\"},{\"document_title\":\"Hello world!\",\"error\":\"Processing stopped due to embedding credits limit\"},{\"document_title\":\"Ben Tailor \\u03a1\\u03bf\\u03cd\\u03c7\\u03b1 &amp; Red Raven \\u0393\\u03c5\\u03b1\\u03bb\\u03b9\\u03ac\",\"error\":\"Processing stopped due to embedding credits limit\"},{\"document_title\":\"\\u03a0\\u03bf\\u03bb\\u03b9\\u03c4\\u03b9\\u03ba\\u03ae \\u0391\\u03c0\\u03bf\\u03c1\\u03c1\\u03ae\\u03c4\\u03bf\\u03c5\",\"error\":\"Processing stopped due to embedding credits limit\"}]","2026-01-27 12:47:39","2026-01-28 11:59:40","2026-01-28 11:59:40");

INSERT IGNORE INTO `wpby_helpmate_settings` VALUES 
("1","modules","{\"chatbot\":true,\"sales-notifications\":true,\"promo-banner\":true,\"ticket-system\":true,\"image-search\":false,\"proactive-sales\":false,\"refund-return\":false,\"abandoned-cart\":false,\"order-tracker\":false,\"coupon-delivery\":false}","1769425424"),
("6","order_tracker","{\"order_tracker_email_required\":true,\"order_tracker_phone_required\":false}","1769425424"),
("7","refund_return","{\"policy_url\":\"\",\"selected_email_template\":1,\"email_templates\":[{\"id\":1,\"refund_return_template_name\":\"Default Email Template\",\"refund_return_email_subject\":\"Your Refund\\/Return Request\",\"refund_return_email_body\":\"\\n                        <div style=\\\"font-family: Arial, sans-serif; margin: 0; padding: 0; background-color: #ffffff;\\\">\\n                            <div style=\\\"max-width: 600px; margin: 0 auto; padding: 20px;\\\">\\n                                <div style=\\\"color: #666666; font-size: 16px; margin-bottom: 10px; text-align: center;\\\">Hello {customer_name},<\\/div>\\n                                <div style=\\\"color: #455CFE; font-size: 28px; font-weight: bold; margin-bottom: 20px; text-align: center;\\\">Refund\\/Return Request Update<\\/div>\\n                                <div style=\\\"color: #666666; font-size: 14px; line-height: 1.5; margin-bottom: 25px; text-align: center;\\\">\\n                                    We have an update regarding your refund\\/return request.<br>\\n                                    Please review the details below:\\n                                <\\/div>\\n                                <div style=\\\"background: #ffffff; border-radius: 8px; padding: 20px; margin: 20px auto; box-shadow: 0 2px 6px rgba(0,0,0,0.08); max-width: 400px; border: 2px solid #455CFE;\\\">\\n                                    <div style=\\\"background: #455CFE; color: white; padding: 8px 16px; border-radius: 20px; display: inline-block; font-weight: bold; font-size: 14px; margin-bottom: 15px;\\\">{status}<\\/div>\\n                                    <div style=\\\"background: #f8f9fa; border-radius: 8px; padding: 15px; margin: 15px 0; border-left: 4px solid #455CFE;\\\">\\n                                        <div style=\\\"color: #455CFE; font-weight: bold; font-size: 16px; margin-bottom: 5px;\\\">Order ID: {order_id}<\\/div>\\n                                        <div style=\\\"color: #666666; font-size: 14px; line-height: 1.5;\\\">\\n                                            Your request has been processed and updated.<br>\\n                                            If you have any questions, please contact our support team.\\n                                        <\\/div>\\n                                    <\\/div>\\n                                <\\/div>\\n                                <div style=\\\"text-align: center;\\\">\\n                                    <a href=\\\"{order_url}\\\" style=\\\"background: #455CFE; color: white; padding: 15px 30px; text-decoration: none; border-radius: 8px; display: inline-block; font-weight: bold; margin-top: 25px;\\\">View Order<\\/a>\\n                                <\\/div>\\n                                <div style=\\\"margin-top: 30px; color: #999999; font-size: 12px; text-align: center;\\\">\\n                                    Best regards,<br>\\n                                    {shop_name}\\n                                <\\/div>\\n                            <\\/div>\\n                        <\\/div>\"}],\"reasons\":[\"Defective Product\",\"Wrong Product Received\",\"Wrong Size Received\",\"Wrong Color Received\",\"Wrong Quantity Received\",\"Other\"]}","1769425424"),
("8","abandoned_cart","{\"abandoned_cart_after\":\"60\",\"delete_abandoned_cart_after\":\"10080\",\"cart_recovery_button_text\":\"Recover Cart\",\"selected_email_template\":1,\"coupon_code\":\"\",\"email_templates\":[{\"id\":1,\"abandoned_cart_template_name\":\"Default Email Template\",\"abandoned_cart_email_subject\":\"You left something behind?\",\"abandoned_cart_email_body\":\"\\n                        <div style=\\\"font-family: Arial, sans-serif; margin: 0; padding: 0; background-color: #ffffff;\\\">\\n                            <div style=\\\"max-width: 600px; margin: 0 auto; padding: 20px;\\\">\\n                                <div style=\\\"color: #666666; font-size: 16px; margin-bottom: 10px; text-align: center;\\\">Hello {customer_name},<\\/div>\\n                                <div style=\\\"color: #455CFE; font-size: 28px; font-weight: bold; margin-bottom: 20px; text-align: center;\\\">You left something behind?<\\/div>\\n                                <div style=\\\"color: #666666; font-size: 14px; line-height: 1.5; margin-bottom: 25px; text-align: center;\\\">\\n                                    Looks like you didn\'t get a chance to complete your order.<br>\\n                                    Don\'t worry\\u2014we\'ve saved your cart for you.<br>\\n                                    Here\'s what\'s waiting for you:\\n                                <\\/div>\\n                                {cart_items}\\n                                <div style=\\\"text-align: center;\\\">\\n                                    <a href=\\\"{cart_url}\\\" style=\\\"background: #455CFE; color: white; padding: 15px 30px; text-decoration: none; border-radius: 8px; display: inline-block; font-weight: bold; margin-top: 25px;\\\">View cart<\\/a>\\n                                <\\/div>\\n                                <div style=\\\"text-align: center; margin-top: 20px; padding: 15px; background-color: #f8f9fa; border-radius: 8px; border: 2px dashed #455CFE;\\\">\\n                                    <div style=\\\"color: #455CFE; font-weight: bold; font-size: 16px; margin-bottom: 5px;\\\">Special Offer!<\\/div>\\n                                    <div style=\\\"color: #666666; font-size: 14px;\\\">Use coupon code: <strong style=\\\"color: #455CFE;\\\">{coupon_code}<\\/strong><\\/div>\\n                                <\\/div>\\n                                <div style=\\\"margin-top: 30px; color: #999999; font-size: 12px; text-align: center;\\\">\\n                                    Best regards,<br>\\n                                    {shop_name}\\n                                <\\/div>\\n                            <\\/div>\\n                        <\\/div>\"}]}","1769425424"),
("10","proactive_sales","{\"proactive_sales_hide_frequency\":\"0.08\",\"proactive_sales_show_frequency\":\"0.16\",\"proactive_sales_template\":\"1\",\"products\":[]}","1769425424"),
("11","coupons","{\"coupons\":[],\"exit_intent_coupon\":\"\",\"ask_ai_coupon\":true,\"specific_product_query_coupon\":true,\"collect_lead\":false}","1769425424"),
("12","promo_banners","[]","1769425424"),
("13","encryption_key","\"be8d02667ab4720119e826cae862debc23f53f5912117b9fd2e403ae270d5843\"","1769425424"),
("16","sales_notifications","{\"sales_notification\":true,\"review\":false,\"download\":false,\"sales_notification_show_frequency\":\"0.5\",\"sales_notification_hide_frequency\":\"0.08\",\"sales_notification_template\":\"1\"}","1769506066"),
("17","api","{\"api_key\":\"vMMj5pwyZTMOTxvRt+oLxWcvcHJFOHJvMDVYN0dLVXRtaTRNdmhDNk1UNms2K214cU5mLzk2R05yczg9\",\"validation_key\":\"3nn+I+vJG84WRi2jb+rOvkxiK3l3dGFsMGxuelY1dGQvbjErUkFvU0JyUkp6cXgxOG1EbmM5MUc1cm5MUTR0M2pEU1BTMlVNa0VxSmNTK0xtcjBrMnpYUjRBNVF1dXlQM1B5ZHNHV3VKSU0yRVZlSklKUStCQXlSbkRxSGNPTzJHZ1FWc0IxQ3llZnlKMys5MElsRkNrYlNsRkkzdHpkcTU0L3I3aml1WkQxcEQvN0pJZGJpcDNmTXdVYlVLd3YvNUZBZUZvYzI5WEpidlVWM1VoWGFsR2dKVlZGbFhlQXIrbFozVlZjSm9KNm9oM1V3cWljUlVSWTRNTlo4M25tUXBRQUlVNmNBd3UxNEUyMSthbFBUbEhuODFPSDRwSWhnTlhGbTdteXF1MUdnTCtlUjhGUEdocVZzWHdFUnNVYitpRnh0OFFuSmQ2THp0dHhDOUtuSml5cGgybE1Va1IyTVpzTk5UQT09\",\"credits\":\"tkybsUQbUskqqKZKpBKtmlFkSjdKUWw4T3lNd2l0Wk4vZzJKcjE4aVJ0bld3ME1lZ3IvWGFnL1hYdjJZT1JZeGM3T3krWHlvUFR5WStQeEM0bGFYRjNoMkFiQmpuby9KdkRnYVdqdFh4b2ZNOUxmeU5kc2VzbmM2Z1dnS09reXUzdXF4a1pCY0ZvWU9oVzNRMUNmckY5UVAxWE1EZU9PTnFudStXbktNckM2eWNsNnlxbC80SnBKTVRHdFhmTE9xU1VIZm5WN3A3ZXc1am96VWc4T1RScmcyK0lRVGgvNk4vVEpoMWVhbmRZZDhEYm1sdEw4TVg0Mm1sdms9\",\"last_sync\":\"23Bvo\\/bk++uxd3ZpgsP8qEhGdVhPWnJmKytEWTFpR0duR2tHcFprTFNmY21PMThDM3NjVElZTjVZR2M9\",\"customer_id\":\"WlbOV\\/AJUySuhvwTXzob2FVwTFJSNTB2aTN6aWRWeUUvN2tDTnc9PQ==\",\"product_slug\":\"EdQ2kjPfWxOugmApEd1wnis2ODduaTlVQTZrU3pZMDRmMWZsbVE9PQ==\"}","1769507055"),
("18","customization","{\"bot_name\":\"Helpmate\",\"bot_icon\":\"\",\"primary_color\":\"#455CFE\",\"primary_gradient\":\"linear-gradient(to top left,#748EFF,#455CFE)\",\"secondary_color\":\"#748EFF\",\"secondary_gradient\":\"\",\"font_size\":\"1rem\",\"sound_effect\":\"none\",\"icon\":\"\",\"icon_size\":\"60px\",\"position\":\"right\",\"icon_shape\":\"circle\"}","1769507104"),
("20","ai","{\"temperature\":0,\"tone\":\"friendly\",\"language\":\"el\",\"similarity_threshold\":0.299999999999999988897769753748434595763683319091796875}","1769507136"),
("21","behavior","{\"human_handover\":[{\"enabled\":false,\"title\":\"Call Us\",\"value\":\"\"},{\"enabled\":false,\"title\":\"Email Us\",\"value\":\"\"},{\"enabled\":false,\"title\":\"Chat on WhatsApp\",\"value\":\"\"},{\"enabled\":false,\"title\":\"Chat on Messenger\",\"value\":\"\"}],\"welcome_message\":[\"\\u0389\\u03be\\u03b5\\u03c1\\u03b5\\u03c2 \\u03cc\\u03c4\\u03b9 \\u03b5\\u03af\\u03bc\\u03b1\\u03c3\\u03c4\\u03b5 Pro Seller \\u03c3\\u03c4\\u03bf Skroutz;\",\"\\u039e\\u03ad\\u03c1\\u03b5\\u03b9\\u03c2 \\u03cc\\u03c4\\u03b9 \\u03ad\\u03c7\\u03b5\\u03b9\\u03c2 -10% \\u03c3\\u03b5 \\u03b1\\u03b3\\u03bf\\u03c1\\u03ac 2 \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03c9\\u03bd \\u03ba\\u03b1\\u03b9 \\u03c0\\u03ac\\u03bd\\u03c9 \\u03c3\\u03c4\\u03b1 \\u03c7\\u03c9\\u03c1\\u03af\\u03c2 \\u03ad\\u03ba\\u03c0\\u03c4\\u03c9\\u03c3\\u03b7 \\u03c0\\u03c1\\u03bf\\u03ca\\u03cc\\u03bd\\u03c4\\u03b1;\",\"\\u03a0\\u03ac\\u03c1\\u03b5 \\u03ba\\u03b1\\u03b9 \\u03ad\\u03bd\\u03b1 \\u03b5\\u03c0\\u03b9\\u03c0\\u03bb\\u03ad\\u03bf\\u03bd 5% \\u03c3\\u03b5 \\u03cc\\u03bb\\u03b7 \\u03c4\\u03b7\\u03bd \\u03c0\\u03b1\\u03c1\\u03b1\\u03b3\\u03b3\\u03b5\\u03bb\\u03af\\u03b1 \\u03bc\\u03b5 \\u03c0\\u03bb\\u03b7\\u03c1\\u03c9\\u03bc\\u03ae \\u03bc\\u03b5 \\u03ba\\u03ac\\u03c1\\u03c4\\u03b1 \\u03ba\\u03b1\\u03b9 Box Now.\"],\"welcome_message_sound\":false,\"show_ticket_creation_option\":false,\"collect_lead\":false,\"lead_form_fields\":[\"name\",\"email\",\"message\"],\"hide_on_mobile\":false}","1769507328"),
("23","was_deactivated","true","1769591582");

INSERT IGNORE INTO `wpby_options` VALUES 
("1","cron","a:28:{i:1769591666;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1769592497;a:1:{s:32:\"duplicator_backup_storages_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:41:\"duplicator_backup_storages_check_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1769592907;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1769593075;a:1:{s:41:\"woodmart_wishlist_on_sales_products_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1769593083;a:1:{s:42:\"woodmart_wishlist_send_back_in_stock_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1769593250;a:1:{s:29:\"woodmart_review_reminder_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1769595087;a:2:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1769595088;a:2:{s:40:\"woodmart_wishlist_send_promotional_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1769595093;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1769598238;a:1:{s:19:\"license_check_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769601520;a:1:{s:21:\"woo_feed_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769632507;a:2:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1769632520;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1769634695;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1769652313;a:1:{s:34:\"disable_admin_notices_log_activity\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1769675707;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769675720;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769675721;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769677887;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769677903;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769677997;a:1:{s:31:\"duplicator_activity_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"duplicator_daily_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769733401;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1770021308;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770030000;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770107707;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770110704;a:1:{s:39:\"rocket_database_optimization_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770257098;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","on"),
("2","siteurl","https://staging.promarketing.gr","on"),
("3","home","https://staging.promarketing.gr","on"),
("4","blogname","LikeMe.gr","on"),
("5","blogdescription","Ben Tailor Ρούχα &amp; Red Raven Γυαλιά","on"),
("6","users_can_register","0","on"),
("7","admin_email","and.adamop@gmail.com","on"),
("8","start_of_week","1","on"),
("9","use_balanceTags","0","on"),
("10","use_smilies","1","on"),
("11","require_name_email","","on"),
("12","comments_notify","","on"),
("13","posts_per_rss","10","on"),
("14","rss_use_excerpt","0","on"),
("15","mailserver_url","mail.example.com","on"),
("16","mailserver_login","login@example.com","on"),
("17","mailserver_pass","","on"),
("18","mailserver_port","110","on"),
("19","default_category","1","on"),
("20","default_comment_status","","on"),
("21","default_ping_status","","on"),
("22","default_pingback_flag","","on"),
("23","posts_per_page","10","on"),
("24","date_format","m/d/Y","on"),
("25","time_format","H:i","on"),
("26","links_updated_date_format","F j, Y g:i a","on"),
("27","comment_moderation","","on"),
("28","moderation_notify","","on"),
("29","permalink_structure","/%postname%/","on"),
("30","rewrite_rules","a:388:{s:12:\"forreview/?$\";s:31:\"index.php?product_cat=forreview\";s:18:\"forreview/embed/?$\";s:42:\"index.php?product_cat=forreview&embed=true\";s:42:\"forreview/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?product_cat=forreview&feed=$matches[1]\";s:37:\"forreview/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?product_cat=forreview&feed=$matches[1]\";s:30:\"forreview/page/?([0-9]{1,})/?$\";s:49:\"index.php?product_cat=forreview&paged=$matches[1]\";s:20:\"forreview/([^/]+)/?$\";s:29:\"index.php?product=$matches[1]\";s:45:\"forreview/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:40:\"woocommerce-email-template-customizer/?$\";s:34:\"index.php?post_type=viwec_template\";s:70:\"woocommerce-email-template-customizer/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?post_type=viwec_template&feed=$matches[1]\";s:65:\"woocommerce-email-template-customizer/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?post_type=viwec_template&feed=$matches[1]\";s:57:\"woocommerce-email-template-customizer/page/([0-9]{1,})/?$\";s:52:\"index.php?post_type=viwec_template&paged=$matches[1]\";s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:15:\"^checkout-link$\";s:28:\"index.php?checkout-link=true\";s:31:\"^wishlist/([^/]*)/page/([^/]*)?\";s:63:\"index.php?page_id=178&wishlist_id=$matches[1]&paged=$matches[2]\";s:23:\"^wishlist/page/([^/]*)?\";s:39:\"index.php?page_id=178&paged=$matches[1]\";s:19:\"^wishlist/([^/]*)/?\";s:45:\"index.php?page_id=178&wishlist_id=$matches[1]\";s:37:\"jet-popup/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"jet-popup/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"jet-popup/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"jet-popup/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"jet-popup/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"jet-popup/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"jet-popup/([^/]+)/embed/?$\";s:42:\"index.php?jet-popup=$matches[1]&embed=true\";s:30:\"jet-popup/([^/]+)/trackback/?$\";s:36:\"index.php?jet-popup=$matches[1]&tb=1\";s:38:\"jet-popup/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?jet-popup=$matches[1]&paged=$matches[2]\";s:45:\"jet-popup/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?jet-popup=$matches[1]&cpage=$matches[2]\";s:46:\"jet-popup/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?jet-popup=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"jet-popup/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?jet-popup=$matches[1]&wc-api=$matches[3]\";s:52:\"jet-popup/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"jet-popup/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"jet-popup/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"jet-popup/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"jet-popup/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?jet-popup=$matches[1]&page=$matches[2]\";s:26:\"jet-popup/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"jet-popup/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"jet-popup/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"jet-popup/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"jet-popup/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"jet-popup/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:55:\"e-floating-buttons/([^/]+)/wc/file/transient(/(.*))?/?$\";s:70:\"index.php?e-floating-buttons=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"e-floating-buttons/([^/]+)/wc-api(/(.*))?/?$\";s:59:\"index.php?e-floating-buttons=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"e-floating-buttons/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:65:\"woocommerce-email-template-customizer/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:75:\"woocommerce-email-template-customizer/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:95:\"woocommerce-email-template-customizer/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:90:\"woocommerce-email-template-customizer/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:90:\"woocommerce-email-template-customizer/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:71:\"woocommerce-email-template-customizer/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"woocommerce-email-template-customizer/([^/]+)/embed/?$\";s:47:\"index.php?viwec_template=$matches[1]&embed=true\";s:58:\"woocommerce-email-template-customizer/([^/]+)/trackback/?$\";s:41:\"index.php?viwec_template=$matches[1]&tb=1\";s:78:\"woocommerce-email-template-customizer/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?viwec_template=$matches[1]&feed=$matches[2]\";s:73:\"woocommerce-email-template-customizer/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?viwec_template=$matches[1]&feed=$matches[2]\";s:66:\"woocommerce-email-template-customizer/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?viwec_template=$matches[1]&paged=$matches[2]\";s:73:\"woocommerce-email-template-customizer/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?viwec_template=$matches[1]&cpage=$matches[2]\";s:74:\"woocommerce-email-template-customizer/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?viwec_template=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"woocommerce-email-template-customizer/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?viwec_template=$matches[1]&wc-api=$matches[3]\";s:80:\"woocommerce-email-template-customizer/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:91:\"woocommerce-email-template-customizer/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woocommerce-email-template-customizer/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:80:\"woocommerce-email-template-customizer/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:62:\"woocommerce-email-template-customizer/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?viwec_template=$matches[1]&page=$matches[2]\";s:54:\"woocommerce-email-template-customizer/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:64:\"woocommerce-email-template-customizer/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:84:\"woocommerce-email-template-customizer/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:79:\"woocommerce-email-template-customizer/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:79:\"woocommerce-email-template-customizer/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:60:\"woocommerce-email-template-customizer/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"woodmart_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_layout/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_layout=$matches[1]&embed=true\";s:36:\"woodmart_layout/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_layout=$matches[1]&tb=1\";s:44:\"woodmart_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_layout/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_layout=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_layout/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_layout=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_layout/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_layout/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_layout=$matches[1]&page=$matches[2]\";s:32:\"woodmart_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"woodmart_woo_fbt/([^/]+)/embed/?$\";s:49:\"index.php?woodmart_woo_fbt=$matches[1]&embed=true\";s:37:\"woodmart_woo_fbt/([^/]+)/trackback/?$\";s:43:\"index.php?woodmart_woo_fbt=$matches[1]&tb=1\";s:45:\"woodmart_woo_fbt/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&paged=$matches[2]\";s:52:\"woodmart_woo_fbt/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&cpage=$matches[2]\";s:53:\"woodmart_woo_fbt/([^/]+)/wc/file/transient(/(.*))?/?$\";s:68:\"index.php?woodmart_woo_fbt=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"woodmart_woo_fbt/([^/]+)/wc-api(/(.*))?/?$\";s:57:\"index.php?woodmart_woo_fbt=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:70:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:48:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:41:\"woodmart_woo_fbt/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?woodmart_woo_fbt=$matches[1]&page=$matches[2]\";s:33:\"woodmart_woo_fbt/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"woodmart_woo_fbt/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"woodmart_woo_fbt/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"woodmart_woo_fbt/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"wd_woo_discounts/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"wd_woo_discounts/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"wd_woo_discounts/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"wd_woo_discounts/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"wd_woo_discounts/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"wd_woo_discounts/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"wd_woo_discounts/([^/]+)/embed/?$\";s:49:\"index.php?wd_woo_discounts=$matches[1]&embed=true\";s:37:\"wd_woo_discounts/([^/]+)/trackback/?$\";s:43:\"index.php?wd_woo_discounts=$matches[1]&tb=1\";s:45:\"wd_woo_discounts/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?wd_woo_discounts=$matches[1]&paged=$matches[2]\";s:52:\"wd_woo_discounts/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?wd_woo_discounts=$matches[1]&cpage=$matches[2]\";s:53:\"wd_woo_discounts/([^/]+)/wc/file/transient(/(.*))?/?$\";s:68:\"index.php?wd_woo_discounts=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"wd_woo_discounts/([^/]+)/wc-api(/(.*))?/?$\";s:57:\"index.php?wd_woo_discounts=$matches[1]&wc-api=$matches[3]\";s:59:\"wd_woo_discounts/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:70:\"wd_woo_discounts/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:48:\"wd_woo_discounts/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:59:\"wd_woo_discounts/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:41:\"wd_woo_discounts/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?wd_woo_discounts=$matches[1]&page=$matches[2]\";s:33:\"wd_woo_discounts/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"wd_woo_discounts/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"wd_woo_discounts/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"wd_woo_discounts/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"wd_woo_discounts/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"wd_woo_discounts/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"wd_popup_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?wd_popup_cat=$matches[1]&feed=$matches[2]\";s:48:\"wd_popup_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?wd_popup_cat=$matches[1]&feed=$matches[2]\";s:29:\"wd_popup_cat/([^/]+)/embed/?$\";s:45:\"index.php?wd_popup_cat=$matches[1]&embed=true\";s:41:\"wd_popup_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?wd_popup_cat=$matches[1]&paged=$matches[2]\";s:23:\"wd_popup_cat/([^/]+)/?$\";s:34:\"index.php?wd_popup_cat=$matches[1]\";s:62:\"wd_floating_block_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?wd_floating_block_cat=$matches[1]&feed=$matches[2]\";s:57:\"wd_floating_block_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?wd_floating_block_cat=$matches[1]&feed=$matches[2]\";s:38:\"wd_floating_block_cat/([^/]+)/embed/?$\";s:54:\"index.php?wd_floating_block_cat=$matches[1]&embed=true\";s:50:\"wd_floating_block_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:61:\"index.php?wd_floating_block_cat=$matches[1]&paged=$matches[2]\";s:32:\"wd_floating_block_cat/([^/]+)/?$\";s:43:\"index.php?wd_floating_block_cat=$matches[1]\";s:54:\"cms_block_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:49:\"cms_block_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:30:\"cms_block_cat/([^/]+)/embed/?$\";s:46:\"index.php?cms_block_cat=$matches[1]&embed=true\";s:42:\"cms_block_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?cms_block_cat=$matches[1]&paged=$matches[2]\";s:24:\"cms_block_cat/([^/]+)/?$\";s:35:\"index.php?cms_block_cat=$matches[1]\";s:49:\"μάρκα/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:44:\"μάρκα/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:25:\"μάρκα/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:37:\"μάρκα/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:19:\"μάρκα/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:46:\"brand/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pa_brand=$matches[1]&feed=$matches[2]\";s:41:\"brand/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pa_brand=$matches[1]&feed=$matches[2]\";s:22:\"brand/([^/]+)/embed/?$\";s:41:\"index.php?pa_brand=$matches[1]&embed=true\";s:34:\"brand/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pa_brand=$matches[1]&paged=$matches[2]\";s:16:\"brand/([^/]+)/?$\";s:30:\"index.php?pa_brand=$matches[1]\";s:36:\"shop/.+?/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"shop/.+?/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"shop/.+?/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"shop/.+?/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"shop/.+?/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"shop/.+?/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"shop/(.+?)/([^/]+)/embed/?$\";s:64:\"index.php?product_cat=$matches[1]&product=$matches[2]&embed=true\";s:31:\"shop/(.+?)/([^/]+)/trackback/?$\";s:58:\"index.php?product_cat=$matches[1]&product=$matches[2]&tb=1\";s:51:\"shop/(.+?)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:70:\"index.php?product_cat=$matches[1]&product=$matches[2]&feed=$matches[3]\";s:46:\"shop/(.+?)/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:70:\"index.php?product_cat=$matches[1]&product=$matches[2]&feed=$matches[3]\";s:39:\"shop/(.+?)/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?product_cat=$matches[1]&product=$matches[2]&paged=$matches[3]\";s:46:\"shop/(.+?)/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?product_cat=$matches[1]&product=$matches[2]&cpage=$matches[3]\";s:47:\"shop/(.+?)/([^/]+)/wc/file/transient(/(.*))?/?$\";s:83:\"index.php?product_cat=$matches[1]&product=$matches[2]&wc/file/transient=$matches[4]\";s:36:\"shop/(.+?)/([^/]+)/wc-api(/(.*))?/?$\";s:72:\"index.php?product_cat=$matches[1]&product=$matches[2]&wc-api=$matches[4]\";s:51:\"shop/.+?/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:62:\"shop/.+?/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"shop/.+?/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"shop/.+?/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"shop/(.+?)/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?product_cat=$matches[1]&product=$matches[2]&page=$matches[3]\";s:25:\"shop/.+?/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"shop/.+?/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"shop/.+?/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"shop/.+?/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"shop/.+?/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"shop/.+?/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"pys_event/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"pys_event/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"pys_event/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"pys_event/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"pys_event/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"pys_event/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"pys_event/([^/]+)/embed/?$\";s:42:\"index.php?pys_event=$matches[1]&embed=true\";s:30:\"pys_event/([^/]+)/trackback/?$\";s:36:\"index.php?pys_event=$matches[1]&tb=1\";s:38:\"pys_event/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?pys_event=$matches[1]&paged=$matches[2]\";s:45:\"pys_event/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?pys_event=$matches[1]&cpage=$matches[2]\";s:46:\"pys_event/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?pys_event=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"pys_event/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?pys_event=$matches[1]&wc-api=$matches[3]\";s:52:\"pys_event/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"pys_event/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"pys_event/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"pys_event/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"pys_event/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?pys_event=$matches[1]&page=$matches[2]\";s:26:\"pys_event/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"pys_event/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"pys_event/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"pys_event/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"pys_event/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"pys_event/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:23:\"index.php?sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=2&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","on"),
("31","hack_file","0","on"),
("32","blog_charset","UTF-8","on"),
("33","moderation_keys","","off"),
("34","active_plugins","a:3:{i:0;s:33:\"duplicator-pro/duplicator-pro.php\";i:1;s:23:\"elementor/elementor.php\";i:2;s:27:\"woocommerce/woocommerce.php\";}","on"),
("35","category_base","","on"),
("36","ping_sites","https://rpc.pingomatic.com/","on"),
("37","comment_max_links","2","on"),
("38","gmt_offset","3","on"),
("39","default_email_category","1","on"),
("40","recently_edited","a:3:{i:0;s:81:\"/home/stagingpromarket/public_html/wp-content/themes/woodmart-child/functions.php\";i:2;s:77:\"/home/stagingpromarket/public_html/wp-content/themes/woodmart-child/style.css\";i:3;s:0:\"\";}","off"),
("41","template","woodmart","on"),
("42","stylesheet","woodmart-child","on"),
("43","comment_registration","","on"),
("44","html_type","text/html","on"),
("45","use_trackback","0","on"),
("46","default_role","subscriber","on"),
("47","db_version","60717","on"),
("48","uploads_use_yearmonth_folders","1","on"),
("49","upload_path","","on"),
("50","blog_public","1","on"),
("51","default_link_category","2","on"),
("52","show_on_front","page","on"),
("53","tag_base","","on"),
("54","show_avatars","","on"),
("55","avatar_rating","G","on"),
("56","upload_url_path","","on"),
("57","thumbnail_size_w","150","on"),
("58","thumbnail_size_h","0","on"),
("59","thumbnail_crop","1","on"),
("60","medium_size_w","400","on"),
("61","medium_size_h","0","on"),
("62","avatar_default","mystery","on"),
("63","large_size_w","1067","on"),
("64","large_size_h","0","on"),
("65","image_default_link_type","","on"),
("66","image_default_size","","on"),
("67","image_default_align","","on"),
("68","close_comments_for_old_posts","","on"),
("69","close_comments_days_old","14","on"),
("70","thread_comments","","on"),
("71","thread_comments_depth","5","on"),
("72","page_comments","","on"),
("73","comments_per_page","50","on"),
("74","default_comments_page","newest","on"),
("75","comment_order","asc","on"),
("76","sticky_posts","a:0:{}","on"),
("77","widget_categories","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("78","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("79","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("80","uninstall_plugins","a:5:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:45:\"user-role-editor-pro/user-role-editor-pro.php\";a:2:{i:0;s:20:\"User_Role_Editor_Pro\";i:1;s:9:\"uninstall\";}s:19:\"bbpress/bbpress.php\";s:15:\"bbp_remove_caps\";s:55:\"yellow-pencil-visual-theme-customizer/yellow-pencil.php\";s:23:\"uninstall_yellow_pencil\";s:35:\"wp-slm-delivery/wp-slm-delivery.php\";s:15:\"slmdb_uninstall\";}","off"),
("81","timezone_string","","on"),
("82","page_for_posts","0","on"),
("83","page_on_front","2","on"),
("84","default_post_format","0","on"),
("85","link_manager_enabled","0","on"),
("86","finished_splitting_shared_terms","1","on"),
("87","site_icon","261","on"),
("88","medium_large_size_w","768","on"),
("89","medium_large_size_h","0","on"),
("90","wp_page_for_privacy_policy","3","on"),
("91","show_comments_cookies_opt_in","","on"),
("92","admin_email_lifespan","1784968507","on"),
("93","disallowed_keys","","off"),
("94","comment_previously_approved","","on"),
("95","auto_plugin_theme_update_emails","a:0:{}","off"),
("96","auto_update_core_dev","enabled","on"),
("97","auto_update_core_minor","enabled","on"),
("98","auto_update_core_major","enabled","on"),
("99","wp_force_deactivated_plugins","a:0:{}","on"),
("100","wp_attachment_pages_enabled","0","on"),
("101","wp_notes_notify","","on"),
("102","initial_db_version","60717","on"),
("103","wpby_user_roles","a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:177:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:16:\"create_customers\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:10:\"manage_pys\";b:1;s:23:\"rank_math_edit_htaccess\";b:1;s:16:\"rank_math_titles\";b:1;s:17:\"rank_math_general\";b:1;s:17:\"rank_math_sitemap\";b:1;s:21:\"rank_math_404_monitor\";b:1;s:22:\"rank_math_link_builder\";b:1;s:22:\"rank_math_redirections\";b:1;s:22:\"rank_math_role_manager\";b:1;s:19:\"rank_math_analytics\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:25:\"rank_math_onpage_advanced\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:20:\"rank_math_content_ai\";b:1;s:19:\"rank_math_admin_bar\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:16:\"ure_export_roles\";b:1;s:16:\"ure_import_roles\";b:1;s:21:\"ure_admin_menu_access\";b:1;s:18:\"ure_widgets_access\";b:1;s:23:\"ure_widgets_show_access\";b:1;s:21:\"ure_meta_boxes_access\";b:1;s:22:\"ure_other_roles_access\";b:1;s:21:\"ure_edit_posts_access\";b:1;s:28:\"ure_edit_gravityforms_access\";b:1;s:29:\"ure_plugins_activation_access\";b:1;s:21:\"ure_view_posts_access\";b:1;s:25:\"ure_front_end_menu_access\";b:1;s:20:\"ure_nav_menus_access\";b:1;s:15:\"manage_rp_wcdpd\";b:1;s:10:\"loco_admin\";b:1;s:17:\"edit_jet_fb_forms\";b:1;s:24:\"edit_others_jet_fb_forms\";b:1;s:20:\"publish_jet_fb_forms\";b:1;s:25:\"read_private_jet_fb_forms\";b:1;s:19:\"delete_jet_fb_forms\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:14:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:90:{s:20:\"assign_product_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:12:\"create_posts\";b:1;s:12:\"create_users\";b:1;s:19:\"delete_jet_fb_forms\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_others_products\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:12:\"delete_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:23:\"delete_private_products\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:14:\"delete_product\";b:1;s:20:\"delete_product_terms\";b:1;s:15:\"delete_products\";b:1;s:22:\"delete_published_posts\";b:1;s:25:\"delete_published_products\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:18:\"delete_shop_coupon\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:19:\"delete_shop_coupons\";b:1;s:17:\"delete_shop_order\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:18:\"delete_shop_orders\";b:1;s:12:\"delete_users\";b:1;s:14:\"edit_dashboard\";b:1;s:17:\"edit_jet_fb_forms\";b:1;s:24:\"edit_others_jet_fb_forms\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_others_products\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:10:\"edit_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:21:\"edit_private_products\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:12:\"edit_product\";b:1;s:18:\"edit_product_terms\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_published_posts\";b:1;s:23:\"edit_published_products\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:16:\"edit_shop_coupon\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:17:\"edit_shop_coupons\";b:1;s:15:\"edit_shop_order\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:16:\"edit_shop_orders\";b:1;s:10:\"edit_users\";b:1;s:10:\"list_users\";b:1;s:17:\"manage_categories\";b:1;s:20:\"manage_product_terms\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:18:\"manage_woocommerce\";b:1;s:13:\"promote_users\";b:1;s:20:\"publish_jet_fb_forms\";b:1;s:13:\"publish_posts\";b:1;s:16:\"publish_products\";b:1;s:20:\"publish_shop_coupons\";b:1;s:19:\"publish_shop_orders\";b:1;s:4:\"read\";b:1;s:25:\"read_private_jet_fb_forms\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:21:\"read_private_products\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:24:\"read_private_shop_orders\";b:1;s:12:\"read_product\";b:1;s:16:\"read_shop_coupon\";b:1;s:15:\"read_shop_order\";b:1;s:12:\"remove_users\";b:1;s:21:\"rocket_manage_options\";b:1;s:20:\"rocket_preload_cache\";b:1;s:18:\"rocket_purge_cache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:12:\"upload_files\";b:1;s:24:\"view_woocommerce_reports\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}}","on"),
("104","fresh_site","0","off"),
("105","user_count","2","off"),
("106","widget_block","a:5:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","on"),
("107","sidebars_widgets","a:12:{s:19:\"wp_inactive_widgets\";a:4:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";}s:9:\"sidebar-1\";a:0:{}s:12:\"sidebar-shop\";a:9:{i:0;s:32:\"woocommerce_product_categories-2\";i:1;s:24:\"wd-widget-stock-status-2\";i:2;s:34:\"woodmart-woocommerce-layered-nav-2\";i:3;s:34:\"woodmart-woocommerce-layered-nav-4\";i:4;s:34:\"woodmart-woocommerce-layered-nav-3\";i:5;s:34:\"woodmart-woocommerce-layered-nav-6\";i:6;s:34:\"woodmart-woocommerce-layered-nav-5\";i:7;s:34:\"woodmart-woocommerce-layered-nav-7\";i:8;s:22:\"woocommerce_products-2\";}s:12:\"filters-area\";a:0:{}s:22:\"sidebar-product-single\";a:0:{}s:24:\"sidebar-my-account-pages\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:1:{i:0;s:21:\"woodmart-html-block-2\";}s:8:\"footer-1\";a:0:{}s:11:\"sidebar-282\";a:1:{i:0;s:22:\"woocommerce_products-3\";}s:11:\"sidebar-281\";a:1:{i:0;s:38:\"woocommerce_recently_viewed_products-2\";}s:13:\"array_version\";i:3;}","on"),
("108","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("109","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("110","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("111","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("112","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("113","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("114","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("115","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("116","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("117","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("118","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("119","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("120","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("121","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("122","theme_mods_twentytwentyfive","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1769418651;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","off"),
("123","recovery_keys","a:0:{}","off"),
("132","WPLANG","el","yes"),
("153","can_compress_scripts","0","on"),
("167","recently_activated","a:52:{s:71:\"bestprice-analytics-integration/ext-bestprice-analytics-integration.php\";i:1769591589;s:37:\"box-now-delivery/box-now-delivery.php\";i:1769591589;s:45:\"taxonomy-terms-order/taxonomy-terms-order.php\";i:1769591589;s:47:\"disable-admin-notices/disable-admin-notices.php\";i:1769591589;s:57:\"disable-generate-thumbnails/disablegeneratethumbnails.php\";i:1769591589;s:31:\"elementor-pro/elementor-pro.php\";i:1769591589;s:71:\"email-template-customizer-for-woo/email-template-customizer-for-woo.php\";i:1769591589;s:69:\"woocommerce-tm-extra-product-options/tm-woo-extra-product-options.php\";i:1769591589;s:53:\"flexible-checkout-fields/flexible-checkout-fields.php\";i:1769591589;s:25:\"gtranslate/gtranslate.php\";i:1769591589;s:43:\"helpmate-ai-chatbot/helpmate-ai-chatbot.php\";i:1769591589;s:29:\"jet-elements/jet-elements.php\";i:1769591589;s:25:\"jet-engine/jet-engine.php\";i:1769591589;s:83:\"jet-engine-custom-visibility-conditions/jet-engine-custom-visibility-conditions.php\";i:1769591589;s:35:\"jetformbuilder/jet-form-builder.php\";i:1769591589;s:23:\"jet-popup/jet-popup.php\";i:1769591589;s:23:\"loco-translate/loco.php\";i:1769591589;s:31:\"oxygen-mydata/oxygen-mydata.php\";i:1769591589;s:39:\"pixelyoursite-pro/pixelyoursite-pro.php\";i:1769591589;s:53:\"pixelyoursite-super-pack/pixelyoursite-super-pack.php\";i:1769591589;s:55:\"product-category-tree-pro/product-category-tree-pro.php\";i:1769591589;s:30:\"seo-by-rank-math/rank-math.php\";i:1769591589;s:54:\"skroutz-analytics-woocommerce/wc-skroutz-analytics.php\";i:1769591589;s:35:\"wp-slm-delivery/wp-slm-delivery.php\";i:1769591589;s:45:\"user-role-editor-pro/user-role-editor-pro.php\";i:1769591589;s:33:\"user-switching/user-switching.php\";i:1769591589;s:51:\"viva-com-smart-for-woocommerce/wc-vivacom-smart.php\";i:1769591589;s:41:\"woo-discount-field/woo-discount-field.php\";i:1769591589;s:65:\"woocommerce-advanced-bulk-edit/woocommerce-advanced-bulk-edit.php\";i:1769591589;s:51:\"wc-auto-greeklish-slugs/wc-auto-greeklish-slugs.php\";i:1769591589;s:69:\"wc-dynamic-pricing-and-discounts/wc-dynamic-pricing-and-discounts.php\";i:1769591589;s:47:\"iben-woo-elta-courier/iben-woo-elta-courier.php\";i:1769591589;s:49:\"wc-product-title-fixer/wc-product-title-fixer.php\";i:1769591589;s:85:\"webexpert-woocommerce-skroutz-smart-cart/webexpert-woocommerce-skroutz-smart-cart.php\";i:1769591589;s:55:\"webexpert-woocommerce-sms/webexpert-woocommerce-sms.php\";i:1769591589;s:31:\"woodmart-core/woodmart-core.php\";i:1769591589;s:23:\"wordfence/wordfence.php\";i:1769591589;s:51:\"wpae-woocommerce-add-on/wpae-woocommerce-add-on.php\";i:1769591589;s:39:\"wp-all-export-pro/wp-all-export-pro.php\";i:1769591589;s:51:\"wpai-woocommerce-add-on/wpai-woocommerce-add-on.php\";i:1769591589;s:39:\"wp-all-import-pro/wp-all-import-pro.php\";i:1769591589;s:29:\"wp-mail-smtp/wp_mail_smtp.php\";i:1769591589;s:23:\"wp-rocket/wp-rocket.php\";i:1769591589;s:63:\"wp-rocket-no-cache-auto-purge/wp-rocket-no-cache-auto-purge.php\";i:1769591589;s:35:\"wployalty/wp-loyalty-rules-lite.php\";i:1769591589;s:55:\"yellow-pencil-visual-theme-customizer/yellow-pencil.php\";i:1769591589;s:89:\"webappick-product-feed-for-woocommerce-pro/webappick-product-feed-for-woocommerce-pro.php\";i:1769591077;s:35:\"classic-widgets/classic-widgets.php\";i:1769590906;s:81:\"duracelltomi-google-tag-manager/duracelltomi-google-tag-manager-for-wordpress.php\";i:1769515480;s:37:\"imunify-security/imunify-security.php\";i:1769500591;s:87:\"custom-order-statuses-for-woocommerce-pro/custom-order-statuses-for-woocommerce-pro.php\";i:1769431201;s:55:\"autoconvert-greeklish-permalinks/auto-gr-permalinks.php\";i:1769429070;}","off"),
("173","finished_updating_comment_type","1","auto"),
("182","current_theme","Woodmart Child","auto"),
("183","theme_mods_woodmart","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1769418664;s:4:\"data\";a:6:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:22:\"portfolio-widgets-area\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:0:{}s:8:\"footer-1\";a:0:{}}}}","off"),
("184","theme_switched","","auto"),
("185","woodmart-generated-wpbcss-file","","auto"),
("186","woodmart_is_activated","1","auto"),
("188","xts-options-presets","","auto"),
("189","xts-woodmart-options","a:854:{s:12:\"last_message\";s:4:\"save\";s:14:\"default_header\";s:14:\"default_header\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:7:\"sidebar\";i:1;s:6:\"link_1\";i:2;s:6:\"link_2\";i:3;s:6:\"link_3\";i:4;s:6:\"link_5\";}s:10:\"link_1_url\";s:55:\"https://likeme.gr/andriki-moda/andrika-okonomika-rouxa/\";s:11:\"link_1_text\";s:3:\"Men\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:77:\"https://likeme.gr/wp-content/uploads/2025/12/menu-iaoxqnpyjdkokz13yxzrwh.webp\";s:2:\"id\";s:6:\"314208\";}s:10:\"link_2_url\";s:33:\"https://likeme.gr/ginaikeia-moda/\";s:11:\"link_2_text\";s:5:\"Women\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:77:\"https://likeme.gr/wp-content/uploads/2025/12/menu-iaoxqnpyjdkokz13yxzrwh.webp\";s:2:\"id\";s:6:\"314208\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:27:\"https://likeme.gr/checkout/\";s:11:\"link_5_text\";s:10:\"Αγορά\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:138:\"https://staging.promarketing.gr/wp-content/uploads/2026/01/334-3348736_shopping-cart-svg-png-icon-free-download-shopping-cart-icon-svg.jpg\";s:2:\"id\";s:3:\"264\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"0\";s:24:\"promo_popup_content_type\";s:4:\"text\";s:10:\"popup_text\";s:119:\"Επιπλέον έκπτωση 5% για παραγγελίες άνω των 39€ σε όλα τα προϊόντα!\";s:16:\"popup_html_block\";s:0:\"\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:7:\"#111111\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:13:\"popup_padding\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"promo_popup_hide_mobile\";s:1:\"0\";s:11:\"popup_event\";s:4:\"time\";s:12:\"popup_scroll\";s:4:\"1000\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:226:\"Χρησιμοποιούμε cookies δικά μας και τρίτων για να βελτιώσουμε την εμπειρία σας &amp; να προσφέρουμε το μέγιστο των υπηρεσιών μας.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"0\";s:18:\"header_banner_link\";s:0:\"\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:337:\"<p style=\"text-align: center\"><span style=\"color: #ffffff\"><strong>ΤΗΛΕΦΩΝΙΚΕΣ ΠΑΡΑΓΓΕΛΙΕΣ: 2102156537 10:00 - 18:00 | ΔΩΡΕΑΝ ΜΕΤΑΦΟΡΙΚΑ &amp; ΔΩΡΕΑΝ ΑΛΛΑΓΗ | ΕΠΙΠΛΕΟΝ 5% ΕΚΠΤΩΣΗ ΣΕ ΟΛΑ ΤΑ ΠΡΟΪΟΝΤΑ ΓΙΑ ΑΓΟΡΕΣ ΑΝΩ ΤΩΝ 39€</strong></span></p>\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:13:\"rgb(10,10,10)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"50\";s:27:\"header_banner_mobile_height\";s:3:\"110\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:13:\"search_by_sku\";s:1:\"1\";s:28:\"search_by_product_categories\";s:1:\"0\";s:21:\"search_by_product_tag\";s:1:\"0\";s:28:\"search_by_product_attributes\";s:1:\"0\";s:24:\"search_by_product_brands\";s:1:\"0\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:16:\"popular_requests\";s:0:\"\";s:15:\"search_synonyms\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:17:\"relevanssi_search\";s:1:\"0\";s:10:\"site_width\";s:4:\"wide\";s:17:\"site_custom_width\";s:4:\"1222\";s:11:\"main_layout\";s:12:\"sidebar-left\";s:13:\"sidebar_width\";s:1:\"3\";s:17:\"hide_main_sidebar\";s:1:\"0\";s:24:\"hide_main_sidebar_tablet\";s:1:\"1\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:11:\"insta_token\";s:0:\"\";s:28:\"insta_delete_outdated_images\";s:1:\"0\";s:18:\"google_map_api_key\";s:39:\"AIzaSyDR22XuR0oOwRl-SkhRjjS13ka37YRivAg\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"0\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:5:\"after\";s:14:\"products_hover\";s:5:\"quick\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:6:\"inside\";s:24:\"products_with_background\";s:1:\"0\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"products_shadow\";s:1:\"0\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:3:\"two\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"1\";s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:27:\"show_stock_quantity_on_grid\";s:1:\"0\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"1\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"1\";s:18:\"show_reviews_count\";s:1:\"0\";s:17:\"categories_design\";s:11:\"mask-subcat\";s:19:\"categories_rounding\";s:0:\"\";s:31:\"custom_categories_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_subcategories\";s:1:\"0\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"2\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"1\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"1\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"1\";s:25:\"shop_categories_ancestors\";s:1:\"1\";s:25:\"show_categories_neighbors\";s:1:\"1\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"1\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:24:\"mobile_categories_layout\";s:9:\"accordion\";s:29:\"mobile_categories_menu_layout\";s:8:\"dropdown\";s:37:\"mobile_categories_drilldown_animation\";s:5:\"slide\";s:40:\"mobile_categories_submenu_opening_action\";s:10:\"only_arrow\";s:26:\"mobile_categories_position\";s:4:\"left\";s:30:\"mobile_categories_color_scheme\";s:7:\"default\";s:27:\"mobile_categories_close_btn\";s:1:\"0\";s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"5\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:23:\"products_spacing_tablet\";s:0:\"\";s:23:\"products_spacing_mobile\";s:0:\"\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:5:{i:0;s:1:\"2\";i:1;s:1:\"3\";i:2;s:1:\"4\";i:3;s:1:\"5\";i:4;s:1:\"6\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"72\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:7:\"72, 144\";s:15:\"shop_pagination\";s:7:\"infinit\";s:25:\"load_more_button_page_url\";s:1:\"0\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"180\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_columns\";s:0:\"\";s:27:\"shop_filters_columns_tablet\";s:4:\"auto\";s:27:\"shop_filters_columns_mobile\";s:4:\"auto\";s:20:\"shop_filters_spacing\";s:2:\"30\";s:27:\"shop_filters_spacing_tablet\";s:0:\"\";s:27:\"shop_filters_spacing_mobile\";s:0:\"\";s:12:\"hide_sort_by\";s:1:\"0\";s:17:\"hide_price_filter\";s:1:\"0\";s:20:\"shop_filters_content\";s:5:\"20465\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:17:\"page-title-design\";s:8:\"centered\";s:15:\"page-title-size\";s:5:\"small\";s:16:\"title-background\";a:7:{s:5:\"color\";s:13:\"rgb(64,64,63)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:1:\"1\";s:17:\"footer_html_block\";s:3:\"157\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:7:\"#ffffff\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:4:\"dark\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"0\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"0\";s:17:\"copyrights-layout\";s:8:\"centered\";s:10:\"copyrights\";s:0:\"\";s:11:\"copyrights2\";s:0:\"\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"1\";s:11:\"font-family\";s:6:\"Roboto\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"1\";s:11:\"font-family\";s:6:\"Roboto\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"1\";s:11:\"font-family\";s:6:\"Roboto\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"1\";s:11:\"font-family\";s:6:\"Roboto\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"1\";s:11:\"font-family\";s:6:\"Roboto\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"1\";s:11:\"font-family\";s:6:\"Roboto\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"17\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:2:{i:0;a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"1\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:1:\"0\";s:20:\"custom_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:12:\"dark_version\";s:1:\"0\";s:27:\"accessibility_outline_style\";s:0:\"\";s:27:\"accessibility_outline_width\";s:0:\"\";s:27:\"accessibility_outline_color\";a:0:{}s:13:\"primary-color\";a:1:{s:4:\"idle\";s:15:\"rgb(129,215,66)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:15:\"rgb(129,215,66)\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:4:\"flat\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:7:\"#f7f7f7\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#efefef\";}s:25:\"btns_default_color_scheme\";s:4:\"dark\";s:31:\"btns_default_color_scheme_hover\";s:4:\"dark\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:4:\"flat\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:15:\"rgb(129,215,66)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:15:\"rgb(129,215,66)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:6:\"square\";s:17:\"form_border_width\";s:1:\"2\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:0:\"\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:15:\"rgb(129,215,66)\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:15:\"rgb(129,215,66)\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:15:\"rgb(129,215,66)\";s:5:\"hover\";s:15:\"rgb(129,215,66)\";}s:20:\"link_underline_style\";s:0:\"\";s:26:\"link_hover_underline_style\";s:0:\"\";s:20:\"link_underline_color\";a:0:{}s:26:\"link_underline_hover_color\";a:0:{}s:24:\"carousel_arrows_position\";s:3:\"sep\";s:25:\"carousel_arrows_icon_type\";s:1:\"1\";s:27:\"carousel_arrows_hover_style\";s:1:\"1\";s:24:\"carousel_arrows_sep_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_sep_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:25:\"carousel_arrows_sep_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:31:\"carousel_arrows_sep_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_arrows_sep_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_arrows_sep_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_sep_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_arrows_sep_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_sep_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_style\";s:0:\"\";s:32:\"carousel_arrows_sep_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_sep_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_sep_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:39:\"carousel_arrows_sep_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:35:\"carousel_arrows_sep_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_sep_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:28:\"carousel_arrows_together_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_together_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:34:\"carousel_arrows_together_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:30:\"carousel_arrows_together_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_together_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_together_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_together_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_together_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:37:\"carousel_arrows_together_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_together_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_style\";s:0:\"\";s:37:\"carousel_arrows_together_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:43:\"carousel_arrows_together_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:44:\"carousel_arrows_together_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:44:\"carousel_arrows_together_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:40:\"carousel_arrows_together_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:42:\"carousel_arrows_together_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:19:\"carousel_pagin_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:23:\"carousel_pagin_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_pagin_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:30:\"carousel_pagin_bg_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_pagin_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_style\";s:0:\"\";s:27:\"carousel_pagin_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_pagin_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_pagin_border_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:25:\"carousel_scrollbar_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:24:\"carousel_scrollbar_width\";s:152:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJ0YWJsZXQiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJtb2JpbGUiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9fX0=\";s:27:\"carousel_scrollbar_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_scrollbar_drag_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_scrollbar_drag_bg_hover_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:11:\"blog_design\";s:7:\"masonry\";s:15:\"blog_image_size\";s:0:\"\";s:23:\"blog_image_custom_width\";s:0:\"\";s:24:\"blog_image_custom_height\";s:0:\"\";s:12:\"blog_masonry\";b:0;s:10:\"blog_style\";s:4:\"flat\";s:16:\"blog_with_shadow\";s:1:\"1\";s:12:\"blog_columns\";s:1:\"3\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:19:\"blog_spacing_tablet\";s:0:\"\";s:19:\"blog_spacing_mobile\";s:0:\"\";s:15:\"blog_pagination\";s:10:\"pagination\";s:19:\"blog_archive_layout\";s:13:\"sidebar-right\";s:26:\"blog_archive_sidebar_width\";s:1:\"3\";s:25:\"blog_archive_hide_sidebar\";s:1:\"0\";s:32:\"blog_archive_hide_sidebar_tablet\";s:1:\"1\";s:32:\"blog_archive_hide_sidebar_mobile\";s:1:\"1\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"135\";s:11:\"parts_title\";s:1:\"1\";s:10:\"parts_meta\";s:1:\"1\";s:10:\"parts_text\";s:1:\"1\";s:9:\"parts_btn\";s:1:\"1\";s:20:\"parts_published_date\";s:1:\"1\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:17:\"blog_hide_sidebar\";s:1:\"0\";s:24:\"blog_hide_sidebar_tablet\";s:1:\"1\";s:24:\"blog_hide_sidebar_mobile\";s:1:\"1\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:19:\"blog_published_date\";s:1:\"1\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:29:\"single_post_builder_post_data\";s:0:\"\";s:9:\"portfolio\";s:1:\"0\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:2:\"30\";s:24:\"portfolio_spacing_tablet\";s:0:\"\";s:24:\"portfolio_spacing_mobile\";s:0:\"\";s:18:\"portoflio_per_page\";s:2:\"12\";s:20:\"portfolio_pagination\";s:10:\"pagination\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:24:\"portfolio_archive_layout\";s:13:\"sidebar-right\";s:31:\"portfolio_archive_sidebar_width\";s:1:\"3\";s:30:\"portfolio_archive_hide_sidebar\";s:1:\"0\";s:37:\"portfolio_archive_hide_sidebar_tablet\";s:1:\"1\";s:37:\"portfolio_archive_hide_sidebar_mobile\";s:1:\"1\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:28:\"portoflio_image_custom_width\";s:0:\"\";s:29:\"portoflio_image_custom_height\";s:0:\"\";s:17:\"portoflio_filters\";s:1:\"0\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:23:\"single_portfolio_layout\";s:13:\"sidebar-right\";s:30:\"single_portfolio_sidebar_width\";s:1:\"3\";s:29:\"single_portfolio_hide_sidebar\";s:1:\"0\";s:36:\"single_portfolio_hide_sidebar_tablet\";s:1:\"1\";s:36:\"single_portfolio_hide_sidebar_mobile\";s:1:\"1\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:32:\"single_project_builder_post_data\";s:0:\"\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"1\";s:33:\"add_to_cart_action_timeout_number\";s:2:\"15\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"1\";s:16:\"show_sku_in_cart\";s:1:\"1\";s:25:\"show_sku_in_checkout_page\";s:1:\"0\";s:26:\"show_sku_in_thank_you_page\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"1\";s:16:\"show_sku_on_ajax\";s:1:\"1\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"0\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:7:\"pa_size\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"6\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"0\";s:32:\"variation_gallery_storage_method\";s:3:\"new\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:29:\"show_filtered_variation_image\";s:1:\"0\";s:17:\"hide_larger_price\";s:1:\"1\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:11:\"rectangular\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:2:\"25\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:18:\"brand_tab_priority\";s:0:\"\";s:14:\"brand_tab_name\";s:1:\"1\";s:10:\"quick_view\";s:1:\"0\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"0\";s:12:\"compare_page\";s:2:\"29\";s:14:\"fields_compare\";a:4:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:8:\"pa_brand\";i:3;s:7:\"pa_size\";}s:18:\"empty_compare_text\";s:215:\"Δεν έχετε προσθέσει ακόμα προϊόντα για σύγκριση.<br> Μπορείτε να βρείτε περισσότερα από 4000 προϊόντα στο κατάστημα μας..\";s:15:\"compare_on_grid\";s:1:\"1\";s:25:\"compare_save_button_state\";s:1:\"0\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:18:\"cart_totals_layout\";s:8:\"layout-1\";s:27:\"update_cart_quantity_change\";s:1:\"0\";s:15:\"empty_cart_text\";s:277:\"Πριν προχωρήσετε σε αγορά πρέπει να προσθέσετε μερικά προϊόντα στο καλάθι σας.<br> Θα βρείτε μεγάλη ποικιλία προϊόντων σε όλες τις κατηγορίες προϊόντων.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:27:\"single_product_hide_sidebar\";s:1:\"0\";s:34:\"single_product_hide_sidebar_tablet\";s:1:\"1\";s:34:\"single_product_hide_sidebar_mobile\";s:1:\"1\";s:20:\"single_product_style\";s:1:\"2\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:12:\"image_action\";s:4:\"zoom\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"1\";s:23:\"pagination_main_gallery\";s:1:\"1\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:4:\"left\";s:31:\"single_product_grid_columns_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:34:\"single_product_grid_column_desktop\";s:0:\"\";s:33:\"single_product_grid_column_tablet\";s:0:\"\";s:33:\"single_product_grid_column_mobile\";s:0:\"\";s:37:\"single_product_gallery_column_desktop\";s:1:\"1\";s:36:\"single_product_gallery_column_tablet\";s:0:\"\";s:36:\"single_product_gallery_column_mobile\";s:0:\"\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:22:\"main_gallery_on_tablet\";s:1:\"1\";s:22:\"main_gallery_on_mobile\";s:1:\"1\";s:24:\"main_gallery_center_mode\";s:1:\"0\";s:48:\"single_product_thumbnails_wrap_in_mobile_devices\";s:1:\"1\";s:39:\"single_product_thumbnails_gallery_width\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:40:\"single_product_thumbnails_gallery_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"400\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"1\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"1\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:10:\"html_block\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:5:\"28492\";s:30:\"after_add_to_cart_content_type\";s:10:\"html_block\";s:25:\"content_after_add_to_cart\";s:65:\"Άμεση Παραλαβή / 1-3 Εργάσιμες Ημέρες\";s:28:\"after_add_to_cart_html_block\";s:5:\"20465\";s:27:\"single_breadcrumbs_position\";s:12:\"below_header\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:18:\"show_product_brand\";s:1:\"0\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:4:\"grid\";s:23:\"related_product_columns\";s:1:\"5\";s:30:\"related_product_columns_tablet\";s:4:\"auto\";s:30:\"related_product_columns_mobile\";s:4:\"auto\";s:21:\"related_product_count\";s:2:\"10\";s:19:\"product_tabs_layout\";s:9:\"accordion\";s:21:\"product_tabs_location\";s:7:\"summary\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:22:\"enable_description_tab\";s:1:\"1\";s:24:\"description_tab_priority\";s:0:\"\";s:26:\"enable_additional_info_tab\";s:1:\"1\";s:28:\"additional_info_tab_priority\";s:0:\"\";s:18:\"enable_reviews_tab\";s:1:\"1\";s:20:\"reviews_tab_priority\";s:0:\"\";s:27:\"legacy_product_tabs_enabled\";s:1:\"1\";s:20:\"additional_tab_title\";s:35:\"Αποστολές & Αλλαγές\";s:23:\"additional_tab_priority\";s:0:\"\";s:27:\"additional_tab_content_type\";s:10:\"html_block\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:5:\"20470\";s:22:\"additional_tab_2_title\";s:0:\"\";s:25:\"additional_tab_2_priority\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:10:\"html_block\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:25:\"additional_tab_3_priority\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:14:\"Εγγραφή\";s:8:\"reg_text\";s:506:\"Κάνοντας εγγραφή στην σελίδα μας, θα έχετε πρόσβαση στις παραγγελίες σας και το ιστορικό σας. Απλά συμπληρώστε τα παρακάτω πεδία για να αποκτήσετε πρόσβαση άμεσα. Θα σας ζητήσουμε μόνο τις απαραίτητες πληροφορίες για να ολοκληρώνετε τις αγορές σας γρηγορότερα και ευκολότερα.\";s:11:\"login_title\";s:14:\"Σύνδεση\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:3469:\"/* Breadcrumb link */\r\n.woodmart-woo-breadcrumbs .woocommerce-breadcrumb .breadcrumb-link:nth-child(1){\r\n	display:none;\r\n}\r\n\r\n/* Breadcrumb link */\r\n.woodmart-woo-breadcrumbs .woocommerce-breadcrumb .breadcrumb-link:nth-child(2){\r\n	display:none;\r\n}\r\n\r\n/* Breadcrumb link */\r\n.woodmart-woo-breadcrumbs .woocommerce-breadcrumb .breadcrumb-link:nth-child(3){\r\n	display:none;\r\n}\r\n\r\n\r\n/* Paragraph */\r\n.description-area-after .term-description p{\r\n	display:none;\r\n}\r\n\r\n/* After add cart */\r\n.entry-summary .wd-after-add-to-cart{\r\n	color:#83b735;\r\n	\r\n}\r\n\r\n/* Link */\r\n.cart-widget-side li:nth-child(1) a:nth-child(2){\r\n	transform:scale(1.45);\r\n}\r\n\r\n.cart-widget-side li:nth-child(2) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(3) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(4) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(5) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(6) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(7) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(8) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(9) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(10) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(11) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(12) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(13) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n/* Breadcrumb link */\r\n.single-breadcrumbs-wrapper .woocommerce-breadcrumb .breadcrumb-link:nth-child(1){\r\n	display:none;\r\n}\r\n\r\n/* Breadcrumb link */\r\n.single-breadcrumbs-wrapper .woocommerce-breadcrumb .breadcrumb-link:nth-child(2){\r\n	display:none;\r\n}\r\n\r\n/* Breadcrumb link */\r\n.single-breadcrumbs-wrapper .woocommerce-breadcrumb .breadcrumb-link:nth-child(3){\r\n	display:none;\r\n}\r\n\r\n/* Woodmart back */\r\n.single-breadcrumbs-wrapper .woodmart-products-nav .woodmart-back-btn{\r\n	display:none;\r\n}\r\n\r\n/* Prev */\r\n.woodmart-products-nav div .wd-btn-prev{\r\n	transform:scale(1.4) translatex(-5px);\r\n}\r\n\r\n/* Next */\r\n.woodmart-products-nav div .wd-btn-next{\r\n	transform:scale(1.4);\r\n}\r\n\r\n/* Tab title seller */\r\n.woocommerce-tabs .wd-accordion-item .tab-title-seller{\r\n	display:none;\r\n	\r\n}\r\n\r\n/* 1025px and larger screen sizes */\r\n@media (min-width:1025px){\r\n\r\n	/* Breadcrumb last */\r\n	.single-breadcrumbs-wrapper .woocommerce-breadcrumb .breadcrumb-last{\r\n		display:none;\r\n	}\r\n	\r\n}\r\n\r\n\r\n/* 1024px and smaller screen sizes */\r\n@media (max-width:1024px){\r\n\r\n	/* Category nav link */\r\n	.woodmart-product-categories .shop-all-link .category-nav-link{\r\n		display:none;\r\n		\r\n	}\r\n	\r\n}\r\n\r\n/* Link */\r\n.wd-products-holder .woodmart-product-cats a{\r\n	color:#76C43C;\r\n	font-size:14px;\r\n	font-weight:600;\r\n}\r\n\r\n/* Show Current Cat Open on Mobile Nav */\r\n\r\n.wd-nav-mobile .current-menu-ancestor>ul,.wd-nav-mobile .current-menu-parent>ul {\r\n\r\n    display: block;\r\n\r\n}\r\n\r\n.wd-nav-mobile .current-menu-ancestor>.wd-nav-opener,.wd-nav-mobile .current-menu-parent>.wd-nav-opener{\r\n\r\n    background-color: var(--wd-primary-color);\r\n\r\n    color: var(--nav-opener-color-active);\r\n\r\n}\r\n\r\n.wd-nav-mobile .current-menu-ancestor>.wd-nav-opener:after,.wd-nav-mobile .current-menu-parent>.wd-nav-opener:after{\r\n\r\n    transform: rotate(90deg);\r\n	\r\n\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:35:\"https://www.facebook.com/LikeMe.gr/\";s:12:\"twitter_link\";s:0:\"\";s:12:\"bluesky_link\";s:0:\"\";s:14:\"isntagram_link\";s:36:\"https://www.instagram.com/likeme.gr/\";s:12:\"threads_link\";s:0:\"\";s:14:\"pinterest_link\";s:0:\"\";s:12:\"youtube_link\";s:0:\"\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:10:\"viber_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:12:\"discord_link\";s:0:\"\";s:9:\"yelp_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"0\";s:14:\"share_linkedin\";s:1:\"0\";s:14:\"share_whatsapp\";s:1:\"1\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:1:\"1\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_ok\";s:1:\"0\";s:11:\"share_email\";s:1:\"1\";s:19:\"mobile_optimization\";s:1:\"0\";s:16:\"load_text_domain\";s:1:\"1\";s:21:\"disable_gutenberg_css\";s:1:\"1\";s:19:\"inline_critical_css\";b:0;s:19:\"advanced_css_notice\";s:0:\"\";s:17:\"styles_always_use\";a:3:{i:0;s:18:\"product-loop-quick\";i:1;s:23:\"woo-mod-add-btn-replace\";i:2;s:12:\"product-loop\";}s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"1\";s:21:\"remove_jquery_migrate\";s:1:\"1\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:17:\"wd_swiper_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:22:\"lazy_loading_bg_images\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:4:\"1000\";s:11:\"lazy_effect\";s:4:\"fade\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"0\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:17:\"preload_lcp_image\";b:0;s:15:\"current_builder\";s:8:\"external\";s:16:\"gutenberg_blocks\";s:1:\"0\";s:29:\"enable_gutenberg_for_products\";s:1:\"0\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"0\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"0\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"0\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:24:\"auto_update_translations\";s:1:\"0\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"1\";s:22:\"white_label_theme_name\";s:12:\"ProMarketing\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:9:\"LikeMe.gr\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:3:\"178\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:181:\"Δεν έχετε αγαπημένα προϊόντα ακόμα.  <br> Θα βρείτε μεγάλη ποικιλία προϊόντων σε όλες τις κατηγορίες.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"1\";s:27:\"checkout_show_product_image\";s:1:\"1\";s:25:\"checkout_product_quantity\";s:1:\"1\";s:22:\"checkout_remove_button\";s:1:\"1\";s:24:\"checkout_link_to_product\";s:1:\"1\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:21:\"reviews_form_location\";s:5:\"after\";s:13:\"reviews_style\";s:7:\"style-1\";s:15:\"reviews_columns\";s:1:\"1\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:24:\"reviews_enable_pros_cons\";s:1:\"0\";s:20:\"reviews_enable_likes\";s:1:\"1\";s:32:\"show_reviews_purchased_indicator\";s:1:\"0\";s:15:\"reviews_sorting\";s:1:\"0\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"0\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"0\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:23:\"checkout_fields_enabled\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:2:\"49\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"include\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"1\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"1\";s:37:\"shipping_progress_bar_message_initial\";s:78:\"Με [remainder] ακόμα θα έχεις δωρεάν μεταφορικά!\";s:37:\"shipping_progress_bar_message_success\";s:87:\"Ο στόχος επιτεύχθη! Κέρδισες δωρεάν μεταφορικά!\";s:15:\"buy_now_enabled\";s:1:\"0\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"1\";s:27:\"counter_visitor_data_source\";s:9:\"fake_data\";s:38:\"counter_visitor_data_source_min_number\";s:1:\"2\";s:38:\"counter_visitor_data_source_max_number\";s:1:\"6\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"1\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:17:\"linked_variations\";s:1:\"0\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:20:\"sold_counter_enabled\";s:1:\"0\";s:23:\"sold_counter_sales_type\";s:9:\"real_data\";s:24:\"sold_counter_shown_after\";s:1:\"0\";s:22:\"sold_counter_min_count\";s:2:\"10\";s:22:\"sold_counter_max_count\";s:2:\"20\";s:31:\"sold_counter_hide_on_outofstock\";s:1:\"0\";s:22:\"sold_counter_timeframe\";s:1:\"3\";s:29:\"sold_counter_timeframe_period\";s:7:\"minutes\";s:28:\"sold_counter_transient_hours\";s:2:\"24\";s:17:\"discounts_enabled\";s:1:\"1\";s:20:\"show_discounts_table\";s:1:\"1\";s:18:\"free_gifts_enabled\";s:1:\"0\";s:16:\"free_gifts_limit\";s:1:\"5\";s:41:\"free_gifts_allow_multiple_identical_gifts\";s:1:\"0\";s:23:\"free_gifts_price_format\";s:4:\"text\";s:17:\"free_gift_on_cart\";s:1:\"1\";s:25:\"free_gifts_table_location\";s:28:\"woocommerce_after_cart_table\";s:21:\"free_gift_on_checkout\";s:1:\"0\";s:28:\"show_out_of_stock_at_the_end\";s:1:\"0\";s:16:\"waitlist_enabled\";s:1:\"0\";s:21:\"waitlist_for_loggined\";s:1:\"0\";s:19:\"waitlist_form_state\";s:13:\"current_state\";s:25:\"waitlist_fragments_enable\";s:1:\"0\";s:22:\"waitlist_wait_interval\";s:4:\"3600\";s:32:\"waitlist_enable_privacy_checkbox\";s:1:\"1\";s:30:\"waitlist_privacy_checkbox_text\";s:60:\"I have read and accept the <strong>[privacy_policy]</strong>\";s:25:\"estimate_delivery_enabled\";s:1:\"0\";s:40:\"estimate_delivery_show_on_single_product\";s:1:\"1\";s:35:\"estimate_delivery_show_on_mini_cart\";s:1:\"0\";s:35:\"estimate_delivery_show_on_cart_page\";s:1:\"1\";s:39:\"estimate_delivery_show_on_checkout_page\";s:1:\"1\";s:39:\"estimate_delivery_show_on_order_details\";s:1:\"1\";s:37:\"estimate_delivery_show_on_email_order\";s:1:\"1\";s:30:\"estimate_delivery_show_overall\";s:1:\"0\";s:29:\"estimate_delivery_date_format\";s:7:\"default\";s:34:\"estimate_delivery_fragments_enable\";s:1:\"0\";s:27:\"custom_product_tabs_enabled\";s:1:\"0\";s:21:\"cart_recovery_enabled\";s:1:\"0\";s:26:\"recover_guest_cart_enabled\";s:1:\"0\";s:42:\"recover_guest_cart_enable_privacy_checkbox\";s:1:\"0\";s:40:\"recover_guest_cart_privacy_checkbox_text\";s:281:\"If you check this box, you are giving us permission to save some of your details into a contact list. You may receive email messages containing information of commercial or promotional nature concerning this store.\r\nPersonal Data collected: email address, first name and last name.\";s:24:\"abandoned_cart_timeframe\";s:1:\"2\";s:31:\"abandoned_cart_timeframe_period\";s:5:\"86400\";s:31:\"abandoned_cart_delete_timeframe\";s:2:\"30\";s:38:\"abandoned_cart_delete_timeframe_period\";s:5:\"86400\";s:29:\"abandoned_cart_coupon_enabled\";s:1:\"0\";s:28:\"abandoned_cart_coupon_prefix\";s:2:\"WD\";s:28:\"abandoned_cart_coupon_amount\";s:2:\"10\";s:35:\"abandoned_cart_coupon_discount_type\";s:7:\"percent\";s:34:\"abandoned_cart_delete_used_coupons\";s:1:\"1\";s:37:\"abandoned_cart_delete_expired_coupons\";s:1:\"1\";s:31:\"abandoned_cart_coupon_timeframe\";s:1:\"1\";s:38:\"abandoned_cart_coupon_timeframe_period\";s:5:\"86400\";s:23:\"review_reminder_enabled\";s:1:\"1\";s:33:\"review_reminder_sending_timeframe\";s:1:\"7\";s:40:\"review_reminder_sending_timeframe_period\";s:0:\"\";s:21:\"price_tracker_enabled\";s:1:\"0\";s:26:\"price_tracker_for_loggined\";s:1:\"0\";s:32:\"price_tracker_use_loggedin_email\";s:1:\"0\";s:27:\"price_tracker_desired_price\";s:1:\"0\";s:37:\"price_tracker_enable_privacy_checkbox\";s:1:\"1\";s:30:\"price_tracker_fragments_enable\";s:1:\"0\";s:31:\"email_marketing_consent_enabled\";s:1:\"0\";s:37:\"email_subscription_individual_control\";s:1:\"0\";s:8:\"last_tab\";s:0:\"\";}","auto"),
("190","woodmart_setup_status","","auto"),
("191","wd_import_theme_version","","auto"),
("192","woodmart-plugins-update-time","1769419362","auto"),
("193","woodmart_js_composer_version","8.7.2","auto"),
("194","woodmart_revslider_version","6.7.40","auto"),
("195","woodmart_woodmart-images-optimizer_version","1.3.3","auto"),
("198","wd_wishlist_installed","1","auto"),
("199","woodmart_upgrade_database_wishlist","1","auto"),
("200","woodmart_added_column_on_sale_in_product_db","1","auto"),
("201","xts-theme_settings_default-css-data","@font-face {\n	font-weight: normal;\n	font-style: normal;\n	font-family: \"woodmart-font\";\n	src: url(\"//staging.promarketing.gr/wp-content/themes/woodmart/fonts/woodmart-font-1-400.woff2?v=8.3.8\") format(\"woff2\");\n}\n\n:root {\n	--wd-text-font: \"Roboto\", Arial, Helvetica, sans-serif;\n	--wd-text-font-weight: 400;\n	--wd-text-color: #777777;\n	--wd-text-font-size: 14px;\n	--wd-title-font: \"Roboto\", Arial, Helvetica, sans-serif;\n	--wd-title-font-weight: 500;\n	--wd-title-color: #242424;\n	--wd-entities-title-font: \"Roboto\", Arial, Helvetica, sans-serif;\n	--wd-entities-title-font-weight: 400;\n	--wd-entities-title-color: #333333;\n	--wd-entities-title-color-hover: rgb(51 51 51 / 65%);\n	--wd-alternative-font: \"Roboto\", Arial, Helvetica, sans-serif;\n	--wd-widget-title-font: \"Roboto\", Arial, Helvetica, sans-serif;\n	--wd-widget-title-font-weight: 500;\n	--wd-widget-title-transform: uppercase;\n	--wd-widget-title-color: #333;\n	--wd-widget-title-font-size: 16px;\n	--wd-header-el-font: \"Roboto\", Arial, Helvetica, sans-serif;\n	--wd-header-el-font-weight: 500;\n	--wd-header-el-transform: uppercase;\n	--wd-header-el-font-size: 17px;\n	--wd-otl-style: dotted;\n	--wd-otl-width: 2px;\n	--wd-primary-color: rgb(129,215,66);\n	--wd-alternative-color: rgb(129,215,66);\n	--btn-default-bgcolor: #f7f7f7;\n	--btn-default-bgcolor-hover: #efefef;\n	--btn-accented-bgcolor: rgb(129,215,66);\n	--btn-accented-bgcolor-hover: rgb(129,215,66);\n	--wd-form-brd-width: 2px;\n	--notices-success-bg: rgb(129,215,66);\n	--notices-success-color: #fff;\n	--notices-warning-bg: rgb(129,215,66);\n	--notices-warning-color: #fff;\n	--wd-link-color: rgb(129,215,66);\n	--wd-link-color-hover: rgb(129,215,66);\n	--wd-sticky-btn-height: 95px;\n}\n.wd-age-verify-wrap {\n	--wd-popup-width: 500px;\n}\n.wd-popup.wd-promo-popup {\n	background-color: #111111;\n	background-image: none;\n	background-repeat: no-repeat;\n	background-size: contain;\n	background-position: left center;\n}\n.wd-promo-popup-wrap {\n	--wd-popup-width: 800px;\n}\n:is(.woodmart-woocommerce-layered-nav, .wd-product-category-filter) .wd-scroll-content {\n	max-height: 180px;\n}\n.wd-page-title .wd-page-title-bg img {\n	object-fit: cover;\n	object-position: center center;\n}\n.wd-footer {\n	background-color: #ffffff;\n	background-image: none;\n}\n.mfp-wrap.wd-popup-quick-view-wrap {\n	--wd-popup-width: 920px;\n}\n\n@media (max-width: 1024px) {\n	:root {\n		--wd-sticky-btn-height: 95px;\n	}\n\n}\n\n@media (max-width: 768.98px) {\n	:root {\n		--wd-sticky-btn-height: 42px;\n	}\n\n}\n:root{\n--wd-container-w: 1600px;\n--wd-form-brd-radius: 0px;\n--btn-default-color: #333;\n--btn-default-color-hover: #333;\n--btn-accented-color: #fff;\n--btn-accented-color-hover: #fff;\n--btn-default-brd-radius: 0px;\n--btn-default-box-shadow: none;\n--btn-default-box-shadow-hover: none;\n--btn-default-box-shadow-active: none;\n--btn-default-bottom: 0px;\n--btn-accented-brd-radius: 0px;\n--btn-accented-box-shadow: none;\n--btn-accented-box-shadow-hover: none;\n--btn-accented-box-shadow-active: none;\n--btn-accented-bottom: 0px;\n--wd-brd-radius: 0px;\n}\n\n@media (min-width: 1600px) {\nsection.elementor-section.wd-section-stretch > .elementor-container {\nmargin-left: auto;\nmargin-right: auto;\n}\n}\n\n\n.wd-page-title {\nbackground-color: rgb(64,64,63);\n}\n\n/* Breadcrumb link */\r\n.woodmart-woo-breadcrumbs .woocommerce-breadcrumb .breadcrumb-link:nth-child(1){\r\n	display:none;\r\n}\r\n\r\n/* Breadcrumb link */\r\n.woodmart-woo-breadcrumbs .woocommerce-breadcrumb .breadcrumb-link:nth-child(2){\r\n	display:none;\r\n}\r\n\r\n/* Breadcrumb link */\r\n.woodmart-woo-breadcrumbs .woocommerce-breadcrumb .breadcrumb-link:nth-child(3){\r\n	display:none;\r\n}\r\n\r\n\r\n/* Paragraph */\r\n.description-area-after .term-description p{\r\n	display:none;\r\n}\r\n\r\n/* After add cart */\r\n.entry-summary .wd-after-add-to-cart{\r\n	color:#83b735;\r\n	\r\n}\r\n\r\n/* Link */\r\n.cart-widget-side li:nth-child(1) a:nth-child(2){\r\n	transform:scale(1.45);\r\n}\r\n\r\n.cart-widget-side li:nth-child(2) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(3) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(4) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(5) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(6) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(7) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(8) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(9) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(10) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(11) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(12) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(13) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n/* Breadcrumb link */\r\n.single-breadcrumbs-wrapper .woocommerce-breadcrumb .breadcrumb-link:nth-child(1){\r\n	display:none;\r\n}\r\n\r\n/* Breadcrumb link */\r\n.single-breadcrumbs-wrapper .woocommerce-breadcrumb .breadcrumb-link:nth-child(2){\r\n	display:none;\r\n}\r\n\r\n/* Breadcrumb link */\r\n.single-breadcrumbs-wrapper .woocommerce-breadcrumb .breadcrumb-link:nth-child(3){\r\n	display:none;\r\n}\r\n\r\n/* Woodmart back */\r\n.single-breadcrumbs-wrapper .woodmart-products-nav .woodmart-back-btn{\r\n	display:none;\r\n}\r\n\r\n/* Prev */\r\n.woodmart-products-nav div .wd-btn-prev{\r\n	transform:scale(1.4) translatex(-5px);\r\n}\r\n\r\n/* Next */\r\n.woodmart-products-nav div .wd-btn-next{\r\n	transform:scale(1.4);\r\n}\r\n\r\n/* Tab title seller */\r\n.woocommerce-tabs .wd-accordion-item .tab-title-seller{\r\n	display:none;\r\n	\r\n}\r\n\r\n/* 1025px and larger screen sizes */\r\n@media (min-width:1025px){\r\n\r\n	/* Breadcrumb last */\r\n	.single-breadcrumbs-wrapper .woocommerce-breadcrumb .breadcrumb-last{\r\n		display:none;\r\n	}\r\n	\r\n}\r\n\r\n\r\n/* 1024px and smaller screen sizes */\r\n@media (max-width:1024px){\r\n\r\n	/* Category nav link */\r\n	.woodmart-product-categories .shop-all-link .category-nav-link{\r\n		display:none;\r\n		\r\n	}\r\n	\r\n}\r\n\r\n/* Link */\r\n.wd-products-holder .woodmart-product-cats a{\r\n	color:#76C43C;\r\n	font-size:14px;\r\n	font-weight:600;\r\n}\r\n\r\n/* Show Current Cat Open on Mobile Nav */\r\n\r\n.wd-nav-mobile .current-menu-ancestor>ul,.wd-nav-mobile .current-menu-parent>ul {\r\n\r\n    display: block;\r\n\r\n}\r\n\r\n.wd-nav-mobile .current-menu-ancestor>.wd-nav-opener,.wd-nav-mobile .current-menu-parent>.wd-nav-opener{\r\n\r\n    background-color: var(--wd-primary-color);\r\n\r\n    color: var(--nav-opener-color-active);\r\n\r\n}\r\n\r\n.wd-nav-mobile .current-menu-ancestor>.wd-nav-opener:after,.wd-nav-mobile .current-menu-parent>.wd-nav-opener:after{\r\n\r\n    transform: rotate(90deg);\r\n	\r\n","on");

INSERT IGNORE INTO `wpby_options` VALUES 
("203","xts-theme_settings_default-version","8.3.8","on"),
("204","xts-theme_settings_default-site-url","652d50dbe520f689a6bb223640a2438c","on"),
("208","woodmart_unsubscribed_emails_table_created","1","off"),
("209","woodmart_unsubscribed_emails_migrated","1","off"),
("210","woodmart_version","8.3.8","auto"),
("211","allowedthemes","a:1:{s:14:\"woodmart-child\";b:1;}","off"),
("213","theme_mods_woodmart-child","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:9:\"main-menu\";i:21;s:11:\"mobile-menu\";i:22;}s:18:\"custom_css_post_id\";i:-1;}","on"),
("221","widget_nav_mega_menu","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("222","widget_woodmart-banner","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("223","widget_woodmart-author-information","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("224","widget_woodmart-instagram","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("225","widget_woodmart-html-block","a:2:{i:2;a:1:{s:2:\"id\";s:3:\"242\";}s:12:\"_multiwidget\";i:1;}","auto"),
("226","widget_woodmart-recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("227","widget_woodmart-twitter","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("228","widget_wd-mailchimp-widget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("230","default_term_wd_popup_cat","2","auto"),
("232","default_term_wd_floating_block_cat","3","auto"),
("234","default_term_cms_block_cat","4","auto"),
("245","action_scheduler_hybrid_store_demarkation","6","auto"),
("246","schema-ActionScheduler_StoreSchema","8.0.1769418686","auto"),
("247","schema-ActionScheduler_LoggerSchema","3.0.1769418686","auto"),
("250","woocommerce_newly_installed","no","auto"),
("251","woocommerce_order_stats_has_fulfillment_column","no","off"),
("252","woocommerce_schema_version","920","auto"),
("253","woocommerce_store_address","Δοϊράνης 9","on"),
("254","woocommerce_store_address_2","211800400","on"),
("255","woocommerce_store_city","Καλλιθέα","on"),
("256","woocommerce_default_country","GR:I","on"),
("257","woocommerce_store_postcode","17671","on"),
("258","woocommerce_allowed_countries","specific","on"),
("259","woocommerce_all_except_countries","a:0:{}","on"),
("260","woocommerce_specific_allowed_countries","a:1:{i:0;s:2:\"GR\";}","on"),
("261","woocommerce_ship_to_countries","","on"),
("262","woocommerce_specific_ship_to_countries","a:0:{}","on"),
("263","woocommerce_default_customer_address","base","on"),
("264","woocommerce_address_autocomplete_enabled","no","on"),
("265","woocommerce_calc_taxes","yes","on"),
("266","woocommerce_enable_coupons","yes","on"),
("267","woocommerce_calc_discounts_sequentially","no","off"),
("268","woocommerce_currency","EUR","on"),
("269","woocommerce_currency_pos","right_space","on"),
("270","woocommerce_price_thousand_sep",".","on"),
("271","woocommerce_price_decimal_sep",",","on"),
("272","woocommerce_price_num_decimals","2","on"),
("273","woocommerce_shop_page_id","8","on"),
("274","woocommerce_cart_redirect_after_add","no","on"),
("275","woocommerce_enable_ajax_add_to_cart","yes","on"),
("276","woocommerce_placeholder_image","7","on"),
("277","woocommerce_weight_unit","kg","on"),
("278","woocommerce_dimension_unit","cm","on"),
("279","woocommerce_enable_reviews","yes","on"),
("280","woocommerce_review_rating_verification_label","no","off"),
("281","woocommerce_review_rating_verification_required","no","off"),
("282","woocommerce_enable_review_rating","yes","on"),
("283","woocommerce_review_rating_required","no","off"),
("284","woocommerce_manage_stock","yes","on"),
("285","woocommerce_hold_stock_minutes","60","off"),
("286","woocommerce_notify_low_stock","no","off"),
("287","woocommerce_notify_no_stock","no","off"),
("288","woocommerce_stock_email_recipient","and.adamop@gmail.com","off"),
("289","woocommerce_notify_low_stock_amount","0","off"),
("290","woocommerce_notify_no_stock_amount","0","on"),
("291","woocommerce_hide_out_of_stock_items","yes","on"),
("292","woocommerce_stock_format","","on"),
("293","woocommerce_file_download_method","force","off"),
("294","woocommerce_downloads_redirect_fallback_allowed","no","off"),
("295","woocommerce_downloads_require_login","no","off"),
("296","woocommerce_downloads_grant_access_after_payment","yes","off"),
("297","woocommerce_downloads_deliver_inline","","off"),
("298","woocommerce_downloads_add_hash_to_filename","yes","on"),
("299","woocommerce_downloads_count_partial","yes","on"),
("301","woocommerce_attribute_lookup_direct_updates","yes","on"),
("302","woocommerce_attribute_lookup_optimized_updates","yes","on"),
("303","woocommerce_product_match_featured_image_by_sku","no","on"),
("304","woocommerce_prices_include_tax","yes","on"),
("305","woocommerce_tax_based_on","shipping","on"),
("306","woocommerce_shipping_tax_class","","on"),
("307","woocommerce_tax_round_at_subtotal","no","on"),
("308","woocommerce_tax_classes","","on"),
("309","woocommerce_tax_display_shop","incl","on"),
("310","woocommerce_tax_display_cart","incl","on"),
("311","woocommerce_price_display_suffix","","on"),
("312","woocommerce_tax_total_display","single","off"),
("313","woocommerce_enable_shipping_calc","yes","off"),
("314","woocommerce_shipping_cost_requires_address","no","on"),
("315","woocommerce_shipping_hide_rates_when_free","no","off"),
("316","woocommerce_ship_to_destination","billing","off"),
("317","woocommerce_shipping_debug_mode","no","on"),
("318","woocommerce_enable_guest_checkout","yes","off"),
("319","woocommerce_enable_checkout_login_reminder","no","off"),
("320","woocommerce_enable_signup_and_login_from_checkout","no","off"),
("321","woocommerce_enable_myaccount_registration","yes","off"),
("322","woocommerce_registration_generate_password","no","off"),
("323","woocommerce_registration_generate_username","no","off"),
("324","woocommerce_erasure_request_removes_order_data","no","off"),
("325","woocommerce_erasure_request_removes_download_data","no","off"),
("326","woocommerce_allow_bulk_remove_personal_data","no","off"),
("327","woocommerce_registration_privacy_policy_text","Τα προσωπικά σας δεδομένα θα χρησιμοποιηθούν για την υποστήριξη της εμπειρίας σας σε ολόκληρο τον ιστότοπο, για τη διαχείριση της πρόσβασης στο λογαριασμό σας και για άλλους σκοπούς που περιγράφονται στη σελίδα [privacy_policy].","on"),
("328","woocommerce_checkout_privacy_policy_text","Τα προσωπικά σας δεδομένα θα χρησιμοποιηθούν για τη διεκπεραίωση της παραγγελίας σας, την άρτια εμπειρία σας στον ιστότοπο και για ό,τι ακόμα περιγράφεται στην [privacy_policy].","on"),
("329","woocommerce_delete_inactive_accounts","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","off"),
("330","woocommerce_trash_pending_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}","off"),
("331","woocommerce_trash_failed_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}","off"),
("332","woocommerce_trash_cancelled_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}","off"),
("333","woocommerce_anonymize_refunded_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","off"),
("334","woocommerce_anonymize_completed_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","off"),
("335","woocommerce_email_from_name","LikeMe.gr | Κατάστημα Ένδυσης & Αξεσουάρ","off"),
("336","woocommerce_email_from_address","pro@likeme.gr","off"),
("337","woocommerce_email_header_image","","off"),
("338","woocommerce_email_header_image_width","120","on"),
("339","woocommerce_email_header_alignment","left","on"),
("340","woocommerce_email_font_family","Helvetica","on"),
("341","woocommerce_email_footer_text","{site_title}<br />{store_address}","off"),
("342","woocommerce_email_base_color","#720eec","off"),
("343","woocommerce_email_background_color","#f7f7f7","off"),
("344","woocommerce_email_body_background_color","#ffffff","off"),
("345","woocommerce_email_text_color","#3c3c3c","off"),
("346","woocommerce_email_footer_text_color","#3c3c3c","off"),
("347","woocommerce_email_auto_sync_with_theme","yes","off"),
("348","woocommerce_pos_store_name","My Blog","on"),
("349","woocommerce_pos_store_address","","on"),
("350","woocommerce_pos_store_phone","","on"),
("351","woocommerce_pos_store_email","and.adamop@gmail.com","on"),
("352","woocommerce_pos_refund_returns_policy","","on"),
("353","woocommerce_cart_page_id","9","off"),
("354","woocommerce_checkout_page_id","10","off"),
("355","woocommerce_myaccount_page_id","11","off"),
("356","woocommerce_terms_page_id","198","on"),
("357","woocommerce_checkout_pay_endpoint","order-pay","on"),
("358","woocommerce_checkout_order_received_endpoint","order-received","on"),
("359","woocommerce_myaccount_add_payment_method_endpoint","add-payment-method","on"),
("360","woocommerce_myaccount_delete_payment_method_endpoint","delete-payment-method","on"),
("361","woocommerce_myaccount_set_default_payment_method_endpoint","set-default-payment-method","on"),
("362","woocommerce_myaccount_orders_endpoint","orders","on"),
("363","woocommerce_myaccount_view_order_endpoint","view-order","on"),
("364","woocommerce_myaccount_downloads_endpoint","downloads","on"),
("365","woocommerce_myaccount_edit_account_endpoint","edit-account","on"),
("366","woocommerce_myaccount_edit_address_endpoint","edit-address","on"),
("367","woocommerce_myaccount_payment_methods_endpoint","payment-methods","on"),
("368","woocommerce_myaccount_lost_password_endpoint","lost-password","on"),
("369","woocommerce_logout_endpoint","customer-logout","on"),
("370","woocommerce_api_enabled","no","on"),
("371","woocommerce_allow_tracking","no","on"),
("372","woocommerce_show_marketplace_suggestions","yes","off"),
("373","woocommerce_custom_orders_table_enabled","yes","on"),
("374","woocommerce_analytics_enabled","yes","on"),
("375","woocommerce_feature_rate_limit_checkout_enabled","no","on"),
("376","woocommerce_feature_order_attribution_enabled","yes","on"),
("377","woocommerce_feature_site_visibility_badge_enabled","yes","on"),
("378","woocommerce_hpos_datastore_caching_enabled","yes","on"),
("379","woocommerce_feature_remote_logging_enabled","no","on"),
("380","woocommerce_feature_email_improvements_enabled","no","on"),
("383","woocommerce_email_improvements_disabled_count","2","auto"),
("384","woocommerce_email_improvements_first_disabled_at","2026-01-26 09:11:27","auto"),
("385","woocommerce_email_improvements_last_disabled_at","2026-01-26 10:29:16","auto"),
("386","woocommerce_feature_blueprint_enabled","no","on"),
("387","woocommerce_feature_cost_of_goods_sold_enabled","no","on"),
("388","woocommerce_hpos_fts_index_enabled","no","on"),
("389","woocommerce_feature_block_email_editor_enabled","no","on"),
("390","woocommerce_feature_point_of_sale_enabled","no","on"),
("391","woocommerce_feature_mcp_integration_enabled","no","on"),
("392","woocommerce_feature_destroy-empty-sessions_enabled","yes","on"),
("393","woocommerce_single_image_width","1067","on"),
("394","woocommerce_thumbnail_image_width","1067","on"),
("395","woocommerce_checkout_highlight_required_fields","yes","on"),
("396","woocommerce_demo_store","no","off"),
("397","wc_downloads_approved_directories_mode","enabled","auto"),
("398","woocommerce_permalinks","a:5:{s:12:\"product_base\";s:19:\"/shop/%product_cat%\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:1;}","auto"),
("399","current_theme_supports_woocommerce","yes","auto"),
("400","woocommerce_queue_flush_rewrite_rules","no","auto"),
("403","default_product_cat","18","auto"),
("405","woocommerce_refund_returns_page_id","12","auto"),
("408","woocommerce_paypal_settings","a:25:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:189:\"Πληρωμή μέσω PayPal. Μπορείτε να πληρώσετε με την πιστωτική σας κάρτα αν δεν έχετε έναν λογαριασμό στο PayPal.\";s:5:\"email\";s:20:\"and.adamop@gmail.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:14:\"paypal_buttons\";s:3:\"yes\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:9:\"image_url\";s:0:\"\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:20:\"and.adamop@gmail.com\";s:14:\"identity_token\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:28:\"transact_onboarding_complete\";s:2:\"no\";s:12:\"_should_load\";s:2:\"no\";}","on"),
("409","woocommerce_version","10.4.3","auto"),
("410","woocommerce_db_version","10.4.3","auto"),
("411","woocommerce_store_id","17ea5ecb-01e5-41c4-9963-b0f8973720ff","auto"),
("412","woocommerce_admin_install_timestamp","1769418687","auto"),
("413","woocommerce_inbox_variant_assignment","7","auto"),
("414","woocommerce_remote_variant_assignment","75","auto"),
("415","woocommerce_attribute_lookup_enabled","yes","on"),
("416","xts-default_header-css-data",":root{\n	--wd-top-bar-h: 50px;\n	--wd-top-bar-sm-h: 50px;\n	--wd-top-bar-sticky-h: 50px;\n	--wd-top-bar-brd-w: .00001px;\n\n	--wd-header-general-h: 55px;\n	--wd-header-general-sm-h: 50px;\n	--wd-header-general-sticky-h: 55px;\n	--wd-header-general-brd-w: 1px;\n\n	--wd-header-bottom-h: 50px;\n	--wd-header-bottom-sm-h: .00001px;\n	--wd-header-bottom-sticky-h: .00001px;\n	--wd-header-bottom-brd-w: .00001px;\n\n	--wd-header-clone-h: .00001px;\n\n	--wd-header-brd-w: calc(var(--wd-top-bar-brd-w) + var(--wd-header-general-brd-w) + var(--wd-header-bottom-brd-w));\n	--wd-header-h: calc(var(--wd-top-bar-h) + var(--wd-header-general-h) + var(--wd-header-bottom-h) + var(--wd-header-brd-w));\n	--wd-header-sticky-h: calc(var(--wd-top-bar-sticky-h) + var(--wd-header-general-sticky-h) + var(--wd-header-bottom-sticky-h) + var(--wd-header-clone-h) + var(--wd-header-brd-w));\n	--wd-header-sm-h: calc(var(--wd-top-bar-sm-h) + var(--wd-header-general-sm-h) + var(--wd-header-bottom-sm-h) + var(--wd-header-brd-w));\n}\n\n.whb-top-bar .wd-dropdown {\n	margin-top: 4px;\n}\n\n.whb-top-bar .wd-dropdown:after {\n	height: 15px;\n}\n\n.whb-sticked .whb-top-bar .wd-dropdown:not(.sub-sub-menu) {\n	margin-top: 4px;\n}\n\n.whb-sticked .whb-top-bar .wd-dropdown:not(.sub-sub-menu):after {\n	height: 15px;\n}\n\n.whb-sticked .whb-general-header .wd-dropdown:not(.sub-sub-menu) {\n	margin-top: 6.5px;\n}\n\n.whb-sticked .whb-general-header .wd-dropdown:not(.sub-sub-menu):after {\n	height: 17.5px;\n}\n\n\n:root:has(.whb-general-header.whb-border-boxed) {\n	--wd-header-general-brd-w: .00001px;\n}\n\n@media (max-width: 1024px) {\n:root:has(.whb-general-header.whb-hidden-mobile) {\n	--wd-header-general-brd-w: .00001px;\n}\n}\n\n\n.whb-header-bottom .wd-dropdown {\n	margin-top: 4px;\n}\n\n.whb-header-bottom .wd-dropdown:after {\n	height: 15px;\n}\n\n\n\n		\n.whb-top-bar {\n	background-color: rgba(0, 0, 0, 1);\n}\n\n.whb-duljtjrl87kj7pmuut6b form.searchform {\n	--wd-form-height: 46px;\n}\n.whb-general-header {\n	background-color: rgba(246, 246, 246, 1);border-color: rgba(129, 129, 129, 0.2);border-bottom-width: 1px;border-bottom-style: solid;\n}\n","off"),
("417","xts-default_header-status","valid","off"),
("418","xts-default_header-version","8.3.8","off"),
("419","xts-default_header-site-url","652d50dbe520f689a6bb223640a2438c","off"),
("424","wd_page_css_files_theme_version","8.3.8","auto"),
("430","action_scheduler_lock_async-request-runner","6979d35559a517.54981323|1769591697","no"),
("431","woocommerce_maxmind_geolocation_settings","a:1:{s:15:\"database_prefix\";s:32:\"wsk33rqSulAhvglkif1xEuyRcHum7dBa\";}","on"),
("433","widget_woocommerce_widget_cart","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("434","widget_woocommerce_layered_nav_filters","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("435","widget_woocommerce_layered_nav","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("436","widget_woocommerce_price_filter","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("437","widget_woocommerce_product_categories","a:2:{i:2;a:8:{s:5:\"title\";s:39:\"Κατηγορίες προϊόντων\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:1;s:12:\"hierarchical\";i:0;s:18:\"show_children_only\";i:1;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","auto"),
("438","widget_woocommerce_product_search","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("439","widget_woocommerce_product_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("440","widget_woocommerce_products","a:3:{i:2;a:7:{s:5:\"title\";s:12:\"Best Selling\";s:6:\"number\";i:5;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:5:\"sales\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:1;s:11:\"show_hidden\";i:0;}i:3;a:7:{s:5:\"title\";s:36:\"Προϊόντα με Έκπτωση\";s:6:\"number\";i:5;s:4:\"show\";s:6:\"onsale\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:1;s:11:\"show_hidden\";i:0;}s:12:\"_multiwidget\";i:1;}","auto"),
("441","widget_woocommerce_recently_viewed_products","a:2:{i:2;a:2:{s:5:\"title\";s:27:\"Είδες Πρόσφατα\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","auto"),
("442","widget_woocommerce_top_rated_products","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("443","widget_woocommerce_recent_reviews","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("444","widget_woocommerce_rating_filter","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("445","widget_woodmart-user-panel","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("446","widget_woodmart-woocommerce-layered-nav","a:7:{i:2;a:12:{s:5:\"title\";s:14:\"Μέγεθος\";s:9:\"attribute\";s:4:\"size\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:2:\"or\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:5:\"round\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:3:\"off\";s:10:\"checkboxes\";s:3:\"off\";s:17:\"search_by_filters\";b:0;}i:3;a:12:{s:5:\"title\";s:10:\"Μάρκα\";s:9:\"attribute\";s:13:\"product_brand\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:2:\"or\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:5:\"round\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:3:\"off\";s:10:\"checkboxes\";s:3:\"off\";s:17:\"search_by_filters\";b:0;}i:4;a:12:{s:5:\"title\";s:10:\"Χρώμα\";s:9:\"attribute\";s:5:\"color\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:2:\"or\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:5:\"round\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:3:\"off\";s:10:\"checkboxes\";s:3:\"off\";s:17:\"search_by_filters\";b:0;}i:5;a:12:{s:5:\"title\";s:26:\"Διαθεσιμότητα\";s:9:\"attribute\";s:8:\"delivery\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:2:\"or\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:5:\"round\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:3:\"off\";s:10:\"checkboxes\";s:3:\"off\";s:17:\"search_by_filters\";b:0;}i:6;a:12:{s:5:\"title\";s:10:\"Υλικό\";s:9:\"attribute\";s:8:\"material\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:2:\"or\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:5:\"round\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:3:\"off\";s:10:\"checkboxes\";s:3:\"off\";s:17:\"search_by_filters\";b:0;}i:7;a:12:{s:5:\"title\";s:7:\"Special\";s:9:\"attribute\";s:13:\"product_brand\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:2:\"or\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:5:\"round\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:3:\"off\";s:10:\"checkboxes\";s:3:\"off\";s:17:\"search_by_filters\";b:0;}s:12:\"_multiwidget\";i:1;}","auto"),
("447","widget_woodmart-woocommerce-sort-by","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("448","widget_woodmart-price-filter","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("449","widget_woodmart-ajax-search","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("450","widget_wd-widget-stock-status","a:2:{i:2;a:4:{s:5:\"title\";s:12:\"Stock status\";s:7:\"instock\";s:1:\"1\";s:6:\"onsale\";s:1:\"1\";s:11:\"onbackorder\";b:0;}s:12:\"_multiwidget\";i:1;}","auto"),
("451","widget_wd-product-category-filter","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("452","widget_wc_brands_brand_description","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("453","widget_woocommerce_brand_nav","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("454","widget_wc_brands_brand_thumbnails","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("465","woocommerce_admin_pes_incentive_woopayments_store_had_woopayments","no","auto"),
("466","woocommerce_custom_orders_table_created","yes","auto"),
("467","woocommerce_coming_soon","yes","auto"),
("468","woocommerce_store_pages_only","no","auto"),
("469","woocommerce_email_improvements_default_enabled","yes","auto"),
("470","woocommerce_email_improvements_first_enabled_at","2026-01-26 09:11:28","auto"),
("471","woocommerce_email_improvements_last_enabled_at","2026-01-26 09:11:28","auto"),
("472","woocommerce_email_improvements_enabled_count","1","auto"),
("473","woocommerce_back_in_stock_allow_signups","yes","auto"),
("474","woocommerce_initial_installed_version","10.4.3","off"),
("475","wc_blocks_db_schema_version","260","auto"),
("476","wc_remote_inbox_notifications_stored_state","O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}","off"),
("485","woocommerce_admin_notices","a:0:{}","auto"),
("486","jetpack_options","a:1:{s:14:\"last_heartbeat\";i:1769591488;}","auto"),
("493","woocommerce_gateway_order","a:10:{s:19:\"_wc_pes_woopayments\";i:0;s:25:\"_wc_pes_paypal_full_stack\";i:1;s:33:\"_wc_offline_payment_methods_group\";i:2;s:3:\"cod\";i:3;s:4:\"bacs\";i:4;s:6:\"cheque\";i:5;s:19:\"_wc_pes_viva_wallet\";i:6;s:13:\"vivacom_smart\";i:7;s:18:\"skroutz_smart_cart\";i:8;s:14:\"oxygen_payment\";i:9;}","auto"),
("513","elementor_active_kit","13","auto"),
("514","elementor_font_display","swap","auto"),
("518","elementor_events_db_version","1.0.0","off"),
("520","jetpack_connection_active_plugins","a:1:{s:11:\"woocommerce\";a:1:{s:4:\"name\";s:11:\"WooCommerce\";}}","auto"),
("521","elementor_landing_pages_activation","0","auto"),
("522","elementor_checklist","{\"last_opened_timestamp\":1769425514,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header_pro\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":true}","auto"),
("523","elementor_version","3.34.3","auto"),
("524","elementor_install_history","a:2:{s:6:\"3.34.2\";i:1769418703;s:6:\"3.34.3\";i:1769514569;}","auto"),
("530","as_has_wp_comment_logs","no","on"),
("531","elementor_remote_info_feed_data","a:3:{i:0;a:5:{s:5:\"title\";s:79:\"Introducing Elementor 3.33: Variables Manager, Custom CSS, Blend Modes, & more!\";s:7:\"excerpt\";s:340:\"Elementor 3.33 builds on the foundation of Editor V4, continuing our mission to create a faster, more scalable, and more intuitive design experience for Web Creators. With the addition of the Variables Manager, element-level Custom CSS, Background Clipping, and Blend Modes, designers have more creative precision and consistency than ever.\";s:7:\"created\";i:1762944115;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:145:\"https://elementor.com/blog/elementor-333-v4-variables-manager-custom-css/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}","off"),
("540","_elementor_installed_time","1769419377","auto"),
("690","woocommerce_share_key","pcDqWRGWNR4fUKzCwaTtLZKId3ITXqvX","auto"),
("699","woocommerce_task_list_tracked_completed_actions","a:1:{i:0;s:3:\"tax\";}","auto"),
("700","woocommerce_task_list_tracked_completed_tasks","a:5:{i:0;s:3:\"tax\";i:1;s:8:\"shipping\";i:2;s:8:\"payments\";i:3;s:15:\"review-shipping\";i:4;s:8:\"products\";}","auto"),
("705","iben_elta_version","4.2.0","auto"),
("708","iben_elta_main_settings_fields","a:33:{s:40:\"iben_elta_main_settings_enable_test_mode\";s:1:\"1\";s:32:\"iben_elta_main_settings_customer\";s:6:\"289078\";s:32:\"iben_elta_main_settings_username\";s:7:\"0020662\";s:32:\"iben_elta_main_settings_password\";s:7:\"0020662\";s:36:\"iben_elta_main_settings_sub_password\";s:4:\"0000\";s:36:\"iben_elta_main_settings_2nd_customer\";s:0:\"\";s:36:\"iben_elta_main_settings_2nd_username\";s:0:\"\";s:36:\"iben_elta_main_settings_2nd_password\";s:0:\"\";s:40:\"iben_elta_main_settings_2nd_sub_password\";s:0:\"\";s:33:\"iben_elta_main_settings_papersize\";s:1:\"1\";s:38:\"iben_elta_main_settings_default_weight\";s:3:\"0.2\";s:41:\"iben_elta_main_settings_convert_uppercase\";s:1:\"1\";s:40:\"iben_elta_main_settings_enable_ref_order\";s:1:\"1\";s:36:\"iben_elta_button_settings_create_pdf\";s:1:\"1\";s:51:\"iben_elta_main_settings_voucher_change_order_status\";s:2:\"-1\";s:43:\"iben_elta_main_enable_tracking_saving_field\";s:0:\"\";s:46:\"iben_elta_main_settings_auto_createv_cron_time\";s:19:\"iben-elta-5-minutes\";s:47:\"iben_elta_main_settings_auto_createv_create_pdf\";s:1:\"1\";s:47:\"iben_elta_main_settings_auto_createv_admin_body\";s:122:\"<h3>Προς διαχειριστή</h3>\r\n<p>Ο αριθμός αποστολής είναι: [iben_elta_tracking_pdf]</p>\";s:39:\"iben_elta_main_settings_email_completed\";s:1:\"1\";s:55:\"iben_elta_main_settings_email_checked_default_completed\";s:1:\"0\";s:42:\"iben_elta_main_settings_email_default_body\";s:213:\"<h2>Παρακολούθηση δέματος</h2>\r\n<p>Το δέμα σας απεστάλει με τα ΕΛΤΑ κούριερ. </p>\r\n<p>Ο αριθμός αποστολής είναι: [iben_elta_tracking]</p>\";s:50:\"iben_elta_main_settings_enable_cron_check_delivery\";s:1:\"1\";s:39:\"iben_elta_main_settings_cron_check_time\";s:6:\"hourly\";s:40:\"iben_elta_main_settings_cron_query_limit\";s:2:\"20\";s:53:\"iben_elta_main_settings_admin_email_cron_notification\";s:20:\"and.adamop@gmail.com\";s:48:\"iben_elta_main_settings_cron_change_order_status\";s:10:\"wc-on-hold\";s:50:\"iben_elta_main_settings_delete_pdf_cron_check_time\";s:16:\"iben-elta-3-days\";s:45:\"iben_elta_main_settings_delete_pdf_cron_query\";s:1:\"2\";s:60:\"iben_elta_main_settings_frontend_tracking_action_link_enable\";s:1:\"1\";s:58:\"iben_elta_main_settings_frontend_tracking_action_link_text\";s:30:\"ΕΛΤΑ Ιχνηλάτηση:\";s:67:\"iben_elta_main_settings_frontend_view_order_tracking_tracing_enable\";s:1:\"1\";s:66:\"iben_elta_main_settings_frontend_view_order_tracking_tracing_title\";s:12:\"Elta Courier\";}","auto"),
("717","woocommerce_vivacom_smart_settings","a:19:{s:7:\"version\";s:5:\"1.0.2\";s:7:\"enabled\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:9:\"client_id\";s:67:\"2o8ga8wx7p0oj42wbl5yv111ap8stn7o6eutv0hh1z1t2.apps.vivapayments.com\";s:14:\"demo_client_id\";s:0:\"\";s:13:\"client_secret\";s:30:\"72upbPg3po5CTioGUE1s15DE2352CS\";s:18:\"demo_client_secret\";s:0:\"\";s:25:\"advanced_settings_enabled\";s:3:\"yes\";s:5:\"title\";s:66:\"-5% Πληρωμή Με Κάρτα/Κατάθεση ή Viva Wallet\";s:11:\"description\";s:230:\"Ολοκληρώστε την αγορά σας, πληρώνοντας με Κάρτα, GPay, Κατάθεση σε Τράπεζα ή με Viva Wallet ή PayPal αφού πατήσετε \"Αποστολή Παραγγελίας\".\";s:12:\"installments\";s:0:\"\";s:11:\"brand_color\";s:0:\"\";s:11:\"source_code\";s:7:\"WP-3854\";s:16:\"demo_source_code\";s:0:\"\";s:12:\"logo_enabled\";s:2:\"no\";s:12:\"order_status\";s:10:\"processing\";s:24:\"enable_preauthorizations\";s:2:\"no\";s:12:\"source_error\";s:12:\"code_created\";s:15:\"webhook_created\";s:3:\"yes\";}","on"),
("726","woocommerce_free_shipping_1_settings","a:4:{s:5:\"title\";s:12:\"Elta Courier\";s:8:\"requires\";s:6:\"either\";s:10:\"min_amount\";s:1:\"0\";s:16:\"ignore_discounts\";s:2:\"no\";}","on"),
("731","woocommerce_box_now_delivery_2_settings","a:13:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:54:\"Δωρεάν με Box Now Delivery άνω των 49€\";s:4:\"cost\";s:1:\"0\";s:23:\"free_delivery_threshold\";s:0:\"\";s:7:\"taxable\";s:3:\"yes\";s:13:\"custom_weight\";s:2:\"20\";s:10:\"dimensions\";s:0:\"\";s:10:\"max_length\";s:2:\"60\";s:9:\"max_width\";s:2:\"45\";s:10:\"max_height\";s:2:\"36\";s:15:\"cod_description\";s:0:\"\";s:29:\"enable_custom_cod_description\";s:3:\"yes\";s:22:\"custom_cod_description\";s:80:\"Αγόρασε τώρα, πλήρωσε κατά την παραλαβή online.\";}","on"),
("736","woocommerce_payments_provider_state_snapshots","a:1:{s:30:\"viva-com-smart-for-woocommerce\";a:5:{s:17:\"account_connected\";b:1;s:17:\"account_test_mode\";b:0;s:16:\"extension_active\";b:1;s:11:\"needs_setup\";b:0;s:9:\"test_mode\";b:1;}}","off"),
("744","woocommerce_admin_created_default_shipping_zones","yes","auto"),
("745","woocommerce_admin_reviewed_default_shipping_zones","yes","auto"),
("746","woocommerce_onboarding_profile_progress","a:1:{s:29:\"core_profiler_completed_steps\";a:2:{s:12:\"intro-opt-in\";a:1:{s:12:\"completed_at\";s:20:\"2026-01-26T10:17:38Z\";}s:17:\"skip-guided-setup\";a:1:{s:12:\"completed_at\";s:20:\"2026-01-26T10:17:46Z\";}}}","auto"),
("748","woocommerce_allow_tracking_first_optin","1769422647","auto"),
("749","woocommerce_allow_tracking_last_modified","1769422658","auto"),
("752","wc_has_tracked_default_theme","1","auto"),
("753","woocommerce_onboarding_profile","a:1:{s:7:\"skipped\";b:1;}","auto"),
("754","woocommerce_private_link","no","auto"),
("761","woocommerce_default_homepage_layout","two_columns","auto"),
("762","woocommerce_task_list_hidden_lists","a:2:{i:0;s:5:\"setup\";i:1;s:8:\"extended\";}","auto"),
("766","woocommerce_cod_settings","a:6:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:32:\"Αντικαταβολή +2.5€\";s:11:\"description\";s:68:\"Πληρωμή με μετρητά κατά την παράδοση.\";s:12:\"instructions\";s:68:\"Πληρωμή με μετρητά κατά την παράδοση.\";s:18:\"enable_for_methods\";a:1:{i:0;s:15:\"free_shipping:1\";}s:18:\"enable_for_virtual\";s:2:\"no\";}","on"),
("769","woocommerce_bacs_settings","a:11:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:46:\"Άμεση Τραπεζική Μεταφορά\";s:11:\"description\";s:420:\"Κάντε την πληρωμή σας απευθείας στον τραπεζικό μας λογαριασμό. Παρακαλούμε χρησιμοποιήστε το ID της παραγγελίας σας ως αποδεικτικό πληρωμής. Η παραγγελία σας δε θα αποσταλεί μέχρι να γίνει εκκαθάριση του ποσού στο λογαριασμό μας.\";s:12:\"instructions\";s:0:\"\";s:15:\"account_details\";s:0:\"\";s:12:\"account_name\";s:0:\"\";s:14:\"account_number\";s:0:\"\";s:9:\"sort_code\";s:0:\"\";s:9:\"bank_name\";s:0:\"\";s:4:\"iban\";s:0:\"\";s:3:\"bic\";s:0:\"\";}","on"),
("770","woocommerce_bacs_accounts","a:0:{}","auto"),
("811","woocommerce_cancelled_order_settings","a:8:{s:7:\"enabled\";s:2:\"no\";s:9:\"recipient\";s:20:\"and.adamop@gmail.com\";s:7:\"subject\";s:0:\"\";s:7:\"heading\";s:0:\"\";s:18:\"additional_content\";s:56:\"Ευχαριστούμε για την ανάγνωση.\";s:10:\"email_type\";s:4:\"html\";s:2:\"cc\";s:0:\"\";s:3:\"bcc\";s:0:\"\";}","on"),
("815","woocommerce_failed_order_settings","a:8:{s:7:\"enabled\";s:2:\"no\";s:9:\"recipient\";s:20:\"and.adamop@gmail.com\";s:7:\"subject\";s:0:\"\";s:7:\"heading\";s:0:\"\";s:18:\"additional_content\";s:284:\"Ελπίζουμε να επιστρέψουν σύντομα! Διαβάστε περισσότερα σχετικά με την <a href=\"https://woocommerce.com/document/managing-orders/\">αντιμετώπιση προβλημάτων αποτυχημένων πληρωμών</a>.\";s:10:\"email_type\";s:4:\"html\";s:2:\"cc\";s:0:\"\";s:3:\"bcc\";s:0:\"\";}","on"),
("819","woocommerce_customer_on_hold_order_settings","a:7:{s:7:\"enabled\";s:3:\"yes\";s:7:\"subject\";s:0:\"\";s:7:\"heading\";s:0:\"\";s:18:\"additional_content\";s:190:\"Ευχαριστούμε και πάλι! Εάν χρειάζεστε βοήθεια με την παραγγελία σας, επικοινωνήστε μαζί μας στο {store_email}.\";s:10:\"email_type\";s:4:\"html\";s:2:\"cc\";s:0:\"\";s:3:\"bcc\";s:0:\"\";}","on"),
("823","woocommerce_customer_refunded_order_settings","a:9:{s:7:\"enabled\";s:2:\"no\";s:12:\"subject_full\";s:0:\"\";s:15:\"subject_partial\";s:0:\"\";s:12:\"heading_full\";s:0:\"\";s:15:\"heading_partial\";s:0:\"\";s:18:\"additional_content\";s:148:\"Εάν χρειάζεστε βοήθεια με την παραγγελία σας, επικοινωνήστε μαζί μας στο {store_email}.\";s:10:\"email_type\";s:4:\"html\";s:2:\"cc\";s:0:\"\";s:3:\"bcc\";s:0:\"\";}","on"),
("826","woocommerce_customer_new_account_settings","a:7:{s:7:\"enabled\";s:3:\"yes\";s:7:\"subject\";s:0:\"\";s:7:\"heading\";s:0:\"\";s:18:\"additional_content\";s:63:\"Ανυπομονούμε να σας δούμε σύντομα.\";s:10:\"email_type\";s:4:\"html\";s:2:\"cc\";s:0:\"\";s:3:\"bcc\";s:0:\"\";}","on"),
("837","woocommerce_customer_pos_refunded_order_settings","a:9:{s:7:\"enabled\";s:2:\"no\";s:12:\"subject_full\";s:0:\"\";s:15:\"subject_partial\";s:0:\"\";s:12:\"heading_full\";s:0:\"\";s:15:\"heading_partial\";s:0:\"\";s:18:\"additional_content\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:2:\"cc\";s:0:\"\";s:3:\"bcc\";s:0:\"\";}","on"),
("853","woocommerce_custom_orders_table_data_sync_enabled","no","on"),
("873","boxnow_api_url","api-production.boxnow.gr","auto"),
("874","boxnow_warehouse_id","2","auto"),
("875","boxnow_client_id","951dd91f-dba6-47a2-9b6d-2f74b6ced600","auto"),
("876","boxnow_partner_id","4053","auto"),
("877","boxnow_client_secret","38312d9adacf31d644ab10cf2a4ea6e77c3c22d013798478c4c8ea7646d56e81","auto"),
("878","boxnow_button_color","","auto"),
("879","boxnow_button_text","Επιλέξτε Locker","auto"),
("880","box_now_display_mode","popup","auto"),
("881","boxnow_gps_tracking","on","auto"),
("882","boxnow_voucher_option","button","auto"),
("883","boxnow_voucher_email","and.adamop@gmail.com","auto"),
("884","boxnow_allow_returns","1","auto"),
("885","boxnow_mobile_number","+306971774535","auto"),
("886","boxnow_locker_not_selected_message","Επιλέξτε Locker","auto"),
("887","boxnow_thankyou_page","0","auto"),
("916","new_admin_email","and.adamop@gmail.com","auto"),
("942","woocommerce_brand_permalink","","auto"),
("965","xts_backups_auto","a:3:{i:0;b:0;i:1769423961;a:5:{s:5:\"title\";s:12:\"Auto Backup \";s:4:\"date\";s:19:\"2026-01-26 10:39:21\";s:4:\"auto\";b:1;s:7:\"options\";a:852:{s:14:\"default_header\";s:0:\"\";s:14:\"sticky_toolbar\";b:1;s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";s:0:\"\";s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";s:0:\"\";s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";s:0:\"\";s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";s:0:\"\";s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";s:0:\"\";s:10:\"age_verify\";b:0;s:15:\"age_verify_text\";s:156:\"<h4 class=\"text-center\">Are you over 18?</h4>\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:119:\"<h4 class=\"text-center\">Access forbidden</h4>\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";s:0:\"\";s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";b:0;s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:0:\"\";s:16:\"popup-background\";a:4:{s:5:\"color\";s:7:\"#111111\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:13:\"popup_padding\";s:0:\"\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:12:\"popup_scroll\";s:4:\"1000\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";b:0;s:12:\"cookies_text\";s:116:\"We use cookies to improve your experience on our website. By browsing this website, you agree to our use of cookies.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";b:0;s:18:\"header_banner_link\";s:0:\"\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";s:0:\"\";s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:13:\"search_by_sku\";s:1:\"1\";s:28:\"search_by_product_categories\";s:1:\"0\";s:21:\"search_by_product_tag\";s:1:\"0\";s:28:\"search_by_product_attributes\";s:1:\"0\";s:24:\"search_by_product_brands\";s:1:\"0\";s:21:\"enqueue_posts_results\";b:0;s:27:\"search_posts_results_column\";s:1:\"2\";s:16:\"popular_requests\";s:0:\"\";s:15:\"search_synonyms\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:17:\"relevanssi_search\";s:1:\"0\";s:10:\"site_width\";s:10:\"full-width\";s:17:\"site_custom_width\";s:4:\"1222\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:17:\"hide_main_sidebar\";s:1:\"0\";s:24:\"hide_main_sidebar_tablet\";s:1:\"1\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:11:\"insta_token\";s:0:\"\";s:28:\"insta_delete_outdated_images\";b:1;s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:4:\"base\";s:23:\"base_hover_mobile_click\";b:0;s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:0:\"\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:0:\"\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"products_shadow\";s:0:\"\";s:23:\"stretch_product_desktop\";b:0;s:22:\"stretch_product_tablet\";b:0;s:22:\"stretch_product_mobile\";b:0;s:25:\"product_title_lines_limit\";s:4:\"none\";s:22:\"show_empty_star_rating\";b:0;s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";b:0;s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";b:0;s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:27:\"show_stock_quantity_on_grid\";b:0;s:23:\"grid_stock_progress_bar\";b:0;s:14:\"shop_countdown\";b:0;s:22:\"categories_under_title\";b:1;s:18:\"brands_under_title\";b:0;s:15:\"sku_under_title\";b:0;s:18:\"show_reviews_count\";b:0;s:17:\"categories_design\";s:7:\"default\";s:19:\"categories_rounding\";s:0:\"\";s:31:\"custom_categories_rounding_size\";s:0:\"\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_subcategories\";b:0;s:29:\"hide_categories_product_count\";b:0;s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";b:0;s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";b:0;s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"1\";s:25:\"shop_categories_ancestors\";b:0;s:25:\"show_categories_neighbors\";b:0;s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";b:0;s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:24:\"mobile_categories_layout\";s:9:\"accordion\";s:29:\"mobile_categories_menu_layout\";s:8:\"dropdown\";s:37:\"mobile_categories_drilldown_animation\";s:5:\"slide\";s:40:\"mobile_categories_submenu_opening_action\";s:10:\"only_arrow\";s:26:\"mobile_categories_position\";s:4:\"left\";s:30:\"mobile_categories_color_scheme\";s:7:\"default\";s:27:\"mobile_categories_close_btn\";b:0;s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:23:\"products_spacing_tablet\";s:0:\"\";s:23:\"products_spacing_mobile\";s:0:\"\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:3:{i:0;s:1:\"2\";i:1;s:1:\"3\";i:2;s:1:\"4\";}s:16:\"products_masonry\";b:0;s:24:\"products_different_sizes\";b:0;s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";b:1;s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";b:0;s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_columns\";s:0:\"\";s:27:\"shop_filters_columns_tablet\";s:4:\"auto\";s:27:\"shop_filters_columns_mobile\";s:4:\"auto\";s:20:\"shop_filters_spacing\";s:2:\"30\";s:27:\"shop_filters_spacing_tablet\";s:0:\"\";s:27:\"shop_filters_spacing_mobile\";s:0:\"\";s:12:\"hide_sort_by\";b:0;s:17:\"hide_price_filter\";b:0;s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";b:0;s:18:\"shop_filters_close\";b:0;s:17:\"page-title-design\";s:8:\"centered\";s:15:\"page-title-size\";s:7:\"default\";s:16:\"title-background\";a:3:{s:5:\"color\";s:7:\"#0a0a0a\";s:8:\"position\";s:13:\"center center\";s:4:\"size\";s:5:\"cover\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";b:0;s:23:\"yoast_pages_breadcrumbs\";b:0;s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:7:\"widgets\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:0:\"\";s:13:\"footer-bar-bg\";a:1:{s:5:\"color\";s:7:\"#ffffff\";}s:12:\"footer-style\";s:0:\"\";s:13:\"sticky_footer\";b:0;s:23:\"collapse_footer_widgets\";b:1;s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"1\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:243:\"Based on <a href=\"http://woodmart.xtemos.com\"><strong>WoodMart</strong></a> theme<i class=\"fa fa-copyright\"></i> 2026 <a href=\"https://themeforest.net/item/woodmart-woocommerce-wordpress-theme/20264492\"><strong>WooCommerce Themes</strong></a>.\";s:11:\"copyrights2\";s:105:\"<img src=\"https://staging.promarketing.gr/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:4:{s:11:\"font-family\";s:4:\"Lato\";s:5:\"color\";s:7:\"#767676\";s:9:\"font-size\";s:2:\"14\";s:11:\"font-weight\";s:3:\"400\";}}s:12:\"primary-font\";a:1:{i:0;a:3:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-weight\";s:3:\"600\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:4:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-weight\";s:3:\"500\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:2:{s:11:\"font-family\";s:4:\"Lato\";s:11:\"font-weight\";s:3:\"400\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:5:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-weight\";s:3:\"600\";s:9:\"font-size\";s:2:\"16\";s:5:\"color\";s:4:\"#333\";s:14:\"text-transform\";s:9:\"uppercase\";}}s:15:\"navigation-font\";a:1:{i:0;a:4:{s:11:\"font-family\";s:4:\"Lato\";s:11:\"font-weight\";s:3:\"700\";s:9:\"font-size\";s:2:\"13\";s:14:\"text-transform\";s:9:\"uppercase\";}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";s:0:\"\";s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";s:0:\"\";s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"1\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:4:\"none\";s:20:\"custom_rounding_size\";s:0:\"\";s:12:\"dark_version\";b:0;s:27:\"accessibility_outline_style\";s:6:\"dotted\";s:27:\"accessibility_outline_width\";s:0:\"\";s:27:\"accessibility_outline_color\";a:0:{}s:13:\"primary-color\";a:1:{s:4:\"idle\";s:7:\"#83b735\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:7:\"#fbbc34\";}s:25:\"android_browser_bar_color\";a:0:{}s:15:\"body-background\";a:0:{}s:16:\"pages-background\";a:0:{}s:15:\"shop-background\";a:0:{}s:18:\"product-background\";a:0:{}s:15:\"blog-background\";a:0:{}s:20:\"blog-post-background\";a:0:{}s:20:\"portfolio-background\";a:0:{}s:28:\"portfolio-project-background\";a:0:{}s:18:\"btns_default_style\";s:4:\"flat\";s:23:\"btns_default_typography\";a:1:{i:0;a:4:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:7:\"#f7f7f7\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#efefef\";}s:25:\"btns_default_color_scheme\";s:4:\"dark\";s:31:\"btns_default_color_scheme_hover\";s:4:\"dark\";s:32:\"btns_default_color_scheme_custom\";a:0:{}s:38:\"btns_default_color_scheme_hover_custom\";a:0:{}s:15:\"btns_shop_style\";s:2:\"3d\";s:20:\"btns_shop_typography\";a:1:{i:0;a:4:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:7:\"#83b735\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#74a32f\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:0:{}s:35:\"btns_shop_color_scheme_hover_custom\";a:0:{}s:26:\"advanced_typography_button\";a:1:{i:0;a:10:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:14:\"text-transform\";s:0:\"\";s:7:\"padding\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}}}s:17:\"form_fields_style\";s:6:\"square\";s:17:\"form_border_width\";s:1:\"2\";s:10:\"form_color\";a:0:{}s:22:\"form_placeholder_color\";a:0:{}s:14:\"form_brd_color\";a:0:{}s:20:\"form_brd_color_focus\";a:0:{}s:7:\"form_bg\";a:0:{}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:7:\"#242424\";}s:20:\"link_underline_style\";s:0:\"\";s:26:\"link_hover_underline_style\";s:0:\"\";s:20:\"link_underline_color\";a:0:{}s:26:\"link_underline_hover_color\";a:0:{}s:24:\"carousel_arrows_position\";s:3:\"sep\";s:25:\"carousel_arrows_icon_type\";s:1:\"1\";s:27:\"carousel_arrows_hover_style\";s:1:\"1\";s:24:\"carousel_arrows_sep_size\";s:0:\"\";s:29:\"carousel_arrows_sep_icon_size\";s:0:\"\";s:28:\"carousel_arrows_sep_offset_h\";s:0:\"\";s:28:\"carousel_arrows_sep_offset_v\";s:0:\"\";s:25:\"carousel_arrows_sep_color\";a:0:{}s:31:\"carousel_arrows_sep_color_hover\";a:0:{}s:29:\"carousel_arrows_sep_color_dis\";a:0:{}s:28:\"carousel_arrows_sep_bg_color\";a:0:{}s:34:\"carousel_arrows_sep_bg_color_hover\";a:0:{}s:32:\"carousel_arrows_sep_bg_color_dis\";a:0:{}s:33:\"carousel_arrows_sep_border_radius\";s:0:\"\";s:32:\"carousel_arrows_sep_border_style\";s:0:\"\";s:32:\"carousel_arrows_sep_border_width\";s:0:\"\";s:32:\"carousel_arrows_sep_border_color\";a:0:{}s:38:\"carousel_arrows_sep_border_color_hover\";a:0:{}s:36:\"carousel_arrows_sep_border_color_dis\";a:0:{}s:36:\"carousel_arrows_sep_box_shadow_color\";a:0:{}s:39:\"carousel_arrows_sep_box_shadow_offset_x\";s:0:\"\";s:39:\"carousel_arrows_sep_box_shadow_offset_y\";s:0:\"\";s:35:\"carousel_arrows_sep_box_shadow_blur\";s:0:\"\";s:37:\"carousel_arrows_sep_box_shadow_spread\";s:0:\"\";s:28:\"carousel_arrows_together_gap\";s:0:\"\";s:29:\"carousel_arrows_together_size\";s:0:\"\";s:34:\"carousel_arrows_together_icon_size\";s:0:\"\";s:33:\"carousel_arrows_together_offset_h\";s:0:\"\";s:33:\"carousel_arrows_together_offset_v\";s:0:\"\";s:30:\"carousel_arrows_together_color\";a:0:{}s:36:\"carousel_arrows_together_color_hover\";a:0:{}s:34:\"carousel_arrows_together_color_dis\";a:0:{}s:33:\"carousel_arrows_together_bg_color\";a:0:{}s:39:\"carousel_arrows_together_bg_color_hover\";a:0:{}s:37:\"carousel_arrows_together_bg_color_dis\";a:0:{}s:38:\"carousel_arrows_together_border_radius\";s:0:\"\";s:37:\"carousel_arrows_together_border_style\";s:0:\"\";s:37:\"carousel_arrows_together_border_width\";s:0:\"\";s:37:\"carousel_arrows_together_border_color\";a:0:{}s:43:\"carousel_arrows_together_border_color_hover\";a:0:{}s:41:\"carousel_arrows_together_border_color_dis\";a:0:{}s:41:\"carousel_arrows_together_box_shadow_color\";a:0:{}s:44:\"carousel_arrows_together_box_shadow_offset_x\";s:0:\"\";s:44:\"carousel_arrows_together_box_shadow_offset_y\";s:0:\"\";s:40:\"carousel_arrows_together_box_shadow_blur\";s:0:\"\";s:42:\"carousel_arrows_together_box_shadow_spread\";s:0:\"\";s:19:\"carousel_pagin_size\";s:0:\"\";s:23:\"carousel_pagin_bg_color\";a:0:{}s:29:\"carousel_pagin_bg_color_hover\";a:0:{}s:30:\"carousel_pagin_bg_color_active\";a:0:{}s:28:\"carousel_pagin_border_radius\";s:0:\"\";s:27:\"carousel_pagin_border_style\";s:0:\"\";s:27:\"carousel_pagin_border_width\";s:0:\"\";s:27:\"carousel_pagin_border_color\";a:0:{}s:33:\"carousel_pagin_border_color_hover\";a:0:{}s:34:\"carousel_pagin_border_color_active\";a:0:{}s:25:\"carousel_scrollbar_height\";s:0:\"\";s:24:\"carousel_scrollbar_width\";s:0:\"\";s:27:\"carousel_scrollbar_bg_color\";a:0:{}s:32:\"carousel_scrollbar_drag_bg_color\";a:0:{}s:38:\"carousel_scrollbar_drag_bg_hover_color\";a:0:{}s:11:\"blog_design\";s:7:\"masonry\";s:15:\"blog_image_size\";s:5:\"large\";s:23:\"blog_image_custom_width\";s:0:\"\";s:24:\"blog_image_custom_height\";s:0:\"\";s:12:\"blog_masonry\";b:0;s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";b:1;s:12:\"blog_columns\";s:1:\"2\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:19:\"blog_spacing_tablet\";s:0:\"\";s:19:\"blog_spacing_mobile\";s:0:\"\";s:15:\"blog_pagination\";s:10:\"pagination\";s:19:\"blog_archive_layout\";s:13:\"sidebar-right\";s:26:\"blog_archive_sidebar_width\";s:1:\"3\";s:25:\"blog_archive_hide_sidebar\";s:1:\"0\";s:32:\"blog_archive_hide_sidebar_tablet\";s:1:\"1\";s:32:\"blog_archive_hide_sidebar_mobile\";s:1:\"1\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"135\";s:11:\"parts_title\";s:1:\"1\";s:10:\"parts_meta\";s:1:\"1\";s:10:\"parts_text\";s:1:\"1\";s:9:\"parts_btn\";s:1:\"1\";s:20:\"parts_published_date\";s:1:\"1\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:17:\"blog_hide_sidebar\";s:1:\"0\";s:24:\"blog_hide_sidebar_tablet\";s:1:\"1\";s:24:\"blog_hide_sidebar_mobile\";s:1:\"1\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:19:\"blog_published_date\";s:1:\"1\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:29:\"single_post_builder_post_data\";s:0:\"\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";b:0;s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:24:\"portfolio_spacing_tablet\";s:0:\"\";s:24:\"portfolio_spacing_mobile\";s:0:\"\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:24:\"portfolio_archive_layout\";s:13:\"sidebar-right\";s:31:\"portfolio_archive_sidebar_width\";s:1:\"3\";s:30:\"portfolio_archive_hide_sidebar\";s:1:\"0\";s:37:\"portfolio_archive_hide_sidebar_tablet\";s:1:\"1\";s:37:\"portfolio_archive_hide_sidebar_mobile\";s:1:\"1\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:28:\"portoflio_image_custom_width\";s:0:\"\";s:29:\"portoflio_image_custom_height\";s:0:\"\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";b:0;s:23:\"single_portfolio_layout\";s:13:\"sidebar-right\";s:30:\"single_portfolio_sidebar_width\";s:1:\"3\";s:29:\"single_portfolio_hide_sidebar\";s:1:\"0\";s:36:\"single_portfolio_hide_sidebar_tablet\";s:1:\"1\";s:36:\"single_portfolio_hide_sidebar_mobile\";s:1:\"1\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:32:\"single_project_builder_post_data\";s:0:\"\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";b:0;s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";b:0;s:16:\"show_sku_in_cart\";b:0;s:25:\"show_sku_in_checkout_page\";b:0;s:26:\"show_sku_in_thank_you_page\";b:0;s:23:\"show_sku_in_email_order\";b:0;s:16:\"show_sku_on_ajax\";b:0;s:12:\"catalog_mode\";b:0;s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";b:0;s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:0:\"\";s:14:\"swatches_limit\";b:0;s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";b:0;s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";b:0;s:20:\"swatches_labels_name\";b:0;s:27:\"swatches_scroll_top_desktop\";b:0;s:26:\"swatches_scroll_top_mobile\";b:0;s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"new\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:29:\"show_filtered_variation_image\";b:0;s:17:\"hide_larger_price\";b:0;s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:7:\"rounded\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:0:{}s:21:\"sale_label_text_color\";a:0:{}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:0:{}s:20:\"new_label_text_color\";a:0:{}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:0:{}s:20:\"hot_label_text_color\";a:0:{}s:20:\"stock_label_bg_color\";a:0:{}s:22:\"stock_label_text_color\";a:0:{}s:24:\"attribute_label_bg_color\";a:0:{}s:26:\"attribute_label_text_color\";a:0:{}s:16:\"brands_attribute\";s:0:\"\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:18:\"brand_tab_priority\";s:0:\"\";s:14:\"brand_tab_name\";b:0;s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:3:\"265\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:146:\"No products added in the compare list. You must add some products to compare them. You will find a lot of interesting products on our \"Shop\" page.\";s:15:\"compare_on_grid\";s:1:\"1\";s:25:\"compare_save_button_state\";s:1:\"0\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:18:\"cart_totals_layout\";s:8:\"layout-1\";s:27:\"update_cart_quantity_change\";b:0;s:15:\"empty_cart_text\";s:140:\"Before proceed to checkout you must add some products to your shopping cart. You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";b:0;s:20:\"single_sidebar_width\";s:1:\"3\";s:27:\"single_product_hide_sidebar\";s:1:\"0\";s:34:\"single_product_hide_sidebar_tablet\";s:1:\"1\";s:34:\"single_product_hide_sidebar_mobile\";s:1:\"1\";s:20:\"single_product_style\";s:1:\"2\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";b:0;s:22:\"product_summary_shadow\";b:0;s:17:\"single_full_width\";b:0;s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:12:\"image_action\";s:4:\"zoom\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";b:0;s:23:\"pagination_main_gallery\";b:0;s:23:\"product_images_captions\";b:0;s:14:\"thums_position\";s:4:\"left\";s:31:\"single_product_grid_columns_gap\";s:0:\"\";s:34:\"single_product_grid_column_desktop\";s:0:\"\";s:33:\"single_product_grid_column_tablet\";s:0:\"\";s:33:\"single_product_grid_column_mobile\";s:0:\"\";s:37:\"single_product_gallery_column_desktop\";s:1:\"1\";s:36:\"single_product_gallery_column_tablet\";s:0:\"\";s:36:\"single_product_gallery_column_mobile\";s:0:\"\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:22:\"main_gallery_on_tablet\";b:1;s:22:\"main_gallery_on_mobile\";b:1;s:24:\"main_gallery_center_mode\";b:0;s:48:\"single_product_thumbnails_wrap_in_mobile_devices\";b:1;s:39:\"single_product_thumbnails_gallery_width\";s:0:\"\";s:40:\"single_product_thumbnails_gallery_height\";s:0:\"\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";b:0;s:32:\"mobile_single_sticky_add_to_cart\";b:0;s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";b:0;s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";b:0;s:17:\"product_countdown\";b:0;s:23:\"sale_countdown_variable\";b:0;s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:18:\"show_product_brand\";s:1:\"0\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:30:\"related_product_columns_tablet\";s:4:\"auto\";s:30:\"related_product_columns_mobile\";s:4:\"auto\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:22:\"enable_description_tab\";s:1:\"1\";s:24:\"description_tab_priority\";s:0:\"\";s:26:\"enable_additional_info_tab\";s:1:\"1\";s:28:\"additional_info_tab_priority\";s:0:\"\";s:18:\"enable_reviews_tab\";s:1:\"1\";s:20:\"reviews_tab_priority\";s:0:\"\";s:27:\"legacy_product_tabs_enabled\";s:1:\"1\";s:20:\"additional_tab_title\";s:19:\"Shipping & Delivery\";s:23:\"additional_tab_priority\";s:0:\"\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:25:\"additional_tab_2_priority\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:25:\"additional_tab_3_priority\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:8:\"Register\";s:8:\"reg_text\";s:258:\"Registering for this site allows you to access your order status and history. Just fill in the fields below, and we\'ll get a new account set up for you in no time. We will only ask you for information necessary to make the purchase process faster and easier.\";s:11:\"login_title\";s:5:\"Login\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:0:\"\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";b:0;s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:12:\"bluesky_link\";s:0:\"\";s:14:\"isntagram_link\";s:1:\"#\";s:12:\"threads_link\";s:0:\"\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:10:\"viber_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:12:\"discord_link\";s:0:\"\";s:9:\"yelp_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:18:\"social_email_links\";b:0;s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:14:\"share_whatsapp\";b:0;s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";b:0;s:8:\"share_vk\";b:0;s:8:\"share_ok\";b:0;s:11:\"share_email\";b:0;s:19:\"mobile_optimization\";b:0;s:16:\"load_text_domain\";b:0;s:21:\"disable_gutenberg_css\";b:0;s:19:\"inline_critical_css\";b:0;s:19:\"advanced_css_notice\";s:0:\"\";s:17:\"styles_always_use\";a:0:{}s:14:\"styles_not_use\";a:0:{}s:26:\"disable_owl_mobile_devices\";b:0;s:21:\"remove_jquery_migrate\";b:0;s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";b:0;s:20:\"autocomplete_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:7:\"not_use\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:17:\"wd_swiper_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";a:0:{}s:15:\"scripts_not_use\";a:0:{}s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";b:0;s:22:\"lazy_loading_bg_images\";b:0;s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"none\";s:23:\"lazy_custom_placeholder\";s:0:\"\";s:30:\"disable_wordpress_lazy_loading\";b:0;s:26:\"rocket_delay_js_exclusions\";b:0;s:6:\"cf7_js\";b:1;s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";b:0;s:9:\"preloader\";b:0;s:15:\"preloader_image\";s:0:\"\";s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:17:\"preload_lcp_image\";b:0;s:15:\"current_builder\";s:8:\"external\";s:16:\"gutenberg_blocks\";b:0;s:29:\"enable_gutenberg_for_products\";b:0;s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"0\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:24:\"auto_update_translations\";s:1:\"0\";s:16:\"maintenance_mode\";b:0;s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";b:0;s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";s:0:\"\";s:26:\"white_label_dashboard_logo\";s:0:\"\";s:33:\"white_label_appearance_screenshot\";s:0:\"\";s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:3:\"267\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:112:\"You don\'t have any products in the wishlist yet. You will find a lot of interesting products on our \"Shop\" page.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:27:\"checkout_show_product_image\";b:0;s:25:\"checkout_product_quantity\";b:0;s:22:\"checkout_remove_button\";b:0;s:24:\"checkout_link_to_product\";b:0;s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:21:\"reviews_form_location\";s:5:\"after\";s:13:\"reviews_style\";s:7:\"style-1\";s:15:\"reviews_columns\";s:1:\"1\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:24:\"reviews_enable_pros_cons\";b:0;s:20:\"reviews_enable_likes\";b:0;s:32:\"show_reviews_purchased_indicator\";b:0;s:15:\"reviews_sorting\";b:0;s:29:\"single_product_comment_images\";b:0;s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";b:0;s:22:\"reviews_rating_summary\";b:0;s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";b:0;s:26:\"reviews_rating_by_criteria\";b:0;s:32:\"reviews_criteria_rating_required\";b:0;s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";b:1;s:23:\"checkout_fields_enabled\";b:0;s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:3:\"100\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"0\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:53:\"<p>Add [remainder] to cart and get free shipping!</p>\";s:37:\"shipping_progress_bar_message_success\";s:46:\"<p>Your order qualifies for free shipping!</p>\";s:15:\"buy_now_enabled\";b:0;s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"0\";s:27:\"counter_visitor_data_source\";s:9:\"live_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:17:\"linked_variations\";b:1;s:21:\"show_single_variation\";b:0;s:21:\"hide_variation_parent\";b:0;s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:0:\"\";s:20:\"sold_counter_enabled\";b:0;s:23:\"sold_counter_sales_type\";s:9:\"real_data\";s:24:\"sold_counter_shown_after\";s:1:\"0\";s:22:\"sold_counter_min_count\";s:2:\"10\";s:22:\"sold_counter_max_count\";s:2:\"20\";s:31:\"sold_counter_hide_on_outofstock\";b:0;s:22:\"sold_counter_timeframe\";s:1:\"3\";s:29:\"sold_counter_timeframe_period\";s:7:\"minutes\";s:28:\"sold_counter_transient_hours\";s:2:\"24\";s:17:\"discounts_enabled\";s:1:\"0\";s:20:\"show_discounts_table\";s:1:\"0\";s:18:\"free_gifts_enabled\";s:1:\"0\";s:16:\"free_gifts_limit\";s:1:\"5\";s:41:\"free_gifts_allow_multiple_identical_gifts\";s:1:\"0\";s:23:\"free_gifts_price_format\";s:4:\"text\";s:17:\"free_gift_on_cart\";b:1;s:25:\"free_gifts_table_location\";s:28:\"woocommerce_after_cart_table\";s:21:\"free_gift_on_checkout\";b:0;s:28:\"show_out_of_stock_at_the_end\";s:1:\"0\";s:16:\"waitlist_enabled\";s:1:\"0\";s:21:\"waitlist_for_loggined\";s:1:\"0\";s:19:\"waitlist_form_state\";s:13:\"current_state\";s:25:\"waitlist_fragments_enable\";s:1:\"0\";s:22:\"waitlist_wait_interval\";s:4:\"3600\";s:32:\"waitlist_enable_privacy_checkbox\";s:1:\"1\";s:30:\"waitlist_privacy_checkbox_text\";s:60:\"I have read and accept the <strong>[privacy_policy]</strong>\";s:25:\"estimate_delivery_enabled\";b:0;s:40:\"estimate_delivery_show_on_single_product\";b:1;s:35:\"estimate_delivery_show_on_mini_cart\";b:0;s:35:\"estimate_delivery_show_on_cart_page\";b:1;s:39:\"estimate_delivery_show_on_checkout_page\";b:0;s:39:\"estimate_delivery_show_on_order_details\";b:1;s:37:\"estimate_delivery_show_on_email_order\";b:1;s:30:\"estimate_delivery_show_overall\";b:0;s:29:\"estimate_delivery_date_format\";s:7:\"default\";s:34:\"estimate_delivery_fragments_enable\";b:0;s:27:\"custom_product_tabs_enabled\";s:1:\"0\";s:21:\"cart_recovery_enabled\";b:0;s:26:\"recover_guest_cart_enabled\";b:0;s:42:\"recover_guest_cart_enable_privacy_checkbox\";b:0;s:40:\"recover_guest_cart_privacy_checkbox_text\";s:280:\"If you check this box, you are giving us permission to save some of your details into a contact list. You may receive email messages containing information of commercial or promotional nature concerning this store.\nPersonal Data collected: email address, first name and last name.\";s:24:\"abandoned_cart_timeframe\";s:1:\"2\";s:31:\"abandoned_cart_timeframe_period\";s:5:\"86400\";s:31:\"abandoned_cart_delete_timeframe\";s:2:\"30\";s:38:\"abandoned_cart_delete_timeframe_period\";s:5:\"86400\";s:29:\"abandoned_cart_coupon_enabled\";b:0;s:28:\"abandoned_cart_coupon_prefix\";s:2:\"WD\";s:28:\"abandoned_cart_coupon_amount\";s:2:\"10\";s:35:\"abandoned_cart_coupon_discount_type\";s:7:\"percent\";s:34:\"abandoned_cart_delete_used_coupons\";b:1;s:37:\"abandoned_cart_delete_expired_coupons\";b:1;s:31:\"abandoned_cart_coupon_timeframe\";s:1:\"1\";s:38:\"abandoned_cart_coupon_timeframe_period\";s:5:\"86400\";s:23:\"review_reminder_enabled\";b:0;s:33:\"review_reminder_sending_timeframe\";s:1:\"7\";s:40:\"review_reminder_sending_timeframe_period\";s:5:\"86400\";s:21:\"price_tracker_enabled\";s:1:\"0\";s:26:\"price_tracker_for_loggined\";s:1:\"0\";s:32:\"price_tracker_use_loggedin_email\";s:1:\"0\";s:27:\"price_tracker_desired_price\";s:1:\"0\";s:37:\"price_tracker_enable_privacy_checkbox\";s:1:\"1\";s:30:\"price_tracker_fragments_enable\";s:1:\"0\";s:31:\"email_marketing_consent_enabled\";s:1:\"0\";s:37:\"email_subscription_individual_control\";s:1:\"0\";}s:7:\"presets\";s:0:\"\";}i:1769514597;a:5:{s:5:\"title\";s:12:\"Auto Backup \";s:4:\"date\";s:19:\"2026-01-27 11:49:57\";s:4:\"auto\";b:1;s:7:\"options\";a:852:{s:14:\"default_header\";s:14:\"default_header\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:7:\"sidebar\";i:1;s:6:\"link_1\";i:2;s:6:\"link_2\";i:3;s:6:\"link_3\";i:4;s:6:\"link_5\";}s:10:\"link_1_url\";s:55:\"https://likeme.gr/andriki-moda/andrika-okonomika-rouxa/\";s:11:\"link_1_text\";s:3:\"Men\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:77:\"https://likeme.gr/wp-content/uploads/2025/12/menu-iaoxqnpyjdkokz13yxzrwh.webp\";s:2:\"id\";s:6:\"314208\";}s:10:\"link_2_url\";s:33:\"https://likeme.gr/ginaikeia-moda/\";s:11:\"link_2_text\";s:5:\"Women\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:77:\"https://likeme.gr/wp-content/uploads/2025/12/menu-iaoxqnpyjdkokz13yxzrwh.webp\";s:2:\"id\";s:6:\"314208\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:27:\"https://likeme.gr/checkout/\";s:11:\"link_5_text\";s:10:\"Αγορά\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:66:\"https://likeme.gr/wp-content/uploads/2025/12/shopping-bag-icon.png\";s:2:\"id\";s:6:\"310837\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"0\";s:24:\"promo_popup_content_type\";s:4:\"text\";s:10:\"popup_text\";s:119:\"Επιπλέον έκπτωση 5% για παραγγελίες άνω των 39€ σε όλα τα προϊόντα!\";s:16:\"popup_html_block\";s:0:\"\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:7:\"#111111\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:13:\"popup_padding\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"promo_popup_hide_mobile\";s:1:\"0\";s:11:\"popup_event\";s:4:\"time\";s:12:\"popup_scroll\";s:4:\"1000\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:226:\"Χρησιμοποιούμε cookies δικά μας και τρίτων για να βελτιώσουμε την εμπειρία σας &amp; να προσφέρουμε το μέγιστο των υπηρεσιών μας.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"0\";s:18:\"header_banner_link\";s:0:\"\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:337:\"<p style=\"text-align: center\"><span style=\"color: #ffffff\"><strong>ΤΗΛΕΦΩΝΙΚΕΣ ΠΑΡΑΓΓΕΛΙΕΣ: 2102156537 10:00 - 18:00 | ΔΩΡΕΑΝ ΜΕΤΑΦΟΡΙΚΑ &amp; ΔΩΡΕΑΝ ΑΛΛΑΓΗ | ΕΠΙΠΛΕΟΝ 5% ΕΚΠΤΩΣΗ ΣΕ ΟΛΑ ΤΑ ΠΡΟΪΟΝΤΑ ΓΙΑ ΑΓΟΡΕΣ ΑΝΩ ΤΩΝ 39€</strong></span></p>\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:13:\"rgb(10,10,10)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"50\";s:27:\"header_banner_mobile_height\";s:3:\"110\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:13:\"search_by_sku\";s:1:\"1\";s:28:\"search_by_product_categories\";s:1:\"0\";s:21:\"search_by_product_tag\";s:1:\"0\";s:28:\"search_by_product_attributes\";s:1:\"0\";s:24:\"search_by_product_brands\";s:1:\"0\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:16:\"popular_requests\";s:0:\"\";s:15:\"search_synonyms\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:17:\"relevanssi_search\";s:1:\"0\";s:10:\"site_width\";s:4:\"wide\";s:17:\"site_custom_width\";s:4:\"1222\";s:11:\"main_layout\";s:12:\"sidebar-left\";s:13:\"sidebar_width\";s:1:\"3\";s:17:\"hide_main_sidebar\";s:1:\"0\";s:24:\"hide_main_sidebar_tablet\";s:1:\"1\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:11:\"insta_token\";s:0:\"\";s:28:\"insta_delete_outdated_images\";s:1:\"0\";s:18:\"google_map_api_key\";s:39:\"AIzaSyDR22XuR0oOwRl-SkhRjjS13ka37YRivAg\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"0\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:5:\"after\";s:14:\"products_hover\";s:5:\"quick\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:6:\"inside\";s:24:\"products_with_background\";s:1:\"0\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"products_shadow\";s:1:\"0\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:3:\"two\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"1\";s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:27:\"show_stock_quantity_on_grid\";s:1:\"0\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"1\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"1\";s:18:\"show_reviews_count\";s:1:\"0\";s:17:\"categories_design\";s:11:\"mask-subcat\";s:19:\"categories_rounding\";s:0:\"\";s:31:\"custom_categories_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_subcategories\";s:1:\"0\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"2\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"1\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"1\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"1\";s:25:\"shop_categories_ancestors\";s:1:\"1\";s:25:\"show_categories_neighbors\";s:1:\"1\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"1\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:24:\"mobile_categories_layout\";s:9:\"accordion\";s:29:\"mobile_categories_menu_layout\";s:8:\"dropdown\";s:37:\"mobile_categories_drilldown_animation\";s:5:\"slide\";s:40:\"mobile_categories_submenu_opening_action\";s:10:\"only_arrow\";s:26:\"mobile_categories_position\";s:4:\"left\";s:30:\"mobile_categories_color_scheme\";s:7:\"default\";s:27:\"mobile_categories_close_btn\";s:1:\"0\";s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"5\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:23:\"products_spacing_tablet\";s:0:\"\";s:23:\"products_spacing_mobile\";s:0:\"\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:5:{i:0;s:1:\"2\";i:1;s:1:\"3\";i:2;s:1:\"4\";i:3;s:1:\"5\";i:4;s:1:\"6\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"72\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:7:\"72, 144\";s:15:\"shop_pagination\";s:7:\"infinit\";s:25:\"load_more_button_page_url\";s:1:\"0\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"180\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_columns\";s:0:\"\";s:27:\"shop_filters_columns_tablet\";s:4:\"auto\";s:27:\"shop_filters_columns_mobile\";s:4:\"auto\";s:20:\"shop_filters_spacing\";s:2:\"30\";s:27:\"shop_filters_spacing_tablet\";s:0:\"\";s:27:\"shop_filters_spacing_mobile\";s:0:\"\";s:12:\"hide_sort_by\";s:1:\"0\";s:17:\"hide_price_filter\";s:1:\"0\";s:20:\"shop_filters_content\";s:5:\"20465\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:17:\"page-title-design\";s:8:\"centered\";s:15:\"page-title-size\";s:5:\"small\";s:16:\"title-background\";a:7:{s:5:\"color\";s:13:\"rgb(64,64,63)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:1:\"1\";s:17:\"footer_html_block\";s:3:\"157\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:7:\"#ffffff\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:4:\"dark\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"0\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"0\";s:17:\"copyrights-layout\";s:8:\"centered\";s:10:\"copyrights\";s:0:\"\";s:11:\"copyrights2\";s:0:\"\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"1\";s:11:\"font-family\";s:6:\"Roboto\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"1\";s:11:\"font-family\";s:6:\"Roboto\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"1\";s:11:\"font-family\";s:6:\"Roboto\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"1\";s:11:\"font-family\";s:6:\"Roboto\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"1\";s:11:\"font-family\";s:6:\"Roboto\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"1\";s:11:\"font-family\";s:6:\"Roboto\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"17\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:2:{i:0;a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"1\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:1:\"0\";s:20:\"custom_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:12:\"dark_version\";s:1:\"0\";s:27:\"accessibility_outline_style\";s:0:\"\";s:27:\"accessibility_outline_width\";s:0:\"\";s:27:\"accessibility_outline_color\";a:0:{}s:13:\"primary-color\";a:1:{s:4:\"idle\";s:15:\"rgb(129,215,66)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:15:\"rgb(129,215,66)\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:4:\"flat\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:7:\"#f7f7f7\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#efefef\";}s:25:\"btns_default_color_scheme\";s:4:\"dark\";s:31:\"btns_default_color_scheme_hover\";s:4:\"dark\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:4:\"flat\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:15:\"rgb(129,215,66)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:15:\"rgb(129,215,66)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:6:\"square\";s:17:\"form_border_width\";s:1:\"2\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:0:\"\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:15:\"rgb(129,215,66)\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:15:\"rgb(129,215,66)\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:15:\"rgb(129,215,66)\";s:5:\"hover\";s:15:\"rgb(129,215,66)\";}s:20:\"link_underline_style\";s:0:\"\";s:26:\"link_hover_underline_style\";s:0:\"\";s:20:\"link_underline_color\";a:0:{}s:26:\"link_underline_hover_color\";a:0:{}s:24:\"carousel_arrows_position\";s:3:\"sep\";s:25:\"carousel_arrows_icon_type\";s:1:\"1\";s:27:\"carousel_arrows_hover_style\";s:1:\"1\";s:24:\"carousel_arrows_sep_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_sep_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:25:\"carousel_arrows_sep_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:31:\"carousel_arrows_sep_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_arrows_sep_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_arrows_sep_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_sep_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_arrows_sep_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_sep_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_style\";s:0:\"\";s:32:\"carousel_arrows_sep_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_sep_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_sep_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:39:\"carousel_arrows_sep_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:35:\"carousel_arrows_sep_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_sep_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:28:\"carousel_arrows_together_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_together_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:34:\"carousel_arrows_together_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:30:\"carousel_arrows_together_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_together_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_together_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_together_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_together_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:37:\"carousel_arrows_together_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_together_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_style\";s:0:\"\";s:37:\"carousel_arrows_together_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:43:\"carousel_arrows_together_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:44:\"carousel_arrows_together_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:44:\"carousel_arrows_together_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:40:\"carousel_arrows_together_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:42:\"carousel_arrows_together_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:19:\"carousel_pagin_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:23:\"carousel_pagin_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_pagin_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:30:\"carousel_pagin_bg_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_pagin_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_style\";s:0:\"\";s:27:\"carousel_pagin_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_pagin_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_pagin_border_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:25:\"carousel_scrollbar_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:24:\"carousel_scrollbar_width\";s:152:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJ0YWJsZXQiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJtb2JpbGUiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9fX0=\";s:27:\"carousel_scrollbar_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_scrollbar_drag_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_scrollbar_drag_bg_hover_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:11:\"blog_design\";s:7:\"masonry\";s:15:\"blog_image_size\";s:0:\"\";s:23:\"blog_image_custom_width\";s:0:\"\";s:24:\"blog_image_custom_height\";s:0:\"\";s:12:\"blog_masonry\";b:0;s:10:\"blog_style\";s:4:\"flat\";s:16:\"blog_with_shadow\";s:1:\"1\";s:12:\"blog_columns\";s:1:\"3\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:19:\"blog_spacing_tablet\";s:0:\"\";s:19:\"blog_spacing_mobile\";s:0:\"\";s:15:\"blog_pagination\";s:10:\"pagination\";s:19:\"blog_archive_layout\";s:13:\"sidebar-right\";s:26:\"blog_archive_sidebar_width\";s:1:\"3\";s:25:\"blog_archive_hide_sidebar\";s:1:\"0\";s:32:\"blog_archive_hide_sidebar_tablet\";s:1:\"1\";s:32:\"blog_archive_hide_sidebar_mobile\";s:1:\"1\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"135\";s:11:\"parts_title\";s:1:\"1\";s:10:\"parts_meta\";s:1:\"1\";s:10:\"parts_text\";s:1:\"1\";s:9:\"parts_btn\";s:1:\"1\";s:20:\"parts_published_date\";s:1:\"1\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:17:\"blog_hide_sidebar\";s:1:\"0\";s:24:\"blog_hide_sidebar_tablet\";s:1:\"1\";s:24:\"blog_hide_sidebar_mobile\";s:1:\"1\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:19:\"blog_published_date\";s:1:\"1\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:29:\"single_post_builder_post_data\";s:0:\"\";s:9:\"portfolio\";s:1:\"0\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:2:\"30\";s:24:\"portfolio_spacing_tablet\";s:0:\"\";s:24:\"portfolio_spacing_mobile\";s:0:\"\";s:18:\"portoflio_per_page\";s:2:\"12\";s:20:\"portfolio_pagination\";s:10:\"pagination\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:24:\"portfolio_archive_layout\";s:13:\"sidebar-right\";s:31:\"portfolio_archive_sidebar_width\";s:1:\"3\";s:30:\"portfolio_archive_hide_sidebar\";s:1:\"0\";s:37:\"portfolio_archive_hide_sidebar_tablet\";s:1:\"1\";s:37:\"portfolio_archive_hide_sidebar_mobile\";s:1:\"1\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:28:\"portoflio_image_custom_width\";s:0:\"\";s:29:\"portoflio_image_custom_height\";s:0:\"\";s:17:\"portoflio_filters\";s:1:\"0\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:23:\"single_portfolio_layout\";s:13:\"sidebar-right\";s:30:\"single_portfolio_sidebar_width\";s:1:\"3\";s:29:\"single_portfolio_hide_sidebar\";s:1:\"0\";s:36:\"single_portfolio_hide_sidebar_tablet\";s:1:\"1\";s:36:\"single_portfolio_hide_sidebar_mobile\";s:1:\"1\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:32:\"single_project_builder_post_data\";s:0:\"\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"1\";s:33:\"add_to_cart_action_timeout_number\";s:2:\"15\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"1\";s:16:\"show_sku_in_cart\";s:1:\"1\";s:25:\"show_sku_in_checkout_page\";s:1:\"0\";s:26:\"show_sku_in_thank_you_page\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"1\";s:16:\"show_sku_on_ajax\";s:1:\"1\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"0\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:7:\"pa_size\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"6\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"0\";s:32:\"variation_gallery_storage_method\";s:3:\"new\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:29:\"show_filtered_variation_image\";s:1:\"0\";s:17:\"hide_larger_price\";s:1:\"1\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:11:\"rectangular\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:2:\"25\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:18:\"brand_tab_priority\";s:0:\"\";s:14:\"brand_tab_name\";s:1:\"1\";s:10:\"quick_view\";s:1:\"0\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"0\";s:12:\"compare_page\";s:2:\"29\";s:14:\"fields_compare\";a:4:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:8:\"pa_brand\";i:3;s:7:\"pa_size\";}s:18:\"empty_compare_text\";s:215:\"Δεν έχετε προσθέσει ακόμα προϊόντα για σύγκριση.<br> Μπορείτε να βρείτε περισσότερα από 4000 προϊόντα στο κατάστημα μας..\";s:15:\"compare_on_grid\";s:1:\"1\";s:25:\"compare_save_button_state\";s:1:\"0\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:18:\"cart_totals_layout\";s:8:\"layout-1\";s:27:\"update_cart_quantity_change\";s:1:\"0\";s:15:\"empty_cart_text\";s:277:\"Πριν προχωρήσετε σε αγορά πρέπει να προσθέσετε μερικά προϊόντα στο καλάθι σας.<br> Θα βρείτε μεγάλη ποικιλία προϊόντων σε όλες τις κατηγορίες προϊόντων.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:27:\"single_product_hide_sidebar\";s:1:\"0\";s:34:\"single_product_hide_sidebar_tablet\";s:1:\"1\";s:34:\"single_product_hide_sidebar_mobile\";s:1:\"1\";s:20:\"single_product_style\";s:1:\"2\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:12:\"image_action\";s:4:\"zoom\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"1\";s:23:\"pagination_main_gallery\";s:1:\"1\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:4:\"left\";s:31:\"single_product_grid_columns_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:34:\"single_product_grid_column_desktop\";s:0:\"\";s:33:\"single_product_grid_column_tablet\";s:0:\"\";s:33:\"single_product_grid_column_mobile\";s:0:\"\";s:37:\"single_product_gallery_column_desktop\";s:1:\"1\";s:36:\"single_product_gallery_column_tablet\";s:0:\"\";s:36:\"single_product_gallery_column_mobile\";s:0:\"\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:22:\"main_gallery_on_tablet\";s:1:\"1\";s:22:\"main_gallery_on_mobile\";s:1:\"1\";s:24:\"main_gallery_center_mode\";s:1:\"0\";s:48:\"single_product_thumbnails_wrap_in_mobile_devices\";s:1:\"1\";s:39:\"single_product_thumbnails_gallery_width\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:40:\"single_product_thumbnails_gallery_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"400\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"1\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"1\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:10:\"html_block\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:5:\"28492\";s:30:\"after_add_to_cart_content_type\";s:10:\"html_block\";s:25:\"content_after_add_to_cart\";s:65:\"Άμεση Παραλαβή / 1-3 Εργάσιμες Ημέρες\";s:28:\"after_add_to_cart_html_block\";s:5:\"20465\";s:27:\"single_breadcrumbs_position\";s:12:\"below_header\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:18:\"show_product_brand\";s:1:\"0\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:4:\"grid\";s:23:\"related_product_columns\";s:1:\"5\";s:30:\"related_product_columns_tablet\";s:4:\"auto\";s:30:\"related_product_columns_mobile\";s:4:\"auto\";s:21:\"related_product_count\";s:2:\"10\";s:19:\"product_tabs_layout\";s:9:\"accordion\";s:21:\"product_tabs_location\";s:7:\"summary\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:22:\"enable_description_tab\";s:1:\"1\";s:24:\"description_tab_priority\";s:0:\"\";s:26:\"enable_additional_info_tab\";s:1:\"1\";s:28:\"additional_info_tab_priority\";s:0:\"\";s:18:\"enable_reviews_tab\";s:1:\"1\";s:20:\"reviews_tab_priority\";s:0:\"\";s:27:\"legacy_product_tabs_enabled\";s:1:\"1\";s:20:\"additional_tab_title\";s:35:\"Αποστολές & Αλλαγές\";s:23:\"additional_tab_priority\";s:0:\"\";s:27:\"additional_tab_content_type\";s:10:\"html_block\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:5:\"20470\";s:22:\"additional_tab_2_title\";s:0:\"\";s:25:\"additional_tab_2_priority\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:10:\"html_block\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:25:\"additional_tab_3_priority\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:14:\"Εγγραφή\";s:8:\"reg_text\";s:506:\"Κάνοντας εγγραφή στην σελίδα μας, θα έχετε πρόσβαση στις παραγγελίες σας και το ιστορικό σας. Απλά συμπληρώστε τα παρακάτω πεδία για να αποκτήσετε πρόσβαση άμεσα. Θα σας ζητήσουμε μόνο τις απαραίτητες πληροφορίες για να ολοκληρώνετε τις αγορές σας γρηγορότερα και ευκολότερα.\";s:11:\"login_title\";s:14:\"Σύνδεση\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:3469:\"/* Breadcrumb link */\r\n.woodmart-woo-breadcrumbs .woocommerce-breadcrumb .breadcrumb-link:nth-child(1){\r\n	display:none;\r\n}\r\n\r\n/* Breadcrumb link */\r\n.woodmart-woo-breadcrumbs .woocommerce-breadcrumb .breadcrumb-link:nth-child(2){\r\n	display:none;\r\n}\r\n\r\n/* Breadcrumb link */\r\n.woodmart-woo-breadcrumbs .woocommerce-breadcrumb .breadcrumb-link:nth-child(3){\r\n	display:none;\r\n}\r\n\r\n\r\n/* Paragraph */\r\n.description-area-after .term-description p{\r\n	display:none;\r\n}\r\n\r\n/* After add cart */\r\n.entry-summary .wd-after-add-to-cart{\r\n	color:#83b735;\r\n	\r\n}\r\n\r\n/* Link */\r\n.cart-widget-side li:nth-child(1) a:nth-child(2){\r\n	transform:scale(1.45);\r\n}\r\n\r\n.cart-widget-side li:nth-child(2) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(3) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(4) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(5) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(6) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(7) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(8) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(9) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(10) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(11) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(12) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n.cart-widget-side li:nth-child(13) a:nth-child(2){\r\n	transform:scale(1.45);\r\n	\r\n}\r\n\r\n/* Breadcrumb link */\r\n.single-breadcrumbs-wrapper .woocommerce-breadcrumb .breadcrumb-link:nth-child(1){\r\n	display:none;\r\n}\r\n\r\n/* Breadcrumb link */\r\n.single-breadcrumbs-wrapper .woocommerce-breadcrumb .breadcrumb-link:nth-child(2){\r\n	display:none;\r\n}\r\n\r\n/* Breadcrumb link */\r\n.single-breadcrumbs-wrapper .woocommerce-breadcrumb .breadcrumb-link:nth-child(3){\r\n	display:none;\r\n}\r\n\r\n/* Woodmart back */\r\n.single-breadcrumbs-wrapper .woodmart-products-nav .woodmart-back-btn{\r\n	display:none;\r\n}\r\n\r\n/* Prev */\r\n.woodmart-products-nav div .wd-btn-prev{\r\n	transform:scale(1.4) translatex(-5px);\r\n}\r\n\r\n/* Next */\r\n.woodmart-products-nav div .wd-btn-next{\r\n	transform:scale(1.4);\r\n}\r\n\r\n/* Tab title seller */\r\n.woocommerce-tabs .wd-accordion-item .tab-title-seller{\r\n	display:none;\r\n	\r\n}\r\n\r\n/* 1025px and larger screen sizes */\r\n@media (min-width:1025px){\r\n\r\n	/* Breadcrumb last */\r\n	.single-breadcrumbs-wrapper .woocommerce-breadcrumb .breadcrumb-last{\r\n		display:none;\r\n	}\r\n	\r\n}\r\n\r\n\r\n/* 1024px and smaller screen sizes */\r\n@media (max-width:1024px){\r\n\r\n	/* Category nav link */\r\n	.woodmart-product-categories .shop-all-link .category-nav-link{\r\n		display:none;\r\n		\r\n	}\r\n	\r\n}\r\n\r\n/* Link */\r\n.wd-products-holder .woodmart-product-cats a{\r\n	color:#76C43C;\r\n	font-size:14px;\r\n	font-weight:600;\r\n}\r\n\r\n/* Show Current Cat Open on Mobile Nav */\r\n\r\n.wd-nav-mobile .current-menu-ancestor>ul,.wd-nav-mobile .current-menu-parent>ul {\r\n\r\n    display: block;\r\n\r\n}\r\n\r\n.wd-nav-mobile .current-menu-ancestor>.wd-nav-opener,.wd-nav-mobile .current-menu-parent>.wd-nav-opener{\r\n\r\n    background-color: var(--wd-primary-color);\r\n\r\n    color: var(--nav-opener-color-active);\r\n\r\n}\r\n\r\n.wd-nav-mobile .current-menu-ancestor>.wd-nav-opener:after,.wd-nav-mobile .current-menu-parent>.wd-nav-opener:after{\r\n\r\n    transform: rotate(90deg);\r\n	\r\n\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:35:\"https://www.facebook.com/LikeMe.gr/\";s:12:\"twitter_link\";s:0:\"\";s:12:\"bluesky_link\";s:0:\"\";s:14:\"isntagram_link\";s:36:\"https://www.instagram.com/likeme.gr/\";s:12:\"threads_link\";s:0:\"\";s:14:\"pinterest_link\";s:0:\"\";s:12:\"youtube_link\";s:0:\"\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:10:\"viber_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:12:\"discord_link\";s:0:\"\";s:9:\"yelp_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"0\";s:14:\"share_linkedin\";s:1:\"0\";s:14:\"share_whatsapp\";s:1:\"1\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:1:\"1\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_ok\";s:1:\"0\";s:11:\"share_email\";s:1:\"1\";s:19:\"mobile_optimization\";s:1:\"0\";s:16:\"load_text_domain\";s:1:\"1\";s:21:\"disable_gutenberg_css\";s:1:\"1\";s:19:\"inline_critical_css\";b:0;s:19:\"advanced_css_notice\";s:0:\"\";s:17:\"styles_always_use\";a:3:{i:0;s:18:\"product-loop-quick\";i:1;s:23:\"woo-mod-add-btn-replace\";i:2;s:12:\"product-loop\";}s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"1\";s:21:\"remove_jquery_migrate\";s:1:\"1\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:17:\"wd_swiper_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:22:\"lazy_loading_bg_images\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:4:\"1000\";s:11:\"lazy_effect\";s:4:\"fade\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"0\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:17:\"preload_lcp_image\";b:0;s:15:\"current_builder\";s:8:\"external\";s:16:\"gutenberg_blocks\";s:1:\"0\";s:29:\"enable_gutenberg_for_products\";s:1:\"0\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"0\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"0\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"0\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:24:\"auto_update_translations\";s:1:\"0\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"1\";s:22:\"white_label_theme_name\";s:12:\"ProMarketing\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:9:\"LikeMe.gr\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:3:\"178\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:181:\"Δεν έχετε αγαπημένα προϊόντα ακόμα.  <br> Θα βρείτε μεγάλη ποικιλία προϊόντων σε όλες τις κατηγορίες.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"1\";s:27:\"checkout_show_product_image\";s:1:\"1\";s:25:\"checkout_product_quantity\";s:1:\"1\";s:22:\"checkout_remove_button\";s:1:\"1\";s:24:\"checkout_link_to_product\";s:1:\"1\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:21:\"reviews_form_location\";s:5:\"after\";s:13:\"reviews_style\";s:7:\"style-1\";s:15:\"reviews_columns\";s:1:\"1\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:24:\"reviews_enable_pros_cons\";s:1:\"0\";s:20:\"reviews_enable_likes\";s:1:\"1\";s:32:\"show_reviews_purchased_indicator\";s:1:\"0\";s:15:\"reviews_sorting\";s:1:\"0\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"0\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"0\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:23:\"checkout_fields_enabled\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:2:\"49\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"include\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"1\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"1\";s:37:\"shipping_progress_bar_message_initial\";s:78:\"Με [remainder] ακόμα θα έχεις δωρεάν μεταφορικά!\";s:37:\"shipping_progress_bar_message_success\";s:87:\"Ο στόχος επιτεύχθη! Κέρδισες δωρεάν μεταφορικά!\";s:15:\"buy_now_enabled\";s:1:\"0\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"1\";s:27:\"counter_visitor_data_source\";s:9:\"fake_data\";s:38:\"counter_visitor_data_source_min_number\";s:1:\"2\";s:38:\"counter_visitor_data_source_max_number\";s:1:\"6\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"1\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:17:\"linked_variations\";s:1:\"0\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:20:\"sold_counter_enabled\";s:1:\"0\";s:23:\"sold_counter_sales_type\";s:9:\"real_data\";s:24:\"sold_counter_shown_after\";s:1:\"0\";s:22:\"sold_counter_min_count\";s:2:\"10\";s:22:\"sold_counter_max_count\";s:2:\"20\";s:31:\"sold_counter_hide_on_outofstock\";s:1:\"0\";s:22:\"sold_counter_timeframe\";s:1:\"3\";s:29:\"sold_counter_timeframe_period\";s:7:\"minutes\";s:28:\"sold_counter_transient_hours\";s:2:\"24\";s:17:\"discounts_enabled\";s:1:\"1\";s:20:\"show_discounts_table\";s:1:\"1\";s:18:\"free_gifts_enabled\";s:1:\"0\";s:16:\"free_gifts_limit\";s:1:\"5\";s:41:\"free_gifts_allow_multiple_identical_gifts\";s:1:\"0\";s:23:\"free_gifts_price_format\";s:4:\"text\";s:17:\"free_gift_on_cart\";s:1:\"1\";s:25:\"free_gifts_table_location\";s:28:\"woocommerce_after_cart_table\";s:21:\"free_gift_on_checkout\";s:1:\"0\";s:28:\"show_out_of_stock_at_the_end\";s:1:\"0\";s:16:\"waitlist_enabled\";s:1:\"0\";s:21:\"waitlist_for_loggined\";s:1:\"0\";s:19:\"waitlist_form_state\";s:13:\"current_state\";s:25:\"waitlist_fragments_enable\";s:1:\"0\";s:22:\"waitlist_wait_interval\";s:4:\"3600\";s:32:\"waitlist_enable_privacy_checkbox\";s:1:\"1\";s:30:\"waitlist_privacy_checkbox_text\";s:60:\"I have read and accept the <strong>[privacy_policy]</strong>\";s:25:\"estimate_delivery_enabled\";s:1:\"0\";s:40:\"estimate_delivery_show_on_single_product\";s:1:\"1\";s:35:\"estimate_delivery_show_on_mini_cart\";s:1:\"0\";s:35:\"estimate_delivery_show_on_cart_page\";s:1:\"1\";s:39:\"estimate_delivery_show_on_checkout_page\";s:1:\"1\";s:39:\"estimate_delivery_show_on_order_details\";s:1:\"1\";s:37:\"estimate_delivery_show_on_email_order\";s:1:\"1\";s:30:\"estimate_delivery_show_overall\";s:1:\"0\";s:29:\"estimate_delivery_date_format\";s:7:\"default\";s:34:\"estimate_delivery_fragments_enable\";s:1:\"0\";s:27:\"custom_product_tabs_enabled\";s:1:\"0\";s:21:\"cart_recovery_enabled\";s:1:\"0\";s:26:\"recover_guest_cart_enabled\";s:1:\"0\";s:42:\"recover_guest_cart_enable_privacy_checkbox\";s:1:\"0\";s:40:\"recover_guest_cart_privacy_checkbox_text\";s:281:\"If you check this box, you are giving us permission to save some of your details into a contact list. You may receive email messages containing information of commercial or promotional nature concerning this store.\r\nPersonal Data collected: email address, first name and last name.\";s:24:\"abandoned_cart_timeframe\";s:1:\"2\";s:31:\"abandoned_cart_timeframe_period\";s:5:\"86400\";s:31:\"abandoned_cart_delete_timeframe\";s:2:\"30\";s:38:\"abandoned_cart_delete_timeframe_period\";s:5:\"86400\";s:29:\"abandoned_cart_coupon_enabled\";s:1:\"0\";s:28:\"abandoned_cart_coupon_prefix\";s:2:\"WD\";s:28:\"abandoned_cart_coupon_amount\";s:2:\"10\";s:35:\"abandoned_cart_coupon_discount_type\";s:7:\"percent\";s:34:\"abandoned_cart_delete_used_coupons\";s:1:\"1\";s:37:\"abandoned_cart_delete_expired_coupons\";s:1:\"1\";s:31:\"abandoned_cart_coupon_timeframe\";s:1:\"1\";s:38:\"abandoned_cart_coupon_timeframe_period\";s:5:\"86400\";s:23:\"review_reminder_enabled\";s:1:\"1\";s:33:\"review_reminder_sending_timeframe\";s:1:\"7\";s:40:\"review_reminder_sending_timeframe_period\";s:0:\"\";s:21:\"price_tracker_enabled\";s:1:\"0\";s:26:\"price_tracker_for_loggined\";s:1:\"0\";s:32:\"price_tracker_use_loggedin_email\";s:1:\"0\";s:27:\"price_tracker_desired_price\";s:1:\"0\";s:37:\"price_tracker_enable_privacy_checkbox\";s:1:\"1\";s:30:\"price_tracker_fragments_enable\";s:1:\"0\";s:31:\"email_marketing_consent_enabled\";s:1:\"0\";s:37:\"email_subscription_individual_control\";s:1:\"0\";}s:7:\"presets\";s:0:\"\";}}","off");

INSERT IGNORE INTO `wpby_options` VALUES 
("967","xts_successfully_installed_patches","a:1:{s:5:\"8.3.8\";a:4:{i:701388;b:1;i:701515;b:1;i:701517;b:1;i:701557;b:1;}}","off"),
("990","whb_main_header","default_header","auto"),
("1075","elementor_pro_license_key","ep-**********","auto"),
("1076","_elementor_pro_license_v2_data","a:2:{s:7:\"timeout\";i:1769645576;s:5:\"value\";s:71:\"{\"success\":true,\"license\":\"valid\",\"expires\":\"01.01.2030\",\"features\":[]}\";}","auto"),
("1078","elementor_pro_version","3.33.2","auto"),
("1079","elementor_pro_install_history","a:1:{s:6:\"3.33.2\";i:1769425284;}","auto"),
("1080","widget_elementor-library","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("1082","_elementor_pro_installed_time","1769425285","auto"),
("1083","elementor_submissions_db_version","5","auto"),
("1102","_elementor_settings_update_time","1769503001","auto"),
("1103","elementor_cpt_support","a:2:{i:0;s:4:\"page\";i:1;s:9:\"cms_block\";}","auto"),
("1104","elementor_disable_color_schemes","yes","auto"),
("1105","elementor_disable_typography_schemes","yes","auto"),
("1106","elementor_allow_tracking_last_update","1769503001","auto"),
("1107","elementor_allow_tracking","no","auto"),
("1108","elementor_google_maps_api_key","","auto"),
("1109","elementor_pro_recaptcha_site_key","","auto"),
("1110","elementor_pro_recaptcha_secret_key","","auto"),
("1111","elementor_pro_recaptcha_v3_site_key","","auto"),
("1112","elementor_pro_recaptcha_v3_secret_key","","auto"),
("1113","elementor_pro_recaptcha_v3_threshold","0.5","auto"),
("1114","elementor_pro_facebook_app_id","","auto"),
("1115","elementor_pro_mailchimp_api_key","","auto"),
("1116","elementor_validate_api_data","","auto"),
("1117","elementor_pro_drip_api_token","","auto"),
("1118","elementor_pro_activecampaign_api_key","","auto"),
("1119","elementor_pro_activecampaign_api_url","","auto"),
("1120","elementor_pro_getresponse_api_key","","auto"),
("1121","elementor_pro_convertkit_api_key","","auto"),
("1122","elementor_pro_mailerlite_api_key","","auto"),
("1123","elementor_use_mini_cart_template","initial","auto"),
("1124","elementor_typekit-kit-id","","auto"),
("1126","elementor_pro_stripe_test_secret_key","","auto"),
("1127","elementor_validate_stripe_api_test_secret_key_button","","auto"),
("1128","elementor_pro_stripe_live_secret_key","","auto"),
("1129","elementor_validate_stripe_api_live_secret_key_button","","auto"),
("1130","elementor_stripe_legal_disclaimer","","auto"),
("1131","elementor_editor_break_lines","","auto"),
("1132","elementor_unfiltered_files_upload","1","auto"),
("1133","elementor_google_font","0","auto"),
("1134","elementor_form-submissions","1","auto"),
("1135","elementor_load_fa4_shim","","auto"),
("1136","elementor_meta_generator_tag","1","auto"),
("1137","elementor_css_print_method","external","auto"),
("1138","elementor_optimized_gutenberg_loading","1","auto"),
("1139","elementor_lazy_load_background_images","1","auto"),
("1140","elementor_local_google_fonts","0","auto"),
("1141","elementor_element_cache_ttl","24","auto"),
("1142","elementor_experiment-container","default","auto"),
("1143","elementor_experiment-mega-menu","default","auto"),
("1144","elementor_experiment-e_font_icon_svg","default","auto"),
("1145","elementor_experiment-additional_custom_breakpoints","default","auto"),
("1146","elementor_experiment-e_optimized_markup","default","auto"),
("1147","elementor_experiment-theme_builder_v2","default","auto"),
("1148","elementor_experiment-nested-elements","default","auto"),
("1152","elementor_log","a:9:{s:32:\"efc89fb2e9b52b175dc10819fca5d295\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2026-01-26 11:02:12\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:30:\"C.startsWith is not a function\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:6;s:14:\"\0*\0times_dates\";a:6:{i:0;s:19:\"2026-01-26 11:02:12\";i:1;s:19:\"2026-01-26 11:20:54\";i:2;s:19:\"2026-01-26 11:21:08\";i:3;s:19:\"2026-01-27 08:34:16\";i:4;s:19:\"2026-01-27 08:36:12\";i:5;s:19:\"2026-01-27 08:36:39\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1769425332\";s:7:\"message\";s:30:\"C.startsWith is not a function\";s:3:\"url\";s:103:\"https://staging.promarketing.gr/wp-content/plugins/elementor/assets/js/common-modules.min.js?ver=3.34.2\";s:4:\"line\";s:1:\"1\";s:6:\"column\";s:6:\"102999\";}s:7:\"\0*\0file\";s:103:\"https://staging.promarketing.gr/wp-content/plugins/elementor/assets/js/common-modules.min.js?ver=3.34.2\";s:7:\"\0*\0line\";s:1:\"1\";s:9:\"\0*\0column\";s:6:\"102999\";}s:32:\"e6e076c9d7c1040e07469a28b2906569\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2026-01-26 11:13:53\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:55:\"Cannot read properties of null (reading &#039;id&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-26 11:13:53\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1769426033\";s:7:\"message\";s:45:\"Cannot read properties of null (reading \'id\')\";s:3:\"url\";s:95:\"https://staging.promarketing.gr/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.34.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:7:\"1234456\";}s:7:\"\0*\0file\";s:95:\"https://staging.promarketing.gr/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.34.2\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:7:\"1234456\";}s:32:\"efc0188297abb9768f6d6b7303331288\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2026-01-26 11:33:05\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:20:\"Something went wrong\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2026-01-26 11:33:05\";i:1;s:19:\"2026-01-26 11:37:01\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1769427185\";s:7:\"message\";s:20:\"Something went wrong\";s:3:\"url\";s:120:\"https://staging.promarketing.gr/wp-content/plugins/jetformbuilder/assets/build/frontend/main.js?ver=a8ff8d24b43df9ed7e99\";s:4:\"line\";s:1:\"1\";s:6:\"column\";s:5:\"44130\";}s:7:\"\0*\0file\";s:120:\"https://staging.promarketing.gr/wp-content/plugins/jetformbuilder/assets/build/frontend/main.js?ver=a8ff8d24b43df9ed7e99\";s:7:\"\0*\0line\";s:1:\"1\";s:9:\"\0*\0column\";s:5:\"44130\";}s:32:\"762999aa7dcf476d8dde171e8d919c4f\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2026-01-27 11:03:25\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:669:\"Uncaught Error: Call to a member function get_gallery_image_ids() on bool in /home/stagingpromarket/public_html/wp-content/plugins/elementor/modules/ai/module.php:351\nStack trace:\n#0 /home/stagingpromarket/public_html/wp-includes/class-wp-hook.php(341): Elementor\\Modules\\Ai\\Module-&gt;get_product_images_ajax(&#039;&#039;)\n#1 /home/stagingpromarket/public_html/wp-includes/class-wp-hook.php(365): WP_Hook-&gt;apply_filters(&#039;&#039;, Array)\n#2 /home/stagingpromarket/public_html/wp-includes/plugin.php(522): WP_Hook-&gt;do_action(Array)\n#3 /home/stagingpromarket/public_html/wp-admin/admin-ajax.php(192): do_action(&#039;wp_ajax_element...&#039;)\n#4 {main}\n  thrown\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-27 11:03:25\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:5:\"error\";s:7:\"message\";s:630:\"Uncaught Error: Call to a member function get_gallery_image_ids() on bool in /home/stagingpromarket/public_html/wp-content/plugins/elementor/modules/ai/module.php:351\nStack trace:\n#0 /home/stagingpromarket/public_html/wp-includes/class-wp-hook.php(341): Elementor\\Modules\\Ai\\Module->get_product_images_ajax(\'\')\n#1 /home/stagingpromarket/public_html/wp-includes/class-wp-hook.php(365): WP_Hook->apply_filters(\'\', Array)\n#2 /home/stagingpromarket/public_html/wp-includes/plugin.php(522): WP_Hook->do_action(Array)\n#3 /home/stagingpromarket/public_html/wp-admin/admin-ajax.php(192): do_action(\'wp_ajax_element...\')\n#4 {main}\n  thrown\";s:4:\"file\";s:85:\"/home/stagingpromarket/public_html/wp-content/plugins/elementor/modules/ai/module.php\";s:4:\"line\";i:351;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:85:\"/home/stagingpromarket/public_html/wp-content/plugins/elementor/modules/ai/module.php\";s:7:\"\0*\0line\";i:351;}s:32:\"a9bd2378450607e2a35791038fb6135b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-27 14:49:28\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-27 14:49:28\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"0b8b2bccb2ae807e282430f2ba7f3794\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-27 14:49:28\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-27 14:49:28\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"acbd2974a61ad090887e33fa8b998d94\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-27 14:49:28\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-27 14:49:28\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"da06676a9b1f334d9ce0c502baed4697\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-27 14:49:29\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.34.2\";s:2:\"to\";s:6:\"3.34.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-27 14:49:29\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.34.2\";s:2:\"to\";s:6:\"3.34.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"11c07efa5b84839733e75f513c3c1ee6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-27 14:49:29\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.34.2\";s:2:\"to\";s:6:\"3.34.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-27 14:49:29\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.34.2\";s:2:\"to\";s:6:\"3.34.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}}","off"),
("1159","e_editor_counter","22","auto"),
("1160","_elementor_notifications_data","a:2:{s:7:\"timeout\";i:1769602166;s:5:\"value\";s:12018:\"[{\"id\":\"one-launch\",\"title\":\"Introducing Elementor One\",\"description\":\"The complete website building experience. All the tools to create, optimize, and manage websites, unified under one roof.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/one-launch.png\",\"chipTags\":[\"New Launch\"],\"cta\":\"Explore Elementor One\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/launch-whats-new\"},{\"id\":\"atomic-tabs-3.34\",\"title\":\"Atomic Tabs\",\"description\":\"Nest any type of content inside tab triggers or content panels, unlocking a truly atomic way of design.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/tabs-3.34.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.34-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"interactions-3.34\",\"title\":\"Entrance Interactions\",\"description\":\"Add subtle, performance\\u2011minded Fade, Scale or Slide effects to your elements from the new Interaction panel.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/interactions-3.34.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.34-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"variables-manager-3.33\",\"title\":\"Variables Manager\",\"description\":\"Centralize and control all your color, typography, and size tokens for consistent, scalable design systems.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-variables-manager.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"custom-css-3.33\",\"title\":\"Custom CSS\",\"description\":\"Write isolated, responsive, and state-based CSS directly inside atomic elements for pixel-perfect control.\",\"topic\":\"Elementor Pro 3.33\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-custom-css.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"custom-css-3.33\",\"title\":\"Custom CSS\",\"description\":\"Write isolated, responsive, and state-based CSS directly inside atomic elements for pixel-perfect control.\",\"topic\":\"Elementor Pro 3.33\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-custom-css.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-custom-css\\/\"},{\"id\":\"blend-mode-3.33\",\"title\":\"Blend Mode\",\"description\":\"Layer and blend visuals to create depth, contrast, and cinematic design effects.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-blend.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"transform-3.32\",\"title\":\"Design with depth using Transform\",\"description\":\"Move, scale, rotate, and skew any element with ease. Transform controls add depth, stacked effects, and seamless States for hover, focus, and active micro-interactions.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transform.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-size-variable\\/\"},{\"id\":\"transitions-3.32\",\"title\":\"Smooth interactions with Transitions\",\"description\":\"Bring polish to every interaction. Transitions let you animate style changes smoothly between states. In Pro, layer multiple transitions by property for refined, modern micro-animations.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transition.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"variables-3.31\",\"title\":\"Scalable design with Variables\",\"description\":\"Define once, reuse everywhere. Color & Font Variables help you build consistent, scalable design systems that update globally and are perfect for large sites or teams.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-variables.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"filters-3.31\",\"title\":\"Visual effects with Filters and Backdrop Filters\",\"description\":\"Apply multiple Filters like blur, brightness, and contrast. Stack, reorder, and preview in real time without writing a line of code.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-filters.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-assistant\",\"title\":\"New! Fix accessibility issues with Ally Assistant\",\"description\":\"Scan any page for accessibility issues and fix them in one click. From color contrast to missing alt text, Ally Assistant provides guided steps or AI-powered fixes to make your site more inclusive.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-assistant.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Scan for free\",\"ctaLink\":\"http:\\/\\/go.elementor.com\\/acc-assistant-launch-whats-new\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"classes-3.31\",\"title\":\"Smarter Class Manager tools\",\"description\":\"Quickly locate and manage Global Classes with usage counts, a new locator panel, and full class search. Perfect for scaling and refactoring complex design systems.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-attributes\\/\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}","off"),
("1163","elementor_fonts_manager_font_types","a:0:{}","auto"),
("1164","elementor_fonts_manager_fonts","a:0:{}","auto"),
("1165","elementor_custom_icon_sets_config","a:0:{}","auto"),
("1173","elementor_connect_site_key","5b2b87db912b8c73fcb29581a068205d","auto"),
("1174","elementor_remote_info_library","a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:823:{i:0;a:20:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:20:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:20:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:20:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:20:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:20:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:20:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:20:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:20:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:20:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:20:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:20:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:20:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:20:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:20:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:20:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:20:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:20:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:20:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:20:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:20:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:20:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:20:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:20:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:20:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:20:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:20:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:20:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:20:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:20:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:20:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:20:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:20:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:20:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:20:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:20:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:20:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:20:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:20:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:20:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:20:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:20:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:20:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:20:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:20:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:20:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:20:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:20:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:20:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:20:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:20:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:20:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:20:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:20:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:20:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:20:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:20:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:20:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:20:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:20:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:20:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:20:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl